# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList


class APIServiceCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["APIServiceCondition"]:
            return APIServiceCondition

        def build(self) -> "APIServiceCondition":
            return APIServiceCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "APIServiceCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "APIServiceCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            Last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            Human-readable message indicating details about last transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            Unique, one-word, CamelCase reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status is the status of the condition. Can be True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type is the type of the condition.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["APIServiceCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = APIServiceCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for APIServiceCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["APIServiceCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use APIServiceCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    Last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    Human-readable message indicating details about last transition.
    """
    reason: Optional[str] = None
    """
    Unique, one-word, CamelCase reason for the condition's last transition.
    """
    status: str
    """
    Status is the status of the condition. Can be True, False, Unknown.
    """
    type: str
    """
    Type is the type of the condition.
    """


class APIServiceStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["APIServiceStatus"]:
            return APIServiceStatus

        def build(self) -> "APIServiceStatus":
            return APIServiceStatus(**self._attrs)

        @overload
        def conditions(
            self, value_or_callback: List[APIServiceCondition], /
        ) -> "APIServiceStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[APIServiceCondition, APIServiceCondition.Builder]],
                GenericListBuilder[APIServiceCondition, APIServiceCondition.Builder]
                | List[APIServiceCondition],
            ],
            /,
        ) -> "APIServiceStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[APIServiceCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Current service state of apiService.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[APIServiceCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(APIServiceCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

    class BuilderContext(BuilderContextBase["APIServiceStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = APIServiceStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for APIServiceStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["APIServiceStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use APIServiceStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conditions: Optional[List[APIServiceCondition]] = None
    """
    Current service state of apiService.
    """


class ServiceReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServiceReference"]:
            return ServiceReference

        def build(self) -> "ServiceReference":
            return ServiceReference(**self._attrs)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name is the name of the service
            """
            return self._set("name", value)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            Namespace is the namespace of the service
            """
            return self._set("namespace", value)

        def port(self, value: Optional[int], /) -> Self:
            """
            If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).
            """
            return self._set("port", value)

    class BuilderContext(BuilderContextBase["ServiceReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServiceReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServiceReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServiceReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServiceReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: Optional[str] = None
    """
    Name is the name of the service
    """
    namespace: Optional[str] = None
    """
    Namespace is the namespace of the service
    """
    port: Optional[int] = None
    """
    If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).
    """


class APIServiceSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["APIServiceSpec"]:
            return APIServiceSpec

        def build(self) -> "APIServiceSpec":
            return APIServiceSpec(**self._attrs)

        def ca_bundle(self, value: Optional[str], /) -> Self:
            """
            CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.
            """
            return self._set("ca_bundle", value)

        def group(self, value: Optional[str], /) -> Self:
            """
            Group is the API group name this server hosts
            """
            return self._set("group", value)

        def group_priority_minimum(self, value: int, /) -> Self:
            """
            GroupPriorityMinimum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMinimum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s
            """
            return self._set("group_priority_minimum", value)

        def insecure_skip_tls_verify(self, value: Optional[bool], /) -> Self:
            """
            InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged.  You should use the CABundle instead.
            """
            return self._set("insecure_skip_tls_verify", value)

        @overload
        def service(
            self, value_or_callback: Optional[ServiceReference], /
        ) -> "APIServiceSpec.Builder": ...

        @overload
        def service(
            self,
            value_or_callback: Callable[
                [ServiceReference.Builder], ServiceReference.Builder | ServiceReference
            ],
            /,
        ) -> "APIServiceSpec.Builder": ...

        @overload
        def service(self, value_or_callback: Never = ...) -> "ServiceReference.BuilderContext": ...

        def service(self, value_or_callback=None, /):
            """
            Service is a reference to the service for this API server.  It must communicate on port 443. If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.
            """
            if self._in_context and value_or_callback is None:
                context = ServiceReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "service"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ServiceReference.builder())
                if isinstance(output, ServiceReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("service", value)

        def version(self, value: Optional[str], /) -> Self:
            """
            Version is the API version this server hosts.  For example, "v1"
            """
            return self._set("version", value)

        def version_priority(self, value: int, /) -> Self:
            """
            VersionPriority controls the ordering of this API version inside of its group.  Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
            """
            return self._set("version_priority", value)

    class BuilderContext(BuilderContextBase["APIServiceSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = APIServiceSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for APIServiceSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["APIServiceSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use APIServiceSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    ca_bundle: Annotated[Optional[str], Field(alias="caBundle")] = None
    """
    CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.
    """
    group: Optional[str] = None
    """
    Group is the API group name this server hosts
    """
    group_priority_minimum: Annotated[int, Field(alias="groupPriorityMinimum")]
    """
    GroupPriorityMinimum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMinimum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s
    """
    insecure_skip_tls_verify: Annotated[Optional[bool], Field(alias="insecureSkipTLSVerify")] = None
    """
    InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged.  You should use the CABundle instead.
    """
    service: Optional[ServiceReference] = None
    """
    Service is a reference to the service for this API server.  It must communicate on port 443. If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.
    """
    version: Optional[str] = None
    """
    Version is the API version this server hosts.  For example, "v1"
    """
    version_priority: Annotated[int, Field(alias="versionPriority")]
    """
    VersionPriority controls the ordering of this API version inside of its group.  Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
    """


class APIService(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["APIService"]:
            return APIService

        def build(self) -> "APIService":
            return APIService(**self._attrs)

        def api_version(self, value: Optional[Literal["apiregistration.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["APIService"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "APIService.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "APIService.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[APIServiceSpec], /) -> "APIService.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [APIServiceSpec.Builder], APIServiceSpec.Builder | APIServiceSpec
            ],
            /,
        ) -> "APIService.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "APIServiceSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec contains information for locating and communicating with a server
            """
            if self._in_context and value_or_callback is None:
                context = APIServiceSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(APIServiceSpec.builder())
                if isinstance(output, APIServiceSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[APIServiceStatus], /
        ) -> "APIService.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [APIServiceStatus.Builder], APIServiceStatus.Builder | APIServiceStatus
            ],
            /,
        ) -> "APIService.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "APIServiceStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status contains derived information about an API server
            """
            if self._in_context and value_or_callback is None:
                context = APIServiceStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(APIServiceStatus.builder())
                if isinstance(output, APIServiceStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["APIService.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = APIService.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for APIService."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["APIService", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use APIService.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["apiregistration.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "apiregistration.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["APIService"]] = "APIService"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[APIServiceSpec] = None
    """
    Spec contains information for locating and communicating with a server
    """
    status: Optional[APIServiceStatus] = None
    """
    Status contains derived information about an API server
    """


APIServiceList = ResourceList["APIService"]
