# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Any,
    Callable,
    Dict,
    List,
    Literal,
    Optional,
    Type,
    cast,
    overload,
)

from pydantic import Field, RootModel

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseBuilder,
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList


class CustomResourceColumnDefinition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceColumnDefinition"]:
            return CustomResourceColumnDefinition

        def build(self) -> "CustomResourceColumnDefinition":
            return CustomResourceColumnDefinition(**self._attrs)

        def description(self, value: Optional[str], /) -> Self:
            """
            description is a human readable description of this column.
            """
            return self._set("description", value)

        def format(self, value: Optional[str], /) -> Self:
            """
            format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
            """
            return self._set("format", value)

        def json_path(self, value: str, /) -> Self:
            """
            jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
            """
            return self._set("json_path", value)

        def name(self, value: str, /) -> Self:
            """
            name is a human readable name for the column.
            """
            return self._set("name", value)

        def priority(self, value: Optional[int], /) -> Self:
            """
            priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
            """
            return self._set("priority", value)

        def type(self, value: str, /) -> Self:
            """
            type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["CustomResourceColumnDefinition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceColumnDefinition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceColumnDefinition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceColumnDefinition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceColumnDefinition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    description: Optional[str] = None
    """
    description is a human readable description of this column.
    """
    format: Optional[str] = None
    """
    format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
    """
    json_path: Annotated[str, Field(alias="jsonPath")]
    """
    jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
    """
    name: str
    """
    name is a human readable name for the column.
    """
    priority: Optional[int] = None
    """
    priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
    """
    type: str
    """
    type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
    """


class CustomResourceDefinitionNames(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceDefinitionNames"]:
            return CustomResourceDefinitionNames

        def build(self) -> "CustomResourceDefinitionNames":
            return CustomResourceDefinitionNames(**self._attrs)

        def categories(self, value: Optional[List[str]], /) -> Self:
            """
            categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
            """
            return self._set("categories", value)

        def kind(self, value: str, /) -> Self:
            """
            kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
            """
            return self._set("kind", value)

        def list_kind(self, value: Optional[str], /) -> Self:
            """
            listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
            """
            return self._set("list_kind", value)

        def plural(self, value: str, /) -> Self:
            """
            plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
            """
            return self._set("plural", value)

        def short_names(self, value: Optional[List[str]], /) -> Self:
            """
            shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
            """
            return self._set("short_names", value)

        def singular(self, value: Optional[str], /) -> Self:
            """
            singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
            """
            return self._set("singular", value)

    class BuilderContext(BuilderContextBase["CustomResourceDefinitionNames.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceDefinitionNames.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceDefinitionNames."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceDefinitionNames", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceDefinitionNames.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    categories: Optional[List[str]] = None
    """
    categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
    """
    kind: str
    """
    kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
    """
    list_kind: Annotated[Optional[str], Field(alias="listKind")] = None
    """
    listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
    """
    plural: str
    """
    plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
    """
    short_names: Annotated[Optional[List[str]], Field(alias="shortNames")] = None
    """
    shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
    """
    singular: Optional[str] = None
    """
    singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
    """


class CustomResourceSubresourceScale(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceSubresourceScale"]:
            return CustomResourceSubresourceScale

        def build(self) -> "CustomResourceSubresourceScale":
            return CustomResourceSubresourceScale(**self._attrs)

        def label_selector_path(self, value: Optional[str], /) -> Self:
            """
            labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
            """
            return self._set("label_selector_path", value)

        def spec_replicas_path(self, value: str, /) -> Self:
            """
            specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
            """
            return self._set("spec_replicas_path", value)

        def status_replicas_path(self, value: str, /) -> Self:
            """
            statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
            """
            return self._set("status_replicas_path", value)

    class BuilderContext(BuilderContextBase["CustomResourceSubresourceScale.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceSubresourceScale.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceSubresourceScale."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceSubresourceScale", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceSubresourceScale.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    label_selector_path: Annotated[Optional[str], Field(alias="labelSelectorPath")] = None
    """
    labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
    """
    spec_replicas_path: Annotated[str, Field(alias="specReplicasPath")]
    """
    specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
    """
    status_replicas_path: Annotated[str, Field(alias="statusReplicasPath")]
    """
    statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
    """


class CustomResourceSubresourceStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceSubresourceStatus"]:
            return CustomResourceSubresourceStatus

        def build(self) -> "CustomResourceSubresourceStatus":
            return CustomResourceSubresourceStatus(**self._attrs)

    class BuilderContext(BuilderContextBase["CustomResourceSubresourceStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceSubresourceStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceSubresourceStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceSubresourceStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceSubresourceStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    pass


class CustomResourceSubresources(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceSubresources"]:
            return CustomResourceSubresources

        def build(self) -> "CustomResourceSubresources":
            return CustomResourceSubresources(**self._attrs)

        @overload
        def scale(
            self, value_or_callback: Optional[CustomResourceSubresourceScale], /
        ) -> "CustomResourceSubresources.Builder": ...

        @overload
        def scale(
            self,
            value_or_callback: Callable[
                [CustomResourceSubresourceScale.Builder],
                CustomResourceSubresourceScale.Builder | CustomResourceSubresourceScale,
            ],
            /,
        ) -> "CustomResourceSubresources.Builder": ...

        @overload
        def scale(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceSubresourceScale.BuilderContext": ...

        def scale(self, value_or_callback=None, /):
            """
            scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceSubresourceScale.BuilderContext()
                context._parent_builder = self
                context._field_name = "scale"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceSubresourceScale.builder())
                if isinstance(output, CustomResourceSubresourceScale.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("scale", value)

        @overload
        def status(
            self, value_or_callback: Optional[CustomResourceSubresourceStatus], /
        ) -> "CustomResourceSubresources.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [CustomResourceSubresourceStatus.Builder],
                CustomResourceSubresourceStatus.Builder | CustomResourceSubresourceStatus,
            ],
            /,
        ) -> "CustomResourceSubresources.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceSubresourceStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceSubresourceStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceSubresourceStatus.builder())
                if isinstance(output, CustomResourceSubresourceStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["CustomResourceSubresources.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceSubresources.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceSubresources."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceSubresources", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceSubresources.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    scale: Optional[CustomResourceSubresourceScale] = None
    """
    scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
    """
    status: Optional[CustomResourceSubresourceStatus] = None
    """
    status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
    """


class ExternalDocumentation(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ExternalDocumentation"]:
            return ExternalDocumentation

        def build(self) -> "ExternalDocumentation":
            return ExternalDocumentation(**self._attrs)

        def description(self, value: Optional[str], /) -> Self:
            return self._set("description", value)

        def url(self, value: Optional[str], /) -> Self:
            return self._set("url", value)

    class BuilderContext(BuilderContextBase["ExternalDocumentation.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ExternalDocumentation.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ExternalDocumentation."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ExternalDocumentation", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ExternalDocumentation.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    description: Optional[str] = None
    url: Optional[str] = None


class JSON(RootModel[Any]):
    class Builder(BaseBuilder):
        _value: Any | None = None

        def root(self, value: Any, /) -> Self:
            """
            JSON represents any valid JSON value. These types are supported: bool, int64, float64, string, []interface{}, map[string]interface{} and nil.
            """
            self._value = value
            return self

        def __call__(self, value: Any, /) -> Self:
            """
            JSON represents any valid JSON value. These types are supported: bool, int64, float64, string, []interface{}, map[string]interface{} and nil.
            """
            self._value = value
            return self

        def build(self) -> "JSON":
            value = cast(Any, self._value)
            return JSON(value)

    root: Any
    """
    JSON represents any valid JSON value. These types are supported: bool, int64, float64, string, []interface{}, map[string]interface{} and nil.
    """

    class BuilderContext(BuilderContextBase["JSON.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JSON.Builder()
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JSON."""
        return cls.BuilderContext()


class JSONSchemaPropsOrArray(RootModel[Any]):
    class Builder(BaseBuilder):
        _value: Any | None = None

        def root(self, value: Any, /) -> Self:
            """
            JSONSchemaPropsOrArray represents a value that can either be a JSONSchemaProps or an array of JSONSchemaProps. Mainly here for serialization purposes.
            """
            self._value = value
            return self

        def __call__(self, value: Any, /) -> Self:
            """
            JSONSchemaPropsOrArray represents a value that can either be a JSONSchemaProps or an array of JSONSchemaProps. Mainly here for serialization purposes.
            """
            self._value = value
            return self

        def build(self) -> "JSONSchemaPropsOrArray":
            value = cast(Any, self._value)
            return JSONSchemaPropsOrArray(value)

    root: Any
    """
    JSONSchemaPropsOrArray represents a value that can either be a JSONSchemaProps or an array of JSONSchemaProps. Mainly here for serialization purposes.
    """

    class BuilderContext(BuilderContextBase["JSONSchemaPropsOrArray.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JSONSchemaPropsOrArray.Builder()
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JSONSchemaPropsOrArray."""
        return cls.BuilderContext()


class JSONSchemaPropsOrBool(RootModel[Any]):
    class Builder(BaseBuilder):
        _value: Any | None = None

        def root(self, value: Any, /) -> Self:
            """
            JSONSchemaPropsOrBool represents JSONSchemaProps or a boolean value. Defaults to true for the boolean property.
            """
            self._value = value
            return self

        def __call__(self, value: Any, /) -> Self:
            """
            JSONSchemaPropsOrBool represents JSONSchemaProps or a boolean value. Defaults to true for the boolean property.
            """
            self._value = value
            return self

        def build(self) -> "JSONSchemaPropsOrBool":
            value = cast(Any, self._value)
            return JSONSchemaPropsOrBool(value)

    root: Any
    """
    JSONSchemaPropsOrBool represents JSONSchemaProps or a boolean value. Defaults to true for the boolean property.
    """

    class BuilderContext(BuilderContextBase["JSONSchemaPropsOrBool.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JSONSchemaPropsOrBool.Builder()
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JSONSchemaPropsOrBool."""
        return cls.BuilderContext()


class JSONSchemaPropsOrStringArray(RootModel[Any]):
    class Builder(BaseBuilder):
        _value: Any | None = None

        def root(self, value: Any, /) -> Self:
            """
            JSONSchemaPropsOrStringArray represents a JSONSchemaProps or a string array.
            """
            self._value = value
            return self

        def __call__(self, value: Any, /) -> Self:
            """
            JSONSchemaPropsOrStringArray represents a JSONSchemaProps or a string array.
            """
            self._value = value
            return self

        def build(self) -> "JSONSchemaPropsOrStringArray":
            value = cast(Any, self._value)
            return JSONSchemaPropsOrStringArray(value)

    root: Any
    """
    JSONSchemaPropsOrStringArray represents a JSONSchemaProps or a string array.
    """

    class BuilderContext(BuilderContextBase["JSONSchemaPropsOrStringArray.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JSONSchemaPropsOrStringArray.Builder()
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JSONSchemaPropsOrStringArray."""
        return cls.BuilderContext()


class SelectableField(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SelectableField"]:
            return SelectableField

        def build(self) -> "SelectableField":
            return SelectableField(**self._attrs)

        def json_path(self, value: str, /) -> Self:
            """
            jsonPath is a simple JSON path which is evaluated against each custom resource to produce a field selector value. Only JSON paths without the array notation are allowed. Must point to a field of type string, boolean or integer. Types with enum values and strings with formats are allowed. If jsonPath refers to absent field in a resource, the jsonPath evaluates to an empty string. Must not point to metdata fields. Required.
            """
            return self._set("json_path", value)

    class BuilderContext(BuilderContextBase["SelectableField.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SelectableField.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SelectableField."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SelectableField", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SelectableField.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    json_path: Annotated[str, Field(alias="jsonPath")]
    """
    jsonPath is a simple JSON path which is evaluated against each custom resource to produce a field selector value. Only JSON paths without the array notation are allowed. Must point to a field of type string, boolean or integer. Types with enum values and strings with formats are allowed. If jsonPath refers to absent field in a resource, the jsonPath evaluates to an empty string. Must not point to metdata fields. Required.
    """


class ServiceReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServiceReference"]:
            return ServiceReference

        def build(self) -> "ServiceReference":
            return ServiceReference(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            name is the name of the service. Required
            """
            return self._set("name", value)

        def namespace(self, value: str, /) -> Self:
            """
            namespace is the namespace of the service. Required
            """
            return self._set("namespace", value)

        def path(self, value: Optional[str], /) -> Self:
            """
            path is an optional URL path at which the webhook will be contacted.
            """
            return self._set("path", value)

        def port(self, value: Optional[int], /) -> Self:
            """
            port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
            """
            return self._set("port", value)

    class BuilderContext(BuilderContextBase["ServiceReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServiceReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServiceReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServiceReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServiceReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    name is the name of the service. Required
    """
    namespace: str
    """
    namespace is the namespace of the service. Required
    """
    path: Optional[str] = None
    """
    path is an optional URL path at which the webhook will be contacted.
    """
    port: Optional[int] = None
    """
    port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
    """


class ValidationRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ValidationRule"]:
            return ValidationRule

        def build(self) -> "ValidationRule":
            return ValidationRule(**self._attrs)

        def field_path(self, value: Optional[str], /) -> Self:
            """
            fieldPath represents the field path returned when the validation fails. It must be a relative JSON path (i.e. with array notation) scoped to the location of this x-kubernetes-validations extension in the schema and refer to an existing field. e.g. when validation checks if a specific attribute `foo` under a map `testMap`, the fieldPath could be set to `.testMap.foo` If the validation checks two lists must have unique attributes, the fieldPath could be set to either of the list: e.g. `.testList` It does not support list numeric index. It supports child operation to refer to an existing field currently. Refer to [JSONPath support in Kubernetes](https://kubernetes.io/docs/reference/kubectl/jsonpath/) for more info. Numeric index of array is not supported. For field name which contains special characters, use `['specialName']` to refer the field name. e.g. for attribute `foo.34$` appears in a list `testList`, the fieldPath could be set to `.testList['foo.34$']`
            """
            return self._set("field_path", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            Message represents the message displayed when validation fails. The message is required if the Rule contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host"
            """
            return self._set("message", value)

        def message_expression(self, value: Optional[str], /) -> Self:
            """
            MessageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a rule, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the rule; the only difference is the return type. Example: "x must be less than max ("+string(self.max)+")"
            """
            return self._set("message_expression", value)

        def optional_old_self(self, value: Optional[bool], /) -> Self:
            """
            optionalOldSelf is used to opt a transition rule into evaluation even when the object is first created, or if the old object is missing the value.

            When enabled `oldSelf` will be a CEL optional whose value will be `None` if there is no old value, or when the object is initially created.

            You may check for presence of oldSelf using `oldSelf.hasValue()` and unwrap it after checking using `oldSelf.value()`. Check the CEL documentation for Optional types for more information: https://pkg.go.dev/github.com/google/cel-go/cel#OptionalTypes

            May not be set unless `oldSelf` is used in `rule`.
            """
            return self._set("optional_old_self", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            reason provides a machine-readable validation failure reason that is returned to the caller when a request fails this validation rule. The HTTP status code returned to the caller will match the reason of the reason of the first failed validation rule. The currently supported reasons are: "FieldValueInvalid", "FieldValueForbidden", "FieldValueRequired", "FieldValueDuplicate". If not set, default to use "FieldValueInvalid". All future added reasons must be accepted by clients when reading this value and unknown reasons should be treated as FieldValueInvalid.
            """
            return self._set("reason", value)

        def rule(self, value: str, /) -> Self:
            """
            Rule represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec The Rule is scoped to the location of the x-kubernetes-validations extension in the schema. The `self` variable in the CEL expression is bound to the scoped value. Example: - Rule scoped to the root of a resource with a status subresource: {"rule": "self.status.actual <= self.spec.maxDesired"}

            If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable via `self.field` and field presence can be checked via `has(self.field)`. Null valued fields are treated as absent fields in CEL expressions. If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map are accessible via `self[mapKey]`, map containment can be checked via `mapKey in self` and all entries of the map are accessible via CEL macros and functions such as `self.all(...)`. If the Rule is scoped to an array, the elements of the array are accessible via `self[i]` and also by macros and functions. If the Rule is scoped to a scalar, `self` is bound to the scalar value. Examples: - Rule scoped to a map of objects: {"rule": "self.components['Widget'].priority < 10"} - Rule scoped to a list of integers: {"rule": "self.values.all(value, value >= 0 && value < 100)"} - Rule scoped to a string value: {"rule": "self.startsWith('kube')"}

            The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.

            Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL expressions. This includes: - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields. - Object properties where the property schema is of an "unknown type". An "unknown type" is recursively defined as:
              - A schema with no type and x-kubernetes-preserve-unknown-fields set to true
              - An array where the items schema is of an "unknown type"
              - An object where the additionalProperties schema is of an "unknown type"

            Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
                  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
                  "import", "let", "loop", "package", "namespace", "return".
            Examples:
              - Rule accessing a property named "namespace": {"rule": "self.__namespace__ > 0"}
              - Rule accessing a property named "x-prop": {"rule": "self.x__dash__prop > 0"}
              - Rule accessing a property named "redact__d": {"rule": "self.redact__underscores__d > 0"}

            Equality on arrays with x-kubernetes-list-type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
              - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
                non-intersecting elements in `Y` are appended, retaining their partial order.
              - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
                are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
                non-intersecting keys are appended, retaining their partial order.

            If `rule` makes use of the `oldSelf` variable it is implicitly a `transition rule`.

            By default, the `oldSelf` variable is the same type as `self`. When `optionalOldSelf` is true, the `oldSelf` variable is a CEL optional
             variable whose value() is the same type as `self`.
            See the documentation for the `optionalOldSelf` field for details.

            Transition rules by default are applied only on UPDATE requests and are skipped if an old value could not be found. You can opt a transition rule into unconditional evaluation by setting `optionalOldSelf` to true.
            """
            return self._set("rule", value)

    class BuilderContext(BuilderContextBase["ValidationRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ValidationRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ValidationRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ValidationRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ValidationRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    field_path: Annotated[Optional[str], Field(alias="fieldPath")] = None
    """
    fieldPath represents the field path returned when the validation fails. It must be a relative JSON path (i.e. with array notation) scoped to the location of this x-kubernetes-validations extension in the schema and refer to an existing field. e.g. when validation checks if a specific attribute `foo` under a map `testMap`, the fieldPath could be set to `.testMap.foo` If the validation checks two lists must have unique attributes, the fieldPath could be set to either of the list: e.g. `.testList` It does not support list numeric index. It supports child operation to refer to an existing field currently. Refer to [JSONPath support in Kubernetes](https://kubernetes.io/docs/reference/kubectl/jsonpath/) for more info. Numeric index of array is not supported. For field name which contains special characters, use `['specialName']` to refer the field name. e.g. for attribute `foo.34$` appears in a list `testList`, the fieldPath could be set to `.testList['foo.34$']`
    """
    message: Optional[str] = None
    """
    Message represents the message displayed when validation fails. The message is required if the Rule contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host"
    """
    message_expression: Annotated[Optional[str], Field(alias="messageExpression")] = None
    """
    MessageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a rule, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the rule; the only difference is the return type. Example: "x must be less than max ("+string(self.max)+")"
    """
    optional_old_self: Annotated[Optional[bool], Field(alias="optionalOldSelf")] = None
    """
    optionalOldSelf is used to opt a transition rule into evaluation even when the object is first created, or if the old object is missing the value.

    When enabled `oldSelf` will be a CEL optional whose value will be `None` if there is no old value, or when the object is initially created.

    You may check for presence of oldSelf using `oldSelf.hasValue()` and unwrap it after checking using `oldSelf.value()`. Check the CEL documentation for Optional types for more information: https://pkg.go.dev/github.com/google/cel-go/cel#OptionalTypes

    May not be set unless `oldSelf` is used in `rule`.
    """
    reason: Optional[str] = None
    """
    reason provides a machine-readable validation failure reason that is returned to the caller when a request fails this validation rule. The HTTP status code returned to the caller will match the reason of the reason of the first failed validation rule. The currently supported reasons are: "FieldValueInvalid", "FieldValueForbidden", "FieldValueRequired", "FieldValueDuplicate". If not set, default to use "FieldValueInvalid". All future added reasons must be accepted by clients when reading this value and unknown reasons should be treated as FieldValueInvalid.
    """
    rule: str
    """
    Rule represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec The Rule is scoped to the location of the x-kubernetes-validations extension in the schema. The `self` variable in the CEL expression is bound to the scoped value. Example: - Rule scoped to the root of a resource with a status subresource: {"rule": "self.status.actual <= self.spec.maxDesired"}

    If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable via `self.field` and field presence can be checked via `has(self.field)`. Null valued fields are treated as absent fields in CEL expressions. If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map are accessible via `self[mapKey]`, map containment can be checked via `mapKey in self` and all entries of the map are accessible via CEL macros and functions such as `self.all(...)`. If the Rule is scoped to an array, the elements of the array are accessible via `self[i]` and also by macros and functions. If the Rule is scoped to a scalar, `self` is bound to the scalar value. Examples: - Rule scoped to a map of objects: {"rule": "self.components['Widget'].priority < 10"} - Rule scoped to a list of integers: {"rule": "self.values.all(value, value >= 0 && value < 100)"} - Rule scoped to a string value: {"rule": "self.startsWith('kube')"}

    The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.

    Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL expressions. This includes: - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields. - Object properties where the property schema is of an "unknown type". An "unknown type" is recursively defined as:
      - A schema with no type and x-kubernetes-preserve-unknown-fields set to true
      - An array where the items schema is of an "unknown type"
      - An object where the additionalProperties schema is of an "unknown type"

    Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
          "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
          "import", "let", "loop", "package", "namespace", "return".
    Examples:
      - Rule accessing a property named "namespace": {"rule": "self.__namespace__ > 0"}
      - Rule accessing a property named "x-prop": {"rule": "self.x__dash__prop > 0"}
      - Rule accessing a property named "redact__d": {"rule": "self.redact__underscores__d > 0"}

    Equality on arrays with x-kubernetes-list-type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
      - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
        non-intersecting elements in `Y` are appended, retaining their partial order.
      - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
        are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
        non-intersecting keys are appended, retaining their partial order.

    If `rule` makes use of the `oldSelf` variable it is implicitly a `transition rule`.

    By default, the `oldSelf` variable is the same type as `self`. When `optionalOldSelf` is true, the `oldSelf` variable is a CEL optional
     variable whose value() is the same type as `self`.
    See the documentation for the `optionalOldSelf` field for details.

    Transition rules by default are applied only on UPDATE requests and are skipped if an old value could not be found. You can opt a transition rule into unconditional evaluation by setting `optionalOldSelf` to true.
    """


class WebhookClientConfig(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["WebhookClientConfig"]:
            return WebhookClientConfig

        def build(self) -> "WebhookClientConfig":
            return WebhookClientConfig(**self._attrs)

        def ca_bundle(self, value: Optional[str], /) -> Self:
            """
            caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
            """
            return self._set("ca_bundle", value)

        @overload
        def service(
            self, value_or_callback: Optional[ServiceReference], /
        ) -> "WebhookClientConfig.Builder": ...

        @overload
        def service(
            self,
            value_or_callback: Callable[
                [ServiceReference.Builder], ServiceReference.Builder | ServiceReference
            ],
            /,
        ) -> "WebhookClientConfig.Builder": ...

        @overload
        def service(self, value_or_callback: Never = ...) -> "ServiceReference.BuilderContext": ...

        def service(self, value_or_callback=None, /):
            """
            service is a reference to the service for this webhook. Either service or url must be specified.

            If the webhook is running within the cluster, then you should use `service`.
            """
            if self._in_context and value_or_callback is None:
                context = ServiceReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "service"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ServiceReference.builder())
                if isinstance(output, ServiceReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("service", value)

        def url(self, value: Optional[str], /) -> Self:
            """
            url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.

            The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.

            Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.

            The scheme must be "https"; the URL must begin with "https://".

            A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.

            Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
            """
            return self._set("url", value)

    class BuilderContext(BuilderContextBase["WebhookClientConfig.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = WebhookClientConfig.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for WebhookClientConfig."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["WebhookClientConfig", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use WebhookClientConfig.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    ca_bundle: Annotated[Optional[str], Field(alias="caBundle")] = None
    """
    caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
    """
    service: Optional[ServiceReference] = None
    """
    service is a reference to the service for this webhook. Either service or url must be specified.

    If the webhook is running within the cluster, then you should use `service`.
    """
    url: Optional[str] = None
    """
    url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.

    The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.

    Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.

    The scheme must be "https"; the URL must begin with "https://".

    A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.

    Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
    """


class WebhookConversion(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["WebhookConversion"]:
            return WebhookConversion

        def build(self) -> "WebhookConversion":
            return WebhookConversion(**self._attrs)

        @overload
        def client_config(
            self, value_or_callback: Optional[WebhookClientConfig], /
        ) -> "WebhookConversion.Builder": ...

        @overload
        def client_config(
            self,
            value_or_callback: Callable[
                [WebhookClientConfig.Builder],
                WebhookClientConfig.Builder | WebhookClientConfig,
            ],
            /,
        ) -> "WebhookConversion.Builder": ...

        @overload
        def client_config(
            self, value_or_callback: Never = ...
        ) -> "WebhookClientConfig.BuilderContext": ...

        def client_config(self, value_or_callback=None, /):
            """
            clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
            """
            if self._in_context and value_or_callback is None:
                context = WebhookClientConfig.BuilderContext()
                context._parent_builder = self
                context._field_name = "client_config"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(WebhookClientConfig.builder())
                if isinstance(output, WebhookClientConfig.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("client_config", value)

        def conversion_review_versions(self, value: List[str], /) -> Self:
            """
            conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
            """
            return self._set("conversion_review_versions", value)

    class BuilderContext(BuilderContextBase["WebhookConversion.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = WebhookConversion.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for WebhookConversion."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["WebhookConversion", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use WebhookConversion.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    client_config: Annotated[Optional[WebhookClientConfig], Field(alias="clientConfig")] = None
    """
    clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
    """
    conversion_review_versions: Annotated[List[str], Field(alias="conversionReviewVersions")]
    """
    conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
    """


class CustomResourceConversion(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceConversion"]:
            return CustomResourceConversion

        def build(self) -> "CustomResourceConversion":
            return CustomResourceConversion(**self._attrs)

        def strategy(self, value: str, /) -> Self:
            """
            strategy specifies how custom resources are converted between versions. Allowed values are: - `"None"`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
              is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
            """
            return self._set("strategy", value)

        @overload
        def webhook(
            self, value_or_callback: Optional[WebhookConversion], /
        ) -> "CustomResourceConversion.Builder": ...

        @overload
        def webhook(
            self,
            value_or_callback: Callable[
                [WebhookConversion.Builder],
                WebhookConversion.Builder | WebhookConversion,
            ],
            /,
        ) -> "CustomResourceConversion.Builder": ...

        @overload
        def webhook(self, value_or_callback: Never = ...) -> "WebhookConversion.BuilderContext": ...

        def webhook(self, value_or_callback=None, /):
            """
            webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
            """
            if self._in_context and value_or_callback is None:
                context = WebhookConversion.BuilderContext()
                context._parent_builder = self
                context._field_name = "webhook"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(WebhookConversion.builder())
                if isinstance(output, WebhookConversion.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("webhook", value)

    class BuilderContext(BuilderContextBase["CustomResourceConversion.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceConversion.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceConversion."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceConversion", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceConversion.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    strategy: str
    """
    strategy specifies how custom resources are converted between versions. Allowed values are: - `"None"`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
      is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
    """
    webhook: Optional[WebhookConversion] = None
    """
    webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
    """


class CustomResourceDefinitionCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceDefinitionCondition"]:
            return CustomResourceDefinitionCondition

        def build(self) -> "CustomResourceDefinitionCondition":
            return CustomResourceDefinitionCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "CustomResourceDefinitionCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "CustomResourceDefinitionCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            lastTransitionTime last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            message is a human-readable message indicating details about last transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            reason is a unique, one-word, CamelCase reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            status is the status of the condition. Can be True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            type is the type of the condition. Types include Established, NamesAccepted and Terminating.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["CustomResourceDefinitionCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceDefinitionCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceDefinitionCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceDefinitionCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceDefinitionCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    lastTransitionTime last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    message is a human-readable message indicating details about last transition.
    """
    reason: Optional[str] = None
    """
    reason is a unique, one-word, CamelCase reason for the condition's last transition.
    """
    status: str
    """
    status is the status of the condition. Can be True, False, Unknown.
    """
    type: str
    """
    type is the type of the condition. Types include Established, NamesAccepted and Terminating.
    """


class CustomResourceDefinitionStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceDefinitionStatus"]:
            return CustomResourceDefinitionStatus

        def build(self) -> "CustomResourceDefinitionStatus":
            return CustomResourceDefinitionStatus(**self._attrs)

        @overload
        def accepted_names(
            self, value_or_callback: Optional[CustomResourceDefinitionNames], /
        ) -> "CustomResourceDefinitionStatus.Builder": ...

        @overload
        def accepted_names(
            self,
            value_or_callback: Callable[
                [CustomResourceDefinitionNames.Builder],
                CustomResourceDefinitionNames.Builder | CustomResourceDefinitionNames,
            ],
            /,
        ) -> "CustomResourceDefinitionStatus.Builder": ...

        @overload
        def accepted_names(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceDefinitionNames.BuilderContext": ...

        def accepted_names(self, value_or_callback=None, /):
            """
            acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceDefinitionNames.BuilderContext()
                context._parent_builder = self
                context._field_name = "accepted_names"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceDefinitionNames.builder())
                if isinstance(output, CustomResourceDefinitionNames.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("accepted_names", value)

        @overload
        def conditions(
            self, value_or_callback: List[CustomResourceDefinitionCondition], /
        ) -> "CustomResourceDefinitionStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        CustomResourceDefinitionCondition,
                        CustomResourceDefinitionCondition.Builder,
                    ]
                ],
                GenericListBuilder[
                    CustomResourceDefinitionCondition,
                    CustomResourceDefinitionCondition.Builder,
                ]
                | List[CustomResourceDefinitionCondition],
            ],
            /,
        ) -> "CustomResourceDefinitionStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[CustomResourceDefinitionCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            conditions indicate state for particular aspects of a CustomResourceDefinition
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[CustomResourceDefinitionCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceDefinitionCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def stored_versions(self, value: Optional[List[str]], /) -> Self:
            """
            storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
            """
            return self._set("stored_versions", value)

    class BuilderContext(BuilderContextBase["CustomResourceDefinitionStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceDefinitionStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceDefinitionStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceDefinitionStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceDefinitionStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    accepted_names: Annotated[
        Optional[CustomResourceDefinitionNames], Field(alias="acceptedNames")
    ] = None
    """
    acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
    """
    conditions: Optional[List[CustomResourceDefinitionCondition]] = None
    """
    conditions indicate state for particular aspects of a CustomResourceDefinition
    """
    stored_versions: Annotated[Optional[List[str]], Field(alias="storedVersions")] = None
    """
    storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
    """


class JSONSchemaProps(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["JSONSchemaProps"]:
            return JSONSchemaProps

        def build(self) -> "JSONSchemaProps":
            return JSONSchemaProps(**self._attrs)

        def field_ref(self, value: Optional[str], /) -> Self:
            return self._set("field_ref", value)

        def field_schema(self, value: Optional[str], /) -> Self:
            return self._set("field_schema", value)

        @overload
        def additional_items(
            self, value_or_callback: Optional[JSONSchemaPropsOrBool], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def additional_items(
            self,
            value_or_callback: Callable[
                [JSONSchemaPropsOrBool.Builder],
                JSONSchemaPropsOrBool.Builder | JSONSchemaPropsOrBool,
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def additional_items(
            self, value_or_callback: Never = ...
        ) -> "JSONSchemaPropsOrBool.BuilderContext": ...

        def additional_items(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = JSONSchemaPropsOrBool.BuilderContext()
                context._parent_builder = self
                context._field_name = "additional_items"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSONSchemaPropsOrBool.builder())
                if isinstance(output, JSONSchemaPropsOrBool.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("additional_items", value)

        @overload
        def additional_properties(
            self, value_or_callback: Optional[JSONSchemaPropsOrBool], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def additional_properties(
            self,
            value_or_callback: Callable[
                [JSONSchemaPropsOrBool.Builder],
                JSONSchemaPropsOrBool.Builder | JSONSchemaPropsOrBool,
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def additional_properties(
            self, value_or_callback: Never = ...
        ) -> "JSONSchemaPropsOrBool.BuilderContext": ...

        def additional_properties(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = JSONSchemaPropsOrBool.BuilderContext()
                context._parent_builder = self
                context._field_name = "additional_properties"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSONSchemaPropsOrBool.builder())
                if isinstance(output, JSONSchemaPropsOrBool.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("additional_properties", value)

        @overload
        def all_of(
            self, value_or_callback: List[JSONSchemaProps], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def all_of(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[JSONSchemaProps, JSONSchemaProps.Builder]],
                GenericListBuilder[JSONSchemaProps, JSONSchemaProps.Builder]
                | List[JSONSchemaProps],
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def all_of(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[JSONSchemaProps.Builder]: ...

        def all_of(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[JSONSchemaProps.Builder]()
                context._parent_builder = self
                context._field_name = "all_of"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSONSchemaProps.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("all_of", value)

        @overload
        def any_of(
            self, value_or_callback: List[JSONSchemaProps], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def any_of(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[JSONSchemaProps, JSONSchemaProps.Builder]],
                GenericListBuilder[JSONSchemaProps, JSONSchemaProps.Builder]
                | List[JSONSchemaProps],
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def any_of(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[JSONSchemaProps.Builder]: ...

        def any_of(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[JSONSchemaProps.Builder]()
                context._parent_builder = self
                context._field_name = "any_of"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSONSchemaProps.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("any_of", value)

        @overload
        def default(self, value_or_callback: Optional[JSON], /) -> "JSONSchemaProps.Builder": ...

        @overload
        def default(
            self, value_or_callback: Callable[[JSON.Builder], JSON.Builder | JSON], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def default(self, value_or_callback: Never = ...) -> "JSON.BuilderContext": ...

        def default(self, value_or_callback=None, /):
            """
            default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
            """
            if self._in_context and value_or_callback is None:
                context = JSON.BuilderContext()
                context._parent_builder = self
                context._field_name = "default"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSON.builder())
                if isinstance(output, JSON.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("default", value)

        def definitions(self, value: Optional[Dict[str, JSONSchemaProps]], /) -> Self:
            return self._set("definitions", value)

        def dependencies(self, value: Optional[Dict[str, JSONSchemaPropsOrStringArray]], /) -> Self:
            return self._set("dependencies", value)

        def description(self, value: Optional[str], /) -> Self:
            return self._set("description", value)

        @overload
        def enum(self, value_or_callback: List[JSON], /) -> "JSONSchemaProps.Builder": ...

        @overload
        def enum(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[JSON, JSON.Builder]],
                GenericListBuilder[JSON, JSON.Builder] | List[JSON],
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def enum(self, value_or_callback: Never = ...) -> ListBuilderContext[JSON.Builder]: ...

        def enum(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[JSON.Builder]()
                context._parent_builder = self
                context._field_name = "enum"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSON.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("enum", value)

        @overload
        def example(self, value_or_callback: Optional[JSON], /) -> "JSONSchemaProps.Builder": ...

        @overload
        def example(
            self, value_or_callback: Callable[[JSON.Builder], JSON.Builder | JSON], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def example(self, value_or_callback: Never = ...) -> "JSON.BuilderContext": ...

        def example(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = JSON.BuilderContext()
                context._parent_builder = self
                context._field_name = "example"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSON.builder())
                if isinstance(output, JSON.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("example", value)

        def exclusive_maximum(self, value: Optional[bool], /) -> Self:
            return self._set("exclusive_maximum", value)

        def exclusive_minimum(self, value: Optional[bool], /) -> Self:
            return self._set("exclusive_minimum", value)

        @overload
        def external_docs(
            self, value_or_callback: Optional[ExternalDocumentation], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def external_docs(
            self,
            value_or_callback: Callable[
                [ExternalDocumentation.Builder],
                ExternalDocumentation.Builder | ExternalDocumentation,
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def external_docs(
            self, value_or_callback: Never = ...
        ) -> "ExternalDocumentation.BuilderContext": ...

        def external_docs(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = ExternalDocumentation.BuilderContext()
                context._parent_builder = self
                context._field_name = "external_docs"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ExternalDocumentation.builder())
                if isinstance(output, ExternalDocumentation.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("external_docs", value)

        def format(self, value: Optional[str], /) -> Self:
            """
            format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:

            - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\d{3})\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\d{3}[- ]?\d{2}[- ]?\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
            """
            return self._set("format", value)

        def id(self, value: Optional[str], /) -> Self:
            return self._set("id", value)

        @overload
        def items(
            self, value_or_callback: Optional[JSONSchemaPropsOrArray], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def items(
            self,
            value_or_callback: Callable[
                [JSONSchemaPropsOrArray.Builder],
                JSONSchemaPropsOrArray.Builder | JSONSchemaPropsOrArray,
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def items(
            self, value_or_callback: Never = ...
        ) -> "JSONSchemaPropsOrArray.BuilderContext": ...

        def items(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = JSONSchemaPropsOrArray.BuilderContext()
                context._parent_builder = self
                context._field_name = "items"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSONSchemaPropsOrArray.builder())
                if isinstance(output, JSONSchemaPropsOrArray.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("items", value)

        def max_items(self, value: Optional[int], /) -> Self:
            return self._set("max_items", value)

        def max_length(self, value: Optional[int], /) -> Self:
            return self._set("max_length", value)

        def max_properties(self, value: Optional[int], /) -> Self:
            return self._set("max_properties", value)

        def maximum(self, value: Optional[float], /) -> Self:
            return self._set("maximum", value)

        def min_items(self, value: Optional[int], /) -> Self:
            return self._set("min_items", value)

        def min_length(self, value: Optional[int], /) -> Self:
            return self._set("min_length", value)

        def min_properties(self, value: Optional[int], /) -> Self:
            return self._set("min_properties", value)

        def minimum(self, value: Optional[float], /) -> Self:
            return self._set("minimum", value)

        def multiple_of(self, value: Optional[float], /) -> Self:
            return self._set("multiple_of", value)

        @overload
        def not_(
            self, value_or_callback: Optional[JSONSchemaProps], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def not_(
            self,
            value_or_callback: Callable[
                [JSONSchemaProps.Builder], JSONSchemaProps.Builder | JSONSchemaProps
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def not_(self, value_or_callback: Never = ...) -> "JSONSchemaProps.BuilderContext": ...

        def not_(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = JSONSchemaProps.BuilderContext()
                context._parent_builder = self
                context._field_name = "not_"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSONSchemaProps.builder())
                if isinstance(output, JSONSchemaProps.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("not_", value)

        def nullable(self, value: Optional[bool], /) -> Self:
            return self._set("nullable", value)

        @overload
        def one_of(
            self, value_or_callback: List[JSONSchemaProps], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def one_of(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[JSONSchemaProps, JSONSchemaProps.Builder]],
                GenericListBuilder[JSONSchemaProps, JSONSchemaProps.Builder]
                | List[JSONSchemaProps],
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def one_of(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[JSONSchemaProps.Builder]: ...

        def one_of(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[JSONSchemaProps.Builder]()
                context._parent_builder = self
                context._field_name = "one_of"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSONSchemaProps.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("one_of", value)

        def pattern(self, value: Optional[str], /) -> Self:
            return self._set("pattern", value)

        def pattern_properties(self, value: Optional[Dict[str, JSONSchemaProps]], /) -> Self:
            return self._set("pattern_properties", value)

        def properties(self, value: Optional[Dict[str, JSONSchemaProps]], /) -> Self:
            return self._set("properties", value)

        def required(self, value: Optional[List[str]], /) -> Self:
            return self._set("required", value)

        def title(self, value: Optional[str], /) -> Self:
            return self._set("title", value)

        def type(self, value: Optional[str], /) -> Self:
            return self._set("type", value)

        def unique_items(self, value: Optional[bool], /) -> Self:
            return self._set("unique_items", value)

        def x_kubernetes_embedded_resource(self, value: Optional[bool], /) -> Self:
            """
            x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
            """
            return self._set("x_kubernetes_embedded_resource", value)

        def x_kubernetes_int_or_string(self, value: Optional[bool], /) -> Self:
            """
            x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:

            1) anyOf:
               - type: integer
               - type: string
            2) allOf:
               - anyOf:
                 - type: integer
                 - type: string
               - ... zero or more
            """
            return self._set("x_kubernetes_int_or_string", value)

        def x_kubernetes_list_map_keys(self, value: Optional[List[str]], /) -> Self:
            """
            x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.

            This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).

            The properties specified must either be required or have a default value, to ensure those properties are present for all list items.
            """
            return self._set("x_kubernetes_list_map_keys", value)

        def x_kubernetes_list_type(self, value: Optional[str], /) -> Self:
            """
            x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:

            1) `atomic`: the list is treated as a single entity, like a scalar.
                 Atomic lists will be entirely replaced when updated. This extension
                 may be used on any type of list (struct, scalar, ...).
            2) `set`:
                 Sets are lists that must not have multiple items with the same value. Each
                 value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
                 array with x-kubernetes-list-type `atomic`.
            3) `map`:
                 These lists are like maps in that their elements have a non-index key
                 used to identify them. Order is preserved upon merge. The map tag
                 must only be used on a list with elements of type object.
            Defaults to atomic for arrays.
            """
            return self._set("x_kubernetes_list_type", value)

        def x_kubernetes_map_type(self, value: Optional[str], /) -> Self:
            """
            x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:

            1) `granular`:
                 These maps are actual maps (key-value pairs) and each fields are independent
                 from each other (they can each be manipulated by separate actors). This is
                 the default behaviour for all maps.
            2) `atomic`: the list is treated as a single entity, like a scalar.
                 Atomic maps will be entirely replaced when updated.
            """
            return self._set("x_kubernetes_map_type", value)

        def x_kubernetes_preserve_unknown_fields(self, value: Optional[bool], /) -> Self:
            """
            x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
            """
            return self._set("x_kubernetes_preserve_unknown_fields", value)

        @overload
        def x_kubernetes_validations(
            self, value_or_callback: List[ValidationRule], /
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def x_kubernetes_validations(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ValidationRule, ValidationRule.Builder]],
                GenericListBuilder[ValidationRule, ValidationRule.Builder] | List[ValidationRule],
            ],
            /,
        ) -> "JSONSchemaProps.Builder": ...

        @overload
        def x_kubernetes_validations(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ValidationRule.Builder]: ...

        def x_kubernetes_validations(self, value_or_callback=None, /):
            """
            x-kubernetes-validations describes a list of validation rules written in the CEL expression language.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ValidationRule.Builder]()
                context._parent_builder = self
                context._field_name = "x_kubernetes_validations"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ValidationRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("x_kubernetes_validations", value)

    class BuilderContext(BuilderContextBase["JSONSchemaProps.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JSONSchemaProps.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JSONSchemaProps."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["JSONSchemaProps", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use JSONSchemaProps.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    field_ref: Annotated[Optional[str], Field(alias="$ref")] = None
    field_schema: Annotated[Optional[str], Field(alias="$schema")] = None
    additional_items: Annotated[Optional[JSONSchemaPropsOrBool], Field(alias="additionalItems")] = (
        None
    )
    additional_properties: Annotated[
        Optional[JSONSchemaPropsOrBool], Field(alias="additionalProperties")
    ] = None
    all_of: Annotated[Optional[List[JSONSchemaProps]], Field(alias="allOf")] = None
    any_of: Annotated[Optional[List[JSONSchemaProps]], Field(alias="anyOf")] = None
    default: Optional[JSON] = None
    """
    default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
    """
    definitions: Optional[Dict[str, JSONSchemaProps]] = None
    dependencies: Optional[Dict[str, JSONSchemaPropsOrStringArray]] = None
    description: Optional[str] = None
    enum: Optional[List[JSON]] = None
    example: Optional[JSON] = None
    exclusive_maximum: Annotated[Optional[bool], Field(alias="exclusiveMaximum")] = None
    exclusive_minimum: Annotated[Optional[bool], Field(alias="exclusiveMinimum")] = None
    external_docs: Annotated[Optional[ExternalDocumentation], Field(alias="externalDocs")] = None
    format: Optional[str] = None
    """
    format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:

    - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\d{3})\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\d{3}[- ]?\d{2}[- ]?\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
    """
    id: Optional[str] = None
    items: Optional[JSONSchemaPropsOrArray] = None
    max_items: Annotated[Optional[int], Field(alias="maxItems")] = None
    max_length: Annotated[Optional[int], Field(alias="maxLength")] = None
    max_properties: Annotated[Optional[int], Field(alias="maxProperties")] = None
    maximum: Optional[float] = None
    min_items: Annotated[Optional[int], Field(alias="minItems")] = None
    min_length: Annotated[Optional[int], Field(alias="minLength")] = None
    min_properties: Annotated[Optional[int], Field(alias="minProperties")] = None
    minimum: Optional[float] = None
    multiple_of: Annotated[Optional[float], Field(alias="multipleOf")] = None
    not_: Annotated[Optional[JSONSchemaProps], Field(alias="not")] = None
    nullable: Optional[bool] = None
    one_of: Annotated[Optional[List[JSONSchemaProps]], Field(alias="oneOf")] = None
    pattern: Optional[str] = None
    pattern_properties: Annotated[
        Optional[Dict[str, JSONSchemaProps]], Field(alias="patternProperties")
    ] = None
    properties: Optional[Dict[str, JSONSchemaProps]] = None
    required: Optional[List[str]] = None
    title: Optional[str] = None
    type: Optional[str] = None
    unique_items: Annotated[Optional[bool], Field(alias="uniqueItems")] = None
    x_kubernetes_embedded_resource: Annotated[
        Optional[bool], Field(alias="x-kubernetes-embedded-resource")
    ] = None
    """
    x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
    """
    x_kubernetes_int_or_string: Annotated[
        Optional[bool], Field(alias="x-kubernetes-int-or-string")
    ] = None
    """
    x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:

    1) anyOf:
       - type: integer
       - type: string
    2) allOf:
       - anyOf:
         - type: integer
         - type: string
       - ... zero or more
    """
    x_kubernetes_list_map_keys: Annotated[
        Optional[List[str]], Field(alias="x-kubernetes-list-map-keys")
    ] = None
    """
    x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.

    This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).

    The properties specified must either be required or have a default value, to ensure those properties are present for all list items.
    """
    x_kubernetes_list_type: Annotated[Optional[str], Field(alias="x-kubernetes-list-type")] = None
    """
    x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:

    1) `atomic`: the list is treated as a single entity, like a scalar.
         Atomic lists will be entirely replaced when updated. This extension
         may be used on any type of list (struct, scalar, ...).
    2) `set`:
         Sets are lists that must not have multiple items with the same value. Each
         value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
         array with x-kubernetes-list-type `atomic`.
    3) `map`:
         These lists are like maps in that their elements have a non-index key
         used to identify them. Order is preserved upon merge. The map tag
         must only be used on a list with elements of type object.
    Defaults to atomic for arrays.
    """
    x_kubernetes_map_type: Annotated[Optional[str], Field(alias="x-kubernetes-map-type")] = None
    """
    x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:

    1) `granular`:
         These maps are actual maps (key-value pairs) and each fields are independent
         from each other (they can each be manipulated by separate actors). This is
         the default behaviour for all maps.
    2) `atomic`: the list is treated as a single entity, like a scalar.
         Atomic maps will be entirely replaced when updated.
    """
    x_kubernetes_preserve_unknown_fields: Annotated[
        Optional[bool], Field(alias="x-kubernetes-preserve-unknown-fields")
    ] = None
    """
    x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
    """
    x_kubernetes_validations: Annotated[
        Optional[List[ValidationRule]], Field(alias="x-kubernetes-validations")
    ] = None
    """
    x-kubernetes-validations describes a list of validation rules written in the CEL expression language.
    """


class CustomResourceValidation(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceValidation"]:
            return CustomResourceValidation

        def build(self) -> "CustomResourceValidation":
            return CustomResourceValidation(**self._attrs)

        @overload
        def open_apiv3_schema(
            self, value_or_callback: Optional[JSONSchemaProps], /
        ) -> "CustomResourceValidation.Builder": ...

        @overload
        def open_apiv3_schema(
            self,
            value_or_callback: Callable[
                [JSONSchemaProps.Builder], JSONSchemaProps.Builder | JSONSchemaProps
            ],
            /,
        ) -> "CustomResourceValidation.Builder": ...

        @overload
        def open_apiv3_schema(
            self, value_or_callback: Never = ...
        ) -> "JSONSchemaProps.BuilderContext": ...

        def open_apiv3_schema(self, value_or_callback=None, /):
            """
            openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
            """
            if self._in_context and value_or_callback is None:
                context = JSONSchemaProps.BuilderContext()
                context._parent_builder = self
                context._field_name = "open_apiv3_schema"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JSONSchemaProps.builder())
                if isinstance(output, JSONSchemaProps.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("open_apiv3_schema", value)

    class BuilderContext(BuilderContextBase["CustomResourceValidation.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceValidation.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceValidation."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceValidation", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceValidation.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    open_apiv3_schema: Annotated[Optional[JSONSchemaProps], Field(alias="openAPIV3Schema")] = None
    """
    openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
    """


class CustomResourceDefinitionVersion(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceDefinitionVersion"]:
            return CustomResourceDefinitionVersion

        def build(self) -> "CustomResourceDefinitionVersion":
            return CustomResourceDefinitionVersion(**self._attrs)

        @overload
        def additional_printer_columns(
            self, value_or_callback: List[CustomResourceColumnDefinition], /
        ) -> "CustomResourceDefinitionVersion.Builder": ...

        @overload
        def additional_printer_columns(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        CustomResourceColumnDefinition,
                        CustomResourceColumnDefinition.Builder,
                    ]
                ],
                GenericListBuilder[
                    CustomResourceColumnDefinition,
                    CustomResourceColumnDefinition.Builder,
                ]
                | List[CustomResourceColumnDefinition],
            ],
            /,
        ) -> "CustomResourceDefinitionVersion.Builder": ...

        @overload
        def additional_printer_columns(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[CustomResourceColumnDefinition.Builder]: ...

        def additional_printer_columns(self, value_or_callback=None, /):
            """
            additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[CustomResourceColumnDefinition.Builder]()
                context._parent_builder = self
                context._field_name = "additional_printer_columns"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceColumnDefinition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("additional_printer_columns", value)

        def deprecated(self, value: Optional[bool], /) -> Self:
            """
            deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
            """
            return self._set("deprecated", value)

        def deprecation_warning(self, value: Optional[str], /) -> Self:
            """
            deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
            """
            return self._set("deprecation_warning", value)

        def name(self, value: str, /) -> Self:
            """
            name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
            """
            return self._set("name", value)

        @overload
        def schema_(
            self, value_or_callback: Optional[CustomResourceValidation], /
        ) -> "CustomResourceDefinitionVersion.Builder": ...

        @overload
        def schema_(
            self,
            value_or_callback: Callable[
                [CustomResourceValidation.Builder],
                CustomResourceValidation.Builder | CustomResourceValidation,
            ],
            /,
        ) -> "CustomResourceDefinitionVersion.Builder": ...

        @overload
        def schema_(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceValidation.BuilderContext": ...

        def schema_(self, value_or_callback=None, /):
            """
            schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceValidation.BuilderContext()
                context._parent_builder = self
                context._field_name = "schema_"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceValidation.builder())
                if isinstance(output, CustomResourceValidation.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("schema_", value)

        @overload
        def selectable_fields(
            self, value_or_callback: List[SelectableField], /
        ) -> "CustomResourceDefinitionVersion.Builder": ...

        @overload
        def selectable_fields(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[SelectableField, SelectableField.Builder]],
                GenericListBuilder[SelectableField, SelectableField.Builder]
                | List[SelectableField],
            ],
            /,
        ) -> "CustomResourceDefinitionVersion.Builder": ...

        @overload
        def selectable_fields(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[SelectableField.Builder]: ...

        def selectable_fields(self, value_or_callback=None, /):
            """
            selectableFields specifies paths to fields that may be used as field selectors. A maximum of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[SelectableField.Builder]()
                context._parent_builder = self
                context._field_name = "selectable_fields"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SelectableField.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("selectable_fields", value)

        def served(self, value: bool, /) -> Self:
            """
            served is a flag enabling/disabling this version from being served via REST APIs
            """
            return self._set("served", value)

        def storage(self, value: bool, /) -> Self:
            """
            storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
            """
            return self._set("storage", value)

        @overload
        def subresources(
            self, value_or_callback: Optional[CustomResourceSubresources], /
        ) -> "CustomResourceDefinitionVersion.Builder": ...

        @overload
        def subresources(
            self,
            value_or_callback: Callable[
                [CustomResourceSubresources.Builder],
                CustomResourceSubresources.Builder | CustomResourceSubresources,
            ],
            /,
        ) -> "CustomResourceDefinitionVersion.Builder": ...

        @overload
        def subresources(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceSubresources.BuilderContext": ...

        def subresources(self, value_or_callback=None, /):
            """
            subresources specify what subresources this version of the defined custom resource have.
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceSubresources.BuilderContext()
                context._parent_builder = self
                context._field_name = "subresources"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceSubresources.builder())
                if isinstance(output, CustomResourceSubresources.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("subresources", value)

    class BuilderContext(BuilderContextBase["CustomResourceDefinitionVersion.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceDefinitionVersion.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceDefinitionVersion."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceDefinitionVersion", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceDefinitionVersion.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    additional_printer_columns: Annotated[
        Optional[List[CustomResourceColumnDefinition]],
        Field(alias="additionalPrinterColumns"),
    ] = None
    """
    additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
    """
    deprecated: Optional[bool] = None
    """
    deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
    """
    deprecation_warning: Annotated[Optional[str], Field(alias="deprecationWarning")] = None
    """
    deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
    """
    name: str
    """
    name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
    """
    schema_: Annotated[Optional[CustomResourceValidation], Field(alias="schema")] = None
    """
    schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
    """
    selectable_fields: Annotated[
        Optional[List[SelectableField]], Field(alias="selectableFields")
    ] = None
    """
    selectableFields specifies paths to fields that may be used as field selectors. A maximum of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
    """
    served: bool
    """
    served is a flag enabling/disabling this version from being served via REST APIs
    """
    storage: bool
    """
    storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
    """
    subresources: Optional[CustomResourceSubresources] = None
    """
    subresources specify what subresources this version of the defined custom resource have.
    """


class CustomResourceDefinitionSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceDefinitionSpec"]:
            return CustomResourceDefinitionSpec

        def build(self) -> "CustomResourceDefinitionSpec":
            return CustomResourceDefinitionSpec(**self._attrs)

        @overload
        def conversion(
            self, value_or_callback: Optional[CustomResourceConversion], /
        ) -> "CustomResourceDefinitionSpec.Builder": ...

        @overload
        def conversion(
            self,
            value_or_callback: Callable[
                [CustomResourceConversion.Builder],
                CustomResourceConversion.Builder | CustomResourceConversion,
            ],
            /,
        ) -> "CustomResourceDefinitionSpec.Builder": ...

        @overload
        def conversion(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceConversion.BuilderContext": ...

        def conversion(self, value_or_callback=None, /):
            """
            conversion defines conversion settings for the CRD.
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceConversion.BuilderContext()
                context._parent_builder = self
                context._field_name = "conversion"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceConversion.builder())
                if isinstance(output, CustomResourceConversion.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("conversion", value)

        def group(self, value: str, /) -> Self:
            """
            group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
            """
            return self._set("group", value)

        @overload
        def names(
            self, value_or_callback: CustomResourceDefinitionNames, /
        ) -> "CustomResourceDefinitionSpec.Builder": ...

        @overload
        def names(
            self,
            value_or_callback: Callable[
                [CustomResourceDefinitionNames.Builder],
                CustomResourceDefinitionNames.Builder | CustomResourceDefinitionNames,
            ],
            /,
        ) -> "CustomResourceDefinitionSpec.Builder": ...

        @overload
        def names(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceDefinitionNames.BuilderContext": ...

        def names(self, value_or_callback=None, /):
            """
            names specify the resource and kind names for the custom resource.
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceDefinitionNames.BuilderContext()
                context._parent_builder = self
                context._field_name = "names"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceDefinitionNames.builder())
                if isinstance(output, CustomResourceDefinitionNames.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("names", value)

        def preserve_unknown_fields(self, value: Optional[bool], /) -> Self:
            """
            preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.
            """
            return self._set("preserve_unknown_fields", value)

        def scope(self, value: str, /) -> Self:
            """
            scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`.
            """
            return self._set("scope", value)

        @overload
        def versions(
            self, value_or_callback: List[CustomResourceDefinitionVersion], /
        ) -> "CustomResourceDefinitionSpec.Builder": ...

        @overload
        def versions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        CustomResourceDefinitionVersion,
                        CustomResourceDefinitionVersion.Builder,
                    ]
                ],
                GenericListBuilder[
                    CustomResourceDefinitionVersion,
                    CustomResourceDefinitionVersion.Builder,
                ]
                | List[CustomResourceDefinitionVersion],
            ],
            /,
        ) -> "CustomResourceDefinitionSpec.Builder": ...

        @overload
        def versions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[CustomResourceDefinitionVersion.Builder]: ...

        def versions(self, value_or_callback=None, /):
            """
            versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[CustomResourceDefinitionVersion.Builder]()
                context._parent_builder = self
                context._field_name = "versions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceDefinitionVersion.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("versions", value)

    class BuilderContext(BuilderContextBase["CustomResourceDefinitionSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceDefinitionSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceDefinitionSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceDefinitionSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceDefinitionSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conversion: Optional[CustomResourceConversion] = None
    """
    conversion defines conversion settings for the CRD.
    """
    group: str
    """
    group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
    """
    names: CustomResourceDefinitionNames
    """
    names specify the resource and kind names for the custom resource.
    """
    preserve_unknown_fields: Annotated[Optional[bool], Field(alias="preserveUnknownFields")] = None
    """
    preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.
    """
    scope: str
    """
    scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`.
    """
    versions: List[CustomResourceDefinitionVersion]
    """
    versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
    """


class CustomResourceDefinition(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CustomResourceDefinition"]:
            return CustomResourceDefinition

        def build(self) -> "CustomResourceDefinition":
            return CustomResourceDefinition(**self._attrs)

        def api_version(self, value: Optional[Literal["apiextensions.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["CustomResourceDefinition"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "CustomResourceDefinition.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "CustomResourceDefinition.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: CustomResourceDefinitionSpec, /
        ) -> "CustomResourceDefinition.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [CustomResourceDefinitionSpec.Builder],
                CustomResourceDefinitionSpec.Builder | CustomResourceDefinitionSpec,
            ],
            /,
        ) -> "CustomResourceDefinition.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceDefinitionSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec describes how the user wants the resources to appear
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceDefinitionSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceDefinitionSpec.builder())
                if isinstance(output, CustomResourceDefinitionSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[CustomResourceDefinitionStatus], /
        ) -> "CustomResourceDefinition.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [CustomResourceDefinitionStatus.Builder],
                CustomResourceDefinitionStatus.Builder | CustomResourceDefinitionStatus,
            ],
            /,
        ) -> "CustomResourceDefinition.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "CustomResourceDefinitionStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            status indicates the actual state of the CustomResourceDefinition
            """
            if self._in_context and value_or_callback is None:
                context = CustomResourceDefinitionStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CustomResourceDefinitionStatus.builder())
                if isinstance(output, CustomResourceDefinitionStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["CustomResourceDefinition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CustomResourceDefinition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CustomResourceDefinition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CustomResourceDefinition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CustomResourceDefinition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["apiextensions.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "apiextensions.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["CustomResourceDefinition"]] = "CustomResourceDefinition"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: CustomResourceDefinitionSpec
    """
    spec describes how the user wants the resources to appear
    """
    status: Optional[CustomResourceDefinitionStatus] = None
    """
    status indicates the actual state of the CustomResourceDefinition
    """


CustomResourceDefinitionList = ResourceList["CustomResourceDefinition"]


JSONSchemaProps.model_rebuild()
