# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList


class AuditAnnotation(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AuditAnnotation"]:
            return AuditAnnotation

        def build(self) -> "AuditAnnotation":
            return AuditAnnotation(**self._attrs)

        def key(self, value: str, /) -> Self:
            """
            key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.

            The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".

            If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.

            Required.
            """
            return self._set("key", value)

        def value_expression(self, value: str, /) -> Self:
            """
            valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.

            If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.

            Required.
            """
            return self._set("value_expression", value)

    class BuilderContext(BuilderContextBase["AuditAnnotation.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AuditAnnotation.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AuditAnnotation."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AuditAnnotation", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AuditAnnotation.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    key: str
    """
    key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.

    The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".

    If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.

    Required.
    """
    value_expression: Annotated[str, Field(alias="valueExpression")]
    """
    valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.

    If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.

    Required.
    """


class ExpressionWarning(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ExpressionWarning"]:
            return ExpressionWarning

        def build(self) -> "ExpressionWarning":
            return ExpressionWarning(**self._attrs)

        def field_ref(self, value: str, /) -> Self:
            """
            The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
            """
            return self._set("field_ref", value)

        def warning(self, value: str, /) -> Self:
            """
            The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
            """
            return self._set("warning", value)

    class BuilderContext(BuilderContextBase["ExpressionWarning.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ExpressionWarning.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ExpressionWarning."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ExpressionWarning", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ExpressionWarning.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    field_ref: Annotated[str, Field(alias="fieldRef")]
    """
    The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
    """
    warning: str
    """
    The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
    """


class MatchCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["MatchCondition"]:
            return MatchCondition

        def build(self) -> "MatchCondition":
            return MatchCondition(**self._attrs)

        def expression(self, value: str, /) -> Self:
            """
            Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:

            'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
              See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
            'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
              request resource.
            Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/

            Required.
            """
            return self._set("expression", value)

        def name(self, value: str, /) -> Self:
            """
            Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')

            Required.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["MatchCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = MatchCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for MatchCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["MatchCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use MatchCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    expression: str
    """
    Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:

    'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
      See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
    'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
      request resource.
    Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/

    Required.
    """
    name: str
    """
    Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')

    Required.
    """


class NamedRuleWithOperations(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NamedRuleWithOperations"]:
            return NamedRuleWithOperations

        def build(self) -> "NamedRuleWithOperations":
            return NamedRuleWithOperations(**self._attrs)

        def api_groups(self, value: Optional[List[str]], /) -> Self:
            """
            APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
            """
            return self._set("api_groups", value)

        def api_versions(self, value: Optional[List[str]], /) -> Self:
            """
            APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
            """
            return self._set("api_versions", value)

        def operations(self, value: Optional[List[str]], /) -> Self:
            """
            Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
            """
            return self._set("operations", value)

        def resource_names(self, value: Optional[List[str]], /) -> Self:
            """
            ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
            """
            return self._set("resource_names", value)

        def resources(self, value: Optional[List[str]], /) -> Self:
            """
            Resources is a list of resources this rule applies to.

            For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.

            If wildcard is present, the validation rule will ensure resources do not overlap with each other.

            Depending on the enclosing object, subresources might not be allowed. Required.
            """
            return self._set("resources", value)

        def scope(self, value: Optional[str], /) -> Self:
            """
            scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
            """
            return self._set("scope", value)

    class BuilderContext(BuilderContextBase["NamedRuleWithOperations.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NamedRuleWithOperations.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NamedRuleWithOperations."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NamedRuleWithOperations", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NamedRuleWithOperations.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_groups: Annotated[Optional[List[str]], Field(alias="apiGroups")] = None
    """
    APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
    """
    api_versions: Annotated[Optional[List[str]], Field(alias="apiVersions")] = None
    """
    APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
    """
    operations: Optional[List[str]] = None
    """
    Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
    """
    resource_names: Annotated[Optional[List[str]], Field(alias="resourceNames")] = None
    """
    ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
    """
    resources: Optional[List[str]] = None
    """
    Resources is a list of resources this rule applies to.

    For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.

    If wildcard is present, the validation rule will ensure resources do not overlap with each other.

    Depending on the enclosing object, subresources might not be allowed. Required.
    """
    scope: Optional[str] = None
    """
    scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
    """


class ParamKind(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ParamKind"]:
            return ParamKind

        def build(self) -> "ParamKind":
            return ParamKind(**self._attrs)

        def api_version(self, value: Optional[str], /) -> Self:
            """
            APIVersion is the API group version the resources belong to. In format of "group/version". Required.
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[str], /) -> Self:
            """
            Kind is the API kind the resources belong to. Required.
            """
            return self._set("kind", value)

    class BuilderContext(BuilderContextBase["ParamKind.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ParamKind.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ParamKind."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ParamKind", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ParamKind.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[str], Field(alias="apiVersion")] = None
    """
    APIVersion is the API group version the resources belong to. In format of "group/version". Required.
    """
    kind: Optional[str] = None
    """
    Kind is the API kind the resources belong to. Required.
    """


class TypeChecking(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TypeChecking"]:
            return TypeChecking

        def build(self) -> "TypeChecking":
            return TypeChecking(**self._attrs)

        @overload
        def expression_warnings(
            self, value_or_callback: List[ExpressionWarning], /
        ) -> "TypeChecking.Builder": ...

        @overload
        def expression_warnings(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ExpressionWarning, ExpressionWarning.Builder]],
                GenericListBuilder[ExpressionWarning, ExpressionWarning.Builder]
                | List[ExpressionWarning],
            ],
            /,
        ) -> "TypeChecking.Builder": ...

        @overload
        def expression_warnings(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ExpressionWarning.Builder]: ...

        def expression_warnings(self, value_or_callback=None, /):
            """
            The type checking warnings for each expression.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ExpressionWarning.Builder]()
                context._parent_builder = self
                context._field_name = "expression_warnings"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ExpressionWarning.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("expression_warnings", value)

    class BuilderContext(BuilderContextBase["TypeChecking.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TypeChecking.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TypeChecking."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TypeChecking", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TypeChecking.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    expression_warnings: Annotated[
        Optional[List[ExpressionWarning]], Field(alias="expressionWarnings")
    ] = None
    """
    The type checking warnings for each expression.
    """


class Validation(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Validation"]:
            return Validation

        def build(self) -> "Validation":
            return Validation(**self._attrs)

        def expression(self, value: str, /) -> Self:
            """
            Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:

            - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
              For example, a variable named 'foo' can be accessed as 'variables.foo'.
            - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
              See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
            - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
              request resource.

            The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.

            Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
                  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
                  "import", "let", "loop", "package", "namespace", "return".
            Examples:
              - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
              - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
              - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}

            Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
              - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
                non-intersecting elements in `Y` are appended, retaining their partial order.
              - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
                are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
                non-intersecting keys are appended, retaining their partial order.
            Required.
            """
            return self._set("expression", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
            """
            return self._set("message", value)

        def message_expression(self, value: Optional[str], /) -> Self:
            """
            messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
            """
            return self._set("message_expression", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
            """
            return self._set("reason", value)

    class BuilderContext(BuilderContextBase["Validation.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Validation.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Validation."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Validation", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Validation.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    expression: str
    """
    Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:

    - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
      For example, a variable named 'foo' can be accessed as 'variables.foo'.
    - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
      See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
    - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
      request resource.

    The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.

    Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
          "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
          "import", "let", "loop", "package", "namespace", "return".
    Examples:
      - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
      - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
      - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}

    Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
      - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
        non-intersecting elements in `Y` are appended, retaining their partial order.
      - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
        are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
        non-intersecting keys are appended, retaining their partial order.
    Required.
    """
    message: Optional[str] = None
    """
    Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
    """
    message_expression: Annotated[Optional[str], Field(alias="messageExpression")] = None
    """
    messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
    """
    reason: Optional[str] = None
    """
    Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
    """


class Variable(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Variable"]:
            return Variable

        def build(self) -> "Variable":
            return Variable(**self._attrs)

        def expression(self, value: str, /) -> Self:
            """
            Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
            """
            return self._set("expression", value)

        def name(self, value: str, /) -> Self:
            """
            Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["Variable.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Variable.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Variable."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Variable", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Variable.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    expression: str
    """
    Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
    """
    name: str
    """
    Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
    """


class MatchResources(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["MatchResources"]:
            return MatchResources

        def build(self) -> "MatchResources":
            return MatchResources(**self._attrs)

        @overload
        def exclude_resource_rules(
            self, value_or_callback: List[NamedRuleWithOperations], /
        ) -> "MatchResources.Builder": ...

        @overload
        def exclude_resource_rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NamedRuleWithOperations, NamedRuleWithOperations.Builder]],
                GenericListBuilder[NamedRuleWithOperations, NamedRuleWithOperations.Builder]
                | List[NamedRuleWithOperations],
            ],
            /,
        ) -> "MatchResources.Builder": ...

        @overload
        def exclude_resource_rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NamedRuleWithOperations.Builder]: ...

        def exclude_resource_rules(self, value_or_callback=None, /):
            """
            ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NamedRuleWithOperations.Builder]()
                context._parent_builder = self
                context._field_name = "exclude_resource_rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NamedRuleWithOperations.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("exclude_resource_rules", value)

        def match_policy(self, value: Optional[str], /) -> Self:
            """
            matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

            - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.

            - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.

            Defaults to "Equivalent"
            """
            return self._set("match_policy", value)

        @overload
        def namespace_selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "MatchResources.Builder": ...

        @overload
        def namespace_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "MatchResources.Builder": ...

        @overload
        def namespace_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def namespace_selector(self, value_or_callback=None, /):
            """
            NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.

            For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
              "matchExpressions": [
                {
                  "key": "runlevel",
                  "operator": "NotIn",
                  "values": [
                    "0",
                    "1"
                  ]
                }
              ]
            }

            If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
              "matchExpressions": [
                {
                  "key": "environment",
                  "operator": "In",
                  "values": [
                    "prod",
                    "staging"
                  ]
                }
              ]
            }

            See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.

            Default to the empty LabelSelector, which matches everything.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "namespace_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("namespace_selector", value)

        @overload
        def object_selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "MatchResources.Builder": ...

        @overload
        def object_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "MatchResources.Builder": ...

        @overload
        def object_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def object_selector(self, value_or_callback=None, /):
            """
            ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "object_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("object_selector", value)

        @overload
        def resource_rules(
            self, value_or_callback: List[NamedRuleWithOperations], /
        ) -> "MatchResources.Builder": ...

        @overload
        def resource_rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NamedRuleWithOperations, NamedRuleWithOperations.Builder]],
                GenericListBuilder[NamedRuleWithOperations, NamedRuleWithOperations.Builder]
                | List[NamedRuleWithOperations],
            ],
            /,
        ) -> "MatchResources.Builder": ...

        @overload
        def resource_rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NamedRuleWithOperations.Builder]: ...

        def resource_rules(self, value_or_callback=None, /):
            """
            ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NamedRuleWithOperations.Builder]()
                context._parent_builder = self
                context._field_name = "resource_rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NamedRuleWithOperations.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_rules", value)

    class BuilderContext(BuilderContextBase["MatchResources.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = MatchResources.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for MatchResources."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["MatchResources", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use MatchResources.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    exclude_resource_rules: Annotated[
        Optional[List[NamedRuleWithOperations]], Field(alias="excludeResourceRules")
    ] = None
    """
    ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
    """
    match_policy: Annotated[Optional[str], Field(alias="matchPolicy")] = None
    """
    matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

    - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.

    - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.

    Defaults to "Equivalent"
    """
    namespace_selector: Annotated[
        Optional[apimachinery.LabelSelector], Field(alias="namespaceSelector")
    ] = None
    """
    NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.

    For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
      "matchExpressions": [
        {
          "key": "runlevel",
          "operator": "NotIn",
          "values": [
            "0",
            "1"
          ]
        }
      ]
    }

    If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
      "matchExpressions": [
        {
          "key": "environment",
          "operator": "In",
          "values": [
            "prod",
            "staging"
          ]
        }
      ]
    }

    See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.

    Default to the empty LabelSelector, which matches everything.
    """
    object_selector: Annotated[
        Optional[apimachinery.LabelSelector], Field(alias="objectSelector")
    ] = None
    """
    ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
    """
    resource_rules: Annotated[
        Optional[List[NamedRuleWithOperations]], Field(alias="resourceRules")
    ] = None
    """
    ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.
    """


class ParamRef(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ParamRef"]:
            return ParamRef

        def build(self) -> "ParamRef":
            return ParamRef(**self._attrs)

        def name(self, value: Optional[str], /) -> Self:
            """
            `name` is the name of the resource being referenced.

            `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
            """
            return self._set("name", value)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.

            A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.

            - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.

            - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
            """
            return self._set("namespace", value)

        def parameter_not_found_action(self, value: Optional[str], /) -> Self:
            """
            `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.

            Allowed values are `Allow` or `Deny` Default to `Deny`
            """
            return self._set("parameter_not_found_action", value)

        @overload
        def selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "ParamRef.Builder": ...

        @overload
        def selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "ParamRef.Builder": ...

        @overload
        def selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def selector(self, value_or_callback=None, /):
            """
            selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.

            If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.

            One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("selector", value)

    class BuilderContext(BuilderContextBase["ParamRef.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ParamRef.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ParamRef."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ParamRef", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ParamRef.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: Optional[str] = None
    """
    `name` is the name of the resource being referenced.

    `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
    """
    namespace: Optional[str] = None
    """
    namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.

    A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.

    - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.

    - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
    """
    parameter_not_found_action: Annotated[Optional[str], Field(alias="parameterNotFoundAction")] = (
        None
    )
    """
    `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.

    Allowed values are `Allow` or `Deny` Default to `Deny`
    """
    selector: Optional[apimachinery.LabelSelector] = None
    """
    selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.

    If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.

    One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
    """


class ValidatingAdmissionPolicyBindingSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ValidatingAdmissionPolicyBindingSpec"]:
            return ValidatingAdmissionPolicyBindingSpec

        def build(self) -> "ValidatingAdmissionPolicyBindingSpec":
            return ValidatingAdmissionPolicyBindingSpec(**self._attrs)

        @overload
        def match_resources(
            self, value_or_callback: Optional[MatchResources], /
        ) -> "ValidatingAdmissionPolicyBindingSpec.Builder": ...

        @overload
        def match_resources(
            self,
            value_or_callback: Callable[
                [MatchResources.Builder], MatchResources.Builder | MatchResources
            ],
            /,
        ) -> "ValidatingAdmissionPolicyBindingSpec.Builder": ...

        @overload
        def match_resources(
            self, value_or_callback: Never = ...
        ) -> "MatchResources.BuilderContext": ...

        def match_resources(self, value_or_callback=None, /):
            """
            MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
            """
            if self._in_context and value_or_callback is None:
                context = MatchResources.BuilderContext()
                context._parent_builder = self
                context._field_name = "match_resources"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MatchResources.builder())
                if isinstance(output, MatchResources.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("match_resources", value)

        @overload
        def param_ref(
            self, value_or_callback: Optional[ParamRef], /
        ) -> "ValidatingAdmissionPolicyBindingSpec.Builder": ...

        @overload
        def param_ref(
            self,
            value_or_callback: Callable[[ParamRef.Builder], ParamRef.Builder | ParamRef],
            /,
        ) -> "ValidatingAdmissionPolicyBindingSpec.Builder": ...

        @overload
        def param_ref(self, value_or_callback: Never = ...) -> "ParamRef.BuilderContext": ...

        def param_ref(self, value_or_callback=None, /):
            """
            paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
            """
            if self._in_context and value_or_callback is None:
                context = ParamRef.BuilderContext()
                context._parent_builder = self
                context._field_name = "param_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ParamRef.builder())
                if isinstance(output, ParamRef.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("param_ref", value)

        def policy_name(self, value: Optional[str], /) -> Self:
            """
            PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
            """
            return self._set("policy_name", value)

        def validation_actions(self, value: Optional[List[str]], /) -> Self:
            """
            validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.

            Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.

            validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.

            The supported actions values are:

            "Deny" specifies that a validation failure results in a denied request.

            "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.

            "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`

            Clients should expect to handle additional values by ignoring any values not recognized.

            "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.

            Required.
            """
            return self._set("validation_actions", value)

    class BuilderContext(BuilderContextBase["ValidatingAdmissionPolicyBindingSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ValidatingAdmissionPolicyBindingSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ValidatingAdmissionPolicyBindingSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ValidatingAdmissionPolicyBindingSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ValidatingAdmissionPolicyBindingSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    match_resources: Annotated[Optional[MatchResources], Field(alias="matchResources")] = None
    """
    MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
    """
    param_ref: Annotated[Optional[ParamRef], Field(alias="paramRef")] = None
    """
    paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
    """
    policy_name: Annotated[Optional[str], Field(alias="policyName")] = None
    """
    PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
    """
    validation_actions: Annotated[Optional[List[str]], Field(alias="validationActions")] = None
    """
    validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.

    Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.

    validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.

    The supported actions values are:

    "Deny" specifies that a validation failure results in a denied request.

    "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.

    "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`

    Clients should expect to handle additional values by ignoring any values not recognized.

    "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.

    Required.
    """


class ValidatingAdmissionPolicySpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ValidatingAdmissionPolicySpec"]:
            return ValidatingAdmissionPolicySpec

        def build(self) -> "ValidatingAdmissionPolicySpec":
            return ValidatingAdmissionPolicySpec(**self._attrs)

        @overload
        def audit_annotations(
            self, value_or_callback: List[AuditAnnotation], /
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def audit_annotations(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[AuditAnnotation, AuditAnnotation.Builder]],
                GenericListBuilder[AuditAnnotation, AuditAnnotation.Builder]
                | List[AuditAnnotation],
            ],
            /,
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def audit_annotations(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[AuditAnnotation.Builder]: ...

        def audit_annotations(self, value_or_callback=None, /):
            """
            auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[AuditAnnotation.Builder]()
                context._parent_builder = self
                context._field_name = "audit_annotations"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AuditAnnotation.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("audit_annotations", value)

        def failure_policy(self, value: Optional[str], /) -> Self:
            """
            failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.

            A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.

            failurePolicy does not define how validations that evaluate to false are handled.

            When failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.

            Allowed values are Ignore or Fail. Defaults to Fail.
            """
            return self._set("failure_policy", value)

        @overload
        def match_conditions(
            self, value_or_callback: List[MatchCondition], /
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def match_conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[MatchCondition, MatchCondition.Builder]],
                GenericListBuilder[MatchCondition, MatchCondition.Builder] | List[MatchCondition],
            ],
            /,
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def match_conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[MatchCondition.Builder]: ...

        def match_conditions(self, value_or_callback=None, /):
            """
            MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.

            If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.

            The exact matching logic is (in order):
              1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
              2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
              3. If any matchCondition evaluates to an error (but none are FALSE):
                 - If failurePolicy=Fail, reject the request
                 - If failurePolicy=Ignore, the policy is skipped
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[MatchCondition.Builder]()
                context._parent_builder = self
                context._field_name = "match_conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MatchCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("match_conditions", value)

        @overload
        def match_constraints(
            self, value_or_callback: Optional[MatchResources], /
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def match_constraints(
            self,
            value_or_callback: Callable[
                [MatchResources.Builder], MatchResources.Builder | MatchResources
            ],
            /,
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def match_constraints(
            self, value_or_callback: Never = ...
        ) -> "MatchResources.BuilderContext": ...

        def match_constraints(self, value_or_callback=None, /):
            """
            MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
            """
            if self._in_context and value_or_callback is None:
                context = MatchResources.BuilderContext()
                context._parent_builder = self
                context._field_name = "match_constraints"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MatchResources.builder())
                if isinstance(output, MatchResources.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("match_constraints", value)

        @overload
        def param_kind(
            self, value_or_callback: Optional[ParamKind], /
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def param_kind(
            self,
            value_or_callback: Callable[[ParamKind.Builder], ParamKind.Builder | ParamKind],
            /,
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def param_kind(self, value_or_callback: Never = ...) -> "ParamKind.BuilderContext": ...

        def param_kind(self, value_or_callback=None, /):
            """
            ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
            """
            if self._in_context and value_or_callback is None:
                context = ParamKind.BuilderContext()
                context._parent_builder = self
                context._field_name = "param_kind"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ParamKind.builder())
                if isinstance(output, ParamKind.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("param_kind", value)

        @overload
        def validations(
            self, value_or_callback: List[Validation], /
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def validations(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[Validation, Validation.Builder]],
                GenericListBuilder[Validation, Validation.Builder] | List[Validation],
            ],
            /,
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def validations(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[Validation.Builder]: ...

        def validations(self, value_or_callback=None, /):
            """
            Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[Validation.Builder]()
                context._parent_builder = self
                context._field_name = "validations"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Validation.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("validations", value)

        @overload
        def variables(
            self, value_or_callback: List[Variable], /
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def variables(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[Variable, Variable.Builder]],
                GenericListBuilder[Variable, Variable.Builder] | List[Variable],
            ],
            /,
        ) -> "ValidatingAdmissionPolicySpec.Builder": ...

        @overload
        def variables(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[Variable.Builder]: ...

        def variables(self, value_or_callback=None, /):
            """
            Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.

            The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[Variable.Builder]()
                context._parent_builder = self
                context._field_name = "variables"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Variable.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("variables", value)

    class BuilderContext(BuilderContextBase["ValidatingAdmissionPolicySpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ValidatingAdmissionPolicySpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ValidatingAdmissionPolicySpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ValidatingAdmissionPolicySpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ValidatingAdmissionPolicySpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    audit_annotations: Annotated[
        Optional[List[AuditAnnotation]], Field(alias="auditAnnotations")
    ] = None
    """
    auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
    """
    failure_policy: Annotated[Optional[str], Field(alias="failurePolicy")] = None
    """
    failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.

    A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.

    failurePolicy does not define how validations that evaluate to false are handled.

    When failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.

    Allowed values are Ignore or Fail. Defaults to Fail.
    """
    match_conditions: Annotated[Optional[List[MatchCondition]], Field(alias="matchConditions")] = (
        None
    )
    """
    MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.

    If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.

    The exact matching logic is (in order):
      1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
      2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
      3. If any matchCondition evaluates to an error (but none are FALSE):
         - If failurePolicy=Fail, reject the request
         - If failurePolicy=Ignore, the policy is skipped
    """
    match_constraints: Annotated[Optional[MatchResources], Field(alias="matchConstraints")] = None
    """
    MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
    """
    param_kind: Annotated[Optional[ParamKind], Field(alias="paramKind")] = None
    """
    ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
    """
    validations: Optional[List[Validation]] = None
    """
    Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.
    """
    variables: Optional[List[Variable]] = None
    """
    Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.

    The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
    """


class ValidatingAdmissionPolicyStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ValidatingAdmissionPolicyStatus"]:
            return ValidatingAdmissionPolicyStatus

        def build(self) -> "ValidatingAdmissionPolicyStatus":
            return ValidatingAdmissionPolicyStatus(**self._attrs)

        @overload
        def conditions(
            self, value_or_callback: List[apimachinery.Condition], /
        ) -> "ValidatingAdmissionPolicyStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[apimachinery.Condition, apimachinery.Condition.Builder]],
                GenericListBuilder[apimachinery.Condition, apimachinery.Condition.Builder]
                | List[apimachinery.Condition],
            ],
            /,
        ) -> "ValidatingAdmissionPolicyStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[apimachinery.Condition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            The conditions represent the latest available observations of a policy's current state.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[apimachinery.Condition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Condition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def observed_generation(self, value: Optional[int], /) -> Self:
            """
            The generation observed by the controller.
            """
            return self._set("observed_generation", value)

        @overload
        def type_checking(
            self, value_or_callback: Optional[TypeChecking], /
        ) -> "ValidatingAdmissionPolicyStatus.Builder": ...

        @overload
        def type_checking(
            self,
            value_or_callback: Callable[
                [TypeChecking.Builder], TypeChecking.Builder | TypeChecking
            ],
            /,
        ) -> "ValidatingAdmissionPolicyStatus.Builder": ...

        @overload
        def type_checking(
            self, value_or_callback: Never = ...
        ) -> "TypeChecking.BuilderContext": ...

        def type_checking(self, value_or_callback=None, /):
            """
            The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
            """
            if self._in_context and value_or_callback is None:
                context = TypeChecking.BuilderContext()
                context._parent_builder = self
                context._field_name = "type_checking"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TypeChecking.builder())
                if isinstance(output, TypeChecking.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("type_checking", value)

    class BuilderContext(BuilderContextBase["ValidatingAdmissionPolicyStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ValidatingAdmissionPolicyStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ValidatingAdmissionPolicyStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ValidatingAdmissionPolicyStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ValidatingAdmissionPolicyStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conditions: Optional[List[apimachinery.Condition]] = None
    """
    The conditions represent the latest available observations of a policy's current state.
    """
    observed_generation: Annotated[Optional[int], Field(alias="observedGeneration")] = None
    """
    The generation observed by the controller.
    """
    type_checking: Annotated[Optional[TypeChecking], Field(alias="typeChecking")] = None
    """
    The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
    """


class ValidatingAdmissionPolicy(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ValidatingAdmissionPolicy"]:
            return ValidatingAdmissionPolicy

        def build(self) -> "ValidatingAdmissionPolicy":
            return ValidatingAdmissionPolicy(**self._attrs)

        def api_version(
            self, value: Optional[Literal["admissionregistration.k8s.io/v1alpha1"]], /
        ) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ValidatingAdmissionPolicy"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ValidatingAdmissionPolicy.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ValidatingAdmissionPolicy.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[ValidatingAdmissionPolicySpec], /
        ) -> "ValidatingAdmissionPolicy.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [ValidatingAdmissionPolicySpec.Builder],
                ValidatingAdmissionPolicySpec.Builder | ValidatingAdmissionPolicySpec,
            ],
            /,
        ) -> "ValidatingAdmissionPolicy.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "ValidatingAdmissionPolicySpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Specification of the desired behavior of the ValidatingAdmissionPolicy.
            """
            if self._in_context and value_or_callback is None:
                context = ValidatingAdmissionPolicySpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ValidatingAdmissionPolicySpec.builder())
                if isinstance(output, ValidatingAdmissionPolicySpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[ValidatingAdmissionPolicyStatus], /
        ) -> "ValidatingAdmissionPolicy.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [ValidatingAdmissionPolicyStatus.Builder],
                ValidatingAdmissionPolicyStatus.Builder | ValidatingAdmissionPolicyStatus,
            ],
            /,
        ) -> "ValidatingAdmissionPolicy.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "ValidatingAdmissionPolicyStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.
            """
            if self._in_context and value_or_callback is None:
                context = ValidatingAdmissionPolicyStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ValidatingAdmissionPolicyStatus.builder())
                if isinstance(output, ValidatingAdmissionPolicyStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["ValidatingAdmissionPolicy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ValidatingAdmissionPolicy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ValidatingAdmissionPolicy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ValidatingAdmissionPolicy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ValidatingAdmissionPolicy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["admissionregistration.k8s.io/v1alpha1"]],
        Field(alias="apiVersion"),
    ] = "admissionregistration.k8s.io/v1alpha1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ValidatingAdmissionPolicy"]] = "ValidatingAdmissionPolicy"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
    """
    spec: Optional[ValidatingAdmissionPolicySpec] = None
    """
    Specification of the desired behavior of the ValidatingAdmissionPolicy.
    """
    status: Optional[ValidatingAdmissionPolicyStatus] = None
    """
    The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.
    """


class ValidatingAdmissionPolicyBinding(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ValidatingAdmissionPolicyBinding"]:
            return ValidatingAdmissionPolicyBinding

        def build(self) -> "ValidatingAdmissionPolicyBinding":
            return ValidatingAdmissionPolicyBinding(**self._attrs)

        def api_version(
            self, value: Optional[Literal["admissionregistration.k8s.io/v1alpha1"]], /
        ) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ValidatingAdmissionPolicyBinding"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ValidatingAdmissionPolicyBinding.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ValidatingAdmissionPolicyBinding.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[ValidatingAdmissionPolicyBindingSpec], /
        ) -> "ValidatingAdmissionPolicyBinding.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [ValidatingAdmissionPolicyBindingSpec.Builder],
                ValidatingAdmissionPolicyBindingSpec.Builder | ValidatingAdmissionPolicyBindingSpec,
            ],
            /,
        ) -> "ValidatingAdmissionPolicyBinding.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "ValidatingAdmissionPolicyBindingSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.
            """
            if self._in_context and value_or_callback is None:
                context = ValidatingAdmissionPolicyBindingSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ValidatingAdmissionPolicyBindingSpec.builder())
                if isinstance(output, ValidatingAdmissionPolicyBindingSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["ValidatingAdmissionPolicyBinding.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ValidatingAdmissionPolicyBinding.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ValidatingAdmissionPolicyBinding."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ValidatingAdmissionPolicyBinding", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ValidatingAdmissionPolicyBinding.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["admissionregistration.k8s.io/v1alpha1"]],
        Field(alias="apiVersion"),
    ] = "admissionregistration.k8s.io/v1alpha1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ValidatingAdmissionPolicyBinding"]] = "ValidatingAdmissionPolicyBinding"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
    """
    spec: Optional[ValidatingAdmissionPolicyBindingSpec] = None
    """
    Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.
    """


ValidatingAdmissionPolicyBindingList = ResourceList["ValidatingAdmissionPolicyBinding"]


ValidatingAdmissionPolicyList = ResourceList["ValidatingAdmissionPolicy"]
