import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagCategoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Object types to which this category's tags can be attached. Valid types include: Folder, ClusterComputeResource, Datacenter, Datastore, StoragePod, DistributedVirtualPortgroup, DistributedVirtualSwitch, VmwareDistributedVirtualSwitch, HostSystem, com.vmware.content.Library, com.vmware.content.library.Item, HostNetwork, Network, OpaqueNetwork, ResourcePool, VirtualApp, VirtualMachine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/tag_category#associable_types TagCategory#associable_types}
    */
    readonly associableTypes: string[];
    /**
    * The associated cardinality of the category. Can be one of SINGLE (object can only be assigned one tag in this category) or MULTIPLE (object can be assigned multiple tags in this category).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/tag_category#cardinality TagCategory#cardinality}
    */
    readonly cardinality: string;
    /**
    * The description of the category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/tag_category#description TagCategory#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/tag_category#id TagCategory#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The display name of the category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/tag_category#name TagCategory#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/tag_category vsphere_tag_category}
*/
export declare class TagCategory extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_tag_category";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/tag_category vsphere_tag_category} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TagCategoryConfig
    */
    constructor(scope: Construct, id: string, config: TagCategoryConfig);
    private _associableTypes?;
    get associableTypes(): string[];
    set associableTypes(value: string[]);
    get associableTypesInput(): string[] | undefined;
    private _cardinality?;
    get cardinality(): string;
    set cardinality(value: string);
    get cardinalityInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
