import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/role#description DataVsphereRole#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/role#id DataVsphereRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The display label of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/role#label DataVsphereRole#label}
    */
    readonly label: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/role#name DataVsphereRole#name}
    */
    readonly name?: string;
    /**
    * Privileges to be associated with the role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/role#role_privileges DataVsphereRole#role_privileges}
    */
    readonly rolePrivileges?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/role vsphere_role}
*/
export declare class DataVsphereRole extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/role vsphere_role} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereRoleConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereRoleConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _rolePrivileges?;
    get rolePrivileges(): string[];
    set rolePrivileges(value: string[]);
    resetRolePrivileges(): void;
    get rolePrivilegesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
