"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeCluster = exports.ComputeClusterVsanDiskGroupList = exports.ComputeClusterVsanDiskGroupOutputReference = exports.computeClusterVsanDiskGroupToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function computeClusterVsanDiskGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cache: cdktf.stringToTerraform(struct.cache),
        storage: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.storage),
    };
}
exports.computeClusterVsanDiskGroupToTerraform = computeClusterVsanDiskGroupToTerraform;
class ComputeClusterVsanDiskGroupOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cache !== undefined) {
            hasAnyValues = true;
            internalValueResult.cache = this._cache;
        }
        if (this._storage !== undefined) {
            hasAnyValues = true;
            internalValueResult.storage = this._storage;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._cache = undefined;
            this._storage = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._cache = value.cache;
            this._storage = value.storage;
        }
    }
    get cache() {
        return this.getStringAttribute('cache');
    }
    set cache(value) {
        this._cache = value;
    }
    resetCache() {
        this._cache = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacheInput() {
        return this._cache;
    }
    get storage() {
        return cdktf.Fn.tolist(this.getListAttribute('storage'));
    }
    set storage(value) {
        this._storage = value;
    }
    resetStorage() {
        this._storage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageInput() {
        return this._storage;
    }
}
exports.ComputeClusterVsanDiskGroupOutputReference = ComputeClusterVsanDiskGroupOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupOutputReference", version: "0.0.2" };
class ComputeClusterVsanDiskGroupList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanDiskGroupOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanDiskGroupList = ComputeClusterVsanDiskGroupList;
_b = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupList[_b] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupList", version: "0.0.2" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster vsphere_compute_cluster}
*/
class ComputeCluster extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster vsphere_compute_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_compute_cluster',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.2.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // vsan_disk_group - computed: false, optional: true, required: false
        this._vsanDiskGroup = new ComputeClusterVsanDiskGroupList(this, "vsan_disk_group", false);
        this._customAttributes = config.customAttributes;
        this._datacenterId = config.datacenterId;
        this._dpmAutomationLevel = config.dpmAutomationLevel;
        this._dpmEnabled = config.dpmEnabled;
        this._dpmThreshold = config.dpmThreshold;
        this._drsAdvancedOptions = config.drsAdvancedOptions;
        this._drsAutomationLevel = config.drsAutomationLevel;
        this._drsEnablePredictiveDrs = config.drsEnablePredictiveDrs;
        this._drsEnableVmOverrides = config.drsEnableVmOverrides;
        this._drsEnabled = config.drsEnabled;
        this._drsMigrationThreshold = config.drsMigrationThreshold;
        this._drsScaleDescendantsShares = config.drsScaleDescendantsShares;
        this._folder = config.folder;
        this._forceEvacuateOnDestroy = config.forceEvacuateOnDestroy;
        this._haAdmissionControlFailoverHostSystemIds = config.haAdmissionControlFailoverHostSystemIds;
        this._haAdmissionControlHostFailureTolerance = config.haAdmissionControlHostFailureTolerance;
        this._haAdmissionControlPerformanceTolerance = config.haAdmissionControlPerformanceTolerance;
        this._haAdmissionControlPolicy = config.haAdmissionControlPolicy;
        this._haAdmissionControlResourcePercentageAutoCompute = config.haAdmissionControlResourcePercentageAutoCompute;
        this._haAdmissionControlResourcePercentageCpu = config.haAdmissionControlResourcePercentageCpu;
        this._haAdmissionControlResourcePercentageMemory = config.haAdmissionControlResourcePercentageMemory;
        this._haAdmissionControlSlotPolicyExplicitCpu = config.haAdmissionControlSlotPolicyExplicitCpu;
        this._haAdmissionControlSlotPolicyExplicitMemory = config.haAdmissionControlSlotPolicyExplicitMemory;
        this._haAdmissionControlSlotPolicyUseExplicitSize = config.haAdmissionControlSlotPolicyUseExplicitSize;
        this._haAdvancedOptions = config.haAdvancedOptions;
        this._haDatastoreApdRecoveryAction = config.haDatastoreApdRecoveryAction;
        this._haDatastoreApdResponse = config.haDatastoreApdResponse;
        this._haDatastoreApdResponseDelay = config.haDatastoreApdResponseDelay;
        this._haDatastorePdlResponse = config.haDatastorePdlResponse;
        this._haEnabled = config.haEnabled;
        this._haHeartbeatDatastoreIds = config.haHeartbeatDatastoreIds;
        this._haHeartbeatDatastorePolicy = config.haHeartbeatDatastorePolicy;
        this._haHostIsolationResponse = config.haHostIsolationResponse;
        this._haHostMonitoring = config.haHostMonitoring;
        this._haVmComponentProtection = config.haVmComponentProtection;
        this._haVmDependencyRestartCondition = config.haVmDependencyRestartCondition;
        this._haVmFailureInterval = config.haVmFailureInterval;
        this._haVmMaximumFailureWindow = config.haVmMaximumFailureWindow;
        this._haVmMaximumResets = config.haVmMaximumResets;
        this._haVmMinimumUptime = config.haVmMinimumUptime;
        this._haVmMonitoring = config.haVmMonitoring;
        this._haVmRestartAdditionalDelay = config.haVmRestartAdditionalDelay;
        this._haVmRestartPriority = config.haVmRestartPriority;
        this._haVmRestartTimeout = config.haVmRestartTimeout;
        this._hostClusterExitTimeout = config.hostClusterExitTimeout;
        this._hostManaged = config.hostManaged;
        this._hostSystemIds = config.hostSystemIds;
        this._id = config.id;
        this._name = config.name;
        this._proactiveHaAutomationLevel = config.proactiveHaAutomationLevel;
        this._proactiveHaEnabled = config.proactiveHaEnabled;
        this._proactiveHaModerateRemediation = config.proactiveHaModerateRemediation;
        this._proactiveHaProviderIds = config.proactiveHaProviderIds;
        this._proactiveHaSevereRemediation = config.proactiveHaSevereRemediation;
        this._tags = config.tags;
        this._vsanEnabled = config.vsanEnabled;
        this._vsanDiskGroup.internalValue = config.vsanDiskGroup;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    get dpmAutomationLevel() {
        return this.getStringAttribute('dpm_automation_level');
    }
    set dpmAutomationLevel(value) {
        this._dpmAutomationLevel = value;
    }
    resetDpmAutomationLevel() {
        this._dpmAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmAutomationLevelInput() {
        return this._dpmAutomationLevel;
    }
    get dpmEnabled() {
        return this.getBooleanAttribute('dpm_enabled');
    }
    set dpmEnabled(value) {
        this._dpmEnabled = value;
    }
    resetDpmEnabled() {
        this._dpmEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmEnabledInput() {
        return this._dpmEnabled;
    }
    get dpmThreshold() {
        return this.getNumberAttribute('dpm_threshold');
    }
    set dpmThreshold(value) {
        this._dpmThreshold = value;
    }
    resetDpmThreshold() {
        this._dpmThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmThresholdInput() {
        return this._dpmThreshold;
    }
    get drsAdvancedOptions() {
        return this.getStringMapAttribute('drs_advanced_options');
    }
    set drsAdvancedOptions(value) {
        this._drsAdvancedOptions = value;
    }
    resetDrsAdvancedOptions() {
        this._drsAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAdvancedOptionsInput() {
        return this._drsAdvancedOptions;
    }
    get drsAutomationLevel() {
        return this.getStringAttribute('drs_automation_level');
    }
    set drsAutomationLevel(value) {
        this._drsAutomationLevel = value;
    }
    resetDrsAutomationLevel() {
        this._drsAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAutomationLevelInput() {
        return this._drsAutomationLevel;
    }
    get drsEnablePredictiveDrs() {
        return this.getBooleanAttribute('drs_enable_predictive_drs');
    }
    set drsEnablePredictiveDrs(value) {
        this._drsEnablePredictiveDrs = value;
    }
    resetDrsEnablePredictiveDrs() {
        this._drsEnablePredictiveDrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnablePredictiveDrsInput() {
        return this._drsEnablePredictiveDrs;
    }
    get drsEnableVmOverrides() {
        return this.getBooleanAttribute('drs_enable_vm_overrides');
    }
    set drsEnableVmOverrides(value) {
        this._drsEnableVmOverrides = value;
    }
    resetDrsEnableVmOverrides() {
        this._drsEnableVmOverrides = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnableVmOverridesInput() {
        return this._drsEnableVmOverrides;
    }
    get drsEnabled() {
        return this.getBooleanAttribute('drs_enabled');
    }
    set drsEnabled(value) {
        this._drsEnabled = value;
    }
    resetDrsEnabled() {
        this._drsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnabledInput() {
        return this._drsEnabled;
    }
    get drsMigrationThreshold() {
        return this.getNumberAttribute('drs_migration_threshold');
    }
    set drsMigrationThreshold(value) {
        this._drsMigrationThreshold = value;
    }
    resetDrsMigrationThreshold() {
        this._drsMigrationThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsMigrationThresholdInput() {
        return this._drsMigrationThreshold;
    }
    get drsScaleDescendantsShares() {
        return this.getStringAttribute('drs_scale_descendants_shares');
    }
    set drsScaleDescendantsShares(value) {
        this._drsScaleDescendantsShares = value;
    }
    resetDrsScaleDescendantsShares() {
        this._drsScaleDescendantsShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsScaleDescendantsSharesInput() {
        return this._drsScaleDescendantsShares;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get forceEvacuateOnDestroy() {
        return this.getBooleanAttribute('force_evacuate_on_destroy');
    }
    set forceEvacuateOnDestroy(value) {
        this._forceEvacuateOnDestroy = value;
    }
    resetForceEvacuateOnDestroy() {
        this._forceEvacuateOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forceEvacuateOnDestroyInput() {
        return this._forceEvacuateOnDestroy;
    }
    get haAdmissionControlFailoverHostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_admission_control_failover_host_system_ids'));
    }
    set haAdmissionControlFailoverHostSystemIds(value) {
        this._haAdmissionControlFailoverHostSystemIds = value;
    }
    resetHaAdmissionControlFailoverHostSystemIds() {
        this._haAdmissionControlFailoverHostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlFailoverHostSystemIdsInput() {
        return this._haAdmissionControlFailoverHostSystemIds;
    }
    get haAdmissionControlHostFailureTolerance() {
        return this.getNumberAttribute('ha_admission_control_host_failure_tolerance');
    }
    set haAdmissionControlHostFailureTolerance(value) {
        this._haAdmissionControlHostFailureTolerance = value;
    }
    resetHaAdmissionControlHostFailureTolerance() {
        this._haAdmissionControlHostFailureTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlHostFailureToleranceInput() {
        return this._haAdmissionControlHostFailureTolerance;
    }
    get haAdmissionControlPerformanceTolerance() {
        return this.getNumberAttribute('ha_admission_control_performance_tolerance');
    }
    set haAdmissionControlPerformanceTolerance(value) {
        this._haAdmissionControlPerformanceTolerance = value;
    }
    resetHaAdmissionControlPerformanceTolerance() {
        this._haAdmissionControlPerformanceTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPerformanceToleranceInput() {
        return this._haAdmissionControlPerformanceTolerance;
    }
    get haAdmissionControlPolicy() {
        return this.getStringAttribute('ha_admission_control_policy');
    }
    set haAdmissionControlPolicy(value) {
        this._haAdmissionControlPolicy = value;
    }
    resetHaAdmissionControlPolicy() {
        this._haAdmissionControlPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPolicyInput() {
        return this._haAdmissionControlPolicy;
    }
    get haAdmissionControlResourcePercentageAutoCompute() {
        return this.getBooleanAttribute('ha_admission_control_resource_percentage_auto_compute');
    }
    set haAdmissionControlResourcePercentageAutoCompute(value) {
        this._haAdmissionControlResourcePercentageAutoCompute = value;
    }
    resetHaAdmissionControlResourcePercentageAutoCompute() {
        this._haAdmissionControlResourcePercentageAutoCompute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageAutoComputeInput() {
        return this._haAdmissionControlResourcePercentageAutoCompute;
    }
    get haAdmissionControlResourcePercentageCpu() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_cpu');
    }
    set haAdmissionControlResourcePercentageCpu(value) {
        this._haAdmissionControlResourcePercentageCpu = value;
    }
    resetHaAdmissionControlResourcePercentageCpu() {
        this._haAdmissionControlResourcePercentageCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageCpuInput() {
        return this._haAdmissionControlResourcePercentageCpu;
    }
    get haAdmissionControlResourcePercentageMemory() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_memory');
    }
    set haAdmissionControlResourcePercentageMemory(value) {
        this._haAdmissionControlResourcePercentageMemory = value;
    }
    resetHaAdmissionControlResourcePercentageMemory() {
        this._haAdmissionControlResourcePercentageMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageMemoryInput() {
        return this._haAdmissionControlResourcePercentageMemory;
    }
    get haAdmissionControlSlotPolicyExplicitCpu() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_cpu');
    }
    set haAdmissionControlSlotPolicyExplicitCpu(value) {
        this._haAdmissionControlSlotPolicyExplicitCpu = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitCpu() {
        this._haAdmissionControlSlotPolicyExplicitCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitCpuInput() {
        return this._haAdmissionControlSlotPolicyExplicitCpu;
    }
    get haAdmissionControlSlotPolicyExplicitMemory() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_memory');
    }
    set haAdmissionControlSlotPolicyExplicitMemory(value) {
        this._haAdmissionControlSlotPolicyExplicitMemory = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitMemory() {
        this._haAdmissionControlSlotPolicyExplicitMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitMemoryInput() {
        return this._haAdmissionControlSlotPolicyExplicitMemory;
    }
    get haAdmissionControlSlotPolicyUseExplicitSize() {
        return this.getBooleanAttribute('ha_admission_control_slot_policy_use_explicit_size');
    }
    set haAdmissionControlSlotPolicyUseExplicitSize(value) {
        this._haAdmissionControlSlotPolicyUseExplicitSize = value;
    }
    resetHaAdmissionControlSlotPolicyUseExplicitSize() {
        this._haAdmissionControlSlotPolicyUseExplicitSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyUseExplicitSizeInput() {
        return this._haAdmissionControlSlotPolicyUseExplicitSize;
    }
    get haAdvancedOptions() {
        return this.getStringMapAttribute('ha_advanced_options');
    }
    set haAdvancedOptions(value) {
        this._haAdvancedOptions = value;
    }
    resetHaAdvancedOptions() {
        this._haAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdvancedOptionsInput() {
        return this._haAdvancedOptions;
    }
    get haDatastoreApdRecoveryAction() {
        return this.getStringAttribute('ha_datastore_apd_recovery_action');
    }
    set haDatastoreApdRecoveryAction(value) {
        this._haDatastoreApdRecoveryAction = value;
    }
    resetHaDatastoreApdRecoveryAction() {
        this._haDatastoreApdRecoveryAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdRecoveryActionInput() {
        return this._haDatastoreApdRecoveryAction;
    }
    get haDatastoreApdResponse() {
        return this.getStringAttribute('ha_datastore_apd_response');
    }
    set haDatastoreApdResponse(value) {
        this._haDatastoreApdResponse = value;
    }
    resetHaDatastoreApdResponse() {
        this._haDatastoreApdResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseInput() {
        return this._haDatastoreApdResponse;
    }
    get haDatastoreApdResponseDelay() {
        return this.getNumberAttribute('ha_datastore_apd_response_delay');
    }
    set haDatastoreApdResponseDelay(value) {
        this._haDatastoreApdResponseDelay = value;
    }
    resetHaDatastoreApdResponseDelay() {
        this._haDatastoreApdResponseDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseDelayInput() {
        return this._haDatastoreApdResponseDelay;
    }
    get haDatastorePdlResponse() {
        return this.getStringAttribute('ha_datastore_pdl_response');
    }
    set haDatastorePdlResponse(value) {
        this._haDatastorePdlResponse = value;
    }
    resetHaDatastorePdlResponse() {
        this._haDatastorePdlResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastorePdlResponseInput() {
        return this._haDatastorePdlResponse;
    }
    get haEnabled() {
        return this.getBooleanAttribute('ha_enabled');
    }
    set haEnabled(value) {
        this._haEnabled = value;
    }
    resetHaEnabled() {
        this._haEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haEnabledInput() {
        return this._haEnabled;
    }
    get haHeartbeatDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_heartbeat_datastore_ids'));
    }
    set haHeartbeatDatastoreIds(value) {
        this._haHeartbeatDatastoreIds = value;
    }
    resetHaHeartbeatDatastoreIds() {
        this._haHeartbeatDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastoreIdsInput() {
        return this._haHeartbeatDatastoreIds;
    }
    get haHeartbeatDatastorePolicy() {
        return this.getStringAttribute('ha_heartbeat_datastore_policy');
    }
    set haHeartbeatDatastorePolicy(value) {
        this._haHeartbeatDatastorePolicy = value;
    }
    resetHaHeartbeatDatastorePolicy() {
        this._haHeartbeatDatastorePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastorePolicyInput() {
        return this._haHeartbeatDatastorePolicy;
    }
    get haHostIsolationResponse() {
        return this.getStringAttribute('ha_host_isolation_response');
    }
    set haHostIsolationResponse(value) {
        this._haHostIsolationResponse = value;
    }
    resetHaHostIsolationResponse() {
        this._haHostIsolationResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostIsolationResponseInput() {
        return this._haHostIsolationResponse;
    }
    get haHostMonitoring() {
        return this.getStringAttribute('ha_host_monitoring');
    }
    set haHostMonitoring(value) {
        this._haHostMonitoring = value;
    }
    resetHaHostMonitoring() {
        this._haHostMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostMonitoringInput() {
        return this._haHostMonitoring;
    }
    get haVmComponentProtection() {
        return this.getStringAttribute('ha_vm_component_protection');
    }
    set haVmComponentProtection(value) {
        this._haVmComponentProtection = value;
    }
    resetHaVmComponentProtection() {
        this._haVmComponentProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmComponentProtectionInput() {
        return this._haVmComponentProtection;
    }
    get haVmDependencyRestartCondition() {
        return this.getStringAttribute('ha_vm_dependency_restart_condition');
    }
    set haVmDependencyRestartCondition(value) {
        this._haVmDependencyRestartCondition = value;
    }
    resetHaVmDependencyRestartCondition() {
        this._haVmDependencyRestartCondition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmDependencyRestartConditionInput() {
        return this._haVmDependencyRestartCondition;
    }
    get haVmFailureInterval() {
        return this.getNumberAttribute('ha_vm_failure_interval');
    }
    set haVmFailureInterval(value) {
        this._haVmFailureInterval = value;
    }
    resetHaVmFailureInterval() {
        this._haVmFailureInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmFailureIntervalInput() {
        return this._haVmFailureInterval;
    }
    get haVmMaximumFailureWindow() {
        return this.getNumberAttribute('ha_vm_maximum_failure_window');
    }
    set haVmMaximumFailureWindow(value) {
        this._haVmMaximumFailureWindow = value;
    }
    resetHaVmMaximumFailureWindow() {
        this._haVmMaximumFailureWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumFailureWindowInput() {
        return this._haVmMaximumFailureWindow;
    }
    get haVmMaximumResets() {
        return this.getNumberAttribute('ha_vm_maximum_resets');
    }
    set haVmMaximumResets(value) {
        this._haVmMaximumResets = value;
    }
    resetHaVmMaximumResets() {
        this._haVmMaximumResets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumResetsInput() {
        return this._haVmMaximumResets;
    }
    get haVmMinimumUptime() {
        return this.getNumberAttribute('ha_vm_minimum_uptime');
    }
    set haVmMinimumUptime(value) {
        this._haVmMinimumUptime = value;
    }
    resetHaVmMinimumUptime() {
        this._haVmMinimumUptime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMinimumUptimeInput() {
        return this._haVmMinimumUptime;
    }
    get haVmMonitoring() {
        return this.getStringAttribute('ha_vm_monitoring');
    }
    set haVmMonitoring(value) {
        this._haVmMonitoring = value;
    }
    resetHaVmMonitoring() {
        this._haVmMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMonitoringInput() {
        return this._haVmMonitoring;
    }
    get haVmRestartAdditionalDelay() {
        return this.getNumberAttribute('ha_vm_restart_additional_delay');
    }
    set haVmRestartAdditionalDelay(value) {
        this._haVmRestartAdditionalDelay = value;
    }
    resetHaVmRestartAdditionalDelay() {
        this._haVmRestartAdditionalDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartAdditionalDelayInput() {
        return this._haVmRestartAdditionalDelay;
    }
    get haVmRestartPriority() {
        return this.getStringAttribute('ha_vm_restart_priority');
    }
    set haVmRestartPriority(value) {
        this._haVmRestartPriority = value;
    }
    resetHaVmRestartPriority() {
        this._haVmRestartPriority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartPriorityInput() {
        return this._haVmRestartPriority;
    }
    get haVmRestartTimeout() {
        return this.getNumberAttribute('ha_vm_restart_timeout');
    }
    set haVmRestartTimeout(value) {
        this._haVmRestartTimeout = value;
    }
    resetHaVmRestartTimeout() {
        this._haVmRestartTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartTimeoutInput() {
        return this._haVmRestartTimeout;
    }
    get hostClusterExitTimeout() {
        return this.getNumberAttribute('host_cluster_exit_timeout');
    }
    set hostClusterExitTimeout(value) {
        this._hostClusterExitTimeout = value;
    }
    resetHostClusterExitTimeout() {
        this._hostClusterExitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostClusterExitTimeoutInput() {
        return this._hostClusterExitTimeout;
    }
    get hostManaged() {
        return this.getBooleanAttribute('host_managed');
    }
    set hostManaged(value) {
        this._hostManaged = value;
    }
    resetHostManaged() {
        this._hostManaged = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostManagedInput() {
        return this._hostManaged;
    }
    get hostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('host_system_ids'));
    }
    set hostSystemIds(value) {
        this._hostSystemIds = value;
    }
    resetHostSystemIds() {
        this._hostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostSystemIdsInput() {
        return this._hostSystemIds;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get proactiveHaAutomationLevel() {
        return this.getStringAttribute('proactive_ha_automation_level');
    }
    set proactiveHaAutomationLevel(value) {
        this._proactiveHaAutomationLevel = value;
    }
    resetProactiveHaAutomationLevel() {
        this._proactiveHaAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaAutomationLevelInput() {
        return this._proactiveHaAutomationLevel;
    }
    get proactiveHaEnabled() {
        return this.getBooleanAttribute('proactive_ha_enabled');
    }
    set proactiveHaEnabled(value) {
        this._proactiveHaEnabled = value;
    }
    resetProactiveHaEnabled() {
        this._proactiveHaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaEnabledInput() {
        return this._proactiveHaEnabled;
    }
    get proactiveHaModerateRemediation() {
        return this.getStringAttribute('proactive_ha_moderate_remediation');
    }
    set proactiveHaModerateRemediation(value) {
        this._proactiveHaModerateRemediation = value;
    }
    resetProactiveHaModerateRemediation() {
        this._proactiveHaModerateRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaModerateRemediationInput() {
        return this._proactiveHaModerateRemediation;
    }
    get proactiveHaProviderIds() {
        return cdktf.Fn.tolist(this.getListAttribute('proactive_ha_provider_ids'));
    }
    set proactiveHaProviderIds(value) {
        this._proactiveHaProviderIds = value;
    }
    resetProactiveHaProviderIds() {
        this._proactiveHaProviderIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaProviderIdsInput() {
        return this._proactiveHaProviderIds;
    }
    get proactiveHaSevereRemediation() {
        return this.getStringAttribute('proactive_ha_severe_remediation');
    }
    set proactiveHaSevereRemediation(value) {
        this._proactiveHaSevereRemediation = value;
    }
    resetProactiveHaSevereRemediation() {
        this._proactiveHaSevereRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaSevereRemediationInput() {
        return this._proactiveHaSevereRemediation;
    }
    // resource_pool_id - computed: true, optional: false, required: false
    get resourcePoolId() {
        return this.getStringAttribute('resource_pool_id');
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get vsanEnabled() {
        return this.getBooleanAttribute('vsan_enabled');
    }
    set vsanEnabled(value) {
        this._vsanEnabled = value;
    }
    resetVsanEnabled() {
        this._vsanEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanEnabledInput() {
        return this._vsanEnabled;
    }
    get vsanDiskGroup() {
        return this._vsanDiskGroup;
    }
    putVsanDiskGroup(value) {
        this._vsanDiskGroup.internalValue = value;
    }
    resetVsanDiskGroup() {
        this._vsanDiskGroup.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDiskGroupInput() {
        return this._vsanDiskGroup.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            dpm_automation_level: cdktf.stringToTerraform(this._dpmAutomationLevel),
            dpm_enabled: cdktf.booleanToTerraform(this._dpmEnabled),
            dpm_threshold: cdktf.numberToTerraform(this._dpmThreshold),
            drs_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._drsAdvancedOptions),
            drs_automation_level: cdktf.stringToTerraform(this._drsAutomationLevel),
            drs_enable_predictive_drs: cdktf.booleanToTerraform(this._drsEnablePredictiveDrs),
            drs_enable_vm_overrides: cdktf.booleanToTerraform(this._drsEnableVmOverrides),
            drs_enabled: cdktf.booleanToTerraform(this._drsEnabled),
            drs_migration_threshold: cdktf.numberToTerraform(this._drsMigrationThreshold),
            drs_scale_descendants_shares: cdktf.stringToTerraform(this._drsScaleDescendantsShares),
            folder: cdktf.stringToTerraform(this._folder),
            force_evacuate_on_destroy: cdktf.booleanToTerraform(this._forceEvacuateOnDestroy),
            ha_admission_control_failover_host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haAdmissionControlFailoverHostSystemIds),
            ha_admission_control_host_failure_tolerance: cdktf.numberToTerraform(this._haAdmissionControlHostFailureTolerance),
            ha_admission_control_performance_tolerance: cdktf.numberToTerraform(this._haAdmissionControlPerformanceTolerance),
            ha_admission_control_policy: cdktf.stringToTerraform(this._haAdmissionControlPolicy),
            ha_admission_control_resource_percentage_auto_compute: cdktf.booleanToTerraform(this._haAdmissionControlResourcePercentageAutoCompute),
            ha_admission_control_resource_percentage_cpu: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageCpu),
            ha_admission_control_resource_percentage_memory: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageMemory),
            ha_admission_control_slot_policy_explicit_cpu: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitCpu),
            ha_admission_control_slot_policy_explicit_memory: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitMemory),
            ha_admission_control_slot_policy_use_explicit_size: cdktf.booleanToTerraform(this._haAdmissionControlSlotPolicyUseExplicitSize),
            ha_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._haAdvancedOptions),
            ha_datastore_apd_recovery_action: cdktf.stringToTerraform(this._haDatastoreApdRecoveryAction),
            ha_datastore_apd_response: cdktf.stringToTerraform(this._haDatastoreApdResponse),
            ha_datastore_apd_response_delay: cdktf.numberToTerraform(this._haDatastoreApdResponseDelay),
            ha_datastore_pdl_response: cdktf.stringToTerraform(this._haDatastorePdlResponse),
            ha_enabled: cdktf.booleanToTerraform(this._haEnabled),
            ha_heartbeat_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haHeartbeatDatastoreIds),
            ha_heartbeat_datastore_policy: cdktf.stringToTerraform(this._haHeartbeatDatastorePolicy),
            ha_host_isolation_response: cdktf.stringToTerraform(this._haHostIsolationResponse),
            ha_host_monitoring: cdktf.stringToTerraform(this._haHostMonitoring),
            ha_vm_component_protection: cdktf.stringToTerraform(this._haVmComponentProtection),
            ha_vm_dependency_restart_condition: cdktf.stringToTerraform(this._haVmDependencyRestartCondition),
            ha_vm_failure_interval: cdktf.numberToTerraform(this._haVmFailureInterval),
            ha_vm_maximum_failure_window: cdktf.numberToTerraform(this._haVmMaximumFailureWindow),
            ha_vm_maximum_resets: cdktf.numberToTerraform(this._haVmMaximumResets),
            ha_vm_minimum_uptime: cdktf.numberToTerraform(this._haVmMinimumUptime),
            ha_vm_monitoring: cdktf.stringToTerraform(this._haVmMonitoring),
            ha_vm_restart_additional_delay: cdktf.numberToTerraform(this._haVmRestartAdditionalDelay),
            ha_vm_restart_priority: cdktf.stringToTerraform(this._haVmRestartPriority),
            ha_vm_restart_timeout: cdktf.numberToTerraform(this._haVmRestartTimeout),
            host_cluster_exit_timeout: cdktf.numberToTerraform(this._hostClusterExitTimeout),
            host_managed: cdktf.booleanToTerraform(this._hostManaged),
            host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._hostSystemIds),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            proactive_ha_automation_level: cdktf.stringToTerraform(this._proactiveHaAutomationLevel),
            proactive_ha_enabled: cdktf.booleanToTerraform(this._proactiveHaEnabled),
            proactive_ha_moderate_remediation: cdktf.stringToTerraform(this._proactiveHaModerateRemediation),
            proactive_ha_provider_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._proactiveHaProviderIds),
            proactive_ha_severe_remediation: cdktf.stringToTerraform(this._proactiveHaSevereRemediation),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            vsan_enabled: cdktf.booleanToTerraform(this._vsanEnabled),
            vsan_disk_group: cdktf.listMapper(computeClusterVsanDiskGroupToTerraform, true)(this._vsanDiskGroup.internalValue),
        };
    }
}
exports.ComputeCluster = ComputeCluster;
_c = JSII_RTTI_SYMBOL_1;
ComputeCluster[_c] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeCluster", version: "0.0.2" };
// =================
// STATIC PROPERTIES
// =================
ComputeCluster.tfResourceType = "vsphere_compute_cluster";
//# sourceMappingURL=data:application/json;base64,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