import { IReceiptRule } from './receipt-rule';
import { CfnReceiptRule } from './ses.generated';
/**
 * (experimental) An abstract action for a receipt rule.
 *
 * @experimental
 */
export interface IReceiptRuleAction {
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(receiptRule: IReceiptRule): ReceiptRuleActionConfig;
}
/**
 * (experimental) Properties for a receipt rule action.
 *
 * @experimental
 */
export interface ReceiptRuleActionConfig {
    /**
     * (experimental) Adds a header to the received email.
     *
     * @experimental
     */
    readonly addHeaderAction?: CfnReceiptRule.AddHeaderActionProperty;
    /**
     * (experimental) Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly bounceAction?: CfnReceiptRule.BounceActionProperty;
    /**
     * (experimental) Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly lambdaAction?: CfnReceiptRule.LambdaActionProperty;
    /**
     * (experimental) Saves the received message to an Amazon S3 bucket and, optionally, publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly s3Action?: CfnReceiptRule.S3ActionProperty;
    /**
     * (experimental) Publishes the email content within a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly snsAction?: CfnReceiptRule.SNSActionProperty;
    /**
     * (experimental) Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly stopAction?: CfnReceiptRule.StopActionProperty;
    /**
     * (experimental) Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly workmailAction?: CfnReceiptRule.WorkmailActionProperty;
}
