"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const index_1 = require("../lib/index");
const core_1 = require("@aws-cdk/core");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const mockApp = new core_1.App();
const stack = new core_1.Stack(mockApp, 'testing-stack');
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: 'GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    ebsSize: 100,
    blockDuration: index_1.BlockDuration.ONE_HOUR,
    spotFleet: true,
});
runner.expireAfter(core_1.Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFrom(aws_ec2_1.Peer.ipv4('0.0.0.0/0'), aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new core_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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