# coding: utf-8

"""
    LMK API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator
from lmk.generated.models.event_notification_configuration import EventNotificationConfiguration

class EventRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    session_id: Optional[StrictStr] = Field(None, alias="sessionId")
    message: StrictStr = ...
    content_type: Optional[StrictStr] = Field(None, alias="contentType")
    notification_config: Optional[EventNotificationConfiguration] = Field(None, alias="notificationConfig")
    __properties = ["sessionId", "message", "contentType", "notificationConfig"]

    @validator('content_type')
    def content_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('text/plain', 'text/markdown'):
            raise ValueError("must validate the enum values ('text/plain', 'text/markdown')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventRequest:
        """Create an instance of EventRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of notification_config
        if self.notification_config:
            _dict['notificationConfig'] = self.notification_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EventRequest:
        """Create an instance of EventRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EventRequest.parse_obj(obj)

        _obj = EventRequest.parse_obj({
            "session_id": obj.get("sessionId"),
            "message": obj.get("message"),
            "content_type": obj.get("contentType"),
            "notification_config": EventNotificationConfiguration.from_dict(obj.get("notificationConfig")) if obj.get("notificationConfig") is not None else None
        })
        return _obj

