# Collective Mind meta-framework

Collective Mind (CM) is the second generation of the Collective Knowledge meta-framework (CK)
being developed by the [open workgroup](https://github.com/mlcommons/ck/blob/master/docs/mlperf-education-workgroup.md)
to modularize complex AI systems and automate their co-design, benchmarking, 
optimization and deployment across continuously changing software, hardware and data.

[![PyPI version](https://badge.fury.io/py/cmind.svg)](https://pepy.tech/project/cmind)
[![Python Version](https://img.shields.io/badge/python-3+-blue.svg)](https://github.com/mlcommons/ck/tree/master/cm)
[![License](https://img.shields.io/badge/License-Apache%202.0-green)](https://github.com/mlcommons/ck/tree/master/cm)
[![CM(CK2) test](https://github.com/mlcommons/ck/actions/workflows/test-cm.yml/badge.svg)](https://github.com/mlcommons/ck/actions/workflows/test-cm.yml)

&copy; 2022 [MLCommons](https://mlcommons.org)<br>

Apache 2.0 license


*Go to the [project page](https://github.com/mlcommons/ck) for further info*. 


# News

* **2022 September 9:** Subscribe to our [public workgroup](https://github.com/mlcommons/ck/tree/master/docs/mlperf-education-workgroup.md) 
  to participate in the development of automation workflows
  to simplify, modularize and automate ML Systems benchmarking.

* **2022 September 1:** We have developed a CM workflow to automate and modularize 
  [MLPerf inference benchmark](https://github.com/mlcommons/ck/blob/master/docs/mlperf-cm-automation-demo.md).
  We continue these developments within a public [MLPerf education workgroup](https://github.com/mlcommons/ck/tree/master/docs/mlperf-education-workgroup.md).

* **2022 July 25:** We updated tutorial about CM scripts: https://github.com/mlcommons/ck/blob/master/cm/docs/tutorial-scripts.md .

* **2022 July 21:** We have pre-released relatively stable scripts for portable DevOps and MLOps at https://github.com/mlcommons/ck/tree/master/cm-mlops/script .

* **2022 May 20:** We brainstormed the minimal set of [portable CM scripts](https://cknowledge.org/docs/cm/tutorial-scripts.html) to automate deployment of ML models across diverse hardware and software at [OctoML](https://OctoML.ai) in Seattle, WA.

* **2022 April 3:** We presented our approach to bridge the growing gap between ML Systems research and production 
  at the HPCA'22 workshop on [benchmarking deep learning systems](https://sites.google.com/g.harvard.edu/mlperf-bench-hpca22/home).

* **2022 March:** We were invited to present our concept to [enable collaborative and reproducible ML Systems R&D](https://meetings.siam.org/sess/dsp_programsess.cfm?SESSIONCODE=73126) 
  at the SIAM'22 workshop on "Research Challenges and Opportunities within Software Productivity, Sustainability, and Reproducibility"

* **2022 March:** We have released the first prototype of [the Collective Mind toolkit (aka CK2)](https://github.com/mlcommons/ck/tree/master/cm)
  based on your feedback and our practical experience [reproducing 150+ ML and Systems papers and validating them in the real world](https://learning.acm.org/techtalks/reproducibility).
