# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Topic(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Topic - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'published': 'bool',
            'strictness': 'str',
            'programs': 'list[BaseProgramEntity]',
            'tags': 'list[str]',
            'dialect': 'str',
            'participants': 'str',
            'phrases': 'list[Phrase]',
            'modified_by': 'AddressableEntityRef',
            'date_modified': 'datetime',
            'published_by': 'AddressableEntityRef',
            'date_published': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'published': 'published',
            'strictness': 'strictness',
            'programs': 'programs',
            'tags': 'tags',
            'dialect': 'dialect',
            'participants': 'participants',
            'phrases': 'phrases',
            'modified_by': 'modifiedBy',
            'date_modified': 'dateModified',
            'published_by': 'publishedBy',
            'date_published': 'datePublished',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._published = None
        self._strictness = None
        self._programs = None
        self._tags = None
        self._dialect = None
        self._participants = None
        self._phrases = None
        self._modified_by = None
        self._date_modified = None
        self._published_by = None
        self._date_published = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Topic.
        The globally unique identifier for the object.

        :return: The id of this Topic.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Topic.
        The globally unique identifier for the object.

        :param id: The id of this Topic.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Topic.


        :return: The name of this Topic.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Topic.


        :param name: The name of this Topic.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Topic.


        :return: The description of this Topic.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Topic.


        :param description: The description of this Topic.
        :type: str
        """
        
        self._description = description

    @property
    def published(self):
        """
        Gets the published of this Topic.


        :return: The published of this Topic.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this Topic.


        :param published: The published of this Topic.
        :type: bool
        """
        
        self._published = published

    @property
    def strictness(self):
        """
        Gets the strictness of this Topic.


        :return: The strictness of this Topic.
        :rtype: str
        """
        return self._strictness

    @strictness.setter
    def strictness(self, strictness):
        """
        Sets the strictness of this Topic.


        :param strictness: The strictness of this Topic.
        :type: str
        """
        allowed_values = ["1", "55", "65", "72", "85", "90"]
        if strictness.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for strictness -> " + strictness)
            self._strictness = "outdated_sdk_version"
        else:
            self._strictness = strictness

    @property
    def programs(self):
        """
        Gets the programs of this Topic.


        :return: The programs of this Topic.
        :rtype: list[BaseProgramEntity]
        """
        return self._programs

    @programs.setter
    def programs(self, programs):
        """
        Sets the programs of this Topic.


        :param programs: The programs of this Topic.
        :type: list[BaseProgramEntity]
        """
        
        self._programs = programs

    @property
    def tags(self):
        """
        Gets the tags of this Topic.


        :return: The tags of this Topic.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this Topic.


        :param tags: The tags of this Topic.
        :type: list[str]
        """
        
        self._tags = tags

    @property
    def dialect(self):
        """
        Gets the dialect of this Topic.


        :return: The dialect of this Topic.
        :rtype: str
        """
        return self._dialect

    @dialect.setter
    def dialect(self, dialect):
        """
        Sets the dialect of this Topic.


        :param dialect: The dialect of this Topic.
        :type: str
        """
        
        self._dialect = dialect

    @property
    def participants(self):
        """
        Gets the participants of this Topic.


        :return: The participants of this Topic.
        :rtype: str
        """
        return self._participants

    @participants.setter
    def participants(self, participants):
        """
        Sets the participants of this Topic.


        :param participants: The participants of this Topic.
        :type: str
        """
        allowed_values = ["External", "Internal", "All"]
        if participants.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for participants -> " + participants)
            self._participants = "outdated_sdk_version"
        else:
            self._participants = participants

    @property
    def phrases(self):
        """
        Gets the phrases of this Topic.


        :return: The phrases of this Topic.
        :rtype: list[Phrase]
        """
        return self._phrases

    @phrases.setter
    def phrases(self, phrases):
        """
        Sets the phrases of this Topic.


        :param phrases: The phrases of this Topic.
        :type: list[Phrase]
        """
        
        self._phrases = phrases

    @property
    def modified_by(self):
        """
        Gets the modified_by of this Topic.


        :return: The modified_by of this Topic.
        :rtype: AddressableEntityRef
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this Topic.


        :param modified_by: The modified_by of this Topic.
        :type: AddressableEntityRef
        """
        
        self._modified_by = modified_by

    @property
    def date_modified(self):
        """
        Gets the date_modified of this Topic.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this Topic.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this Topic.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this Topic.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def published_by(self):
        """
        Gets the published_by of this Topic.


        :return: The published_by of this Topic.
        :rtype: AddressableEntityRef
        """
        return self._published_by

    @published_by.setter
    def published_by(self, published_by):
        """
        Sets the published_by of this Topic.


        :param published_by: The published_by of this Topic.
        :type: AddressableEntityRef
        """
        
        self._published_by = published_by

    @property
    def date_published(self):
        """
        Gets the date_published of this Topic.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_published of this Topic.
        :rtype: datetime
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published):
        """
        Sets the date_published of this Topic.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_published: The date_published of this Topic.
        :type: datetime
        """
        
        self._date_published = date_published

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Topic.
        The URI for this object

        :return: The self_uri of this Topic.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Topic.
        The URI for this object

        :param self_uri: The self_uri of this Topic.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

