# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class PatchContentPositionProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        PatchContentPositionProperties - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'top': 'str',
            'bottom': 'str',
            'left': 'str',
            'right': 'str'
        }

        self.attribute_map = {
            'top': 'top',
            'bottom': 'bottom',
            'left': 'left',
            'right': 'right'
        }

        self._top = None
        self._bottom = None
        self._left = None
        self._right = None

    @property
    def top(self):
        """
        Gets the top of this PatchContentPositionProperties.
        Top positioning offset.

        :return: The top of this PatchContentPositionProperties.
        :rtype: str
        """
        return self._top

    @top.setter
    def top(self, top):
        """
        Sets the top of this PatchContentPositionProperties.
        Top positioning offset.

        :param top: The top of this PatchContentPositionProperties.
        :type: str
        """
        
        self._top = top

    @property
    def bottom(self):
        """
        Gets the bottom of this PatchContentPositionProperties.
        Bottom positioning offset.

        :return: The bottom of this PatchContentPositionProperties.
        :rtype: str
        """
        return self._bottom

    @bottom.setter
    def bottom(self, bottom):
        """
        Sets the bottom of this PatchContentPositionProperties.
        Bottom positioning offset.

        :param bottom: The bottom of this PatchContentPositionProperties.
        :type: str
        """
        
        self._bottom = bottom

    @property
    def left(self):
        """
        Gets the left of this PatchContentPositionProperties.
        Left positioning offset.

        :return: The left of this PatchContentPositionProperties.
        :rtype: str
        """
        return self._left

    @left.setter
    def left(self, left):
        """
        Sets the left of this PatchContentPositionProperties.
        Left positioning offset.

        :param left: The left of this PatchContentPositionProperties.
        :type: str
        """
        
        self._left = left

    @property
    def right(self):
        """
        Gets the right of this PatchContentPositionProperties.
        Right positioning offset.

        :return: The right of this PatchContentPositionProperties.
        :rtype: str
        """
        return self._right

    @right.setter
    def right(self, right):
        """
        Sets the right of this PatchContentPositionProperties.
        Right positioning offset.

        :param right: The right of this PatchContentPositionProperties.
        :type: str
        """
        
        self._right = right

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

