# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'OutboundMessagingMessagingCampaignConfigChangeUriReference',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'campaign_status': 'str',
            'callable_time_set': 'OutboundMessagingMessagingCampaignConfigChangeUriReference',
            'contact_list': 'OutboundMessagingMessagingCampaignConfigChangeUriReference',
            'dnc_lists': 'list[OutboundMessagingMessagingCampaignConfigChangeUriReference]',
            'contact_list_filters': 'list[OutboundMessagingMessagingCampaignConfigChangeUriReference]',
            'always_running': 'bool',
            'contact_sorts': 'list[OutboundMessagingMessagingCampaignConfigChangeContactSort]',
            'messages_per_minute': 'int',
            'sms_config': 'OutboundMessagingMessagingCampaignConfigChangeSmsConfig',
            'errors': 'list[OutboundMessagingMessagingCampaignConfigChangeErrorDetail]'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'campaign_status': 'campaignStatus',
            'callable_time_set': 'callableTimeSet',
            'contact_list': 'contactList',
            'dnc_lists': 'dncLists',
            'contact_list_filters': 'contactListFilters',
            'always_running': 'alwaysRunning',
            'contact_sorts': 'contactSorts',
            'messages_per_minute': 'messagesPerMinute',
            'sms_config': 'smsConfig',
            'errors': 'errors'
        }

        self._id = None
        self._division = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._campaign_status = None
        self._callable_time_set = None
        self._contact_list = None
        self._dnc_lists = None
        self._contact_list_filters = None
        self._always_running = None
        self._contact_sorts = None
        self._messages_per_minute = None
        self._sms_config = None
        self._errors = None

    @property
    def id(self):
        """
        Gets the id of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The id of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param id: The id of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        
        self._id = id

    @property
    def division(self):
        """
        Gets the division of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The division of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeUriReference
        """
        return self._division

    @division.setter
    def division(self, division):
        """
        Sets the division of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param division: The division of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingMessagingCampaignConfigChangeUriReference
        """
        
        self._division = division

    @property
    def name(self):
        """
        Gets the name of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The name of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param name: The name of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        
        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The date_created of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param date_created: The date_created of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The date_modified of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param date_modified: The date_modified of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def version(self):
        """
        Gets the version of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The version of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param version: The version of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: int
        """
        
        self._version = version

    @property
    def campaign_status(self):
        """
        Gets the campaign_status of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The campaign_status of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._campaign_status

    @campaign_status.setter
    def campaign_status(self, campaign_status):
        """
        Sets the campaign_status of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param campaign_status: The campaign_status of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        allowed_values = ["ON", "OFF", "COMPLETE", "STOPPING", "INVALID"]
        if campaign_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for campaign_status -> " + campaign_status)
            self._campaign_status = "outdated_sdk_version"
        else:
            self._campaign_status = campaign_status

    @property
    def callable_time_set(self):
        """
        Gets the callable_time_set of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The callable_time_set of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeUriReference
        """
        return self._callable_time_set

    @callable_time_set.setter
    def callable_time_set(self, callable_time_set):
        """
        Sets the callable_time_set of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param callable_time_set: The callable_time_set of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingMessagingCampaignConfigChangeUriReference
        """
        
        self._callable_time_set = callable_time_set

    @property
    def contact_list(self):
        """
        Gets the contact_list of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The contact_list of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeUriReference
        """
        return self._contact_list

    @contact_list.setter
    def contact_list(self, contact_list):
        """
        Sets the contact_list of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param contact_list: The contact_list of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingMessagingCampaignConfigChangeUriReference
        """
        
        self._contact_list = contact_list

    @property
    def dnc_lists(self):
        """
        Gets the dnc_lists of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The dnc_lists of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingMessagingCampaignConfigChangeUriReference]
        """
        return self._dnc_lists

    @dnc_lists.setter
    def dnc_lists(self, dnc_lists):
        """
        Sets the dnc_lists of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param dnc_lists: The dnc_lists of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingMessagingCampaignConfigChangeUriReference]
        """
        
        self._dnc_lists = dnc_lists

    @property
    def contact_list_filters(self):
        """
        Gets the contact_list_filters of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The contact_list_filters of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingMessagingCampaignConfigChangeUriReference]
        """
        return self._contact_list_filters

    @contact_list_filters.setter
    def contact_list_filters(self, contact_list_filters):
        """
        Sets the contact_list_filters of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param contact_list_filters: The contact_list_filters of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingMessagingCampaignConfigChangeUriReference]
        """
        
        self._contact_list_filters = contact_list_filters

    @property
    def always_running(self):
        """
        Gets the always_running of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The always_running of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: bool
        """
        return self._always_running

    @always_running.setter
    def always_running(self, always_running):
        """
        Sets the always_running of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param always_running: The always_running of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: bool
        """
        
        self._always_running = always_running

    @property
    def contact_sorts(self):
        """
        Gets the contact_sorts of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The contact_sorts of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingMessagingCampaignConfigChangeContactSort]
        """
        return self._contact_sorts

    @contact_sorts.setter
    def contact_sorts(self, contact_sorts):
        """
        Sets the contact_sorts of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param contact_sorts: The contact_sorts of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingMessagingCampaignConfigChangeContactSort]
        """
        
        self._contact_sorts = contact_sorts

    @property
    def messages_per_minute(self):
        """
        Gets the messages_per_minute of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The messages_per_minute of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: int
        """
        return self._messages_per_minute

    @messages_per_minute.setter
    def messages_per_minute(self, messages_per_minute):
        """
        Sets the messages_per_minute of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param messages_per_minute: The messages_per_minute of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: int
        """
        
        self._messages_per_minute = messages_per_minute

    @property
    def sms_config(self):
        """
        Gets the sms_config of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The sms_config of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeSmsConfig
        """
        return self._sms_config

    @sms_config.setter
    def sms_config(self, sms_config):
        """
        Sets the sms_config of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param sms_config: The sms_config of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingMessagingCampaignConfigChangeSmsConfig
        """
        
        self._sms_config = sms_config

    @property
    def errors(self):
        """
        Gets the errors of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :return: The errors of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingMessagingCampaignConfigChangeErrorDetail]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """
        Sets the errors of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.


        :param errors: The errors of this OutboundMessagingMessagingCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingMessagingCampaignConfigChangeErrorDetail]
        """
        
        self._errors = errors

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

