# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class OutOfOffice(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        OutOfOffice - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'user': 'User',
            'start_date': 'datetime',
            'end_date': 'datetime',
            'active': 'bool',
            'indefinite': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'user': 'user',
            'start_date': 'startDate',
            'end_date': 'endDate',
            'active': 'active',
            'indefinite': 'indefinite',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._user = None
        self._start_date = None
        self._end_date = None
        self._active = None
        self._indefinite = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this OutOfOffice.
        The globally unique identifier for the object.

        :return: The id of this OutOfOffice.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OutOfOffice.
        The globally unique identifier for the object.

        :param id: The id of this OutOfOffice.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this OutOfOffice.


        :return: The name of this OutOfOffice.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OutOfOffice.


        :param name: The name of this OutOfOffice.
        :type: str
        """
        
        self._name = name

    @property
    def user(self):
        """
        Gets the user of this OutOfOffice.


        :return: The user of this OutOfOffice.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this OutOfOffice.


        :param user: The user of this OutOfOffice.
        :type: User
        """
        
        self._user = user

    @property
    def start_date(self):
        """
        Gets the start_date of this OutOfOffice.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_date of this OutOfOffice.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this OutOfOffice.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_date: The start_date of this OutOfOffice.
        :type: datetime
        """
        
        self._start_date = start_date

    @property
    def end_date(self):
        """
        Gets the end_date of this OutOfOffice.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The end_date of this OutOfOffice.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this OutOfOffice.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param end_date: The end_date of this OutOfOffice.
        :type: datetime
        """
        
        self._end_date = end_date

    @property
    def active(self):
        """
        Gets the active of this OutOfOffice.


        :return: The active of this OutOfOffice.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this OutOfOffice.


        :param active: The active of this OutOfOffice.
        :type: bool
        """
        
        self._active = active

    @property
    def indefinite(self):
        """
        Gets the indefinite of this OutOfOffice.


        :return: The indefinite of this OutOfOffice.
        :rtype: bool
        """
        return self._indefinite

    @indefinite.setter
    def indefinite(self, indefinite):
        """
        Sets the indefinite of this OutOfOffice.


        :param indefinite: The indefinite of this OutOfOffice.
        :type: bool
        """
        
        self._indefinite = indefinite

    @property
    def self_uri(self):
        """
        Gets the self_uri of this OutOfOffice.
        The URI for this object

        :return: The self_uri of this OutOfOffice.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this OutOfOffice.
        The URI for this object

        :param self_uri: The self_uri of this OutOfOffice.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

