# Generated by Django 3.2.5 on 2022-03-31 22:29

from django.conf import settings
from django.db import migrations, models


def copy_members_to_temp_row(apps, schema_editor):
    Room = apps.get_model('chit_chat', 'Room')
    RoomMembership = apps.get_model('chit_chat', 'RoomMembership')

    # Ugly code that makes lots of queries .. ok to migrate a few things!
    for room in Room.objects.all():
        for member in room.members.all():
            RoomMembership.objects.create(
                room=room,
                user=member,
            )


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('chit_chat', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='room',
            name='members_temp',
            field=models.ManyToManyField(related_name='chat_rooms_temp', through='chit_chat.RoomMembership', to=settings.AUTH_USER_MODEL),
        ),
        migrations.RunPython(copy_members_to_temp_row)
    ]
