# -*- coding: utf-8 -*-
# Copyright © 2022 Wacom. All rights reserved.
""""Mapping of Wikidata property ids to its string."""
from typing import Dict

# Mapping for property names
PROPERTY_MAPPING: Dict[str, str] = {
    "P6": "head of government"
    , "P10": "video"
    , "P14": "traffic sign"
    , "P15": "route map"
    , "P16": "highway system"
    , "P17": "country"
    , "P18": "image"
    , "P19": "place of birth"
    , "P20": "place of death"
    , "P21": "sex or gender"
    , "P22": "father"
    , "P25": "mother"
    , "P26": "spouse"
    , "P27": "country of citizenship"
    , "P30": "continent"
    , "P31": "instance of"
    , "P35": "head of state"
    , "P36": "capital"
    , "P37": "official language_code"
    , "P38": "currency"
    , "P39": "position held"
    , "P40": "child"
    , "P41": "flag image"
    , "P47": "shares border with"
    , "P50": "author"
    , "P51": "audio"
    , "P53": "family"
    , "P54": "member of sports team"
    , "P57": "director"
    , "P58": "screenwriter"
    , "P59": "constellation"
    , "P61": "discoverer or inventor"
    , "P65": "site of astronomical discovery"
    , "P66": "ancestral home"
    , "P69": "educated at"
    , "P78": "top-level Internet domain"
    , "P81": "connecting line"
    , "P84": "architect"
    , "P85": "anthem"
    , "P86": "composer"
    , "P87": "librettist"
    , "P88": "commissioned by"
    , "P91": "sexual orientation"
    , "P92": "main regulatory text"
    , "P94": "coat of arms image"
    , "P97": "noble title"
    , "P98": "editor"
    , "P101": "field of work"
    , "P102": "political party"
    , "P103": "native language_code"
    , "P105": "taxon rank"
    , "P106": "occupation"
    , "P108": "employer"
    , "P109": "signature"
    , "P110": "illustrator"
    , "P111": "measured physical quantity"
    , "P112": "founded by"
    , "P113": "airline hub"
    , "P114": "airline alliance"
    , "P115": "home venue"
    , "P117": "chemical structure"
    , "P118": "league"
    , "P119": "place of burial"
    , "P121": "item operated"
    , "P122": "basic form of government"
    , "P123": "publisher"
    , "P126": "maintained by"
    , "P127": "owned by"
    , "P128": "regulates (molecular biology)"
    , "P129": "physically interacts with"
    , "P131": "located in the administrative territorial entity"
    , "P135": "movement"
    , "P136": "genre"
    , "P137": "operator"
    , "P138": "named after"
    , "P140": "religion"
    , "P141": "IUCN conservation status"
    , "P143": "imported from Wikimedia project"
    , "P144": "based on"
    , "P149": "architectural style"
    , "P150": "contains administrative territorial entity"
    , "P154": "logo image"
    , "P155": "follows"
    , "P156": "followed by"
    , "P157": "killed by"
    , "P158": "seal image"
    , "P159": "headquarters location"
    , "P161": "cast member"
    , "P162": "producer"
    , "P163": "flag"
    , "P166": "award received"
    , "P167": "structure replaced by"
    , "P169": "chief executive officer"
    , "P170": "creator"
    , "P171": "parent taxon"
    , "P172": "ethnic group"
    , "P175": "performer"
    , "P176": "manufacturer"
    , "P177": "crosses"
    , "P178": "developer"
    , "P179": "part of the series"
    , "P180": "depicts"
    , "P181": "taxon range map image"
    , "P183": "endemic to"
    , "P184": "doctoral advisor"
    , "P185": "doctoral student"
    , "P186": "material used"
    , "P189": "location of discovery"
    , "P190": "twinned administrative body"
    , "P193": "main building contractor"
    , "P194": "legislative body"
    , "P195": "collection"
    , "P196": "minor planet group"
    , "P197": "adjacent station"
    , "P199": "business division"
    , "P200": "inflows"
    , "P201": "lake outflow"
    , "P205": "basin country"
    , "P206": "located in or next to body of water"
    , "P207": "bathymetry image"
    , "P208": "executive body"
    , "P209": "highest judicial authority"
    , "P210": "party chief representative"
    , "P212": "ISBN-13"
    , "P213": "ISNI"
    , "P214": "VIAF ID"
    , "P215": "spectral class"
    , "P217": "inventory number"
    , "P218": "ISO 639-1 code"
    , "P219": "ISO 639-2 code"
    , "P220": "ISO 639-3 code"
    , "P221": "ISO 639-6 code"
    , "P223": "galaxy morphological type"
    , "P225": "taxon name"
    , "P227": "GND ID"
    , "P229": "IATA airline designator"
    , "P230": "ICAO airline designator"
    , "P231": "CAS Registry Number"
    , "P232": "EC number"
    , "P233": "canonical SMILES"
    , "P234": "InChI"
    , "P235": "InChIKey"
    , "P236": "ISSN"
    , "P237": "coat of arms"
    , "P238": "IATA airport code"
    , "P239": "ICAO airport code"
    , "P240": "FAA airport code"
    , "P241": "military branch"
    , "P242": "locator map image"
    , "P243": "OCLC control number"
    , "P244": "Library of Congress authority ID"
    , "P245": "Union List of Artist Names ID"
    , "P246": "element symbol"
    , "P247": "COSPAR ID"
    , "P248": "stated in"
    , "P249": "ticker symbol"
    , "P263": "official residence"
    , "P264": "record label"
    , "P267": "ATC code"
    , "P268": "Biblioth\u00e8que nationale de France ID"
    , "P269": "IdRef ID"
    , "P270": "CALIS ID"
    , "P271": "CiNii author ID (books)"
    , "P272": "production company"
    , "P274": "chemical formula"
    , "P275": "copyright license"
    , "P276": "location"
    , "P277": "programming language_code"
    , "P278": "GOST 7.75\u201397 code"
    , "P279": "subclass of"
    , "P281": "postal code"
    , "P282": "writing system"
    , "P286": "head coach"
    , "P287": "designed by"
    , "P289": "vessel class"
    , "P291": "place of publication"
    , "P296": "station code"
    , "P297": "ISO 3166-1 alpha-2 code"
    , "P298": "ISO 3166-1 alpha-3 code"
    , "P299": "ISO 3166-1 numeric code"
    , "P300": "ISO 3166-2 code"
    , "P301": "category's main topic"
    , "P303": "EE breed number"
    , "P304": "page(s)"
    , "P305": "IETF language_code tag"
    , "P306": "operating system"
    , "P344": "director of photography"
    , "P345": "IMDb ID"
    , "P347": "Joconde work ID"
    , "P348": "software version identifier"
    , "P349": "National Diet Library ID"
    , "P350": "RKDimages ID"
    , "P351": "Entrez Gene ID"
    , "P352": "UniProt protein ID"
    , "P353": "HGNC gene symbol"
    , "P354": "HGNC ID"
    , "P355": "subsidiary"
    , "P356": "DOI"
    , "P358": "discography"
    , "P359": "Rijksmonument ID"
    , "P360": "is a list of"
    , "P361": "part of"
    , "P364": "original language_code of film or TV show"
    , "P366": "use"
    , "P367": "astronomic symbol image"
    , "P368": "Sandbox-CommonsMediaFile"
    , "P369": "Sandbox-Item"
    , "P370": "Sandbox-String"
    , "P371": "presenter"
    , "P373": "Commons category"
    , "P374": "INSEE municipality code"
    , "P375": "space launch vehicle"
    , "P376": "located on astronomical location"
    , "P377": "SCN"
    , "P380": "M\u00e9rim\u00e9e ID"
    , "P381": "PCP reference number"
    , "P382": "CBS municipality code"
    , "P393": "edition number"
    , "P395": "licence plate code"
    , "P396": "SBN author ID"
    , "P397": "parent astronomical body"
    , "P398": "child astronomical body"
    , "P399": "companion of"
    , "P400": "platform"
    , "P402": "OpenStreetMap relation ID"
    , "P403": "mouth of the watercourse"
    , "P404": "game mode"
    , "P405": "taxon author"
    , "P406": "soundtrack release"
    , "P407": "language_code of work or name"
    , "P408": "software engine"
    , "P409": "Libraries Australia ID"
    , "P410": "military rank"
    , "P411": "canonization status"
    , "P412": "voice type"
    , "P413": "position played on team / speciality"
    , "P414": "stock exchange"
    , "P415": "radio format"
    , "P416": "quantity symbol (string)"
    , "P417": "patron saint"
    , "P418": "seal description"
    , "P421": "located in time zone"
    , "P423": "shooting handedness"
    , "P424": "Wikimedia language_code code"
    , "P425": "field of this occupation"
    , "P426": "aircraft registration"
    , "P427": "taxonomic type"
    , "P428": "botanist author abbreviation"
    , "P429": "dantai code"
    , "P432": "callsign of airline"
    , "P433": "issue"
    , "P434": "MusicBrainz artist ID"
    , "P435": "MusicBrainz work ID"
    , "P436": "MusicBrainz release group ID"
    , "P437": "distribution format"
    , "P439": "German municipality key"
    , "P440": "German district key"
    , "P442": "China administrative division code"
    , "P443": "pronunciation audio"
    , "P444": "review score"
    , "P447": "review score by"
    , "P449": "original broadcaster"
    , "P450": "astronaut mission"
    , "P451": "unmarried partner"
    , "P452": "industry"
    , "P453": "character role"
    , "P454": "Structurae structure ID"
    , "P455": "Emporis building ID"
    , "P457": "foundational text"
    , "P458": "IMO ship number"
    , "P459": "determination method"
    , "P460": "said to be the same as"
    , "P461": "opposite of"
    , "P462": "color"
    , "P463": "member of"
    , "P464": "NOR"
    , "P465": "sRGB color hex triplet"
    , "P466": "occupant"
    , "P467": "legislated by"
    , "P468": "dan/kyu rank"
    , "P469": "lakes on river"
    , "P470": "Eight Banner register"
    , "P473": "local dialing code"
    , "P474": "country calling code"
    , "P476": "CELEX number"
    , "P477": "Canadian Register of Historic Places ID"
    , "P478": "volume"
    , "P479": "input method"
    , "P480": "FilmAffinity ID"
    , "P481": "Palissy ID"
    , "P483": "recorded at studio or venue"
    , "P484": "IMA Number, broad sense"
    , "P485": "archives at"
    , "P486": "MeSH descriptor ID"
    , "P487": "Unicode character"
    , "P488": "chairperson"
    , "P489": "currency symbol description"
    , "P490": "provisional designation"
    , "P491": "orbit diagram"
    , "P492": "OMIM ID"
    , "P493": "ICD-9"
    , "P494": "ICD-10"
    , "P495": "country of origin"
    , "P496": "ORCID iD"
    , "P497": "CBDB ID"
    , "P498": "ISO 4217 code"
    , "P500": "exclave of"
    , "P501": "enclave within"
    , "P502": "HURDAT identifier"
    , "P503": "ISO standard"
    , "P504": "home port"
    , "P505": "general manager"
    , "P506": "ISO 15924 alpha-4 code"
    , "P507": "Swedish county code"
    , "P508": "BNCF Thesaurus ID"
    , "P509": "cause of death"
    , "P511": "honorific prefix"
    , "P512": "academic degree"
    , "P514": "interleaves with"
    , "P515": "phase of matter"
    , "P516": "powered by"
    , "P517": "interaction"
    , "P518": "applies to part"
    , "P520": "armament"
    , "P521": "scheduled service destination"
    , "P522": "type of orbit"
    , "P523": "temporal range start"
    , "P524": "temporal range end"
    , "P525": "Swedish municipality code"
    , "P527": "has part"
    , "P528": "catalog code"
    , "P529": "runway"
    , "P530": "diplomatic relation"
    , "P531": "diplomatic mission sent"
    , "P532": "port of registry"
    , "P533": "target"
    , "P534": "streak color"
    , "P535": "Find A Grave memorial ID"
    , "P536": "ATP player ID"
    , "P537": "twinning"
    , "P538": "fracturing"
    , "P539": "Museofile"
    , "P541": "office contested"
    , "P542": "officially opened by"
    , "P543": "oath made by"
    , "P545": "torch lit by"
    , "P546": "docking port"
    , "P547": "commemorates"
    , "P548": "version type"
    , "P549": "Mathematics Genealogy Project ID"
    , "P550": "chivalric order"
    , "P551": "residence"
    , "P552": "handedness"
    , "P553": "website account on"
    , "P554": "website username"
    , "P555": "doubles record"
    , "P556": "crystal system"
    , "P557": "DiseasesDB"
    , "P559": "terminus"
    , "P560": "direction"
    , "P561": "NATO reporting name"
    , "P562": "central bank/issuer"
    , "P563": "ICD-O"
    , "P564": "singles record"
    , "P565": "crystal habit"
    , "P566": "basionym"
    , "P567": "underlies"
    , "P568": "overlies"
    , "P569": "date of birth"
    , "P570": "date of death"
    , "P571": "inception"
    , "P574": "year of taxon publication"
    , "P575": "time of discovery or invention"
    , "P576": "dissolved, abolished or demolished"
    , "P577": "publication date"
    , "P578": "Sandbox-TimeValue"
    , "P579": "IMA status and/or rank"
    , "P580": "start time"
    , "P582": "end time"
    , "P585": "point in time"
    , "P586": "IPNI author ID"
    , "P587": "MMSI"
    , "P588": "coolant"
    , "P589": "point group"
    , "P590": "GNIS ID"
    , "P591": "EC enzyme number"
    , "P592": "ChEMBL ID"
    , "P593": "HomoloGene ID"
    , "P594": "Ensembl gene ID"
    , "P595": "Guide to Pharmacology Ligand ID"
    , "P597": "WTA player ID"
    , "P598": "commander of (DEPRECATED)"
    , "P599": "ITF player ID"
    , "P600": "Wine AppDB ID"
    , "P604": "MedlinePlus ID"
    , "P605": "NUTS code"
    , "P606": "first flight"
    , "P607": "conflict"
    , "P608": "exhibition history"
    , "P609": "terminus location"
    , "P610": "highest point"
    , "P611": "religious order"
    , "P612": "mother house"
    , "P613": "OS grid reference"
    , "P617": "yard number"
    , "P618": "source of energy"
    , "P619": "UTC date of spacecraft launch"
    , "P620": "time of spacecraft landing"
    , "P621": "time of spacecraft orbit decay"
    , "P622": "spacecraft docking/undocking date"
    , "P624": "guidance system"
    , "P625": "coordinate location"
    , "P626": "Sandbox-GeoCoordinateValue"
    , "P627": "IUCN taxon ID"
    , "P628": "E number"
    , "P629": "edition or translation of"
    , "P630": "Paris city digital code"
    , "P631": "structural engineer"
    , "P632": "cultural properties of Belarus reference number"
    , "P633": "Quebec cultural heritage directory ID"
    , "P634": "captain"
    , "P635": "ISTAT ID"
    , "P636": "route of administration"
    , "P637": "RefSeq protein ID"
    , "P638": "PDB structure ID"
    , "P639": "RefSeq RNA ID"
    , "P640": "L\u00e9onore ID"
    , "P641": "sport"
    , "P642": "of"
    , "P644": "genomic start"
    , "P645": "genomic end"
    , "P646": "Freebase ID"
    , "P647": "drafted by"
    , "P648": "Open Library ID"
    , "P649": "NRHP reference number"
    , "P650": "RKDartists ID"
    , "P651": "Biografisch Portaal van Nederland ID"
    , "P652": "UNII"
    , "P653": "PubMed Health"
    , "P654": "direction relative to location"
    , "P655": "translator"
    , "P656": "RefSeq"
    , "P657": "RTECS number"
    , "P658": "tracklist"
    , "P659": "genomic assembly"
    , "P660": "EC enzyme classification"
    , "P661": "ChemSpider ID"
    , "P662": "PubChem CID"
    , "P663": "DSM-IV classification"
    , "P664": "organizer"
    , "P665": "KEGG ID"
    , "P667": "ICPC 2 ID"
    , "P668": "GeneReviews ID"
    , "P669": "located on street"
    , "P670": "street number"
    , "P671": "Mouse Genome Informatics ID"
    , "P672": "MeSH tree code"
    , "P673": "eMedicine ID"
    , "P674": "characters"
    , "P675": "Google Books ID"
    , "P676": "lyrics by"
    , "P677": "\u00daSOP code"
    , "P678": "incertae sedis"
    , "P679": "ZVG number"
    , "P680": "molecular function"
    , "P681": "cell component"
    , "P682": "biological process"
    , "P683": "ChEBI ID"
    , "P684": "ortholog"
    , "P685": "NCBI taxonomy ID"
    , "P686": "Gene Ontology ID"
    , "P687": "BHL Page ID"
    , "P688": "encodes"
    , "P689": "afflicts"
    , "P690": "space group"
    , "P691": "NKCR AUT ID"
    , "P692": "Gene Atlas Image"
    , "P693": "cleavage"
    , "P694": "replaced synonym (for nom. nov.)"
    , "P695": "UN number"
    , "P696": "Interlex ID"
    , "P697": "ex taxon author"
    , "P698": "PubMed ID"
    , "P699": "Disease Ontology ID"
    , "P700": "Kemler code"
    , "P701": "Dodis ID"
    , "P702": "encoded by"
    , "P703": "found in taxon"
    , "P704": "Ensembl transcript ID"
    , "P705": "Ensembl protein ID"
    , "P706": "located on terrain feature"
    , "P707": "satellite bus"
    , "P708": "diocese"
    , "P709": "Historic Scotland ID"
    , "P710": "participant"
    , "P711": "Strunz 8th edition (series ID, updated)"
    , "P712": "Nickel-Strunz 9th edition (updated 2009)"
    , "P713": "Nickel-Strunz '10th ed', review of (9th ed/ 2009 update)"
    , "P714": "Dana 8th edition"
    , "P715": "DrugBank ID"
    , "P716": "JPL Small-Body Database ID"
    , "P717": "Minor Planet Center observatory code"
    , "P718": "Canmore ID"
    , "P720": "asteroid spectral type"
    , "P721": "OKATO ID"
    , "P722": "UIC station code"
    , "P723": "Digitale Bibliotheek voor de Nederlandse Letteren author ID"
    , "P724": "Internet Archive ID"
    , "P725": "voice actor"
    , "P726": "candidate"
    , "P729": "service entry"
    , "P730": "service retirement"
    , "P731": "Litholex ID"
    , "P732": "BGS Lexicon of Named Rock Units ID"
    , "P733": "DINOloket"
    , "P734": "family name"
    , "P735": "given name"
    , "P736": "cover art by"
    , "P737": "influenced by"
    , "P739": "ammunition"
    , "P740": "location of formation"
    , "P741": "playing hand"
    , "P742": "pseudonym"
    , "P744": "asteroid family"
    , "P745": "Low German Bibliography and Biography ID"
    , "P746": "date of disappearance"
    , "P747": "has edition or translation"
    , "P748": "appointed by"
    , "P749": "parent organization"
    , "P750": "distributed by"
    , "P751": "introduced feature"
    , "P756": "removed feature"
    , "P757": "World Heritage Site ID"
    , "P758": "Kulturminne ID"
    , "P759": "Alberta Register of Historic Places ID"
    , "P760": "DPLA ID"
    , "P761": "Lake ID (Sweden)"
    , "P762": "Czech cultural heritage ID"
    , "P763": "PEI Register of Historic Places ID"
    , "P764": "OKTMO ID"
    , "P765": "surface played on"
    , "P767": "contributor to the creative work or subject"
    , "P768": "electoral district"
    , "P769": "significant drug interaction"
    , "P770": "cause of destruction"
    , "P771": "Swiss municipality code"
    , "P772": "INE municipality code"
    , "P773": "ISO 3166-3"
    , "P774": "FIPS 55-3 (locations in the US)"
    , "P775": "Swedish urban area code"
    , "P776": "Swedish minor urban area code"
    , "P777": "Swedish civil parish code/ATA code"
    , "P778": "Church of Sweden parish code"
    , "P779": "Church of Sweden Pastoratskod"
    , "P780": "symptoms"
    , "P781": "SIKART ID"
    , "P782": "LAU"
    , "P783": "hymenium type"
    , "P784": "mushroom cap shape"
    , "P785": "hymenium attachment"
    , "P786": "stipe character"
    , "P787": "spore print color"
    , "P788": "mushroom ecological type"
    , "P789": "edibility"
    , "P790": "approved by"
    , "P791": "ISIL"
    , "P792": "chapter"
    , "P793": "significant event"
    , "P795": "located on linear feature"
    , "P797": "authority"
    , "P798": "military designation"
    , "P799": "Air Ministry specification ID"
    , "P800": "notable work"
    , "P802": "student"
    , "P803": "professorship"
    , "P804": "GNIS Antarctica ID"
    , "P805": "statement is subject of"
    , "P806": "Italian cadastre code"
    , "P807": "separated from"
    , "P808": "Bien de Inter\u00e9s Cultural (BIC) code"
    , "P809": "WDPA ID"
    , "P811": "academic minor"
    , "P812": "academic major"
    , "P813": "retrieved"
    , "P814": "IUCN protected areas category"
    , "P815": "ITIS TSN"
    , "P816": "decays to"
    , "P817": "decay mode"
    , "P818": "arXiv ID"
    , "P819": "ADS bibcode"
    , "P820": "arXiv classification"
    , "P821": "CGNDB Unique ID"
    , "P822": "mascot"
    , "P823": "speaker"
    , "P824": "Meteoritical Bulletin Database ID"
    , "P825": "dedicated to"
    , "P826": "tonality"
    , "P827": "BBC programme ID"
    , "P828": "has cause"
    , "P829": "OEIS ID"
    , "P830": "Encyclopedia of Life ID"
    , "P831": "parent club"
    , "P832": "public holiday"
    , "P833": "interchange station"
    , "P834": "train depot"
    , "P835": "author citation (zoology)"
    , "P836": "GSS code (2011)"
    , "P837": "day in year for periodic occurrence"
    , "P838": "BioLib taxon ID"
    , "P839": "IMSLP ID"
    , "P840": "narrative location"
    , "P841": "feast day"
    , "P842": "Fossilworks taxon ID"
    , "P843": "SIRUTA code"
    , "P844": "UBIGEO code"
    , "P845": "Saskatchewan Register of Heritage OntologyPropertyReference ID"
    , "P846": "Global Biodiversity Information Facility ID"
    , "P847": "United States Navy aircraft designation"
    , "P849": "Japanese military aircraft designation"
    , "P850": "WoRMS-ID for taxa"
    , "P852": "ESRB rating"
    , "P853": "CERO rating"
    , "P854": "reference URL"
    , "P855": "Sandbox-URL"
    , "P856": "official website"
    , "P858": "ESPNscrum player ID"
    , "P859": "sponsor"
    , "P860": "e-archiv.li ID"
    , "P861": "PremiershipRugby.com ID"
    , "P862": "Operational Requirement of the UK Air Ministry"
    , "P863": "InPhO ID"
    , "P864": "ACM Digital Library author ID"
    , "P865": "BMLO ID"
    , "P866": "Perlentaucher ID"
    , "P867": "ROME Occupation Code (v3)"
    , "P868": "foods traditionally associated"
    , "P870": "instrumentation"
    , "P872": "printed by"
    , "P873": "phase point"
    , "P874": "UN class"
    , "P875": "UN code classification"
    , "P876": "UN packaging group"
    , "P877": "NFPA Special"
    , "P878": "avionics"
    , "P879": "pennant number"
    , "P880": "CPU"
    , "P881": "type of variable star"
    , "P882": "FIPS 6-4 (US counties)"
    , "P884": "State Water Register Code (Russia)"
    , "P885": "origin of the watercourse"
    , "P886": "Lexicon istoric retic ID"
    , "P887": "based on heuristic"
    , "P888": "JSTOR article ID"
    , "P889": "Mathematical Reviews ID"
    , "P892": "RfC ID"
    , "P893": "SSRN article ID"
    , "P894": "zbMATH work ID"
    , "P897": "United States Army and Air Force aircraft designation"
    , "P898": "IPA transcription"
    , "P901": "FIPS 10-4 (countries and regions)"
    , "P902": "HDS ID"
    , "P905": "PORT film ID"
    , "P906": "SELIBR ID"
    , "P908": "PEGI rating"
    , "P909": "Nova Scotia Register of Historic Places ID"
    , "P910": "topic's main category"
    , "P911": "South African municipality code"
    , "P912": "has facility"
    , "P913": "notation"
    , "P914": "USK rating"
    , "P915": "filming location"
    , "P916": "GSRR rating"
    , "P917": "GRAU index"
    , "P918": "NOC Occupation Code"
    , "P919": "SOC Code (2010)"
    , "P920": "LEM ID"
    , "P921": "main subject"
    , "P922": "magnetic ordering"
    , "P923": "medical examinations"
    , "P924": "possible treatment"
    , "P925": "presynaptic connection"
    , "P926": "postsynaptic connection"
    , "P927": "anatomical location"
    , "P928": "activating neurotransmitter"
    , "P929": "color space"
    , "P930": "type of electrification"
    , "P931": "place served by transport hub"
    , "P932": "PMCID"
    , "P933": "heritagefoundation.ca ID"
    , "P935": "Commons gallery"
    , "P937": "work location"
    , "P938": "FishBase species ID"
    , "P939": "KSH code"
    , "P941": "inspired by"
    , "P942": "theme music"
    , "P943": "programmer"
    , "P944": "Code of nomenclature"
    , "P945": "allegiance"
    , "P946": "ISIN"
    , "P947": "RSL ID (person)"
    , "P948": "page banner"
    , "P949": "National Library of Israel ID"
    , "P950": "Biblioteca Nacional de Espa\u00f1a ID"
    , "P951": "NSZL (VIAF) ID"
    , "P952": "ISCO-88 occupation code"
    , "P953": "full work available at URL"
    , "P954": "IBNR ID"
    , "P957": "ISBN-10"
    , "P958": "section, verse, paragraph, or clause"
    , "P959": "MSW ID"
    , "P960": "Tropicos ID"
    , "P961": "IPNI plant ID"
    , "P962": "MycoBank taxon name ID"
    , "P963": "streaming media URL"
    , "P964": "Austrian municipality key"
    , "P965": "burial plot reference"
    , "P966": "MusicBrainz label ID"
    , "P967": "guest of honor"
    , "P968": "e-mail address"
    , "P969": "street address (DEPRECATED)"
    , "P970": "neurological function"
    , "P971": "category combines topics"
    , "P972": "catalog"
    , "P973": "described at URL"
    , "P974": "tributary"
    , "P980": "code for weekend and holiday homes (Sweden)"
    , "P981": "BAG residence ID"
    , "P982": "MusicBrainz area ID"
    , "P984": "IOC country code"
    , "P988": "Philippine Standard Geographic Code"
    , "P989": "spoken text audio"
    , "P990": "audio recording of the subject's spoken voice"
    , "P991": "successful candidate"
    , "P993": "NFPA Health"
    , "P994": "NFPA Fire"
    , "P995": "NFPA Instability"
    , "P996": "document file on Wikimedia Commons"
    , "P998": "DMOZ ID"
    , "P999": "ARICNS"
    , "P1000": "record held"
    , "P1001": "applies to jurisdiction"
    , "P1002": "engine configuration"
    , "P1003": "National Library of Romania ID"
    , "P1004": "MusicBrainz place ID"
    , "P1005": "Portuguese National Library ID"
    , "P1006": "Nationale Thesaurus voor Auteurs ID"
    , "P1007": "Lattes Platform number"
    , "P1010": "Iran statistics ID"
    , "P1011": "excluding"
    , "P1012": "including"
    , "P1013": "criterion used"
    , "P1014": "Art & Architecture Thesaurus ID"
    , "P1015": "BIBSYS ID"
    , "P1016": "asteroid taxonomy"
    , "P1017": "Vatican Library ID"
    , "P1018": "language_code regulatory body"
    , "P1019": "web feed URL"
    , "P1021": "KldB-2010 occupation code"
    , "P1022": "CNO-11 occupation code"
    , "P1023": "SBC-2010 occupation code"
    , "P1024": "SBFI occupation code"
    , "P1025": "SUDOC editions"
    , "P1026": "doctoral thesis"
    , "P1027": "conferred by"
    , "P1028": "donated by"
    , "P1029": "crew member"
    , "P1030": "light characteristic of lighthouse"
    , "P1031": "legal citation of this text"
    , "P1032": "Digital Rights Management system"
    , "P1033": "GHS signal word"
    , "P1034": "main food source"
    , "P1035": "honorific suffix"
    , "P1036": "Dewey Decimal Classification"
    , "P1037": "director / manager"
    , "P1038": "relative"
    , "P1039": "type of kinship"
    , "P1040": "film editor"
    , "P1041": "socket supported"
    , "P1042": "ZDB ID"
    , "P1043": "IDEO Job ID"
    , "P1044": "SWB editions"
    , "P1045": "Sycomore ID"
    , "P1046": "discovery method"
    , "P1047": "Catholic Hierarchy person ID"
    , "P1048": "NCL ID"
    , "P1049": "worshipped by"
    , "P1050": "medical condition"
    , "P1051": "PSH ID"
    , "P1052": "Portuguese Job Code CPP-2010"
    , "P1053": "ResearcherID"
    , "P1054": "NDL bib ID"
    , "P1055": "NLM Unique ID"
    , "P1056": "product or material produced"
    , "P1057": "chromosome"
    , "P1058": "ERA Journal ID"
    , "P1059": "CVR number"
    , "P1060": "pathogen transmission process"
    , "P1064": "track gauge"
    , "P1065": "archive URL"
    , "P1066": "student of"
    , "P1067": "Thailand central administrative unit code"
    , "P1068": "instruction set"
    , "P1069": "Statistics Denmarks classification of occupation (DISCO-08)"
    , "P1070": "PlantList-ID"
    , "P1071": "location of creation"
    , "P1072": "readable file format"
    , "P1073": "writable file format"
    , "P1074": "fictional analog of"
    , "P1075": "rector"
    , "P1076": "ICTV virus ID"
    , "P1077": "KOATUU identifier"
    , "P1078": "valvetrain configuration"
    , "P1079": "launch contractor"
    , "P1080": "from narrative universe"
    , "P1081": "Human Development Index"
    , "P1082": "population"
    , "P1083": "maximum capacity"
    , "P1084": "EUL editions"
    , "P1085": "LibraryThing work ID"
    , "P1086": "atomic number"
    , "P1087": "Elo rating"
    , "P1088": "Mohs' hardness"
    , "P1090": "redshift"
    , "P1092": "total produced"
    , "P1093": "gross tonnage"
    , "P1096": "orbital eccentricity"
    , "P1097": "g-factor"
    , "P1098": "number of speakers"
    , "P1099": "number of masts"
    , "P1100": "number of cylinders"
    , "P1101": "floors above ground"
    , "P1102": "flattening"
    , "P1103": "number of platform tracks"
    , "P1104": "number of pages"
    , "P1106": "Sandbox-Quantity"
    , "P1107": "proportion"
    , "P1108": "electronegativity"
    , "P1109": "refractive index"
    , "P1110": "attendance"
    , "P1111": "votes received"
    , "P1113": "number of episodes"
    , "P1114": "quantity"
    , "P1115": "ATVK ID"
    , "P1116": "ELSTAT geographical code"
    , "P1117": "pKa"
    , "P1120": "number of deaths"
    , "P1121": "oxidation state"
    , "P1122": "spin quantum number"
    , "P1123": "parity quantum number"
    , "P1125": "Gini coefficient"
    , "P1126": "isospin quantum number"
    , "P1127": "isospin z-component"
    , "P1128": "employees"
    , "P1129": "national team caps"
    , "P1132": "number of participants"
    , "P1133": "DGO4 identifier"
    , "P1135": "nomenclatural status"
    , "P1136": "solved by"
    , "P1137": "fossil found in this unit"
    , "P1138": "Kunstindeks Danmark Artist ID"
    , "P1139": "floors below ground"
    , "P1140": "EHAK id"
    , "P1141": "number of processor cores"
    , "P1142": "political ideology"
    , "P1143": "BN (Argentine) editions"
    , "P1144": "Library of Congress Control Number (LCCN) (bibliographic)"
    , "P1145": "Lagrangian point"
    , "P1146": "World Athletics athlete ID"
    , "P1148": "neutron number"
    , "P1149": "Library of Congress Classification"
    , "P1150": "Regensburg Classification"
    , "P1151": "topic's main Wikimedia portal"
    , "P1153": "Scopus author ID"
    , "P1154": "Scopus EID"
    , "P1155": "Scopus affiliation ID"
    , "P1156": "Scopus source ID"
    , "P1157": "US Congress Bio ID"
    , "P1158": "location of landing"
    , "P1159": "CODEN"
    , "P1160": "ISO 4 abbreviation"
    , "P1161": "Z39.5 abbreviation"
    , "P1162": "Bluebook abbreviation"
    , "P1163": "media type"
    , "P1164": "cardinality of the group"
    , "P1165": "home world"
    , "P1167": "USB vendor ID"
    , "P1168": "municipality code (Denmark)"
    , "P1170": "transmitted signal type"
    , "P1171": "approximation algorithm"
    , "P1172": "Geokod"
    , "P1174": "visitors per year"
    , "P1181": "numeric value"
    , "P1182": "LIBRIS editions"
    , "P1183": "Gew\u00e4sserkennzahl"
    , "P1184": "Handle ID"
    , "P1185": "Rodovid ID"
    , "P1186": "MEP directory ID"
    , "P1187": "Dharma Drum Buddhist College person ID"
    , "P1188": "Dharma Drum Buddhist College place ID"
    , "P1189": "Chinese Library Classification"
    , "P1190": "Universal Decimal Classification"
    , "P1191": "date of first performance"
    , "P1192": "connecting service"
    , "P1193": "prevalence"
    , "P1194": "received signal type"
    , "P1195": "file extension"
    , "P1196": "manner of death"
    , "P1198": "unemployment rate"
    , "P1199": "mode of inheritance"
    , "P1200": "bodies of water basin category"
    , "P1201": "space tug"
    , "P1202": "carries scientific instrument"
    , "P1203": "Finnish municipality number"
    , "P1204": "Wikimedia portal's main topic"
    , "P1207": "NUKAT ID"
    , "P1208": "ISMN"
    , "P1209": "CN"
    , "P1210": "supercharger"
    , "P1211": "fuel system"
    , "P1212": "Atlas ID"
    , "P1213": "NLC authorities"
    , "P1214": "Riksdagen person-ID"
    , "P1215": "apparent magnitude"
    , "P1216": "National Heritage List for England number"
    , "P1217": "Internet Broadway Database venue ID"
    , "P1218": "Internet Broadway Database production ID"
    , "P1219": "Internet Broadway Database show ID"
    , "P1220": "Internet Broadway Database person ID"
    , "P1221": "compressor type"
    , "P1225": "U.S. National Archives Identifier"
    , "P1227": "astronomical filter"
    , "P1229": "Openpolis ID"
    , "P1230": "JSTOR journal ID"
    , "P1232": "Linguist list code"
    , "P1233": "Internet Speculative Fiction Database author ID"
    , "P1234": "ISFDB publication ID"
    , "P1235": "ISFDB series ID"
    , "P1236": "Parsons code"
    , "P1237": "Box Office Mojo film ID"
    , "P1238": "Swedish Football Association player ID"
    , "P1239": "ISFDB publisher ID"
    , "P1240": "Danish Bibliometric Research Indicator level"
    , "P1241": "Swiss Football Association club number"
    , "P1242": "Theatricalia play ID"
    , "P1243": "ISRC"
    , "P1245": "OmegaWiki Defined Meaning"
    , "P1246": "patent number"
    , "P1247": "compression ratio"
    , "P1248": "KulturNav-ID"
    , "P1249": "time of earliest written record"
    , "P1250": "Danish Bibliometric Research Indicator (BFI) SNO/CNO"
    , "P1251": "ABS ASCL 2011 code"
    , "P1252": "AUSTLANG code"
    , "P1253": "BCU Ecrivainsvd"
    , "P1254": "Slovenska biografija ID"
    , "P1255": "HelveticArchives ID"
    , "P1256": "Iconclass notation"
    , "P1257": "depicts Iconclass notation"
    , "P1258": "Rotten Tomatoes ID"
    , "P1259": "coordinates of the point of view"
    , "P1260": "Swedish Open Cultural Heritage URI"
    , "P1261": "Rundata"
    , "P1262": "RA\u00c4 number"
    , "P1263": "NNDB people ID"
    , "P1264": "valid in period"
    , "P1265": "AlloCin\u00e9 film ID"
    , "P1266": "AlloCin\u00e9 person ID"
    , "P1267": "AlloCin\u00e9 series ID"
    , "P1268": "represents"
    , "P1269": "facet of"
    , "P1270": "Norwegian Register journal ID"
    , "P1271": "Norway Database for Statistics on Higher education publisher ID"
    , "P1272": "Norway Import Service and Registration Authority periodical code"
    , "P1273": "CANTIC ID"
    , "P1274": "ISFDB title ID"
    , "P1275": "Norway Import Service and Registration Authority publisher code"
    , "P1276": "Dictionnaire du Jura ID"
    , "P1277": "JUFO ID"
    , "P1278": "Legal Entity Identifier"
    , "P1279": "inflation rate"
    , "P1280": "CONOR ID"
    , "P1281": "WOEID"
    , "P1282": "OpenStreetMap tag or key"
    , "P1283": "filmography"
    , "P1284": "Munzinger person ID"
    , "P1285": "Munzinger Sport number"
    , "P1286": "Munzinger Pop ID"
    , "P1287": "KDG Komponisten der Gegenwart"
    , "P1288": "Kritisches Lexikon der Gegenwartsliteratur ID"
    , "P1289": "Kritisches Lexikon zur fremdsprachigen Gegenwartsliteratur ID"
    , "P1290": "godparent"
    , "P1291": "Association Authors of Switzerland ID"
    , "P1292": "DNB editions"
    , "P1293": "Royal Aero Club Aviator's Certificate ID"
    , "P1294": "WWF ecoregion code"
    , "P1295": "emissivity"
    , "P1296": "Gran Enciclop\u00e8dia Catalana ID"
    , "P1297": "IRS Employer Identification Number"
    , "P1299": "depicted by"
    , "P1300": "bibcode"
    , "P1301": "number of elevators"
    , "P1302": "primary destinations"
    , "P1303": "instrument"
    , "P1304": "central bank"
    , "P1305": "CTBUH Skyscraper Center building ID"
    , "P1307": "Swiss parliament ID"
    , "P1308": "officeholder"
    , "P1309": "EGAXA ID"
    , "P1310": "statement disputed by"
    , "P1311": "lostbridges.org ID"
    , "P1312": "has facet polytope"
    , "P1313": "office held by head of government"
    , "P1314": "number of spans"
    , "P1315": "NLA Trove ID"
    , "P1316": "Swedish Media Database ID"
    , "P1317": "floruit"
    , "P1318": "proved by"
    , "P1319": "earliest date"
    , "P1320": "OpenCorporates ID"
    , "P1321": "place of origin (Switzerland)"
    , "P1322": "dual to"
    , "P1323": "Terminologia Anatomica 98 ID"
    , "P1324": "source code repository"
    , "P1325": "external data available at"
    , "P1326": "latest date"
    , "P1327": "partner in business or sport"
    , "P1329": "phone number"
    , "P1330": "MusicBrainz instrument ID"
    , "P1331": "PACE member ID"
    , "P1332": "coordinates of northernmost point"
    , "P1333": "coordinates of southernmost point"
    , "P1334": "coordinates of easternmost point"
    , "P1335": "coordinates of westernmost point"
    , "P1336": "territory claimed by"
    , "P1338": "EPSG CRS"
    , "P1339": "number of injured"
    , "P1340": "eye color"
    , "P1341": "Italian Chamber of Deputies dati ID"
    , "P1342": "number of seats"
    , "P1343": "described by source"
    , "P1344": "participant in"
    , "P1345": "number of victims of killer"
    , "P1346": "winner"
    , "P1347": "military casualty classification"
    , "P1348": "AlgaeBase URL"
    , "P1349": "ploidy"
    , "P1350": "number of matches played/races/starts"
    , "P1351": "number of points/goals/set scored"
    , "P1352": "ranking"
    , "P1353": "original spelling"
    , "P1354": "shown with features"
    , "P1355": "number of wins"
    , "P1356": "number of losses"
    , "P1357": "number of draws/ties"
    , "P1358": "points for"
    , "P1359": "number of points/goals conceded"
    , "P1360": "Monte Carlo Particle Number"
    , "P1362": "Theaterlexikon der Schweiz ID"
    , "P1363": "points/goal scored by"
    , "P1364": "ITTF table tennis player ID"
    , "P1365": "replaces"
    , "P1366": "replaced by"
    , "P1367": "Art UK artist ID"
    , "P1368": "LNB ID"
    , "P1369": "Iranian National Heritage registration number"
    , "P1370": "IHSI ID"
    , "P1371": "ASI Monument ID"
    , "P1372": "binding of software library"
    , "P1373": "daily patronage"
    , "P1375": "NSK ID"
    , "P1376": "capital of"
    , "P1377": "MTR station code"
    , "P1378": "China railway TMIS station code"
    , "P1380": "BridgeReports.com ID"
    , "P1381": "bridgehunter.com ID"
    , "P1382": "partially coincident with"
    , "P1383": "contains settlement"
    , "P1385": "Enciclop\u00e9dia A\u00e7oriana ID"
    , "P1386": "Japanese High School Code"
    , "P1387": "political alignment"
    , "P1388": "German regional key"
    , "P1389": "product certification"
    , "P1390": "match time of event"
    , "P1391": "Index Fungorum ID"
    , "P1392": "ComicBookDB ID"
    , "P1393": "proxy"
    , "P1394": "Glottolog code"
    , "P1395": "National Cancer Institute ID"
    , "P1396": "Linguasphere code"
    , "P1397": "State Catalogue of Geographical Names (Russia) ID"
    , "P1398": "structure replaces"
    , "P1399": "convicted of"
    , "P1400": "FCC Facility ID"
    , "P1401": "bug tracking system"
    , "P1402": "Foundational Model of Anatomy ID"
    , "P1403": "original combination"
    , "P1404": "World Glacier Inventory ID"
    , "P1406": "script directionality"
    , "P1407": "MusicBrainz series ID"
    , "P1408": "licensed to broadcast to"
    , "P1409": "Cycling Archives cyclist ID"
    , "P1410": "number of representatives in an organization/legislature or won in elections"
    , "P1411": "nominated for"
    , "P1412": "languages spoken, written or signed"
    , "P1414": "GUI toolkit or framework"
    , "P1415": "Oxford Dictionary of National Biography ID"
    , "P1416": "affiliation"
    , "P1417": "Encyclop\u00e6dia Britannica Online ID"
    , "P1418": "orbits completed"
    , "P1419": "shape"
    , "P1420": "taxon synonym"
    , "P1421": "GRIN URL"
    , "P1422": "Sandrart.net person ID"
    , "P1423": "template's main topic"
    , "P1424": "topic's main template"
    , "P1425": "ecoregion (WWF)"
    , "P1427": "start point"
    , "P1428": "Lost Art ID"
    , "P1429": "has pet"
    , "P1430": "OpenPlaques subject ID"
    , "P1431": "executive producer"
    , "P1433": "published in"
    , "P1434": "takes place in fictional universe"
    , "P1435": "heritage designation"
    , "P1436": "collection or exhibition size"
    , "P1437": "plea"
    , "P1438": "Jewish Encyclopedia ID (Russian)"
    , "P1439": "Norwegian filmography ID"
    , "P1440": "FIDE player ID"
    , "P1441": "present in work"
    , "P1442": "image of grave"
    , "P1443": "score method"
    , "P1444": "destination point"
    , "P1445": "fictional universe described in"
    , "P1446": "number of missing"
    , "P1447": "Sports-Reference.com Olympic athlete ID"
    , "P1448": "official name"
    , "P1449": "nickname"
    , "P1450": "Sandbox-Monolingual text"
    , "P1451": "motto text"
    , "P1453": "catholic.ru ID"
    , "P1454": "legal form"
    , "P1455": "list of works"
    , "P1456": "list of monuments"
    , "P1457": "absolute magnitude"
    , "P1458": "color index"
    , "P1459": "Cadw Building ID"
    , "P1460": "NIEA building ID"
    , "P1461": "Patientplus ID"
    , "P1462": "standards body"
    , "P1463": "Post-Reformation Digital Library author ID"
    , "P1464": "category for people born here"
    , "P1465": "category for people who died here"
    , "P1466": "WALS lect code"
    , "P1467": "WALS genus code"
    , "P1468": "WALS family code"
    , "P1469": "FIFA player ID"
    , "P1470": "maximum glide ratio"
    , "P1471": "reporting mark"
    , "P1472": "Commons Creator page"
    , "P1473": "Nupill Literatura Digital - Author"
    , "P1474": "Nupill Literatura Digital - Document"
    , "P1476": "title"
    , "P1477": "birth name"
    , "P1478": "has immediate cause"
    , "P1479": "has contributing factor"
    , "P1480": "sourcing circumstances"
    , "P1481": "vici.org ID"
    , "P1482": "Stack Exchange tag"
    , "P1483": "kulturnoe-nasledie.ru ID"
    , "P1529": "Gertrude identifier"
    , "P1531": "parent of this hybrid, breed, or cultivar"
    , "P1532": "country for sport"
    , "P1533": "family name identical to this given name"
    , "P1534": "end cause"
    , "P1535": "used by"
    , "P1536": "immediate cause of"
    , "P1537": "contributing factor of"
    , "P1538": "number of households"
    , "P1539": "female population"
    , "P1540": "male population"
    , "P1541": "CQ Ranking male cyclist ID"
    , "P1542": "has effect"
    , "P1543": "monogram"
    , "P1544": "Federal Register Document Number"
    , "P1545": "series ordinal"
    , "P1546": "motto"
    , "P1547": "depends on software"
    , "P1548": "maximum Strahler number"
    , "P1549": "demonym"
    , "P1550": "Orphanet ID"
    , "P1551": "Exceptional heritage of Wallonia ID"
    , "P1552": "has quality"
    , "P1553": "Yandex Music artist ID"
    , "P1554": "UBERON ID"
    , "P1555": "Executive Order number"
    , "P1556": "zbMATH author ID"
    , "P1557": "manifestation of"
    , "P1558": "tempo marking"
    , "P1559": "name in native language_code"
    , "P1560": "given name version for other gender"
    , "P1561": "number of survivors"
    , "P1562": "AllMovie movie ID"
    , "P1563": "MacTutor biography ID"
    , "P1564": "At the Circulating Library ID"
    , "P1565": "Enciclopedia de la Literatura en M\u00e9xico ID"
    , "P1566": "GeoNames ID"
    , "P1567": "NIS/INS code"
    , "P1568": "definition domain"
    , "P1571": "codomain"
    , "P1573": "BBC Genome ID"
    , "P1574": "exemplar of"
    , "P1575": "RISS catalog"
    , "P1576": "lifestyle"
    , "P1577": "Gregory-Aland-Number"
    , "P1578": "Gmelin number"
    , "P1579": "Reaxys registry number"
    , "P1580": "University of Barcelona authority ID"
    , "P1581": "official blog"
    , "P1582": "natural product of taxon"
    , "P1583": "MalaCards ID"
    , "P1584": "Pleiades ID"
    , "P1585": "Brazilian municipality code"
    , "P1586": "Catalan object of cultural interest ID"
    , "P1587": "Slovene Cultural Heritage Register ID"
    , "P1588": "village code of Indonesia"
    , "P1589": "lowest point"
    , "P1590": "number of casualties"
    , "P1591": "defendant"
    , "P1592": "prosecutor"
    , "P1593": "defender"
    , "P1594": "judge"
    , "P1595": "charge"
    , "P1596": "penalty"
    , "P1598": "consecrator"
    , "P1599": "Cambridge Alumni Database ID"
    , "P1600": "Inventari del Patrimoni Arquitect\u00f2nic de Catalunya code"
    , "P1601": "Esperantist ID"
    , "P1602": "Art UK venue ID"
    , "P1603": "number of cases"
    , "P1604": "biosafety level"
    , "P1605": "has natural reservoir"
    , "P1606": "natural reservoir of"
    , "P1607": "Dialnet author ID"
    , "P1608": "Dialnet book ID"
    , "P1609": "Dialnet journal ID"
    , "P1610": "Dialnet article ID"
    , "P1611": "NATO code for grade"
    , "P1612": "Commons Institution page"
    , "P1613": "IRC channel"
    , "P1614": "History of Parliament ID"
    , "P1615": "CLARA-ID"
    , "P1616": "SIREN number"
    , "P1617": "BBC Things ID"
    , "P1618": "sport number"
    , "P1619": "date of official opening"
    , "P1620": "plaintiff"
    , "P1621": "detail map"
    , "P1622": "driving side"
    , "P1624": "MarineTraffic Port ID"
    , "P1625": "has melody"
    , "P1626": "Thai cultural heritage ID"
    , "P1627": "Ethnologue.com language_code code"
    , "P1628": "equivalent property"
    , "P1629": "subject item of this property"
    , "P1630": "formatter URL"
    , "P1631": "China Vitae ID"
    , "P1632": "Hermann-Mauguin notation"
    , "P1635": "religious name"
    , "P1636": "date of baptism in early childhood"
    , "P1637": "undercarriage"
    , "P1638": "codename"
    , "P1639": "pendant of"
    , "P1640": "curator"
    , "P1641": "port"
    , "P1642": "acquisition transaction"
    , "P1643": "departure transaction"
    , "P1644": "messes.info Catholic church ID"
    , "P1645": "NIST/CODATA ID"
    , "P1647": "subproperty of"
    , "P1648": "Dictionary of Welsh Biography ID"
    , "P1649": "KMDb person ID"
    , "P1650": "BBF ID"
    , "P1651": "YouTube video ID"
    , "P1652": "referee"
    , "P1653": "TERYT municipality code"
    , "P1654": "wing configuration"
    , "P1656": "unveiled by"
    , "P1657": "MPAA film rating"
    , "P1659": "see also"
    , "P1660": "has index case"
    , "P1661": "Alexa rank"
    , "P1662": "DOI prefix"
    , "P1663": "ProCyclingStats cyclist ID"
    , "P1664": "Cycling Database ID"
    , "P1665": "ChessGames.com player ID"
    , "P1666": "Chess Club ID"
    , "P1667": "Getty Thesaurus of Geographic Names ID"
    , "P1668": "ATCvet"
    , "P1669": "Cultural Objects Names Authority ID"
    , "P1670": "Canadiana Authorities ID"
    , "P1671": "route number"
    , "P1672": "this taxon is source of"
    , "P1673": "general formula"
    , "P1674": "number confirmed"
    , "P1675": "number probable"
    , "P1676": "number suspected"
    , "P1677": "index case of"
    , "P1678": "has vertex figure"
    , "P1679": "Art UK artwork ID"
    , "P1680": "subtitle"
    , "P1683": "quotation"
    , "P1684": "inscription"
    , "P1685": "Pok\u00e9dex / Pok\u00e9mon browser number"
    , "P1686": "for work"
    , "P1687": "Wikidata property"
    , "P1689": "central government debt as a percent of GDP"
    , "P1690": "ICD-10-PCS"
    , "P1691": "operations and procedures key (OPS)"
    , "P1692": "ICD-9-CM"
    , "P1693": "Terminologia Embryologica"
    , "P1694": "Terminologia Histologica"
    , "P1695": "NLP ID (unique)"
    , "P1696": "inverse property"
    , "P1697": "total valid votes"
    , "P1699": "SkyscraperPage building ID"
    , "P1700": "SIPA ID"
    , "P1702": "DGPC ID"
    , "P1703": "is pollinated by"
    , "P1704": "is pollinator of"
    , "P1705": "native label"
    , "P1706": "together with"
    , "P1707": "DAAO ID"
    , "P1708": "LfDS object ID"
    , "P1709": "equivalent class"
    , "P1710": "S\u00e4chsische Biografie ID"
    , "P1711": "British Museum person or institution ID"
    , "P1712": "Metacritic ID"
    , "P1713": "biography at the Bundestag of Germany URL"
    , "P1714": "Journalisted ID"
    , "P1715": "RKD/ESD (Slovenia) ID"
    , "P1716": "brand"
    , "P1717": "SANDRE ID"
    , "P1721": "pinyin transliteration"
    , "P1725": "beats per minute"
    , "P1726": "Florentine musea Inventario 1890 ID"
    , "P1727": "Flora of North America taxon ID"
    , "P1728": "AllMusic artist ID"
    , "P1729": "AllMusic album ID"
    , "P1730": "AllMusic song ID"
    , "P1731": "Fach"
    , "P1732": "Naturbase ID"
    , "P1733": "Steam application ID"
    , "P1734": "oath of office date"
    , "P1735": "Comedien.ch ID"
    , "P1736": "Information Center for Israeli Art artist ID"
    , "P1738": "Merck Index monograph"
    , "P1739": "CiNii book ID"
    , "P1740": "category for films shot at this location"
    , "P1741": "GTAA ID"
    , "P1743": "Bradley and Fletcher checklist number"
    , "P1744": "Agassiz checklist number"
    , "P1745": "VASCAN ID"
    , "P1746": "ZooBank ID for name or act"
    , "P1747": "Flora of China ID"
    , "P1748": "NCI Thesaurus ID"
    , "P1749": "Parlement & Politiek ID"
    , "P1750": "name day"
    , "P1751": "Art UK collection ID"
    , "P1752": "scale"
    , "P1753": "list related to category"
    , "P1754": "category related to list"
    , "P1755": "Aviation Safety Network accident ID"
    , "P1760": "Aviation Safety Network Wikibase Occurrence"
    , "P1761": "Watson & Dallwitz family ID"
    , "P1762": "Hornbostel-Sachs classification"
    , "P1763": "National Pipe Organ Register ID"
    , "P1764": "Flemish Heritage Object ID"
    , "P1766": "place name sign"
    , "P1769": "denkXweb identifier"
    , "P1770": "Romania LMI code"
    , "P1771": "Integrated Postsecondary Education Data System ID"
    , "P1772": "USDA PLANTS ID"
    , "P1774": "workshop of"
    , "P1775": "follower of"
    , "P1776": "circle of"
    , "P1777": "manner of"
    , "P1778": "forgery after"
    , "P1779": "possible creator"
    , "P1780": "school of"
    , "P1782": "courtesy name"
    , "P1785": "temple name"
    , "P1786": "posthumous name"
    , "P1787": "art-name"
    , "P1788": "DVN ID"
    , "P1789": "chief operating officer"
    , "P1791": "category of people buried here"
    , "P1792": "category of associated people"
    , "P1793": "format as a regular expression"
    , "P1794": "bureau du patrimoine de Seine-Saint-Denis ID"
    , "P1795": "Smithsonian American Art Museum person/institution ID"
    , "P1796": "International Standard Industrial Classification code Rev.4"
    , "P1798": "ISO 639-5 code"
    , "P1799": "Maltese Islands National Inventory of Cultural OntologyPropertyReference ID"
    , "P1800": "Wikimedia database name"
    , "P1801": "commemorative plaque image"
    , "P1802": "EMLO person ID"
    , "P1803": "Masaryk University person ID"
    , "P1804": "DNF film ID"
    , "P1806": "ABoK number"
    , "P1807": "Great Aragonese Encyclopedia ID"
    , "P1808": "senat.fr ID"
    , "P1809": "choreographer"
    , "P1810": "named as"
    , "P1811": "list of episodes"
    , "P1813": "short name"
    , "P1814": "name in kana"
    , "P1815": "RSL scanned books identifier"
    , "P1816": "National Portrait Gallery (London) person ID"
    , "P1817": "addressee"
    , "P1818": "Kaiserhof ID"
    , "P1819": "genealogics.org person ID"
    , "P1820": "Open Food Facts food additive ID"
    , "P1821": "Open Food Facts food category ID"
    , "P1822": "DSH object ID"
    , "P1823": "BAnQ work ID"
    , "P1824": "road number"
    , "P1825": "Baseball-Reference.com major league player ID"
    , "P1826": "Baseball-Reference.com minor & foreign league player ID"
    , "P1827": "ISWC"
    , "P1828": "IPI name number"
    , "P1829": "Roud Folk Song Index number"
    , "P1830": "owner of"
    , "P1831": "electorate"
    , "P1832": "GrassBase ID"
    , "P1833": "number of registered users/contributors"
    , "P1836": "draft pick number"
    , "P1837": "Gaoloumi ID"
    , "P1838": "PSS-archi ID"
    , "P1839": "US Federal Election Commission ID"
    , "P1840": "investigated by"
    , "P1841": "Swedish district code"
    , "P1842": "Global Anabaptist Mennonite Encyclopedia Online ID"
    , "P1843": "taxon common name"
    , "P1844": "HathiTrust ID"
    , "P1845": "anti-virus alias"
    , "P1846": "distribution map"
    , "P1847": "Nasjonalbiblioteket photographer ID"
    , "P1848": "protected areas INPN Code"
    , "P1849": "SSR WrittenForm ID"
    , "P1850": "SSR place name number"
    , "P1851": "input set"
    , "P1852": "Perry Index"
    , "P1853": "blood type"
    , "P1854": "Kiev street code"
    , "P1855": "Wikidata property example"
    , "P1866": "Catholic Hierarchy diocese ID"
    , "P1867": "eligible voters"
    , "P1868": "ballots cast"
    , "P1869": "Hall of Valor ID"
    , "P1870": "Name Assigning Authority Number"
    , "P1871": "CERL Thesaurus ID"
    , "P1872": "minimum number of players"
    , "P1873": "maximum number of players"
    , "P1874": "Netflix ID"
    , "P1875": "represented by"
    , "P1876": "vehicle"
    , "P1877": "after a work by"
    , "P1878": "Vox-ATypI classification"
    , "P1879": "income classification (Philippines)"
    , "P1880": "measurement scale"
    , "P1881": "list of characters"
    , "P1882": "Web Gallery of Art ID"
    , "P1883": "Declarator.org ID"
    , "P1884": "hair color"
    , "P1885": "cathedral"
    , "P1886": "Smithsonian volcano ID"
    , "P1887": "vice-county"
    , "P1888": "Dictionary of Medieval Names from European Sources entry"
    , "P1889": "different from"
    , "P1890": "CCAB ID"
    , "P1891": "signatory"
    , "P1893": "OpenPlaques plaque ID"
    , "P1894": "Danish urban area code"
    , "P1895": "Fauna Europaea ID"
    , "P1896": "source website for the property"
    , "P1897": "highest note"
    , "P1898": "lowest note"
    , "P1899": "LibriVox author ID"
    , "P1900": "EAGLE id"
    , "P1901": "BALaT person/organisation id"
    , "P1902": "Spotify artist ID"
    , "P1903": "volcanic explosivity index"
    , "P1906": "office held by head of state"
    , "P1907": "Australian Dictionary of Biography ID"
    , "P1908": "CWGC person ID"
    , "P1909": "side effect"
    , "P1910": "decreased expression in"
    , "P1911": "increased expression in"
    , "P1912": "deletion association with"
    , "P1913": "gene duplication association with"
    , "P1914": "gene insertion association with"
    , "P1915": "gene inversion association with"
    , "P1916": "gene substitution association with"
    , "P1917": "posttranslational modification association with"
    , "P1918": "altered regulation leads to"
    , "P1919": "Ministry of Education of Chile school ID"
    , "P1920": "CWGC burial ground ID"
    , "P1921": "formatter URI for RDF resource"
    , "P1922": "first line"
    , "P1923": "participating team"
    , "P1924": "vaccine for"
    , "P1925": "VIOLIN ID"
    , "P1928": "Vaccine Ontology ID"
    , "P1929": "ClinVar Variation ID"
    , "P1930": "DSM-5 classification"
    , "P1931": "NIOSH Pocket Guide ID"
    , "P1932": "stated as"
    , "P1933": "MobyGames game ID"
    , "P1934": "Animator.ru film ID"
    , "P1935": "Database of Classical Scholars ID"
    , "P1936": "Digital Atlas of the Roman Empire ID"
    , "P1937": "UN/LOCODE"
    , "P1938": "Project Gutenberg author ID"
    , "P1939": "Dyntaxa ID"
    , "P1940": "conifers.org ID"
    , "P1942": "McCune-Reischauer romanization"
    , "P1943": "location map"
    , "P1944": "relief location map"
    , "P1945": "street key"
    , "P1947": "Mapillary ID"
    , "P1948": "BerlPap identifier"
    , "P1949": "CulturaItalia ID"
    , "P1950": "second family name in Spanish name"
    , "P1951": "investor"
    , "P1952": "Encyclopaedia Metallum band ID"
    , "P1953": "Discogs artist ID"
    , "P1954": "Discogs master ID"
    , "P1955": "Discogs label ID"
    , "P1956": "takeoff and landing capability"
    , "P1957": "Wikisource index page"
    , "P1958": "Trismegistos Geo ID"
    , "P1959": "Dutch Senate person ID"
    , "P1960": "Google Scholar author ID"
    , "P1961": "CTHS society ID"
    , "P1963": "properties for this type"
    , "P1966": "Biblioteca Nacional de Chile catalogue number"
    , "P1967": "BoxRec boxer ID"
    , "P1968": "Foursquare venue ID"
    , "P1969": "MovieMeter director ID"
    , "P1970": "MovieMeter film ID"
    , "P1971": "number of children"
    , "P1972": "Open Hub ID"
    , "P1973": "RSL editions"
    , "P1976": "INEGI locality ID"
    , "P1977": "Les Archives du Spectacle Person ID"
    , "P1978": "USDA NDB number"
    , "P1979": "Righteous Among The Nations ID"
    , "P1980": "PolSys ID"
    , "P1981": "FSK film rating"
    , "P1982": "Anime News Network person ID"
    , "P1983": "Anime News Network company ID"
    , "P1984": "Anime News Network manga ID"
    , "P1985": "Anime News Network anime ID"
    , "P1986": "Treccani's Dizionario biografico degli italiani ID"
    , "P1987": "MCN code"
    , "P1988": "Le Delarge ID"
    , "P1989": "Encyclopaedia Metallum artist ID"
    , "P1990": "species kept"
    , "P1991": "LPSN URL"
    , "P1992": "Plazi ID"
    , "P1993": "TeX string"
    , "P1994": "AllMusic composition ID"
    , "P1995": "health specialty"
    , "P1996": "parliament.uk biography pages"
    , "P1997": "Facebook Places ID"
    , "P1998": "UCI code"
    , "P1999": "UNESCO language_code status"
    , "P2000": "CPDL ID"
    , "P2001": "Revised Romanization"
    , "P2002": "Twitter username"
    , "P2003": "Instagram username"
    , "P2004": "NALT ID"
    , "P2005": "Catalogus Professorum Halensis ID"
    , "P2006": "ZooBank author ID"
    , "P2007": "ZooBank publication ID"
    , "P2008": "IPNI publication ID"
    , "P2009": "Exif model"
    , "P2010": "Exif make"
    , "P2011": "Cooper-Hewitt Person ID"
    , "P2012": "cuisine"
    , "P2013": "Facebook ID"
    , "P2014": "Museum of Modern Art work ID"
    , "P2015": "Hansard (1803\u20132005) ID"
    , "P2016": "Catalogus Professorum Academiae Groninganae id"
    , "P2017": "isomeric SMILES"
    , "P2018": "Teuchos ID"
    , "P2019": "AllMovie person ID"
    , "P2020": "WorldFootball.net player ID"
    , "P2021": "Erd\u0151s number"
    , "P2024": "German cattle breed ID"
    , "P2025": "Find A Grave cemetery ID"
    , "P2026": "Avibase ID"
    , "P2027": "Colour Index International constitution ID"
    , "P2028": "United States Armed Forces service number"
    , "P2029": "Dictionary of Ulster Biography ID"
    , "P2030": "NASA biographical ID"
    , "P2031": "work period (start)"
    , "P2032": "work period (end)"
    , "P2033": "category for pictures taken with camera"
    , "P2034": "Project Gutenberg ebook ID"
    , "P2036": "African Plant Database ID"
    , "P2037": "GitHub username"
    , "P2038": "ResearchGate profile ID"
    , "P2040": "CITES Species+ ID"
    , "P2041": "National Gallery of Victoria artist ID"
    , "P2042": "Artsy artist ID"
    , "P2043": "length"
    , "P2044": "elevation above sea level"
    , "P2045": "orbital inclination"
    , "P2046": "area"
    , "P2047": "duration"
    , "P2048": "height"
    , "P2049": "width"
    , "P2050": "wingspan"
    , "P2051": "M sin i"
    , "P2052": "speed"
    , "P2053": "watershed area"
    , "P2054": "density"
    , "P2055": "electrical conductivity"
    , "P2056": "heat capacity"
    , "P2057": "Human Metabolome Database ID"
    , "P2058": "depositor"
    , "P2060": "luminosity"
    , "P2061": "aspect ratio"
    , "P2062": "HSDB ID"
    , "P2063": "LIPID MAPS ID"
    , "P2064": "KNApSAcK ID"
    , "P2065": "NIAID ChemDB ID"
    , "P2066": "fusion enthalpy"
    , "P2067": "mass"
    , "P2068": "thermal conductivity"
    , "P2069": "magnetic moment"
    , "P2070": "Fellow of the Royal Society ID"
    , "P2071": "M\u00e9moire des hommes ID"
    , "P2072": "CDB Chemical ID"
    , "P2073": "vehicle range"
    , "P2074": "internetmedicin.se ID"
    , "P2075": "speed of sound"
    , "P2076": "temperature"
    , "P2077": "pressure"
    , "P2078": "user manual URL"
    , "P2079": "fabrication method"
    , "P2080": "AcademiaNet ID"
    , "P2081": "BLDAM object ID"
    , "P2082": "M.49 code"
    , "P2083": "Leadscope ID"
    , "P2084": "ZINC ID"
    , "P2085": "Nikkaji ID"
    , "P2086": "CDD Public ID"
    , "P2087": "Crunchbase person ID"
    , "P2088": "Crunchbase organization ID"
    , "P2089": "Library of Congress JukeBox ID"
    , "P2090": "Power of 10 athlete ID"
    , "P2091": "World Rowing ID"
    , "P2092": "Bildindex der Kunst und Architektur ID"
    , "P2093": "author name string"
    , "P2094": "competition class"
    , "P2095": "co-driver"
    , "P2096": "media legend"
    , "P2097": "term length of office"
    , "P2098": "substitute/deputy/replacement of office/officeholder"
    , "P2099": "BC Geographical Names ID"
    , "P2100": "Banque de noms de lieux du Qu\u00e9bec ID"
    , "P2101": "melting point"
    , "P2102": "boiling point"
    , "P2103": "size of team at start"
    , "P2105": "size of team at finish"
    , "P2106": "RXNO Ontology"
    , "P2107": "decomposition point"
    , "P2108": "Kunstindeks Danmark artwork ID"
    , "P2109": "installed capacity"
    , "P2112": "wing area"
    , "P2113": "sublimation temperature"
    , "P2114": "half-life"
    , "P2115": "NDF-RT ID"
    , "P2116": "enthalpy of vaporization"
    , "P2117": "combustion enthalpy"
    , "P2118": "kinematic viscosity"
    , "P2119": "vapor pressure"
    , "P2120": "radius"
    , "P2121": "prize money"
    , "P2123": "YerelNet village ID"
    , "P2124": "member count"
    , "P2125": "Revised Hepburn romanization"
    , "P2126": "Georgian national system of romanization"
    , "P2127": "International Nuclear Event Scale"
    , "P2128": "flash point"
    , "P2129": "immediately dangerous to life or health"
    , "P2130": "cost"
    , "P2131": "nominal GDP"
    , "P2132": "nominal GDP per capita"
    , "P2133": "total debt"
    , "P2134": "total reserves"
    , "P2135": "total exports"
    , "P2136": "total imports"
    , "P2137": "total equity"
    , "P2138": "total liabilities"
    , "P2139": "total revenue"
    , "P2140": "foreign direct investment net outflow"
    , "P2141": "foreign direct investment net inflow"
    , "P2142": "box office"
    , "P2143": "genome size"
    , "P2144": "frequency"
    , "P2145": "explosive energy equivalent"
    , "P2146": "orbital period"
    , "P2147": "rotation period"
    , "P2148": "distance from river mouth"
    , "P2149": "clock speed"
    , "P2150": "FSB speed"
    , "P2151": "focal length"
    , "P2152": "antiparticle"
    , "P2153": "PubChem Substance ID (SID)"
    , "P2154": "binding energy"
    , "P2155": "solid solution series with"
    , "P2156": "pseudo crystal habit"
    , "P2158": "Cell Line Ontology ID"
    , "P2159": "solves"
    , "P2160": "mass excess"
    , "P2161": "Guthrie code"
    , "P2162": "Deutsche Ultramarathon-Vereinigung ID"
    , "P2163": "FAST ID"
    , "P2164": "SIGIC author ID"
    , "P2165": "SIGIC group ID"
    , "P2166": "SIGIC institution ID"
    , "P2167": "UNSPSC Code"
    , "P2168": "Swedish Film Database person ID"
    , "P2169": "PublicWhip ID"
    , "P2170": "Hansard (2006\u2013March 2016) ID"
    , "P2171": "TheyWorkForYou ID"
    , "P2172": "Parliamentary record identifier"
    , "P2173": "BBC News Democracy Live ID"
    , "P2174": "Museum of Modern Art artist ID"
    , "P2175": "medical condition treated"
    , "P2176": "drug used for treatment"
    , "P2177": "solubility"
    , "P2178": "solvent"
    , "P2179": "ACM Classification Code (2012)"
    , "P2180": "Kansallisbiografia ID"
    , "P2181": "Finnish MP ID"
    , "P2182": "Finnish Ministers database ID"
    , "P2183": "ISO 9:1995"
    , "P2184": "history of topic"
    , "P2185": "DLI ID"
    , "P2186": "Wiki Loves Monuments ID"
    , "P2187": "BiblioNet publication ID"
    , "P2188": "BiblioNet author ID"
    , "P2189": "BiblioNet publisher ID"
    , "P2190": "C-SPAN person ID"
    , "P2191": "Vegetti Catalog of Fantastic Literature NILF ID"
    , "P2192": "endangeredlanguages.com ID"
    , "P2193": "Soccerbase player ID"
    , "P2194": "PSS-archi architect ID"
    , "P2195": "Soccerbase manager ID"
    , "P2196": "students count"
    , "P2197": "production rate"
    , "P2198": "average gradient"
    , "P2199": "autoignition temperature"
    , "P2200": "electric charge"
    , "P2201": "electric dipole moment"
    , "P2202": "lower flammable limit"
    , "P2203": "upper flammable limit"
    , "P2204": "minimum explosive concentration"
    , "P2205": "Spotify album ID"
    , "P2206": "Discogs release ID"
    , "P2207": "Spotify track ID"
    , "P2208": "average shot length"
    , "P2209": "SourceForge project"
    , "P2210": "relative to"
    , "P2211": "position angle"
    , "P2212": "angular distance"
    , "P2213": "longitude of ascending node"
    , "P2214": "parallax"
    , "P2215": "proper motion"
    , "P2216": "radial velocity"
    , "P2217": "cruise speed"
    , "P2218": "net worth"
    , "P2219": "real gross domestic product growth rate"
    , "P2220": "household wealth"
    , "P2221": "flux"
    , "P2222": "gyromagnetic ratio"
    , "P2223": "decay width"
    , "P2225": "discharge"
    , "P2226": "market capitalization"
    , "P2227": "metallicity"
    , "P2228": "maximum thrust"
    , "P2229": "thermal design power"
    , "P2230": "torque"
    , "P2231": "explosive velocity"
    , "P2232": "cash"
    , "P2233": "semi-major axis of an orbit"
    , "P2234": "volume as quantity"
    , "P2235": "external superproperty"
    , "P2236": "external subproperty"
    , "P2238": "official symbol"
    , "P2239": "first aid measures"
    , "P2240": "median lethal dose (LD50)"
    , "P2241": "reason for deprecation"
    , "P2242": "Florentine musea catalogue ID"
    , "P2243": "apoapsis"
    , "P2244": "periapsis"
    , "P2248": "argument of periapsis"
    , "P2249": "RefSeq genome ID"
    , "P2250": "life expectancy"
    , "P2252": "National Gallery of Art artist ID"
    , "P2253": "DfE URN"
    , "P2254": "maximum operating altitude"
    , "P2255": "Debrett's People of Today ID"
    , "P2257": "event interval"
    , "P2258": "mobile country code"
    , "P2259": "mobile network code"
    , "P2260": "ionization energy"
    , "P2261": "beam"
    , "P2262": "draft"
    , "P2263": "ISOCAT id"
    , "P2264": "mix'n'match catalog ID"
    , "P2266": "FMD model ID"
    , "P2267": "PolitiFact people and groups ID"
    , "P2268": "Mus\u00e9e d'Orsay artist ID"
    , "P2270": "Emporis building complex ID"
    , "P2271": "Wikidata property example for properties"
    , "P2272": "Hederich encyclopedia article ID"
    , "P2273": "Heidelberg Academy for Sciences and Humanities member ID"
    , "P2275": "World Health Organisation International Nonproprietary Name"
    , "P2276": "UEFA player ID"
    , "P2277": "Magdeburger Biographisches Lexikon"
    , "P2278": "Member of the Hellenic Parliament ID"
    , "P2279": "ambitus"
    , "P2280": "Austrian Parliament ID"
    , "P2281": "Apple Music album ID"
    , "P2282": "Groeningemuseum work PID"
    , "P2283": "uses"
    , "P2284": "price"
    , "P2285": "periapsis date"
    , "P2286": "arterial supply"
    , "P2287": "CRIStin ID"
    , "P2288": "lymphatic drainage"
    , "P2289": "venous drainage"
    , "P2290": "Danish parish code"
    , "P2291": "charted in"
    , "P2292": "consumption rate"
    , "P2293": "genetic association"
    , "P2294": "balance of trade"
    , "P2295": "net profit"
    , "P2296": "money supply"
    , "P2297": "employment by economic sector"
    , "P2298": "NSDAP membership number (1925\u20131945)"
    , "P2299": "PPP GDP per capita"
    , "P2300": "minimal lethal dose"
    , "P2302": "property constraint"
    , "P2303": "exception to constraint"
    , "P2304": "group by"
    , "P2305": "item of property constraint"
    , "P2306": "property"
    , "P2307": "namespace"
    , "P2308": "class"
    , "P2309": "relation"
    , "P2310": "minimum date (property constraint)"
    , "P2311": "maximum date (property constraint)"
    , "P2312": "maximum value"
    , "P2313": "minimum value"
    , "P2315": "comment (DEPRECATED)"
    , "P2316": "constraint status"
    , "P2317": "call sign"
    , "P2318": "debut participant"
    , "P2319": "elector"
    , "P2320": "aftershocks"
    , "P2321": "general classification of race participants"
    , "P2322": "article ID"
    , "P2323": "Swedish Olympic Committee athlete ID"
    , "P2324": "quantity buried"
    , "P2325": "mean anomaly"
    , "P2326": "GNS Unique Feature ID"
    , "P2327": "ProCyclingStats race ID"
    , "P2328": "ProCyclingStats team ID"
    , "P2329": "antagonist muscle"
    , "P2330": "Cycling Archives race ID"
    , "P2331": "Cycling Archives team ID"
    , "P2332": "Dictionary of Art Historians ID"
    , "P2333": "Norwegian organisation number"
    , "P2334": "Swedish Film Database film ID"
    , "P2335": "Swedish Film Database company ID"
    , "P2336": "Swedish Film Database soundtrack ID"
    , "P2337": "Swedish Film Database group ID"
    , "P2338": "Musopen composer ID"
    , "P2339": "BoardGameGeek ID"
    , "P2340": "CESAR person ID"
    , "P2341": "indigenous to"
    , "P2342": "AGORHA person/institution ID"
    , "P2343": "playing range image"
    , "P2344": "AGORHA work ID"
    , "P2345": "AGORHA event identifier"
    , "P2346": "Elonet movie ID"
    , "P2347": "YSO ID"
    , "P2348": "time period"
    , "P2349": "Stuttgart Database of Scientific Illustrators ID"
    , "P2350": "SpeedSkatingBase.eu ID"
    , "P2351": "number of graves"
    , "P2352": "applies to taxon"
    , "P2353": "statistical unit"
    , "P2354": "has list"
    , "P2355": "UNESCO Atlas of the World's Languages in Danger ID"
    , "P2357": "Classification of Instructional Programs code"
    , "P2358": "Roman praenomen"
    , "P2359": "Roman nomen gentilicium"
    , "P2360": "intended public"
    , "P2361": "online service"
    , "P2362": "time to altitude"
    , "P2363": "NMHH film rating"
    , "P2364": "production code"
    , "P2365": "Roman cognomen"
    , "P2366": "Roman agnomen"
    , "P2367": "Australian Stratigraphic Units Database ID"
    , "P2368": "Sandbox-OntologyPropertyReference"
    , "P2369": "Soccerway player ID"
    , "P2370": "conversion to SI unit"
    , "P2371": "FAO risk status"
    , "P2372": "ODIS ID"
    , "P2373": "Genius artist ID"
    , "P2374": "natural abundance"
    , "P2375": "has superpartner"
    , "P2376": "superpartner of"
    , "P2377": "MediaWiki hooks used"
    , "P2378": "issued by"
    , "P2379": "deprecated in version"
    , "P2380": "French Sculpture Census artist ID"
    , "P2381": "Academic Tree ID"
    , "P2382": "Chemins de m\u00e9moire ID"
    , "P2383": "CTHS person ID"
    , "P2384": "statement describes"
    , "P2385": "French diocesan architects ID"
    , "P2386": "diameter"
    , "P2387": "Elonet person ID"
    , "P2388": "office held by head of the organization"
    , "P2389": "organization directed by the office or person"
    , "P2390": "Ballotpedia ID"
    , "P2391": "OKPO ID"
    , "P2392": "teaching method"
    , "P2393": "NCBI locus tag"
    , "P2394": "MGI Gene Symbol"
    , "P2396": "image of function"
    , "P2397": "YouTube channel ID"
    , "P2398": "MLS player ID"
    , "P2399": "British Council artist ID"
    , "P2400": "JMDb film ID"
    , "P2401": "Six Degrees of Francis Bacon ID"
    , "P2402": "total expenditure"
    , "P2403": "total assets"
    , "P2404": "time-weighted average exposure limit"
    , "P2405": "ceiling exposure limit"
    , "P2406": "maximum peak exposure limit"
    , "P2407": "short-term exposure limit"
    , "P2408": "set in period"
    , "P2409": "CiNii article ID"
    , "P2410": "WikiPathways ID"
    , "P2411": "Artsy gene"
    , "P2412": "FMD designer ID"
    , "P2413": "FMD magazine ID"
    , "P2414": "substrate of"
    , "P2415": "personal best"
    , "P2416": "sports discipline competed in"
    , "P2417": "stage classification"
    , "P2418": "Structurae person ID"
    , "P2421": "Prosopographia Attica"
    , "P2423": "International Fencing Federation fencer ID"
    , "P2424": "Berlin cultural heritage ID"
    , "P2425": "service ribbon image"
    , "P2426": "Xeno-canto species ID"
    , "P2427": "GRID ID"
    , "P2428": "RePEc Short-ID"
    , "P2429": "expected completeness"
    , "P2430": "takeoff roll"
    , "P2431": "Thyssen-Bornemisza artist ID"
    , "P2432": "J. Paul Getty Museum artist id"
    , "P2433": "gender of a scientific name of a genus"
    , "P2434": "Panarctic Flora ID"
    , "P2435": "PORT person ID"
    , "P2436": "voltage"
    , "P2437": "number of seasons"
    , "P2438": "narrator"
    , "P2440": "transliteration"
    , "P2441": "data_property translation"
    , "P2442": "conversion to standard unit"
    , "P2443": "stage reached"
    , "P2444": "homoglyph"
    , "P2445": "metasubclass of"
    , "P2446": "Transfermarkt player ID"
    , "P2447": "Transfermarkt manager ID"
    , "P2448": "Turkish Football Federation player ID"
    , "P2449": "Turkish Football Federation coach  ID"
    , "P2450": "Encyclop\u00e6dia Britannica contributor ID"
    , "P2451": "MAME ROM name"
    , "P2452": "GeoNames feature code"
    , "P2453": "nominee"
    , "P2454": "KNAW past member ID"
    , "P2455": "Species Profile and Threats Database ID"
    , "P2456": "DBLP ID"
    , "P2457": "Australian National Shipwreck ID"
    , "P2458": "Mackolik.com player ID"
    , "P2459": "IBU biathlete ID"
    , "P2460": "Persons of Ancient Athens"
    , "P2461": "ComLaw ID"
    , "P2462": "member of the deme"
    , "P2463": "elibrary.ru organisation ID"
    , "P2464": "BugGuide ID"
    , "P2465": "Allcinema film ID"
    , "P2467": "Global Geoparks Network ID"
    , "P2468": "Theatricalia theatre ID"
    , "P2469": "Theatricalia person ID"
    , "P2470": "Talousel\u00e4m\u00e4n vaikuttajat ID"
    , "P2471": "Models.com person ID"
    , "P2472": "ACMA Radiocommunications Client Number"
    , "P2473": "IGPCV ID"
    , "P2474": "CDLI ID"
    , "P2475": "NAVA ID"
    , "P2476": "HNI person/institution ID"
    , "P2477": "BDRC Resource ID"
    , "P2478": "Railways Archive event ID"
    , "P2479": "SPDX license ID"
    , "P2480": "IHO Hydrographic Dictionary (S-32) Number"
    , "P2481": "Elite Prospects player ID"
    , "P2482": "SABR person ID"
    , "P2483": "NCES District ID"
    , "P2484": "NCES School ID"
    , "P2485": "FMD photographer ID"
    , "P2486": "FMD brand ID"
    , "P2487": "page at website of Belarus Geocenter"
    , "P2488": "page at Belarus Globe website"
    , "P2489": "hram.by ID"
    , "P2490": "page at OSTIS Belarus Wiki"
    , "P2491": "Radzima.org ID"
    , "P2492": "MTMT author ID"
    , "P2493": "OM institution ID"
    , "P2494": "Latvian cultural heritage register ID"
    , "P2496": "Latvian toponymic names database ID"
    , "P2497": "Latvian National Address Register ID"
    , "P2498": "Catalan Biographical Dictionary of Women ID"
    , "P2499": "league level above"
    , "P2500": "league level below"
    , "P2501": "results"
    , "P2502": "classification of race"
    , "P2503": "Historical Gazetteer (GOV) ID"
    , "P2504": "Norwegian municipality number"
    , "P2505": "carries"
    , "P2506": "INSEE canton code"
    , "P2507": "corrigendum / erratum"
    , "P2508": "KINENOTE film ID"
    , "P2509": "Movie Walker film ID"
    , "P2510": "National Discography of Italian Song artist/group ID"
    , "P2511": "MSK Gent work PID"
    , "P2512": "series spin-off"
    , "P2513": "Jamendo album ID"
    , "P2514": "Jamendo artist ID"
    , "P2515": "costume designer"
    , "P2516": "Australian Ramsar site ID"
    , "P2517": "category for recipients of this award"
    , "P2518": "Scope.dk film ID"
    , "P2519": "Scope.dk person ID"
    , "P2520": "UNESCO Biosphere Reserve URL"
    , "P2521": "female form of label"
    , "P2522": "victory"
    , "P2524": "SEED number"
    , "P2525": "Ramsar Sites Information Service ID"
    , "P2526": "National Historic Sites of Canada ID"
    , "P2527": "earthquake magnitude on the moment magnitude scale"
    , "P2528": "earthquake magnitude on the Richter magnitude scale"
    , "P2529": "\u010cSFD film ID"
    , "P2530": "Box Office Mojo franchise ID"
    , "P2531": "Box Office Mojo studio ID"
    , "P2532": "lowest atmospheric pressure"
    , "P2533": "WomenWriters ID"
    , "P2534": "defining formula"
    , "P2535": "Sandbox-Mathematical expression"
    , "P2536": "Sandbox-External identifier"
    , "P2537": "Free Software Directory entry"
    , "P2538": "Nationalmuseum Sweden artist ID"
    , "P2539": "Nationalmuseum Sweden artwork ID"
    , "P2540": "Aarne\u2013Thompson\u2013Uther Tale Type Index"
    , "P2541": "operating area"
    , "P2542": "acceptable daily intake"
    , "P2545": "bowling style"
    , "P2546": "sidekick of"
    , "P2547": "perimeter"
    , "P2548": "strand orientation"
    , "P2549": "Italian Senate of the Republic ID"
    , "P2550": "recording or performance of"
    , "P2551": "used metre"
    , "P2552": "quantitative metrical pattern"
    , "P2553": "in work"
    , "P2554": "production designer"
    , "P2555": "fee"
    , "P2556": "bore"
    , "P2557": "stroke"
    , "P2558": "autores.uy ID"
    , "P2559": "Wikidata usage instructions"
    , "P2560": "GPU"
    , "P2561": "name"
    , "P2562": "married name"
    , "P2563": "superhuman feature or ability"
    , "P2564": "K\u00f6ppen climate classification"
    , "P2565": "global warming potential"
    , "P2566": "ECHA InfoCard ID"
    , "P2567": "amended by"
    , "P2568": "repealed by"
    , "P2571": "uncertainty corresponds to"
    , "P2572": "hashtag"
    , "P2573": "number of out-of-school children"
    , "P2574": "National-Football-Teams.com player ID"
    , "P2575": "measures"
    , "P2576": "UCSC Genome Browser assembly ID"
    , "P2577": "admissible rule in"
    , "P2578": "studies"
    , "P2579": "studied by"
    , "P2580": "Baltisches Biographisches Lexikon digital ID (former scheme)"
    , "P2581": "BabelNet ID"
    , "P2582": "J. Paul Getty Museum object ID"
    , "P2583": "distance from Earth"
    , "P2584": "Australian Wetlands Code"
    , "P2585": "INSEE region code"
    , "P2586": "INSEE department code"
    , "P2587": "has phoneme"
    , "P2588": "administrative code of Indonesia"
    , "P2589": "Statistics Indonesia ethnicity code"
    , "P2590": "BPS language_code code"
    , "P2591": "grammatical option indicates"
    , "P2592": "Qu\u00e9bec cultural heritage directory people identifier"
    , "P2593": "Latvian Olympic Committee athlete ID"
    , "P2595": "maximum gradient"
    , "P2596": "culture"
    , "P2597": "Gram staining"
    , "P2598": "serial number"
    , "P2599": "block size"
    , "P2600": "Geni.com profile ID"
    , "P2601": "Eurohockey.com player ID"
    , "P2602": "HockeyDB.com player ID"
    , "P2603": "Kinopoisk film ID"
    , "P2604": "Kinopoisk person ID"
    , "P2605": "\u010cSFD person ID"
    , "P2606": "PlayStation ID"
    , "P2607": "BookBrainz author ID"
    , "P2610": "thickness"
    , "P2611": "TED speaker ID"
    , "P2612": "TED topic ID"
    , "P2613": "TED talk ID"
    , "P2614": "World Heritage criteria"
    , "P2618": "inHerit Place Number"
    , "P2619": "Hungarian company ID"
    , "P2620": "ISO 15924 numeric code"
    , "P2621": "Site of Special Scientific Interest (England) ID"
    , "P2622": "Companies House ID"
    , "P2623": "MEK ID"
    , "P2624": "MetroLyrics ID"
    , "P2625": "PASE ID"
    , "P2626": "Danish National Filmography person ID"
    , "P2627": "ISO 9362 SWIFT/BIC code"
    , "P2628": "German tax authority ID"
    , "P2629": "BBFC rating"
    , "P2630": "cost of damage"
    , "P2631": "TCM Movie Database film ID"
    , "P2632": "place of detention"
    , "P2633": "geography of topic"
    , "P2634": "sitter"
    , "P2635": "number of parts of this work"
    , "P2636": "Minkultury film ID"
    , "P2637": "RARS rating"
    , "P2638": "TV.com ID"
    , "P2639": "Filmportal ID"
    , "P2640": "Swimrankings.net swimmer ID"
    , "P2641": "Davis Cup player ID"
    , "P2642": "Fed Cup player ID"
    , "P2643": "Carnegie Classification of Institutions of Higher Education"
    , "P2645": "mean lifetime"
    , "P2646": "mirTarBase ID"
    , "P2647": "source of material"
    , "P2648": "CQ Ranking men's race ID"
    , "P2649": "CQ Ranking men's team URL"
    , "P2650": "interested in"
    , "P2651": "CRICOS Provider Code"
    , "P2652": "partnership with"
    , "P2655": "Estyn ID"
    , "P2657": "EU Transparency Register ID"
    , "P2658": "Scoville grade"
    , "P2659": "topographic isolation"
    , "P2660": "topographic prominence"
    , "P2661": "target interest rate"
    , "P2662": "consumption rate per capita"
    , "P2663": "common equity tier 1 capital ratio (CETI)"
    , "P2664": "units sold"
    , "P2665": "alcohol by volume"
    , "P2666": "Datahub page"
    , "P2667": "corresponding template"
    , "P2668": "stability of property value"
    , "P2669": "discontinued date"
    , "P2670": "has parts of the class"
    , "P2671": "Google Knowledge Graph ID"
    , "P2672": "SOATO ID"
    , "P2673": "next crossing upstream"
    , "P2674": "next crossing downstream"
    , "P2675": "reply to"
    , "P2676": "rating certificate ID"
    , "P2677": "relative position within image"
    , "P2678": "Russiancinema.ru film ID"
    , "P2679": "author of foreword"
    , "P2680": "author of afterword"
    , "P2681": "is recto of"
    , "P2682": "is verso of"
    , "P2683": "Bekker Number"
    , "P2684": "Kijkwijzer rating"
    , "P2685": "Basketball-Reference.com NBA player ID"
    , "P2686": "OpenSecrets people ID"
    , "P2687": "NDL JPNO"
    , "P2688": "Box Office Mojo person ID"
    , "P2689": "BARTOC ID"
    , "P2694": "ISU figure skater ID"
    , "P2695": "type locality (geology)"
    , "P2696": "FIG gymnast licence number"
    , "P2697": "ESPNcricinfo.com player ID"
    , "P2698": "CricketArchive player ID"
    , "P2699": "URL"
    , "P2700": "protocol"
    , "P2701": "file format"
    , "P2702": "dataset distribution"
    , "P2703": "BFI National Archive work ID"
    , "P2704": "EIDR identifier"
    , "P2705": "Karate Records ID"
    , "P2708": "CQ Ranking women's race ID"
    , "P2709": "CQ Ranking female cyclist ID"
    , "P2710": "minimal lethal concentration"
    , "P2712": "median lethal concentration (LC50)"
    , "P2713": "sectional view"
    , "P2715": "elected in"
    , "P2716": "collage image"
    , "P2717": "no-observed-adverse-effect level"
    , "P2718": "lowest-observed-adverse-effect level"
    , "P2719": "Hungarian-style transcription"
    , "P2720": "embed URL template"
    , "P2721": "Encyclopaedia Metallum release ID"
    , "P2722": "Deezer artist ID"
    , "P2723": "Deezer album ID"
    , "P2724": "Deezer track ID"
    , "P2725": "GOG application ID"
    , "P2726": "UIPM athlete ID"
    , "P2727": "United World Wrestling ID"
    , "P2728": "CageMatch worker ID"
    , "P2729": "BWF.tournamentsoftware.com player ID"
    , "P2730": "ISSF athlete ID"
    , "P2732": "Pers\u00e9e author ID"
    , "P2733": "Pers\u00e9e journal ID"
    , "P2734": "Unz Review author ID"
    , "P2735": "Unz Review journal ID"
    , "P2736": "Biographical Directory of Federal Judges ID"
    , "P2737": "union of"
    , "P2738": "disjoint union of"
    , "P2739": "typeface/font used"
    , "P2740": "ResearchGate institute ID"
    , "P2741": "Tate artist ID"
    , "P2742": "Australian Geological Provinces ID"
    , "P2743": "this zoological name is coordinate with"
    , "P2744": "PASE name"
    , "P2745": "Dictionary of New Zealand Biography ID"
    , "P2746": "production statistics"
    , "P2747": "Filmiroda rating"
    , "P2748": "PRONOM file format identifier"
    , "P2749": "PRONOM software identifier"
    , "P2750": "Photographers' Identities Catalog ID"
    , "P2751": "Roller Coaster Database ID"
    , "P2752": "New Zealand Organisms Register ID"
    , "P2753": "Dictionary of Canadian Biography ID"
    , "P2754": "production date"
    , "P2755": "exploitation visa number"
    , "P2756": "EIRIN film rating"
    , "P2758": "CNC film rating (France)"
    , "P2759": "AUSNUT food ID"
    , "P2760": "NUTTAB food ID"
    , "P2761": "Research Papers in Economics Series handle"
    , "P2762": "CTBUH Skyscraper Center building complex ID"
    , "P2763": "Danish protected area ID"
    , "P2764": "Wrestlingdata person ID"
    , "P2765": "blue-style.com ID"
    , "P2766": "ISO 4063 process number"
    , "P2767": "JudoInside judoka ID"
    , "P2768": "BNE journal ID"
    , "P2769": "budget"
    , "P2770": "source of income"
    , "P2771": "D-U-N-S number"
    , "P2772": "FIS alpine skier ID"
    , "P2773": "FIS cross-country skier ID"
    , "P2774": "FIS freestyle skier ID"
    , "P2775": "FIS ski jumper ID"
    , "P2776": "FIS Nordic combined skier ID"
    , "P2777": "FIS snowboarder ID"
    , "P2778": "IAT triathlete ID"
    , "P2779": "IAT weightlifter ID"
    , "P2780": "IAT diver ID"
    , "P2781": "race time"
    , "P2782": "Models.com client ID"
    , "P2783": "Danish listed buildings case ID"
    , "P2784": "Mercalli intensity scale"
    , "P2786": "aerodrome reference point"
    , "P2787": "longest span"
    , "P2788": "Czech neighbourhood ID code"
    , "P2789": "connects with"
    , "P2790": "net tonnage"
    , "P2791": "power consumed"
    , "P2792": "ASF KID Cave Tag Number"
    , "P2793": "clearance"
    , "P2794": "Index Hepaticarum ID"
    , "P2795": "directions"
    , "P2796": "3DMet ID"
    , "P2797": "sound power level"
    , "P2798": "Loop ID"
    , "P2799": "BVMC person ID"
    , "P2800": "Beach Volleyball Database ID"
    , "P2801": "FIVB beach volleyball player ID"
    , "P2802": "fleet or registration number"
    , "P2803": "Wikidata time precision"
    , "P2804": "World Sailing member ID"
    , "P2805": "Goratings ID"
    , "P2806": "vibration"
    , "P2807": "molar volume"
    , "P2808": "wavelength"
    , "P2809": "Australasian Pollen and Spore Atlas Code"
    , "P2810": "LPGA Tour golf player ID"
    , "P2811": "PGA Tour golf player ID"
    , "P2812": "MathWorld identifier"
    , "P2813": "house publication"
    , "P2814": "P-number"
    , "P2815": "ESR station code"
    , "P2816": "HowLongToBeat ID"
    , "P2817": "appears in the heritage monument list"
    , "P2818": "Sherdog ID"
    , "P2819": "Yandex Music album ID"
    , "P2820": "cardinality of this set"
    , "P2821": "by-product"
    , "P2822": "by-product of"
    , "P2823": "Royal Belgian Football Association player ID"
    , "P2824": "Gazetteer of Planetary Nomenclature ID"
    , "P2825": "via"
    , "P2826": "Megogo ID"
    , "P2827": "flower color"
    , "P2828": "corporate officer"
    , "P2829": "Internet Wrestling Database ID"
    , "P2830": "Online World of Wrestling ID"
    , "P2831": "totem"
    , "P2832": "Joint Electronics Type Designation Automated System designation"
    , "P2833": "ARKive ID"
    , "P2834": "individual tax rate"
    , "P2835": "lowest income threshold"
    , "P2836": "highest income threshold"
    , "P2838": "professional name (Japan)"
    , "P2839": "gait"
    , "P2840": "NSC number"
    , "P2841": "age of onset"
    , "P2842": "place of marriage"
    , "P2843": "Benezit ID"
    , "P2844": "incidence"
    , "P2845": "RAN ID"
    , "P2846": "wheelchair accessibility"
    , "P2847": "Google+ ID"
    , "P2848": "Wi-Fi access"
    , "P2849": "produced by"
    , "P2850": "iTunes artist ID (American version)"
    , "P2851": "payment types accepted"
    , "P2852": "emergency phone number"
    , "P2853": "electrical plug type"
    , "P2854": "disease burden"
    , "P2855": "VAT-rate"
    , "P2856": "EU Surface Water Body Code"
    , "P2857": "WWE.com superstar ID"
    , "P2858": "Killer List of Videogames ID"
    , "P2859": "X-SAMPA Code"
    , "P2860": "cites work"
    , "P2861": "Leidse Hoogleraren ID"
    , "P2862": "Catalogus Professorum Academiae Rheno-Traiectinae ID"
    , "P2863": "Nederlandse Molendatabase ID"
    , "P2864": "OpenCritic ID"
    , "P2865": "band number"
    , "P2866": "Hollandsche Molen ID"
    , "P2867": "Molenecho's ID"
    , "P2868": "subject has role"
    , "P2869": "record or record progression"
    , "P2870": "miRBase pre-miRNA ID"
    , "P2871": "miRBase mature miRNA ID"
    , "P2872": "visitor centre"
    , "P2873": "time in space"
    , "P2874": "PubChem BioAssay ID (AID)"
    , "P2875": "property usage tracking category"
    , "P2876": "type of unit for this property"
    , "P2877": "SureChEMBL ID"
    , "P2878": "Minitel code"
    , "P2879": "Library of the National Congress of Argentina ID"
    , "P2880": "NIOSHTIC-2 ID"
    , "P2881": "promoted"
    , "P2882": "relegated"
    , "P2883": "HKMDB film ID"
    , "P2884": "mains voltage"
    , "P2886": "Shakeosphere person ID"
    , "P2887": "reserve number (Canada)"
    , "P2888": "exact match"
    , "P2889": "FamilySearch person ID"
    , "P2892": "UMLS CUI"
    , "P2893": "Skype username"
    , "P2894": "day of week"
    , "P2895": "maximum sustained winds"
    , "P2896": "publication interval"
    , "P2897": "Eldoblaje Movie ID"
    , "P2898": "Swedish county letter"
    , "P2899": "minimum age"
    , "P2900": "fax number"
    , "P2903": "Molendatabase verdwenen molens ID"
    , "P2904": "Beer Advocate brewery ID"
    , "P2905": "RateBeer brewery ID"
    , "P2907": "UTC timezone offset"
    , "P2908": "SecondHandSongs song ID"
    , "P2909": "SecondHandSongs artist ID"
    , "P2910": "icon"
    , "P2911": "time gap"
    , "P2912": "distinctive jersey"
    , "P2913": "date depicted"
    , "P2914": "MSBI person ID"
    , "P2915": "ECARTICO person ID"
    , "P2916": "syntax clarification"
    , "P2917": "COAM structure ID"
    , "P2918": "PO Box"
    , "P2919": "label in sign language_code"
    , "P2922": "month of the year"
    , "P2923": "focal height"
    , "P2924": "Great Russian Encyclopedia Online ID"
    , "P2925": "domain of saint or deity"
    , "P2926": "InterPro ID"
    , "P2927": "water as percent of area"
    , "P2928": "memory capacity"
    , "P2929": "lighthouse range"
    , "P2930": "INSPIRE-HEP author ID"
    , "P2931": "Encyclopedia of Triangle Centers identifier"
    , "P2935": "connector"
    , "P2936": "language_code used"
    , "P2937": "parliamentary term"
    , "P2938": "Pleiades category identifier"
    , "P2939": "CageMatch tag team ID"
    , "P2940": "Catalogus Professorum Rostochiensium ID"
    , "P2941": "Munk's Roll ID"
    , "P2942": "Dailymotion channel ID"
    , "P2943": "warheroes.ru ID"
    , "P2944": "Plarr ID"
    , "P2945": "British Book Trade Index ID"
    , "P2946": "BacDive ID"
    , "P2948": "Estonian cultural monument ID"
    , "P2949": "WikiTree person ID"
    , "P2950": "Nomisma ID"
    , "P2951": "Cultural heritage database in Austria ObjektID"
    , "P2952": "boat of heritage interest ID"
    , "P2953": "Estonian Research Portal person ID"
    , "P2954": "Transferred Account Data Interchange Group Code"
    , "P2955": "point of penalty"
    , "P2956": "NAIF ID"
    , "P2957": "throughput"
    , "P2959": "permanent duplicated item"
    , "P2960": "archive date"
    , "P2961": "BVPH publication ID"
    , "P2962": "title of chess person"
    , "P2963": "Goodreads author ID"
    , "P2964": "right to vote"
    , "P2965": "EU River Basin District code"
    , "P2966": "National Library of Wales Authority ID"
    , "P2967": "Queensland Heritage Register ID"
    , "P2968": "QUDT unit ID"
    , "P2969": "Goodreads book ID"
    , "P2970": "Kinopolis film ID"
    , "P2971": "GCatholic church ID"
    , "P2972": "SNAP ID"
    , "P2973": "Spenserians person ID"
    , "P2974": "habitat"
    , "P2975": "host"
    , "P2976": "patronym or matronym for this name"
    , "P2977": "LBT person ID"
    , "P2978": "wheel arrangement"
    , "P2979": "maritime identification digits"
    , "P2980": "ARLHS lighthouse ID"
    , "P2981": "UIC alphabetical country code"
    , "P2982": "UIC numerical country code"
    , "P2983": "UNDP country code"
    , "P2984": "Snapchat username"
    , "P2985": "DSBE ID"
    , "P2986": "aircraft registration prefix"
    , "P2987": "Taekwondo Data ID"
    , "P2988": "GOST 7.67 cyrillic"
    , "P2989": "has grammatical case"
    , "P2990": "FIL athlete ID"
    , "P2991": "IBSF athlete ID"
    , "P2992": "software quality assurance"
    , "P2993": "partition coefficient water/octanol"
    , "P2997": "age of majority"
    , "P2998": "age of candidacy"
    , "P2999": "age of consent"
    , "P3000": "marriageable age"
    , "P3001": "retirement age"
    , "P3002": "Untappd brewery ID"
    , "P3003": "zanikleobce.cz abandoned objects ID"
    , "P3004": "Galiciana work ID"
    , "P3005": "valid in place"
    , "P3006": "Marine Regions Geographic ID"
    , "P3007": "Cadw Monument ID"
    , "P3008": "Australian Heritage Database Place ID"
    , "P3009": "Conservatoire du littoral ID"
    , "P3010": "World Archery Federation ID"
    , "P3012": "Statistics Canada Geographic code"
    , "P3013": "surface tension"
    , "P3014": "laws applied"
    , "P3015": "backup or reserve team or crew"
    , "P3016": "French national research structure identifier"
    , "P3017": "Rolling Stone artist ID"
    , "P3018": "located in protected area"
    , "P3019": "railway signalling system"
    , "P3020": "residence time of water"
    , "P3021": "Iranica ID"
    , "P3022": "flag bearer"
    , "P3023": "Legacies of British Slave-ownership person ID"
    , "P3024": "ITU letter code"
    , "P3025": "open days"
    , "P3026": "closed on"
    , "P3027": "open period from"
    , "P3028": "open period to"
    , "P3029": "UK National Archives ID"
    , "P3030": "sheet music"
    , "P3031": "EPPO Code"
    , "P3032": "adjacent building"
    , "P3033": "package management system"
    , "P3034": "Indonesian ethnicity code"
    , "P3035": "ISBN publisher prefix"
    , "P3036": "precipitation height"
    , "P3037": "spatial reference system"
    , "P3038": "IWM memorial ID"
    , "P3039": "wheelbase"
    , "P3040": "SoundCloud ID"
    , "P3041": "luminous intensity"
    , "P3042": "CageMatch wrestling stable ID"
    , "P3043": "Scoresway soccer person ID"
    , "P3044": "College Football HoF ID"
    , "P3045": "HanCinema person ID"
    , "P3046": "ForaDeJogo player ID"
    , "P3047": "PlaymakerStats.com player ID"
    , "P3048": "racing-reference.info driver ID"
    , "P3049": "Scottish Football Association player ID"
    , "P3050": "FACR player ID"
    , "P3051": "Kindred Britain ID"
    , "P3052": "Bloomberg person ID"
    , "P3053": "K League player ID"
    , "P3054": "Ontario MPP ID"
    , "P3055": "NAQ elected person ID"
    , "P3056": "TCM Movie Database person ID"
    , "P3057": "Charity Commission no."
    , "P3058": "Architectuurgids architect ID"
    , "P3059": "Architectuurgids building ID"
    , "P3060": "ButMoth ID"
    , "P3061": "Basisregistratie Instellingen number"
    , "P3063": "gestation period"
    , "P3064": "LepIndex ID"
    , "P3065": "RERO ID"
    , "P3066": "GLAM Identifier"
    , "P3067": "GS1 country code"
    , "P3068": "WIPO ST.3"
    , "P3069": "UN document symbol"
    , "P3070": "dynamic viscosity"
    , "P3071": "standard molar entropy"
    , "P3072": "Storting person ID"
    , "P3073": "CosIng number"
    , "P3074": "Grace's Guide ID"
    , "P3075": "official religion"
    , "P3076": "Open Beauty Facts category ID"
    , "P3077": "Cineplex film ID"
    , "P3078": "standard enthalpy of formation"
    , "P3080": "game artist"
    , "P3081": "damaged"
    , "P3082": "destroyed"
    , "P3083": "SIMBAD ID"
    , "P3085": "qualifies for event"
    , "P3086": "speed limit"
    , "P3087": "fiscal/tax revenue"
    , "P3088": "Catalogue of Life in Taiwan ID"
    , "P3089": "Flags of the World ID"
    , "P3090": "flight number"
    , "P3091": "mount"
    , "P3092": "film crew member"
    , "P3093": "recovered by"
    , "P3094": "develops from"
    , "P3095": "practiced by"
    , "P3096": "KML file"
    , "P3097": "ISBN identifier group"
    , "P3098": "ClinicalTrials.gov Identifier"
    , "P3099": "Internet Bird Collection species ID"
    , "P3100": "Flora of Australia ID (old)"
    , "P3101": "FloraBase ID"
    , "P3102": "Plantarium ID"
    , "P3103": "has tense"
    , "P3104": "Gares & Connexions ID"
    , "P3105": "Tela Botanica ID"
    , "P3106": "Guardian topic ID"
    , "P3107": "LdiF ID"
    , "P3108": "Yelp ID"
    , "P3109": "Peakbagger mountain ID"
    , "P3110": "ISzDb film ID"
    , "P3111": "FEI person ID"
    , "P3112": "DistroWatch ID"
    , "P3113": "does not have part"
    , "P3114": "ISzDb person ID"
    , "P3115": "ISzDb company ID"
    , "P3116": "ISzDb dub ID"
    , "P3117": "DSSTox substance ID"
    , "P3118": "OpenDomesday settlement ID"
    , "P3119": "Code for China Reservoir Name"
    , "P3120": "TOID"
    , "P3121": "Epguides ID"
    , "P3122": "OpenDomesday person ID"
    , "P3123": "Stanford Encyclopedia of Philosophy ID"
    , "P3124": "Polish scientist ID"
    , "P3125": "EDRPOU code"
    , "P3126": "ALCUIN ID"
    , "P3127": "Latindex ID"
    , "P3128": "CiNetMag film ID"
    , "P3129": "cine.gr film ID"
    , "P3130": "NSW Flora ID"
    , "P3131": "Redalyc journal ID"
    , "P3132": "last line"
    , "P3133": "NSZL name authority ID"
    , "P3134": "TripAdvisor ID"
    , "P3135": "elCinema film ID"
    , "P3136": "elCinema person ID"
    , "P3137": "parent peak"
    , "P3138": "OFDb ID"
    , "P3139": "SourehCinema film ID"
    , "P3140": "SourehCinema person ID"
    , "P3141": "EDb film ID"
    , "P3142": "EDb person ID"
    , "P3143": "elFilm film ID"
    , "P3144": "elFilm person ID"
    , "P3145": "Sratim ID"
    , "P3146": "CiNetMag person ID"
    , "P3147": "United States Reports ID"
    , "P3148": "repeals"
    , "P3149": "molecule conformation"
    , "P3150": "birthday"
    , "P3151": "iNaturalist taxon ID"
    , "P3152": "Findsmiley ID"
    , "P3153": "Crossref funder ID"
    , "P3154": "Runeberg author ID"
    , "P3155": "Runeberg book ID"
    , "P3156": "Australian Classification"
    , "P3157": "event distance"
    , "P3158": "enclosure"
    , "P3159": "UGentMemorialis ID"
    , "P3160": "Minnesota legislator ID"
    , "P3161": "has grammatical mood"
    , "P3162": "Rock and Roll Hall of Fame ID"
    , "P3163": "Scottish Charity number"
    , "P3165": "Horsetelex ID"
    , "P3166": "Webpedigrees ID"
    , "P3167": "Allbreedpedigree ID"
    , "P3168": "Sporthorse data ID"
    , "P3169": "Infochevaux ID"
    , "P3170": "Cultural Heritage Armenia ID"
    , "P3171": "International Olympic Committee athlete ID"
    , "P3172": "World Bridge Federation ID"
    , "P3173": "offers view on"
    , "P3174": "art director"
    , "P3175": "Statoids ID"
    , "P3176": "uses property"
    , "P3177": "Patrimonio Web JCyL ID"
    , "P3178": "Zaragoza monument ID"
    , "P3179": "territory overlaps"
    , "P3180": "Visual Novel Database ID"
    , "P3181": "OpenCitations bibliographic resource ID"
    , "P3182": "FANTOIR code"
    , "P3183": "Wall Street Journal topic ID"
    , "P3184": "Czech National Bibliography book ID"
    , "P3185": "VK username"
    , "P3186": "TAXREF ID"
    , "P3187": "Marburger Professorenkatalog ID"
    , "P3188": "Nobel prize ID"
    , "P3189": "innervated by"
    , "P3190": "innervates"
    , "P3191": "IMIS person ID"
    , "P3192": "Last.fm ID"
    , "P3193": "GS1 Manufacturer code"
    , "P3194": "INA video ID"
    , "P3195": "league points system"
    , "P3196": "USGS earthquake ID"
    , "P3197": "Federal Heritage Buildings ID (Canada)"
    , "P3198": "JewishGen Locality ID"
    , "P3199": "charity number (Isle of Man)"
    , "P3200": "Northern Ireland charity number"
    , "P3201": "Medical Dictionary for Regulatory Activities ID"
    , "P3202": "UAI code"
    , "P3203": "Cin\u00e9-Ressources film ID"
    , "P3204": "Cin\u00e9-Ressources person ID"
    , "P3205": "patient of"
    , "P3206": "data.gouv.fr organisation ID"
    , "P3207": "Vine user ID"
    , "P3208": "New General Catalogue ID"
    , "P3209": "Heritage Railway Station of Canada ID"
    , "P3211": "Heritage Lighthouse of Canada ID"
    , "P3212": "ISAN"
    , "P3213": "Indian census area code (2001)"
    , "P3215": "SIRET number"
    , "P3216": "ClassInd rating"
    , "P3217": "Dictionary of Swedish National Biography ID"
    , "P3218": "Au\u00f1amendi ID"
    , "P3219": "Encyclop\u00e6dia Universalis ID"
    , "P3220": "KvK company ID"
    , "P3221": "New York Times topic ID"
    , "P3222": "NE.se ID"
    , "P3223": "Online List of Lights ID"
    , "P3224": "NAICS code"
    , "P3225": "Corporate Number (Japan)"
    , "P3226": "HAS member ID"
    , "P3227": "Cultural Heritage Kosovo ID"
    , "P3228": "Schl\u00e4fli symbol"
    , "P3229": "South Dakota legislator ID"
    , "P3230": "SCAR Composite Gazetteer place ID"
    , "P3231": "Media Arts Database author ID (obsolete)"
    , "P3232": "PhilPapers author ID"
    , "P3233": "PhilPeople profile"
    , "P3234": "Library of Congress Cultural Heritage Organizations"
    , "P3235": "PhilPapers topic"
    , "P3236": "PhilPapers publication ID"
    , "P3237": "KU Leuven person ID"
    , "P3238": "trunk prefix"
    , "P3240": "NBN System Key"
    , "P3241": "Catholic Encyclopedia ID"
    , "P3242": "SIC code"
    , "P3243": "OKVED 1.1 code of the economic activity"
    , "P3245": "OKPD code of the good or service"
    , "P3246": "OKVED 2 code of the economic activity"
    , "P3248": "OKP ID of the good or service"
    , "P3250": "OKPD2 code of the good or service"
    , "P3251": "minimum viable temperature"
    , "P3252": "maximum viable temperature"
    , "P3253": "optimum viable temperature"
    , "P3254": "property proposal discussion"
    , "P3256": "Cave E-Cadastre ID"
    , "P3257": "Queensland place ID"
    , "P3258": "LiveJournal ID"
    , "P3259": "intangible cultural heritage status"
    , "P3260": "points awarded"
    , "P3261": "anatomical branch of"
    , "P3262": "has anatomical branch"
    , "P3263": "base"
    , "P3264": "radix"
    , "P3265": "Myspace ID"
    , "P3266": "Library of Congress Format Description Document ID"
    , "P3267": "Flickr user ID"
    , "P3268": "PORT organization URL"
    , "P3269": "Fotografen.nl ID"
    , "P3270": "compulsory education (minimum age)"
    , "P3271": "compulsory education (maximum age)"
    , "P3272": "Zeri image ID"
    , "P3273": "Actorenregister ID"
    , "P3274": "content deliverer"
    , "P3275": "storyboard artist"
    , "P3276": "Angel List ID"
    , "P3277": "KANTL member ID"
    , "P3279": "statistical leader"
    , "P3280": "BAnQ author ID"
    , "P3281": "French National Assembly Lobbyist ID"
    , "P3283": "Bandcamp ID"
    , "P3284": "Yahoo! Japan Talent Database ID"
    , "P3285": "Mathematics Subject Classification ID"
    , "P3286": "Squash Info player ID"
    , "P3288": "World Spider Catalog ID"
    , "P3289": "Cellosaurus ID"
    , "P3290": "biography at the Landtag of Mecklenburg-Vorpommern"
    , "P3291": "DocCheck Flexikon En ID"
    , "P3292": "DocCheck Flexikon De ID"
    , "P3293": "BALaT object ID"
    , "P3294": "encoding"
    , "P3295": "code"
    , "P3296": "DR\u00daSOP ID"
    , "P3297": "Flemish Parliament person ID"
    , "P3298": "Belgian Senate person ID"
    , "P3299": "student register of the University of Helsinki ID (1640\u20131852)"
    , "P3300": "musical conductor"
    , "P3301": "broadcast by"
    , "P3302": "Open Media Database film ID"
    , "P3303": "third-party formatter URL"
    , "P3304": "NGS pumping station ID"
    , "P3305": "KINENOTE person ID"
    , "P3306": "ICAA rating"
    , "P3307": "Galiciana author ID"
    , "P3308": "lib.reviews ID"
    , "P3309": "SummitPost mountain ID"
    , "P3310": "muscle action"
    , "P3311": "plan view image"
    , "P3314": "365chess player ID"
    , "P3315": "chesstempo ID"
    , "P3316": "ICCF player ID"
    , "P3318": "Patrimonio Inmueble de Andaluc\u00eda ID"
    , "P3320": "board member"
    , "P3321": "male form of label"
    , "P3322": "Vlinderstichting-ID"
    , "P3323": "opponent during disputation"
    , "P3324": "petit-patrimoine.com ID"
    , "P3325": "student register of the University of Helsinki ID (1853\u20131899)"
    , "P3326": "World Waterfall Database ID"
    , "P3327": "R\u00e9serves naturelles de France ID"
    , "P3328": "wurvoc.org measure ID"
    , "P3329": "CIViC variant ID"
    , "P3330": "Supermodels.nl ID"
    , "P3331": "HGVS nomenclature"
    , "P3332": "ACM Digital Library citation ID"
    , "P3333": "ACM Digital Library event ID"
    , "P3335": "hazard on site"
    , "P3337": "generation time"
    , "P3338": "Encyclopedia of Surfing ID"
    , "P3339": "World Surf League ID"
    , "P3340": "Kvikmyndir film ID"
    , "P3341": "Kvikmyndir person ID"
    , "P3342": "significant person"
    , "P3343": "legislation.gov.uk ID"
    , "P3344": "Vote Smart ID"
    , "P3345": "RxNorm ID"
    , "P3346": "HKMDB person ID"
    , "P3347": "PermID"
    , "P3348": "National Library of Greece ID"
    , "P3349": "designed to carry"
    , "P3350": "WHO international non-proprietary names ID"
    , "P3351": "Adult Film Database actor ID"
    , "P3352": "musipedia tune ID"
    , "P3353": "National Recreation Trails Database ID"
    , "P3354": "positive therapeutic predictor"
    , "P3355": "negative therapeutic predictor"
    , "P3356": "positive diagnostic predictor"
    , "P3357": "negative diagnostic predictor"
    , "P3358": "positive prognostic predictor"
    , "P3359": "negative prognostic predictor"
    , "P3360": "Nobel Prize People Nomination ID"
    , "P3361": "PictoRight ID code"
    , "P3362": "operating income"
    , "P3363": "Tennis Hall of Fame player ID"
    , "P3364": "stereoisomer of"
    , "P3365": "Treccani ID"
    , "P3366": "GECD person ID"
    , "P3367": "GECD film ID"
    , "P3368": "Prabook ID"
    , "P3370": "G\u00e9opatronyme ID"
    , "P3371": "Observatoire du Patrimoine Religieux ID"
    , "P3372": "Auckland Art Gallery artist ID"
    , "P3373": "sibling"
    , "P3374": "endianness"
    , "P3375": "GECD Firmen-ID"
    , "P3376": "Enterprise number (Belgium)"
    , "P3377": "Bloomberg company ID"
    , "P3378": "Merck Index reaction ID"
    , "P3379": "Model Manual ID"
    , "P3380": "FAO 2007 genetic resource ID"
    , "P3381": "File Format Wiki page ID"
    , "P3382": "GeneDB ID"
    , "P3383": "film poster"
    , "P3385": "Japan Sumo Association ID"
    , "P3386": "French Sculpture Census work ID"
    , "P3387": "minimum frequency of audible sound"
    , "P3388": "LittleSis people ID"
    , "P3389": "Royal Swedish Academy of Letters member ID"
    , "P3390": "Consolidated code of the electronic catalog of libraries of Belarus"
    , "P3391": "Verkhovna Rada MP ID"
    , "P3392": "Surman ID"
    , "P3393": "LittleSis organization ID"
    , "P3394": "Finnish Lake ID"
    , "P3395": "heart rate"
    , "P3396": "French Catholic Church structure ID"
    , "P3397": "Guide of the French Church person ID"
    , "P3398": "Butterflies and Moths of North America ID"
    , "P3399": "JTWC tropical cyclone ID"
    , "P3400": "CORDIS Project ID"
    , "P3401": "Wilderness Connect ID"
    , "P3402": "CNC film rating (Romania)"
    , "P3403": "coextensive with"
    , "P3404": "The Vogue List ID"
    , "P3405": "Nederlands Soortenregister ID"
    , "P3406": "Saccharomyces Genome Database ID"
    , "P3407": "Klosterdatenbank ID"
    , "P3408": "FINA athlete ID"
    , "P3409": "Catalogus Professorum Lipsiensis ID"
    , "P3410": "Clergy of the Church of England database ID"
    , "P3411": "Saxon Academy of Sciences member ID"
    , "P3412": "Canadian Environmental Sustainability Indicators ID (Protected areas)"
    , "P3413": "Leopoldina member ID"
    , "P3414": "Yle Areena ID"
    , "P3415": "start period"
    , "P3416": "end period"
    , "P3417": "Quora topic ID"
    , "P3418": "Google Play Store app ID"
    , "P3419": "Basic Unit of Settlement code (Czech)"
    , "P3420": "Calflora ID"
    , "P3421": "Belvedere artist ID"
    , "P3422": "INSEE countries and foreign territories code"
    , "P3423": "INSEE arrondissement code"
    , "P3424": "Polish cultural heritage register number"
    , "P3425": "Natura 2000 site ID"
    , "P3426": "ArbetSam ID"
    , "P3427": "AS.com athlete ID"
    , "P3428": "INCAA film rating"
    , "P3429": "Electronic Enlightenment ID"
    , "P3430": "SNAC Ark ID"
    , "P3431": "Publons Publication ID"
    , "P3432": "parent cell line"
    , "P3433": "biological variant of"
    , "P3434": "ERIH PLUS ID"
    , "P3435": "VGMdb artist ID"
    , "P3436": "AELG ID"
    , "P3437": "people or cargo transported"
    , "P3438": "vehicle normally used"
    , "P3439": "angular resolution"
    , "P3440": "time signature"
    , "P3441": "FIFA country code"
    , "P3442": "Debian stable package"
    , "P3443": "Victorian Heritage Database ID"
    , "P3444": "eBird taxon ID"
    , "P3445": "Cinema of Israel ID"
    , "P3446": "FIDAL athlete ID"
    , "P3447": "mirrors data from"
    , "P3448": "stepparent"
    , "P3449": "NSW Heritage database ID"
    , "P3450": "sports season of league or competition"
    , "P3451": "nighttime view"
    , "P3452": "inferred from"
    , "P3453": "IPI base code"
    , "P3454": "Arch Linux package"
    , "P3455": "CircleID writer ID"
    , "P3456": "ATP tennis tournament ID"
    , "P3457": "case fatality rate"
    , "P3458": "CNC authorization number"
    , "P3459": "Euring number"
    , "P3460": "colonel-in-chief"
    , "P3461": "designated as terrorist by"
    , "P3462": "FAMA work ID"
    , "P3463": "Fedora package"
    , "P3464": "medicine marketing authorization"
    , "P3465": "maximum frequency of audible sound"
    , "P3466": "Israeli CBS municipal ID"
    , "P3467": "Inventario Sculture - Polo Museale Fiorentino"
    , "P3468": "National Inventors Hall of Fame ID"
    , "P3469": "WTA tennis tournament ID"
    , "P3470": "Woodland Trust wood ID"
    , "P3471": "WikiSkripta ID"
    , "P3472": "VICNAMES Place ID"
    , "P3473": "Ubuntu package"
    , "P3475": "SANU member ID"
    , "P3476": "PSA World Tour player ID"
    , "P3477": "Nihon Tarento Meikan ID"
    , "P3478": "Songkick artist ID"
    , "P3479": "Omni topic ID"
    , "P3480": "base M\u00e9moire reference"
    , "P3481": "Parks & Gardens UK Record ID"
    , "P3482": "Europeana Fashion creator ID"
    , "P3483": "VGMdb album ID"
    , "P3485": "bite force quotient"
    , "P3486": "normal respiratory rate"
    , "P3487": "maximal incubation period in humans"
    , "P3488": "minimal incubation period in humans"
    , "P3489": "pregnancy category"
    , "P3490": "muscle origin"
    , "P3491": "muscle insertion"
    , "P3492": "basic reproduction number"
    , "P3493": "legal status (medicine)"
    , "P3494": "points classification"
    , "P3495": "FilmPolski.pl ID"
    , "P3496": "teams classification by points"
    , "P3497": "teams classification by time"
    , "P3498": "ZNIEFF ID"
    , "P3499": "Gentoo package"
    , "P3500": "Ringgold ID"
    , "P3501": "Catholic rite"
    , "P3502": "Ameblo username"
    , "P3503": "LombardiaBeniCulturali building ID"
    , "P3504": "Florentine Inventario Palatina art ID"
    , "P3505": "BoardGameGeek designer ID"
    , "P3506": "Luding designer ID"
    , "P3507": "Bivouac.com mountain ID"
    , "P3509": "Dagens Nyheter topic ID"
    , "P3511": "VGMDb organization ID"
    , "P3512": "means of locomotion"
    , "P3513": "peakware mountain ID"
    , "P3514": "U.S. National Geodetic Survey ID"
    , "P3515": "NPCA ID"
    , "P3516": "National Park Foundation ID"
    , "P3517": "Geographical Names Board of NSW ID"
    , "P3518": "Smithsonian trinomial"
    , "P3519": "Pfam ID"
    , "P3520": "databaseOlympics.com athlete ID"
    , "P3521": "European Tour golf player ID"
    , "P3522": "NHL.com player ID"
    , "P3523": "Rfam ID"
    , "P3524": "Simple Modular Architecture Research Tool ID"
    , "P3525": "ACB.com player ID"
    , "P3526": "wisdenindia.com ID"
    , "P3527": "Eurobasket.com player ID"
    , "P3528": "Luding game ID"
    , "P3529": "median income"
    , "P3530": "par"
    , "P3531": "AZBilliards ID"
    , "P3532": "databaseFootball.com ID"
    , "P3533": "DraftExpress ID"
    , "P3534": "Australian Government Organisations Register ID"
    , "P3535": "Japan Golf Tour player ID"
    , "P3536": "euroleague.net ID"
    , "P3537": "FootballDatabase.eu player ID"
    , "P3538": "Fussballdaten.de player ID"
    , "P3539": "NFL.com ID"
    , "P3541": "MLB.com player ID"
    , "P3542": "FIBA player ID"
    , "P3544": "Te Papa agent ID"
    , "P3545": "Theoi Project ID"
    , "P3546": "AustralianFootball.com ID"
    , "P3547": "AFL Tables player ID"
    , "P3548": "Australian Business Number"
    , "P3549": "Australian Company Number"
    , "P3550": "Australian Register of Therapeutic Goods ID"
    , "P3551": "Australian Registered Body Number"
    , "P3552": "Australian Registered Scheme Number"
    , "P3553": "Zhihu topic ID"
    , "P3554": "World Series of Poker ID"
    , "P3555": "World Guide to Covered Bridges ID"
    , "P3556": "CurlingZone ID"
    , "P3557": "World Curling Federation ID"
    , "P3558": "USCF ID"
    , "P3559": "maximum size or capacity"
    , "P3560": "College Football Data Warehouse ID"
    , "P3561": "Pro-Football-Reference.com player ID"
    , "P3562": "Admiralty number"
    , "P3563": "NGA Lighthouse ID"
    , "P3564": "Global Poker Index ID"
    , "P3565": "J.League player ID"
    , "P3566": "Just Sports Stats ID"
    , "P3567": "HHOF.com NHL player ID"
    , "P3568": "Official World Golf Ranking player ID"
    , "P3569": "Cultureel Woordenboek ID"
    , "P3570": "European Case Law ID"
    , "P3571": "ESPN.com MLB player ID"
    , "P3572": "ESPNcricinfo playing ground ID"
    , "P3573": "European Handball Federation player ID"
    , "P3574": "FanGraphs player ID"
    , "P3575": "data size"
    , "P3576": "TLG author ID"
    , "P3577": "Croatian Football Federation player ID"
    , "P3578": "autologous cell line"
    , "P3579": "Sina Weibo user ID"
    , "P3580": "SIPCA code"
    , "P3581": "Pro Football Hall of Fame ID (old)"
    , "P3582": "Sunshine Tour golf player ID"
    , "P3583": "Surfline ID"
    , "P3584": "ITRA runner ID"
    , "P3585": "UltraSignup runner ID"
    , "P3586": "CricketArchive playing ground ID"
    , "P3587": "Common Vulnerabilities and Exposures ID"
    , "P3588": "WNBA player ID"
    , "P3589": "GCD series ID"
    , "P3590": "Relations Ontology ID"
    , "P3591": "WCSPF ID"
    , "P3592": "Saros cycle of eclipse"
    , "P3593": "AFI Catalog of Feature Films ID"
    , "P3594": "Araneae Spider ID"
    , "P3595": "Biografiskt Lexikon f\u00f6r Finland ID"
    , "P3596": "Danish ancient monument ID"
    , "P3597": "F-Droid package"
    , "P3598": "Hockey-Reference.com player ID"
    , "P3599": "archival creator authority record at the Archives nationales"
    , "P3600": "protected heritage site in Brussels ID"
    , "P3601": "MarineTraffic Lighthouse ID"
    , "P3602": "candidacy in election"
    , "P3603": "Minneapolis Institute of Art constituent ID"
    , "P3604": "ITU triathlete ID"
    , "P3605": "90minut player ID"
    , "P3606": "BOLD Systems taxon ID"
    , "P3607": "Booking.com hotel ID"
    , "P3608": "EU VAT number"
    , "P3609": "Recreation.gov gateway ID"
    , "P3610": "fare zone"
    , "P3611": "Borden Code"
    , "P3612": "Le Monde diplomatique subject ID"
    , "P3613": "Naturv\u00e5rdsregistret ID"
    , "P3614": "DigDag ID"
    , "P3615": "Vision of Britain unit ID"
    , "P3616": "Vision of Britain place ID"
    , "P3618": "base salary"
    , "P3619": "Ski-DB skier ID"
    , "P3620": "BWFbadminton.com player ID"
    , "P3621": "Darts Database player ID"
    , "P3622": "Russian Bandy Federation player ID"
    , "P3623": "BadmintonLink player ID"
    , "P3624": "CWE ID"
    , "P3625": "Kirshenbaum code"
    , "P3626": "Australian Antarctic Gazetteer ID"
    , "P3627": "Historical Gazetteer of England's Place Names ID"
    , "P3628": "British History Online VCH ID"
    , "P3629": "age at event"
    , "P3630": "Babelio author ID"
    , "P3631": "Babelio work ID"
    , "P3632": "British Museum thesaurus ID"
    , "P3633": "British Museum place ID"
    , "P3634": "The Met object ID"
    , "P3635": "Peakbagger area ID"
    , "P3636": "PDB ligand ID"
    , "P3637": "European Medicines Agency product number"
    , "P3638": "Oorlogsmonument ID"
    , "P3639": "KEPN ID"
    , "P3640": "National Drug Code"
    , "P3641": "Uniform Type Identifier"
    , "P3642": "ARCHON code"
    , "P3643": "significant environmental impact"
    , "P3644": "FFR player ID"
    , "P3645": "All Blacks player ID"
    , "P3646": "Naismith Memorial Basketball Hall of Fame ID"
    , "P3647": "NBA.com player ID"
    , "P3648": "NatureServe conservation status"
    , "P3650": "JMK film rating"
    , "P3651": "American Hockey League player ID"
    , "P3652": "Kontinental Hockey League player ID"
    , "P3653": "ARRS runner ID"
    , "P3654": "Chess.com player ID"
    , "P3655": "BDFutbol player ID"
    , "P3656": "Cross-tables.com Scrabble player ID"
    , "P3657": "Croatian Football Statistics player ID"
    , "P3658": "DZFoot.com player ID"
    , "P3659": "Estonian Football Association player ID"
    , "P3660": "FootballFacts.ru player ID"
    , "P3661": "ForaDeJogo manager ID"
    , "P3662": "Football Federation of Ukraine player ID"
    , "P3663": "Fotbal DNES player ID"
    , "P3664": "Futsal Planet player ID"
    , "P3665": "L'\u00c9quipe football player ID"
    , "P3666": "EPCR player ID"
    , "P3667": "IWF athlete ID"
    , "P3668": "Sambafoot player ID"
    , "P3669": "Swimming Australia swimmer ID"
    , "P3670": "Tennis Archives player ID"
    , "P3671": "USA Gymnastics athlete ID"
    , "P3672": "IOF athlete ID"
    , "P3673": "film-documentaire.fr film ID"
    , "P3674": "Mutopia composer ID"
    , "P3675": "Hans Christian Andersen Centre work ID"
    , "P3676": "National Bridge Inventory Number"
    , "P3677": "Wereld van Oranje player ID"
    , "P3678": "SA Rugby player ID"
    , "P3679": "stock market index"
    , "P3680": "statement supported by"
    , "P3681": "ESPNFC.com player ID"
    , "P3682": "Australian Olympic Committee athlete ID"
    , "P3683": "LFP player ID"
    , "P3684": "Driver Database driver ID"
    , "P3685": "ESPN.com NBA player ID"
    , "P3686": "ESPN.com NFL player ID"
    , "P3687": "ESPN.com NHL player ID"
    , "P3689": "ICF canoer ID"
    , "P3690": "IFSC climber ID"
    , "P3691": "International Swimming Hall of Fame ID"
    , "P3692": "NCAA sports team ID"
    , "P3693": "short-track speed skater ISU ID"
    , "P3694": "SpeedSkatingNews.info speed skater ID"
    , "P3695": "SpeedSkatingStats speed skater ID"
    , "P3696": "Sports-Reference.com college basketball player ID"
    , "P3697": "Sports-Reference.com college football player ID"
    , "P3698": "Tennis Australia player ID"
    , "P3699": "Transfermarkt referee ID"
    , "P3700": "NHF player ID"
    , "P3701": "incarnation of"
    , "P3702": "Catalogue of Illuminated Manuscripts ID"
    , "P3703": "JMDb person or company ID"
    , "P3704": "KMDb film ID"
    , "P3705": "RITVA Program ID"
    , "P3706": "RITVA Person ID"
    , "P3707": "Gridabase glacier ID"
    , "P3708": "PhDTree person ID"
    , "P3709": "category for value different from Wikidata"
    , "P3710": "Jewish Encyclopedia Daat ID"
    , "P3711": "Vanderkrogt.net Statues ID"
    , "P3712": "objective of project or action"
    , "P3713": "category for value not in Wikidata"
    , "P3714": "Recreation.gov point of interest ID"
    , "P3715": "NISH Hall of Fame ID"
    , "P3716": "social classification"
    , "P3717": "MEROPS enzyme ID"
    , "P3718": "NCMEC person ID"
    , "P3719": "regulated by"
    , "P3720": "GPnotebook ID"
    , "P3721": "public key fingerprint"
    , "P3723": "USCG Lighthouse ID"
    , "P3724": "USHMM Holocaust Encyclopedia ID"
    , "P3725": "CEV player ID"
    , "P3726": "EU-Football.info player ID"
    , "P3727": "Serbia municipality ID"
    , "P3728": "New Zealand Heritage List number"
    , "P3729": "next lower rank"
    , "P3730": "next higher rank"
    , "P3731": "Serbia cadastral municipality ID"
    , "P3732": "PhilPapers record"
    , "P3733": "MOOMA artist ID"
    , "P3734": "category for value same as Wikidata"
    , "P3735": "Yad Vashem Encyclopedia of the Ghettos ID"
    , "P3736": "Eurovision Song Contest song ID"
    , "P3737": "maximum wavelength of sensitivity"
    , "P3738": "minimum wavelength of sensitivity"
    , "P3739": "inflorescence"
    , "P3740": "number of works"
    , "P3741": "seed dispersal"
    , "P3742": "FIH player ID"
    , "P3743": "ITU/ISO/IEC object identifier"
    , "P3744": "number of subscribers"
    , "P3745": "World Rugby Sevens Series player ID"
    , "P3746": "Wildflowers of Israel ID"
    , "P3747": "SSRN author ID"
    , "P3748": "Israel Football Association player ID"
    , "P3749": "Google Maps Customer ID"
    , "P3750": "KMDb documentary film ID"
    , "P3751": "Shoftim BeIsrael judge ID"
    , "P3752": "worst-case time complexity"
    , "P3753": "best-case time complexity"
    , "P3754": "average time complexity"
    , "P3755": "worst-case space complexity"
    , "P3756": "best-case space complexity"
    , "P3757": "average space complexity"
    , "P3758": "DOCOMOMO Ib\u00e9rico ID"
    , "P3759": "SAHRA heritage site ID"
    , "P3760": "Iditarod musher ID"
    , "P3761": "IPv4 routing prefix"
    , "P3762": "openMLOL author ID"
    , "P3763": "MIMO instrument ID"
    , "P3764": "pole position"
    , "P3765": "All-Athletics.com ID"
    , "P3766": "European Athletics ID"
    , "P3767": "French Athletics Federation athlete ID"
    , "P3768": "Medieval Libraries of Great Britain ID"
    , "P3769": "It's Rugby player ID"
    , "P3770": "PeakFinder ID"
    , "P3771": "activator of"
    , "P3772": "agonist of"
    , "P3773": "antagonist of"
    , "P3774": "blocker of"
    , "P3775": "disrupting agent for"
    , "P3776": "inhibitor of"
    , "P3777": "antisense inhibitor of"
    , "P3778": "positive allosteric modulator of"
    , "P3779": "negative allosteric modulator of"
    , "P3780": "active ingredient in"
    , "P3781": "has active ingredient"
    , "P3782": "Artnet artist ID"
    , "P3783": "Christie's object ID"
    , "P3784": "CiteSeerX article ID"
    , "P3785": "danskefilm film ID"
    , "P3786": "Danskefilm person ID"
    , "P3787": "danskefilm silent film ID"
    , "P3788": "BNMM authority ID"
    , "P3789": "Telegram username"
    , "P3790": "AnimeCons.com guest ID"
    , "P3791": "Art Renewal Center artist ID"
    , "P3792": "rate of fire"
    , "P3793": "IPv6 routing prefix"
    , "P3794": "Dictionary of Sydney ID"
    , "P3795": "Flora of Israel Online plant ID"
    , "P3796": "Bureau of Meteorology station ID"
    , "P3797": "autonomous system number"
    , "P3798": "Star Wars Databank ID"
    , "P3799": "Safsal player ID"
    , "P3800": "Safsal coach ID"
    , "P3801": "INEGI municipality ID"
    , "P3802": "Launchpad.net project ID"
    , "P3803": "original film format"
    , "P3804": "TV Guide show ID"
    , "P3805": "Tax-exempt heritage asset ID"
    , "P3806": "Mapa place ID"
    , "P3807": "S2A3 Biographical Database ID"
    , "P3808": "The Numbers movie ID"
    , "P3809": "YerelNET district ID"
    , "P3810": "Parks.it ID"
    , "P3811": "Evidence & Conclusion Ontology ID"
    , "P3812": "Elle.fr person ID"
    , "P3813": "Bivouac.com pass ID"
    , "P3814": "BoF person ID"
    , "P3815": "volcano observatory"
    , "P3816": "film script"
    , "P3817": "FI WarSampo person ID"
    , "P3818": "KMRB film rating"
    , "P3819": "FI WarSampo army unit ID"
    , "P3820": "Flanders Arts Institute venue ID"
    , "P3821": "Bangla Movie Database ID"
    , "P3822": "rules for classification"
    , "P3823": "Ethnologue language_code status"
    , "P3824": "VTJ-PRT building ID"
    , "P3825": "United States Statutes at Large citation"
    , "P3826": "Welsh Rugby Union men's player ID"
    , "P3827": "JSTOR topic ID"
    , "P3828": "wears"
    , "P3829": "Publons author ID"
    , "P3830": "CueTracker player ID"
    , "P3831": "object has role"
    , "P3832": "Europeana Fashion Vocabulary ID"
    , "P3833": "diaspora"
    , "P3834": "RTC film rating"
    , "P3835": "Mendeley person ID"
    , "P3836": "Pinterest username"
    , "P3837": "United States Public Law"
    , "P3838": "Tab4u song ID"
    , "P3839": "Tab4u artist ID"
    , "P3840": "slope rating"
    , "P3841": "Human Phenotype Ontology ID"
    , "P3842": "located in present-day administrative territorial entity"
    , "P3843": "German Athletics Association athlete ID"
    , "P3844": "Deutsche Synchronkartei film ID"
    , "P3845": "TV Guide person ID"
    , "P3846": "DBC author ID"
    , "P3847": "Open Library subject ID"
    , "P3848": "Irish Rugby Football Union men's player ID"
    , "P3849": "LombardiaBeniCulturali institution ID"
    , "P3850": "LombardiaBeniCulturali toponym ID"
    , "P3851": "Cinenacional.com movie ID"
    , "P3852": "FlyBase Gene ID"
    , "P3853": "Rat Genome Database ID"
    , "P3854": "Soundtrack Collector ID"
    , "P3855": "LombardiaBeniCulturali artwork ID"
    , "P3856": "Quebec municipalities geographical code"
    , "P3857": "Cinenacional.com person ID"
    , "P3858": "route diagram"
    , "P3859": "Environment Ontology ID"
    , "P3860": "Wormbase Gene ID"
    , "P3861": "App Store app ID (global)"
    , "P3862": "MyDramaList name ID"
    , "P3863": "Italian Navy Lighthouses and Beacons ID"
    , "P3864": "suicide rate"
    , "P3865": "type of reference"
    , "P3866": "LAWA waterbody ID"
    , "P3867": "Israel Chess Federation player ID"
    , "P3868": "MyDramaList title ID"
    , "P3869": "IAFD female performer ID"
    , "P3870": "ZFIN Gene ID"
    , "P3871": "tributary orientation"
    , "P3872": "patronage"
    , "P3874": "Justia Patents inventor ID"
    , "P3875": "Justia Patents company ID"
    , "P3876": "category for alumni of educational institution"
    , "P3877": "HappyCow restaurant ID"
    , "P3878": "Soundex"
    , "P3879": "Cologne phonetics"
    , "P3880": "Caverphone"
    , "P3881": "National Track & Field Hall of Fame athlete ID"
    , "P3882": "Tilastopaja female athlete ID"
    , "P3883": "Red Bull athlete ID"
    , "P3884": "Tilastopaja male athlete ID"
    , "P3885": "History of Modern Biomedicine ID"
    , "P3886": "number of perpetrators"
    , "P3887": "KVAB member ID"
    , "P3888": "Boijmans artist ID"
    , "P3889": "Swiss Federal Archives ID"
    , "P3890": "MetaboLights Compound ID"
    , "P3891": "observing time available"
    , "P3892": "PictoRight ID-Droit de suite"
    , "P3893": "public domain date"
    , "P3894": "OSTI article ID"
    , "P3895": "INAO product ID"
    , "P3896": "geoshape"
    , "P3897": "Ladies European Tour golf player ID"
    , "P3898": "Hotels.com hotel ID"
    , "P3899": "Medium username"
    , "P3900": "CONICET person ID"
    , "P3901": "ADAGP artist ID"
    , "P3902": "had as last meal"
    , "P3903": "column"
    , "P3904": "VIVC grape variety ID"
    , "P3906": "Ishim ID"
    , "P3907": "LoJ peak ID"
    , "P3908": "Reprezentacija player ID"
    , "P3909": "last words"
    , "P3910": "Bollywood Hungama person numeric ID"
    , "P3911": "STW Thesaurus for Economics ID"
    , "P3912": "newspaper format"
    , "P3913": "MobyGames developer ID"
    , "P3914": "GuideStar Israel organization ID"
    , "P3915": "Australian Athletics Historical Results athlete ID"
    , "P3916": "UNESCO Thesaurus ID"
    , "P3917": "IPA number order"
    , "P3918": "R\u00e9pertoire national des associations identifier"
    , "P3919": "contributed to creative work"
    , "P3920": "Canadian Coastguard Lighthouse ID"
    , "P3921": "Wikidata SPARQL query equivalent"
    , "P3922": "light sector"
    , "P3923": "Diamond League athlete ID"
    , "P3924": "Track and Field Statistics female athlete ID"
    , "P3925": "Track and Field Statistics male athlete ID"
    , "P3926": "USA Track & Field athlete ID"
    , "P3927": "eWRC-results.com racer ID"
    , "P3928": "MotoGP racer ID"
    , "P3929": "V&A item ID"
    , "P3930": "Rallye-info.com driver or co-driver ID"
    , "P3931": "copyright holder"
    , "P3932": "Digital Valencian Library author ID"
    , "P3933": "Cinema.de ID"
    , "P3934": "face value"
    , "P3935": "Chamber of Deputies of Italy storia ID"
    , "P3936": "NFF person ID"
    , "P3937": "Reactome ID"
    , "P3938": "named by"
    , "P3939": "ESTC citation number"
    , "P3940": "OlimpBase Chess Olympiad player ID"
    , "P3941": "Israel Antiquities Authority ID"
    , "P3942": "Bmx-results.com rider ID"
    , "P3943": "Tumblr username"
    , "P3944": "Old Bailey Proceedings ID"
    , "P3945": "RANM member ID"
    , "P3946": "Dictionary Grierson ID"
    , "P3948": "MLL player ID"
    , "P3949": "Juwra.com ID"
    , "P3950": "narrower external class"
    , "P3951": "BioRxiv ID"
    , "P3952": "Stereo Ve Mono artist ID"
    , "P3953": "ALPG Tour golf player ID"
    , "P3954": "Italian Senate ID"
    , "P3955": "NLL player ID"
    , "P3956": "National Academy of Medicine (France) Member ID"
    , "P3957": "RealGM basketball player ID"
    , "P3958": "ENARD athlete ID"
    , "P3959": "NNL work ID"
    , "P3960": "Base biographique AUTOR ID"
    , "P3961": "Unifrance film ID"
    , "P3962": "Global Trade Item Number"
    , "P3963": "Clochers de France ID"
    , "P3964": "BDCYL authority ID"
    , "P3965": "Bridgeman artist ID"
    , "P3966": "programming paradigm"
    , "P3967": "final event"
    , "P3968": "CETS number"
    , "P3969": "signed form"
    , "P3970": "channel number"
    , "P3971": "PASE Domesday person ID"
    , "P3972": "PASE Domesday place"
    , "P3973": "PIM authority ID"
    , "P3974": "nature preserve in North Rhine-Westphalia ID"
    , "P3975": "secretary general"
    , "P3976": "BVMC work ID"
    , "P3977": "Songkick venue ID"
    , "P3978": "IECIC 2015 ID"
    , "P3979": "Unifrance company ID"
    , "P3980": "Unifrance person ID"
    , "P3981": "Misjonsarkiv person ID"
    , "P3982": "TA98 Latin term"
    , "P3983": "sports league level"
    , "P3984": "subreddit"
    , "P3985": "supports programming language_code"
    , "P3986": "Sequence Ontology ID"
    , "P3987": "SHARE Catalogue author ID"
    , "P3988": "National Library Board Singapore ID"
    , "P3989": "members have occupation"
    , "P3990": "BG EKATTE place ID"
    , "P3991": "Austrian Textbook ID"
    , "P3992": "SSB urban settlement number"
    , "P3993": "Vitaskr\u00e1 ID"
    , "P3994": "racon signal"
    , "P3995": "Filmweb.pl ID"
    , "P3996": "Bait La Zemer Ha-Ivri song ID"
    , "P3997": "Bait La Zemer Ha-Ivri artist ID"
    , "P3998": "Censo-Gu\u00eda archive ID"
    , "P3999": "date of official closure"
    , "P4000": "has fruit type"
    , "P4001": "Latvian Protected Nature Territory URL"
    , "P4002": "WFD Ecological status"
    , "P4003": "Facebook ID name/number"
    , "P4004": "escutcheon image"
    , "P4005": "Bavarikon ID"
    , "P4006": "overrules"
    , "P4007": "DBS ID"
    , "P4008": "Early Aviators people ID"
    , "P4009": "RKY national built heritage environment ID"
    , "P4010": "GDP (PPP)"
    , "P4011": "Semantic Scholar paper ID"
    , "P4012": "Semantic Scholar author ID"
    , "P4013": "Giphy username"
    , "P4014": "Australian Statistical Geography 2011 ID"
    , "P4015": "Vimeo username"
    , "P4016": "SlideShare username"
    , "P4017": "Ustream username"
    , "P4018": "The Arabidopsis Information Resource Accession"
    , "P4019": "USL Championship player ID"
    , "P4020": "ISQ dimension"
    , "P4021": "danskefilm animated film ID"
    , "P4022": "danskefilm TV series ID"
    , "P4023": "German Football Association person ID"
    , "P4024": "ADW taxon ID"
    , "P4025": "Pinakothek artist ID"
    , "P4026": "Cullum number"
    , "P4027": "National Discography of Italian Song work ID"
    , "P4028": "Google Scholar paper ID"
    , "P4029": "Latvian Protected Nature Territory ID"
    , "P4030": "PLU code"
    , "P4031": "Hungarian NGO ID"
    , "P4032": "reviewed by"
    , "P4033": "Mastodon address"
    , "P4034": "Shironet artist ID"
    , "P4035": "Shironet song ID"
    , "P4036": "field of view"
    , "P4037": "South Australian Heritage Register Database ID"
    , "P4038": "Danish List of Lights and Fog signals ID"
    , "P4040": "Rock.com.ar artist ID"
    , "P4041": "Rock.com.ar album ID"
    , "P4042": "ESBL athlete ID"
    , "P4043": "emulates"
    , "P4044": "therapeutic area"
    , "P4045": "Sandbox-Tabular data"
    , "P4046": "SIMC place ID"
    , "P4047": "Sandbox-Geographic shape"
    , "P4048": "J.League manager ID"
    , "P4050": "French Olympic Committee athlete ID"
    , "P4051": "Ukrainian regulations base ID"
    , "P4052": "Academia.edu institutional ID"
    , "P4053": "German Olympic Sports Confederation athlete ID"
    , "P4054": "Canadian Olympic Committee athlete ID"
    , "P4055": "Norwegian List of Lights ID"
    , "P4056": "New Zealand Olympic Committee athlete ID"
    , "P4057": "Irish Sites and Monuments Record ID"
    , "P4058": "FINESS medical facility ID"
    , "P4059": "Irish National Monument ID"
    , "P4060": "Brazilian Olympic Committee athlete ID"
    , "P4061": "Lithuanian National Olympic Committee athlete ID"
    , "P4062": "Czech Olympic Committee athlete ID"
    , "P4063": "United States Olympic & Paralympic Committee athlete ID"
    , "P4065": "Argentine Olympic Committee athlete ID"
    , "P4066": "Hungarian Olympic Committee athlete ID"
    , "P4067": "Romanian Olympic and Sports Committee athlete ID"
    , "P4068": "Chinese Olympic Committee athlete ID"
    , "P4069": "Italian National Olympic Committee athlete ID"
    , "P4070": "identifier shared with"
    , "P4071": "Zemereshet artist ID"
    , "P4072": "Zemereshet song ID"
    , "P4073": "Fandom wiki ID"
    , "P4074": "FFN swimmer ID"
    , "P4075": "Czech Monument Catalogue Number"
    , "P4076": "WorldSBK.com racer identifier"
    , "P4077": "Pizmonet ID"
    , "P4078": "SKIP code"
    , "P4079": "Theatres Trust Database ID"
    , "P4080": "number of houses"
    , "P4081": "BHL creator ID"
    , "P4082": "image captured with"
    , "P4083": "Park Alpha Code"
    , "P4084": "MyAnimeList people ID"
    , "P4085": "MyAnimeList character ID"
    , "P4086": "MyAnimeList anime ID"
    , "P4087": "MyAnimeList manga ID"
    , "P4088": "Irish National Inventory of Architectural Heritage ID"
    , "P4089": "Global Terrorism Database ID"
    , "P4090": "Biodiversity Repository ID"
    , "P4091": "Irish Grid Reference"
    , "P4092": "checksum"
    , "P4093": "Australian Statistical Geography 2016 ID"
    , "P4094": "Australian Standard Geographic Classification 2006 ID"
    , "P4095": "Principal Galaxies Catalogue ID"
    , "P4096": "RePEc institute ID"
    , "P4097": "MuseScore ID"
    , "P4098": "BVMC place ID"
    , "P4099": "metrically compatible typeface"
    , "P4100": "parliamentary group"
    , "P4101": "dissertation submitted to"
    , "P4102": "Atlas of Hillforts ID"
    , "P4103": "assets under management"
    , "P4104": "Carnegie Hall agent ID"
    , "P4105": "EGF rating"
    , "P4106": "Finnish archaeological heritage ID"
    , "P4107": "Framalibre ID"
    , "P4108": "Gedbas genealogy person ID"
    , "P4109": "URN-NBN"
    , "P4110": "Crunchyroll ID"
    , "P4111": "danskefilm TV Christmas calendar"
    , "P4112": "danskfilmogtv person ID"
    , "P4113": "FRED time-series ID"
    , "P4114": "ADK member ID"
    , "P4115": "INSPIRE ID"
    , "P4116": "JewAge person ID"
    , "P4117": "National Record of the Historic Environment ID"
    , "P4118": "NLS-FI Geographic Name ID"
    , "P4119": "NLS Geographic Names Place ID"
    , "P4120": "Ontario Heritage Act Register ID"
    , "P4121": "openAIP ID"
    , "P4122": "PalDat plant ID"
    , "P4123": "French National Assembly ID"
    , "P4124": "Who's Who in France biography ID"
    , "P4125": "Titan ID"
    , "P4126": "ESEC person ID"
    , "P4127": "EmbassyPages.com ID"
    , "P4128": "NPSN Indonesian school ID"
    , "P4129": "Cinema Treasures ID"
    , "P4130": "USHMM person ID"
    , "P4131": "annual energy output"
    , "P4132": "linguistic typology"
    , "P4133": "Patrimonioculturale-ER ID"
    , "P4135": "maximum age"
    , "P4136": "WIGOS station ID"
    , "P4137": "muzzle velocity"
    , "P4138": "Treasury of Lives ID"
    , "P4139": "National Assembly of Nigeria ID"
    , "P4140": "energy storage capacity"
    , "P4141": "Gatehouse Gazetteer place ID"
    , "P4142": "RIWAQ Registry of Historic Buildings in Palestine ID"
    , "P4143": "Finnish List of Lights ID"
    , "P4144": "Athenaeum artwork ID"
    , "P4145": "Athenaeum person ID"
    , "P4146": "Athenaeum museum ID"
    , "P4147": "conjugate acid"
    , "P4149": "conjugate base"
    , "P4150": "weather history"
    , "P4151": "game mechanics"
    , "P4152": "file format identification pattern"
    , "P4153": "offset"
    , "P4154": "National Forest Foundation ID"
    , "P4155": "separator"
    , "P4156": "Czech Registration ID"
    , "P4157": "MEG ID"
    , "P4158": "autores.ar ID"
    , "P4159": "WeRelate person ID"
    , "P4160": "Michelin Restaurants ID"
    , "P4161": "Michelin Voyages ID"
    , "P4162": "AUR package"
    , "P4163": "magnification"
    , "P4164": "National Baseball Hall of Fame and Museum ID"
    , "P4165": "CODECS ID"
    , "P4166": "Georgian National Register of Monuments ID"
    , "P4167": "Dagens N\u00e6ringsliv topic ID"
    , "P4168": "IEDB Epitope ID"
    , "P4169": "YCBA agent ID"
    , "P4170": "America's National Parks ID"
    , "P4171": "World Heritage Tentative List ID"
    , "P4172": "America's Byways road ID"
    , "P4173": "Instagram location ID"
    , "P4174": "Wikimedia username"
    , "P4175": "Patreon ID"
    , "P4176": "effective firing range"
    , "P4177": "Finnish National Gallery artist ID"
    , "P4178": "Beazley Archive Pottery Database ID"
    , "P4179": "tabular population"
    , "P4180": "GujLit Person ID"
    , "P4181": "GujLit Book ID"
    , "P4182": "National Natural Landmarks site ID"
    , "P4183": "angle from vertical"
    , "P4184": "slope"
    , "P4185": "iconographic symbol"
    , "P4186": "Australian Women's Register ID"
    , "P4187": "Wylie transliteration"
    , "P4188": "Tibetan pinyin"
    , "P4189": "THL Simplified Phonetic Transcription"
    , "P4190": "Rivers.gov protected area ID"
    , "P4191": "Alljudo judoka ID"
    , "P4192": "LNH player ID"
    , "P4193": "Familypedia person ID"
    , "P4194": "CNPS ID"
    , "P4195": "category for employees of the organization"
    , "P4196": "cytogenetic location"
    , "P4197": "IBM graphic character set global ID"
    , "P4198": "Google Play Music artist ID"
    , "P4199": "Google Play Music album ID"
    , "P4200": "Christie's creator ID"
    , "P4201": "PagesJaunes ID"
    , "P4202": "WFD Chemical status"
    , "P4203": "ROARMAP ID"
    , "P4204": "The Times of India topic ID"
    , "P4206": "FOIH person ID"
    , "P4207": "Italian National Earthquake Center ID"
    , "P4208": "Billboard artist ID"
    , "P4209": "danskfilmogtv title ID"
    , "P4210": "Bashkir encyclopedia (Bashkir version) ID"
    , "P4211": "Bashkir encyclopedia (Russian version) ID"
    , "P4212": "PACTOLS thesaurus ID"
    , "P4213": "Unicode hex codepoint"
    , "P4214": "highest observed lifespan"
    , "P4215": "nLab ID"
    , "P4216": "LNB Pro A player ID"
    , "P4217": "UK Electoral Commission ID"
    , "P4218": "shelf life"
    , "P4219": "Tyrolean Art Cadastre inventory ID"
    , "P4220": "order of battle"
    , "P4221": "National Criminal Justice ID"
    , "P4222": "United Nations Treaty Series Volume Number"
    , "P4223": "Treccani's Enciclopedia Italiana ID"
    , "P4224": "category contains"
    , "P4225": "IPA Braille"
    , "P4226": "Cyworld ID"
    , "P4227": "Indonesian Small Islands Directory ID"
    , "P4228": "Encyclopedia of Australian Science ID"
    , "P4229": "ICD-10-CM"
    , "P4230": "Sefaria ID"
    , "P4231": "United Nations Treaty Series Registration Number"
    , "P4232": "Figshare author ID"
    , "P4233": "PatientsLikeMe condition ID"
    , "P4235": "PatientsLikeMe treatment ID"
    , "P4236": "PatientsLikeMe symptom ID"
    , "P4238": "webcam page URL"
    , "P4239": "vocalized name"
    , "P4240": "regular expression syntax"
    , "P4241": "refine date"
    , "P4242": "maximal rate of climb"
    , "P4243": "candidate number"
    , "P4244": "Bavarian monument authority ID"
    , "P4245": "cultural heritage monument in Serbia ID"
    , "P4246": "LfD-HB object ID"
    , "P4247": "Tagesschau election ID"
    , "P4248": "The Black Book ID"
    , "P4249": "Vincoli in Rete ID"
    , "P4250": "defined daily dose"
    , "P4251": "TSE number"
    , "P4252": "All-Russian Mathematical Portal ID"
    , "P4253": "number of constituencies"
    , "P4254": "Banglapedia (Bengali version) ID"
    , "P4255": "Banglapedia (English version) ID"
    , "P4256": "BOE ID"
    , "P4257": "National Museums of Japan e-museum ID"
    , "P4258": "Gallica ID"
    , "P4259": "Lega Pallavolo Serie A Femminile player ID"
    , "P4260": "NPB player ID"
    , "P4261": "FFVoile sailor ID"
    , "P4262": "Footof\u00e9minin.fr player ID"
    , "P4263": "THW Kiel player ID"
    , "P4264": "LinkedIn company ID"
    , "P4265": "Reddit username"
    , "P4266": "Bavarian geotope ID"
    , "P4267": "Landtag of Liechtenstein ID"
    , "P4268": "half maximal inhibitory concentration (IC50)"
    , "P4269": "half maximal effective concentration (EC50)"
    , "P4270": "Daum TV series ID"
    , "P4271": "rating"
    , "P4272": "DPLA subject ID"
    , "P4273": "New York City Landmarks Preservation Commission ID"
    , "P4274": "Tunisian geographic code"
    , "P4275": "Japanese Database of National important cultural properties"
    , "P4276": "Cin\u00e9math\u00e8que qu\u00e9b\u00e9coise work identifier"
    , "P4277": "Daum movie ID"
    , "P4278": "FCI rider ID"
    , "P4279": "hydrological order number"
    , "P4280": "International Standard Text Code"
    , "P4281": "LNV player ID"
    , "P4282": "LUMIERE film ID"
    , "P4283": "LUMIERE director ID"
    , "P4284": "Nominis given name ID"
    , "P4285": "Theses.fr person ID"
    , "P4286": "Nominis saint ID"
    , "P4287": "Riigikogu ID"
    , "P4288": "UK National Fruit Collection ID"
    , "P4289": "LFH player ID"
    , "P4290": "official app"
    , "P4291": "panoramic view"
    , "P4292": "possessed by spirit"
    , "P4293": "PM20 folder ID"
    , "P4294": "PROSPERO ID"
    , "P4295": "readership"
    , "P4296": "stellar rotational velocity"
    , "P4297": "MIL-STD-2525 Symbol Identification Code"
    , "P4298": "VBL player ID"
    , "P4299": "ITF wheelchair player ID"
    , "P4300": "YouTube playlist ID"
    , "P4301": "PfaF ID"
    , "P4302": "Royal Dutch Athletics Federation athlete ID"
    , "P4303": "Lega Pallavolo Serie A player ID"
    , "P4304": "FOIH materials ID"
    , "P4305": "FOIH styles and cultures ID"
    , "P4306": "FOIH periods ID"
    , "P4307": "FOIH heritage types ID"
    , "P4308": "FOIH value types ID"
    , "P4309": "FOIH event types ID"
    , "P4310": "FOIH decree types ID"
    , "P4311": "FOIH taxon ID"
    , "P4312": "camera setup"
    , "P4313": "mus\u00e9e de Bretagne identifiant collections ID"
    , "P4314": "SpeedskatingResults.com speed skater ID"
    , "P4315": "SwimSwam ID"
    , "P4316": "kinship equivalent in SPARQL at Wikidata"
    , "P4317": "GARD rare disease ID"
    , "P4318": "Scottish Sports Hall of Fame athlete ID"
    , "P4319": "Elite Prospects staff ID"
    , "P4320": "mountains classification"
    , "P4321": "best combative classification"
    , "P4322": "best sprinter classification"
    , "P4323": "young rider classification"
    , "P4324": "combination classification"
    , "P4325": "APA phoneme code"
    , "P4326": "BFI Filmography person ID"
    , "P4327": "BHL bibliography ID"
    , "P4328": "Brueckenweb ID"
    , "P4329": "Wikimedia template or module that populates this category"
    , "P4330": "contains"
    , "P4331": "Department of Education and Skills roll number"
    , "P4332": "Deutsche Synchronkartei actor ID"
    , "P4333": "GenBank Assembly accession"
    , "P4334": "Heritage Conservation District of Ontario ID"
    , "P4335": "IDESCAT territorial code in Catalonia"
    , "P4336": "Lloyd's Register Ship ID"
    , "P4337": "digitised page from Lloyd's Register of Ships from 1930 to 1945"
    , "P4338": "LOINC ID"
    , "P4339": "Radio Radicale organizer ID"
    , "P4340": "PubsHistory pub ID"
    , "P4341": "synodic period"
    , "P4342": "Store norske leksikon ID"
    , "P4343": "WBPLN author ID"
    , "P4344": "QEdu ID"
    , "P4345": "director of archaeological fieldwork"
    , "P4346": "T4T35 megalith ID"
    , "P4347": "Florida Sports Hall of Fame athlete ID"
    , "P4348": "Lotsawa House Tibetan author ID"
    , "P4349": "Lotsawa House Indian author ID"
    , "P4350": "salinity"
    , "P4351": "Cravo Albin artist ID"
    , "P4352": "BillionGraves cemetery ID"
    , "P4353": "nominated by"
    , "P4354": "search formatter URL"
    , "P4355": "PROSITE documentation ID"
    , "P4356": "Megalithic Portal ID"
    , "P4357": "Musikverket person ID"
    , "P4358": "Dutch lost building register ID"
    , "P4359": "gravsted.dk ID"
    , "P4360": "Monumentos de S\u00e3o Paulo ID"
    , "P4361": "ExecutedToday ID"
    , "P4362": "Alabama Sports Hall of Fame athlete ID"
    , "P4363": "DSMHOF athlete ID"
    , "P4364": "Georgia Sports Hall of Fame ID"
    , "P4365": "Hawai\u2018i Sports Hall of Fame ID"
    , "P4366": "Kansas Sports Hall of Fame ID"
    , "P4367": "Louisiana Sports Hall of Fame ID"
    , "P4368": "Mississippi Sports Hall of Fame ID"
    , "P4369": "Cairn author ID"
    , "P4370": "KBO hitter ID"
    , "P4371": "KBO pitcher ID"
    , "P4372": "iPatrim\u00f4nio ID"
    , "P4373": "National Trust Collections ID"
    , "P4374": "New Mexico Sports Hall of Fame ID"
    , "P4375": "North Carolina Sports Hall of Fame ID"
    , "P4376": "Oklahoma Sports Hall of Fame ID"
    , "P4377": "Women's Sports Foundation ID"
    , "P4379": "youth wing"
    , "P4380": "Sandrart.net artwork ID"
    , "P4381": "Soccerdonna player ID"
    , "P4382": "LFB player ID"
    , "P4383": "Tennessee Sports Hall of Fame athlete ID"
    , "P4384": "DAMIT asteroid ID"
    , "P4385": "Missouri Sports Hall of Fame ID"
    , "P4386": "Virginia Sports Hall of Fame ID"
    , "P4387": "update method"
    , "P4388": "Mappy place ID"
    , "P4389": "Science Museum people ID"
    , "P4390": "mapping relation type"
    , "P4391": "The-Sports.org athlete ID"
    , "P4392": "BC Sports Hall of Fame athlete ID"
    , "P4393": "Anvisa drug ID"
    , "P4394": "NeuroNames ID (plain mode)"
    , "P4395": "BrainInfo ID (hierarchical)"
    , "P4396": "Alberta Sports Hall of Fame and Museum athlete ID"
    , "P4397": "IPC.infostradasports.com athlete ID"
    , "P4398": "Canada's Sports Hall of Fame athlete ID"
    , "P4399": "Ita\u00fa Cultural ID"
    , "P4400": "Mem\u00f3ria Globo"
    , "P4401": "ID Museus Brazil"
    , "P4402": "Women's Collegiate Tennis Hall of Fame ID"
    , "P4403": "caliber"
    , "P4404": "MusicBrainz recording ID"
    , "P4405": "NLBPA ID"
    , "P4406": "Nova Scotia Sport Hall of Fame ID"
    , "P4407": "Opera Vivra singer ID"
    , "P4408": "sports.ru athlete ID"
    , "P4409": "Baseball Almanac ID"
    , "P4410": "Women's Basketball Hall of Fame ID"
    , "P4411": "Quora username"
    , "P4412": "Ontario Sports Hall of Fame athlete ID"
    , "P4413": "Manitoba Sports Hall of Fame athlete ID"
    , "P4414": "New Brunswick Sports Hall of Fame athlete ID"
    , "P4415": "Sport Australia Hall of Fame inductee ID"
    , "P4416": "Panth\u00e9on des sports du Qu\u00e9bec ID"
    , "P4417": "Russian Premier League player ID"
    , "P4418": "New Zealand Sports Hall of Fame ID"
    , "P4419": "Videolectures ID"
    , "P4421": "Sportbox.ru ID"
    , "P4422": "U.S. Ski and Snowboard Hall of Fame athlete ID"
    , "P4423": "Portuguese lighthouse ID"
    , "P4424": "mandates"
    , "P4425": "mtDNA haplogroup"
    , "P4426": "Y-DNA Haplogroup"
    , "P4427": "GACS ID"
    , "P4428": "implementation of"
    , "P4429": "Pro14 player ID"
    , "P4430": "New York City Parks monument ID"
    , "P4431": "Google Doodle"
    , "P4432": "AKL Online artist ID"
    , "P4433": "Indian Foundation for Butterflies ID"
    , "P4434": "LesBiographies.com ID"
    , "P4435": "snap package"
    , "P4436": "The Coptic Library ID"
    , "P4437": "FPB rating"
    , "P4438": "BFI Films, TV and people ID"
    , "P4439": "MNCARS artist ID"
    , "P4440": "Biblioteca Nacional de M\u00e9xico ID"
    , "P4441": "hydraulic head"
    , "P4442": "mean age"
    , "P4443": "card network"
    , "P4444": "reward"
    , "P4445": "grace period"
    , "P4446": "reward program"
    , "P4447": "minimum spend bonus"
    , "P4448": "cash back"
    , "P4449": "Shirat Nashim person ID"
    , "P4450": "HAL author ID"
    , "P4451": "Scoresway handball person ID"
    , "P4452": "Thibaudeau classification"
    , "P4453": "Argentine Senate member ID"
    , "P4454": "Argentine Chamber of Deputies ID"
    , "P4455": "Coinage of the Roman Republic Online ID"
    , "P4456": "Internet Off-Broadway Database creditable entity ID"
    , "P4457": "DAHR artist ID"
    , "P4458": "Dutch Cemetery in Chinsurah person ID"
    , "P4459": "Spanish Biographical Dictionary ID"
    , "P4460": "Kaitai Struct format gallery ID"
    , "P4461": "World Golf Hall of Fame player ID"
    , "P4462": "Canadian Baseball Hall of Fame inductee ID"
    , "P4463": "Canadian Ski Hall of Fame inductee ID"
    , "P4464": "Rugby League Project player ID"
    , "P4465": "Ecole des chartes thesis abstract ID"
    , "P4466": "Unified Astronomy Thesaurus ID"
    , "P4467": "Twitch game ID"
    , "P4468": "Mountain Bike Hall of Fame inductee ID"
    , "P4469": "IGHOF athlete ID"
    , "P4470": "British Bobsleigh & Skeleton Association ID"
    , "P4471": "Rush Parliamentary Archive ID"
    , "P4472": "Czech Jockey Club horse ID"
    , "P4473": "Melon artist ID"
    , "P4474": "International Boxing Hall of Fame boxer ID"
    , "P4475": "European Fencing Confederation fencer ID"
    , "P4476": "Australian Baseball League player ID"
    , "P4477": "Humble Store ID"
    , "P4478": "Survey of Scottish Witchcraft - Accused witch ID"
    , "P4479": "INDUCKS character ID"
    , "P4480": "INDUCKS publication ID"
    , "P4481": "INDUCKS creator ID"
    , "P4482": "INDUCKS publisher ID"
    , "P4483": "INDUCKS story ID"
    , "P4484": "INDUCKS issue ID"
    , "P4485": "INDUCKS miniseries ID"
    , "P4486": "Google Play developer ID"
    , "P4487": "Camera Decision ID"
    , "P4488": "COAM architect ID"
    , "P4489": "Hellenic Olympic Committee athlete ID"
    , "P4490": "British Olympic Association athlete ID"
    , "P4491": "Isidore scholar ID"
    , "P4493": "Barbarian F.C. ID"
    , "P4494": "Barbarian R.C. ID"
    , "P4495": "Xenopus Anatomical Ontology ID"
    , "P4496": "NACE code"
    , "P4498": "World Snooker athlete ID"
    , "P4500": "family relationship degree"
    , "P4501": "albedo"
    , "P4502": "Snooker.org player ID"
    , "P4503": "Wimbledon player ID"
    , "P4504": "IWRP athlete ID"
    , "P4505": "IAFD male performer ID"
    , "P4506": "Formal Public Identifier"
    , "P4507": "California Sports Hall of Fame athlete ID"
    , "P4508": "CycleBase cyclist ID"
    , "P4509": "National Monuments of Namibia Site Reference"
    , "P4510": "describes a project that uses"
    , "P4511": "vertical depth"
    , "P4512": "Scottish Cemetery Kolkata person ID"
    , "P4513": "Africultures movie ID"
    , "P4514": "Africultures person ID"
    , "P4515": "Prisma ID"
    , "P4516": "M\u00e9moire du cyclisme cyclist ID"
    , "P4517": "ctext work ID"
    , "P4518": "Melon album ID"
    , "P4519": "payload mass"
    , "P4520": "SUNCAT ID"
    , "P4521": "Radio Radicale person ID"
    , "P4522": "Alaska Sports Hall of Fame athlete ID"
    , "P4523": "Vermont Sports Hall of Fame athlete ID"
    , "P4524": "Survey of Scottish Witchcraft - Person ID"
    , "P4525": "MuIS object ID"
    , "P4526": "ABA bird ID"
    , "P4527": "UK Parliament thesaurus ID"
    , "P4528": "NVE Drainage Basin (REGINE) ID"
    , "P4529": "Douban film ID"
    , "P4530": "Bangladesh administrative division code (pre-2017)"
    , "P4531": "ChinesePosters artist ID"
    , "P4532": "Survey of Scottish Witchcraft - Trial ID"
    , "P4533": "Czech street ID"
    , "P4534": "EUTA person ID"
    , "P4535": "EUTA theatre ID"
    , "P4536": "EThOS thesis ID"
    , "P4537": "Spider Ontology ID"
    , "P4538": "Snooker Database player ID"
    , "P4539": "Collective Biographies of Women ID"
    , "P4540": "IBTrACS cyclone ID"
    , "P4541": "Croatian Olympic Committee athlete ID"
    , "P4542": "World of O athlete ID"
    , "P4543": "has listed ingredient"
    , "P4544": "Tennis Temple player ID"
    , "P4545": "sexually homologous with"
    , "P4546": "Gymn Forum athlete ID"
    , "P4547": "Serbian Olympic Committee athlete ID"
    , "P4548": "Commonwealth Games Federation athlete ID"
    , "P4549": "ARLIMA ID"
    , "P4550": "CNRS research group ID"
    , "P4551": "Everyone Remembered ID"
    , "P4552": "mountain range"
    , "P4553": "RA Collections ID"
    , "P4554": "ICRC PoW ID"
    , "P4555": "Canada Games athlete ID"
    , "P4556": "FAI ID"
    , "P4557": "Indiana Basketball Hall of Fame ID"
    , "P4558": "SNCZI-IPE dam ID"
    , "P4559": "IJF judoka ID"
    , "P4560": "National Collegiate Basketball Hall of Fame ID"
    , "P4561": "Basketball-Reference.com WNBA player ID"
    , "P4562": "Japanese Baseball Hall of Fame ID"
    , "P4563": "Art Museum of Estonia artist ID"
    , "P4564": "Art Museum of Estonia artwork ID"
    , "P4565": "electoral district number"
    , "P4566": "awarded for period"
    , "P4567": "BTO five-letter code"
    , "P4568": "SNCZI-IPE reservoir ID"
    , "P4569": "BPH journal ID"
    , "P4571": "West Australian Football League player ID"
    , "P4572": "SS KL Auschwitz Garrison ID"
    , "P4573": "Merchant Category Code"
    , "P4574": "Norwegian historical register of persons ID"
    , "P4575": "HTML entity"
    , "P4576": "Tidal artist ID"
    , "P4577": "Tidal album ID"
    , "P4578": "Tidal track ID"
    , "P4579": "Tidal music video ID"
    , "P4580": "Berlinische Galerie artist ID"
    , "P4581": "St\u00e4del Museum artist ID"
    , "P4582": "Kulturelles Erbe K\u00f6ln object ID"
    , "P4583": "U.S. Gymnastics Hall of Fame athlete ID"
    , "P4584": "first appearance"
    , "P4585": "Accademia della Crusca ID"
    , "P4586": "type foundry"
    , "P4587": "Argentinian Historic Heritage ID"
    , "P4588": "International World Games Association athlete ID"
    , "P4589": "Dreadnought Project page"
    , "P4590": "Atomic Heritage Foundation ID"
    , "P4591": "National Inventory of Canadian Military Memorials ID"
    , "P4592": "Mountain Project ID"
    , "P4593": "Spanish Paralympic Committee athlete ID"
    , "P4594": "arXiv author ID"
    , "P4595": "post town"
    , "P4596": "NIOSH Numbered Publication ID"
    , "P4597": "FAPESP institution ID"
    , "P4598": "FAPESP researcher ID"
    , "P4599": "monomer of"
    , "P4600": "polymer of"
    , "P4601": "Lives of WWI ID"
    , "P4602": "date of burial or cremation"
    , "P4604": "World Rugby Hall of Fame ID"
    , "P4605": "South Dakota Sports Hall of Fame ID"
    , "P4606": "National Film Board of Canada film ID"
    , "P4607": "Swedish Musical Heritage composer ID"
    , "P4608": "scenographer"
    , "P4609": "Queensland Australian Football Hall of Fame inductee ID"
    , "P4610": "ARTIC artwork ID"
    , "P4611": "LACMA ID"
    , "P4612": "LKL player ID"
    , "P4613": "Encyclopedia of Modern Ukraine ID"
    , "P4614": "drainage basin"
    , "P4615": "WAFL FootyFacts ID"
    , "P4616": "UniProt journal ID"
    , "P4617": "DVV player ID"
    , "P4618": "AUSNUT 2011\u201313 Food Group ID"
    , "P4619": "National Library of Brazil ID"
    , "P4620": "Merkelstiftung person ID"
    , "P4621": "W\u00fcrttembergische Kirchengeschichte person ID"
    , "P4622": "trophy awarded"
    , "P4623": "South Australian Football Hall of Fame inductee ID"
    , "P4624": "squadron embarked"
    , "P4625": "Museum of Fine Arts, Boston object ID"
    , "P4626": "identity of object in hierarchy"
    , "P4627": "EK number"
    , "P4628": "ICTV virus genome composition"
    , "P4629": "Online Books Page author ID"
    , "P4630": "DORIS ID"
    , "P4631": "Iowa Sports Hall of Fame ID"
    , "P4632": "Bechdel Test Movie List ID"
    , "P4633": "name of the character role"
    , "P4634": "premiere type"
    , "P4635": "Indian Financial System Code"
    , "P4636": "Sherpa Juliet ID"
    , "P4637": "FoodEx2 code"
    , "P4638": "The Peerage person ID"
    , "P4639": "Estonian Football Association team ID"
    , "P4640": "photosphere image"
    , "P4641": "Welsh Chapels ID"
    , "P4642": "Colorado Sports Hall of Fame ID"
    , "P4643": "Philadelphia Museum of Art work ID"
    , "P4644": "ESCO skill ID"
    , "P4645": "RCR number"
    , "P4646": "representation of"
    , "P4647": "location of first performance"
    , "P4649": "identity of subject in hierarchy"
    , "P4650": "BSD Portal athlete ID"
    , "P4651": "Welsh assembly ID"
    , "P4652": "ESCO Occupation ID"
    , "P4653": "partition table type"
    , "P4654": "partition type identifier"
    , "P4655": "Flathub ID"
    , "P4656": "Wikimedia import URL"
    , "P4657": "The Numbers person ID"
    , "P4658": "Coflein ID"
    , "P4659": "Mus\u00e9e d'Orsay artwork ID"
    , "P4660": "CPDOC ID"
    , "P4661": "reservoir created"
    , "P4662": "SAN archive conservator ID"
    , "P4663": "DACS ID"
    , "P4664": "Wiki Aves bird ID"
    , "P4665": "CineMagia film ID"
    , "P4666": "CineMagia person ID"
    , "P4667": "Buenos Aires legislator ID"
    , "P4668": "USA Gymnastics Hall of Fame athlete ID"
    , "P4669": "tabular software version"
    , "P4670": "Sjukv\u00e5rdsr\u00e5dgivningen Category ID"
    , "P4671": "Hall of Light ID"
    , "P4672": "EMLO location ID"
    , "P4673": "Museum of Fine Arts, Houston object ID"
    , "P4674": "Indianapolis Museum of Art artwork ID"
    , "P4675": "appears in the form of"
    , "P4676": "MAVISE TV channel ID"
    , "P4677": "MAVISE on-demand audiovisual service ID"
    , "P4678": "MAVISE competent authority ID"
    , "P4679": "MAVISE company ID"
    , "P4680": "constraint scope"
    , "P4681": "Eldoblaje dubbing actor ID"
    , "P4682": "Eldoblaje original actor ID"
    , "P4683": "National Gallery of Art artwork ID"
    , "P4684": "National Gallery of Victoria artwork ID"
    , "P4685": "Nintendo of America Game Store ID (former scheme)"
    , "P4686": "Carnegie Museum of Art ID"
    , "P4687": "Dictionnaire des peintres belges ID"
    , "P4688": "geomorphological unit"
    , "P4689": "Environmental Register code (Estonia)"
    , "P4690": "Oireachtas member ID"
    , "P4691": "OpenSecrets organization ID"
    , "P4692": "American Art Collaborative object ID"
    , "P4693": "Argentine deputy votations ID"
    , "P4694": "Arquivo Arq ID"
    , "P4695": "GEMS Code"
    , "P4696": "CIQUAL2017 ID"
    , "P4697": "Historic Place Names of Wales ID"
    , "P4698": "Conseil de Presse Luxembourg journalist ID"
    , "P4699": "Canal-U channel ID"
    , "P4700": "Cairn publication ID"
    , "P4701": "Google Arts & Culture asset ID"
    , "P4702": "Google Arts & Culture partner ID"
    , "P4703": "HATVP person ID"
    , "P4704": "Smithsonian American Art Museum ID"
    , "P4705": "World of Spectrum ID"
    , "P4706": "Ent'revues ID"
    , "P4707": "Rugby Canada ID"
    , "P4708": "VOGRIPA ID"
    , "P4709": "Barnes Foundation ID"
    , "P4710": "Guardiana ID"
    , "P4711": "CHGIS ID"
    , "P4712": "Minneapolis Institute of Art artwork ID"
    , "P4713": "Walters Art Museum ID"
    , "P4714": "title page number"
    , "P4715": "Guide to North American Birds ID"
    , "P4716": "Acad\u00e9mie des Inscriptions et Belles-Lettres member ID"
    , "P4717": "Acad\u00e9mie fran\u00e7aise member ID"
    , "P4718": "Basketball-Reference.com NBA coach ID"
    , "P4720": "Basketball-Reference.com WNBA coach ID"
    , "P4721": "MuBE Virtual ID"
    , "P4722": "\u00c9rudit journal ID"
    , "P4723": "GSMArena phone ID"
    , "P4724": "Maitron ID"
    , "P4725": "C-SPAN organization ID"
    , "P4726": "Sign@l journal ID"
    , "P4727": "Deutsche Synchronkartei dubbing voice actor ID"
    , "P4728": "uBio ID"
    , "P4729": "INRAN Italian Food ID"
    , "P4730": "Mir@bel journal ID"
    , "P4731": "The Baseball Cube player ID"
    , "P4732": "IUPAC Gold Book ID"
    , "P4733": "produced sound"
    , "P4734": "IBM code page ID"
    , "P4735": "IBM coded character set ID"
    , "P4736": "IBM graphic character global ID"
    , "P4737": "Solomon R. Guggenheim Foundation artwork ID"
    , "P4738": "Yale Center for British Art artwork ID"
    , "P4739": "Mus\u00e9e des Augustins artwork ID"
    , "P4740": "Brooklyn Museum artwork ID"
    , "P4741": "OpenEdition journal ID"
    , "P4742": "Uniform Resource Identifier Scheme"
    , "P4743": "animal breed"
    , "P4744": "Basketball-Reference.com NBA G League player ID"
    , "P4745": "is proceedings from"
    , "P4746": "Elhuyar ZTH ID"
    , "P4747": "Line Music artist ID"
    , "P4748": "Line Music album ID"
    , "P4749": "Dictionnaire des auteurs luxembourgeois ID"
    , "P4750": "National Historic Ships certificate number"
    , "P4751": "Sports-Reference.com college basketball coach ID"
    , "P4752": "Manus Online ID"
    , "P4753": "Ecocrop ID"
    , "P4754": "Harvard botanical journal ID"
    , "P4755": "UK railway station code"
    , "P4756": "V Live channel ID"
    , "P4757": "Songwriters Hall of Fame ID"
    , "P4758": "MONA ID"
    , "P4759": "Luminous-Lint ID"
    , "P4760": "LTI Korea Library ID"
    , "P4761": "Images d'Art artwork ID"
    , "P4762": "Common Database on Designated Areas ID"
    , "P4763": "crates.io ID"
    , "P4764": "Base Arcade artwork ID"
    , "P4765": "Commons compatible image available at URL"
    , "P4766": "Australian honours ID"
    , "P4768": "cinematografo.it name or company ID"
    , "P4769": "GameFAQs game ID"
    , "P4770": "is a hydrated form of"
    , "P4771": "compArt institution ID"
    , "P4772": "compArt person ID"
    , "P4773": "MobyGames company ID"
    , "P4774": "biological phase"
    , "P4775": "lot number"
    , "P4776": "MAC Address Block Large ID"
    , "P4777": "has boundary"
    , "P4778": "USA Rugby player ID"
    , "P4779": "MYmovies actor ID"
    , "P4780": "MYmovies movie ID"
    , "P4781": "MYmovies director ID"
    , "P4782": "Movieplayer person ID"
    , "P4783": "Movieplayer film ID"
    , "P4784": "Movieplayer TV-series ID"
    , "P4785": "MYmovies name ID"
    , "P4786": "cinematografo film ID"
    , "P4787": "CiNii author ID (articles)"
    , "P4788": "storage device"
    , "P4789": "Who's Who UK ID"
    , "P4790": "Basketball-Reference.com international player ID"
    , "P4791": "commanded by"
    , "P4792": "dam"
    , "P4793": "identifiers.org prefix"
    , "P4794": "season starts"
    , "P4795": "Basketball-Reference.com referee ID"
    , "P4796": "Basketball-Reference.com NBL player ID"
    , "P4797": "member of the Assembly of Madrid ID"
    , "P4798": "BTO Birds of Britain ID"
    , "P4799": "Rugby Australia ID"
    , "P4800": "EUAP ID"
    , "P4801": "LoC and MARC vocabularies ID"
    , "P4802": "BVPB authority ID"
    , "P4803": "Amtrak station code"
    , "P4804": "Compagnon de la Lib\u00e9ration ID"
    , "P4805": "make-up artist"
    , "P4806": "Gaming-History ID"
    , "P4807": "Fauna Europaea New ID"
    , "P4808": "Royal Academy new identifier"
    , "P4809": "sets environment variable"
    , "P4810": "reads environment variable"
    , "P4811": "BWSA ID"
    , "P4812": "Statistical Service of Cyprus Geocode"
    , "P4813": "PARES ID"
    , "P4814": "Inventories of American Painting and Sculpture control number"
    , "P4815": "Technical Element Score"
    , "P4816": "Lemon 64 identifier"
    , "P4818": "Panoptikum podcast ID"
    , "P4819": "Swedish Portrait Archive ID"
    , "P4820": "TORA ID"
    , "P4821": "Cour des comptes magistrate ID"
    , "P4822": "La Poste personality ID"
    , "P4823": "American National Biography ID"
    , "P4824": "org-id.guide ID"
    , "P4825": "deductions (in figure skating)"
    , "P4826": "Program Component Score"
    , "P4827": "Swimrankings.net meet ID"
    , "P4829": "Swiss Enterprise Identification Number"
    , "P4830": "Swedish Football Association national team player ID"
    , "P4831": "Bandysidan player ID"
    , "P4832": "World Sailing regatta ID"
    , "P4833": "Sailboatdata ID"
    , "P4834": "Deutsche Synchronkartei series ID"
    , "P4835": "TheTVDB.com ID"
    , "P4836": "Irish Rugby Football Union women's player ID"
    , "P4837": "has command line option"
    , "P4838": "CATO ID"
    , "P4839": "Wolfram Language entity code"
    , "P4840": "Directory of Czech publishers ID"
    , "P4841": "total fertility rate"
    , "P4842": "ASHRAE refrigerant number"
    , "P4843": "development of anatomical structure"
    , "P4844": "research intervention"
    , "P4845": "Bulbapedia article"
    , "P4846": "Lemon Amiga identifier"
    , "P4847": "CPC-Power ID"
    , "P4848": "Libraries.org ID"
    , "P4849": "International Numbering System number"
    , "P4850": "permitted food additive"
    , "P4851": "maximum food additive use level"
    , "P4852": "JECFA database ID"
    , "P4853": "JMPR database ID"
    , "P4854": "Uppslagsverket Finland ID"
    , "P4855": "Phasmida Species File ID"
    , "P4856": "conscription number"
    , "P4857": "AtariAge ID"
    , "P4858": "Atari Legend identifier"
    , "P4859": "Atarimania identifier"
    , "P4860": "BMI work ID"
    , "P4861": "Charity Navigator ID"
    , "P4862": "Amazon author ID"
    , "P4863": "recognition sequence"
    , "P4864": "cutting site of restriction enzyme"
    , "P4866": "REBASE Enzyme Number"
    , "P4867": "RFE symbol"
    , "P4868": "Hispania Nostra Red List code"
    , "P4869": "Operabase ID"
    , "P4870": "GEPRIS project ID"
    , "P4871": "GEPRIS organization ID"
    , "P4872": "GEPRIS person ID"
    , "P4873": "isoschizomer"
    , "P4875": "neoschizomer"
    , "P4876": "number of records"
    , "P4878": "symbolizes"
    , "P4879": "World Rugby Women's Sevens Series player ID"
    , "P4880": "FFR Sevens player ID"
    , "P4881": "Maison d'\u00e9crivain ID"
    , "P4882": "segmental innervation"
    , "P4883": "FFF male player ID"
    , "P4884": "court"
    , "P4885": "AFL Tables coach ID"
    , "P4886": "FFF female player ID"
    , "P4887": "Web umenia creator ID"
    , "P4888": "AFL Tables umpire ID"
    , "P4889": "MuIS person or group ID"
    , "P4890": "EPHE ID"
    , "P4891": "Patrons de France ID"
    , "P4892": "Siprojuris ID"
    , "P4893": "X Games athlete ID"
    , "P4894": "ACE Repertory work ID"
    , "P4895": "time index"
    , "P4896": "3D model"
    , "P4897": "AICTE institute application ID"
    , "P4898": "Chronicling America newspaper ID"
    , "P4899": "Brooklyn Museum Exhibition ID"
    , "P4900": "broader concept"
    , "P4901": "Zenodo ID"
    , "P4902": "CONABIO ID"
    , "P4903": "New Georgia Encyclopedia ID"
    , "P4904": "Tropicos publication ID"
    , "P4905": "KMSKA work PID"
    , "P4906": "Bargeton ID"
    , "P4907": "Guide Nicaise ID"
    , "P4908": "season"
    , "P4909": "number of players in region"
    , "P4910": "AlloCin\u00e9 company ID"
    , "P4911": "Annuaire des fondations ID"
    , "P4912": "century breaks"
    , "P4913": "dialect of"
    , "P4914": "produces cohesive end"
    , "P4915": "isocaudomer"
    , "P4916": "Ready64 ID"
    , "P4917": "Gamebase64 identifier"
    , "P4919": "Plus/4 World ID"
    , "P4920": "Rugby Football Union men's player ID"
    , "P4921": "Snooker.org tournament ID"
    , "P4922": "Rugby Football Union women's sevens player ID"
    , "P4923": "Rugby Football Union men's sevens player ID"
    , "P4924": "CueTracker tournament ID"
    , "P4925": "Rugby Football Union women's player ID"
    , "P4926": "PRotein Ontology ID"
    , "P4927": "Invaluable.com person ID"
    , "P4928": "Ricorso author ID"
    , "P4929": "AINM ID"
    , "P4930": "Julien ID"
    , "P4931": "Todotango.com person ID"
    , "P4932": "Todotango.com work ID"
    , "P4933": "Big Cartoon Database ID"
    , "P4934": "calculated from"
    , "P4935": "Small Monuments of Plze\u0148 Catalogue ID"
    , "P4936": "SFMOMA artist ID"
    , "P4937": "Japan Rugby Football Union men's player ID"
    , "P4938": "Japan Rugby Football Union women's player ID"
    , "P4939": "BFMTV.com director ID"
    , "P4940": "Japan Rugby Football Union women's sevens player ID"
    , "P4941": "Japan Rugby Football Union men's sevens player ID"
    , "P4942": "Societe.com director ID"
    , "P4943": "Dominicains ID"
    , "P4944": "Premiers pr\u00e9fets ID"
    , "P4945": "download link"
    , "P4946": "Library of Congress Demographic Group Terms ID"
    , "P4947": "TMDb movie ID"
    , "P4948": "DDB ID"
    , "P4949": "Irish Rugby Football Union men's sevens player ID"
    , "P4950": "Irish Rugby Football Union women's sevens player ID"
    , "P4951": "INCI name"
    , "P4952": "safety classification and labelling"
    , "P4953": "Library of Congress Genre/Form Terms ID"
    , "P4954": "may prevent"
    , "P4955": "MR Author ID"
    , "P4956": "BDH edition ID"
    , "P4957": "AIDA freediver ID"
    , "P4958": "classification of the best at metas volantes"
    , "P4959": "paris.fr equipment ID"
    , "P4960": "Generation MSX identifier"
    , "P4961": "Sega8bit.com identifier"
    , "P4962": "Abandonia identifier"
    , "P4963": "Svenskt kvinnobiografiskt lexikon ID"
    , "P4964": "SPLASH"
    , "P4965": "Behind The Voice Actors video game ID"
    , "P4966": "Hungarian National Assembly identifier"
    , "P4967": "prerequisite"
    , "P4968": "relevant qualification"
    , "P4969": "derivative work"
    , "P4970": "alternate names"
    , "P4971": "UK Provider Reference Number"
    , "P4972": "Norwegian war sailor register person ID"
    , "P4973": "Wikitribune category"
    , "P4974": "Scottish Rugby Union men's player ID"
    , "P4975": "Scottish Rugby Union men's sevens player ID"
    , "P4976": "Scottish Rugby Union women's player ID"
    , "P4977": "IDA place ID"
    , "P4978": "PRS Legislative Research MP ID"
    , "P4979": "Th\u00e9saurus de la d\u00e9signation des objets mobiliers ID"
    , "P4980": "Th\u00e9saurus de la d\u00e9signation des \u0153uvres architecturales et des espaces "
               "am\u00e9nag\u00e9s ID"
    , "P4981": "Kinoliste ID"
    , "P4982": "Women\u2019s Elite Rugby ID"
    , "P4983": "TMDb TV series ID"
    , "P4985": "TMDb person ID"
    , "P4986": "Routard.com place ID"
    , "P4987": "Scottish Rugby Union women's sevens player ID"
    , "P4988": "test method"
    , "P4989": "RKDlibrary ID"
    , "P4991": "Biographical Dictionary of Georgia ID"
    , "P4992": "DBA ID"
    , "P4993": "Hungarian public body ID"
    , "P4994": "ruchess ID"
    , "P4996": "World Para Snowboard athlete ID"
    , "P4997": "National Governors Association biography URL"
    , "P4998": "key press"
    , "P4999": "number of clubs"
    , "P5001": "METAR code"
    , "P5002": "Orthodox Encyclopedia ID"
    , "P5003": "Amphibians of India ID"
    , "P5004": "in opposition to"
    , "P5005": "National Thesis Number (France)"
    , "P5006": "DNV GL Vessel register ID"
    , "P5007": "Behind The Voice Actors person ID"
    , "P5008": "on focus list of Wikimedia project"
    , "P5009": "complies with"
    , "P5010": "Territographie ID"
    , "P5011": "Prazdne Domy building ID"
    , "P5012": "special rank"
    , "P5013": "Welsh Rugby Union women's player ID"
    , "P5014": "Welsh Rugby Union men's sevens player ID"
    , "P5015": "Digital Typhoon typhoon ID"
    , "P5016": "Digital Typhoon cyclone ID"
    , "P5017": "last update"
    , "P5018": "Chile Rugby player ID"
    , "P5019": "Brockhaus Enzyklop\u00e4die online ID"
    , "P5020": "Code of Household Registration and Conscription Information System (Taiwan)"
    , "P5021": "test taken"
    , "P5022": "test score"
    , "P5023": "activity policy in this place"
    , "P5024": "choral conductor"
    , "P5025": "gens"
    , "P5026": "lighting designer"
    , "P5027": "number of representations"
    , "P5028": "sound designer"
    , "P5029": "Researchmap ID"
    , "P5030": "talk show guest"
    , "P5031": "Animated Knots ID"
    , "P5032": "Filmweb.pl film ID"
    , "P5033": "Filmweb.pl person ID"
    , "P5034": "National Library of Korea ID"
    , "P5035": "Lambiek Comiclopedia artist ID"
    , "P5036": "AmphibiaWeb Species ID"
    , "P5037": "Plants of the World online ID"
    , "P5038": "Fogis.se player ID"
    , "P5039": "Authorea author ID"
    , "P5040": "GHS hazard pictogram"
    , "P5041": "GHS hazard statement"
    , "P5042": "GHS precautionary statement"
    , "P5043": "number of abstentions"
    , "P5044": "number of spoilt votes"
    , "P5045": "number of blank votes"
    , "P5046": "International Classification for Standards"
    , "P5047": "Rosetta Code ID"
    , "P5048": "Church of Sweden ID"
    , "P5049": "Harvard designation"
    , "P5050": "UMAC ID"
    , "P5051": "towards"
    , "P5052": "supervisory board member"
    , "P5053": "fastest lap"
    , "P5054": "cabinet"
    , "P5055": "IRMNG ID"
    , "P5056": "patronym or matronym for this person"
    , "P5057": "Handball-Bundesliga player ID"
    , "P5058": "e-teatr.pl person ID"
    , "P5059": "modified version of"
    , "P5061": "unit symbol"
    , "P5062": "DOAB publisher ID"
    , "P5063": "ILI ID"
    , "P5064": "World of Physics identifier"
    , "P5065": "wind speed"
    , "P5066": "operating temperature"
    , "P5067": "non-operating temperature"
    , "P5068": "Flanders Arts Institute person ID"
    , "P5069": "service life"
    , "P5070": "French standard size for oil paintings"
    , "P5071": "boiler pressure"
    , "P5072": "presented in"
    , "P5073": "JAAF athlete ID"
    , "P5075": "Polish Athletics Federation ID"
    , "P5076": "R\u00f6mpp online ID"
    , "P5077": "Russian Athletics ID"
    , "P5078": "Athletics Canada ID"
    , "P5079": "NVE Lake Database ID"
    , "P5080": "Norsk biografisk leksikon ID"
    , "P5081": "Norsk kunstnerleksikon ID"
    , "P5082": "Store medisinske leksikon ID"
    , "P5083": "Adult Film Database film ID"
    , "P5084": "Yahoo Answers category"
    , "P5085": "Pschyrembel Online ID"
    , "P5086": "FIPS 5-2 alpha code (US states)"
    , "P5087": "FIPS 5-2 numeric code (US states)"
    , "P5088": "Internet Encyclopedia of Philosophy ID"
    , "P5090": "ARRS race ID"
    , "P5091": "HanCinema drama ID"
    , "P5092": "ISC event ID"
    , "P5093": "road number (Estonia)"
    , "P5094": "HPIP ID"
    , "P5095": "fault"
    , "P5096": "member of the crew of"
    , "P5097": "Logainm ID"
    , "P5098": "IAFD film ID"
    , "P5099": "Il mondo dei doppiatori ID"
    , "P5101": "Swedish Literature Bank AuthorID"
    , "P5102": "nature of statement"
    , "P5103": "FIS speed skier ID"
    , "P5104": "New Zealand Gazetteer place ID"
    , "P5105": "Deutsche Bahn station category"
    , "P5106": "Dictionary of Algorithms and Data Structures ID"
    , "P5107": "Behind The Voice Actors character ID"
    , "P5108": "HanCinema film ID"
    , "P5109": "has grammatical gender"
    , "P5110": "has grammatical person"
    , "P5114": "Italian School ID"
    , "P5115": "Directory of Open Access Journals ID"
    , "P5116": "LGDB game ID"
    , "P5117": "LGDB emulator ID"
    , "P5118": "LGDB tool ID"
    , "P5119": "LGDB engine ID"
    , "P5120": "TFRRS athlete ID"
    , "P5121": "All About Jazz musician ID"
    , "P5122": "Ontario public library ID"
    , "P5123": "Swedish Literature Bank edition"
    , "P5124": "WikiCFP event ID"
    , "P5125": "Wikimedia outline"
    , "P5126": "assistant director"
    , "P5127": "WikiCFP conference series ID"
    , "P5128": "ICAA film catalogue ID"
    , "P5129": "Stepwell Atlas ID"
    , "P5131": "possible medical findings"
    , "P5132": "suggests the existence of"
    , "P5133": "has evaluation"
    , "P5134": "evaluation of"
    , "P5135": "greater than"
    , "P5136": "less than"
    , "P5137": "item for this sense"
    , "P5138": "season of club or team"
    , "P5139": "M\u00f6llendorff transliteration"
    , "P5140": "coordinates of geographic center"
    , "P5141": "coastline"
    , "P5142": "Chinese Political Elites Database ID"
    , "P5143": "amateur radio callsign"
    , "P5144": "Bugs! album ID"
    , "P5145": "Bugs! artist ID"
    , "P5146": "Cinema Project (Israel) ID"
    , "P5147": "Dictionary of Swedish Translators ID"
    , "P5148": "e-MEC entry"
    , "P5149": "Ester ID"
    , "P5150": "IGAC rating"
    , "P5151": "Israel Film Fund ID"
    , "P5152": "KAVI rating"
    , "P5153": "KKBox album ID"
    , "P5154": "KKBox artist ID"
    , "P5156": "Norwegian war sailor register ship-ID"
    , "P5157": "OnsOranje match ID"
    , "P5158": "OnsOranje player ID"
    , "P5159": "The New Fund for Cinema and Television (Israel) ID"
    , "P5160": "Thesaurus For Graphic Materials ID"
    , "P5161": "Trustpilot company ID"
    , "P5162": "OnsOranje tournament ID"
    , "P5163": "Odnoklassniki ID"
    , "P5164": "Flanders Arts Institute organisation ID"
    , "P5165": "Norsk pop- og rockleksikon ID"
    , "P5166": "established from medical condition"
    , "P5167": "vehicles per thousand people"
    , "P5168": "applies to name of item"
    , "P5169": "Norwegian historical lexicon ID"
    , "P5170": "Norwegian fjord catalog ID"
    , "P5171": "Rockipedia album ID"
    , "P5172": "Rockipedia artist ID"
    , "P5173": "Rockipedia area ID"
    , "P5174": "Rockipedia label ID"
    , "P5175": "Univ-droit jurist ID"
    , "P5176": "KIT Linked Open Numbers ID"
    , "P5177": "Victorian Heritage Register ID"
    , "P5178": "glossary entry at Wikipedia"
    , "P5179": "FloraCatalana ID"
    , "P5180": "CIVICUS Monitor country entry"
    , "P5181": "Relationship Science organization ID"
    , "P5182": "JMA Seismic Intensity Database ID"
    , "P5183": "Eurohockey.com club ID"
    , "P5184": "Daum Encyclopedia ID"
    , "P5185": "grammatical gender"
    , "P5186": "conjugation class"
    , "P5187": "word stem"
    , "P5188": "Sandbox-Lexeme"
    , "P5189": "Sandbox-Form"
    , "P5191": "derived from"
    , "P5192": "Wikidata property example for lexemes"
    , "P5193": "Wikidata property example for forms"
    , "P5194": "officialized by"
    , "P5195": "Wikidata Dataset Imports page"
    , "P5196": "output method"
    , "P5197": "Melon song ID"
    , "P5198": "ASC Leiden Thesaurus ID"
    , "P5199": "British Library system number"
    , "P5200": "eBird hotspot ID"
    , "P5201": "IMDA rating"
    , "P5202": "adapted by"
    , "P5203": "topographic map"
    , "P5204": "date of commercialization"
    , "P5205": "stroke count"
    , "P5206": "has conjugation class"
    , "P5207": "BAG public space ID"
    , "P5208": "BAG building ID"
    , "P5209": "ISO 3950 code"
    , "P5210": "National Gallery of Armenia work ID"
    , "P5211": "GONIAT author ID"
    , "P5212": "Armenian National Academy of Sciences ID"
    , "P5213": "Armenian Parliamentary ID"
    , "P5214": "GONIAT paper ID"
    , "P5215": "GONIAT place ID"
    , "P5216": "GONIAT taxon ID"
    , "P5217": "Spyur ID"
    , "P5218": "Armenian Cinema ID"
    , "P5219": "BMRB ID"
    , "P5220": "ICSC ID"
    , "P5221": "Tree of Life Web Project ID"
    , "P5222": "National Women's Soccer League player ID"
    , "P5223": "Information Center for Israeli Art artwork ID"
    , "P5224": "OlimpBase Women's Chess Olympiad player ID"
    , "P5225": "Argentine biography deputy ID"
    , "P5226": "BRAHMS artist ID"
    , "P5227": "Carnegie Hall event ID"
    , "P5229": "Carnegie Hall work ID"
    , "P5230": "chromosome count"
    , "P5231": "Chromosome numbers of the Flora of Germany database ID"
    , "P5232": "D&B Hoovers company profile"
    , "P5233": "Filmow ID"
    , "P5234": "SpectraBase compound ID"
    , "P5235": "Cit\u00e9 de la Musique-Philharmonie de Paris work ID"
    , "P5236": "prime factor"
    , "P5237": "pronunciation variety"
    , "P5238": "combines"
    , "P5239": "Artists in Canada record number"
    , "P5240": "RollDaBeats artist ID"
    , "P5241": "Songfacts song ID"
    , "P5242": "ARWU university ID"
    , "P5243": "Canal-U person ID"
    , "P5244": "reading pattern of Han character"
    , "P5245": "myschool ID"
    , "P5246": "Pornhub ID"
    , "P5247": "Giant Bomb ID"
    , "P5248": "medical evacuation to"
    , "P5249": "sports competition competed at"
    , "P5250": "IAB code"
    , "P5251": "Corago opera ID"
    , "P5252": "winter view"
    , "P5253": "FilmTv.it movie ID"
    , "P5254": "FilmTv.it person ID"
    , "P5255": "FilmTv.it TV series ID"
    , "P5256": "OpenCorporates corporate grouping"
    , "P5257": "BirdLife taxon ID"
    , "P5258": "Czech Geomorphological Unit Code"
    , "P5259": "Swedish Gravestone ID"
    , "P5260": "Apple App Store developer ID"
    , "P5261": "Les Enfoir\u00e9s participant ID"
    , "P5262": "Les Enfoir\u00e9s song ID"
    , "P5263": "Czech NDOP taxon ID"
    , "P5264": "Relationship Science person ID"
    , "P5265": "Dordrechts Museum artwork ID"
    , "P5266": "Finnish national bibliography corporate name ID"
    , "P5267": "YouPorn ID"
    , "P5268": "MNAV work ID"
    , "P5269": "Web umenia work ID"
    , "P5270": "MonDO ID"
    , "P5271": "Saint Louis Art Museum person ID"
    , "P5272": "CDMC musician ID"
    , "P5273": "Nelson-Atkins Museum of Art person ID"
    , "P5274": "SJP Online ID"
    , "P5275": "OED Online ID"
    , "P5276": "Slavic phonetic alphabet"
    , "P5277": "grade of kanji"
    , "P5278": "gender inflection of surname"
    , "P5279": "hyphenation"
    , "P5280": "radical"
    , "P5281": "residual stroke count"
    , "P5282": "ground level 360 degree view"
    , "P5283": "Strava ID of a professional sport person"
    , "P5284": "Douban movie celebrity ID"
    , "P5285": "Firmenbuchnummer"
    , "P5286": "Portable Game Notation"
    , "P5287": "Songfacts artist ID"
    , "P5288": "StadiumDB identifier"
    , "P5289": "World Stadium Database identifier"
    , "P5290": "Redump.org ID"
    , "P5291": "Taratata artist ID"
    , "P5292": "NRJ artist ID"
    , "P5293": "Akout ID"
    , "P5294": "Church of Norway building ID"
    , "P5295": "Lafonoteca artist ID"
    , "P5296": "Party Number (Taiwan)"
    , "P5297": "Companies House officer ID"
    , "P5298": "Webb-site person ID"
    , "P5299": "AntWeb ID"
    , "P5300": "Webb-site organization ID"
    , "P5301": "France Culture person ID"
    , "P5302": "BRAHMS work ID"
    , "P5303": "DLCM ID"
    , "P5304": "type locality (biology)"
    , "P5305": "SPARQL endpoint"
    , "P5306": "LONSEA ID"
    , "P5307": "display technology"
    , "P5308": "Dictionary of Scottish Architects ID"
    , "P5309": "Drouot artist ID"
    , "P5310": "Protected Buildings Register in Finland ID"
    , "P5311": "Kino-teatr.ua film ID"
    , "P5312": "Kino-teatr.ua person ID"
    , "P5313": "Protected Buildings Register in Finland Building ID"
    , "P5314": "property scope"
    , "P5315": "BioStor work ID"
    , "P5316": "Swedish Signaturer.se ID"
    , "P5317": "jockey"
    , "P5318": "C\u00e9sar Award film ID"
    , "P5319": "C\u00e9sar Award person ID"
    , "P5320": "IUF member ID"
    , "P5321": "Museo del Prado artist ID"
    , "P5323": "attested in"
    , "P5324": "Swedish National Archive ID"
    , "P5325": "Swedish Academy member ID"
    , "P5326": "publication in which this taxon name was established"
    , "P5327": "fernsehserien.de ID"
    , "P5328": "revival or touring version of"
    , "P5329": "ARMB member ID"
    , "P5330": "United Kingdom Department for Transport railway station category"
    , "P5331": "OCLC work ID"
    , "P5332": "OpenDOAR ID"
    , "P5333": "B\u00e9rose ID"
    , "P5334": "Rom Galil settlement ID"
    , "P5335": "Or Movement settlement ID"
    , "P5336": "Or Movement regional council ID"
    , "P5337": "Google News topics ID"
    , "P5338": "SilentEra.com film ID"
    , "P5339": "Lega Serie A soccer player ID"
    , "P5340": "American Film Institute person ID"
    , "P5341": "Poetry Foundation ID"
    , "P5343": "Poets.org poet ID"
    , "P5344": "Printemps des po\u00e8tes poet ID"
    , "P5345": "PC Engine Software Bible ID"
    , "P5346": "Playmates Playmate ID"
    , "P5348": "angular diameter"
    , "P5349": "laps completed"
    , "P5350": "Alexander polynomial"
    , "P5351": "Conway polynomial"
    , "P5352": "Jones polynomial"
    , "P5353": "school district"
    , "P5354": "Amphibian Species of the World ID"
    , "P5355": "abgeordnetenwatch.de politician ID"
    , "P5356": "Laut.de artist ID"
    , "P5357": "The Encyclopedia of Science Fiction ID"
    , "P5358": "Operone opera ID"
    , "P5359": "Operone composer ID"
    , "P5360": "MobyGames group ID"
    , "P5361": "BNB person ID"
    , "P5362": "ASMP member ID"
    , "P5363": "Acad\u00e9mie des beaux-arts member ID"
    , "P5364": "British Council writer ID"
    , "P5365": "Internet Book Database of Fiction writer ID"
    , "P5366": "Operissimo artist ID"
    , "P5368": "National Gallery of Canada artist ID"
    , "P5369": "Encyclop\u00e6dia Universalis author ID"
    , "P5370": "Entomologists of the World ID"
    , "P5371": "GAMECIP media format ID"
    , "P5372": "Dictionnaire critique des historiens de l'art ID"
    , "P5373": "\u00c9cole normale alumnus ID"
    , "P5374": "Acad\u00e9mie des sciences d'outre-mer member ID"
    , "P5375": "BIU Sant\u00e9 person ID"
    , "P5376": "Medicina author ID"
    , "P5377": "\u00c9tonnants voyageurs participant ID"
    , "P5378": "Akadem person ID"
    , "P5379": "GAMECIP platform ID"
    , "P5380": "National Academy of Sciences member ID"
    , "P5381": "EGROKN ID"
    , "P5382": "Behind The Voice Actors franchise ID"
    , "P5383": "archINFORM project ID"
    , "P5384": "Behind The Voice Actors film ID"
    , "P5385": "IGN game ID"
    , "P5386": "JMA Seismic Intensity Scale"
    , "P5387": "Behind The Voice Actors TV show ID"
    , "P5388": "Bulgarian Antarctic Gazetteer ID"
    , "P5389": "permanent resident of"
    , "P5390": "Classiques des sciences sociales ID"
    , "P5391": "Norwegian Polar Institute place name ID"
    , "P5392": "Poetry Archive poet ID"
    , "P5393": "cipM poet ID"
    , "P5394": "Poets & Writers author ID"
    , "P5395": "Canadian Encyclopedia article ID"
    , "P5396": "Online Books Page publication ID"
    , "P5397": "Tierstimmenarchiv ID"
    , "P5398": "TDKIV term ID"
    , "P5400": "GeoNLP ID"
    , "P5401": "auxiliary verb"
    , "P5402": "homograph lexeme"
    , "P5403": "CNAP artist ID"
    , "P5404": "Rate Your Music artist ID"
    , "P5406": "Rendez-vous de l'histoire ID"
    , "P5407": "MHK object ID"
    , "P5408": "Fantastic Fiction author ID"
    , "P5409": "\u00cele en \u00eele author ID"
    , "P5410": "Flanders Music Centre person ID"
    , "P5411": "CeBeDem composer ID"
    , "P5412": "romanization of Belarusian (2007 system)"
    , "P5413": "Ricochet author ID"
    , "P5414": "The Paris Review interviewee ID"
    , "P5415": "Whonamedit? doctor ID"
    , "P5417": "Common Procurement Vocabulary"
    , "P5418": "Pasteur Institute person ID"
    , "P5419": "NYRB contributor ID"
    , "P5420": "GS1 Global Product Classification brick code"
    , "P5421": "Trading Card Database person ID"
    , "P5422": "has decorative pattern"
    , "P5423": "floor number"
    , "P5424": "Lega Serie A team ID"
    , "P5425": "Han character in this lexeme"
    , "P5426": "Japanese pitch accent type"
    , "P5427": "position of accent nucleus"
    , "P5428": "position of devoiced vowel"
    , "P5429": "IPTC NewsCode"
    , "P5430": "Poetry International Web poet ID"
    , "P5431": "setlist.fm artist ID"
    , "P5432": "setlist.fm venue ID"
    , "P5434": "Gfycat user ID"
    , "P5435": "pixiv user ID"
    , "P5436": "number of viewers/listeners"
    , "P5437": "EuroVoc ID"
    , "P5438": "signum"
    , "P5439": "research measurement"
    , "P5440": "Elysee.fr president ID"
    , "P5441": "Encyclopaedia Herder author ID"
    , "P5442": "Library of Congress of Chile person ID"
    , "P5443": "Coll\u00e8ge de France professor ID"
    , "P5444": "model year"
    , "P5445": "Language Council of Norways termwiki ID"
    , "P5446": "reference value"
    , "P5447": "lower limit"
    , "P5448": "upper limit"
    , "P5449": "Inventory of French sanctuaries ID"
    , "P5450": "BIA PSY person ID"
    , "P5451": "House of Representatives of Morocco ID"
    , "P5452": "MyHeritage Surname ID"
    , "P5453": "Logicielsmoto identifier"
    , "P5454": "USNPL ID"
    , "P5455": "SGJP Online ID"
    , "P5456": "TasteAtlas ID"
    , "P5457": "Conseil constitutionnel ID"
    , "P5458": "Guide to Pharmacology Target ID"
    , "P5459": "RHE doctor ID"
    , "P5460": "grants"
    , "P5461": "model year code"
    , "P5462": "RHE professor ID"
    , "P5463": "AE member ID"
    , "P5464": "A Church Near You church ID"
    , "P5465": "Australian Poetry Library poet ID"
    , "P5466": "French Academy in Rome resident ID"
    , "P5467": "GlyphWiki ID"
    , "P5468": "Historia de la Medicina person ID"
    , "P5469": "Mormon Literature and Creative Arts Database artist ID"
    , "P5470": "Scottish Poetry Library poet ID"
    , "P5471": "Harmonized System Code"
    , "P5473": "The Reptile Database ID"
    , "P5474": "section number"
    , "P5475": "CJKV variant character"
    , "P5476": "LegaBasket.it player ID"
    , "P5477": "Les Voix de la po\u00e9sie poet ID"
    , "P5478": "RPO poet ID"
    , "P5479": "ultimate tensile strength"
    , "P5480": "tensile modulus of elasticity"
    , "P5481": "position of nasal sonant"
    , "P5483": "hardness"
    , "P5485": "SBN books ID"
    , "P5488": "artist-info curator ID"
    , "P5489": "artist-info artist ID"
    , "P5490": "artist-info location ID"
    , "P5491": "BD Gest' author ID"
    , "P5492": "EDIT16 catalogue author ID"
    , "P5493": "EDIT16 catalogue printer ID"
    , "P5494": "GameSpot ID"
    , "P5495": "Mormon Literature and Creative Arts Database Works ID"
    , "P5496": "M\u00e9dicos hist\u00f3ricos doctor ID"
    , "P5497": "Doroszewski Online ID"
    , "P5498": "Base de datos de premiados person ID"
    , "P5499": "Boijmans work ID"
    , "P5500": "IPHAN ID"
    , "P5501": "Brenda Tissue Ontology ID"
    , "P5502": "LRB contributor ID"
    , "P5503": "Poetry Society of America poet ID"
    , "P5504": "RISM ID"
    , "P5505": "WorldCat Registry ID"
    , "P5506": "Poetry In Voice poet ID"
    , "P5507": "artist-info exhibition ID"
    , "P5508": "archINFORM person or group ID"
    , "P5509": "MAPS poet ID"
    , "P5510": "DEFA film database ID"
    , "P5513": "Enciclop\u00e8dia de l'Esport Catal\u00e0 ID"
    , "P5514": "accredited by"
    , "P5515": "Znicenekostely ID"
    , "P5516": "Virtual Laboratory person ID"
    , "P5517": "Auvergne-Rh\u00f4ne-Alpes Regional Inventory identifier"
    , "P5518": "four-corner method"
    , "P5519": "Cangjie input"
    , "P5520": "toughness"
    , "P5522": "Unicode block"
    , "P5523": "fanqie"
    , "P5524": "horizontal depth"
    , "P5525": "CONDEPHAAT ID"
    , "P5526": "valency"
    , "P5527": "Academia Brasileira de Letras ID"
    , "P5528": "Belgian Heritage in Brazil ID"
    , "P5529": "yield strength"
    , "P5530": "Altmetric ID"
    , "P5531": "Central Index Key"
    , "P5532": "L'\u00eele author ID"
    , "P5533": "Kopali\u0144ski Online ID"
    , "P5534": "Open Media Database person ID"
    , "P5535": "Prison History ID"
    , "P5536": "Swedish place name register SOFI"
    , "P5537": "Hangul of a Chinese character"
    , "P5538": "Auteurs en Auvergne-Rh\u00f4ne-Alpes ID"
    , "P5539": "Eulalie ID"
    , "P5540": "RedTube ID"
    , "P5541": "Paris Faculty of Science professor ID"
    , "P5542": "Literature Ireland ID"
    , "P5543": "Livre et lecture en Bretagne ID"
    , "P5544": "Paris Faculty of Letters professor ID (1909-1939)"
    , "P5545": "Paris Faculty of Letters professor ID (1809\u20131908)"
    , "P5546": "College de France professor ID (1909-1939)"
    , "P5547": "CICLIC author ID"
    , "P5548": "derived from form"
    , "P5549": "INEPAC ID"
    , "P5550": "La Vie des id\u00e9es ID"
    , "P5551": "Courrier international topic ID"
    , "P5552": "CNRS talents page"
    , "P5553": "IDIH ID"
    , "P5554": "Courrier international source ID"
    , "P5555": "schematic"
    , "P5556": "KLEKs ID"
    , "P5557": "Interbibly author ID"
    , "P5558": "Le Monde ID"
    , "P5559": "MUSE journal ID"
    , "P5560": "passive voice"
    , "P5561": "Institut culturel de Bretagne ID"
    , "P5562": "Tebeosfera ID"
    , "P5563": "CSDE Lynching Database ID"
    , "P5564": "registration district"
    , "P5565": "CRAN project"
    , "P5566": "RubyGems gem"
    , "P5567": "National Research Institute for Cultural Properties artist ID"
    , "P5568": "Python Package Index project"
    , "P5569": "Tebeosfera character ID"
    , "P5570": "NooSFere author ID"
    , "P5571": "NooSFere book ID"
    , "P5572": "expressed in"
    , "P5573": "archINFORM location ID"
    , "P5574": "CAGE code"
    , "P5575": "coefficient of friction"
    , "P5576": "EDb company ID"
    , "P5578": "Indian census area code (2011)"
    , "P5579": "flight-report.com Airline identifier"
    , "P5580": "Norwegian National Road DataBase ID"
    , "P5581": "NATO Stock Number"
    , "P5582": "number of arrests"
    , "P5584": "QS World University ID"
    , "P5585": "SMS Power identifier"
    , "P5586": "Times Higher Education World University ID"
    , "P5587": "Libris-URI"
    , "P5588": "invasive to"
    , "P5589": "microstructure"
    , "P5590": "oric.org identifier"
    , "P5591": "normalized Unicode character"
    , "P5592": "number of works accessible online"
    , "P5593": "Poisson's ratio"
    , "P5594": "moisture absorption"
    , "P5595": "number of platform faces"
    , "P5596": "relative humidity"
    , "P5597": "Artcyclopedia artist ID"
    , "P5598": "Places of Worship Inventory ID"
    , "P5599": "Inventory of Quebec's Places of Worship ID"
    , "P5600": "U-Multirank university ID"
    , "P5601": "TCI destination ID"
    , "P5602": "Chercheurs d'Asie ID"
    , "P5603": "Trove newspaper ID"
    , "P5604": "archINFORM keyword ID"
    , "P5605": "DOLF ID"
    , "P5606": "station class"
    , "P5607": "located in the ecclesiastical territorial entity"
    , "P5608": "fatigue limit"
    , "P5609": "Split This Rock poet ID"
    , "P5610": "OpenMath ID"
    , "P5611": "BeWeb church ID"
    , "P5612": "LegaBasket.it coach ID"
    , "P5613": "Biblioth\u00e8que de la Pl\u00e9iade ID"
    , "P5614": "Aosd\u00e1na ID"
    , "P5615": "CNT ID"
    , "P5616": "Com\u00e9die-Fran\u00e7aise ID"
    , "P5617": "Evene ID"
    , "P5618": "LOA ID"
    , "P5619": "FFF author ID"
    , "P5620": "FFF character ID"
    , "P5621": "Marvel character ID"
    , "P5622": "National Cartoonists Society member ID"
    , "P5623": "type of water supply"
    , "P5624": "pitting resistance equivalent number"
    , "P5625": "Vietnamese reading"
    , "P5626": "Global Invasive Species Database ID"
    , "P5627": "WSO Online ID"
    , "P5628": "Football.it female player ID"
    , "P5629": "Brasseur ID"
    , "P5630": "prisoner count"
    , "P5631": "Canal Acad\u00e9mie ID"
    , "P5632": "Persons of Indian Studies ID"
    , "P5633": "Amphi-Theatrum ID"
    , "P5634": "Theatrum ID"
    , "P5635": "ANZL writer ID"
    , "P5636": "Black Ferns player ID"
    , "P5637": "CNL author ID"
    , "P5638": "IEEE standard"
    , "P5639": "LARB contributor ID"
    , "P5640": "Read NZ Te Pou Muramura writer ID"
    , "P5641": "PRELIB person ID"
    , "P5642": "risk factor"
    , "P5643": "RSL author ID"
    , "P5644": "World Rugby Women's World Cup player ID"
    , "P5645": "Acad\u00e9mie fran\u00e7aise award winner ID"
    , "P5646": "AniDB anime ID"
    , "P5647": "Baidu ScholarID"
    , "P5648": "AniDB character ID"
    , "P5649": "AniDB person ID"
    , "P5650": "Exoplanet Data Explorer exoplanet ID"
    , "P5651": "Expedia hotel ID"
    , "P5652": "Carthalia ID"
    , "P5653": "Extrasolar Planets Encyclopaedia exoplanet ID"
    , "P5654": "France Musique person ID"
    , "P5655": "iTunes music video ID"
    , "P5656": "MuIS collection ID"
    , "P5657": "National Humanities Medal winner ID"
    , "P5658": "railway traffic side"
    , "P5659": "VGMdb product ID"
    , "P5661": "Acad\u00e9mie de Montpellier member ID"
    , "P5662": "Acad\u00e9mie de M\u00e2con member ID"
    , "P5663": "Acad\u00e9mie de Versailles member ID"
    , "P5664": "Savoirs ENS ID"
    , "P5665": "Cartooning for Peace cartoonist ID"
    , "P5666": "Quais du polar writer ID"
    , "P5667": "NASA Exoplanet Archive exoplanet ID"
    , "P5668": "bulk modulus"
    , "P5669": "compressive strength"
    , "P5670": "glass transition temperature"
    , "P5672": "linear thermal expansion coefficient"
    , "P5673": "shear modulus"
    , "P5674": "thermal diffusivity"
    , "P5675": "relative permittivity"
    , "P5676": "relative permeability"
    , "P5677": "flexural strength"
    , "P5678": "dissipation factor"
    , "P5679": "electrical resistivity"
    , "P5680": "Hoopla title ID"
    , "P5681": "flexural modulus"
    , "P5682": "heat deflection temperature"
    , "P5683": "iNaturalist observation ID"
    , "P5685": "tear resistance"
    , "P5686": "ITU-R Recommendation"
    , "P5687": "New Zealand Business Number"
    , "P5688": "ITU-T Recommendation"
    , "P5690": "Saskatchewan Sports Hall of Fame ID"
    , "P5691": "BND ID"
    , "P5692": "dummy value"
    , "P5693": "Fandango film ID"
    , "P5694": "Moroccan cultural heritage ID"
    , "P5695": "Bibliopoche author ID"
    , "P5696": "Indian Railways station code"
    , "P5698": "Invasive Species Compendium Datasheet ID"
    , "P5699": "Transport Canada LID"
    , "P5700": "La Lorraine des \u00e9crivains writer ID"
    , "P5703": "airline accounting code"
    , "P5704": "Tasmanian Heritage Register ID"
    , "P5705": "Los Angeles Review of Books author ID"
    , "P5706": "shear strength"
    , "P5707": "samples from work"
    , "P5708": "force"
    , "P5709": "abrasion resistance"
    , "P5710": "Recours au po\u00e8me ID"
    , "P5711": "Revues Litt\u00e9raires ID"
    , "P5712": "IMEC ID"
    , "P5713": "requires grammatical feature"
    , "P5714": "Tor.com author ID"
    , "P5715": "Academia.edu profile URL"
    , "P5716": "2006 Commonwealth Games athlete ID"
    , "P5717": "TPA person ID"
    , "P5718": "PAM ID"
    , "P5719": "National Medal of Arts winner ID"
    , "P5720": "WSJP ID"
    , "P5721": "Turkish Basketball Super League ID"
    , "P5722": "Greek Basket League ID"
    , "P5723": "Polish Basketball League ID"
    , "P5724": "Basketball Bundesliga ID"
    , "P5725": "Baloncesto Superior Nacional ID"
    , "P5726": "Pietre della Memoria ID"
    , "P5727": "Partis d'Arcadie ID"
    , "P5731": "Angelicum ID"
    , "P5732": "bgm.tv subject identifier"
    , "P5733": "bilibili ID"
    , "P5734": "Historic Hotels of America ID"
    , "P5735": "Historic Hotels Worldwide ID"
    , "P5736": "Minor Planet Center body ID"
    , "P5737": "Moegirlpedia ID (Chinese)"
    , "P5738": "Open Exoplanet Catalogue exoplanet ID"
    , "P5739": "Pontificia Universit\u00e0 della Santa Croce ID"
    , "P5740": "So Foot ID"
    , "P5742": "Voetbalstats player ID"
    , "P5743": "SR Number"
    , "P5744": "KERIS school ID"
    , "P5745": "Pacific Coast Architecture Database person ID"
    , "P5746": "Directorate General of Civil Aeronautics (Mexico) code"
    , "P5747": "CWA writer ID"
    , "P5748": "Basisklassifikation"
    , "P5749": "Amazon Standard Identification Number"
    , "P5750": "FBref.com player ID"
    , "P5752": "Syndikat writer ID"
    , "P5753": "ideographic description sequences"
    , "P5755": "EU project RCN"
    , "P5756": "ABMC person ID"
    , "P5757": "DAV hut ID"
    , "P5758": "PZS hut ID"
    , "P5759": "\u00d6AV hut ID"
    , "P5760": "Petit Fut\u00e9 site ID"
    , "P5761": "SAC ID"
    , "P5762": "NDB identifier for airport beacons"
    , "P5763": "Directorio de Museos y Colecciones de Espa\u00f1a ID"
    , "P5764": "IMA museum ID"
    , "P5765": "The Park Database ID"
    , "P5768": "Osservatorio culturale del Cantone Ticino ID"
    , "P5769": "editor-in-chief"
    , "P5770": "Animator.ru person ID"
    , "P5771": "Russian Biathlon DB athlete ID"
    , "P5772": "coach ID at the Russian Biathlon DB"
    , "P5773": "Television Academy Foundation interviewee ID"
    , "P5774": "Historic Hotels of Europe ID"
    , "P5775": "image of interior"
    , "P5776": "Arnet Miner author ID"
    , "P5777": "CoinMarketCap cryptocurrency ID"
    , "P5778": "Cooperative Patent Classification code"
    , "P5779": "CPAN project"
    , "P5780": "CPCRulez ID"
    , "P5782": "DBUnico MIBACT ID"
    , "P5783": "Cranach Digital Archive artwork ID"
    , "P5784": "DSV person ID"
    , "P5785": "EU Research participant ID"
    , "P5786": "Moviepilot.de film ID"
    , "P5787": "Ski Jumping Hill Archive ID"
    , "P5788": "The Gymternet gymnast ID"
    , "P5789": "WorldofVolley player ID"
    , "P5790": "Skijumping.pl jumper ID"
    , "P5791": "Cineuropa film ID"
    , "P5792": "NooSFere series ID"
    , "P5793": "Dobry s\u0142ownik ID"
    , "P5794": "Internet Game Database game ID"
    , "P5795": "Internet Game Database platform ID"
    , "P5796": "Internet Game Database person ID"
    , "P5797": "Twitch channel ID"
    , "P5798": "Thomson Reuters Business Classification"
    , "P5799": "AustLII ID"
    , "P5800": "narrative role"
    , "P5801": "Academia.edu topic ID"
    , "P5802": "stage crew member"
    , "P5803": "VOR/DME identifier for airport beacons"
    , "P5804": "has program committee member"
    , "P5805": "OSI Model layer location"
    , "P5806": "SNOMED CT identifier"
    , "P5807": "Alternativa Teatral person ID"
    , "P5808": "Alternativa Teatral work ID"
    , "P5809": "Alternativa Teatral place ID"
    , "P5810": "cryptocurrency symbol"
    , "P5811": "elongation at break"
    , "P5813": "MusicBrainz release ID"
    , "P5814": "IANA service name"
    , "P5815": "Olympic Channel athlete ID"
    , "P5816": "state of conservation"
    , "P5817": "state of use"
    , "P5818": "BGCI garden ID"
    , "P5819": "International Mathematical Olympiad participant ID"
    , "P5820": "Film Indonesia ID"
    , "P5821": "ArhivX LOD"
    , "P5822": "admission rate"
    , "P5823": "Belvedere object ID"
    , "P5824": "is retracted by"
    , "P5825": "ISO 15919 transliteration"
    , "P5826": "majority opinion by"
    , "P5827": "National Trust for Historic Preservation ID"
    , "P5828": "seed"
    , "P5829": "Television Academy Foundation show ID"
    , "P5830": "demonstrates form"
    , "P5831": "usage example"
    , "P5832": "political coalition"
    , "P5833": "Playbill production ID"
    , "P5834": "Leading Hotels of the World hotel ID"
    , "P5835": "World Travel Awards ID"
    , "P5836": "Relais & Ch\u00e2teaux ID"
    , "P5838": "Nintendo GameID"
    , "P5839": "Acad\u00e9mie de Marseille member ID"
    , "P5840": "NPR podcast ID"
    , "P5841": "Status in the Red List of Threatened Species in the Czech Republic"
    , "P5842": "Apple Podcasts podcast ID"
    , "P5843": "Gynopedia ID"
    , "P5844": "Treccani Vocabulary ID"
    , "P5845": "AnimeClick anime ID"
    , "P5846": "AnimeClick novel ID"
    , "P5847": "AnimeClick character ID"
    , "P5848": "AnimeClick person ID"
    , "P5849": "AnimeClick manga ID"
    , "P5851": "Ex-USSR internal airport code"
    , "P5852": "item inherits value from"
    , "P5858": "Index Herbariorum code"
    , "P5859": "Adelphi author ID"
    , "P5860": "AnimeClick drama ID"
    , "P5862": "Lepidoptera of Belgium ID"
    , "P5863": "CharacTour character ID"
    , "P5864": "Enciclovida ID"
    , "P5865": "IGN film ID"
    , "P5866": "LakeNet ID"
    , "P5867": "Mathematical Reviews journal ID"
    , "P5868": "MobyGames platform ID"
    , "P5869": "model item"
    , "P5870": "Northern Ireland Assembly ID"
    , "P5871": "Norwegian war refugees register ID"
    , "P5872": "perfume note"
    , "P5873": "place of devotion"
    , "P5874": "re3data repository ID"
    , "P5875": "ResearchGate publication identifier"
    , "P5876": "SJPXVII ID"
    , "P5877": "SPXVI ID"
    , "P5878": "Taxonomic Literature 2 number"
    , "P5879": "Qualit\u00e9 Tourisme ID"
    , "P5880": "video designer"
    , "P5881": "projection designer"
    , "P5882": "Muziekweb performer ID"
    , "P5883": "Tourisme & Handicap ID"
    , "P5884": "Dapodikdasmen ID"
    , "P5885": "Microsoft Store product ID"
    , "P5886": "mode of derivation"
    , "P5887": "Arkivportalen agent ID"
    , "P5888": "Arkivportalen archive ID"
    , "P5890": "Preferred Hotels & Resorts hotel ID"
    , "P5891": "Bpk-ID"
    , "P5892": "UOL Elei\u00e7\u00f5es ID"
    , "P5893": "work hardening strain"
    , "P5894": "tuition fee"
    , "P5895": "foreign transaction fee"
    , "P5896": "trading fee"
    , "P5897": "account charge / subscription fee"
    , "P5898": "borrowing rate"
    , "P5899": "interest rate"
    , "P5900": "JMA Magnitude"
    , "P5901": "official number of town quarter"
    , "P5902": "Uralonet ID"
    , "P5903": "\u00c1lgu ID"
    , "P5904": "ASCE Historical Civil Engineering Landmark ID"
    , "P5905": "Comic Vine ID"
    , "P5906": "DxOMark ID"
    , "P5908": "Geheugen van de VU person ID"
    , "P5909": "HKCAN ID"
    , "P5910": "ENI number"
    , "P5911": "inflection class"
    , "P5912": "Oqaasileriffik online dictionary ID"
    , "P5913": "has inflection class"
    , "P5914": "IANA Root Zone Database ID"
    , "P5915": "Shazam track ID"
    , "P5916": "Spotify show ID"
    , "P5917": "Shazam artist ID"
    , "P5918": "Sprockhoff Number"
    , "P5920": "root"
    , "P5921": "Index of Historic Collectors and Dealers of Cubism ID"
    , "P5922": "ANZSRC 2008 FoR ID"
    , "P5923": "creates lexeme type"
    , "P5925": "Moviepilot.de series ID"
    , "P5926": "Spectral Database for Organic Compounds ID"
    , "P5927": "Ultimate Guitar artist ID"
    , "P5928": "\u0120abra lexeme ID"
    , "P5929": "limiting oxygen index"
    , "P5930": "Open Food Facts ingredient ID"
    , "P5931": "bazakolejowa.pl railway line ID"
    , "P5932": "IGN TV series ID"
    , "P5933": "tweet ID"
    , "P5934": "Short Title Catalogue Flanders (STCV)"
    , "P5935": "Flanders Arts Institute production ID"
    , "P5936": "old-computers.com ID"
    , "P5937": "Oudnederlands Woordenboek GTB ID"
    , "P5938": "Vroegmiddelnederlands Woordenboek GTB ID"
    , "P5939": "Middelnederlandsch Woordenboek GTB ID"
    , "P5940": "plot expanded in"
    , "P5941": "Film Indonesia person ID"
    , "P5942": "Protected objects Ostbelgien ID"
    , "P5944": "North America PlayStation Store ID"
    , "P5945": "VicFlora ID"
    , "P5946": "SUCA code"
    , "P5947": "Vicat softening point"
    , "P5948": "CMI person ID"
    , "P5949": "Unicode range"
    , "P5950": "S\u00e3o Paulo: os estrangeiros e a constru\u00e7\u00e3o da cidade ID"
    , "P5951": "ComiXology creator ID"
    , "P5952": "Annuaire de la magistrature ID"
    , "P5953": "NT Flora ID"
    , "P5954": "Museu Nacional ID"
    , "P5955": "Sekolah Kita ID"
    , "P5956": "War Memorials Online ID"
    , "P5957": "ID of Inventory of the Archaeological and Paleontological Heritage of Catalonia"
    , "P5958": "Women's Japan Basketball League ID"
    , "P5959": "V.League ID (obsolete)"
    , "P5960": "Japan Professional Basketball League ID"
    , "P5961": "depicted part"
    , "P5962": "sail emblem"
    , "P5963": "Elsevier journal ID"
    , "P5964": "Norwegian Nationaltheatret actor ID"
    , "P5965": "LUBW Protected Area No"
    , "P5966": "SAGE journal ID"
    , "P5967": "reference vocabulary"
    , "P5968": "CPPAP ID"
    , "P5969": "RBF player ID"
    , "P5970": "Medier\u00e5det rating"
    , "P5971": "Europe PlayStation Store ID"
    , "P5972": "translation"
    , "P5973": "synonym"
    , "P5974": "antonym"
    , "P5975": "troponym of"
    , "P5976": "false friend"
    , "P5977": "Wikidata property example for senses"
    , "P5978": "classifier"
    , "P5979": "Sandbox-Sense"
    , "P5980": "derived from sense"
    , "P5981": "Encyclopedia Virginia ID"
    , "P5982": "annual number of weddings"
    , "P5983": "Springer journal ID"
    , "P5984": "APNI ID"
    , "P5985": "Literaturaren Zubitegia ID"
    , "P5986": "Getty Iconography Authority ID"
    , "P5987": "Indiancine.ma film ID"
    , "P5988": "Deezer show ID"
    , "P5989": "Indiancine.ma person ID"
    , "P5990": "Movies Anywhere ID"
    , "P5991": "carbon footprint"
    , "P5992": "attenuation coefficient"
    , "P5993": "compressive modulus of elasticity"
    , "P5994": "recycling code"
    , "P5995": "kit supplier"
    , "P5996": "category for films in this language_code"
    , "P5997": "stated in reference as"
    , "P5998": "distributary"
    , "P5999": "Japan PlayStation Store ID"
    , "P6000": "water footprint"
    , "P6001": "applies to people"
    , "P6002": "WikiArt ID"
    , "P6003": "Center for Biological Diversity ID"
    , "P6004": "Brasiliana Iconogr\u00e1fica ID"
    , "P6005": "Muck Rack journalist ID"
    , "P6006": "Museum Universe Data File ID"
    , "P6007": "Salons ID"
    , "P6008": "Agoda hotel ID"
    , "P6009": "Techopedia ID"
    , "P6010": "Encyclopedia of Alabama ID"
    , "P6011": "Internet Pinball Database ID"
    , "P6012": "California Office of Historic Preservation ID"
    , "P6013": "Encyclopedia of Appalachia ID"
    , "P6014": "flexural strain at break"
    , "P6015": "Handbook of Texas ID"
    , "P6016": "Tennessee Encyclopedia ID"
    , "P6017": "CanalPlan AC place ID"
    , "P6018": "SeaLifeBase ID"
    , "P6019": "Species at Risk public registry ID"
    , "P6020": "d'Art d'Art ! ID"
    , "P6021": "Hymenoptera Online taxon ID"
    , "P6022": "expression, gesture or body pose"
    , "P6023": "ResearchGate contributions ID"
    , "P6024": "Cl\u00e9 des langues ID"
    , "P6025": "Oiseaux.net ID"
    , "P6028": "Hypericum MySpecies ID"
    , "P6030": "ECOS ID"
    , "P6032": "IGF entrant ID"
    , "P6033": "CMS ID"
    , "P6034": "Plant Finder ID"
    , "P6035": "C.V. Starr Virtual Herbarium ID"
    , "P6036": "Wild Herps ID"
    , "P6037": "ProsopoMaths ID"
    , "P6038": "AFAS author ID"
    , "P6039": "Australian Faunal Directory ID"
    , "P6040": "BirdLife Australia ID"
    , "P6041": "John J. Audubon's Birds of America ID"
    , "P6042": "Echinoid Directory ID"
    , "P6043": "Esp\u00e8ces Envahissantes Outre-mer ID"
    , "P6044": "FEIS ID"
    , "P6045": "Global Raptor Information Network ID"
    , "P6046": "MNHN taxon ID"
    , "P6047": "Neotropical Birds ID"
    , "P6048": "New Zealand Birds Online ID"
    , "P6049": "NOAA Fisheries Species Directory ID"
    , "P6050": "OSF Online ID"
    , "P6051": "Sea Slug Forum ID"
    , "P6052": "Cockroach Species File ID"
    , "P6053": "Coreoidea Species File ID"
    , "P6054": "GT IBMA ID"
    , "P6055": "Mantodea Species File ID"
    , "P6056": "Red List of South African Plants ID"
    , "P6057": "Systematic Catalog of Culicidae ID"
    , "P6058": "Larousse ID"
    , "P6059": "Biographie vosgienne ID"
    , "P6060": "MoEML ID"
    , "P6061": "Plant Parasites of Europe ID"
    , "P6062": "Scoresway baseball person ID"
    , "P6063": "Scoresway basketball person ID"
    , "P6064": "Scoresway ice hockey person ID"
    , "P6065": "Scoresway rugby person ID"
    , "P6066": "Scoresway volleyball person ID"
    , "P6067": "ARD Mediathek ID"
    , "P6068": "DCMOTO identifier"
    , "P6069": "INEP IGC continuous score"
    , "P6070": "BirdLife International IBA ID"
    , "P6071": "Polish Olympic Committee athlete ID"
    , "P6072": "demonstrates sense"
    , "P6073": "permeation"
    , "P6075": "embodied energy"
    , "P6076": "biobased content weight percentage"
    , "P6077": "British Museum bioID"
    , "P6078": "GameFAQs platform ID"
    , "P6079": "Discogs track ID"
    , "P6080": "Discogs composition ID"
    , "P6081": "RIA Novosti reference"
    , "P6082": "NYC Building Identification Number (BIN)"
    , "P6083": "Cineuropa person ID"
    , "P6084": "location of sense usage"
    , "P6086": "dramaturge"
    , "P6087": "coach of sports team"
    , "P6088": "beer bitterness"
    , "P6089": "beer color"
    , "P6090": "Caselaw Access Project case ID"
    , "P6091": "MGG Online ID"
    , "P6092": "Map of Life ID"
    , "P6093": "AfroMoths ID"
    , "P6094": "FloraWeb ID"
    , "P6095": "INEP IGC discrete grade"
    , "P6096": "FLOW ID"
    , "P6097": "AllPowerlifting.com person ID"
    , "P6098": "Info Flora ID"
    , "P6099": "clinical trial phase"
    , "P6100": "Y\u00d6K Academic Profile ID"
    , "P6101": "Mushroom Observer ID"
    , "P6102": "Schleswig-Holstein cultural heritage object ID"
    , "P6103": "Michigan Flora ID"
    , "P6104": "maintained by WikiProject"
    , "P6105": "Observation.org ID"
    , "P6106": "uses capitalization for"
    , "P6107": "winterthur-glossar URL"
    , "P6108": "IIIF manifest"
    , "P6109": "Danish Football Union player ID"
    , "P6110": "AllMusic release ID"
    , "P6111": "MusicNotes product ID"
    , "P6112": "category for members of a team"
    , "P6113": "Playbill venue ID"
    , "P6114": "Portal to the Flora of Italy ID"
    , "P6115": "Digital Flora of Central Africa ID"
    , "P6116": "chord progression"
    , "P6117": "Envanter.gov.tr Monument ID"
    , "P6118": "season ends"
    , "P6119": "Letterboxd actor ID"
    , "P6120": "Argentinean NCAA Airport code"
    , "P6122": "MusicNotes song ID"
    , "P6123": "B3Kat dataset ID"
    , "P6124": "Sotheby's person ID"
    , "P6125": "number of volunteers"
    , "P6126": "Santiebeati ID"
    , "P6127": "Letterboxd film ID"
    , "P6128": "Threatened Species Link ID"
    , "P6130": "Littera ID"
    , "P6131": "Soccerway team ID"
    , "P6132": "Playbill person ID"
    , "P6133": "Siamzone film ID"
    , "P6134": "Thaifilm ID"
    , "P6135": "VD 18 ID"
    , "P6136": "Newseum newspaper front page ID"
    , "P6137": "APA ID"
    , "P6138": "Software Heritage identifier (SWHID)"
    , "P6139": "Virtual Guide to the Flora of Mongolia ID"
    , "P6140": "DanNet 2.2 word ID"
    , "P6141": "\u00c0 nos grands hommes ID"
    , "P6142": "Verspreidingsatlas.nl ID"
    , "P6143": "BioOne journal ID"
    , "P6144": "ortsnamen.ch ID"
    , "P6145": "Academy Awards Database film ID"
    , "P6146": "The Hendon Mob ID"
    , "P6147": "World Poker Tour player ID"
    , "P6148": "GLAMOS glacier ID"
    , "P6149": "running mate"
    , "P6150": "Academy Awards Database nominee ID"
    , "P6151": "ANICA ID"
    , "P6152": "National Portrait Gallery (United States) object ID"
    , "P6153": "research site"
    , "P6154": "r-hockey.ru person ID"
    , "P6155": "Sotheby's Museum Network ID"
    , "P6156": "MNAV artist ID"
    , "P6157": "Google News publication ID"
    , "P6158": "ALCA author ID"
    , "P6159": "Atlas of Florida Plants ID"
    , "P6160": "BoardGameGeek game publisher ID"
    , "P6161": "Invasive Plant Atlas of the United States ID"
    , "P6162": "Luding game publisher ID"
    , "P6163": "NAS ID"
    , "P6164": "Dep\u00f3sito Legal ID"
    , "P6165": "Corpus typographique fran\u00e7ais ID"
    , "P6166": "quotes work"
    , "P6167": "British Executions ID"
    , "P6168": "Bantu Lexical Reconstructions ID"
    , "P6169": "Welsh Book Trade Info ID"
    , "P6170": "System16 identifier"
    , "P6171": "Acad\u00e9mie d'Arles member ID"
    , "P6172": "Satakore game ID"
    , "P6173": "Bitraga author ID"
    , "P6174": "TWAS Fellow ID"
    , "P6175": "Bitraga work ID"
    , "P6176": "Cal-IPC ID"
    , "P6177": "EUNIS ID for species"
    , "P6178": "Dimensions author ID"
    , "P6179": "Dimensions Publication ID"
    , "P6180": "Dimensions Source ID"
    , "P6181": "Disney A to Z ID"
    , "P6182": "GameFAQs company ID"
    , "P6183": "African Journals Online  journal ID"
    , "P6184": "reference has role"
    , "P6185": "tautomer of"
    , "P6186": "category for eponymous categories"
    , "P6187": "Lego set ID"
    , "P6188": "BDFA player ID"
    , "P6189": "Sabinet journal ID"
    , "P6190": "NSW State Archives and Records Authority Agency ID"
    , "P6191": "language_code style"
    , "P6192": "Bygdeband ID"
    , "P6193": "ratified by"
    , "P6194": "Austrian Biographical Encylopedia ID"
    , "P6195": "funding scheme"
    , "P6196": "Badtaste ID"
    , "P6197": "Badgames ID"
    , "P6198": "Liga MX Femenil player ID"
    , "P6199": "member of the Portuguese parliament ID"
    , "P6200": "BBC News topic ID"
    , "P6201": "OBV editions ID"
    , "P6202": "Geolex ID"
    , "P6204": "CNPJ"
    , "P6205": "Defined Term ID"
    , "P6206": "Guida al Fumetto Italiano ID"
    , "P6208": "award rationale"
    , "P6209": "SEINet ID"
    , "P6210": "LIGA profile"
    , "P6211": "BIBSYS work ID"
    , "P6212": "heat treating"
    , "P6213": "UK Parliament identifier"
    , "P6214": "Jewish Museum Berlin person ID"
    , "P6215": "Vesti.kz person ID"
    , "P6216": "copyright status"
    , "P6217": "Genius album ID"
    , "P6218": "Genius song ID"
    , "P6219": "TASS reference"
    , "P6220": "OpenTrials ID"
    , "P6221": "NooSFere story ID"
    , "P6222": "DIR3 ID"
    , "P6223": "L'Encyclop\u00e9die philosophique ID"
    , "P6224": "level of description"
    , "P6225": "TrENSmissions person ID"
    , "P6226": "ARLLFB member ID"
    , "P6227": "Flora of Wisconsin ID"
    , "P6228": "RegiowikiAT ID"
    , "P6229": "Discord Store game SKU"
    , "P6230": "Bavarian protected area ID"
    , "P6231": "BDEL ID"
    , "P6232": "Danske Taler speaker ID"
    , "P6233": "Place Names Register ID (Estonia)"
    , "P6234": "Biographie nationale de Belgique ID"
    , "P6235": "ARB person ID"
    , "P6237": "real estate developer"
    , "P6238": "Monument aux morts ID"
    , "P6239": "IEC commemorative monument of Catalonia ID"
    , "P6240": "MMLO ID"
    , "P6241": "collection creator"
    , "P6242": "Meteorological Service of Canada climate site ID"
    , "P6243": "digital representation of"
    , "P6244": "Volksbund ID"
    , "P6245": "PomBase systematic ID"
    , "P6246": "Paris Mus\u00e9es work ID"
    , "P6247": "Lego design ID"
    , "P6248": "Lego element ID"
    , "P6249": "narrative age"
    , "P6250": "iTunes music movie ID"
    , "P6251": "catchphrase"
    , "P6252": "BSRussia player ID"
    , "P6253": "Beachsoccer.ru player ID"
    , "P6254": "subject lexeme"
    , "P6255": "SinemaT\u00fcrk person ID"
    , "P6256": "SinemaT\u00fcrk film ID"
    , "P6257": "right ascension"
    , "P6258": "declination"
    , "P6259": "epoch"
    , "P6260": "galactic longitude"
    , "P6261": "galactic latitude"
    , "P6262": "Fandom article ID"
    , "P6263": "MinDat mineral ID"
    , "P6264": "Harvard Index of Botanists ID"
    , "P6265": "MinDat Locality ID"
    , "P6266": "Garzanti Linguistica ID"
    , "P6267": "Multiplayer ID"
    , "P6268": "Danmarks svampeatlas ID"
    , "P6269": "API endpoint"
    , "P6271": "demonym of"
    , "P6272": "specific rotation"
    , "P6274": "concentration"
    , "P6275": "copyright representative"
    , "P6276": "Amazon Music artist ID"
    , "P6277": "Objectif Gard topic ID"
    , "P6278": "Epic Games Store ID"
    , "P6279": "ZVR-Number"
    , "P6280": "Berlin protected area ID"
    , "P6281": "IPPDH ID"
    , "P6282": "French Academy of Sciences member ID"
    , "P6283": "MNopedia ID"
    , "P6284": "NCpedia ID"
    , "P6285": "Weeds in Ontario ID"
    , "P6286": "ICCD ID - S form"
    , "P6287": "ICCD ID - CF form"
    , "P6288": "ICCD ID - CG form"
    , "P6289": "ODNR Division of Wildlife ID"
    , "P6290": "Penthouse ID"
    , "P6291": "advertises"
    , "P6292": "Complete BBC Micro Games Archive ID"
    , "P6293": "YSA ID"
    , "P6294": "ARTIC exhibition ID"
    , "P6295": "ARTIC artist ID"
    , "P6296": "bgm.tv character identifier"
    , "P6297": "ACB.com coach ID"
    , "P6298": "bgm.tv person identifier"
    , "P6299": "PC-9801 DB ID"
    , "P6300": "Hymnary author ID"
    , "P6301": "The Armory Show at 100 ID"
    , "P6302": "Dictionnaire de spiritualit\u00e9 ID"
    , "P6303": "Swedish Anbytarforum"
    , "P6304": "researchportal.helsinki.fi profile ID"
    , "P6305": "Wikimedia OTRS ticket number"
    , "P6306": "AllMusic performance ID"
    , "P6307": "Wikibase Registry ID"
    , "P6308": "Scoresway tennis person ID"
    , "P6309": "historical R\u00e9pertoire national des associations identifier"
    , "P6310": "Mus\u00e9osph\u00e8re work ID"
    , "P6311": "Pressball.by football (soccer) player ID"
    , "P6312": "Russian Premier League staff ID"
    , "P6313": "Russian Premier League referee ID"
    , "P6314": "WorldFootball.net referee ID"
    , "P6315": "PlaymakerStats.com referee ID"
    , "P6316": "PlaymakerStats.com coach ID"
    , "P6317": "RusTeam player ID"
    , "P6318": "Crimean Football Union player ID"
    , "P6319": "Italian Footballers' Association player ID"
    , "P6320": "Futsal Association of Russia player ID"
    , "P6321": "Teams.by player ID"
    , "P6322": "vehicle identification number"
    , "P6323": "Centre Pompidou ID"
    , "P6324": "INE ID (Portugal)"
    , "P6325": "Critique d'art ID"
    , "P6326": "DVR Number"
    , "P6327": "Goodreads character ID"
    , "P6328": "Politika topic"
    , "P6329": "Share-VDE author ID"
    , "P6330": "England Football Online manager profile"
    , "P6331": "England Football Online player profile"
    , "P6332": "Panorama de l'art ID"
    , "P6333": "title of broader work"
    , "P6334": "Agence photo RMN package ID"
    , "P6335": "MDWS place ID"
    , "P6336": "JKT48 member ID"
    , "P6337": "PCGamingWiki ID"
    , "P6338": "colorist"
    , "P6339": "reports periodicity"
    , "P6340": "Uppsala General Catalogue ID"
    , "P6341": "IFPNI species ID"
    , "P6342": "Dictionnaire des Wallons ID"
    , "P6343": "urban population"
    , "P6344": "rural population"
    , "P6346": "statutory purpose"
    , "P6347": "The White-files species ID"
    , "P6348": "Hymnary text ID"
    , "P6349": "Lace bugs database ID"
    , "P6350": "Doctrine ID"
    , "P6351": "Genius artist numeric ID"
    , "P6352": "OLAC video game genre vocabulary ID"
    , "P6353": "OSGS-Number"
    , "P6354": "closest approach"
    , "P6355": "MNAM artwork ID"
    , "P6356": "IHOI work ID"
    , "P6357": "Conf\u00e9rence du stage secretary ID"
    , "P6358": "Mus\u00e9e Picasso artwork ID"
    , "P6359": "Crew United title ID"
    , "P6360": "Genius album numeric ID"
    , "P6361": "Genius song numeric ID"
    , "P6362": "Litchfield Ledger ID"
    , "P6363": "WordLift URL"
    , "P6364": "official color"
    , "P6365": "member category"
    , "P6366": "Microsoft Academic ID"
    , "P6367": "Bahamut Gamer's Community ACG Database"
    , "P6368": "Media Arts Database anime ID (obsolete)"
    , "P6369": "Media Arts Database manga ID (obsolete)"
    , "P6370": "REDIZO"
    , "P6371": "Archives of Maryland Biographical Series ID"
    , "P6372": "Interpol WOA artwork ID (OBSOLETE)"
    , "P6373": "Online Catalog of Biblioteca Nacional de Portugal ID"
    , "P6374": "MAMVP artwork ID"
    , "P6375": "street address"
    , "P6376": "Psyl'list species ID"
    , "P6377": "VectorBase taxonomy ID"
    , "P6378": "charter URL"
    , "P6379": "has works in the collection"
    , "P6381": "iTunes TV season ID"
    , "P6382": "Hungarian public thesaurus ID"
    , "P6383": "TV Spielfilm film ID"
    , "P6384": "Viperson ID"
    , "P6385": "Krugosvet article"
    , "P6386": "biathlon.com.ua person ID"
    , "P6387": "RBU person ID"
    , "P6388": "sportufo.ru person ID"
    , "P6389": "Skiresort.info ID"
    , "P6390": "Education Institution Identification Number"
    , "P6391": "U-DISE code"
    , "P6392": "AISHE code"
    , "P6394": "ELNET ID"
    , "P6395": "Apple Books book ID"
    , "P6398": "iTunes movie ID"
    , "P6399": "Romanian Soccer player ID"
    , "P6400": "Skimap area ID"
    , "P6401": "sports.md athlete ID"
    , "P6402": "Gault et Millau ID"
    , "P6403": "TheatreOnline ID"
    , "P6404": "Treccani's Dizionario di Storia ID"
    , "P6405": "Smarthistory ID"
    , "P6406": "vodnimlyny.cz ID"
    , "P6407": "World Cube Association ID"
    , "P6408": "COOL species ID"
    , "P6409": "CORE ID"
    , "P6410": "LevskiSofia.info coach ID"
    , "P6411": "LevskiSofia.info player ID"
    , "P6412": "Gran Enciclop\u00e8dia de la M\u00fasica ID"
    , "P6413": "JORFSearch organization ID"
    , "P6414": "DIZIE ID"
    , "P6415": "Football.Odessa.ua person ID"
    , "P6416": "sport-strana.ru article ID"
    , "P6417": "Homosaurus ID"
    , "P6418": "funk channel ID"
    , "P6419": "GEOFON earthquake ID"
    , "P6420": "Georgian National Filmography ID"
    , "P6421": "infosport.ru person ID"
    , "P6422": "ManualsLib brand ID"
    , "P6423": "MusicBrainz event ID"
    , "P6424": "affiliation string"
    , "P6425": "LGD local body code"
    , "P6426": "RightsStatement status according to source website"
    , "P6427": "trading name"
    , "P6428": "HAER ID"
    , "P6429": "Hymnary hymnal ID"
    , "P6430": "Hymnary instance ID"
    , "P6431": "Hymnary tune ID"
    , "P6432": "Alexander\u2013Briggs notation"
    , "P6433": "Global Species ID"
    , "P6434": "Amsterdam code"
    , "P6436": "Code of Natura 2000/FFH habitat"
    , "P6437": "day of regular release"
    , "P6438": "Euler characteristic"
    , "P6439": "has lyrics"
    , "P6440": "maintenance method"
    , "P6441": "Douban author ID"
    , "P6442": "Douban book ID"
    , "P6443": "Douban drama ID"
    , "P6444": "Douban game ID"
    , "P6445": "Douban music ID"
    , "P6446": "Douban musician ID"
    , "P6447": "Douban Read author ID"
    , "P6448": "Douban Read eBook ID"
    , "P6449": "Douban site name"
    , "P6450": "Douban username"
    , "P6451": "Zhihu username"
    , "P6452": "CBFC rating"
    , "P6453": "Bilibili bangumi ID"
    , "P6454": "Bilibili tag ID"
    , "P6455": "Bilibili userID"
    , "P6456": "Bilibili video ID"
    , "P6457": "Eventa Servo ID"
    , "P6458": "Mtime movie ID"
    , "P6459": "QQ number"
    , "P6460": "Swedish Organization Number"
    , "P6461": "Rock's Backpages artist ID"
    , "P6462": "Rock's Backpages author ID"
    , "P6463": "Rock's Backpages publication ID"
    , "P6464": "Mtime people ID"
    , "P6465": "Democracy Club candidate ID"
    , "P6466": "Hulu movie ID"
    , "P6467": "Hulu series ID"
    , "P6468": "ISA ID"
    , "P6469": "Fuzhou Architecture Heritage ID"
    , "P6470": "DALFAN ID"
    , "P6471": "Den Digitale Byport ID"
    , "P6472": "GameFAQs franchise ID"
    , "P6473": "NMSRCP reference number"
    , "P6474": "Swiss Films ID"
    , "P6475": "CABB player ID"
    , "P6476": "castingvideos ID"
    , "P6477": "does not have quality"
    , "P6478": "Mecklenburg-Vorpommern protected area ID"
    , "P6479": "IEEE Xplore author ID"
    , "P6480": "IEEE Xplore document ID"
    , "P6481": "Strepsiptera database species ID"
    , "P6482": "Image Archive, Herder Institute"
    , "P6483": "WBCHSE code"
    , "P6484": "Antarctica NZ Digital Asset Manager"
    , "P6485": "Brentidae of the world species ID"
    , "P6486": "Pacific Coast Architecture Database building ID"
    , "P6487": "Illustrated catalog of Tessaratomidae species ID"
    , "P6488": "Enciclopedia delle donne ID"
    , "P6489": "Joan Mir\u00f3 Online Image Bank ID"
    , "P6490": "BIDICAM authority ID"
    , "P6491": "Board Game Atlas ID"
    , "P6492": "BVPH authority ID"
    , "P6493": "CCBAE publication ID"
    , "P6494": "ISTC No."
    , "P6495": "KSI player ID"
    , "P6496": "Biblioteca Virtual Andaluc\u00eda authority ID"
    , "P6497": "drag coefficient"
    , "P6498": "illiterate population"
    , "P6499": "literate population"
    , "P6500": "non-free artwork image URL"
    , "P6501": "Georgian National Filmography person ID"
    , "P6502": "JWF Wrestlers Database person ID"
    , "P6503": "Indian census area code (1991)"
    , "P6504": "Lithuanian Sport Encyclopedia (LSE) article ID"
    , "P6506": "Eliseu Visconti Project ID"
    , "P6507": "taxon author citation"
    , "P6509": "total goals in career"
    , "P6510": "stall speed"
    , "P6512": "UN/CEFACT Common Code"
    , "P6513": "AICTE Permanent ID"
    , "P6514": "DOGC ID"
    , "P6515": "DoBIH Number"
    , "P6516": "ScaleNet ID"
    , "P6517": "WhoSampled artist ID"
    , "P6518": "Business Registry code (Estonia)"
    , "P6519": "ISO 639-3 Change Request ID"
    , "P6520": "Lokalhistoriewiki.no ID"
    , "P6521": "Crew United person ID"
    , "P6524": "expression of"
    , "P6525": "Fondation Maeght artist ID"
    , "P6526": "data.gouv.fr dataset ID"
    , "P6527": "V.League men's player ID"
    , "P6528": "V.League women's player ID"
    , "P6529": "provisional house number in the Czech Republic"
    , "P6530": "has role in modeling"
    , "P6531": "observed in"
    , "P6532": "has phenotype"
    , "P6533": "type of front suspension"
    , "P6534": "type of rear suspension"
    , "P6535": "BHL part ID"
    , "P6536": "Gateway to Research Project ID"
    , "P6537": "Yandex Music genre ID"
    , "P6538": "Yandex Music label ID"
    , "P6539": "Cat\u00e1logo de Patrimonio Cultural de Castilla-La Mancha ID"
    , "P6540": "multi-channel network"
    , "P6541": "Stack Exchange site"
    , "P6542": "Invent\u00e1rio dos Monumentos RJ ID"
    , "P6543": "total shots in career"
    , "P6544": "total points in career"
    , "P6545": "total assists in career"
    , "P6546": "penalty minutes in career"
    , "P6547": "career plus-minus rating"
    , "P6548": "NZ On Screen person ID"
    , "P6549": "NZ On Screen work ID"
    , "P6550": "Pacific Coast Architecture Database firm ID"
    , "P6551": "Physics History Network ID"
    , "P6552": "Twitter user numeric ID"
    , "P6553": "preferred pronoun"
    , "P6554": "Represent Me ID"
    , "P6555": "Brazilian Electoral Unit ID"
    , "P6556": "SICRIS researcher ID"
    , "P6557": "Dimensions.guide ID"
    , "P6558": "National Wrestling Hall of Fame University team ID"
    , "P6559": "Official Charts artist ID"
    , "P6560": "Saxony-Anhalt protected area ID"
    , "P6561": "AiF dossier ID"
    , "P6562": "Google Play Movies & TV ID"
    , "P6563": "key performance indicator"
    , "P6564": "Brilliant Wiki ID"
    , "P6565": "Musenor artwork ID"
    , "P6566": "Indonesian Cultural Heritage Registration System ID"
    , "P6567": "Florida Historical Marker List ID"
    , "P6568": "inscription mentions"
    , "P6569": "taxa especially protected in area"
    , "P6570": "number of words"
    , "P6571": "collective noun for animals"
    , "P6572": "ProQuest document ID"
    , "P6573": "Klexikon article ID"
    , "P6574": "Libraries & Information Centers in the Czech Republic ID"
    , "P6575": "Acad\u00e9mie de Rouen member ID"
    , "P6576": "Art Fund artwork ID"
    , "P6577": "Cour des comptes report ID"
    , "P6578": "MutualArt artist ID"
    , "P6579": "National Book Foundation author ID"
    , "P6580": "National Book Foundation book ID"
    , "P6581": "Deportation Database transport ID"
    , "P6582": "Dutch Instrument Makers ID"
    , "P6583": "Lucerna person ID"
    , "P6584": "Scripts.com script ID"
    , "P6585": "Directorio Legislativo ID"
    , "P6586": "Cook Partisan Voting Index"
    , "P6587": "league system"
    , "P6589": "endowment"
    , "P6590": "highest break"
    , "P6591": "maximum temperature record"
    , "P6592": "OpenStreetMap zoom level"
    , "P6593": "hyperonym"
    , "P6594": "Guggenheim fellows ID"
    , "P6595": "Paintings by Salvador Dal\u00ed ID"
    , "P6596": "a-tremasov.ru biography ID"
    , "P6597": "Digital Dictionary of Surnames in Germany ID"
    , "P6598": "flgr-results.ru athlete ID"
    , "P6599": "HCA Red List of Endangered Crafts ID"
    , "P6600": "Resident Advisor artist ID"
    , "P6601": "Resident Advisor label ID"
    , "P6602": "Rhineland-Palatinate protected area ID"
    , "P6603": "film-documentaire.fr author ID"
    , "P6604": "Sandbox-Musical Notation"
    , "P6605": "Plant Illustrations artist ID"
    , "P6606": "study or design for"
    , "P6607": "constraint clarification"
    , "P6608": "General Material Designation"
    , "P6609": "value hierarchy property"
    , "P6610": "Ashmolean museum ID"
    , "P6611": "Semantic Scholar topic ID"
    , "P6612": "FFS athlete ID"
    , "P6613": "CSKA person ID"
    , "P6614": "Libreflix ID"
    , "P6615": "Kicker.de player ID (former scheme)"
    , "P6616": "Library of Parliament of Canada person ID"
    , "P6617": "RoMEO publisher ID"
    , "P6618": "Federal-State Cooperative System ID"
    , "P6619": "XING company ID"
    , "P6620": "L'Express person ID"
    , "P6621": "Le Figaro tag ID"
    , "P6622": "Le Parisien tag ID"
    , "P6623": "Gamepedia article ID"
    , "P6624": "FSkate.ru skater ID"
    , "P6625": "Salvador Dali Museum ID"
    , "P6626": "Index to American Botanical Literature ID"
    , "P6627": "FaroeSoccer player ID"
    , "P6628": "FaroeSoccer coach ID"
    , "P6629": "Artcurial lot ID"
    , "P6630": "SNISB ID"
    , "P6631": "Tainacan MHN ID"
    , "P6632": "100 bombardirov person ID"
    , "P6633": "Cini Foundation ID"
    , "P6634": "LinkedIn personal profile ID"
    , "P6635": "ACA author ID"
    , "P6636": "CDEC ID"
    , "P6637": "AWARE ID"
    , "P6639": "capacity factor"
    , "P6640": "JRC Names id"
    , "P6641": "Zomato ID"
    , "P6643": "TV Spielfilm series ID"
    , "P6644": "Fandango theater ID"
    , "P6645": "Stedelijk Museum Amsterdam ID"
    , "P6646": "JMdictDB ID"
    , "P6647": "Zagat ID"
    , "P6648": "position in Forsyth-Edwards Notation"
    , "P6649": "Democracy Club election ID"
    , "P6650": "Martindale-Hubbell profile"
    , "P6652": "Sumo Reference ID"
    , "P6653": "ETS Designated Institution code"
    , "P6654": "Periscope ID"
    , "P6655": "stroke order"
    , "P6656": "BHCL ID"
    , "P6657": "CHVRS Classification"
    , "P6658": "RCQ classification"
    , "P6659": "Baden-W\u00fcrttemberg protected area ID"
    , "P6660": "Rxivist author ID"
    , "P6661": "Rxivist preprint ID"
    , "P6662": "Springboks Rugby Player ID"
    , "P6663": "Utpictura18 artwork ID"
    , "P6664": "Le Vif tag ID"
    , "P6665": "Pro-Linux.de DBApp ID"
    , "P6666": "LibreGameWiki ID"
    , "P6667": "MARGS ID"
    , "P6668": "theatre-contemporain.net ID"
    , "P6669": "FIS telemark skier ID"
    , "P6670": "musical quotation or excerpt"
    , "P6671": "French public service directory ID"
    , "P6672": "Placar UOL Elei\u00e7\u00f5es ID"
    , "P6673": "Mem\u00f3rias da Ditadura ID"
    , "P6674": "Desaparecidos Pol\u00edticos ID"
    , "P6676": "OpenEdition text ID"
    , "P6677": "OpenEdition Books author ID"
    , "P6678": "WoRMS source ID"
    , "P6679": "e-teatr.pl play ID"
    , "P6680": "MeSH term ID"
    , "P6681": "EUNIS ID for habitats"
    , "P6682": "Motorsports Hall of Fame of America ID"
    , "P6683": "Alexander Turnbull Library ID"
    , "P6684": "first attested from"
    , "P6685": "Wikidata property example for media"
    , "P6686": "musical motif"
    , "P6687": "IANA timezone ID"
    , "P6688": "National Wrestling Hall of Fame wrestler ID"
    , "P6689": "MassBank accession ID"
    , "P6690": "CNV-SP ID"
    , "P6691": "GruCultura ID"
    , "P6692": "CEMDP ID"
    , "P6693": "NGMDb Prod ID"
    , "P6694": "MeSH concept ID"
    , "P6695": "number of sentences"
    , "P6696": "PRELIB organization ID"
    , "P6697": "Football Money League rank"
    , "P6698": "Japan Search name ID"
    , "P6699": "Yu-Gi-Oh! TCG cards ID"
    , "P6700": "Saxony protected area ID"
    , "P6701": "Referee.ru person ID"
    , "P6702": "Shanghai Library person ID"
    , "P6703": "Shanghai Library place ID"
    , "P6704": "FrogMAP ID"
    , "P6705": "Ming Qing Archive ID"
    , "P6706": "De Agostini ID"
    , "P6707": "approach angle"
    , "P6708": "departure angle"
    , "P6709": "L\u00f8\u00f8v classification"
    , "P6710": "linear reference"
    , "P6711": "data transfer speed"
    , "P6712": "precedes word-initial"
    , "P6713": "Australian War Memorial ID"
    , "P6714": "Whitney Museum of American Art artist ID"
    , "P6715": "SIUSA archive producer person ID"
    , "P6716": "MyNeta.info political party ID"
    , "P6717": "Indie DB video game ID"
    , "P6718": "music video"
    , "P6719": "specified by sense"
    , "P6720": "interwiki prefix at Wikimedia"
    , "P6721": "PPN ID"
    , "P6722": "FemBio ID"
    , "P6723": "BlackPast.org ID"
    , "P6724": "Trainline ID"
    , "P6725": "CatholicSaints.info ID"
    , "P6726": "NSW Capital Conviction ID"
    , "P6727": "Dimore Storiche Italiane ID"
    , "P6728": "Dictionnaire des Vend\u00e9ens ID"
    , "P6729": "SportSport.ba club ID"
    , "P6730": "CroRec ID"
    , "P6731": "Commons quality assessment"
    , "P6732": "VTB United League player ID"
    , "P6733": "National Taxonomy of Exempt Entities code"
    , "P6734": "Archaeology Data Service person ID"
    , "P6735": "Watercolour World artist ID"
    , "P6736": "Drobn\u00e9 pam\u00e1tky ID"
    , "P6737": "grwar.ru person ID"
    , "P6738": "Whitney Museum of American Art artwork ID"
    , "P6739": "Russia.tv actor profile ID"
    , "P6740": "Justia Patents assignee ID"
    , "P6741": "Kinosozvezdie biography ID"
    , "P6742": "Musixmatch track ID"
    , "P6743": "LNB Coach id"
    , "P6744": "FragDenStaat public body ID"
    , "P6745": "Orlando author ID"
    , "P6746": "Pam\u011b\u0165 n\u00e1roda ID"
    , "P6747": "Recreation.gov campground ID"
    , "P6748": "Interactive Fiction Database ID"
    , "P6749": "CanLII ID"
    , "P6750": "CineChile filmmaker ID"
    , "P6751": "Heritage Gazetteer of Libya ID"
    , "P6752": "RGALI ID"
    , "P6753": "number of polling stations"
    , "P6754": "OBIS ID"
    , "P6756": "Flora of Australia ID (new)"
    , "P6757": "exposure time"
    , "P6758": "supported sports team"
    , "P6759": "NARA record group number"
    , "P6760": "Know Your Meme ID"
    , "P6761": "NARA collection identifier"
    , "P6762": "FilmFreeway ID"
    , "P6763": "Dictionary of Anhui Writers ID"
    , "P6764": "V&A artist ID"
    , "P6765": "Guix Variable Name"
    , "P6766": "Who's on First ID"
    , "P6767": "FoodOn ID"
    , "P6768": "SportSport.ba news ID"
    , "P6769": "CJFD journal article ID"
    , "P6770": "Swiss National Sound Archives ID"
    , "P6771": "Arabic Ontology ID"
    , "P6772": "Buddhist Author Authority Database ID"
    , "P6773": "HAL structure ID"
    , "P6774": "Mod DB video game ID"
    , "P6775": "Finnish Trade Register ID"
    , "P6776": "IMTL.org ID"
    , "P6777": "Danskefilmstemmer.dk person ID"
    , "P6778": "OBO Gazetteer ID"
    , "P6780": "LGBTFansDB character ID"
    , "P6781": "ProofWiki ID"
    , "P6782": "ROR ID"
    , "P6783": "speedrun.com game ID"
    , "P6784": "Harper's author ID"
    , "P6785": "Pakistan Railways station code"
    , "P6786": "National Library of Wales Catalogue ID"
    , "P6787": "Arachne building ID"
    , "P6788": "messes.info Catholic parish ID"
    , "P6789": "ISO speed"
    , "P6790": "f-number"
    , "P6791": "The Atlantic author ID"
    , "P6792": "Find NZ Artists ID"
    , "P6793": "WMI code"
    , "P6794": "minimum wage"
    , "P6795": "Unified Social Credit Identifier"
    , "P6796": "OSZMI ID"
    , "P6797": "MSX Games World ID"
    , "P6798": "UPA transcription"
    , "P6799": "GLIMS ID"
    , "P6800": "sequenced genome URL"
    , "P6801": "number of hospital beds"
    , "P6802": "related image"
    , "P6803": "taxa found at location"
    , "P6804": "Art Gallery of South Australia creator ID"
    , "P6805": "Art Gallery of South Australia work ID"
    , "P6806": "racing-reference race ID"
    , "P6807": "racing-reference track ID"
    , "P6808": "SportSport.ba player ID"
    , "P6809": "Xikao History ID"
    , "P6810": "Xikao Repertoire ID"
    , "P6811": "Prazdne Domy architect ID"
    , "P6812": "AntWiki article ID"
    , "P6813": "Mediapart tag ID"
    , "P6814": "NWBib ID"
    , "P6815": "University of Amsterdam Album Academicum ID"
    , "P6816": "The Dragon Archive ID"
    , "P6817": "SVT Open archive"
    , "P6818": "calendar feed URL"
    , "P6819": "calligrapher"
    , "P6820": "Australian bank branch ID"
    , "P6821": "Uppsala University Alvin ID"
    , "P6822": "Tainacan MAI ID"
    , "P6823": "GNU ELPA package ID"
    , "P6824": "replacement property"
    , "P6825": "RFGS person ID"
    , "P6826": "feed-in tariff"
    , "P6827": "Igromania ID"
    , "P6828": "Czech parliament ID"
    , "P6829": "Dictionary of Irish Biography ID"
    , "P6830": "swMATH work ID"
    , "P6831": "Pinakes author ID"
    , "P6832": "IndicePA ID"
    , "P6833": "title in HTML"
    , "P6835": "title in LaTeX"
    , "P6836": "Pro-Football-Reference.com coach ID"
    , "P6837": "Keybase username"
    , "P6838": "Elhuyar Dictionary ID"
    , "P6839": "TV Tropes identifier"
    , "P6840": "student organization of"
    , "P6841": "ITF tournament ID"
    , "P6842": "Campendium ID"
    , "P6843": "Malaysia company number"
    , "P6844": "abART person ID"
    , "P6845": "abART document ID"
    , "P6846": "abART exhibition ID"
    , "P6847": "abART group ID"
    , "P6848": "abART institution ID"
    , "P6849": "DR topic ID"
    , "P6850": "ABA League ID"
    , "P6851": "Biographical Dictionary of Iowa ID"
    , "P6852": "CCDC Number"
    , "P6853": "Coco Game List ID"
    , "P6854": "Dimensions grant ID"
    , "P6855": "emergency services"
    , "P6856": "average speed"
    , "P6857": "JIS standard"
    , "P6858": "R\u00e9unionnais du monde ID"
    , "P6859": "Corporate Number (South Korea)"
    , "P6861": "dbSNP ID"
    , "P6862": "digilibLT author ID"
    , "P6863": "Digital Prosopography of the Roman Republic ID"
    , "P6864": "eBiodiversity ID"
    , "P6865": "eurobasket.com coach ID"
    , "P6866": "euroleague.net coach ID"
    , "P6867": "Gamepedia wiki ID"
    , "P6868": "Hoopla artist ID"
    , "P6869": "Hoopla publisher ID"
    , "P6870": "Latvian National Encyclopedia Online ID"
    , "P6871": "ECI Lok Sabha constituency code"
    , "P6872": "has written for"
    , "P6873": "IntraText author ID"
    , "P6874": "Musixmatch artist ID"
    , "P6875": "motif represents"
    , "P6876": "solar irradiance"
    , "P6877": "MAHG ID"
    , "P6878": "Amburger database ID"
    , "P6879": "effective temperature"
    , "P6880": "ATP tennis tournament edition ID"
    , "P6881": "Rugby League Project ID (general)"
    , "P6882": "RIAA artist ID"
    , "P6883": "LilyPond notation"
    , "P6884": "target muscle"
    , "P6885": "historical region"
    , "P6886": "writing language_code"
    , "P6887": "match interval"
    , "P6888": "MELPA package ID"
    , "P6889": "microarchitecture"
    , "P6890": "Nchdb asset ID"
    , "P6891": "National Film Board of Canada director identifier"
    , "P6892": "Fundamental.org Baptist Church ID"
    , "P6893": "Offizielle Deutsche Charts artist ID"
    , "P6894": "Beatport artist ID"
    , "P6895": "Bangladesh administrative division code (2017-)"
    , "P6896": "Djshop artist ID"
    , "P6897": "literacy rate"
    , "P6898": "NeoGeoSoft ID"
    , "P6899": "New York City Neighborhood Tabulation area ID"
    , "P6900": "NicoNicoPedia ID"
    , "P6901": "NooSFere edition ID"
    , "P6902": "era name"
    , "P6903": "ArtBrokerage artist ID"
    , "P6904": "ATRF ID"
    , "P6905": "Bebo profile ID"
    , "P6906": "National Library of Aruba ID"
    , "P6907": "BVLarramendi ID"
    , "P6908": "Cameo ID"
    , "P6909": "Charts in France artist ID"
    , "P6910": "CIN ID"
    , "P6911": "Dutch Charts artist ID"
    , "P6912": "Equipboard artist ID"
    , "P6913": "Facebook Gaming game ID"
    , "P6914": "Gaana.com artist ID"
    , "P6915": "Gambay ID"
    , "P6916": "Heritage Gazetteer of Cyprus"
    , "P6917": "Historical Archives of the European Union ID"
    , "P6918": "hitparade.ch artist ID"
    , "P6919": "Indian gallantry awardee ID"
    , "P6920": "Juno Download artist ID"
    , "P6921": "MangaSeek person ID"
    , "P6922": "Metro topic ID"
    , "P6923": "Moov artist ID"
    , "P6924": "Murfie artist ID"
    , "P6925": "Musicalics composer ID"
    , "P6926": "Nederlandse Top 40 artist ID"
    , "P6927": "NME artist ID"
    , "P6928": "PCE Daisakusen ID"
    , "P6929": "CUT code"
    , "P6930": "Pro Football Hall of Fame ID"
    , "P6931": "Repology project name"
    , "P6932": "RogerEbert.com film ID"
    , "P6933": "SA Flora ID"
    , "P6934": "Syriac Biographical Dictionary ID"
    , "P6935": "The DJ List artist ID"
    , "P6936": "Who's Who of American Comic Books ID"
    , "P6937": "SNBP ID"
    , "P6938": "seconded by"
    , "P6939": "moved by"
    , "P6940": "FPBR person ID"
    , "P6941": "PHI Latin Texts author ID"
    , "P6942": "animator"
    , "P6943": "VG-lista artist ID"
    , "P6944": "Bionomia ID"
    , "P6945": "Steam profile ID"
    , "P6946": "Find & Connect ID"
    , "P6947": "Goodreads series ID"
    , "P6948": "video system"
    , "P6949": "announcement date"
    , "P6950": "Scandipop topic ID"
    , "P6953": "2014 Commonwealth Games athlete ID"
    , "P6954": "access status"
    , "P6955": "El portal de M\u00fasica artist ID"
    , "P6956": "Balochistan EMIS code"
    , "P6957": "Khyber Pakhtunkhwa EMIS code"
    , "P6958": "Punjab EMIS code"
    , "P6959": "Sindh EMIS code"
    , "P6960": "IMVDb artist ID"
    , "P6962": "narrative motif"
    , "P6963": "BaFin Institute ID"
    , "P6964": "Musiikkituottajat artist (certyfication) ID"
    , "P6965": "IFPI Austria artist ID"
    , "P6966": "IFPI Danmark artist ID"
    , "P6967": "SNEP artist ID"
    , "P6968": "hitparade.ch artist (certyfication) ID"
    , "P6969": "BVMI artist ID"
    , "P6970": "Music Canada artist ID"
    , "P6971": "IFPI Norge artist ID"
    , "P6972": "Napster artist ID"
    , "P6973": "Personnel de l'administration pr\u00e9fectorale ID"
    , "P6975": "RBF professional boxer ID"
    , "P6976": "Retrosheet person ID"
    , "P6977": "review of"
    , "P6978": "Scandinavian middle family name"
    , "P6979": "SLNSW unpublished item ID"
    , "P6980": "LB.ua dossier ID"
    , "P6981": "ACNP journal ID"
    , "P6982": "Australian Faunal Directory publication ID"
    , "P6983": "Sverigetopplistan artist ID"
    , "P6984": "Rupa Publications author ID"
    , "P6985": "OYO Hotel ID"
    , "P6987": "Hungarian National Namespace place ID"
    , "P6988": "Hungarian National Namespace person ID"
    , "P6989": "Hungarian National Namespace organisation ID"
    , "P6992": "IMFDB ID"
    , "P6993": "Pro Kabaddi League player ID"
    , "P6994": "RBF amateur boxer ID"
    , "P6995": "National Transportation Safety Board report ID"
    , "P6996": "Epitafier.se ID"
    , "P6997": "magazine in BitArkivo.org"
    , "P6998": "iTunes movie collection ID"
    , "P6999": "Musisque Deoque author ID"
    , "P7000": "DigitalNZ ID"
    , "P7001": "PharmGKB ID"
    , "P7002": "Handball123 player ID"
    , "P7003": "ACMI web ID"
    , "P7004": "AtlasFor ID"
    , "P7005": "Adventure Gamers ID"
    , "P7006": "BIC of the Canary Islands ID"
    , "P7007": "Wolfram Language unit code"
    , "P7008": "unabbreviated text"
    , "P7009": "extracted from"
    , "P7010": "imprimitur granted by"
    , "P7011": "Russian organisation number"
    , "P7012": "World Encyclopedia of Puppetry Arts ID"
    , "P7013": "Anime Characters Database character ID"
    , "P7014": "terms of service URL"
    , "P7015": "surface gravity"
    , "P7017": "Anime Characters Database anime ID"
    , "P7018": "lexeme"
    , "P7019": "ANZCTR ID"
    , "P7020": "Arachne collection ID"
    , "P7021": "Arachne object ID"
    , "P7022": "Australian Suppliers Directory ID"
    , "P7023": "Biyografya ID"
    , "P7024": "Flemish Public Libraries ID"
    , "P7025": "HCIS ID"
    , "P7026": "Lebanese National Library ID"
    , "P7027": "MPG ID"
    , "P7028": "National Library of Luxembourg ID"
    , "P7029": "National Library of Russia ID"
    , "P7030": "National Pollutant Inventory ID"
    , "P7031": "Penguin India author ID"
    , "P7032": "Repertorium van ambtsdragers en ambtenaren id"
    , "P7033": "Australian Educational Vocabulary ID"
    , "P7034": "Syriaca work ID"
    , "P7035": "TuttoCalciatori.net coach ID"
    , "P7036": "TuttoCalciatori.net player ID"
    , "P7037": "COURAGE ID"
    , "P7038": "Documenta Catholica Omnia author ID"
    , "P7039": "National Library of Iceland ID"
    , "P7040": "NosD\u00e9put\u00e9s.fr identifiant"
    , "P7041": "Perseus author ID"
    , "P7042": "The Latin Library author ID"
    , "P7043": "TheTVDB episode ID"
    , "P7044": "Colonial Frontier Massacres ID"
    , "P7045": "chassis"
    , "P7046": "HOV-ID"
    , "P7047": "enemy of"
    , "P7048": "PBS Drug Code"
    , "P7049": "AICS Chemical ID"
    , "P7050": "Album of the Year artist ID"
    , "P7051": "Atlas of Living Australia ID"
    , "P7052": "Jaxsta profile ID"
    , "P7053": "Indian Super League player ID"
    , "P7054": "misas.org Catholic church ID"
    , "P7055": "Jaxsta release ID"
    , "P7056": "Jaxsta recording ID"
    , "P7057": "FEC Campaign Committee ID"
    , "P7058": "BNRM ID"
    , "P7059": "Premier Badminton League player ID"
    , "P7060": "NosS\u00e9nateurs.fr identifier"
    , "P7063": "U. S. Supreme Court docket number"
    , "P7064": "PBS Manufacturer ID"
    , "P7065": "Kerala state school code"
    , "P7066": "Taxonomicon ID"
    , "P7067": "Album of the Year album ID"
    , "P7068": "Gotlands museum"
    , "P7069": "IAAF competition category"
    , "P7070": "Musixmatch writer ID"
    , "P7071": "Qobuz artist ID"
    , "P7072": "wiki on WikiApiary"
    , "P7073": "extension on WikiApiary"
    , "P7074": "skin on WikiApiary"
    , "P7075": "mod of"
    , "P7076": "Zaragoza public art ID"
    , "P7077": "Paris Foreign Missions Society ID"
    , "P7078": "typing discipline"
    , "P7079": "shrinkage"
    , "P7080": "specific absorption rate"
    , "P7081": "quotation or excerpt"
    , "P7083": "surface roughness"
    , "P7084": "related category"
    , "P7085": "TikTok username"
    , "P7086": "start grade"
    , "P7087": "inverse label item"
    , "P7089": "AFCD PFKID"
    , "P7090": "Australian Marine Algal Name Index ID"
    , "P7091": "Common Sense Media ID"
    , "P7092": "Russian Fencing Federation fencer ID"
    , "P7093": "ABBBS Taxon ID"
    , "P7094": "WaterNSW Rivers and Streams Site No."
    , "P7095": "end grade"
    , "P7100": "Lens ID"
    , "P7101": "privacy policy URL"
    , "P7102": "Grand Canyon Trust ID"
    , "P7103": "start of covered period"
    , "P7104": "end of covered period"
    , "P7105": "LezWatch.TV actor ID"
    , "P7106": "LezWatch.TV character ID"
    , "P7107": "LezWatch.TV show ID"
    , "P7108": "location of the point of view"
    , "P7109": "Acharts.co artist ID"
    , "P7110": "Textile Connect publication ID"
    , "P7111": "08euro.Ru person ID"
    , "P7112": "CUP2002.RU person ID"
    , "P7113": "Euro04.Ru person ID"
    , "P7114": "Gazeta.Ru Euro 2012 person ID"
    , "P7115": "WorldCup10.Ru person ID"
    , "P7116": "Hiking Project trail ID"
    , "P7117": "Media Arts Database console games ID (obsolete)"
    , "P7118": "AMPAS collections film ID"
    , "P7119": "AMPAS collections person ID"
    , "P7120": "Douyin ID"
    , "P7121": "School code of the Ministry of Education, Taiwan"
    , "P7122": "opinion joined by"
    , "P7124": "date of the first one"
    , "P7125": "date of the latest one"
    , "P7126": "Mac OS type code"
    , "P7127": "AllTrails trail ID"
    , "P7128": "Archives Directory for the History of Collecting in America ID"
    , "P7129": "PEPC park ID"
    , "P7130": "Vidwan ID"
    , "P7131": "Bureau des longitudes ID"
    , "P7132": "ComingSoon.it film ID"
    , "P7133": "Cleartrip hotel ID"
    , "P7134": "Mojarto artist ID"
    , "P7135": "Rijksmonument complex ID"
    , "P7136": "Goibibo Hotel ID"
    , "P7137": "acknowledged"
    , "P7138": "Acharts.co chart ID"
    , "P7139": "ONF forest national ID"
    , "P7140": "M\u00fcnchen Wiki article ID"
    , "P7141": "measure number"
    , "P7142": "Poincar\u00e9 Papers person ID"
    , "P7143": "Acharts.co album ID"
    , "P7144": "NOTAM (FAA)"
    , "P7145": "CHESNO politician ID"
    , "P7146": "Rollerstory.net skater ID"
    , "P7148": "Nauka Ukrainy scientist ID"
    , "P7149": "OhRanger.com ID"
    , "P7150": "epigraph (literature)"
    , "P7151": "Wynk artist ID"
    , "P7152": "copyright exemption"
    , "P7153": "significant place"
    , "P7154": "Empik author ID"
    , "P7155": "WP Muzyka artist ID"
    , "P7156": "Interia Muzyka artist ID"
    , "P7157": "The Top Tens ID"
    , "P7159": "Plus Music artist ID"
    , "P7160": "manner of inhumane treatment"
    , "P7161": "Kinsky\u2013Halm Catalogue"
    , "P7162": "cases consolidated"
    , "P7163": "typically sells"
    , "P7164": "Raptekster.dk ID"
    , "P7165": "noun class"
    , "P7166": "Acharts.co song ID"
    , "P7167": "does not have effect"
    , "P7168": "FGrHist ID"
    , "P7169": "substitute director/manager"
    , "P7170": "register of real estate NKP"
    , "P7171": "Hacker News username"
    , "P7172": "shmup.com ID"
    , "P7173": "TA2 ID"
    , "P7174": "school class"
    , "P7175": "Gaana.com album ID"
    , "P7176": "XING profile ID"
    , "P7177": "Cinestaan film ID"
    , "P7178": "Cinestaan person ID"
    , "P7179": "Service d'Information sur les Etudes et les Professions Job ID"
    , "P7180": "Planespotters.net aircraft ID"
    , "P7181": "PLIA ID"
    , "P7182": "IBP 4-letter bird species alpha code"
    , "P7183": "EPW author ID"
    , "P7184": "Awards & Winners artist ID"
    , "P7185": "eska.pl topic ID"
    , "P7186": "Image-Line artist ID"
    , "P7187": "Jango artist ID"
    , "P7188": "LiveXLive artist ID"
    , "P7189": "mora artist ID"
    , "P7190": "RMF FM artist ID"
    , "P7191": "Supraphonline artist ID"
    , "P7192": "TuneIn artist ID"
    , "P7193": "YesAsia author ID"
    , "P7194": "AZLyrics.com artist ID"
    , "P7195": "Bandsintown artist ID"
    , "P7196": "musica.com artist ID"
    , "P7197": "OpenWeatherMap city ID"
    , "P7198": "RauteMusik artist ID"
    , "P7199": "Scribd publication ID"
    , "P7200": "SongMeanings artist ID"
    , "P7201": "SoundHound artist ID"
    , "P7202": "Belgian Species List ID"
    , "P7203": "Dizionario biografico dei Friulani ID"
    , "P7204": "Mafab.hu film ID"
    , "P7205": "jog.fm artist ID"
    , "P7206": "Lyrics007 artist ID"
    , "P7207": "moly.hu book ID"
    , "P7208": "Liber Liber author ID"
    , "P7209": "ordeal by"
    , "P7210": "GreatSong artist ID"
    , "P7211": "LINE BLOG user ID"
    , "P7212": "LyricsTranslate ID"
    , "P7213": "newspaper archive URL"
    , "P7214": "Allcinema person ID"
    , "P7215": "Eiga.com person ID"
    , "P7216": "MTV Polska artist ID"
    , "P7217": "MTV UK artist ID"
    , "P7218": "Vox FM artist ID"
    , "P7219": "periphrastic definition"
    , "P7220": "lexeme for periphrastic definition"
    , "P7221": "link for periphrastic definition"
    , "P7222": "Eiga.com movie ID"
    , "P7223": "Transfermarkt team ID"
    , "P7224": "Insects (Insecta) of the World ID"
    , "P7225": "BEACON ID"
    , "P7226": "RPGGeek ID"
    , "P7227": "DIBAVOD ID"
    , "P7228": "access restriction status"
    , "P7229": "Fundaci\u00f3n Goya en Arag\u00f3n ID"
    , "P7230": "AccuRadio artist ID"
    , "P7231": "eSTUD\u00c1NKY ID"
    , "P7232": "LongSwimsDB ID"
    , "P7233": "WTA trail ID"
    , "P7234": "Scribd item ID"
    , "P7235": "in defining formula"
    , "P7236": "Dove.org work ID"
    , "P7237": "Chinese Engineering Expert Tank ID"
    , "P7238": "Open Science Framework ID"
    , "P7241": "SCTrails trail ID"
    , "P7242": "Laws & Regulations Database of the Republic of China ID"
    , "P7243": "pronunciation"
    , "P7250": "mobile formatter URL"
    , "P7251": "Identification code for Japanese universities and colleges"
    , "P7252": "degree of difficulty"
    , "P7253": "color produced"
    , "P7254": "Pilze Deutschland ID"
    , "P7255": "Moose Deutschland ID"
    , "P7256": "computer performance"
    , "P7257": "Guia dos Quadrinhos artist ID"
    , "P7258": "Toons Mag ID"
    , "P7259": "Newspapers.com ID"
    , "P7260": "Transporter Classification Database ID"
    , "P7261": "use restriction status"
    , "P7262": "ESPN.com college football player ID"
    , "P7263": "Prime Pages ID"
    , "P7264": "FCC Grantee Code"
    , "P7265": "FNL player ID"
    , "P7266": "Guia dos Quadrinhos comic ID (Brazilian)"
    , "P7267": "Guia dos Quadrinhos publishing house ID (Brazilian)"
    , "P7268": "Guia dos Quadrinhos character ID"
    , "P7269": "Guia dos Quadrinhos comic ID"
    , "P7270": "Guia dos Quadrinhos publishing house ID"
    , "P7271": "Hiking Project area ID"
    , "P7272": "Hiking Project site ID"
    , "P7273": "National Equipment Registration System Supplier Number"
    , "P7274": "Naver Music album ID"
    , "P7275": "Naver Music artist ID"
    , "P7276": "New Encyclopedic Dictionary of Czech ID"
    , "P7277": "Pandora artist ID"
    , "P7278": "Peakbagger climber ID"
    , "P7279": "Peakbagger key col ID"
    , "P7280": "PlaymakerStats.com team ID"
    , "P7281": "Radio Equipment List Certification Number"
    , "P7282": "Slovo i Dilo person ID"
    , "P7283": "Spectrum Management System Company Number"
    , "P7284": "The Independent topic ID"
    , "P7285": "Writers Guild of America project ID"
    , "P7286": "Writers Guild of America writer ID"
    , "P7287": "WorldFootball.net team ID"
    , "P7288": "Bursa Malaysia stock code"
    , "P7289": "CPUID"
    , "P7290": "FCC Product Code"
    , "P7291": "L-number"
    , "P7292": "Arnet Miner publication ID"
    , "P7293": "PLWABN ID"
    , "P7294": "Itch.io URL"
    , "P7295": "Gregorian calendar start date"
    , "P7296": "Lower Austrian Museum ID"
    , "P7297": "cumulative elevation gain"
    , "P7298": "Auckland Museum ID"
    , "P7299": "MUBI film ID"
    , "P7300": "MUBI person ID"
    , "P7301": "Al-Jazeera topic ID"
    , "P7302": "Digital Giza ID"
    , "P7303": "Grammy Awards artist ID"
    , "P7304": "Highland Historic Environment Record ID"
    , "P7305": "Online PWN Encyclopedia"
    , "P7306": "Downdetector ID"
    , "P7307": "TOP500 System ID"
    , "P7308": "National Wildlife Refuge Trails ID"
    , "P7309": "climbing route"
    , "P7310": "Maine Trail Finder ID"
    , "P7311": "Aozora Bunko author ID"
    , "P7312": "Aozora Bunko work ID"
    , "P7313": "Rate Your Music label ID"
    , "P7314": "TDV \u0130slam Ansiklopedisi ID"
    , "P7315": "IP Code"
    , "P7316": "number of decimal digits"
    , "P7317": "iHeartRadio artist ID"
    , "P7318": "Behind The Voice Actors short ID"
    , "P7319": "ExplorePaTrails ID"
    , "P7320": "Labelcode"
    , "P7321": "Trail Finder ID"
    , "P7322": "Marine Regions Geographic IDentifier (MRGID)"
    , "P7323": "Archnet site ID"
    , "P7324": "iHeartRadio podcast ID"
    , "P7325": "DANE code"
    , "P7326": "MobyGames genre ID"
    , "P7327": "OFLC classification"
    , "P7328": "amount cataloged"
    , "P7329": "ICD-11 ID (MMS)"
    , "P7330": "Hardware Version Identification Number"
    , "P7331": "Letteraturaitaliana.net author ID"
    , "P7332": "NMM artist ID"
    , "P7333": "Pathway Ontology ID"
    , "P7334": "Vudu video ID"
    , "P7335": "Mixer game ID [OBSOLETE]"
    , "P7336": "GCF Reference"
    , "P7337": "Wi-Fi Certification ID"
    , "P7338": "regnal ordinal"
    , "P7339": "Rivals.com ID"
    , "P7340": "sixpackfilmdata film ID"
    , "P7341": "sixpackfilmdata person ID"
    , "P7342": "Direcci\u00f3n General de Bibliotecas ID"
    , "P7343": "Elitefootball player ID"
    , "P7344": "The Wind Power farm ID"
    , "P7345": "IGNrando' ID"
    , "P7346": "Fossiilid.info ID"
    , "P7347": "peer review URL"
    , "P7348": "Kivid.info ID"
    , "P7349": "Gazetteer for Scotland person ID"
    , "P7350": "Gazetteer for Scotland place ID"
    , "P7351": "FootballDatabase.eu team ID"
    , "P7352": "GENUKI ID"
    , "P7353": "NTS Radio artist ID"
    , "P7354": "Ticketmaster artist ID"
    , "P7355": "See Tickets artist ID"
    , "P7356": "DC Books author ID"
    , "P7357": "Diccionari de la Literatura Catalana ID"
    , "P7358": "FootballFacts.ru team ID"
    , "P7359": "LaPreferente.com player ID"
    , "P7360": "UEFA coach ID"
    , "P7361": "UEFA team ID"
    , "P7362": "Ukrainian Premier League  player ID"
    , "P7363": "ISSN-L"
    , "P7364": "FIDAL team ID"
    , "P7365": "China Martyrs ID"
    , "P7366": "FAIMER school ID"
    , "P7367": "content descriptor"
    , "P7368": "JournalBase ID"
    , "P7369": "National Library of Chile ID"
    , "P7370": "PCEngine Catalog Project ID"
    , "P7371": "Beatport label ID"
    , "P7372": "memoriademadrid publication ID"
    , "P7374": "educational stage"
    , "P7375": "MWNF URL"
    , "P7376": "worn by"
    , "P7377": "tussenvoegsel"
    , "P7378": "item disputed by"
    , "P7379": "fineness"
    , "P7380": "identified in image by"
    , "P7381": "PubPeer article ID"
    , "P7382": "Turkish Football Federation match ID"
    , "P7383": "name in hiero markup"
    , "P7384": "geograph.org.uk image ID"
    , "P7387": "Q-Codes ID"
    , "P7388": "Great Encyclopedia of Navarre ID"
    , "P7389": "Three Decks people ID"
    , "P7390": "Knesset Law ID"
    , "P7391": "graph radius"
    , "P7395": "DynamoMania.com player ID"
    , "P7396": "Beachsafe Beach Key"
    , "P7397": "247Sports ID"
    , "P7398": "Internet Off-Broadway Database production ID"
    , "P7399": "Futbolme player ID"
    , "P7400": "LibraryThing author ID"
    , "P7401": "SMHI drainage basin ID"
    , "P7402": "Turkish Football Federation stadium ID"
    , "P7403": "Publons publisher ID"
    , "P7404": "ADL Hate Symbols Database ID"
    , "P7405": "Turkish Football Federation referee ID"
    , "P7406": "style of karate"
    , "P7407": "name (image)"
    , "P7408": "EconBiz publication ID"
    , "P7409": "ERIC publication ID"
    , "P7410": "Healthcare Common Procedure Coding System Identifier"
    , "P7411": "Pubs Galore ID"
    , "P7412": "ForaDeJogo.net team ID"
    , "P7413": "Ancient Tree Inventory ID"
    , "P7414": "State Catalogue of the Museum Fund of Russia museum ID"
    , "P7415": "code (image)"
    , "P7416": "folio(s)"
    , "P7417": "image of backside"
    , "P7418": "image of frontside"
    , "P7419": "gender educated"
    , "P7420": "image with frame"
    , "P7421": "line(s)"
    , "P7422": "minimum temperature record"
    , "P7423": "Professional Football League of Ukraine player ID"
    , "P7425": "Rotterdam City Archives actor ID"
    , "P7427": "FreeBSD port"
    , "P7428": "Bluetooth Declaration ID"
    , "P7429": "Bundle ID"
    , "P7430": "Dictionary of Sculptors in Britain ID"
    , "P7431": "Wolfram Language quantity ID"
    , "P7432": "Steam bundle ID"
    , "P7433": "FantLab author ID"
    , "P7434": "NAD place ID"
    , "P7435": "EU-Football.info referee ID"
    , "P7436": "WorldReferee.com referee ID"
    , "P7437": "FantLab award ID"
    , "P7438": "FantLab publisher ID"
    , "P7439": "FantLab work ID"
    , "P7440": "FIG gymnast (no licence) identifier"
    , "P7441": "WorldFootball.net competition ID"
    , "P7442": "glacier status"
    , "P7443": "number of processor threads"
    , "P7444": "Rijksmuseum Research Library authority ID"
    , "P7445": "Basis Wien person ID"
    , "P7446": "Basis Wien institution ID"
    , "P7447": "Basis Wien event ID"
    , "P7448": "Basis Wien object ID"
    , "P7449": "NARCIS researcher ID"
    , "P7450": "Turkish Football Federation team ID"
    , "P7451": "Czech Fortuna liga player ID"
    , "P7452": "reason for preferred rank"
    , "P7453": "90minut.pl team ID"
    , "P7454": "Soccerbase team ID"
    , "P7455": "Transfermarkt match ID"
    , "P7456": "AAAS keyword ID"
    , "P7457": "creator's signature"
    , "P7458": "Kinematoscope film ID"
    , "P7459": "CanadaSoccer.com person ID"
    , "P7460": "FlashScore.com match ID"
    , "P7461": "Publons journals/conferences ID"
    , "P7462": "graph diameter"
    , "P7463": "EU-Football.info manager ID"
    , "P7464": "Genetics Home Reference Conditions ID"
    , "P7465": "Soccerbase referee ID"
    , "P7466": "Edvard Munch's correspondance person ID"
    , "P7467": "Broadway Photographs person ID"
    , "P7468": "MOHW HospID"
    , "P7469": "orientation"
    , "P7470": "URN formatter"
    , "P7471": "iNaturalist place ID"
    , "P7472": "National Marine Biological Library authority ID"
    , "P7473": "Neliti Journal ID"
    , "P7474": "Online Cenotaph ID"
    , "P7475": "dp.ru person ID"
    , "P7476": "iFixit teardown ID"
    , "P7477": "Internet Content Provider Registration Record ID"
    , "P7478": "iFixit repairability score (DEPRECATED)"
    , "P7479": "key col"
    , "P7480": "Brazilian federal deputy ID"
    , "P7481": "variety of form"
    , "P7482": "source of file"
    , "P7483": "CinemaRx person ID"
    , "P7484": "Kinematoscope film director ID"
    , "P7485": "Kinematoscope writer ID"
    , "P7486": "grammatical aspect"
    , "P7487": "Kinematoscope literary work ID"
    , "P7488": "BDFutbol team ID"
    , "P7489": "Stathletics ID"
    , "P7490": "Teams.by team ID"
    , "P7491": "Austrian Parliament 1848 - 1918 ID"
    , "P7492": "EU-Football.info match ID"
    , "P7493": "PlaymakerStats.com match ID"
    , "P7494": "Soccerway match ID"
    , "P7495": "Fussballdaten.de team ID"
    , "P7496": "NZPCN ID"
    , "P7497": "Wolfram Language entity type"
    , "P7498": "Women Film Pioneers ID"
    , "P7499": "Van Wijngaarden quarry ID"
    , "P7500": "comorbidity"
    , "P7501": "audio system"
    , "P7502": "Golden ID"
    , "P7503": "Ovrtur biography ID"
    , "P7504": "Jeugdliteratuur ID"
    , "P7505": "ACL Anthology article ID"
    , "P7506": "Naver Encyclopedia ID"
    , "P7507": "Ben Yehuda author ID"
    , "P7508": "election called by"
    , "P7509": "Estonian biographical database ID"
    , "P7510": "XML namespace"
    , "P7511": "doujinshi.org author ID"
    , "P7512": "startrek.com Database ID"
    , "P7513": "Alfred P. Sloan Foundation grant ID"
    , "P7514": "landscape architect"
    , "P7515": "Chinese Professional Baseball League player ID"
    , "P7516": "Software Preservation Society ID"
    , "P7517": "Sega Retro ID"
    , "P7518": "classicamiga ID"
    , "P7519": "Filmov\u00fd p\u0159ehled film ID"
    , "P7520": "Filmov\u00fd p\u0159ehled person ID"
    , "P7521": "Gaming-History company ID"
    , "P7522": "SK cinema authority ID"
    , "P7523": "SK cinema film ID"
    , "P7524": "CA PROP 65 ID"
    , "P7525": "ePSD identifier"
    , "P7526": "Czech cadastral area ID"
    , "P7527": "charge conjugation quantum number"
    , "P7528": "statement is regarded as spoiler for"
    , "P7529": "dp.ru company ID"
    , "P7530": "Fortuna liga player ID"
    , "P7531": "MEA Indian Mission ID"
    , "P7532": "room number"
    , "P7533": "AaRC person ID"
    , "P7534": "MIC market code"
    , "P7535": "scope and content"
    , "P7536": "Birds of India ID"
    , "P7537": "India Biodiversity Portal species ID"
    , "P7538": "Moths of India ID"
    , "P7539": "NBAIR pest ID"
    , "P7540": "Odonata of India ID"
    , "P7541": "Plan\u00e8te Aventure ID"
    , "P7542": "Reptiles of India ID"
    , "P7543": "ZSI author ID"
    , "P7544": "Indian Medicinal Plants Database ID"
    , "P7545": "askArt person ID"
    , "P7546": "Flowers of India ID"
    , "P7547": "National Health Portal hospital ID"
    , "P7548": "UK Lakes Portal ID"
    , "P7549": "Biodiversity of West Bengal species ID"
    , "P7550": "International Paralympic Committee athlete alphabetical ID"
    , "P7551": "Plusliga player ID"
    , "P7552": "Finnish Biodiversity Information Facility's Species List ID"
    , "P7553": "Sinemalar person ID"
    , "P7554": "Encyclopedia of Mathematics wiki ID"
    , "P7555": "UVL game ID"
    , "P7556": "UVL platform ID"
    , "P7558": "Inguma database ID"
    , "P7559": "Ahotsak Lexeme"
    , "P7560": "UVL company ID"
    , "P7561": "category for the interior of the item"
    , "P7562": "UVL group ID"
    , "P7563": "Home of the Underdogs game ID"
    , "P7564": "OGDB game title ID"
    , "P7565": "CISCE school code"
    , "P7566": "JNAF artist ID"
    , "P7567": "OGDB compilation ID"
    , "P7568": "CBSE affiliation number"
    , "P7569": "Wikimedia page-version URL"
    , "P7570": "OGDB company ID"
    , "P7571": "Memorial Book Bundesarchiv ID"
    , "P7572": "Digital Corpus of Sanskrit ID"
    , "P7573": "IFCO rating"
    , "P7574": "Swedish Royal Theater Archive"
    , "P7575": "Sri Granth Punjabi word ID"
    , "P7576": "Broadcast Radio Bearer URI"
    , "P7577": "Czech city district ID"
    , "P7578": "DUC ID"
    , "P7579": "Prague administrative district ID"
    , "P7580": "AboutTheArtists artist ID"
    , "P7581": "IAST transliteration"
    , "P7582": "Wildlife Protection Act 1972 (India) schedule"
    , "P7583": "fyyd podcast ID"
    , "P7584": "age estimated by a dating method"
    , "P7585": "NinDB game ID"
    , "P7586": "Cinepub person ID"
    , "P7587": "eFloraSA ID"
    , "P7588": "effective date"
    , "P7589": "date of assent"
    , "P7590": "eBay username"
    , "P7591": "VideoGameGeek game ID"
    , "P7592": "VideoGameGeek platform ID"
    , "P7593": "CinePT film ID"
    , "P7594": "CinePT person ID"
    , "P7595": "Disney+ movie ID"
    , "P7596": "Disney+ series ID"
    , "P7597": "Lutris game ID"
    , "P7598": "ascending scale"
    , "P7599": "descending scale"
    , "P7600": "primary note"
    , "P7601": "secondary note"
    , "P7602": "Ratingraph actor ID"
    , "P7603": "CITES Appendix"
    , "P7604": "supervised by"
    , "P7605": "Hunterian transliteration"
    , "P7606": "Czech municipality ID"
    , "P7607": "WikiTree category or space"
    , "P7608": "Englandstats.com Soccer ID"
    , "P7609": "SHARE Catalogue work ID"
    , "P7610": "Taiwan Cinema company ID"
    , "P7611": "Taiwan Cinema film ID"
    , "P7612": "Taiwan Cinema person ID"
    , "P7613": "Biblioteche dei filosofi ID"
    , "P7614": "Dictionary of Wisconsin History ID"
    , "P7615": "Finnish generals and admirals in the Imperial Russian Army 1809\u20131917 ID"
    , "P7616": "Lutris genre ID"
    , "P7617": "Lutris platform ID"
    , "P7618": "Virginia Landmarks Register ID"
    , "P7619": "The Cardinals of the Holy Roman Church ID"
    , "P7620": "Treccani's Enciclopedia dei Papi ID"
    , "P7621": "Church Heritage Cymru ID"
    , "P7622": "TheGamesDB game ID"
    , "P7623": "TheGamesDB platform ID"
    , "P7624": "YVNG ID"
    , "P7625": "WPI ID"
    , "P7626": "NVE powerplant ID"
    , "P7627": "Artsdata.ca ID"
    , "P7630": "Dictionary of Scottish Architects building ID"
    , "P7631": "MPPDA Digital Archive film ID"
    , "P7632": "MPPDA Digital Archive organisation ID"
    , "P7633": "MPPDA Digital Archive person ID"
    , "P7634": "TheGamesDB developer ID"
    , "P7635": "administrative district of Czech municipality with authorized municipal office ID"
    , "P7636": "administrative district of Czech municipality with expanded powers ID"
    , "P7637": "IDU theatre company ID"
    , "P7638": "OverDrive creator ID"
    , "P7639": "OverDrive publisher ID"
    , "P7641": "MTV Germany artist ID"
    , "P7642": "TheGamesDB publisher ID"
    , "P7643": "covered period"
    , "P7644": "Encyclopedia of Cleveland History ID"
    , "P7645": "RomanianActors person ID"
    , "P7646": "IISG ID"
    , "P7647": "Cochrane concept ID"
    , "P7648": "OverDrive series ID"
    , "P7649": "Vectrex Game Database ID"
    , "P7650": "WeChat ID"
    , "P7651": "Hoopla series ID"
    , "P7652": "Germany06.Ru person ID"
    , "P7653": "MovieGe person ID"
    , "P7654": "Ratingraph actress ID"
    , "P7655": "Speiderhistorisk leksikon ID"
    , "P7656": "Arolsen ID"
    , "P7657": "Doctrine court decision ID"
    , "P7658": "Juricaf decision ID"
    , "P7659": "POWiS ID"
    , "P7660": "super-famicom.jp ID"
    , "P7661": "GameFAQs credit ID"
    , "P7662": "Scilit journal ID"
    , "P7663": "Scienza a due voci ID"
    , "P7665": "FMV World ID"
    , "P7666": "Visuotin\u0117 lietuvi\u0173 enciklopedija ID"
    , "P7667": "Hellenic Civil Aviation Authority airport code"
    , "P7668": "file page"
    , "P7669": "NEC Retro ID"
    , "P7670": "Prog Archives artist ID"
    , "P7671": "Semion author ID"
    , "P7672": "Musiikkituottajat artist ID"
    , "P7673": "Czech district ID"
    , "P7674": "Czech region ID"
    , "P7675": "Vie publique intervention ID"
    , "P7676": "Vie publique person ID"
    , "P7677": "www.gesetze-im-internet.de ID"
    , "P7678": "Wikimapia ID"
    , "P7679": "Cin\u00e9polis KLIC ID"
    , "P7680": "Colorado Encyclopedia ID"
    , "P7681": "Israel Museum Jerusalem artist ID"
    , "P7682": "National Library of New Zealand ID"
    , "P7683": "OpenRetro Game Database ID"
    , "P7684": "Vie publique report ID"
    , "P7685": "CALS Encyclopedia of Arkansas ID"
    , "P7686": "Encyclopedia of the Great Plains ID"
    , "P7687": "Kansaspedia ID"
    , "P7688": "Mississippi Encyclopedia ID"
    , "P7689": "Online Nevada Encyclopedia ID"
    , "P7690": "South Carolina Encyclopedia ID"
    , "P7691": "The Oregon Encyclopedia ID"
    , "P7692": "Utah History Encyclopedia ID"
    , "P7693": "WyoHistory.org Encyclopedia ID"
    , "P7694": "Aberdeenshire HER ID"
    , "P7695": "e-WV: The West Virginia Encyclopedia ID"
    , "P7696": "Fran\u00e7ais libres ID"
    , "P7697": "Maine: An Encyclopedia ID"
    , "P7698": "Mus\u00e9e de la R\u00e9sistance ID"
    , "P7699": "National Library of Lithuania ID"
    , "P7700": "Slovak National Library ID"
    , "P7701": "SNESmusic.org game ID"
    , "P7702": "The Sierra Chest ID"
    , "P7703": "Spanish Quora topic ID"
    , "P7704": "Europeana entity"
    , "P7705": "superfamicom.org URL"
    , "P7706": "nominalized form"
    , "P7707": "PlayStation DataCenter URL"
    , "P7708": "SNESmusic.org company ID"
    , "P7709": "ScienceOpen author ID"
    , "P7710": "ScienceOpen publication ID"
    , "P7711": "Joconde author ID"
    , "P7712": "Joconde domain ID"
    , "P7713": "SNESmusic.org composer ID"
    , "P7714": "tDAR creator ID"
    , "P7715": "World Flora Online ID"
    , "P7716": "ACMA Broadcast Service Licence Number"
    , "P7717": "Vaare falne ID"
    , "P7718": "Complex Portal accession ID"
    , "P7719": "generalization of"
    , "P7720": "Fossilworks ID for journal article"
    , "P7721": "Wikispore ID"
    , "P7722": "TLFi ID"
    , "P7723": "The Encyclopedia of Oklahoma History and Culture ID"
    , "P7724": "Littr\u00e9 ID"
    , "P7725": "litter size"
    , "P7726": "PlanetMath ID"
    , "P7727": "legislative committee"
    , "P7729": "GUI number"
    , "P7730": "ZX81 Collection publisher ID"
    , "P7731": "ZX81 Collection ID"
    , "P7732": "DAF ID"
    , "P7733": "Computer Emuzone game ID"
    , "P7734": "console music history ID"
    , "P7735": "Czech cohesion region ID"
    , "P7736": "Czech territorial region ID"
    , "P7737": "deviantArt account ID"
    , "P7738": "EEPS ID"
    , "P7739": "Garaph game ID"
    , "P7740": "Garaph group ID"
    , "P7741": "IDFA film ID"
    , "P7742": "Lithuanian Football Encyclopedia player ID"
    , "P7743": "Microworld ID"
    , "P7744": "Mille Anni di Scienza in Italia ID"
    , "P7745": "Movie Walker person ID"
    , "P7746": "Natural Product Atlas ID"
    , "P7747": "NES Cart Database ID"
    , "P7748": "NIPS Proceedings author ID"
    , "P7749": "Nomenclature for Museum Cataloging"
    , "P7750": "Nonfiction ID"
    , "P7751": "portable music history ID"
    , "P7752": "Prague territorial district ID"
    , "P7753": "Projekt Gutenberg-DE ID"
    , "P7754": "PS photographer ID"
    , "P7755": "ScreenScraper company ID"
    , "P7756": "ScreenScraper game ID"
    , "P7757": "ScreenScraper platform ID"
    , "P7758": "SPIE profile ID"
    , "P7759": "The Video Games Museum system ID"
    , "P7760": "Tubi movie ID"
    , "P7761": "Tubi series ID"
    , "P7762": "VBProfiles person ID"
    , "P7763": "copyright status as a creator"
    , "P7764": "Archives Portal Europe ID"
    , "P7765": "DES ID"
    , "P7766": "Bob ID"
    , "P7767": "serving temperature"
    , "P7768": "Australian National Maritime Museum object ID"
    , "P7769": "Australian National Maritime Museum person ID"
    , "P7770": "egg incubation period"
    , "P7771": "PersonalData.IO ID"
    , "P7772": "Atlas Obscura identifier"
    , "P7773": "The Digital Local Culture Encyclopedia of Korea ID"
    , "P7774": "The Good Old Days ID"
    , "P7775": "RationalWiki ID"
    , "P7776": "SSNE person ID"
    , "P7777": "AdoroCinema film ID"
    , "P7778": "Museum of Modern Art online exhibition ID"
    , "P7779": "member of military unit"
    , "P7780": "Russian PFL player ID"
    , "P7781": "exonerated of"
    , "P7782": "category for ship name"
    , "P7783": "J-GLOBAL ID"
    , "P7784": "LaunchBox Games Database developer ID"
    , "P7785": "LaunchBox Games Database game ID"
    , "P7786": "Joconde epoch ID"
    , "P7787": "heading"
    , "P7788": "openSUSE package"
    , "P7789": "Ten-Bruggencatenummer"
    , "P7790": "DLE RAE ID"
    , "P7791": "NTIS accession number"
    , "P7792": "PubAg ID"
    , "P7793": "filename in archive"
    , "P7794": "Games Database developer ID"
    , "P7795": "National September 11 Memorial ID"
    , "P7796": "BeWeb person ID"
    , "P7797": "BeWeb entity ID"
    , "P7798": "BeWeb family ID"
    , "P7799": "Apple IIGS France ID"
    , "P7800": "bauhaus.community ID"
    , "P7801": "CEEB K-12 school code"
    , "P7802": "D-MSX ID"
    , "P7803": "Decine21 person ID"
    , "P7804": "dovidka.com.ua person ID"
    , "P7805": "Games Database publisher ID"
    , "P7806": "Games Database system ID"
    , "P7807": "ICD-11 (foundation)"
    , "P7808": "kino-teatr.ru person ID"
    , "P7809": "LaunchBox Games Database platform ID"
    , "P7810": "LaunchBox Games Database publisher ID"
    , "P7811": "Macintosh Garden game ID"
    , "P7812": "Macintosh Repository ID"
    , "P7813": "Open Churches ID"
    , "P7814": "OpenBibArt ID"
    , "P7815": "textove.com artist ID"
    , "P7816": "textove.com song ID"
    , "P7817": "Electronic library Ukrainica ID"
    , "P7818": "French Vikidia ID"
    , "P7819": "OrthodoxWiki ID (English)"
    , "P7820": "Punjabipedia ID"
    , "P7821": "Sarvavijnanakosam ID"
    , "P7822": "Italian Vikidia ID"
    , "P7823": "BookBrainz work ID"
    , "P7824": "CPCWiki ID"
    , "P7825": "UCUM code"
    , "P7826": "VGMPF ID"
    , "P7827": "Spanish Vikidia ID"
    , "P7828": "What is the Apple IIGS? ID"
    , "P7829": "English Vikidia ID"
    , "P7830": "LiverTox ID"
    , "P7831": "NMVW id"
    , "P7832": "Basque Vikidia ID"
    , "P7834": "Authenticus ID"
    , "P7835": "Instituto Moreira Salles ID"
    , "P7836": "Livelib.ru person ID"
    , "P7837": "Nederlands Fotomuseum photographer ID"
    , "P7838": "Polish Nationwide Railway Database - station ID"
    , "P7839": "Saregama artist ID"
    , "P7840": "ScummVM wiki ID"
    , "P7841": "Armenian Vikidia ID"
    , "P7842": "Vienna History Wiki ID"
    , "P7843": "German Vikidia ID"
    , "P7844": "Joconde object type ID"
    , "P7845": "MarketScreener business leaders ID"
    , "P7846": "Beta ma\u1e63\u0101\u1e25\u01ddft ID"
    , "P7847": "DigitaltMuseum ID"
    , "P7848": "Frick Art Reference Library Artist File ID"
    , "P7849": "Panoptikum podcast episode ID"
    , "P7850": "Joconde location ID"
    , "P7851": "Identifier for a resource held by the Smithsonian Institution"
    , "P7852": "C64.COM ID"
    , "P7853": "c64games.de ID"
    , "P7854": "EU-Football.info club ID"
    , "P7855": "attested as"
    , "P7856": "museum in Salzburg (AT) ID"
    , "P7857": "fyyd podcast episode ID"
    , "P7858": "Upper Austria Museum ID"
    , "P7859": "WorldCat Identities ID"
    , "P7860": "word in DEJ of RAE ID"
    , "P7861": "category for files created with program"
    , "P7862": "period of lactation"
    , "P7863": "aperture"
    , "P7864": "HAL article ID"
    , "P7865": "CoBiS author ID"
    , "P7866": "marterl.at ID"
    , "P7867": "category for maps"
    , "P7868": "NPDRMI record ID"
    , "P7869": "Analysis & Policy Observatory node ID"
    , "P7870": "Analysis & Policy Observatory term ID"
    , "P7871": "PCBdB game ID"
    , "P7872": "Diccionari del cinema a Catalunya ID"
    , "P7873": "EFIS film festival ID"
    , "P7874": "EFIS person ID"
    , "P7875": "Eurogamer ID"
    , "P7876": "FlashScore.com team ID"
    , "P7877": "GameStar ID"
    , "P7878": "Soccerdonna team ID"
    , "P7879": "The Video Games Museum game ID"
    , "P7880": "Voetbal International player ID"
    , "P7881": "Games Database game ID"
    , "P7882": "ft.dk politician identifier"
    , "P7883": "Historical Marker Database ID"
    , "P7884": "Joconde inscription ID"
    , "P7885": "Joconde time period ID"
    , "P7886": "Media Arts Database ID"
    , "P7887": "number of reviews/ratings"
    , "P7888": "merged into"
    , "P7889": "Cambridge Encyclopedia of Anthropology ID"
    , "P7890": "8-bits.info URL"
    , "P7891": "EFIS filmfirm ID"
    , "P7892": "EFIS film ID"
    , "P7893": "Ci\u00eancia ID"
    , "P7894": "Swedish School Registry ID"
    , "P7895": "Whaling History ID"
    , "P7896": "Academia.edu publication ID"
    , "P7897": "TI-99/4A Videogame House ID"
    , "P7898": "National Aviation Hall of Fame ID"
    , "P7899": "MOCAGH ID"
    , "P7900": "Denkmalatlas Niedersachsen Objekt-ID"
    , "P7901": "Encyclopedia of Chicago ID"
    , "P7902": "Deutsche Biographie ID"
    , "P7903": "gained territory from"
    , "P7904": "gave up territory to"
    , "P7905": "AnimalBase ID"
    , "P7906": "Canmore maritime-type ID"
    , "P7907": "Canmore object-type ID"
    , "P7908": "Clavis Clavium ID"
    , "P7909": "Can You Run it ID"
    , "P7910": "DANFS ship ID"
    , "P7911": "Gamekult company ID"
    , "P7912": "Gamekult franchise ID"
    , "P7913": "Gamekult game ID"
    , "P7914": "Gamekult platform ID"
    , "P7915": "GBAtemp game ID"
    , "P7916": "Mendeley publication ID"
    , "P7917": "Museums in Austria Code"
    , "P7918": "M\u00e9dias 19 ID"
    , "P7919": "SerialStation game ID"
    , "P7920": "TheTVDB person ID"
    , "P7921": "TrueAchievements series ID"
    , "P7922": "Canmore monument-type ID"
    , "P7923": "Bollywood Hungama person alphabetic ID"
    , "P7924": "Bibliotheca Hagiographica Latina ID"
    , "P7925": "Jurisdiction List number"
    , "P7926": "Visual AIDS Artist+ Registry ID"
    , "P7927": "Open Food Facts label"
    , "P7928": "BioLexSOE ID"
    , "P7929": "Roglo person ID"
    , "P7930": "Wikimedia community discussion URL"
    , "P7931": "Adelsvapen ID"
    , "P7932": "Irish playography play ID"
    , "P7934": "Irish playography person ID"
    , "P7935": "Corpus Corporum author ID"
    , "P7936": "business model"
    , "P7937": "format of creative work"
    , "P7938": "associated electoral district"
    , "P7939": "Dansk kvindebiografisk leksikon ID"
    , "P7940": "Adventure Gamers company ID"
    , "P7941": "Biografisch Woordenboek van Nederland: 1880-2000 ID"
    , "P7942": "National Historic Lookout Register ID"
    , "P7943": "The Washington Post contributor ID"
    , "P7944": "DoME artist ID"
    , "P7945": "ArchiWebture ID"
    , "P7946": "Museu de Memes ID"
    , "P7947": "WeChangEd ID"
    , "P7948": "GreatSchools ID"
    , "P7949": "Czech War Graves Register"
    , "P7950": "Marvel Comics creators ID"
    , "P7951": "DC Comics talent ID"
    , "P7952": "The First Amendment Encyclopedia ID"
    , "P7953": "Indiegogo project ID"
    , "P7954": "RealGM basketball coach ID"
    , "P7955": "Global Music Rights work ID"
    , "P7956": "SESAC work number"
    , "P7957": "Directory of Ma\u00eetres d'art"
    , "P7958": "Chicago Landmarks ID"
    , "P7959": "historic county"
    , "P7960": "Joconde discovery ID"
    , "P7961": "Joconde creation ID"
    , "P7962": "Dictionnaire des femmes de l\u2019ancienne France ID"
    , "P7963": "Cell Ontology ID"
    , "P7964": "corresponding HTML autocomplete attribute"
    , "P7965": "Scilit work ID"
    , "P7966": "NetBSD package"
    , "P7967": "OpenBSD port"
    , "P7968": "VR GameCritic ID"
    , "P7969": "DAR ancestor ID"
    , "P7970": "FandangoNow ID"
    , "P7971": "food energy"
    , "P7972": "CVR person ID"
    , "P7973": "quantity symbol (LaTeX)"
    , "P7974": "Facult\u00e9 des sciences de Nancy ID"
    , "P7975": "Filmfront film ID"
    , "P7976": "stargate-wiki.de article"
    , "P7977": "AncientFaces person ID"
    , "P7978": "Decine21 film ID"
    , "P7979": "ACM conference ID"
    , "P7980": "Clavis Patrum Latinorum ID"
    , "P7981": "ExoticA ID"
    , "P7982": "Hrvatska enciklopedija ID"
    , "P7983": "ACM Journal ID"
    , "P7984": "depicted format"
    , "P7985": "Kanopy ID"
    , "P7986": "Mirabile author ID"
    , "P7987": "Bibliotheca Hagiographica Graeca ID"
    , "P7988": "Clavis Patrum Graecorum ID"
    , "P7989": "Mirabile manuscript ID"
    , "P7990": "Mirabile saint ID"
    , "P7991": "Mirabile title ID"
    , "P7992": "Poeti d'Italia in lingua latina author ID"
    , "P7993": "Treccani's Dizionario di Filosofia ID"
    , "P7994": "Colecovision Zone ID"
    , "P7995": "NHS Health A to Z ID"
    , "P7996": "EH.Net Encyclopedia of Economic and Business History ID"
    , "P7997": "Gry Online company ID"
    , "P7998": "Podchaser podcast ID"
    , "P7999": "Haz-Map ID"
    , "P8000": "electron configuration"
    , "P8001": "endorsed by"
    , "P8002": "Social Security number"
    , "P8003": "ColecoVision.dk ID"
    , "P8004": "ordered by"
    , "P8005": "research subject recruitment status"
    , "P8006": "footedness"
    , "P8007": "US Bureau of Prisons Inmate Register Number"
    , "P8008": "Google Scholar case ID"
    , "P8009": "IM channel"
    , "P8010": "number of recoveries"
    , "P8011": "number of clinical tests"
    , "P8012": "Adventure Gamers series ID"
    , "P8013": "Trakt.tv ID"
    , "P8014": "Compendium heroicum ID"
    , "P8015": "Encyclopedia on Early Childhood Development ID (English)"
    , "P8016": "Encyclop\u00e9die sur le d\u00e9veloppement des jeunes enfants ID"
    , "P8017": "generational suffix"
    , "P8018": "IGCD game ID"
    , "P8019": "Kickstarter project ID"
    , "P8020": "Gram.pl game ID"
    , "P8021": "Kooora/Goalzz player ID"
    , "P8022": "RFI Musique artist ID"
    , "P8023": "VideoGamer.com game ID"
    , "P8024": "Nobel Laureate API ID"
    , "P8025": "VGMRips system ID"
    , "P8026": "LiverTox likelihood score"
    , "P8027": "VGMRips company ID"
    , "P8028": "GameRevolution game ID"
    , "P8029": "PIV Online ID"
    , "P8030": "size designation"
    , "P8031": "perpetrator"
    , "P8032": "victim"
    , "P8033": "Movie Review Query Engine ID"
    , "P8034": "VcBA ID"
    , "P8035": "m3db.com film ID"
    , "P8036": "m3db.com person ID"
    , "P8037": "Filmfront person ID"
    , "P8038": "SIUSA archive conservator ID"
    , "P8039": "National Register of Historic Monuments in Bosnia and Herzegovina ID"
    , "P8040": "RPGamer game ID"
    , "P8041": "DR music artist ID"
    , "P8042": "PC Games Database.de game ID"
    , "P8043": "ELAR ID"
    , "P8044": "Frankfurter Personenlexikon ID"
    , "P8045": "organized response related to outbreak"
    , "P8046": "Latvian transcription"
    , "P8047": "country of registry"
    , "P8048": "Women of Scotland memorial ID"
    , "P8049": "number of hospitalized cases"
    , "P8050": "Women of Scotland subject ID"
    , "P8051": "Geschichtsquellen des deutschen Mittelalters author ID"
    , "P8052": "MusicBrainz genre ID"
    , "P8053": "Latvian unified registration number"
    , "P8054": "ARK formatter"
    , "P8055": "Amazon Prime Video ID"
    , "P8056": "VGMRips composer ID"
    , "P8057": "Apache Project ID"
    , "P8058": "symbol of"
    , "P8059": "coinop.org game ID"
    , "P8060": "Glassdoor company ID"
    , "P8061": "AGROVOC ID"
    , "P8062": "Ameli ID"
    , "P8063": "BookBrainz publisher ID"
    , "P8064": "Chinese Clinical Trial Registry ID"
    , "P8065": "CIRIS author ID"
    , "P8066": "Colecovision Addict ID"
    , "P8067": "Macdonald Dictionary ID"
    , "P8068": "ToposText place ID"
    , "P8069": "ToposText person ID"
    , "P8070": "ToposText work ID"
    , "P8071": "BDSP ID"
    , "P8072": "CAB ID"
    , "P8073": "Cult of Saints in Late Antiquity ID"
    , "P8074": "Geschichtsquellen des deutschen Mittelalters work ID"
    , "P8075": "ScreenScraper group ID"
    , "P8076": "The Cover Project game ID"
    , "P8077": "FHF establishment ID"
    , "P8078": "FHF hospital group ID"
    , "P8079": "elibrary.ru person ID"
    , "P8080": "\u00d6kumenisches Heiligenlexikon ID"
    , "P8081": "WBIS ID"
    , "P8082": "Spanish National Catalog of Hospitals ID"
    , "P8083": "Visit Tuscany ID"
    , "P8084": "URL slug on Nintendo eShop"
    , "P8085": "Curran Index contributor ID"
    , "P8086": "ODMP person ID"
    , "P8087": "GameTDB game ID"
    , "P8088": "Elephind.com ID"
    , "P8089": "EZB ID"
    , "P8090": "GameReactor game ID"
    , "P8091": "Archival Resource Key"
    , "P8092": "EcuRed article"
    , "P8093": "donations"
    , "P8094": "GeneaStar person ID"
    , "P8095": "Encyklopedia Solidarno\u015bci ID"
    , "P8096": "Pinakes copyist or possessor ID"
    , "P8097": "network bands"
    , "P8098": "Biographical Dictionary of Architects in Canada ID"
    , "P8099": "I-Revues ID"
    , "P8100": "JournalTOCs ID"
    , "P8101": "MUSE article ID"
    , "P8102": "NASA active astronaut ID - DO NOT USE"
    , "P8103": "Paperity article ID"
    , "P8104": "Paperity journal ID"
    , "P8105": "SAN archive producer ID"
    , "P8106": "SOCAN work number"
    , "P8107": "bus"
    , "P8108": "Papers Past ID"
    , "P8109": "Pascal et Francis ID"
    , "P8110": "Retronews ID"
    , "P8111": "recommended unit of measurement"
    , "P8112": "CSS color keyword"
    , "P8113": "COTREX trail ID"
    , "P8114": "Wikiparques ID"
    , "P8115": "eligible recipient"
    , "P8116": "Encyclopedia of Brno Person ID"
    , "P8117": "FooDB compound ID"
    , "P8118": "Forest Stewardship Council Certificate Code"
    , "P8119": "HASC"
    , "P8120": "ModelSEED compound ID"
    , "P8121": "UM-BBD compound ID"
    , "P8122": "DLL Catalog author ID"
    , "P8123": "DLL Catalog work ID"
    , "P8124": "CPAN author ID"
    , "P8125": "Fandango performer ID"
    , "P8126": "Club Netherlands Handball Association ID"
    , "P8127": "tournament format"
    , "P8128": "Forest Stewardship Council License Code"
    , "P8129": "IDU theatre name unique ID"
    , "P8130": "Internetowy Polski S\u0142ownik Biograficzny ID"
    , "P8131": "dialect of computer language_code"
    , "P8132": "Texas Historic Sites Atlas ID"
    , "P8133": "Swedish Glaciers ID"
    , "P8134": "Soccerdonna coach ID"
    , "P8135": "Encyclopedia of \u010cesk\u00e9 Bud\u011bjovice ID"
    , "P8136": "Il Sole 24 Ore ID"
    , "P8137": "Inventory of Archaic and Classical Poleis ID"
    , "P8138": "located in the statistical territorial entity"
    , "P8139": "Moravian Lives ID"
    , "P8140": "motorsportstats.com driver ID"
    , "P8141": "motorsportstats.com series ID"
    , "P8142": "motorsportstats.com venue ID"
    , "P8143": "SAR ancestor ID"
    , "P8144": "Ternopil Encyclopedia ID"
    , "P8145": "Psocodea Species File ID"
    , "P8146": "SkiMo Stats ID"
    , "P8147": "National-Football-Teams.com club ID"
    , "P8148": "re:publica speaker ID"
    , "P8149": "Provenio ID"
    , "P8150": "COVIDWHO ID"
    , "P8151": "Sicilian Regional Assembly ID"
    , "P8152": "Sicilian Regional Assembly numeric ID"
    , "P8153": "Accademia delle Scienze di Torino ID"
    , "P8155": "Republic of Korea Parliamentarian Society ID"
    , "P8156": "NKAA ID"
    , "P8157": "M\u00e9morialGenWeb monument ID"
    , "P8158": "History Colorado ID"
    , "P8159": "SciProfiles ID"
    , "P8160": "Bibliotheca Augustana author ID"
    , "P8161": "CONI honoured ID"
    , "P8162": "DGHS facility code"
    , "P8163": "Diels-Kranz ID"
    , "P8164": "DPVweb ID"
    , "P8165": "Maryland's National Register Properties ID"
    , "P8166": "Encyclopaedia Metallum label ID"
    , "P8167": "WhatDoTheyKnow organisation ID"
    , "P8168": "FactGrid item ID"
    , "P8169": "Heritage Gateway ID"
    , "P8170": "RPPS ID"
    , "P8171": "Priset of Archidiecezja Gda\u0144ska ID"
    , "P8172": "Sejm-Wielki.pl profile ID"
    , "P8173": "Extratime.ie player ID"
    , "P8174": "Slovak Registration ID"
    , "P8175": "Infames Romani ID"
    , "P8176": "Itch.io developer profile"
    , "P8177": "Oregon Historic Sites Database ID"
    , "P8178": "motorsportstats.com team ID"
    , "P8179": "Canadiana NCF ID"
    , "P8180": "Indian Railways train number"
    , "P8181": "SNCF Station Identifier"
    , "P8182": "South African Company Registration Number"
    , "P8183": "general property-based URL formatter"
    , "P8184": "DART-Europe thesis ID"
    , "P8185": "DoME exhibition ID"
    , "P8186": "DPE school code"
    , "P8187": "Epistemonikos ID"
    , "P8188": "Lexikon der Filmbegriffe ID"
    , "P8189": "National Library of Israel J9U ID"
    , "P8190": "UK Modern House Index architect ID"
    , "P8191": "UK Modern House Index building ID"
    , "P8192": "Joconde technique ID"
    , "P8193": "hardiness of plant"
    , "P8194": "hardiness zone"
    , "P8195": "ex-libris"
    , "P8196": "voting system"
    , "P8197": "PragerU presenter ID"
    , "P8198": "regional government of Sicily ID"
    , "P8199": "Anagrafe Istituti Culturali Ecclesiastici ID"
    , "P8200": "BeWeb cultural institution ID"
    , "P8201": "ACUM work ID"
    , "P8202": "Reta Vortaro ID"
    , "P8203": "supported metadata"
    , "P8204": "tabular case data"
    , "P8205": "Mozilla Developer Network article"
    , "P8206": "Gazette of India notification"
    , "P8207": "The Conversation author ID"
    , "P8208": "tilt"
    , "P8209": "SILL software ID"
    , "P8210": "LombardiaBeniCulturali artwork author ID"
    , "P8211": "Bookogs work ID"
    , "P8212": "Gitabitan.net ID"
    , "P8213": "Arlington Cemetery person ID"
    , "P8214": "curriculum vitae"
    , "P8215": "CDAPNC author ID"
    , "P8216": "iDAI.chronontology ID"
    , "P8217": "iDAI.gazetteer ID"
    , "P8218": "Archaeology in Greece Online place ID"
    , "P8219": "ASUT ID"
    , "P8220": "NMMA antiquities ID"
    , "P8221": "NMMA built heritage ID"
    , "P8222": "rating.chgk.info ID"
    , "P8223": "K-Scholar ID"
    , "P8224": "molecular model or crystal lattice model"
    , "P8225": "is metaclass for"
    , "P8226": "Wyoming SHPO ID"
    , "P8227": "Lower Austrian Castle ID"
    , "P8228": "lighting"
    , "P8229": "Co-Optimus ID"
    , "P8230": "Bookogs credit ID"
    , "P8231": "Wiener Wohnen ID"
    , "P8232": "Arkansas Register of Historic Places ID"
    , "P8233": "Augustins de l'Assomption ID"
    , "P8234": "LiederNet author ID"
    , "P8235": "LiederNet composer ID"
    , "P8236": "LiederNet song cycle ID"
    , "P8237": "LiederNet text ID"
    , "P8238": "Bibliography of the History of Slovakia ID"
    , "P8239": "MACRIS ID"
    , "P8240": "National Register Database, Louisiana ID"
    , "P8241": "type of age limit"
    , "P8242": "Niden INE"
    , "P8243": "500 Queer Scientists profile"
    , "P8244": "Mediaqueer.ca artist ID"
    , "P8245": "Mediaqueer.ca movie ID"
    , "P8246": "Natural Atlas ID"
    , "P8247": "nominal share capital"
    , "P8248": "Colon Classification"
    , "P8249": "MDAH's HRI ID"
    , "P8250": "RI National Register Search ID"
    , "P8251": "CTHS author ID"
    , "P8253": "OSM Name Suggestion Index identifier"
    , "P8254": "PC Games Database.de company ID"
    , "P8255": "SNES central game ID"
    , "P8256": "Super Mario Wiki ID"
    , "P8257": "Wikilengua article"
    , "P8258": "field of training"
    , "P8259": "FlashScore.com player ID"
    , "P8260": "Aberdeen Built Ships ID"
    , "P8261": "Origin video game ID"
    , "P8262": "npm package"
    , "P8263": "curriculum topics"
    , "P8264": "attribution text"
    , "P8265": "based on tabular data"
    , "P8266": "FEMA number"
    , "P8267": "Mod DB mod ID"
    , "P8268": "Ubisoft Store game ID"
    , "P8269": "Norwegian prisoner register person ID"
    , "P8270": "ID natural monuments in Landkreis Oberspreewald-Lausitz"
    , "P8271": "LombardiaBeniCulturali architecture author ID"
    , "P8272": "BaGLAMa GID"
    , "P8273": "GMC registration number"
    , "P8274": "living people protection class"
    , "P8275": "position in biological sequence"
    , "P8276": "region within image"
    , "P8277": "AFL player ID"
    , "P8278": "serial identifier on SerialZone"
    , "P8279": "Absolute Games game ID"
    , "P8280": "Modelhub ID"
    , "P8281": "Liszt Academy Lexikon person ID"
    , "P8282": "Medusa NRHP ID"
    , "P8283": "ISCO-08 occupation code"
    , "P8284": "motorsportstats.com event ID"
    , "P8285": "LGBT Danmark online dictionary ID"
    , "P8286": "Olympedia athlete ID"
    , "P8287": "Worlds Without End author ID"
    , "P8289": "parish church"
    , "P8290": "Archivio Storico Ricordi person ID"
    , "P8291": "AusStage organization ID"
    , "P8292": "AusStage person ID"
    , "P8293": "AusStage venue ID"
    , "P8294": "AusStage work ID"
    , "P8295": "AustLit ID"
    , "P8296": "Cinema Context ID"
    , "P8297": "New York Times contributor ID"
    , "P8298": "HBO Max ID"
    , "P8299": "Semantic Scholar corpus ID"
    , "P8300": "Montreux Jazz Festival concert ID"
    , "P8301": "Montreux Jazz Festival person ID"
    , "P8302": "Montreux Jazz Festival song ID"
    , "P8303": "ESRB video game ID"
    , "P8304": "NexusMods video game ID"
    , "P8305": "LongTake person ID"
    , "P8306": "has grouping"
    , "P8307": "has sorting"
    , "P8308": "has column"
    , "P8309": "Yle topic ID"
    , "P8310": "digilibLT work ID"
    , "P8311": "PHI Latin Texts work ID"
    , "P8312": "Musisque Deoque work ID"
    , "P8313": "Den Store Danske ID"
    , "P8314": "Noovie person ID"
    , "P8315": "NTB ID"
    , "P8316": "sobory.ru ID"
    , "P8317": "Philadelphia Museum of Art entity ID"
    , "P8318": "WorldFootball.net stadium ID"
    , "P8319": "National Football Teams.com match ID"
    , "P8320": "EU-Football.info stadium ID"
    , "P8321": "Canadian Football League player ID"
    , "P8322": "cadastral municipality ID in Austria"
    , "P8323": "Monasteries in the Netherlands until 1800 ID"
    , "P8324": "funder"
    , "P8325": "Indonesian intangible cultural heritage"
    , "P8326": "Australian Classification ID"
    , "P8327": "intended subject of deprecated statement"
    , "P8328": "Democracy Index"
    , "P8329": "principal investigator"
    , "P8330": "file page offset"
    , "P8331": "strike tone"
    , "P8332": "Dansk litteraturs historie ID"
    , "P8333": "DLive game ID"
    , "P8334": "MuseScore artist ID"
    , "P8335": "Uffizi artwork ID"
    , "P8336": "MNBAQ artist ID"
    , "P8337": "Cimeti\u00e8res de France ID"
    , "P8338": "applies to name of value"
    , "P8339": "entry receptor"
    , "P8340": "estimated value"
    , "P8341": "Dansk Biografisk Leksikon ID"
    , "P8342": "SIUSA archival fonds ID"
    , "P8343": "Odeon ID"
    , "P8344": "WikiTrek ID"
    , "P8345": "media franchise"
    , "P8346": "Nomor Pokok Wajib Pajak"
    , "P8347": "Spotify songwriter ID"
    , "P8348": "NVE River Network (ELVIS) ID"
    , "P8349": "Proleksis enciklopedija ID"
    , "P8350": "Singapore Infopedia ID"
    , "P8351": "vglist video game ID"
    , "P8352": "Veldkruus ID"
    , "P8354": "BitterDB compound ID"
    , "P8355": "Helsinki persistent building ID Ratu"
    , "P8356": "SIUSA archive producer family ID"
    , "P8357": "SIUSA archive producer organization ID"
    , "P8358": "Museum of Family History ID"
    , "P8359": "Dewey Decimal Classification (works and editions)"
    , "P8360": "Library of Congress Classification (works and editions)"
    , "P8361": "Universal Decimal Classification (works and editions)"
    , "P8362": "Regensburg Classification (works and editions)"
    , "P8363": "study type"
    , "P8364": "Deku Deals ID"
    , "P8365": "Thesaurus Sozialwissenschaften ID"
    , "P8366": "GCatholic person ID"
    , "P8367": "Legacy.com person ID"
    , "P8368": "number of branches"
    , "P8369": "Econlib ID"
    , "P8370": "UNBIS Thesaurus ID"
    , "P8371": "references work, tradition or theory"
    , "P8372": "Web of Science ID"
    , "P8373": "Encyclopedia Tatarica (tt) Online ID"
    , "P8374": "Criminological Thesaurus ID"
    , "P8375": "Crossref journal ID"
    , "P8376": "Duden ID"
    , "P8377": "Encyclopedia Tatarica (ru) Online ID"
    , "P8378": "Dowker-Thistlethwaite notation"
    , "P8379": "qualifier for this property"
    , "P8380": "Directory of Afrocubanas ID"
    , "P8381": "Emmys person ID"
    , "P8382": "Finales Rugby ID"
    , "P8383": "Goodreads work ID"
    , "P8384": "locality number in Austria"
    , "P8385": "IDU person ID"
    , "P8386": "Gramophone composer ID"
    , "P8387": "Foreign war churchyards in Norway ID"
    , "P8388": "Riksdagen person guid"
    , "P8389": "GCatholic diocese ID"
    , "P8390": "PMSA ID"
    , "P8391": "BBK (library and bibliographic classification)"
    , "P8392": "Rate Your Music release ID"
    , "P8393": "QUDT quantity kind ID"
    , "P8394": "gloss quote"
    , "P8395": "use with property value"
    , "P8396": "use with qualifier"
    , "P8397": "prompt when missing"
    , "P8398": "offset from vertical"
    , "P8399": "Unique OntologyPropertyReference Reference Number"
    , "P8400": "House Divided ID"
    , "P8401": "thefreedictionary medical term ID"
    , "P8402": "Open Data portal"
    , "P8403": "theorised by"
    , "P8404": "DOI formatter"
    , "P8405": "People's Representative Council of Indonesia ID"
    , "P8406": "Grove Art Online ID"
    , "P8407": "Supreme Court of Sweden case number"
    , "P8408": "KBpedia ID"
    , "P8409": "Swedish Environmental Protection Agency Amenity OBJECTID"
    , "P8410": "Oxford Bibliographies ID"
    , "P8411": "set in environment"
    , "P8412": "Swiss Timber Bridges ID"
    , "P8413": "academic appointment"
    , "P8414": "AlloCin\u00e9 theater ID"
    , "P8415": "Maniadb artist ID"
    , "P8416": "Dowker-Thistlethwaite name"
    , "P8417": "Group Properties wiki ID"
    , "P8418": "Oberwolfach mathematician ID"
    , "P8419": "Archive Of Our Own tag"
    , "P8420": "GameBanana video game ID"
    , "P8421": "Spanish Olympic Committee athlete ID"
    , "P8422": "EHESS ID of a French commune"
    , "P8423": "version control system"
    , "P8424": "OpenHistoricalMap relation ID"
    , "P8425": "IAPH code"
    , "P8426": "Knot Atlas identifier"
    , "P8427": "Knotinfo identifier"
    , "P8428": "interactive elements"
    , "P8429": "Swiss Tunnel ID"
    , "P8430": "Wien Kulturgut: Kunstwerke im \u00f6ffentlichen Raum ID"
    , "P8431": "course"
    , "P8432": "\u00d6sterreichisches Musiklexikon Online ID"
    , "P8433": "Swedish Riksdag document ID"
    , "P8434": "Artprice artist ID"
    , "P8435": "AnyDecentMusic album ID"
    , "P8439": "SAH Archipedia architect ID"
    , "P8440": "Personendatenbank Germania Sacra ID"
    , "P8441": "Cistercian Biography Online ID"
    , "P8442": "Digital Library of the Caribbean ID"
    , "P8443": "Homebrew formula name"
    , "P8445": "Our Campaigns candidate ID"
    , "P8446": "Gateway to Research person ID"
    , "P8447": "Unique Street Reference Number"
    , "P8448": "Benerail station ID"
    , "P8449": "Churches in Limburg"
    , "P8450": "peak bagging classification"
    , "P8453": "public transport stop"
    , "P8454": "Vmusic.bg artist ID"
    , "P8455": "US Quaternary Fault ID"
    , "P8456": "ASCRG 2016 ID"
    , "P8457": "ANZSOC 2011 ID"
    , "P8458": "ANZSCO 2013 ID"
    , "P8459": "descriptive solubility"
    , "P8460": "applies if regular expression matches"
    , "P8461": "energy consumption per transaction"
    , "P8462": "Political Graveyard politician ID"
    , "P8463": "SAH Archipedia building ID"
    , "P8464": "content partnership category"
    , "P8465": "van der Waals Constant a"
    , "P8466": "van der Waals Constant b"
    , "P8467": "Wiki-Rennes ID"
    , "P8468": "Queensland Biota ID"
    , "P8469": "Australian Weed ID"
    , "P8470": "order number"
    , "P8471": "pertainym"
    , "P8472": "Encyclopedie berbere ID"
    , "P8473": "Japanese magazine code"
    , "P8474": "Lobbywatch.ch ID of a member of parliament"
    , "P8475": "IVS ID"
    , "P8476": "BTI Governance Index"
    , "P8477": "BTI Status Index"
    , "P8478": "Svenska Akademiens Ordbok ID"
    , "P8479": "National Registry of Exonerations Case ID"
    , "P8480": "Ofsted inspection rating"
    , "P8481": "Described and Captioned Media Program producer ID"
    , "P8482": "\u010cesk\u00fd hudebn\u00ed slovn\u00edk osob a instituc\u00ed ID"
    , "P8483": "PM20 geo code"
    , "P8484": "PM20 subject code"
    , "P8485": "distribution map of taxon"
    , "P8486": "DATAtourisme ID"
    , "P8487": "OpenCritic critic ID"
    , "P8488": "ASCCEG 2019 ID"
    , "P8489": "SmallGroup ID"
    , "P8490": "ANZSIC 2006 ID"
    , "P8491": "AHECC 2017 ID"
    , "P8492": "Tree of Public Interest ID"
    , "P8493": "Denkmaldatenbank Thurgau ID"
    , "P8494": "DSSTOX compound identifier"
    , "P8495": "South Africa EMIS code"
    , "P8496": "Archive Site Trinity College Cambridge ID"
    , "P8497": "height of center of mass"
    , "P8498": "road number formatter"
    , "P8499": "WISAARD resource ID"
    , "P8500": "Vietnamese middle name"
    , "P8501": "Gateway to Research organisation ID"
    , "P8502": "S\u00daKL code"
    , "P8503": "heraldic attitude"
    , "P8504": "Science Fiction Awards Database author ID"
    , "P8505": "traffic sign template image"
    , "P8506": "Power plant operating licence (Turkey)"
    , "P8507": "Legacy.com newspaper ID"
    , "P8508": "ChemSynthesis ID"
    , "P8509": "Dizionario Biografico dei Protestanti in Italia ID"
    , "P8510": "Maitron des fusill\u00e9s ID"
    , "P8511": "Fototeka person ID"
    , "P8512": "size comparison diagram"
    , "P8513": "LibraryThing series ID"
    , "P8514": "TOPCMB ID"
    , "P8515": "Swiss Industrial Heritage ID"
    , "P8516": "Library of Congress Medium of Performance Thesaurus ID"
    , "P8517": "view"
    , "P8518": "Henrik Ibsen writings ID"
    , "P8519": "RKD thesaurus ID"
    , "P8520": "TCLF ID"
    , "P8521": "Sculptures and cities database ID for sculptures"
    , "P8522": "Manioc book ID"
    , "P8523": "Pr\u00e9sence Compositrices composer ID"
    , "P8524": "Offizielle Deutsche Charts song ID"
    , "P8525": "ToS;DR service numerical identifier"
    , "P8526": "Have I Been Pwned breach ID"
    , "P8527": "Unsplash user ID"
    , "P8528": "EIB project ID"
    , "P8529": "ANZSRC 2020 FoR ID"
    , "P8530": "alternative form"
    , "P8531": "Filmstarts title ID"
    , "P8532": "Trismegistos text ID"
    , "P8533": "SMARTS notation"
    , "P8534": "SPLC Individual ID"
    , "P8535": "tala"
    , "P8536": "raga"
    , "P8539": "ERIC Thesaurus ID"
    , "P8540": "American Folklore Society Ethnographic Thesaurus ID"
    , "P8541": "BHF magazine ID"
    , "P8542": "Macedonian cadastral municipality ID"
    , "P8543": "Monumentbrowser ID"
    , "P8544": "Frauen in Bewegung 1848\u20131938 ID"
    , "P8545": "Nasjonalt skoleregister ID"
    , "P8546": "recording location"
    , "P8547": "BHF author ID"
    , "P8548": "Proballers ID"
    , "P8549": "Opera Online work ID"
    , "P8550": "law or regulation identifying number"
    , "P8551": "Opera Online composer ID"
    , "P8552": "Opera Online opera house ID"
    , "P8553": "CTHS publication ID"
    , "P8554": "earliest end date"
    , "P8555": "latest start date"
    , "P8556": "extinction date"
    , "P8557": "edukado.net Panteono ID"
    , "P8558": "Butcher tableau"
    , "P8559": "Chrome Webstore extension ID"
    , "P8560": "PARADISEC Catalog"
    , "P8561": "NPR station ID"
    , "P8562": "JSTOR publisher ID"
    , "P8563": "Emporis company ID"
    , "P8564": "Art Bonus ID"
    , "P8565": "British Museum object ID"
    , "P8566": "monumenta.ch ID"
    , "P8567": "The Living New Deal ID"
    , "P8568": "Jewish Virtual Library person ID"
    , "P8569": "YIVO Encyclopedia of Jews in Eastern Europe ID"
    , "P8570": "front and back matter"
    , "P8571": "external auditor"
    , "P8572": "Spanish Artists from the Fourth to the Twentieth Century ID"
    , "P8573": "LSG localbody code"
    , "P8574": "NYARC Discovery ID"
    , "P8575": "Encyclopaedia of Architects, Vienna 1770\u20131945 ID"
    , "P8576": "Hrvatska tehni\u010dka enciklopedija ID"
    , "P8577": "ICP artist ID"
    , "P8578": "TracesOfWar person ID"
    , "P8579": "Firefox add-on ID"
    , "P8580": "NHK Archives Portal person ID"
    , "P8581": "Hrvatski biografski leksikon ID"
    , "P8582": "InciWeb ID"
    , "P8583": "YUAG ID"
    , "P8584": "Wikipedia Library partner ID"
    , "P8585": "FIPRESCI person ID"
    , "P8586": "Anais do Museu Paulista article ID"
    , "P8587": "Legacies of British Slave-ownership place ID"
    , "P8588": "Wisconsin Historical Society NRHP ID"
    , "P8589": "Carl-Maria-von-Weber-Gesamtausgabe ID"
    , "P8590": "Jewish Encyclopedia ID"
    , "P8591": "Grove Music Online ID"
    , "P8592": "aerial view"
    , "P8593": "Hikr waypoint ID"
    , "P8594": "ride height"
    , "P8595": "DIL ID"
    , "P8596": "category for the exterior of the item"
    , "P8597": "axle track"
    , "P8598": "Seattle Art Museum ID"
    , "P8599": "Nelson-Atkins Museum of Art artwork ID"
    , "P8600": "TV Maze series ID"
    , "P8601": "Barcelona Public art ID"
    , "P8602": "University of Ghana Digital Collections (UGSpace) ID"
    , "P8603": "Istrapedia ID"
    , "P8604": "OnlyFans person ID"
    , "P8605": "Linked Open Data Cloud identifier"
    , "P8606": "Stairway To Hell ID"
    , "P8607": "The Cutting Room Floor ID"
    , "P8608": "Fatcat ID"
    , "P8609": "China Treaty Database ID"
    , "P8610": "e-GOV law ID"
    , "P8611": "Portugal. Dicion\u00e1rio Hist\u00f3rico ID"
    , "P8612": "past Fellow of the Royal Society ID"
    , "P8613": "Regesta Ecclesiastica Salisburgensia ID"
    , "P8614": "Slack organization ID"
    , "P8615": "Oakeshott typology"
    , "P8616": "Kansas Historic Resources Inventory ID"
    , "P8617": "Historic Montana ID"
    , "P8618": "ITF player ID 2020"
    , "P8619": "BD Gest' series ID"
    , "P8620": "construction point"
    , "P8621": "turning radius"
    , "P8622": "hill size"
    , "P8623": "American Battlefield Trust battlefield ID"
    , "P8624": "American Battlefield Trust ID (person)"
    , "P8625": "bibliography"
    , "P8626": "opening time"
    , "P8627": "closing time"
    , "P8628": "engine displacement"
    , "P8629": "Occupational Outlook Handbook ID"
    , "P8630": "Thomas Jefferson Encyclopedia ID"
    , "P8631": "Canadian Women Artists History Initiative ID"
    , "P8632": "Book Marks ID"
    , "P8633": "Re-Member ID"
    , "P8634": "SPoT skater ID"
    , "P8635": "NDL law ID"
    , "P8636": "McClintock and Strong Biblical Cyclopedia ID"
    , "P8637": "L'Officiel des spectacles ID"
    , "P8638": "British and Irish Furniture Makers Online ID"
    , "P8639": "Cincinnati Art Museum ID"
    , "P8640": "Dallas Museum of Art ID"
    , "P8642": "FBref.com squad ID"
    , "P8643": "Dostoyevsky and His Entourage ID"
    , "P8644": "Lambiek comic magazines ID"
    , "P8645": "Energy Identification Code"
    , "P8646": "expansion of"
    , "P8647": "Library of Congress Children's Subject Headings ID"
    , "P8648": "Ministry of the Interior of Italy ID"
    , "P8649": "National Park Service place ID"
    , "P8650": "MnDOT Historic Bridges ID"
    , "P8651": "Open Civic Data Division ID"
    , "P8652": "Netflix maturity rating"
    , "P8653": "Museen Dresden article ID"
    , "P8654": "SSYK 2012 The Swedish Standard Classification of Occupations"
    , "P8655": "LoC HABS/HAER/HALS place ID"
    , "P8656": "Symptom Ontology ID"
    , "P8657": "photoLondon ID"
    , "P8658": "Syro-Malabar Catholic Church ID"
    , "P8659": "TDD number"
    , "P8660": "Native Plants Database ID"
    , "P8661": "Lower Sorbian place name ID"
    , "P8662": "Les roses cultiv\u00e9es \u00e0 l'Ha\u00ff en 1902 ID"
    , "P8663": "Maniadb album ID"
    , "P8664": "USA Water Polo Hall of Fame ID"
    , "P8665": "Pr\u00e9sence Compositrices work ID"
    , "P8666": "Regional Council of Tuscany ID"
    , "P8667": "twin town sign"
    , "P8668": "Indonesian prison database ID"
    , "P8669": "Encyclopaedia Beliana ID"
    , "P8670": "character designer"
    , "P8671": "Deutsche Bahn station code"
    , "P8672": "Twitter topics ID"
    , "P8673": "Naver movie ID"
    , "P8674": "Bollywood Hungama movie ID"
    , "P8675": "BoardGameGeek family ID"
    , "P8676": "London Stock Exchange company ID"
    , "P8677": "R\u00e9gion \u00cele-de-France ID"
    , "P8678": "Slovn\u00edk \u010desk\u00fdch nakladatelstv\u00ed 1848-1949 person ID"
    , "P8714": "identifier in the Global Administrative Area database"
}

__all__ = ['wikidata', 'PROPERTY_MAPPING']

from knowledge.public import wikidata
