/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.model.def;

import com.cmayes.common.model.Atom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cmayes.hartree.model.BaseResult;
import org.cmayes.hartree.model.GlucoseRingResult;
import org.cmayes.hartree.model.def.CremerPopleCoordinates;
import org.cmayes.hartree.model.def.CremerPopleResult;
import org.cmayes.hartree.model.def.DefaultBaseResult;

public class CpCalculationSnapshot
extends DefaultBaseResult
implements CremerPopleResult,
GlucoseRingResult {
    private List<Atom> glucoseRing = new ArrayList<Atom>();
    private List<Atom> oxygenAtoms = new ArrayList<Atom>();
    private List<Double> carbonDistances = new ArrayList<Double>();
    private List<Double> oxygenDistances = new ArrayList<Double>();
    private List<Double> ionDistances = new ArrayList<Double>();
    private CremerPopleCoordinates cpCoords;
    private Double hmArmAngle1;
    private Double acArmAngle1;
    private Double hmArmAngle2;
    private Double acArmAngle2;
    private Double anoAngle1;
    private Double anoAngle2;

    public CpCalculationSnapshot() {
    }

    public CpCalculationSnapshot(CpCalculationSnapshot snap) {
        super(snap);
        this.glucoseRing = snap.getGlucoseRing();
        this.cpCoords = snap.getCpCoords();
        this.carbonDistances = snap.getCarbonDistances();
        this.oxygenDistances = snap.getOxygenDistances();
        this.ionDistances = snap.getIonDistances();
        this.oxygenAtoms = snap.getOxygenAtoms();
        this.hmArmAngle1 = snap.getHmArmAngle1();
        this.hmArmAngle2 = snap.getHmArmAngle2();
        this.acArmAngle1 = snap.getAcArmAngle1();
        this.acArmAngle2 = snap.getAcArmAngle2();
        this.anoAngle1 = snap.getAnoAngle1();
        this.anoAngle2 = snap.getAnoAngle2();
    }

    public CpCalculationSnapshot(BaseResult baseResult) {
        super(baseResult);
    }

    @Override
    public List<Atom> getGlucoseRing() {
        return this.glucoseRing;
    }

    @Override
    public void setGlucoseRing(List<Atom> ring) {
        this.glucoseRing = ring;
    }

    public List<Atom> getOxygenAtoms() {
        return this.oxygenAtoms;
    }

    public void setOxygenAtoms(List<Atom> oxyAtoms) {
        this.oxygenAtoms = oxyAtoms;
    }

    @Override
    public CremerPopleCoordinates getCpCoords() {
        return this.cpCoords;
    }

    @Override
    public void setCpCoords(CremerPopleCoordinates coords) {
        this.cpCoords = coords;
    }

    @Override
    public List<Double> getCarbonDistances() {
        return this.carbonDistances;
    }

    public void setCarbonDistances(List<Double> carbonDist) {
        this.carbonDistances = carbonDist;
    }

    @Override
    public List<Double> getOxygenDistances() {
        return this.oxygenDistances;
    }

    public void setOxygenDistances(List<Double> oxygenDist) {
        this.oxygenDistances = oxygenDist;
    }

    @Override
    public List<Double> getIonDistances() {
        return this.ionDistances;
    }

    public void setIonDistances(List<Double> ionDist) {
        this.ionDistances = ionDist;
    }

    @Override
    public Double getHmArmAngle1() {
        return this.hmArmAngle1;
    }

    public void setHmArmAngle1(Double angle1) {
        this.hmArmAngle1 = angle1;
    }

    @Override
    public Double getHmArmAngle2() {
        return this.hmArmAngle2;
    }

    public void setHmArmAngle2(Double angle2) {
        this.hmArmAngle2 = angle2;
    }

    @Override
    public Double getAcArmAngle1() {
        return this.acArmAngle1;
    }

    public void setAcArmAngle1(Double angle1) {
        this.acArmAngle1 = angle1;
    }

    @Override
    public Double getAcArmAngle2() {
        return this.acArmAngle2;
    }

    public void setAcArmAngle2(Double angle2) {
        this.acArmAngle2 = angle2;
    }

    @Override
    public Double getAnoAngle1() {
        return this.anoAngle1;
    }

    public void setAnoAngle1(Double thirdAngle1) {
        this.anoAngle1 = thirdAngle1;
    }

    @Override
    public Double getAnoAngle2() {
        return this.anoAngle2;
    }

    public void setAnoAngle2(Double thirdAngle2) {
        this.anoAngle2 = thirdAngle2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CpCalculationSnapshot)) {
            return false;
        }
        CpCalculationSnapshot rhs = (CpCalculationSnapshot)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append(this.anoAngle2, rhs.anoAngle2).append(this.anoAngle1, rhs.anoAngle1).append(this.carbonDistances, rhs.carbonDistances).append(this.ionDistances, rhs.ionDistances).append(this.oxygenDistances, rhs.oxygenDistances).append(this.cpCoords, rhs.cpCoords).append(this.oxygenAtoms, rhs.oxygenAtoms).append(this.hmArmAngle1, rhs.hmArmAngle1).append(this.hmArmAngle2, rhs.hmArmAngle2).append(this.acArmAngle2, rhs.acArmAngle2).append(this.acArmAngle1, rhs.acArmAngle1).append(this.glucoseRing, rhs.glucoseRing).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(-334262149, 954656579).appendSuper(super.hashCode()).append(this.anoAngle2).append(this.anoAngle1).append(this.carbonDistances).append(this.ionDistances).append(this.oxygenDistances).append(this.cpCoords).append(this.oxygenAtoms).append(this.hmArmAngle1).append(this.hmArmAngle2).append(this.acArmAngle2).append(this.acArmAngle1).append(this.glucoseRing).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("functional", this.getFunctional()).append("anoAngle1", this.anoAngle1).append("anoAngle2", this.anoAngle2).append("frequencyValues", this.getFrequencyValues()).append("glucoseRing", this.glucoseRing).append("mult", this.getMult()).append("ionDistances", this.ionDistances).append("symmetricTop", this.isSymmetricTop()).append("sourceName", this.getSourceName()).append("hmArmAngle1", this.hmArmAngle1).append("solvent", this.getSolvent()).append("terminationDates", this.getTerminationDates()).append("enthalpy298", this.getEnthalpy298()).append("elecEn", this.getElecEn()).append("charge", this.getCharge()).append("atoms", this.getAtoms()).append("cpuTimes", this.getCpuTimes()).append("acArmAngle1", this.acArmAngle1).append("atomCount", this.getAtomCount()).append("acArmAngle2", this.acArmAngle2).append("hmArmAngle2", this.hmArmAngle2).append("cpCoords", this.cpCoords).append("rotPart", this.getRotPart()).append("oxygenDistances", this.oxygenDistances).append("transPart", this.getTransPart()).append("gibbs298", this.getGibbs298()).append("zpeCorrection", this.getZpeCorrection()).append("oxygenAtoms", this.oxygenAtoms).append("stoichiometry", this.getStoichiometry()).append("basisSet", this.getBasisSet()).append("carbonDistances", this.carbonDistances).append("dipoleMomentTotal", this.getDipoleMomentTotal()).append("atomMap", this.getAtomMap()).toString();
    }
}

