# Copyright (C) 2022 CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

# CVAT REST API
#
# REST API for Computer Vision Annotation Tool (CVAT)  # noqa: E501
#
# The version of the OpenAPI document: 2.5
# Contact: support@cvat.ai
# Generated by: https://openapi-generator.tech


from __future__ import annotations

import typing
import urllib3

import re  # noqa: F401

from cvat_sdk.api_client.api_client import ApiClient, Endpoint as _Endpoint
from cvat_sdk.api_client.model_utils import (  # noqa: F401
    date,
    datetime,
    file_type,
    none_type,
)
from cvat_sdk.api_client.model.events import Events
from cvat_sdk.api_client.model.paginated_webhook_delivery_read_list import PaginatedWebhookDeliveryReadList
from cvat_sdk.api_client.model.paginated_webhook_read_list import PaginatedWebhookReadList
from cvat_sdk.api_client.model.patched_webhook_write_request import PatchedWebhookWriteRequest
from cvat_sdk.api_client.model.webhook_delivery_read import WebhookDeliveryRead
from cvat_sdk.api_client.model.webhook_read import WebhookRead
from cvat_sdk.api_client.model.webhook_write_request import WebhookWriteRequest

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    # Enable introspection. Can't work normally due to cyclic imports
    from cvat_sdk.api_client.apis import *
    from cvat_sdk.api_client.models import *


class WebhooksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_endpoint = _Endpoint(
            settings={
                'response_schema': (WebhookRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks',
                'operation_id': 'create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'webhook_write_request',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'webhook_write_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'webhook_write_request':
                        (WebhookWriteRequest,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'webhook_write_request': 'body',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data',
                    'application/offset+octet-stream'
                ]
            },
            api_client=api_client
        )
        self.create_deliveries_redelivery_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/{id}/deliveries/{delivery_id}/redelivery',
                'operation_id': 'create_deliveries_redelivery',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'delivery_id',
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'delivery_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'delivery_id',
                ]
            },
            root_map={
                'validations': {
                    ('delivery_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'delivery_id':
                        (str,),
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'delivery_id': 'delivery_id',
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'delivery_id': 'path',
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_ping_endpoint = _Endpoint(
            settings={
                'response_schema': (WebhookDeliveryRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/{id}/ping',
                'operation_id': 'create_ping',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.destroy_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/{id}',
                'operation_id': 'destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_endpoint = _Endpoint(
            settings={
                'response_schema': (PaginatedWebhookReadList,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks',
                'operation_id': 'list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_organization',
                    'filter',
                    'org',
                    'org_id',
                    'owner',
                    'page',
                    'page_size',
                    'project_id',
                    'search',
                    'sort',
                    'target_url',
                    'type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('type',): {

                        "ORGANIZATION": "organization",
                        "PROJECT": "project"
                    },
                },
                'openapi_types': {
                    'x_organization':
                        (str,),
                    'filter':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'owner':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'project_id':
                        (int,),
                    'search':
                        (str,),
                    'sort':
                        (str,),
                    'target_url':
                        (str,),
                    'type':
                        (str,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'filter': 'filter',
                    'org': 'org',
                    'org_id': 'org_id',
                    'owner': 'owner',
                    'page': 'page',
                    'page_size': 'page_size',
                    'project_id': 'project_id',
                    'search': 'search',
                    'sort': 'sort',
                    'target_url': 'target_url',
                    'type': 'type',
                },
                'location_map': {
                    'x_organization': 'header',
                    'filter': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'owner': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'project_id': 'query',
                    'search': 'query',
                    'sort': 'query',
                    'target_url': 'query',
                    'type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_deliveries_endpoint = _Endpoint(
            settings={
                'response_schema': (PaginatedWebhookDeliveryReadList,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/{id}/deliveries',
                'operation_id': 'list_deliveries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'filter',
                    'org',
                    'org_id',
                    'page',
                    'page_size',
                    'search',
                    'sort',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'filter':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'search':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'filter': 'filter',
                    'org': 'org',
                    'org_id': 'org_id',
                    'page': 'page',
                    'page_size': 'page_size',
                    'search': 'search',
                    'sort': 'sort',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'filter': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'search': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.partial_update_endpoint = _Endpoint(
            settings={
                'response_schema': (WebhookRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/{id}',
                'operation_id': 'partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                    'patched_webhook_write_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'patched_webhook_write_request':
                        (PatchedWebhookWriteRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                    'patched_webhook_write_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data',
                    'application/offset+octet-stream'
                ]
            },
            api_client=api_client
        )
        self.retrieve_endpoint = _Endpoint(
            settings={
                'response_schema': (WebhookRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/{id}',
                'operation_id': 'retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_deliveries_endpoint = _Endpoint(
            settings={
                'response_schema': (WebhookDeliveryRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/{id}/deliveries/{delivery_id}',
                'operation_id': 'retrieve_deliveries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'delivery_id',
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'delivery_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'delivery_id',
                ]
            },
            root_map={
                'validations': {
                    ('delivery_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'delivery_id':
                        (str,),
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'delivery_id': 'delivery_id',
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'delivery_id': 'path',
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_events_endpoint = _Endpoint(
            settings={
                'response_schema': (Events,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/events',
                'operation_id': 'retrieve_events',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_organization',
                    'org',
                    'org_id',
                    'type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'type':
                        (str,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                    'type': 'type',
                },
                'location_map': {
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                    'type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_endpoint = _Endpoint(
            settings={
                'response_schema': (WebhookRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/webhooks/{id}',
                'operation_id': 'update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'webhook_write_request',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'id',
                    'webhook_write_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'webhook_write_request':
                        (WebhookWriteRequest,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'webhook_write_request': 'body',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data',
                    'application/offset+octet-stream'
                ]
            },
            api_client=api_client
        )

    def create(
        self,
        webhook_write_request: WebhookWriteRequest,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[WebhookRead], urllib3.HTTPResponse]:
        """Method creates a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create(webhook_write_request, _async_call=True)
        >>> result = thread.get()

        Args:
            webhook_write_request (WebhookWriteRequest):

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (WebhookRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['webhook_write_request'] = webhook_write_request
        return self.create_endpoint.call_with_http_info(**kwargs)

    def create_deliveries_redelivery(
        self,
        delivery_id: str,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Method redeliver a specific webhook delivery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_deliveries_redelivery(delivery_id, id, _async_call=True)
        >>> result = thread.get()

        Args:
            delivery_id (str):
            id (int): A unique integer value identifying this webhook.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['delivery_id'] = delivery_id
        kwargs['id'] = id
        return self.create_deliveries_redelivery_endpoint.call_with_http_info(**kwargs)

    def create_ping(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[WebhookDeliveryRead], urllib3.HTTPResponse]:
        """Method send ping webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_ping(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this webhook.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (WebhookDeliveryRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.create_ping_endpoint.call_with_http_info(**kwargs)

    def destroy(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Method deletes a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.destroy(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this webhook.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.destroy_endpoint.call_with_http_info(**kwargs)

    def list(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[PaginatedWebhookReadList], urllib3.HTTPResponse]:
        """Method returns a paginated list of webhook according to query parameters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            x_organization (str): [optional]
            filter (str): A filter term. Available filter_fields: ['target_url', 'owner', 'type', 'description', 'id', 'project_id', 'updated_date']. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            owner (str): A simple equality filter for the owner field. [optional]
            page (int): A page number within the paginated result set.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            project_id (int): A simple equality filter for the project_id field. [optional]
            search (str): A search term. Available search_fields: ('target_url', 'owner', 'type', 'description'). [optional]
            sort (str): Which field to use when ordering the results. Available ordering_fields: ['target_url', 'owner', 'type', 'description', 'id', 'project_id', 'updated_date']. [optional]
            target_url (str): A simple equality filter for the target_url field. [optional]
            type (str): A simple equality filter for the type field. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (PaginatedWebhookReadList, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.list_endpoint.call_with_http_info(**kwargs)

    def list_deliveries(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[PaginatedWebhookDeliveryReadList], urllib3.HTTPResponse]:
        """Method return a list of deliveries for a specific webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list_deliveries(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this webhook.

        Keyword Args:
            x_organization (str): [optional]
            filter (str): A filter term. Available filter_fields: None. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            page (int): A page number within the paginated result set.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            search (str): A search term. Available search_fields: None. [optional]
            sort (str): Which field to use when ordering the results. Available ordering_fields: None. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (PaginatedWebhookDeliveryReadList, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.list_deliveries_endpoint.call_with_http_info(**kwargs)

    def partial_update(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[WebhookRead], urllib3.HTTPResponse]:
        """Methods does a partial update of chosen fields in a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this webhook.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            patched_webhook_write_request (PatchedWebhookWriteRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (WebhookRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.partial_update_endpoint.call_with_http_info(**kwargs)

    def retrieve(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[WebhookRead], urllib3.HTTPResponse]:
        """Method returns details of a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this webhook.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (WebhookRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_endpoint.call_with_http_info(**kwargs)

    def retrieve_deliveries(
        self,
        delivery_id: str,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[WebhookDeliveryRead], urllib3.HTTPResponse]:
        """Method return a specific delivery for a specific webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_deliveries(delivery_id, id, _async_call=True)
        >>> result = thread.get()

        Args:
            delivery_id (str):
            id (int): A unique integer value identifying this webhook.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (WebhookDeliveryRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['delivery_id'] = delivery_id
        kwargs['id'] = id
        return self.retrieve_deliveries_endpoint.call_with_http_info(**kwargs)

    def retrieve_events(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[Events], urllib3.HTTPResponse]:
        """Method return a list of available webhook events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_events(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            type (str): Type of webhook. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (Events, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.retrieve_events_endpoint.call_with_http_info(**kwargs)

    def update(
        self,
        id: int,
        webhook_write_request: WebhookWriteRequest,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[WebhookRead], urllib3.HTTPResponse]:
        """Method updates a webhook by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.update(id, webhook_write_request, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this webhook.
            webhook_write_request (WebhookWriteRequest):

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (WebhookRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        kwargs['webhook_write_request'] = webhook_write_request
        return self.update_endpoint.call_with_http_info(**kwargs)

