import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectIssueBoardConfig extends cdktf.TerraformMetaArguments {
    /**
    * The assignee the board should be scoped to. Requires a GitLab EE license.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#assignee_id ProjectIssueBoard#assignee_id}
    */
    readonly assigneeId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#id ProjectIssueBoard#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The list of label names which the board should be scoped to. Requires a GitLab EE license.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#labels ProjectIssueBoard#labels}
    */
    readonly labels?: string[];
    /**
    * The milestone the board should be scoped to. Requires a GitLab EE license.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#milestone_id ProjectIssueBoard#milestone_id}
    */
    readonly milestoneId?: number;
    /**
    * The name of the board.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#name ProjectIssueBoard#name}
    */
    readonly name: string;
    /**
    * The ID or full path of the project maintained by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#project ProjectIssueBoard#project}
    */
    readonly project: string;
    /**
    * The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#weight ProjectIssueBoard#weight}
    */
    readonly weight?: number;
    /**
    * lists block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#lists ProjectIssueBoard#lists}
    */
    readonly lists?: ProjectIssueBoardLists[] | cdktf.IResolvable;
}
export interface ProjectIssueBoardLists {
    /**
    * The ID of the assignee the list should be scoped to. Requires a GitLab EE license.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#assignee_id ProjectIssueBoard#assignee_id}
    */
    readonly assigneeId?: number;
    /**
    * The ID of the iteration the list should be scoped to. Requires a GitLab EE license.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#iteration_id ProjectIssueBoard#iteration_id}
    */
    readonly iterationId?: number;
    /**
    * The ID of the label the list should be scoped to. Requires a GitLab EE license.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#label_id ProjectIssueBoard#label_id}
    */
    readonly labelId?: number;
    /**
    * The ID of the milestone the list should be scoped to. Requires a GitLab EE license.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board#milestone_id ProjectIssueBoard#milestone_id}
    */
    readonly milestoneId?: number;
}
export declare function projectIssueBoardListsToTerraform(struct?: ProjectIssueBoardLists | cdktf.IResolvable): any;
export declare class ProjectIssueBoardListsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProjectIssueBoardLists | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectIssueBoardLists | cdktf.IResolvable | undefined);
    private _assigneeId?;
    get assigneeId(): number;
    set assigneeId(value: number);
    resetAssigneeId(): void;
    get assigneeIdInput(): number | undefined;
    get id(): number;
    private _iterationId?;
    get iterationId(): number;
    set iterationId(value: number);
    resetIterationId(): void;
    get iterationIdInput(): number | undefined;
    private _labelId?;
    get labelId(): number;
    set labelId(value: number);
    resetLabelId(): void;
    get labelIdInput(): number | undefined;
    private _milestoneId?;
    get milestoneId(): number;
    set milestoneId(value: number);
    resetMilestoneId(): void;
    get milestoneIdInput(): number | undefined;
    get position(): number;
}
export declare class ProjectIssueBoardListsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProjectIssueBoardLists[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProjectIssueBoardListsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board gitlab_project_issue_board}
*/
export declare class ProjectIssueBoard extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_issue_board";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue_board gitlab_project_issue_board} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectIssueBoardConfig
    */
    constructor(scope: Construct, id: string, config: ProjectIssueBoardConfig);
    private _assigneeId?;
    get assigneeId(): number;
    set assigneeId(value: number);
    resetAssigneeId(): void;
    get assigneeIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _milestoneId?;
    get milestoneId(): number;
    set milestoneId(value: number);
    resetMilestoneId(): void;
    get milestoneIdInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _lists;
    get lists(): ProjectIssueBoardListsList;
    putLists(value: ProjectIssueBoardLists[] | cdktf.IResolvable): void;
    resetLists(): void;
    get listsInput(): cdktf.IResolvable | ProjectIssueBoardLists[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
