# AUTOGENERATED! DO NOT EDIT! File to edit: 01_case.ipynb (unless otherwise specified).

__all__ = ['replace_parentheses', 'snake2words', 'replace_acronyms', 'acronyms', 'PxLabeler', 'px_labeler']

# Cell
import re
import pandas as pd
from fastcore.all import *
from .core import *

# Cell
def replace_parentheses(s):
    out = s.replace('__','_(', 1).replace('__',')', 1)
    if out == s: return out
    return replace_parentheses(out)

# Cell
_par_re = re.compile(r'((?<=\()[A-Z])')

# Cell
def snake2words(s):
    return re.sub(_par_re, lambda x: x.group(0).lower(), ' '.join(replace_parentheses(s).title().split('_')))

# Cell
acronyms = ['MAE', 'RMSE']
def replace_acronyms(s):
    if is_listy(s): return [replace_acronyms(o) for o in s]
    for o in acronyms: s=s.replace(o.lower(), o).replace(o.capitalize(), o)
    return s

# Cell
@patch
def rename2words(self:pd.DataFrame):
    '''Renames columns in snake_case to Words.'''
    return self.renamec(snake2words).renamec(replace_acronyms)

# Cell
class PxLabeler:
    def __getitem__(self, item): return replace_acronyms(snake2words(item))
px_labeler = PxLabeler()