"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNoneAuthorizer = exports.HttpAuthorizer = exports.AuthorizerPayloadVersion = exports.HttpAuthorizerType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Supported Authorizer types
 */
var HttpAuthorizerType;
(function (HttpAuthorizerType) {
    /** IAM Authorizer */
    HttpAuthorizerType["IAM"] = "AWS_IAM";
    /** JSON Web Tokens */
    HttpAuthorizerType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpAuthorizerType["LAMBDA"] = "REQUEST";
})(HttpAuthorizerType = exports.HttpAuthorizerType || (exports.HttpAuthorizerType = {}));
/**
 * Payload format version for lambda authorizers
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html
 */
var AuthorizerPayloadVersion;
(function (AuthorizerPayloadVersion) {
    /** Version 1.0 */
    AuthorizerPayloadVersion["VERSION_1_0"] = "1.0";
    /** Version 2.0 */
    AuthorizerPayloadVersion["VERSION_2_0"] = "2.0";
})(AuthorizerPayloadVersion = exports.AuthorizerPayloadVersion || (exports.AuthorizerPayloadVersion = {}));
/**
 * An authorizer for Http Apis
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class HttpAuthorizer extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        let authorizerPayloadFormatVersion = props.payloadFormatVersion;
        if (props.type === HttpAuthorizerType.JWT && (!props.jwtAudience || props.jwtAudience.length === 0 || !props.jwtIssuer)) {
            throw new Error('jwtAudience and jwtIssuer are mandatory for JWT authorizers');
        }
        if (props.type === HttpAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        /**
         * This check is required because Cloudformation will fail stack creation if this property
         * is set for the JWT authorizer. AuthorizerPayloadFormatVersion can only be set for REQUEST authorizer
         */
        if (props.type === HttpAuthorizerType.LAMBDA && typeof authorizerPayloadFormatVersion === 'undefined') {
            authorizerPayloadFormatVersion = AuthorizerPayloadVersion.VERSION_2_0;
        }
        const resource = new aws_apigatewayv2_1.CfnAuthorizer(this, 'Resource', {
            name: (_c = props.authorizerName) !== null && _c !== void 0 ? _c : id,
            apiId: props.httpApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            jwtConfiguration: undefinedIfNoKeys({
                audience: props.jwtAudience,
                issuer: props.jwtIssuer,
            }),
            enableSimpleResponses: props.enableSimpleResponses,
            authorizerPayloadFormatVersion,
            authorizerUri: props.authorizerUri,
            authorizerResultTtlInSeconds: (_d = props.resultsCacheTtl) === null || _d === void 0 ? void 0 : _d.toSeconds(),
        });
        this.authorizerId = resource.ref;
    }
    /**
     * Import an existing HTTP Authorizer into this CDK app.
     */
    static fromHttpAuthorizerAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpAuthorizerAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromHttpAuthorizerAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpAuthorizer = HttpAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpAuthorizer", version: "2.24.0-alpha.0" };
function undefinedIfNoKeys(obj) {
    const allUndefined = Object.values(obj).every(val => val === undefined);
    return allUndefined ? undefined : obj;
}
/**
 * Explicitly configure no authorizers on specific HTTP API routes.
 */
class HttpNoneAuthorizer {
    bind(_) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpRouteAuthorizerBindOptions(_);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            authorizationType: 'NONE',
        };
    }
}
exports.HttpNoneAuthorizer = HttpNoneAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
HttpNoneAuthorizer[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpNoneAuthorizer", version: "2.24.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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