import warnings

from django.test import TestCase
from .factories import PhotoFactory, PhotoSizeFactory


class PhotologueBaseTest(TestCase):

    def setUp(self):
        self.s = PhotoSizeFactory(name='testPhotoSize',
                                  width=100,
                                  height=100)
        try:
            # Squash lots of ResourceWarning generated by the Pillow library during unit tests.
            warnings.simplefilter("ignore", ResourceWarning)
        except NameError:
            # Doesn't exist in Python 2.7.
            pass
        self.pl = PhotoFactory(title='Landscape',
                               slug='landscape')

    def tearDown(self):
        # Need to manually remove the files created during testing.
        self.pl.delete()
