# Django Daisy

[**Live Demo https://hypy13-django-daisy.hf.space/en/admin/**](https://hypy13-django-daisy.hf.space/en/admin/)  
**Username:** demo  
**Password:** demo


for RTL mode:
https://hypy13-django-daisy.hf.space/fa/admin/

![ScreenShot](https://raw.githubusercontent.com/hypy13/django-daisy/refs/heads/main/screenshots/change_form.png)

---



Django Daisy is a modern, sleek, and highly responsive admin dashboard built with **DaisyUI** and **TailwindCSS**. It brings a polished and user-friendly interface that scales beautifully across devices, from mobile to desktop, making your admin experience fast and efficient.


### Documentation:
https://hypy13.github.io/django-daisy-docs/

---

## ✨ Key Features

- 🌍 **Responsive Design**: Perfectly adapts to all screen sizes, ensuring a seamless user experience across mobile, tablet, and desktop devices.
- 🔄 **RTL Support**: Complete right-to-left language support, with a clean and consistent layout for RTL users.
- 🎨 **Multi-Theme Support**: Effortlessly switch between themes to match your brand identity or personal style.
- 🚀 **Enhanced UX/UI**: Experience an optimized interface with **tabbed inline admin panels** for better organization and usability.
- 📝 **Tabbed Inline Admin**: Manage related data more efficiently with tabbed inline admin sections, improving organization and accessibility.
- 🔍 **Advanced Admin Filtering**: Utilize multi-value filters for fast and precise navigation through admin lists.

---

## ⚙️ Compatibility

- Django 3.2 - 5.1.1 are fully supported.

---

## 🚧 Upcoming Features

Stay tuned! Continuous improvements and new features are regularly added to enhance your experience.

---

## 📦 Installation

### Option 1: Install via PyPi

```bash
pip install django-daisy
```
### Option 2: Install as an editable GitHub source

```bash
pip install -e git+https://github.com/hypy13/django-daisy.git#egg=django-daisy
```

After installation, add `django_daisy` to your `INSTALLED_APPS` in the Django settings file.  

```python
INSTALLED_APPS = [
    'django_daisy',
    'django.contrib.admin',
    ...
]
```

Once you've made these changes, enjoy the fresh new theme!

---

## 🤝 Contributing

We welcome contributions from the community! Feel free to submit any issues, suggestions, or pull requests to help improve Django Daisy.

---

## 📸 Screenshots

##### Listing View:
![Listing View](https://raw.githubusercontent.com/hypy13/django-daisy/refs/heads/main/screenshots/listing.png)


##### Change Form:
![Listing View](https://raw.githubusercontent.com/hypy13/django-daisy/refs/heads/main/screenshots/change_form.png)

##### InlineAdmin Change Form:
![Listing View](https://raw.githubusercontent.com/hypy13/django-daisy/refs/heads/main/screenshots/inline_admin.png)

##### Mobile Responsive:
![Listing View](https://raw.githubusercontent.com/hypy13/django-daisy/refs/heads/main/screenshots/mobile.png)

##### Dark Theme:
![Listing View](https://raw.githubusercontent.com/hypy13/django-daisy/refs/heads/main/screenshots/dark_theme.png)


Elevate your Django admin panel with **Django Daisy** – an elegant, powerful, and flexible solution for modern web applications!

