# auto generated by update_py.py

import threading

from tlclient.linker.fist import Fist
from tlclient.linker.event import Event
from tlclient.linker.frame import FrameHeaderStatus
from tlclient.linker.timer import Timer
from tlclient.trader.client import Client
from importlib import import_module


class TunnelClient(Client):

    def __init__(self, name: str, tunnel_name: str, config_file_path: str):
        super().__init__(name, f'tunnel_client', '')
        self._is_req = False
        self._last_req_res = None
        self._cv = threading.Condition()
        self._worker_t = threading.Thread(target=self._worker_func, daemon=True)
        self._logger_t = threading.Thread(target=self._logger_func, daemon=True)

        lib_name = f'lib{tunnel_name}_tunnel_py'
        try:
            imported_lib = import_module(lib_name)
            # globals()[lib_name] = imported_lib
        except Exception:
            raise Exception(f'cannot find lib named {lib_name} (config_file_path){config_file_path}')
        self._tunnel = imported_lib.Tunnel(config_file_path)
        self.logger.info(f'init done (name){name} (tunnel_name){tunnel_name} (config_file_path){config_file_path}')

    def _log_func(self, info):
        self.logger.info(f'{info}')

    def _worker_func(self):
        try:
            while not self.is_stopped():
                data: bytes = self._tunnel.get_one_data()
                e = Event.new_event(data[1:])
                if e is not None:
                    if data[0] == ord('1'):
                        with self._cv:
                            self._last_req_res = e
                            self._cv.notify_all()
                    elif data[0] == ord('2'):
                        for f in e.frames():
                            self.on_pub_frame(f)
                    else:
                        self.logger.warn(f'got unknown type({data[0]}) data')
        except Exception as e:
            self.logger.exception('_worker_func failed!')
            self.stop(-1)
            raise e

    def _logger_func(self):
        try:
            while not self.is_stopped():
                one_log: str = self._tunnel.get_one_log()
                self.logger.info(one_log)
        except Exception as e:
            self.logger.exception('_logger_func failed!')
            self.stop(-1)
            raise e

    # @staticmethod
    # def _on_data(data: bytes):
    #     # self.logger.info(len(data))
    #     e = Event.new_event(data[1:])
    #     if e is not None:
    #         if data[0] == '1':
    #             self._last_req_res = e
    #         elif data[0] == '2':
    #             for f in e.frames():
    #                 self.on_pub_frame(f)

    # override base version
    def init_trade(self, router_name):
        self.trade_router = router_name

    def init_market(self, router_name):
        self.market_router = router_name

    def start(self):
        self.logger.info('starting...')
        self._worker_t.start()
        self._logger_t.start()
        self.logger.info('start done')

    def create_fist(self):
        pass

    def init_oms(self, oms_name):
        pass

    def init_dm(self, api_key, secret_key):
        pass

    def req(self, path_tag, msg, msg_type, req_id):
        self.logger.info(f'(path_tag){path_tag} (msg_type){msg_type} (req_id){req_id} (is_req){self._is_req}')
        with self._cv:
            if not self._cv.wait_for(lambda: not self._is_req, Fist.REQ_WAIT_TIME / 1000 + 4):
                self.logger.warn('wait for prev req expired')
                raise Exception('Timeout in wait prev req!')
            self._is_req = True

        f = Event.new_pb_frame()
        f._frame.header.content_id = path_tag
        f.set_status(FrameHeaderStatus.NORMAL)
        f.set_msg_type(msg_type)
        f.set_req_id(req_id)
        f.set_nano(Timer.nano())
        f.set_data(msg)
        self._tunnel.send_data(f.buf)
        with self._cv:
            if not self._cv.wait_for(lambda: self._last_req_res is not None, Fist.REQ_WAIT_TIME / 1000 + 2):
                self._is_req = False
                self.logger.warn('wait for req response expired')
                raise Exception('Timeout in req!')
            ret = self._last_req_res
            self._last_req_res = None
            self._is_req = False
            self._cv.notify_all()
        return ret
