/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2ORegressionMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all regression metrics supported by CoxPH algorithm.")
@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001b\tI\u0002JM(SK\u001e\u0014Xm]:j_:\u001cu\u000e\u001f)I\u001b\u0016$(/[2t\u0015\t\u0019A!A\u0004nKR\u0014\u0018nY:\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0005ta\u0006\u00148\u000e\\5oO*\u0011\u0011BC\u0001\u0004QJz'\"A\u0006\u0002\u0005\u0005L7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003)!\u0013tJU3he\u0016\u001c8/[8o\u001b\u0016$(/[2t\u0011!\u0019\u0002A!b\u0001\n\u0003\"\u0012aA;jIV\tQ\u0003\u0005\u0002\u001799\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\u00051\u0001K]3eK\u001aL!!\b\u0010\u0003\rM#(/\u001b8h\u0015\tY\u0002\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0011)\u0018\u000e\u001a\u0011\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u0010\u0001!)1#\ta\u0001+!)!\u0005\u0001C\u0001OQ\tA\u0005C\u0004*\u0001\t\u0007I\u0011\u0003\u0016\u0002\u0017\r|gnY8sI\u0006t7-Z\u000b\u0002WA\u0011AFN\u0007\u0002[)\u0011afL\u0001\u0006a\u0006\u0014\u0018-\u001c\u0006\u0003\u000bAR!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0005\u0003o5\u00121\u0002R8vE2,\u0007+\u0019:b[\"1\u0011\b\u0001Q\u0001\n-\nAbY8oG>\u0014H-\u00198dK\u0002Bqa\u000f\u0001C\u0002\u0013EA(\u0001\u0006d_:\u001cwN\u001d3b]R,\u0012!\u0010\t\u0003YyJ!aP\u0017\u0003\u00131{gn\u001a)be\u0006l\u0007BB!\u0001A\u0003%Q(A\u0006d_:\u001cwN\u001d3b]R\u0004\u0003bB\"\u0001\u0005\u0004%\t\u0002P\u0001\u000bI&\u001c8m\u001c:eC:$\bBB#\u0001A\u0003%Q(A\u0006eSN\u001cwN\u001d3b]R\u0004\u0003bB$\u0001\u0005\u0004%\t\u0002P\u0001\u0006i&,G-\u0017\u0005\u0007\u0013\u0002\u0001\u000b\u0011B\u001f\u0002\rQLW\rZ-!\u0011\u0015Y\u0005\u0001\"\u0001M\u000399W\r^\"p]\u000e|'\u000fZ1oG\u0016$\u0012!\u0014\t\u0003/9K!a\u0014\r\u0003\r\u0011{WO\u00197f\u0011\u0015\t\u0006\u0001\"\u0001S\u000359W\r^\"p]\u000e|'\u000fZ1oiR\t1\u000b\u0005\u0002\u0018)&\u0011Q\u000b\u0007\u0002\u0005\u0019>tw\rC\u0003X\u0001\u0011\u0005!+A\u0007hKR$\u0015n]2pe\u0012\fg\u000e\u001e\u0005\u00063\u0002!\tAU\u0001\tO\u0016$H+[3e3\")1\f\u0001C!9\u0006Q1/\u001a;NKR\u0014\u0018nY:\u0015\u0007u\u0003G\u000e\u0005\u0002\u0018=&\u0011q\f\u0007\u0002\u0005+:LG\u000fC\u0003b5\u0002\u0007!-\u0001\u0003kg>t\u0007CA2k\u001b\u0005!'BA3g\u0003\u001197o\u001c8\u000b\u0005\u001dD\u0017AB4p_\u001edWMC\u0001j\u0003\r\u0019w.\\\u0005\u0003W\u0012\u0014!BS:p]>\u0013'.Z2u\u0011\u0015i'\f1\u0001\u0016\u0003\u001d\u0019wN\u001c;fqRDQa\u001c\u0001\u0005BA\fAaY8qsR\u0011\u0011O]\u0007\u0002\u0001!)1O\u001ca\u0001i\u0006)Q\r\u001f;sCB\u0011A&^\u0005\u0003m6\u0012\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0005\u0001a\\H\u0010\u0005\u0002\u0010s&\u0011!P\u0001\u0002\u0013\u001b\u0016$(/[2t\t\u0016\u001c8M]5qi&|g.A\u0006eKN\u001c'/\u001b9uS>t\u0017%A?\u0002\u001dRCW\rI2mCN\u001c\b%\\1lKN\u0004\u0013M^1jY\u0006\u0014G.\u001a\u0011bY2\u0004#/Z4sKN\u001c\u0018n\u001c8![\u0016$(/[2tAM,\b\u000f]8si\u0016$\u0007EY=!\u0007>D\b\u000b\u0013\u0011bY\u001e|'/\u001b;i[:\u0002")
public class H2ORegressionCoxPHMetrics
extends H2ORegressionMetrics {
    private final String uid;
    private final DoubleParam concordance;
    private final LongParam concordant;
    private final LongParam discordant;
    private final LongParam tiedY;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam concordance() {
        return this.concordance;
    }

    public LongParam concordant() {
        return this.concordant;
    }

    public LongParam discordant() {
        return this.discordant;
    }

    public LongParam tiedY() {
        return this.tiedY;
    }

    public double getConcordance() {
        return BoxesRunTime.unboxToDouble(this.$(this.concordance()));
    }

    public long getConcordant() {
        return BoxesRunTime.unboxToLong(this.$(this.concordant()));
    }

    public long getDiscordant() {
        return BoxesRunTime.unboxToLong(this.$(this.discordant()));
    }

    public long getTiedY() {
        return BoxesRunTime.unboxToLong(this.$(this.tiedY()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        super.setMetrics(json, context);
        if (json.has("concordance")) {
            try {
                params3 = this.set("concordance", BoxesRunTime.boxToDouble((double)json.get("concordance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'concordance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'concordance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("concordant")) {
            try {
                params2 = this.set("concordant", BoxesRunTime.boxToLong((long)json.get("concordant").getAsLong()));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'concordant' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'concordant' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("discordant")) {
            try {
                params = this.set("discordant", BoxesRunTime.boxToLong((long)json.get("discordant").getAsLong()));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'discordant' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'discordant' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("tied_y")) {
            try {
                this.set("tiedY", BoxesRunTime.boxToLong((long)json.get("tied_y").getAsLong()));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'tied_y' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'tied_y' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            return;
        }
    }

    @Override
    public H2ORegressionCoxPHMetrics copy(ParamMap extra) {
        return (H2ORegressionCoxPHMetrics)this.defaultCopy(extra);
    }

    public H2ORegressionCoxPHMetrics(String uid) {
        this.uid = uid;
        this.concordance = this.doubleParam("concordance", "concordance index.");
        this.concordant = this.longParam("concordant", "number of concordant pairs.");
        this.discordant = this.longParam("discordant", "number of discordant pairs.");
        this.tiedY = this.longParam("tiedY", "number of pairs tied in Y value.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.concordance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2ORegressionCoxPHMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2ORegressionCoxPHMetrics"));
    }
}

