# Input Files

## ALLCools Starts From Mapped Data
ALLCools is designed for post-mapping data preprocessing ana analysis. 
Therefore, ALLCools start from mapped and demultiplexed data. 
Please refer to the data provider or corresponding methods/pipelines for 
demultiplexing single-cell reads and mapping them on to reference genome.

```{note}
For all the data generated by snmC-seq and related single-cell multi-omics technologies in Ecker Lab, 
we use [YAP](https://hq-1.gitbook.io/mc/) pipeline to demultiplex and map the reads. YAP uses the bismark 
to map reads, and generate single-cell ALLC files from each filtered BAM files.
```

After demultiplexing and mapping, you should get one BAM file per cell containing sorted, non-duplicated, 
uniquely mapped reads, you can then create ALLC files
using [`allcools` command line tools](../command_line/allcools.ipynb). 

## ALLCools Uses Three File Formats
We use three file formats to store three different levels of information: 
```{div} full-width
**File Format**|**Number of Methylomes**|**Genome Resolution**|**Data Type**|**mC Context**|**Matrix Form**|**Based On**
-----|-----|-----|-----|-----|-----|-----
ALLC|single|single base pair|raw counts|all mC context|N.A.|tab-separated table, compressed by [bgzip](http://www.htslib.org/doc/bgzip.html), indexed by [tabix](http://www.htslib.org/doc/tabix.html)
MCDS|multiple|genome region<br/>(large size, small number)|raw counts|multiple user-defined mC context|N-D Dense Matrix|[`xarray.Dataset`](http://xarray.pydata.org/en/stable/data-structures.html#dataset)
MCAD|multiple|genome region<br/>(small size, large number)|hypo-methylation score|single mC context|2-D Sparse Matrix|[`anndata.AnnData`](https://anndata.readthedocs.io/en/latest/index.html)
```

### Relationships between these file formats
The ALLC files are generated from sequencing data, the MCDS and MCAD files are then generated from a set of ALLC files 
(usually, thousands of single-cell ALLC files coming from the same experiment). 
The MCDS or MCAD files are the starting point of cell-level analysis.

```{figure} ./data_model.png
---
height: 300px
name: data-model-fig
---
ALLCools data model for handling single-cell methylomes and performing cell-level analysis.
```

## Base-level, Single Methylome

### ALLC File
The ALLC (ALL Cytosine) format is a tab-separated table containing **base level methylation and coverage counts**. 
This format is originally defined by [`methylpy`](https://github.com/yupenghe/methylpy), a python package developed 
in the Ecker lab for bulk WGBS-seq data analysis. Each row in an ALLC file corresponds to one cytosine in the genome. 
An ALLC file contains 7 mandatory columns and no header. ALLCools assumes all the ALLC files are compressed and 
indexed by [`bgzip`](http://www.htslib.org/doc/bgzip.html) and [`tabix`](http://www.htslib.org/doc/tabix.html) from 
the [htslib](http://www.htslib.org/). The ALLC file 
[generated from a single-cell BAM file](../command_line/allcools_allc.ipynb) 
only contains information from a single cell, while the ALLC file can also be 
[merged from multiple ALLC files](../command_line/allcools_merge.ipynb) 
(e.g., merge by cell cluster) as a pseudo-bulk-level methylation table.

For more details on generating and handling ALLC files, please read the [`allcools` command line tools](
../command_line/allcools.ipynb) introduction.

#### Columns in ALLC file
**index**|**column name**|**example**|**note**
-----|-----|-----|-----
1|chromosome|chr12|chromosome names need to be the same as genome FASTA
2|position|18283342|1-based
3|strand|+|either + or -
4|sequence context|CGT|can be more than 3 bases
5|mc|1|count of reads supporting methylation
6|cov|2|read coverage
7|methylated|1|indicator of significant methylation (1 if no test is performed)

#### Compression and Indexing ALLC
All the ALLC files generated by ALLCools are compressed by [`bgzip`](http://www.htslib.org/doc/bgzip.html) 
and indexed by [`tabix`](http://www.htslib.org/doc/tabix.html). The `tabix` enable us to query ALLC files with 
specific genomic regions. To check whether your ALLC files meet the standard, you can use 
[`allcools standard`](../command_line/allcools_standard.ipynb) to validate the compression and indexing. 
You can also use [`allcools tbi`](../command_line/allcools_tbi.ipynb) to index ALLC file using `tabix`.

## Region-level, Multiple Methylomes
For cell-level analysis like clustering, we need to first aggregate the base-level methylation information into 
region-level, and gathering thousands of cells together into a data matrix. To do so, we provide two kinds 
of format MCDS and MCAD for different purpose.

### MCDS File - N-D dense matrix for raw counts

```{figure} ./mcds.png
---
height: 250px
name: mcds-fig
---
Schematic of one MCDS file.
```

The MCDS is a versatile data matrix format for storing region-level raw methylation counts from a set of cells. 
It aims to handle relatively large regions (KBs to MBs), such as 100Kb genomic bins or gene body regions. 
Because these regions are large, with the typical coverage of single-cell methylome data (for snmC-seq2, 
1.6M reads per cell), the raw count matrix is not sparse at all (~80-90% non-zero values). Therefore, we store 
MCDS as dense N-dimensional matrix, with **four common dimensions** representing the cells, regions, methylation 
context (e.g., CH or CG), and count type (e.g, methylated base count (mc in ALLC) or total base count (cov in ALLC)).

#### MCDS store multiple region sets together
It is also necessary to count the same cell using different region sets. For example, in the brain cell clustering 
analysis, we will [use 100Kb genomic bins in clustering](../cell_level/basic/mch_mcg_100k_basic.ipynb) and [use the 
gene body regions to identify DMGs](../cell_level/dmg/intro_dmg.md). One MCDS can save multiple region sets together,
making it easy to switch between different region sets.

#### MCDS enables on-disk data handling
Single-cell methylome dataset is essentially hundreds of thousands of whole-genome sequencing datasets. Due to this 
high coverage (million reads per cell) nature, cell-level analysis, especially preprocessing steps before dimension 
reduction, can be quite memory intensive. One of the most important reason we chose `xarray.Dataset`
to model MCDS is because [it allows on-disk data manipulation and lazy computation](
http://xarray.pydata.org/en/stable/dask.html). This feature enabled by python package `xarray` and `dask` allow us to 
handle hundreds of thousands of single-cell methylomes that don't fit into the memory of a single computational node.
Still, memory consumption need to be carefully monitored when doing the single-cell methylome data analysis, especially
before dimension reduction.

### MCAD File - 2-D sparse matrix for hypo-methylation score

```{figure} ./mcad.png
---
height: 250px
name: mcad-fig
---
Schematic of one MCAD file.
```

Alternatively, one may need to count the single-cell methylomes with small genomic regions (e.g., 5Kb genomic 
bins or hundreds of bp DMRs), since smaller regions might capture methylation diversity at cis-regulatory elements 
better during cell-level analysis.

The caveats of using small regions are that 1) the matrix sparsity increases when the region is small; 2) the 
number of total regions need to be considered also goes up quickly. Therefore, storing the matrix in dense format 
like MCDS did is not appropriate anymore, we switch to use the anndata.AnnData class to store a sparse matrix.

#### MCAD store processed hypo-methylation score
Currently, one MCAD file only store one kind of methylation context (e.g., mCG) from one set of regions (e.g., 
5Kb genomic bins). To further reduce the matrix size, we calculated hypo-methylation score (see below) from the raw 
counts, and filter the hypo-methylation score by a loose cutoff (0.9 by default) to only store significant values.

#### Hypo-methylation score
```{note}
The hypo-methylation score range from 0 to 1, larger value means the region is more hypo-methylated in the cell.
```
The hypo-methylation score is calculated by performing binomial test on each individual base count pair, and then used
the survival function (1 - p) as the value. This value range from 0 to 1, with a higher value indicates more 
hypo-methylated (potentially, more open and active). During [analysis using this matrix](
../cell_level/basic/mcg_5kb_basic.ipynb), we will apply more filters and then binarize it to apply the algorithms
adapted from snATAC-seq analysis.
