"use strict";
const nodeunit_1 = require("nodeunit");
const lambda = require("../lib");
module.exports = nodeunit_1.testCase({
    'runtimes are equal for different instances'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, true, 'Runtimes should be equal');
        test.done();
    },
    'runtimes are equal for same instance'(test) {
        // GIVEN
        const runtime = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime.runtimeEquals(runtime);
        // THEN
        test.strictEqual(result, true, 'Runtimes should be equal');
        test.done();
    },
    'unequal when name changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.6', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when name changes');
        test.done();
    },
    'unequal when family changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.JAVA, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when family changes');
        test.done();
    },
    'unequal when supportsInlineCode changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: false });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when supportsInlineCode changes');
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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