"use strict";
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'throws if maxBatchingWindow > 300 seconds'(test) {
        const stack = new cdk.Stack();
        const fn = new lib_1.Function(stack, 'fn', {
            handler: 'index.handler',
            code: lib_1.Code.fromInline(`exports.handler = \${handler.toString()}`),
            runtime: lib_1.Runtime.NODEJS_10_X
        });
        test.throws(() => new lib_1.EventSourceMapping(stack, 'test', {
            target: fn,
            eventSourceArn: '',
            maxBatchingWindow: cdk.Duration.seconds(301)
        }), /maxBatchingWindow cannot be over 300 seconds/);
        test.done();
    },
    'throws if maxRecordAge is below 60 seconds'(test) {
        const stack = new cdk.Stack();
        const fn = new lib_1.Function(stack, 'fn', {
            handler: 'index.handler',
            code: lib_1.Code.fromInline(`exports.handler = \${handler.toString()}`),
            runtime: lib_1.Runtime.NODEJS_10_X
        });
        test.throws(() => new lib_1.EventSourceMapping(stack, 'test', {
            target: fn,
            eventSourceArn: '',
            maxRecordAge: cdk.Duration.seconds(59)
        }), /maxRecordAge must be between 60 seconds and 7 days inclusive/);
        test.done();
    },
    'throws if maxRecordAge is over 7 days'(test) {
        const stack = new cdk.Stack();
        const fn = new lib_1.Function(stack, 'fn', {
            handler: 'index.handler',
            code: lib_1.Code.fromInline(`exports.handler = \${handler.toString()}`),
            runtime: lib_1.Runtime.NODEJS_10_X
        });
        test.throws(() => new lib_1.EventSourceMapping(stack, 'test', {
            target: fn,
            eventSourceArn: '',
            maxRecordAge: cdk.Duration.seconds(604801)
        }), /maxRecordAge must be between 60 seconds and 7 days inclusive/);
        test.done();
    },
    'throws if retryAttempts is negative'(test) {
        const stack = new cdk.Stack();
        const fn = new lib_1.Function(stack, 'fn', {
            handler: 'index.handler',
            code: lib_1.Code.fromInline(`exports.handler = \${handler.toString()}`),
            runtime: lib_1.Runtime.NODEJS_10_X
        });
        test.throws(() => new lib_1.EventSourceMapping(stack, 'test', {
            target: fn,
            eventSourceArn: '',
            retryAttempts: -1
        }), /retryAttempts must be between 0 and 10000 inclusive, got -1/);
        test.done();
    },
    'throws if retryAttempts is over 10000'(test) {
        const stack = new cdk.Stack();
        const fn = new lib_1.Function(stack, 'fn', {
            handler: 'index.handler',
            code: lib_1.Code.fromInline(`exports.handler = \${handler.toString()}`),
            runtime: lib_1.Runtime.NODEJS_10_X
        });
        test.throws(() => new lib_1.EventSourceMapping(stack, 'test', {
            target: fn,
            eventSourceArn: '',
            retryAttempts: 10001
        }), /retryAttempts must be between 0 and 10000 inclusive, got 10001/);
        test.done();
    },
    'throws if parallelizationFactor is below 1'(test) {
        const stack = new cdk.Stack();
        const fn = new lib_1.Function(stack, 'fn', {
            handler: 'index.handler',
            code: lib_1.Code.fromInline(`exports.handler = \${handler.toString()}`),
            runtime: lib_1.Runtime.NODEJS_10_X
        });
        test.throws(() => new lib_1.EventSourceMapping(stack, 'test', {
            target: fn,
            eventSourceArn: '',
            parallelizationFactor: 0
        }), /parallelizationFactor must be between 1 and 10 inclusive, got 0/);
        test.done();
    },
    'throws if parallelizationFactor is over 10'(test) {
        const stack = new cdk.Stack();
        const fn = new lib_1.Function(stack, 'fn', {
            handler: 'index.handler',
            code: lib_1.Code.fromInline(`exports.handler = \${handler.toString()}`),
            runtime: lib_1.Runtime.NODEJS_10_X
        });
        test.throws(() => new lib_1.EventSourceMapping(stack, 'test', {
            target: fn,
            eventSourceArn: '',
            parallelizationFactor: 11
        }), /parallelizationFactor must be between 1 and 10 inclusive, got 11/);
        test.done();
    },
    'import event source mapping'(test) {
        const stack = new cdk.Stack(undefined, undefined, { stackName: 'test-stack' });
        const imported = lib_1.EventSourceMapping.fromEventSourceMappingId(stack, 'imported', '14e0db71-5d35-4eb5-b481-8945cf9d10c2');
        test.equals(imported.eventSourceMappingId, '14e0db71-5d35-4eb5-b481-8945cf9d10c2');
        test.equals(imported.stack.stackName, 'test-stack');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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