import * as iam from '@aws-cdk/aws-iam';
import * as logs from '@aws-cdk/aws-logs';
import * as cdk from '@aws-cdk/core';
/**
 * Construction properties for a LogRetention.
 */
export interface LogRetentionProps {
    /**
     * The log group name.
     */
    readonly logGroupName: string;
    /**
     * The number of days log events are kept in CloudWatch Logs.
     */
    readonly retention: logs.RetentionDays;
    /**
     * The IAM role for the Lambda function associated with the custom resource.
     *
     * @default - A new role is created
     */
    readonly role?: iam.IRole;
}
/**
 * Creates a custom resource to control the retention policy of a CloudWatch Logs
 * log group. The log group is created if it doesn't already exist. The policy
 * is removed when `retentionDays` is `undefined` or equal to `Infinity`.
 */
export declare class LogRetention extends cdk.Construct {
    /**
     * The ARN of the LogGroup.
     */
    readonly logGroupArn: string;
    constructor(scope: cdk.Construct, id: string, props: LogRetentionProps);
}
