# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class ActivateMediaWorkflowRequest(TeaModel):
    def __init__(self, media_workflow_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the media workflow. You can obtain the ID from the response of the [AddMediaWorkflow](~~44437~~) operation.
        self.media_workflow_id = media_workflow_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ActivateMediaWorkflowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ActivateMediaWorkflowResponseBodyMediaWorkflow(TeaModel):
    def __init__(self, creation_time=None, media_workflow_id=None, name=None, state=None, topology=None):
        # The time when the media workflow was created.
        self.creation_time = creation_time  # type: str
        # The ID of the media workflow.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the media workflow.
        self.name = name  # type: str
        # The status of the media workflow. The value is **Active**.
        self.state = state  # type: str
        # The topology of the media workflow.
        self.topology = topology  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ActivateMediaWorkflowResponseBodyMediaWorkflow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        return self


class ActivateMediaWorkflowResponseBody(TeaModel):
    def __init__(self, media_workflow=None, request_id=None):
        # The details of the media workflow.
        self.media_workflow = media_workflow  # type: ActivateMediaWorkflowResponseBodyMediaWorkflow
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_workflow:
            self.media_workflow.validate()

    def to_map(self):
        _map = super(ActivateMediaWorkflowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow is not None:
            result['MediaWorkflow'] = self.media_workflow.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflow') is not None:
            temp_model = ActivateMediaWorkflowResponseBodyMediaWorkflow()
            self.media_workflow = temp_model.from_map(m['MediaWorkflow'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActivateMediaWorkflowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ActivateMediaWorkflowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ActivateMediaWorkflowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActivateMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaRequest(TeaModel):
    def __init__(self, cate_id=None, cover_url=None, description=None, file_url=None, input_unbind=None,
                 media_workflow_id=None, media_workflow_user_data=None, override_params=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, tags=None, title=None):
        # The ID of the category to which the media file belongs. The value cannot be negative.
        self.cate_id = cate_id  # type: long
        # The storage location of the thumbnail that you want to specify for the media file. To obtain the URL, you can log on to the **MPS console** and choose **Workflows** > **Media Buckets**. Alternatively, you can log on to the **OSS console** and click **My OSS Paths**.
        # 
        # *   The value can be up to 3,200 bytes in length.
        # *   The URL complies with RFC 2396 and is encoded in UTF-8, with reserved characters being percent-encoded.
        self.cover_url = cover_url  # type: str
        # The description of the media file.
        # 
        # *   The description can be up to 1,024 bytes in length.
        # *   The value is encoded in UTF-8.
        self.description = description  # type: str
        # The path of the input file. You can query the path of the input file in the MPS or OSS console. For more information, see the **Triggering and matching rule for a workflow** section of this topic.
        # 
        # *   The value can be up to 3,200 bytes in length.
        # *   The URL complies with RFC 2396 and is encoded in UTF-8, with reserved characters being percent-encoded.
        self.file_url = file_url  # type: str
        # Specifies whether to check if the media workflow supports the specified input path. We recommend that you set this parameter to true to avoid errors that may result from invalid paths. Valid values:
        # 
        # *   **true**: checks whether the workflow supports the specified input path.
        # *   **false**: does not check whether the workflow supports the specified input path.
        self.input_unbind = input_unbind  # type: bool
        # The ID of the media workflow that you want to run for the media file. To query the ID of a media workflow, you can log on to the MPS console or call the [AddMediaWorkflow](~~44437~~) operation.
        self.media_workflow_id = media_workflow_id  # type: str
        # The custom data of the media workflow.
        # 
        # *   The value can be up to 1,024 bytes in length.
        # *   The value is encoded in UTF-8.
        self.media_workflow_user_data = media_workflow_user_data  # type: str
        # The subtitle settings that are used to overwrite the original settings.
        # 
        # *   Example 1: Use `{"WebVTTSubtitleOverrides",[{"RefActivityName":"subtitleNode","WebVTTSubtitleURL":"http://test.oss-cn-hangzhou.aliyuncs.com/example1.vtt"}]}` to overwrite the original subtitle settings during HTTP Live Streaming (HLS) packaging.
        # *   Example 2: Use `{"subtitleTransNodeName":{"InputConfig":{"Format":"stl","InputFile":{"URL":"http://subtitleBucket.oss-cn-hangzhou.aliyuncs.com/package/example/CENG.stl"}}}}` to overwrite the original subtitle settings during Dynamic Adaptive Streaming over HTTP (DASH) packaging.
        self.override_params = override_params  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The tags that you want to add for the media file.
        # 
        # >  In MPS, each tag that is specified for a media file is independent. You can search for all the media files that have the same tags in the Media Library.
        # 
        # *   Separate multiple tags with commas (,). You can specify up to 16 tags for a media file.
        # *   Each tag can be up to 32 bytes in length.
        # *   The value is encoded in UTF-8.
        self.tags = tags  # type: str
        # The title of the media file.
        # 
        # *   The title can be up to 128 bytes in length.
        # *   The value is encoded in UTF-8.
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMediaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.description is not None:
            result['Description'] = self.description
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.input_unbind is not None:
            result['InputUnbind'] = self.input_unbind
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_user_data is not None:
            result['MediaWorkflowUserData'] = self.media_workflow_user_data
        if self.override_params is not None:
            result['OverrideParams'] = self.override_params
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('InputUnbind') is not None:
            self.input_unbind = m.get('InputUnbind')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowUserData') is not None:
            self.media_workflow_user_data = m.get('MediaWorkflowUserData')
        if m.get('OverrideParams') is not None:
            self.override_params = m.get('OverrideParams')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class AddMediaResponseBodyMediaFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the input file. The default value is **Normal**.
        self.state = state  # type: str
        # The URL of the input file.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMediaResponseBodyMediaFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class AddMediaResponseBodyMediaRunIdList(TeaModel):
    def __init__(self, run_id=None):
        self.run_id = run_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMediaResponseBodyMediaRunIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.run_id is not None:
            result['RunId'] = self.run_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        return self


class AddMediaResponseBodyMediaTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMediaResponseBodyMediaTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class AddMediaResponseBodyMedia(TeaModel):
    def __init__(self, bitrate=None, cate_id=None, censor_state=None, cover_url=None, creation_time=None,
                 description=None, duration=None, file=None, format=None, fps=None, height=None, media_id=None,
                 publish_state=None, run_id_list=None, size=None, tags=None, title=None, width=None):
        # The bitrate of the media file.
        self.bitrate = bitrate  # type: str
        # The ID of the category to which the media file belongs.
        self.cate_id = cate_id  # type: long
        # The review status of the video. Valid values:
        # 
        # *   **Initiated**: The media file is uploaded but not reviewed.
        # *   **Pass**: The media file is uploaded and passes the review.
        self.censor_state = censor_state  # type: str
        # The storage location of the media thumbnail.
        self.cover_url = cover_url  # type: str
        # The time when the media file was created.
        self.creation_time = creation_time  # type: str
        # The description of the media file. The value is no longer than 1,024 bytes.
        self.description = description  # type: str
        # The duration of the media file.
        self.duration = duration  # type: str
        # The information about the input file.
        self.file = file  # type: AddMediaResponseBodyMediaFile
        # The format of the media file. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format = format  # type: str
        # The frame rate of the media file.
        self.fps = fps  # type: str
        # The height of the media file.
        self.height = height  # type: str
        # The ID of the media file.
        self.media_id = media_id  # type: str
        # The publishing status of the media file. Valid values:
        # 
        # *   **Initiated**: The media file is in the initial state.
        # *   **UnPublish**: The media file has not been published, and the playback permission on the OSS object is Private.
        # *   **Published**: The media file has been published, and the playback permission on the OSS object is Default.
        self.publish_state = publish_state  # type: str
        # The IDs of the executed workflow execution instances. The IDs are separated by commas (,).
        self.run_id_list = run_id_list  # type: AddMediaResponseBodyMediaRunIdList
        # The size of the media file.
        self.size = size  # type: str
        # The tags of the media file.
        self.tags = tags  # type: AddMediaResponseBodyMediaTags
        # The title of the media file. The title is no longer than 128 bytes.
        self.title = title  # type: str
        # The width of the media file.
        self.width = width  # type: str

    def validate(self):
        if self.file:
            self.file.validate()
        if self.run_id_list:
            self.run_id_list.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(AddMediaResponseBodyMedia, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.censor_state is not None:
            result['CensorState'] = self.censor_state
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.publish_state is not None:
            result['PublishState'] = self.publish_state
        if self.run_id_list is not None:
            result['RunIdList'] = self.run_id_list.to_map()
        if self.size is not None:
            result['Size'] = self.size
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CensorState') is not None:
            self.censor_state = m.get('CensorState')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('File') is not None:
            temp_model = AddMediaResponseBodyMediaFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('PublishState') is not None:
            self.publish_state = m.get('PublishState')
        if m.get('RunIdList') is not None:
            temp_model = AddMediaResponseBodyMediaRunIdList()
            self.run_id_list = temp_model.from_map(m['RunIdList'])
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Tags') is not None:
            temp_model = AddMediaResponseBodyMediaTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddMediaResponseBody(TeaModel):
    def __init__(self, media=None, request_id=None):
        # The detailed information about the media file.
        self.media = media  # type: AddMediaResponseBodyMedia
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media:
            self.media.validate()

    def to_map(self):
        _map = super(AddMediaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            temp_model = AddMediaResponseBodyMedia()
            self.media = temp_model.from_map(m['Media'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMediaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddMediaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddMediaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaTagRequest(TeaModel):
    def __init__(self, media_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, tag=None):
        self.media_id = media_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMediaTagRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class AddMediaTagResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMediaTagResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMediaTagResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddMediaTagResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddMediaTagResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMediaTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaWorkflowRequest(TeaModel):
    def __init__(self, name=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, topology=None, trigger_mode=None):
        # The name of the media workflow.
        # 
        # *   The value cannot be empty.
        # *   The name cannot be the same as that of an existing media workflow within the current Alibaba Cloud account.
        # *   The name can be up to 64 characters in length.
        # *   The name can contain only UTF-8 characters.
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The topology of the media workflow. The value must be a JSON object that contains the activity list and activity dependencies. For more information, see the **Sample topology** section of this topic.
        self.topology = topology  # type: str
        # The trigger mode of the media workflow. Valid values:
        # 
        # *   **OssAutoTrigger**: The media workflow is automatically triggered.
        # *   **NotInAuto**: The media workflow is not automatically triggered.
        self.trigger_mode = trigger_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMediaWorkflowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.topology is not None:
            result['Topology'] = self.topology
        if self.trigger_mode is not None:
            result['TriggerMode'] = self.trigger_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        if m.get('TriggerMode') is not None:
            self.trigger_mode = m.get('TriggerMode')
        return self


class AddMediaWorkflowResponseBodyMediaWorkflow(TeaModel):
    def __init__(self, creation_time=None, media_workflow_id=None, name=None, state=None, topology=None,
                 trigger_mode=None):
        # The time when the media workflow was created.
        self.creation_time = creation_time  # type: str
        # The ID of the media workflow. We recommend that you keep this ID for later operations on this workflow.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the media workflow.
        self.name = name  # type: str
        # The status of the media workflow. By default, the created workflow is in the **Active** state.
        self.state = state  # type: str
        # The topology of the media workflow. The value is a JSON object that contains the activity list and activity dependencies.
        self.topology = topology  # type: str
        # The trigger mode of the media workflow. Valid values:
        # 
        # *   **OssAutoTrigger**: The media workflow is automatically triggered.
        # *   **NotInAuto**: The media workflow is not automatically triggered.
        self.trigger_mode = trigger_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMediaWorkflowResponseBodyMediaWorkflow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        if self.trigger_mode is not None:
            result['TriggerMode'] = self.trigger_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        if m.get('TriggerMode') is not None:
            self.trigger_mode = m.get('TriggerMode')
        return self


class AddMediaWorkflowResponseBody(TeaModel):
    def __init__(self, media_workflow=None, request_id=None):
        # The information about the media workflow.
        self.media_workflow = media_workflow  # type: AddMediaWorkflowResponseBodyMediaWorkflow
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_workflow:
            self.media_workflow.validate()

    def to_map(self):
        _map = super(AddMediaWorkflowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow is not None:
            result['MediaWorkflow'] = self.media_workflow.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflow') is not None:
            temp_model = AddMediaWorkflowResponseBodyMediaWorkflow()
            self.media_workflow = temp_model.from_map(m['MediaWorkflow'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMediaWorkflowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddMediaWorkflowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddMediaWorkflowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPipelineRequest(TeaModel):
    def __init__(self, extend_config=None, name=None, notify_config=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, role=None, speed=None, speed_level=None):
        self.extend_config = extend_config  # type: str
        self.name = name  # type: str
        self.notify_config = notify_config  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.role = role  # type: str
        self.speed = speed  # type: str
        self.speed_level = speed_level  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPipelineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_config is not None:
            result['ExtendConfig'] = self.extend_config
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role is not None:
            result['Role'] = self.role
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.speed_level is not None:
            result['SpeedLevel'] = self.speed_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtendConfig') is not None:
            self.extend_config = m.get('ExtendConfig')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('SpeedLevel') is not None:
            self.speed_level = m.get('SpeedLevel')
        return self


class AddPipelineResponseBodyPipelineExtendConfig(TeaModel):
    def __init__(self, is_boost_new=None, max_multi_speed=None, multi_speed_downgrade_policy=None):
        self.is_boost_new = is_boost_new  # type: bool
        self.max_multi_speed = max_multi_speed  # type: int
        self.multi_speed_downgrade_policy = multi_speed_downgrade_policy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPipelineResponseBodyPipelineExtendConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_boost_new is not None:
            result['IsBoostNew'] = self.is_boost_new
        if self.max_multi_speed is not None:
            result['MaxMultiSpeed'] = self.max_multi_speed
        if self.multi_speed_downgrade_policy is not None:
            result['MultiSpeedDowngradePolicy'] = self.multi_speed_downgrade_policy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsBoostNew') is not None:
            self.is_boost_new = m.get('IsBoostNew')
        if m.get('MaxMultiSpeed') is not None:
            self.max_multi_speed = m.get('MaxMultiSpeed')
        if m.get('MultiSpeedDowngradePolicy') is not None:
            self.multi_speed_downgrade_policy = m.get('MultiSpeedDowngradePolicy')
        return self


class AddPipelineResponseBodyPipelineNotifyConfig(TeaModel):
    def __init__(self, mq_tag=None, mq_topic=None, queue_name=None, topic=None):
        self.mq_tag = mq_tag  # type: str
        self.mq_topic = mq_topic  # type: str
        self.queue_name = queue_name  # type: str
        self.topic = topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPipelineResponseBodyPipelineNotifyConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mq_tag is not None:
            result['MqTag'] = self.mq_tag
        if self.mq_topic is not None:
            result['MqTopic'] = self.mq_topic
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MqTag') is not None:
            self.mq_tag = m.get('MqTag')
        if m.get('MqTopic') is not None:
            self.mq_topic = m.get('MqTopic')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class AddPipelineResponseBodyPipeline(TeaModel):
    def __init__(self, extend_config=None, id=None, name=None, notify_config=None, quota_allocate=None, role=None,
                 speed=None, speed_level=None, state=None):
        self.extend_config = extend_config  # type: AddPipelineResponseBodyPipelineExtendConfig
        self.id = id  # type: str
        self.name = name  # type: str
        self.notify_config = notify_config  # type: AddPipelineResponseBodyPipelineNotifyConfig
        self.quota_allocate = quota_allocate  # type: long
        self.role = role  # type: str
        self.speed = speed  # type: str
        self.speed_level = speed_level  # type: long
        self.state = state  # type: str

    def validate(self):
        if self.extend_config:
            self.extend_config.validate()
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super(AddPipelineResponseBodyPipeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_config is not None:
            result['ExtendConfig'] = self.extend_config.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.quota_allocate is not None:
            result['QuotaAllocate'] = self.quota_allocate
        if self.role is not None:
            result['Role'] = self.role
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.speed_level is not None:
            result['SpeedLevel'] = self.speed_level
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtendConfig') is not None:
            temp_model = AddPipelineResponseBodyPipelineExtendConfig()
            self.extend_config = temp_model.from_map(m['ExtendConfig'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = AddPipelineResponseBodyPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('QuotaAllocate') is not None:
            self.quota_allocate = m.get('QuotaAllocate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('SpeedLevel') is not None:
            self.speed_level = m.get('SpeedLevel')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class AddPipelineResponseBody(TeaModel):
    def __init__(self, pipeline=None, request_id=None):
        self.pipeline = pipeline  # type: AddPipelineResponseBodyPipeline
        self.request_id = request_id  # type: str

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super(AddPipelineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = AddPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPipelineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPipelineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPipelineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSmarttagTemplateRequest(TeaModel):
    def __init__(self, analyse_types=None, face_category_ids=None, face_custom_params_config=None, industry=None,
                 is_default=None, keyword_config=None, knowledge_config=None, label_type=None, label_version=None,
                 landmark_group_ids=None, object_group_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, scene=None, template_name=None):
        self.analyse_types = analyse_types  # type: str
        self.face_category_ids = face_category_ids  # type: str
        self.face_custom_params_config = face_custom_params_config  # type: str
        self.industry = industry  # type: str
        self.is_default = is_default  # type: bool
        self.keyword_config = keyword_config  # type: str
        self.knowledge_config = knowledge_config  # type: str
        self.label_type = label_type  # type: str
        self.label_version = label_version  # type: str
        self.landmark_group_ids = landmark_group_ids  # type: str
        self.object_group_ids = object_group_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.scene = scene  # type: str
        self.template_name = template_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSmarttagTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analyse_types is not None:
            result['AnalyseTypes'] = self.analyse_types
        if self.face_category_ids is not None:
            result['FaceCategoryIds'] = self.face_category_ids
        if self.face_custom_params_config is not None:
            result['FaceCustomParamsConfig'] = self.face_custom_params_config
        if self.industry is not None:
            result['Industry'] = self.industry
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.keyword_config is not None:
            result['KeywordConfig'] = self.keyword_config
        if self.knowledge_config is not None:
            result['KnowledgeConfig'] = self.knowledge_config
        if self.label_type is not None:
            result['LabelType'] = self.label_type
        if self.label_version is not None:
            result['LabelVersion'] = self.label_version
        if self.landmark_group_ids is not None:
            result['LandmarkGroupIds'] = self.landmark_group_ids
        if self.object_group_ids is not None:
            result['ObjectGroupIds'] = self.object_group_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnalyseTypes') is not None:
            self.analyse_types = m.get('AnalyseTypes')
        if m.get('FaceCategoryIds') is not None:
            self.face_category_ids = m.get('FaceCategoryIds')
        if m.get('FaceCustomParamsConfig') is not None:
            self.face_custom_params_config = m.get('FaceCustomParamsConfig')
        if m.get('Industry') is not None:
            self.industry = m.get('Industry')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('KeywordConfig') is not None:
            self.keyword_config = m.get('KeywordConfig')
        if m.get('KnowledgeConfig') is not None:
            self.knowledge_config = m.get('KnowledgeConfig')
        if m.get('LabelType') is not None:
            self.label_type = m.get('LabelType')
        if m.get('LabelVersion') is not None:
            self.label_version = m.get('LabelVersion')
        if m.get('LandmarkGroupIds') is not None:
            self.landmark_group_ids = m.get('LandmarkGroupIds')
        if m.get('ObjectGroupIds') is not None:
            self.object_group_ids = m.get('ObjectGroupIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class AddSmarttagTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        self.request_id = request_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSmarttagTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class AddSmarttagTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddSmarttagTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddSmarttagTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSmarttagTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTemplateRequest(TeaModel):
    def __init__(self, audio=None, container=None, mux_config=None, name=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, trans_config=None, video=None):
        # The audio stream configuration. The value must be a JSON object. For more information, see the [Parameters nested under the Audio parameter](~~29253~~) section of this topic.
        # 
        # >  If you do not set this parameter, output files do not contain audio streams. If you need to retain the audio streams, this parameter is required.
        self.audio = audio  # type: str
        # The container configuration. The value must be a JSON object and contains the Format parameter. If you do not configure the container, the transcoded media file is in MP4 format by default. If you want to use the transcoding template to generate media files in other formats, this parameter is required. For more information, see the [Parameter nested under the Container parameter](~~29253~~) section of this topic.
        # 
        # *   Default value of the Format parameter: mp4.
        # *   Video formats include FLV, MP4, HLS (M3U8 + TS), and MPEG-DASH (MPD + fMP4)
        # 
        # >  If the container format is FLV, the video codec cannot be set to H.265.
        # 
        # *   Audio formats include MP3, MP4, Ogg, FLAC, and M4A
        # 
        # *   Image formats include GIF and WebP.
        # 
        # >*   If the container format is GIF, the video codec must be set to GIF.
        #   *   If the container format is WebP, the video codec must be set to WebP.
        self.container = container  # type: str
        # The segment configuration. The value must be a JSON object. For more information, see the [Parameters nested under the MuxConfig parameter](~~29253~~) section of this topic. If you do not set this parameter, media segment files are not generated. If you want to generate media segment files, this parameter is required.
        self.mux_config = mux_config  # type: str
        # The name of the template. The name can be up to 128 bytes in length.
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The general transcoding configuration. The value must be a JSON object. For more information, see the [Parameters nested under the TransConfig parameter](~~29253~~) section of this topic. If you do not set this parameter, the default settings of this parameter are used. If the default settings cannot meet your transcoding needs, set the parameters nested under the TransConfig parameter as required.
        self.trans_config = trans_config  # type: str
        # The video stream configuration. The value must be a JSON object. For more information, see the [Parameters nested under the Video parameter](~~29253~~) section of this topic.
        # 
        # >  If you do not set this parameter, output files do not contain video streams. If you need to retain the video streams, this parameter is required.
        self.video = video  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio
        if self.container is not None:
            result['Container'] = self.container
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config
        if self.video is not None:
            result['Video'] = self.video
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            self.audio = m.get('Audio')
        if m.get('Container') is not None:
            self.container = m.get('Container')
        if m.get('MuxConfig') is not None:
            self.mux_config = m.get('MuxConfig')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransConfig') is not None:
            self.trans_config = m.get('TransConfig')
        if m.get('Video') is not None:
            self.video = m.get('Video')
        return self


class AddTemplateResponseBodyTemplateAudioVolume(TeaModel):
    def __init__(self, level=None, method=None):
        # The volume adjustment range.
        # 
        # *   Default value: **-20**.
        # *   Unit: dB.
        self.level = level  # type: str
        # The volume adjustment method. Valid values:
        # 
        # *   **auto**: The volume is automatically adjusted.
        # *   **dynamic**: The volume is dynamically adjusted.
        # *   **linear**: The volume is linearly adjusted.
        self.method = method  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateAudioVolume, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class AddTemplateResponseBodyTemplateAudio(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, qscale=None, remove=None,
                 samplerate=None, volume=None):
        # The audio bitrate of the output file.
        # 
        # *   Unit: Kbit/s.
        # *   Default value: **128**.
        self.bitrate = bitrate  # type: str
        # The number of sound channels. Default value: **2**.
        self.channels = channels  # type: str
        # The audio codec. Default audio codec: **AAC**. Valid audio codecs:
        # 
        # *   **AAC**\
        # *   **MP3**\
        # *   **VORBIS**\
        # *   **FLAC**\
        self.codec = codec  # type: str
        # The codec profile of the audio. Valid values when the audio codec is set to **AAC**:****\
        # 
        # *   **aac_low**\
        # *   **aac_he**\
        # *   **aac_he_v2**\
        # *   **aac_ld**\
        # *   **aac_eld**\
        self.profile = profile  # type: str
        # The level of the independent denoising algorithm.
        self.qscale = qscale  # type: str
        # Indicates whether to delete the audio stream.
        # 
        # *   **true**: The audio stream is deleted.
        # *   **false**: The audio stream is retained.
        # *   Default value: **false**.
        self.remove = remove  # type: str
        # The sampling rate.
        # 
        # *   Unit: Hz.
        # *   Default value: **44100**.
        self.samplerate = samplerate  # type: str
        # The details of the volume.
        self.volume = volume  # type: AddTemplateResponseBodyTemplateAudioVolume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateAudio, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = AddTemplateResponseBodyTemplateAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class AddTemplateResponseBodyTemplateContainer(TeaModel):
    def __init__(self, format=None):
        # The container format.
        self.format = format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateContainer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class AddTemplateResponseBodyTemplateMuxConfigGif(TeaModel):
    def __init__(self, dither_mode=None, final_delay=None, is_custom_palette=None, loop=None):
        # The color dithering algorithm of the palette. Valid values: sierra and bayer.
        self.dither_mode = dither_mode  # type: str
        # The duration for which the final frame is paused. Unit: centiseconds.
        self.final_delay = final_delay  # type: str
        # Indicates whether the custom palette is used.
        self.is_custom_palette = is_custom_palette  # type: str
        # The loop count.
        self.loop = loop  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateMuxConfigGif, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class AddTemplateResponseBodyTemplateMuxConfigSegment(TeaModel):
    def __init__(self, duration=None):
        # The length of the segment. Unit: seconds.
        self.duration = duration  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateMuxConfigSegment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class AddTemplateResponseBodyTemplateMuxConfigWebp(TeaModel):
    def __init__(self, loop=None):
        # The loop count.
        self.loop = loop  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateMuxConfigWebp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class AddTemplateResponseBodyTemplateMuxConfig(TeaModel):
    def __init__(self, gif=None, segment=None, webp=None):
        # The transmuxing configuration for GIF.
        self.gif = gif  # type: AddTemplateResponseBodyTemplateMuxConfigGif
        # The segment configuration.
        self.segment = segment  # type: AddTemplateResponseBodyTemplateMuxConfigSegment
        # The transmuxing configuration for WebP.
        self.webp = webp  # type: AddTemplateResponseBodyTemplateMuxConfigWebp

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()
        if self.webp:
            self.webp.validate()

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateMuxConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        if self.webp is not None:
            result['Webp'] = self.webp.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = AddTemplateResponseBodyTemplateMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = AddTemplateResponseBodyTemplateMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        if m.get('Webp') is not None:
            temp_model = AddTemplateResponseBodyTemplateMuxConfigWebp()
            self.webp = temp_model.from_map(m['Webp'])
        return self


class AddTemplateResponseBodyTemplateTransConfig(TeaModel):
    def __init__(self, adj_dar_method=None, is_check_audio_bitrate=None, is_check_audio_bitrate_fail=None,
                 is_check_reso=None, is_check_reso_fail=None, is_check_video_bitrate=None, is_check_video_bitrate_fail=None,
                 trans_mode=None):
        # The method of resolution adjustment. Default value: **none** Valid values:
        # 
        # *   **rescale**: The input video is rescaled.
        # *   **crop**: The input video is cropped.
        # *   **none**: No change is made.
        self.adj_dar_method = adj_dar_method  # type: str
        # Indicates whether to check the audio bitrate.
        # 
        # If this feature is enabled and the system detects that the audio bitrate of the output file is greater than that of the input file, the audio bitrate of the input file is retained after transcoding.
        # 
        # *   **true**: The audio bitrate is checked.
        # *   **false**: The audio bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_audio_bitrate = is_check_audio_bitrate  # type: str
        # Indicates whether to check the audio bitrate. If the bitrate of the output audio is greater than that of the input audio, this parameter has a higher priority than the **IsCheckAudioBitrate** parameter.
        # 
        # *   **true**: The audio bitrate is checked. If the bitrate of the output audio is greater than that of the input audio, the input file is not transcoded.
        # *   **false**: The audio bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail  # type: str
        # Indicates whether to check the resolution.
        # 
        # *   **true**: The resolution is checked.
        # *   **false**: The resolution is not checked.
        # *   Default value: **false**.
        # 
        # >  If this feature is enabled and the system detects that the resolution of the output file is higher than that of the input file based on the width or height, the resolution of the input file is retained after transcoding.
        self.is_check_reso = is_check_reso  # type: str
        # Indicates whether to check the resolution.
        # 
        # *   **true**: The resolution is checked.
        # *   **false**: The resolution is not checked.
        # *   Default value: **false**.
        # 
        # >  If this feature is enabled and the system detects that the resolution of the output file is higher than that of the input file based on the width or height, an error that indicates a transcoding failure is returned.
        self.is_check_reso_fail = is_check_reso_fail  # type: str
        # Indicates whether to check the video bitrate.
        # 
        # *   **true**: The video bitrate is checked.
        # *   **false**: The video bitrate is not checked.
        # *   Default value: **false**.
        # 
        # >  If this feature is enabled and the system detects that the video bitrate of the output file is greater than that of the input file, the video bitrate of the input file is retained after transcoding.
        self.is_check_video_bitrate = is_check_video_bitrate  # type: str
        # If the video bitrate of the output file is found to be greater than that of the input file, this parameter has a higher priority than the IsCheckVideoBitrate parameter. Valid values:
        # 
        # *   **true**: The video bitrate is checked. If the video bitrate of the output file is higher than that of the input file, the input file is not transcoded.
        # *   **false**: The video bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail  # type: str
        # The transcoding mode. Valid values:
        # 
        # *   **onepass**\
        # *   **twopass**\
        # *   **CBR**\
        # *   Default value: **onepass**.
        self.trans_mode = trans_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateTransConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class AddTemplateResponseBodyTemplateVideoBitrateBnd(TeaModel):
    def __init__(self, max=None, min=None):
        # The maximum bitrate.
        self.max = max  # type: str
        # The minimum bitrate.
        self.min = min  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateVideoBitrateBnd, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class AddTemplateResponseBodyTemplateVideo(TeaModel):
    def __init__(self, bitrate=None, bitrate_bnd=None, bufsize=None, codec=None, crf=None, crop=None, degrain=None,
                 fps=None, gop=None, height=None, long_short_mode=None, max_fps=None, maxrate=None, pad=None,
                 pix_fmt=None, preset=None, profile=None, qscale=None, remove=None, reso_priority=None, scan_mode=None,
                 width=None):
        # The bitrate of the output video. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The bitrate range of the video.
        self.bitrate_bnd = bitrate_bnd  # type: AddTemplateResponseBodyTemplateVideoBitrateBnd
        # The size of the buffer.
        # 
        # *   Default value: **6000**.
        # *   Unit: KB.
        self.bufsize = bufsize  # type: str
        # The video codec. Valid video codecs: H.264, H.265, GIF, and WebP. Default video codec: **H.264**.
        self.codec = codec  # type: str
        # The constant rate factor. Default value when the video codec is set to H.264: **23**. Default value when the video codec is set to H.265: **26**.
        # 
        # >  If this parameter is specified, the setting of the Bitrate parameter becomes invalid.
        self.crf = crf  # type: str
        # The method of video cropping. Valid values:
        # 
        # *   **border**: automatically detects and removes borders.
        # *   Value in the format of **width:height:left:top**: crops the video image based on the custom setting. Example: 1280:800:0:140.
        self.crop = crop  # type: str
        # The level of quality control on the video.
        self.degrain = degrain  # type: str
        # The frame rate of the video. Default value: the frame rate of the input file. The value is 60 if the frame rate of the input file exceeds 60. Unit: frames per second.
        self.fps = fps  # type: str
        # The GOP size. The GOP size can be the maximum interval of keyframes or the maximum number of frames in a frame group. If you specified the maximum interval, the value contains the unit (s). If you specified the maximum number of frames, the value does not contain a unit. Default value: **10s**.
        self.gop = gop  # type: str
        # The height of the video.
        # 
        # *   Unit: pixel.
        # *   Default value: the height of the input video.
        self.height = height  # type: str
        # Indicates whether to enable the auto-rotate screen feature. Default value: **false**. Valid values:
        # 
        # *   **true**: The auto-rotate screen feature is enabled.
        # *   **false**: The auto-rotate screen feature is disabled.
        # 
        # >  If this feature is enabled, the width of the output video corresponds to the long side of the input video, which is the height of the input video in portrait mode. The height of the output video corresponds to the short side of the input video, which is the width of the input video in portrait mode.
        self.long_short_mode = long_short_mode  # type: str
        # The maximum frame rate.
        self.max_fps = max_fps  # type: str
        # The maximum bitrate of the output video. Unit: Kbit/s.
        self.maxrate = maxrate  # type: str
        # The black borders to be added to the video. Format: width:height:left:top.
        self.pad = pad  # type: str
        # The pixel format for video color encoding. Standard pixel formats such as yuv420p and yuvj420p are supported. The default pixel format can be yuv420p or the original color format.
        self.pix_fmt = pix_fmt  # type: str
        # The preset video algorithm. Default value: **medium**. Valid values:
        # 
        # *   **veryfast**\
        # *   **fast**\
        # *   **medium**\
        # *   **slow**\
        # *   **slower**\
        # 
        # >  This parameter is valid only when the video codec is set to H.264.
        self.preset = preset  # type: str
        # The codec profile. Valid values:
        # 
        # *   **baseline**: suitable for mobile devices
        # *   **main**: suitable for standard-definition devices
        # *   **high**: suitable for high-definition devices
        # *   Default value: **high**.
        # 
        # If multiple definitions exist, we recommend that you set this parameter to baseline for the lowest definition to ensure normal playback on low-end devices. Set this parameter to main or high for other definitions.
        # 
        # >  This parameter is valid only when the video codec is set to H.264.
        self.profile = profile  # type: str
        # The level of the independent denoising algorithm.
        self.qscale = qscale  # type: str
        # Indicates whether to delete the video stream.
        # 
        # *   **true**: The video stream is deleted.
        # *   **false**: The video stream is retained.
        # *   Default value: **false**.
        self.remove = remove  # type: str
        # The policy of resolution adjustment.
        self.reso_priority = reso_priority  # type: str
        # The scan mode. Valid values:
        # 
        # *   **interlaced**\
        # *   **progressive**\
        self.scan_mode = scan_mode  # type: str
        # The width of the video.
        # 
        # *   Default value: the width of the input video.****\
        # *   Unit: pixel.
        self.width = width  # type: str

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplateVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.reso_priority is not None:
            result['ResoPriority'] = self.reso_priority
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = AddTemplateResponseBodyTemplateVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ResoPriority') is not None:
            self.reso_priority = m.get('ResoPriority')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddTemplateResponseBodyTemplate(TeaModel):
    def __init__(self, audio=None, container=None, id=None, mux_config=None, name=None, state=None, trans_config=None,
                 video=None):
        # The audio codec configuration.
        self.audio = audio  # type: AddTemplateResponseBodyTemplateAudio
        # The container configuration.
        self.container = container  # type: AddTemplateResponseBodyTemplateContainer
        # The ID of the transcoding template. We recommend that you keep this ID for subsequent operation calls.
        self.id = id  # type: str
        # The transmuxing configuration.
        self.mux_config = mux_config  # type: AddTemplateResponseBodyTemplateMuxConfig
        # The name of the template.
        self.name = name  # type: str
        # The status of the template.
        # 
        # *   **Normal**: The template is normal.
        # *   **Deleted**: The template is deleted.
        self.state = state  # type: str
        # The general transcoding configuration.
        self.trans_config = trans_config  # type: AddTemplateResponseBodyTemplateTransConfig
        # The video codec configuration.
        self.video = video  # type: AddTemplateResponseBodyTemplateVideo

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = AddTemplateResponseBodyTemplateAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = AddTemplateResponseBodyTemplateContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MuxConfig') is not None:
            temp_model = AddTemplateResponseBodyTemplateMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TransConfig') is not None:
            temp_model = AddTemplateResponseBodyTemplateTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Video') is not None:
            temp_model = AddTemplateResponseBodyTemplateVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class AddTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The details of the transcoding template.
        self.template = template  # type: AddTemplateResponseBodyTemplate

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super(AddTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = AddTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class AddTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddWaterMarkTemplateRequest(TeaModel):
    def __init__(self, config=None, name=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The configuration of the watermark template. The value is a JSON object. For more information, see [Watermark templates](~~29253~~).
        # 
        # >  If you do not require a positive correlation between the size of text in the watermark and the resolution, you can enable adaptation for the watermark. To do so, add `[\"adaptive\"]=true` to the text parameter of the watermark.
        self.config = config  # type: str
        # The name of the watermark template. The value can contain letters and digits and can be up to 128 bytes in size.
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddWaterMarkTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddWaterMarkTemplateResponseBodyWaterMarkTemplateRatioRefer(TeaModel):
    def __init__(self, dx=None, dy=None, height=None, width=None):
        # The horizontal offset of the watermark relative to the output video image. Default value: **0**. The default value indicates no offset.
        # 
        # The value can be an integer or a decimal.
        # 
        # *   **Integer**: the vertical offset. This indicates the absolute position. Unit: pixel.
        # *   **Decimal**: the ratio of the horizontal offset to the width of the output video. The ratio varies based on the size of the video. Four decimal places are supported, such as 0.9999. More decimal places are discarded.
        self.dx = dx  # type: str
        # The vertical offset of the watermark relative to the output video image. Default value: **0**. The default value indicates no offset. The value can be an integer or a decimal.
        # 
        # *   **Integer**: the vertical offset. This indicates the absolute position. Unit: pixel.
        # *   **Decimal**: the ratio of the vertical offset to the height of the output video. The ratio varies based on the size of the video. Four decimal places are supported, such as 0.9999. More decimal places are discarded.
        self.dy = dy  # type: str
        # The height of the watermark image in the output video. The value can be an integer or a decimal.
        # 
        # *   **Integer**: the height of the watermark image. This indicates the absolute position. Unit: pixel.
        # *   **Decimal**: the ratio of the height of the watermark image to the height of the output video. The ratio varies based on the size of the video. Four decimal places are supported, such as 0.9999. More decimal places are discarded.
        self.height = height  # type: str
        # The width of the watermark image in the output video. The value can be an integer or a decimal.
        # 
        # *   **Integer**: the width of the watermark image. This indicates the absolute position. Unit: pixel.
        # *   **Decimal**: the ratio of the width of the watermark image to the width of the output video. The ratio varies based on the size of the video. Four decimal places are supported, such as 0.9999. More decimal places are discarded.
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddWaterMarkTemplateResponseBodyWaterMarkTemplateRatioRefer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddWaterMarkTemplateResponseBodyWaterMarkTemplateTimeline(TeaModel):
    def __init__(self, duration=None, start=None):
        # The display duration of the watermark. Default value: **ToEND**. The default value indicates that the watermark is displayed until the video ends.
        self.duration = duration  # type: str
        # The beginning of the time range during which the watermark is displayed.
        # 
        # *   Unit: seconds.
        # *   Default value: **0**.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddWaterMarkTemplateResponseBodyWaterMarkTemplateTimeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class AddWaterMarkTemplateResponseBodyWaterMarkTemplate(TeaModel):
    def __init__(self, dx=None, dy=None, height=None, id=None, name=None, ratio_refer=None, refer_pos=None, state=None,
                 timeline=None, type=None, width=None):
        # The horizontal offset. Unit: pixel.
        self.dx = dx  # type: str
        # The vertical offset. Unit: pixel.
        self.dy = dy  # type: str
        # The height of the watermark image. Unit: pixel.
        self.height = height  # type: str
        # The ID of the watermark template. We recommend that you keep this ID for subsequent operation calls.
        self.id = id  # type: str
        # The name of the watermark template.
        self.name = name  # type: str
        # The values of the Height, Width, Dx, and Dy parameters relative to the reference edges. If the values of the Height, Width, Dx, and Dy parameters are decimals between 0 and 1, the values are calculated by referring to the following edges in sequence:
        # 
        # *   **Width**: the width edge.
        # *   **Height**: the height edge.
        # *   **Long**: the long edge.
        # *   **Short**: the short edge.
        self.ratio_refer = ratio_refer  # type: AddWaterMarkTemplateResponseBodyWaterMarkTemplateRatioRefer
        # The position of the watermark. Valid values:
        # 
        # *   **TopRight**: the upper-right corner.
        # *   **TopLeft**: the upper-left corner.
        # *   **BottomRight**: the lower-right corner.
        # *   **BottomLeft**: the lower-left corner.
        self.refer_pos = refer_pos  # type: str
        # The status of the watermark template. Valid values:
        # 
        # *   **Normal**: The watermark template is normal.
        # *   **Deleted**: The watermark template is deleted.
        self.state = state  # type: str
        # The timeline of the watermark.
        self.timeline = timeline  # type: AddWaterMarkTemplateResponseBodyWaterMarkTemplateTimeline
        # The type of the watermark. Valid values:
        # 
        # *   Image: an image watermark.
        # *   Text: a text watermark.
        self.type = type  # type: str
        # The width of the watermark image. Unit: pixel.
        self.width = width  # type: str

    def validate(self):
        if self.ratio_refer:
            self.ratio_refer.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super(AddWaterMarkTemplateResponseBodyWaterMarkTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.ratio_refer is not None:
            result['RatioRefer'] = self.ratio_refer.to_map()
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.state is not None:
            result['State'] = self.state
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RatioRefer') is not None:
            temp_model = AddWaterMarkTemplateResponseBodyWaterMarkTemplateRatioRefer()
            self.ratio_refer = temp_model.from_map(m['RatioRefer'])
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Timeline') is not None:
            temp_model = AddWaterMarkTemplateResponseBodyWaterMarkTemplateTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddWaterMarkTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, water_mark_template=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The details of the watermark template.
        self.water_mark_template = water_mark_template  # type: AddWaterMarkTemplateResponseBodyWaterMarkTemplate

    def validate(self):
        if self.water_mark_template:
            self.water_mark_template.validate()

    def to_map(self):
        _map = super(AddWaterMarkTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.water_mark_template is not None:
            result['WaterMarkTemplate'] = self.water_mark_template.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WaterMarkTemplate') is not None:
            temp_model = AddWaterMarkTemplateResponseBodyWaterMarkTemplate()
            self.water_mark_template = temp_model.from_map(m['WaterMarkTemplate'])
        return self


class AddWaterMarkTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddWaterMarkTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddWaterMarkTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddWaterMarkTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindInputBucketRequest(TeaModel):
    def __init__(self, bucket=None, owner_account=None, owner_id=None, referer=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The name of the input media bucket to be bound. The name can be up to 64 bytes in size. To obtain the media bucket name, you can log on to the **ApsaraVideo Media Processing (MPS) console** and choose **Workflows** > **Media Buckets** in the left-side navigation pane.
        # 
        # >  The bucket name can contain lowercase letters, digits, and hyphens (-), and cannot start or end with a hyphen (-).
        self.bucket = bucket  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The settings of Object Storage Service (OSS) hotlink protection. For more information, see [Hotlink protection](~~31869~~).
        self.referer = referer  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindInputBucketRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.referer is not None:
            result['Referer'] = self.referer
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Referer') is not None:
            self.referer = m.get('Referer')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class BindInputBucketResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindInputBucketResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindInputBucketResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindInputBucketResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindInputBucketResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindInputBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindOutputBucketRequest(TeaModel):
    def __init__(self, bucket=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The name of the Object Storage Service (OSS) bucket that you want to bind. The name can be up to 64 bytes in size and can contain letters, digits, and hyphens (-). The name cannot start with a special character.
        self.bucket = bucket  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindOutputBucketRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class BindOutputBucketResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindOutputBucketResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindOutputBucketResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindOutputBucketResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindOutputBucketResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindOutputBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelJobRequest(TeaModel):
    def __init__(self, job_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.job_id = job_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CancelJobResponseBody(TeaModel):
    def __init__(self, job_id=None, request_id=None):
        self.job_id = job_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomEntityRequest(TeaModel):
    def __init__(self, algorithm=None, custom_entity_info=None, custom_entity_name=None, custom_group_id=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        self.algorithm = algorithm  # type: str
        self.custom_entity_info = custom_entity_info  # type: str
        self.custom_entity_name = custom_entity_name  # type: str
        self.custom_group_id = custom_group_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomEntityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.custom_entity_info is not None:
            result['CustomEntityInfo'] = self.custom_entity_info
        if self.custom_entity_name is not None:
            result['CustomEntityName'] = self.custom_entity_name
        if self.custom_group_id is not None:
            result['CustomGroupId'] = self.custom_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('CustomEntityInfo') is not None:
            self.custom_entity_info = m.get('CustomEntityInfo')
        if m.get('CustomEntityName') is not None:
            self.custom_entity_name = m.get('CustomEntityName')
        if m.get('CustomGroupId') is not None:
            self.custom_group_id = m.get('CustomGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateCustomEntityResponseBody(TeaModel):
    def __init__(self, custom_entity_id=None, request_id=None):
        self.custom_entity_id = custom_entity_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomEntityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_entity_id is not None:
            result['CustomEntityId'] = self.custom_entity_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomEntityId') is not None:
            self.custom_entity_id = m.get('CustomEntityId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomEntityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCustomEntityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomEntityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomGroupRequest(TeaModel):
    def __init__(self, algorithm=None, custom_group_description=None, custom_group_name=None, owner_account=None,
                 owner_id=None, resource_owner_account=None, resource_owner_id=None):
        self.algorithm = algorithm  # type: str
        self.custom_group_description = custom_group_description  # type: str
        self.custom_group_name = custom_group_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.custom_group_description is not None:
            result['CustomGroupDescription'] = self.custom_group_description
        if self.custom_group_name is not None:
            result['CustomGroupName'] = self.custom_group_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('CustomGroupDescription') is not None:
            self.custom_group_description = m.get('CustomGroupDescription')
        if m.get('CustomGroupName') is not None:
            self.custom_group_name = m.get('CustomGroupName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateCustomGroupResponseBody(TeaModel):
    def __init__(self, custom_group_id=None, request_id=None):
        self.custom_group_id = custom_group_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_group_id is not None:
            result['CustomGroupId'] = self.custom_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomGroupId') is not None:
            self.custom_group_id = m.get('CustomGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCustomGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFpShotDBRequest(TeaModel):
    def __init__(self, config=None, description=None, model_id=None, name=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The configurations of the media fingerprint library. By default, this parameter is empty. You can customize the configurations based on your business requirements. The value is a string in the JSON format.
        self.config = config  # type: str
        # The description of the media fingerprint library.
        self.description = description  # type: str
        # The model ID of the media fingerprint library. To create a text fingerprint library, set the parameter to **11**. To create a video fingerprint library, set the parameter to **12**. To create an audio fingerprint library, set the parameter to **13**. A value of **14** indicates that the library is an image fingerprint library.
        self.model_id = model_id  # type: int
        # The name of the media fingerprint library to be created.
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFpShotDBRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.description is not None:
            result['Description'] = self.description
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateFpShotDBResponseBodyFpShotDB(TeaModel):
    def __init__(self, config=None, description=None, fp_dbid=None, model_id=None, name=None, state=None):
        # The configurations of the media fingerprint library.
        self.config = config  # type: str
        # The description of the media fingerprint library.
        self.description = description  # type: str
        # The ID of the media fingerprint library. We recommend that you keep this ID for subsequent operation calls.
        self.fp_dbid = fp_dbid  # type: str
        # The model ID of the media fingerprint library.
        self.model_id = model_id  # type: int
        # The name of the media fingerprint library.
        self.name = name  # type: str
        # The status of the media fingerprint library. After the media fingerprint library is created, it enters the **offline** state. After the media fingerprint library is processed at the backend, it enters the **active** state.
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFpShotDBResponseBodyFpShotDB, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.description is not None:
            result['Description'] = self.description
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class CreateFpShotDBResponseBody(TeaModel):
    def __init__(self, fp_shot_db=None, request_id=None):
        # The details of the media fingerprint library.
        self.fp_shot_db = fp_shot_db  # type: CreateFpShotDBResponseBodyFpShotDB
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.fp_shot_db:
            self.fp_shot_db.validate()

    def to_map(self):
        _map = super(CreateFpShotDBResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_db is not None:
            result['FpShotDB'] = self.fp_shot_db.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpShotDB') is not None:
            temp_model = CreateFpShotDBResponseBodyFpShotDB()
            self.fp_shot_db = temp_model.from_map(m['FpShotDB'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFpShotDBResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateFpShotDBResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFpShotDBResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFpShotDBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactivateMediaWorkflowRequest(TeaModel):
    def __init__(self, media_workflow_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the media workflow that you want to deactivate. To obtain the ID of the media workflow, you can log on to the **ApsaraVideo Media Processing (MPS) console** and choose **Workflows** > **Workflow Settings** in the left-side navigation pane.
        self.media_workflow_id = media_workflow_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeactivateMediaWorkflowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeactivateMediaWorkflowResponseBodyMediaWorkflow(TeaModel):
    def __init__(self, creation_time=None, media_workflow_id=None, name=None, state=None, topology=None):
        # The time when the media workflow was created.
        self.creation_time = creation_time  # type: str
        # The ID of the media workflow that is deactivated.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the media workflow that is deactivated.
        self.name = name  # type: str
        # The status of the media workflow. The value is **Inactive**.
        self.state = state  # type: str
        # The topology of the media workflow.
        self.topology = topology  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeactivateMediaWorkflowResponseBodyMediaWorkflow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        return self


class DeactivateMediaWorkflowResponseBody(TeaModel):
    def __init__(self, media_workflow=None, request_id=None):
        # The details of the media workflow.
        self.media_workflow = media_workflow  # type: DeactivateMediaWorkflowResponseBodyMediaWorkflow
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_workflow:
            self.media_workflow.validate()

    def to_map(self):
        _map = super(DeactivateMediaWorkflowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow is not None:
            result['MediaWorkflow'] = self.media_workflow.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflow') is not None:
            temp_model = DeactivateMediaWorkflowResponseBodyMediaWorkflow()
            self.media_workflow = temp_model.from_map(m['MediaWorkflow'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactivateMediaWorkflowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeactivateMediaWorkflowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeactivateMediaWorkflowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeactivateMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomEntityRequest(TeaModel):
    def __init__(self, algorithm=None, custom_entity_id=None, custom_group_id=None, owner_account=None,
                 owner_id=None, resource_owner_account=None, resource_owner_id=None):
        self.algorithm = algorithm  # type: str
        self.custom_entity_id = custom_entity_id  # type: str
        self.custom_group_id = custom_group_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomEntityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.custom_entity_id is not None:
            result['CustomEntityId'] = self.custom_entity_id
        if self.custom_group_id is not None:
            result['CustomGroupId'] = self.custom_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('CustomEntityId') is not None:
            self.custom_entity_id = m.get('CustomEntityId')
        if m.get('CustomGroupId') is not None:
            self.custom_group_id = m.get('CustomGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCustomEntityResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomEntityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomEntityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCustomEntityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCustomEntityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomGroupRequest(TeaModel):
    def __init__(self, algorithm=None, custom_group_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.algorithm = algorithm  # type: str
        self.custom_group_id = custom_group_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.custom_group_id is not None:
            result['CustomGroupId'] = self.custom_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('CustomGroupId') is not None:
            self.custom_group_id = m.get('CustomGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCustomGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCustomGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCustomGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomViewRequest(TeaModel):
    def __init__(self, algorithm=None, custom_entity_id=None, custom_group_id=None, custom_view_id=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        self.algorithm = algorithm  # type: str
        self.custom_entity_id = custom_entity_id  # type: str
        self.custom_group_id = custom_group_id  # type: str
        self.custom_view_id = custom_view_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.custom_entity_id is not None:
            result['CustomEntityId'] = self.custom_entity_id
        if self.custom_group_id is not None:
            result['CustomGroupId'] = self.custom_group_id
        if self.custom_view_id is not None:
            result['CustomViewId'] = self.custom_view_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('CustomEntityId') is not None:
            self.custom_entity_id = m.get('CustomEntityId')
        if m.get('CustomGroupId') is not None:
            self.custom_group_id = m.get('CustomGroupId')
        if m.get('CustomViewId') is not None:
            self.custom_view_id = m.get('CustomViewId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCustomViewResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomViewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCustomViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCustomViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaRequest(TeaModel):
    def __init__(self, media_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.media_ids = media_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMediaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteMediaResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMediaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMediaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMediaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaTagRequest(TeaModel):
    def __init__(self, media_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, tag=None):
        # The ID of the media file for which you want to remove a tag. To obtain the ID of a media file, you can call the [AddMedia](~~44458~~) operation. Alternatively, perform the following operations in the ApsaraVideo Media Processing (MPS) console: In the left-side navigation pane, choose **Media Management** > **Media List**. Find the required video and click **Manage**. The ID of the video is displayed on the Basics tab.
        self.media_id = media_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The media tag that you want to remove. The value is encoded in UTF-8 and can be up to 32 bytes in length.
        # 
        # >  You can remove only one tag at a time.
        self.tag = tag  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMediaTagRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class DeleteMediaTagResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMediaTagResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaTagResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMediaTagResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMediaTagResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaWorkflowRequest(TeaModel):
    def __init__(self, media_workflow_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the media workflow that you want to delete. To obtain the ID of the media workflow, you can log on to the **ApsaraVideo Media Processing (MPS) console** and choose **Workflows** > **Workflow Settings** in the left-side navigation pane.
        self.media_workflow_id = media_workflow_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMediaWorkflowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteMediaWorkflowResponseBodyMediaWorkflow(TeaModel):
    def __init__(self, creation_time=None, media_workflow_id=None, name=None, state=None, topology=None):
        # The time when the media workflow was created.
        self.creation_time = creation_time  # type: str
        # The ID of the media workflow that is deleted.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the media workflow that is deleted.
        self.name = name  # type: str
        # The status of the media workflow. The value is **Deleted**.
        self.state = state  # type: str
        # The topology of the media workflow.
        self.topology = topology  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMediaWorkflowResponseBodyMediaWorkflow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        return self


class DeleteMediaWorkflowResponseBody(TeaModel):
    def __init__(self, media_workflow=None, request_id=None):
        # The details of the media workflow.
        self.media_workflow = media_workflow  # type: DeleteMediaWorkflowResponseBodyMediaWorkflow
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_workflow:
            self.media_workflow.validate()

    def to_map(self):
        _map = super(DeleteMediaWorkflowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow is not None:
            result['MediaWorkflow'] = self.media_workflow.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflow') is not None:
            temp_model = DeleteMediaWorkflowResponseBodyMediaWorkflow()
            self.media_workflow = temp_model.from_map(m['MediaWorkflow'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaWorkflowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMediaWorkflowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMediaWorkflowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, pipeline_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the MPS queue that you want to delete. To obtain the ID of the MPS queue, you can log on to the **MPS console** and choose **Global Settings** > **Pipelines** in the left-side navigation pane.
        self.pipeline_id = pipeline_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePipelineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeletePipelineResponseBody(TeaModel):
    def __init__(self, pipeline_id=None, request_id=None):
        # The ID of the MPS queue that is deleted.
        self.pipeline_id = pipeline_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePipelineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePipelineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePipelineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePipelineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSmarttagTemplateRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 template_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSmarttagTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteSmarttagTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSmarttagTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSmarttagTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSmarttagTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSmarttagTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSmarttagTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTemplateRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 template_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the custom transcoding template that you want to delete. To obtain the ID of the custom transcoding template, you can log on to the **ApsaraVideo Media Processing (MPS) console** and choose **Global Settings** > **Encoding Templates** in the left-side navigation pane.
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the custom transcoding template that is deleted.
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWaterMarkTemplateRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 water_mark_template_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.water_mark_template_id = water_mark_template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWaterMarkTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        return self


class DeleteWaterMarkTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, water_mark_template_id=None):
        self.request_id = request_id  # type: str
        self.water_mark_template_id = water_mark_template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWaterMarkTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        return self


class DeleteWaterMarkTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteWaterMarkTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteWaterMarkTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWaterMarkTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImAuditRequest(TeaModel):
    def __init__(self, biz_type=None, contents=None, images=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, scenes=None):
        self.biz_type = biz_type  # type: str
        self.contents = contents  # type: str
        self.images = images  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.scenes = scenes  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImAuditRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.contents is not None:
            result['Contents'] = self.contents
        if self.images is not None:
            result['Images'] = self.images
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scenes is not None:
            result['Scenes'] = self.scenes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('Contents') is not None:
            self.contents = m.get('Contents')
        if m.get('Images') is not None:
            self.images = m.get('Images')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Scenes') is not None:
            self.scenes = m.get('Scenes')
        return self


class ImAuditResponseBodyImageResultsResultResultsFrames(TeaModel):
    def __init__(self, rate=None, url=None):
        self.rate = rate  # type: float
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResultResultsFrames, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rate is not None:
            result['rate'] = self.rate
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class ImAuditResponseBodyImageResultsResultResultsHintWordsInfo(TeaModel):
    def __init__(self, context=None):
        self.context = context  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResultResultsHintWordsInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context is not None:
            result['context'] = self.context
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('context') is not None:
            self.context = m.get('context')
        return self


class ImAuditResponseBodyImageResultsResultResultsLogoData(TeaModel):
    def __init__(self, h=None, name=None, type=None, w=None, x=None, y=None):
        self.h = h  # type: float
        self.name = name  # type: str
        self.type = type  # type: str
        self.w = w  # type: float
        self.x = x  # type: float
        self.y = y  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResultResultsLogoData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.h is not None:
            result['h'] = self.h
        if self.name is not None:
            result['name'] = self.name
        if self.type is not None:
            result['type'] = self.type
        if self.w is not None:
            result['w'] = self.w
        if self.x is not None:
            result['x'] = self.x
        if self.y is not None:
            result['y'] = self.y
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('h') is not None:
            self.h = m.get('h')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('w') is not None:
            self.w = m.get('w')
        if m.get('x') is not None:
            self.x = m.get('x')
        if m.get('y') is not None:
            self.y = m.get('y')
        return self


class ImAuditResponseBodyImageResultsResultResultsProgramCodeData(TeaModel):
    def __init__(self, h=None, w=None, x=None, y=None):
        self.h = h  # type: float
        self.w = w  # type: float
        self.x = x  # type: float
        self.y = y  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResultResultsProgramCodeData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.h is not None:
            result['h'] = self.h
        if self.w is not None:
            result['w'] = self.w
        if self.x is not None:
            result['x'] = self.x
        if self.y is not None:
            result['y'] = self.y
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('h') is not None:
            self.h = m.get('h')
        if m.get('w') is not None:
            self.w = m.get('w')
        if m.get('x') is not None:
            self.x = m.get('x')
        if m.get('y') is not None:
            self.y = m.get('y')
        return self


class ImAuditResponseBodyImageResultsResultResultsQrcodeLocations(TeaModel):
    def __init__(self, h=None, qrcode=None, w=None, x=None, y=None):
        self.h = h  # type: float
        self.qrcode = qrcode  # type: str
        self.w = w  # type: float
        self.x = x  # type: float
        self.y = y  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResultResultsQrcodeLocations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.h is not None:
            result['h'] = self.h
        if self.qrcode is not None:
            result['qrcode'] = self.qrcode
        if self.w is not None:
            result['w'] = self.w
        if self.x is not None:
            result['x'] = self.x
        if self.y is not None:
            result['y'] = self.y
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('h') is not None:
            self.h = m.get('h')
        if m.get('qrcode') is not None:
            self.qrcode = m.get('qrcode')
        if m.get('w') is not None:
            self.w = m.get('w')
        if m.get('x') is not None:
            self.x = m.get('x')
        if m.get('y') is not None:
            self.y = m.get('y')
        return self


class ImAuditResponseBodyImageResultsResultResultsSfaceDataFaces(TeaModel):
    def __init__(self, idid=None, name=None, re=None):
        self.idid = idid  # type: str
        self.name = name  # type: str
        self.re = re  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResultResultsSfaceDataFaces, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idid is not None:
            result['idid'] = self.idid
        if self.name is not None:
            result['name'] = self.name
        if self.re is not None:
            result['re'] = self.re
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('idid') is not None:
            self.idid = m.get('idid')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('re') is not None:
            self.re = m.get('re')
        return self


class ImAuditResponseBodyImageResultsResultResultsSfaceData(TeaModel):
    def __init__(self, faces=None, h=None, w=None, x=None, y=None):
        self.faces = faces  # type: list[ImAuditResponseBodyImageResultsResultResultsSfaceDataFaces]
        self.h = h  # type: float
        self.w = w  # type: float
        self.x = x  # type: float
        self.y = y  # type: float

    def validate(self):
        if self.faces:
            for k in self.faces:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResultResultsSfaceData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['faces'] = []
        if self.faces is not None:
            for k in self.faces:
                result['faces'].append(k.to_map() if k else None)
        if self.h is not None:
            result['h'] = self.h
        if self.w is not None:
            result['w'] = self.w
        if self.x is not None:
            result['x'] = self.x
        if self.y is not None:
            result['y'] = self.y
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.faces = []
        if m.get('faces') is not None:
            for k in m.get('faces'):
                temp_model = ImAuditResponseBodyImageResultsResultResultsSfaceDataFaces()
                self.faces.append(temp_model.from_map(k))
        if m.get('h') is not None:
            self.h = m.get('h')
        if m.get('w') is not None:
            self.w = m.get('w')
        if m.get('x') is not None:
            self.x = m.get('x')
        if m.get('y') is not None:
            self.y = m.get('y')
        return self


class ImAuditResponseBodyImageResultsResultResults(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None, frames=None, hint_words_info=None,
                 logo_data=None, ocr_data=None, program_code_data=None, qrcode_data=None, qrcode_locations=None,
                 sface_data=None):
        self.label = label  # type: str
        self.rate = rate  # type: float
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str
        self.frames = frames  # type: list[ImAuditResponseBodyImageResultsResultResultsFrames]
        self.hint_words_info = hint_words_info  # type: list[ImAuditResponseBodyImageResultsResultResultsHintWordsInfo]
        self.logo_data = logo_data  # type: list[ImAuditResponseBodyImageResultsResultResultsLogoData]
        self.ocr_data = ocr_data  # type: list[str]
        self.program_code_data = program_code_data  # type: list[ImAuditResponseBodyImageResultsResultResultsProgramCodeData]
        self.qrcode_data = qrcode_data  # type: list[str]
        self.qrcode_locations = qrcode_locations  # type: list[ImAuditResponseBodyImageResultsResultResultsQrcodeLocations]
        self.sface_data = sface_data  # type: list[ImAuditResponseBodyImageResultsResultResultsSfaceData]

    def validate(self):
        if self.frames:
            for k in self.frames:
                if k:
                    k.validate()
        if self.hint_words_info:
            for k in self.hint_words_info:
                if k:
                    k.validate()
        if self.logo_data:
            for k in self.logo_data:
                if k:
                    k.validate()
        if self.program_code_data:
            for k in self.program_code_data:
                if k:
                    k.validate()
        if self.qrcode_locations:
            for k in self.qrcode_locations:
                if k:
                    k.validate()
        if self.sface_data:
            for k in self.sface_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResultResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        result['frames'] = []
        if self.frames is not None:
            for k in self.frames:
                result['frames'].append(k.to_map() if k else None)
        result['hintWordsInfo'] = []
        if self.hint_words_info is not None:
            for k in self.hint_words_info:
                result['hintWordsInfo'].append(k.to_map() if k else None)
        result['logoData'] = []
        if self.logo_data is not None:
            for k in self.logo_data:
                result['logoData'].append(k.to_map() if k else None)
        if self.ocr_data is not None:
            result['ocrData'] = self.ocr_data
        result['programCodeData'] = []
        if self.program_code_data is not None:
            for k in self.program_code_data:
                result['programCodeData'].append(k.to_map() if k else None)
        if self.qrcode_data is not None:
            result['qrcodeData'] = self.qrcode_data
        result['qrcodeLocations'] = []
        if self.qrcode_locations is not None:
            for k in self.qrcode_locations:
                result['qrcodeLocations'].append(k.to_map() if k else None)
        result['sfaceData'] = []
        if self.sface_data is not None:
            for k in self.sface_data:
                result['sfaceData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        self.frames = []
        if m.get('frames') is not None:
            for k in m.get('frames'):
                temp_model = ImAuditResponseBodyImageResultsResultResultsFrames()
                self.frames.append(temp_model.from_map(k))
        self.hint_words_info = []
        if m.get('hintWordsInfo') is not None:
            for k in m.get('hintWordsInfo'):
                temp_model = ImAuditResponseBodyImageResultsResultResultsHintWordsInfo()
                self.hint_words_info.append(temp_model.from_map(k))
        self.logo_data = []
        if m.get('logoData') is not None:
            for k in m.get('logoData'):
                temp_model = ImAuditResponseBodyImageResultsResultResultsLogoData()
                self.logo_data.append(temp_model.from_map(k))
        if m.get('ocrData') is not None:
            self.ocr_data = m.get('ocrData')
        self.program_code_data = []
        if m.get('programCodeData') is not None:
            for k in m.get('programCodeData'):
                temp_model = ImAuditResponseBodyImageResultsResultResultsProgramCodeData()
                self.program_code_data.append(temp_model.from_map(k))
        if m.get('qrcodeData') is not None:
            self.qrcode_data = m.get('qrcodeData')
        self.qrcode_locations = []
        if m.get('qrcodeLocations') is not None:
            for k in m.get('qrcodeLocations'):
                temp_model = ImAuditResponseBodyImageResultsResultResultsQrcodeLocations()
                self.qrcode_locations.append(temp_model.from_map(k))
        self.sface_data = []
        if m.get('sfaceData') is not None:
            for k in m.get('sfaceData'):
                temp_model = ImAuditResponseBodyImageResultsResultResultsSfaceData()
                self.sface_data.append(temp_model.from_map(k))
        return self


class ImAuditResponseBodyImageResultsResult(TeaModel):
    def __init__(self, code=None, data_id=None, extras=None, msg=None, results=None, task_id=None, url=None):
        self.code = code  # type: long
        self.data_id = data_id  # type: str
        self.extras = extras  # type: dict[str, any]
        self.msg = msg  # type: str
        self.results = results  # type: list[ImAuditResponseBodyImageResultsResultResults]
        self.task_id = task_id  # type: str
        self.url = url  # type: str

    def validate(self):
        if self.results:
            for k in self.results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResultsResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.extras is not None:
            result['extras'] = self.extras
        if self.msg is not None:
            result['msg'] = self.msg
        result['results'] = []
        if self.results is not None:
            for k in self.results:
                result['results'].append(k.to_map() if k else None)
        if self.task_id is not None:
            result['taskId'] = self.task_id
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('extras') is not None:
            self.extras = m.get('extras')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        self.results = []
        if m.get('results') is not None:
            for k in m.get('results'):
                temp_model = ImAuditResponseBodyImageResultsResultResults()
                self.results.append(temp_model.from_map(k))
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class ImAuditResponseBodyImageResults(TeaModel):
    def __init__(self, result=None):
        self.result = result  # type: list[ImAuditResponseBodyImageResultsResult]

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImAuditResponseBodyImageResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ImAuditResponseBodyImageResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class ImAuditResponseBodyTextResultsResultResultsDetailsContexts(TeaModel):
    def __init__(self, context=None, lib_code=None, lib_name=None, positions=None, rule_type=None):
        self.context = context  # type: str
        self.lib_code = lib_code  # type: str
        self.lib_name = lib_name  # type: str
        self.positions = positions  # type: list[str]
        self.rule_type = rule_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImAuditResponseBodyTextResultsResultResultsDetailsContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context is not None:
            result['context'] = self.context
        if self.lib_code is not None:
            result['libCode'] = self.lib_code
        if self.lib_name is not None:
            result['libName'] = self.lib_name
        if self.positions is not None:
            result['positions'] = self.positions
        if self.rule_type is not None:
            result['ruleType'] = self.rule_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('context') is not None:
            self.context = m.get('context')
        if m.get('libCode') is not None:
            self.lib_code = m.get('libCode')
        if m.get('libName') is not None:
            self.lib_name = m.get('libName')
        if m.get('positions') is not None:
            self.positions = m.get('positions')
        if m.get('ruleType') is not None:
            self.rule_type = m.get('ruleType')
        return self


class ImAuditResponseBodyTextResultsResultResultsDetails(TeaModel):
    def __init__(self, label=None, contexts=None):
        self.label = label  # type: str
        self.contexts = contexts  # type: list[ImAuditResponseBodyTextResultsResultResultsDetailsContexts]

    def validate(self):
        if self.contexts:
            for k in self.contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImAuditResponseBodyTextResultsResultResultsDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        result['contexts'] = []
        if self.contexts is not None:
            for k in self.contexts:
                result['contexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        self.contexts = []
        if m.get('contexts') is not None:
            for k in m.get('contexts'):
                temp_model = ImAuditResponseBodyTextResultsResultResultsDetailsContexts()
                self.contexts.append(temp_model.from_map(k))
        return self


class ImAuditResponseBodyTextResultsResultResults(TeaModel):
    def __init__(self, details=None, label=None, rate=None, scene=None, suggestion=None):
        self.details = details  # type: list[ImAuditResponseBodyTextResultsResultResultsDetails]
        self.label = label  # type: str
        self.rate = rate  # type: float
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImAuditResponseBodyTextResultsResultResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['details'] = []
        if self.details is not None:
            for k in self.details:
                result['details'].append(k.to_map() if k else None)
        if self.label is not None:
            result['label'] = self.label
        if self.rate is not None:
            result['rate'] = self.rate
        if self.scene is not None:
            result['scene'] = self.scene
        if self.suggestion is not None:
            result['suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.details = []
        if m.get('details') is not None:
            for k in m.get('details'):
                temp_model = ImAuditResponseBodyTextResultsResultResultsDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('label') is not None:
            self.label = m.get('label')
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('suggestion') is not None:
            self.suggestion = m.get('suggestion')
        return self


class ImAuditResponseBodyTextResultsResult(TeaModel):
    def __init__(self, code=None, content=None, data_id=None, msg=None, results=None, task_id=None):
        self.code = code  # type: long
        self.content = content  # type: str
        self.data_id = data_id  # type: str
        self.msg = msg  # type: str
        self.results = results  # type: list[ImAuditResponseBodyTextResultsResultResults]
        self.task_id = task_id  # type: str

    def validate(self):
        if self.results:
            for k in self.results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImAuditResponseBodyTextResultsResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.content is not None:
            result['content'] = self.content
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.msg is not None:
            result['msg'] = self.msg
        result['results'] = []
        if self.results is not None:
            for k in self.results:
                result['results'].append(k.to_map() if k else None)
        if self.task_id is not None:
            result['taskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        self.results = []
        if m.get('results') is not None:
            for k in m.get('results'):
                temp_model = ImAuditResponseBodyTextResultsResultResults()
                self.results.append(temp_model.from_map(k))
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        return self


class ImAuditResponseBodyTextResults(TeaModel):
    def __init__(self, result=None):
        self.result = result  # type: list[ImAuditResponseBodyTextResultsResult]

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImAuditResponseBodyTextResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ImAuditResponseBodyTextResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class ImAuditResponseBody(TeaModel):
    def __init__(self, image_quota_exceed=None, image_results=None, request_id=None, text_quota_exceed=None,
                 text_results=None):
        self.image_quota_exceed = image_quota_exceed  # type: bool
        self.image_results = image_results  # type: ImAuditResponseBodyImageResults
        self.request_id = request_id  # type: str
        self.text_quota_exceed = text_quota_exceed  # type: bool
        self.text_results = text_results  # type: ImAuditResponseBodyTextResults

    def validate(self):
        if self.image_results:
            self.image_results.validate()
        if self.text_results:
            self.text_results.validate()

    def to_map(self):
        _map = super(ImAuditResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_quota_exceed is not None:
            result['ImageQuotaExceed'] = self.image_quota_exceed
        if self.image_results is not None:
            result['ImageResults'] = self.image_results.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.text_quota_exceed is not None:
            result['TextQuotaExceed'] = self.text_quota_exceed
        if self.text_results is not None:
            result['TextResults'] = self.text_results.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageQuotaExceed') is not None:
            self.image_quota_exceed = m.get('ImageQuotaExceed')
        if m.get('ImageResults') is not None:
            temp_model = ImAuditResponseBodyImageResults()
            self.image_results = temp_model.from_map(m['ImageResults'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TextQuotaExceed') is not None:
            self.text_quota_exceed = m.get('TextQuotaExceed')
        if m.get('TextResults') is not None:
            temp_model = ImAuditResponseBodyTextResults()
            self.text_results = temp_model.from_map(m['TextResults'])
        return self


class ImAuditResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ImAuditResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImAuditResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImAuditResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportFpShotJobRequest(TeaModel):
    def __init__(self, fp_dbid=None, fp_import_config=None, input=None, owner_account=None, owner_id=None,
                 pipeline_id=None, resource_owner_account=None, resource_owner_id=None, user_data=None):
        self.fp_dbid = fp_dbid  # type: str
        self.fp_import_config = fp_import_config  # type: str
        self.input = input  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.pipeline_id = pipeline_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportFpShotJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.fp_import_config is not None:
            result['FpImportConfig'] = self.fp_import_config
        if self.input is not None:
            result['Input'] = self.input
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('FpImportConfig') is not None:
            self.fp_import_config = m.get('FpImportConfig')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ImportFpShotJobResponseBody(TeaModel):
    def __init__(self, job_id=None, request_id=None):
        self.job_id = job_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportFpShotJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ImportFpShotJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ImportFpShotJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportFpShotJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportFpShotJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAllMediaBucketRequest(TeaModel):
    def __init__(self, maximum_page_size=None, next_page_token=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The maximum number of media buckets to return. Valid values: 1 to 100. Default value: 50.
        self.maximum_page_size = maximum_page_size  # type: int
        # The token that is used to retrieve the next page of the query results. You do not need to specify this parameter in the first request. The response to the first request contains this parameter, which is added to the next request.
        self.next_page_token = next_page_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAllMediaBucketRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListAllMediaBucketResponseBodyMediaBucketListMediaBucket(TeaModel):
    def __init__(self, bucket=None, referer=None, type=None):
        # The name of the media bucket.
        self.bucket = bucket  # type: str
        # The settings of Object Storage Service (OSS) hotlink protection. For more information, see [Hotlink protection](~~31869~~).
        self.referer = referer  # type: str
        # The type of the media bucket. Valid values:
        # 
        # *   Input: input media bucket
        # *   Output: output media bucket
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAllMediaBucketResponseBodyMediaBucketListMediaBucket, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.referer is not None:
            result['Referer'] = self.referer
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Referer') is not None:
            self.referer = m.get('Referer')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListAllMediaBucketResponseBodyMediaBucketList(TeaModel):
    def __init__(self, media_bucket=None):
        self.media_bucket = media_bucket  # type: list[ListAllMediaBucketResponseBodyMediaBucketListMediaBucket]

    def validate(self):
        if self.media_bucket:
            for k in self.media_bucket:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAllMediaBucketResponseBodyMediaBucketList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaBucket'] = []
        if self.media_bucket is not None:
            for k in self.media_bucket:
                result['MediaBucket'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_bucket = []
        if m.get('MediaBucket') is not None:
            for k in m.get('MediaBucket'):
                temp_model = ListAllMediaBucketResponseBodyMediaBucketListMediaBucket()
                self.media_bucket.append(temp_model.from_map(k))
        return self


class ListAllMediaBucketResponseBody(TeaModel):
    def __init__(self, media_bucket_list=None, next_page_token=None, request_id=None):
        # The list of returned media buckets.
        self.media_bucket_list = media_bucket_list  # type: ListAllMediaBucketResponseBodyMediaBucketList
        # The identifier of the next page.
        self.next_page_token = next_page_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_bucket_list:
            self.media_bucket_list.validate()

    def to_map(self):
        _map = super(ListAllMediaBucketResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_bucket_list is not None:
            result['MediaBucketList'] = self.media_bucket_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaBucketList') is not None:
            temp_model = ListAllMediaBucketResponseBodyMediaBucketList()
            self.media_bucket_list = temp_model.from_map(m['MediaBucketList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAllMediaBucketResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAllMediaBucketResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAllMediaBucketResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAllMediaBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomEntitiesRequest(TeaModel):
    def __init__(self, algorithm=None, custom_group_id=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, resource_owner_account=None, resource_owner_id=None):
        self.algorithm = algorithm  # type: str
        self.custom_group_id = custom_group_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomEntitiesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.custom_group_id is not None:
            result['CustomGroupId'] = self.custom_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('CustomGroupId') is not None:
            self.custom_group_id = m.get('CustomGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListCustomEntitiesResponseBodyCustomEntitiesCustomEntity(TeaModel):
    def __init__(self, custom_entity_id=None, custom_entity_info=None, custom_entity_name=None):
        self.custom_entity_id = custom_entity_id  # type: str
        self.custom_entity_info = custom_entity_info  # type: str
        self.custom_entity_name = custom_entity_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomEntitiesResponseBodyCustomEntitiesCustomEntity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_entity_id is not None:
            result['CustomEntityId'] = self.custom_entity_id
        if self.custom_entity_info is not None:
            result['CustomEntityInfo'] = self.custom_entity_info
        if self.custom_entity_name is not None:
            result['CustomEntityName'] = self.custom_entity_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomEntityId') is not None:
            self.custom_entity_id = m.get('CustomEntityId')
        if m.get('CustomEntityInfo') is not None:
            self.custom_entity_info = m.get('CustomEntityInfo')
        if m.get('CustomEntityName') is not None:
            self.custom_entity_name = m.get('CustomEntityName')
        return self


class ListCustomEntitiesResponseBodyCustomEntities(TeaModel):
    def __init__(self, custom_entity=None):
        self.custom_entity = custom_entity  # type: list[ListCustomEntitiesResponseBodyCustomEntitiesCustomEntity]

    def validate(self):
        if self.custom_entity:
            for k in self.custom_entity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomEntitiesResponseBodyCustomEntities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomEntity'] = []
        if self.custom_entity is not None:
            for k in self.custom_entity:
                result['CustomEntity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_entity = []
        if m.get('CustomEntity') is not None:
            for k in m.get('CustomEntity'):
                temp_model = ListCustomEntitiesResponseBodyCustomEntitiesCustomEntity()
                self.custom_entity.append(temp_model.from_map(k))
        return self


class ListCustomEntitiesResponseBody(TeaModel):
    def __init__(self, custom_entities=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.custom_entities = custom_entities  # type: ListCustomEntitiesResponseBodyCustomEntities
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.custom_entities:
            self.custom_entities.validate()

    def to_map(self):
        _map = super(ListCustomEntitiesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_entities is not None:
            result['CustomEntities'] = self.custom_entities.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomEntities') is not None:
            temp_model = ListCustomEntitiesResponseBodyCustomEntities()
            self.custom_entities = temp_model.from_map(m['CustomEntities'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCustomEntitiesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCustomEntitiesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCustomEntitiesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomEntitiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomGroupsRequest(TeaModel):
    def __init__(self, algorithm=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.algorithm = algorithm  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListCustomGroupsResponseBodyCustomGroupsCustomGroup(TeaModel):
    def __init__(self, custom_group_description=None, custom_group_id=None, custom_group_name=None):
        self.custom_group_description = custom_group_description  # type: str
        self.custom_group_id = custom_group_id  # type: str
        self.custom_group_name = custom_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomGroupsResponseBodyCustomGroupsCustomGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_group_description is not None:
            result['CustomGroupDescription'] = self.custom_group_description
        if self.custom_group_id is not None:
            result['CustomGroupId'] = self.custom_group_id
        if self.custom_group_name is not None:
            result['CustomGroupName'] = self.custom_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomGroupDescription') is not None:
            self.custom_group_description = m.get('CustomGroupDescription')
        if m.get('CustomGroupId') is not None:
            self.custom_group_id = m.get('CustomGroupId')
        if m.get('CustomGroupName') is not None:
            self.custom_group_name = m.get('CustomGroupName')
        return self


class ListCustomGroupsResponseBodyCustomGroups(TeaModel):
    def __init__(self, custom_group=None):
        self.custom_group = custom_group  # type: list[ListCustomGroupsResponseBodyCustomGroupsCustomGroup]

    def validate(self):
        if self.custom_group:
            for k in self.custom_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomGroupsResponseBodyCustomGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomGroup'] = []
        if self.custom_group is not None:
            for k in self.custom_group:
                result['CustomGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_group = []
        if m.get('CustomGroup') is not None:
            for k in m.get('CustomGroup'):
                temp_model = ListCustomGroupsResponseBodyCustomGroupsCustomGroup()
                self.custom_group.append(temp_model.from_map(k))
        return self


class ListCustomGroupsResponseBody(TeaModel):
    def __init__(self, custom_groups=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.custom_groups = custom_groups  # type: ListCustomGroupsResponseBodyCustomGroups
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.custom_groups:
            self.custom_groups.validate()

    def to_map(self):
        _map = super(ListCustomGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_groups is not None:
            result['CustomGroups'] = self.custom_groups.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomGroups') is not None:
            temp_model = ListCustomGroupsResponseBodyCustomGroups()
            self.custom_groups = temp_model.from_map(m['CustomGroups'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCustomGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCustomGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCustomGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomPersonsRequest(TeaModel):
    def __init__(self, category_id=None, owner_account=None, owner_id=None, person_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.category_id = category_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.person_id = person_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomPersonsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFacesFace(TeaModel):
    def __init__(self, face_id=None, image_url=None):
        self.face_id = face_id  # type: str
        self.image_url = image_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFacesFace, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.face_id is not None:
            result['FaceId'] = self.face_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FaceId') is not None:
            self.face_id = m.get('FaceId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        return self


class ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFaces(TeaModel):
    def __init__(self, face=None):
        self.face = face  # type: list[ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFacesFace]

    def validate(self):
        if self.face:
            for k in self.face:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFaces, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Face'] = []
        if self.face is not None:
            for k in self.face:
                result['Face'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.face = []
        if m.get('Face') is not None:
            for k in m.get('Face'):
                temp_model = ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFacesFace()
                self.face.append(temp_model.from_map(k))
        return self


class ListCustomPersonsResponseBodyCategoriesCategoryPersonsPerson(TeaModel):
    def __init__(self, faces=None, person_description=None, person_id=None, person_name=None):
        self.faces = faces  # type: ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFaces
        self.person_description = person_description  # type: str
        self.person_id = person_id  # type: str
        self.person_name = person_name  # type: str

    def validate(self):
        if self.faces:
            self.faces.validate()

    def to_map(self):
        _map = super(ListCustomPersonsResponseBodyCategoriesCategoryPersonsPerson, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.faces is not None:
            result['Faces'] = self.faces.to_map()
        if self.person_description is not None:
            result['PersonDescription'] = self.person_description
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_name is not None:
            result['PersonName'] = self.person_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Faces') is not None:
            temp_model = ListCustomPersonsResponseBodyCategoriesCategoryPersonsPersonFaces()
            self.faces = temp_model.from_map(m['Faces'])
        if m.get('PersonDescription') is not None:
            self.person_description = m.get('PersonDescription')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonName') is not None:
            self.person_name = m.get('PersonName')
        return self


class ListCustomPersonsResponseBodyCategoriesCategoryPersons(TeaModel):
    def __init__(self, person=None):
        self.person = person  # type: list[ListCustomPersonsResponseBodyCategoriesCategoryPersonsPerson]

    def validate(self):
        if self.person:
            for k in self.person:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomPersonsResponseBodyCategoriesCategoryPersons, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Person'] = []
        if self.person is not None:
            for k in self.person:
                result['Person'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.person = []
        if m.get('Person') is not None:
            for k in m.get('Person'):
                temp_model = ListCustomPersonsResponseBodyCategoriesCategoryPersonsPerson()
                self.person.append(temp_model.from_map(k))
        return self


class ListCustomPersonsResponseBodyCategoriesCategory(TeaModel):
    def __init__(self, category_description=None, category_id=None, category_name=None, persons=None):
        self.category_description = category_description  # type: str
        self.category_id = category_id  # type: str
        self.category_name = category_name  # type: str
        self.persons = persons  # type: ListCustomPersonsResponseBodyCategoriesCategoryPersons

    def validate(self):
        if self.persons:
            self.persons.validate()

    def to_map(self):
        _map = super(ListCustomPersonsResponseBodyCategoriesCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_description is not None:
            result['CategoryDescription'] = self.category_description
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        if self.persons is not None:
            result['Persons'] = self.persons.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryDescription') is not None:
            self.category_description = m.get('CategoryDescription')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        if m.get('Persons') is not None:
            temp_model = ListCustomPersonsResponseBodyCategoriesCategoryPersons()
            self.persons = temp_model.from_map(m['Persons'])
        return self


class ListCustomPersonsResponseBodyCategories(TeaModel):
    def __init__(self, category=None):
        self.category = category  # type: list[ListCustomPersonsResponseBodyCategoriesCategory]

    def validate(self):
        if self.category:
            for k in self.category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomPersonsResponseBodyCategories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Category'] = []
        if self.category is not None:
            for k in self.category:
                result['Category'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.category = []
        if m.get('Category') is not None:
            for k in m.get('Category'):
                temp_model = ListCustomPersonsResponseBodyCategoriesCategory()
                self.category.append(temp_model.from_map(k))
        return self


class ListCustomPersonsResponseBody(TeaModel):
    def __init__(self, categories=None, request_id=None):
        self.categories = categories  # type: ListCustomPersonsResponseBodyCategories
        self.request_id = request_id  # type: str

    def validate(self):
        if self.categories:
            self.categories.validate()

    def to_map(self):
        _map = super(ListCustomPersonsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories is not None:
            result['Categories'] = self.categories.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Categories') is not None:
            temp_model = ListCustomPersonsResponseBodyCategories()
            self.categories = temp_model.from_map(m['Categories'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCustomPersonsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCustomPersonsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCustomPersonsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomPersonsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomViewsRequest(TeaModel):
    def __init__(self, algorithm=None, custom_entity_id=None, custom_group_id=None, owner_account=None,
                 owner_id=None, page_number=None, page_size=None, resource_owner_account=None, resource_owner_id=None):
        self.algorithm = algorithm  # type: str
        self.custom_entity_id = custom_entity_id  # type: str
        self.custom_group_id = custom_group_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomViewsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.custom_entity_id is not None:
            result['CustomEntityId'] = self.custom_entity_id
        if self.custom_group_id is not None:
            result['CustomGroupId'] = self.custom_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('CustomEntityId') is not None:
            self.custom_entity_id = m.get('CustomEntityId')
        if m.get('CustomGroupId') is not None:
            self.custom_group_id = m.get('CustomGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListCustomViewsResponseBodyCustomViewsCustomView(TeaModel):
    def __init__(self, custom_view_id=None, image_url=None):
        self.custom_view_id = custom_view_id  # type: str
        self.image_url = image_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomViewsResponseBodyCustomViewsCustomView, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_view_id is not None:
            result['CustomViewId'] = self.custom_view_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomViewId') is not None:
            self.custom_view_id = m.get('CustomViewId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        return self


class ListCustomViewsResponseBodyCustomViews(TeaModel):
    def __init__(self, custom_view=None):
        self.custom_view = custom_view  # type: list[ListCustomViewsResponseBodyCustomViewsCustomView]

    def validate(self):
        if self.custom_view:
            for k in self.custom_view:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomViewsResponseBodyCustomViews, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomView'] = []
        if self.custom_view is not None:
            for k in self.custom_view:
                result['CustomView'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_view = []
        if m.get('CustomView') is not None:
            for k in m.get('CustomView'):
                temp_model = ListCustomViewsResponseBodyCustomViewsCustomView()
                self.custom_view.append(temp_model.from_map(k))
        return self


class ListCustomViewsResponseBody(TeaModel):
    def __init__(self, custom_views=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.custom_views = custom_views  # type: ListCustomViewsResponseBodyCustomViews
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.custom_views:
            self.custom_views.validate()

    def to_map(self):
        _map = super(ListCustomViewsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_views is not None:
            result['CustomViews'] = self.custom_views.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomViews') is not None:
            temp_model = ListCustomViewsResponseBodyCustomViews()
            self.custom_views = temp_model.from_map(m['CustomViews'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCustomViewsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCustomViewsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCustomViewsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomViewsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFpShotDBRequest(TeaModel):
    def __init__(self, fp_dbids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The IDs of the media fingerprint libraries. You can obtain the library IDs from the response parameters of the [CreateFpShotDB](~~170149~~) operation. You can query up to 10 libraries at a time. Separate multiple library IDs with commas (,).
        self.fp_dbids = fp_dbids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFpShotDBRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbids is not None:
            result['FpDBIds'] = self.fp_dbids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpDBIds') is not None:
            self.fp_dbids = m.get('FpDBIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListFpShotDBResponseBodyFpShotDBListFpShotDB(TeaModel):
    def __init__(self, description=None, fp_dbid=None, model_id=None, name=None, status=None):
        # The description of the media fingerprint library.
        self.description = description  # type: str
        # The ID of the media fingerprint library.
        self.fp_dbid = fp_dbid  # type: str
        # The model ID of the media fingerprint library. A value of **11** indicates that the library is a text fingerprint library. A value of **12** indicates that the library is a video fingerprint library. A value of **13** indicates that the library is an audio fingerprint library. A value of **14** indicates that the library is an image fingerprint library.
        self.model_id = model_id  # type: int
        # The name of the media fingerprint library.
        self.name = name  # type: str
        # The status of the media fingerprint library. Default value: **offline**. ****Valid values:
        # 
        # *   **offline**: The media fingerprint library is offline.
        # *   **active**: The media fingerprint library is online.
        # *   **paused**: The media fingerprint library is paused.
        # *   **deleted**: The media fingerprint library is deleted.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFpShotDBResponseBodyFpShotDBListFpShotDB, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListFpShotDBResponseBodyFpShotDBList(TeaModel):
    def __init__(self, fp_shot_db=None):
        self.fp_shot_db = fp_shot_db  # type: list[ListFpShotDBResponseBodyFpShotDBListFpShotDB]

    def validate(self):
        if self.fp_shot_db:
            for k in self.fp_shot_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFpShotDBResponseBodyFpShotDBList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotDB'] = []
        if self.fp_shot_db is not None:
            for k in self.fp_shot_db:
                result['FpShotDB'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_shot_db = []
        if m.get('FpShotDB') is not None:
            for k in m.get('FpShotDB'):
                temp_model = ListFpShotDBResponseBodyFpShotDBListFpShotDB()
                self.fp_shot_db.append(temp_model.from_map(k))
        return self


class ListFpShotDBResponseBodyNonExistIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFpShotDBResponseBodyNonExistIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class ListFpShotDBResponseBody(TeaModel):
    def __init__(self, fp_shot_dblist=None, non_exist_ids=None, request_id=None):
        # The array of media fingerprint libraries.
        self.fp_shot_dblist = fp_shot_dblist  # type: ListFpShotDBResponseBodyFpShotDBList
        # The IDs of the media fingerprint libraries that do not exist. If all the queried libraries exist, the response does not contain this parameter.
        self.non_exist_ids = non_exist_ids  # type: ListFpShotDBResponseBodyNonExistIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.fp_shot_dblist:
            self.fp_shot_dblist.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super(ListFpShotDBResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_dblist is not None:
            result['FpShotDBList'] = self.fp_shot_dblist.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpShotDBList') is not None:
            temp_model = ListFpShotDBResponseBodyFpShotDBList()
            self.fp_shot_dblist = temp_model.from_map(m['FpShotDBList'])
        if m.get('NonExistIds') is not None:
            temp_model = ListFpShotDBResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListFpShotDBResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListFpShotDBResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFpShotDBResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListFpShotDBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFpShotFilesRequest(TeaModel):
    def __init__(self, end_time=None, fp_dbid=None, next_page_token=None, owner_account=None, owner_id=None,
                 page_size=None, resource_owner_account=None, resource_owner_id=None, start_time=None):
        self.end_time = end_time  # type: str
        # The ID of the media fingerprint library whose files you want to query. You can obtain the library ID from the response parameters of the [CreateFpShotDB](~~170149~~) operation.
        self.fp_dbid = fp_dbid  # type: str
        # The token of the next page. This parameter is specified if you require paged queries. When you request the first page of query results, leave the NextPageToken parameter empty. When you request more query results, specify the value of the NextPageToken parameter returned in the query results on the previous page.
        self.next_page_token = next_page_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of entries to return on each page. Default value: 20.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFpShotFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListFpShotFilesResponseBodyFpShotFileListFpShotFileInputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The name of the OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The ID of the OSS region in which the input file resides.
        self.location = location  # type: str
        # The name of the Object Storage Service (OSS) object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFpShotFilesResponseBodyFpShotFileListFpShotFileInputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListFpShotFilesResponseBodyFpShotFileListFpShotFile(TeaModel):
    def __init__(self, file_id=None, input_file=None, primary_key=None, store_time=None):
        # The ID of the video file.
        self.file_id = file_id  # type: str
        # The information about the job input.
        self.input_file = input_file  # type: ListFpShotFilesResponseBodyFpShotFileListFpShotFileInputFile
        # The unique primary key of the video.
        self.primary_key = primary_key  # type: str
        self.store_time = store_time  # type: str

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super(ListFpShotFilesResponseBodyFpShotFileListFpShotFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.store_time is not None:
            result['StoreTime'] = self.store_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('InputFile') is not None:
            temp_model = ListFpShotFilesResponseBodyFpShotFileListFpShotFileInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('StoreTime') is not None:
            self.store_time = m.get('StoreTime')
        return self


class ListFpShotFilesResponseBodyFpShotFileList(TeaModel):
    def __init__(self, fp_shot_file=None):
        self.fp_shot_file = fp_shot_file  # type: list[ListFpShotFilesResponseBodyFpShotFileListFpShotFile]

    def validate(self):
        if self.fp_shot_file:
            for k in self.fp_shot_file:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFpShotFilesResponseBodyFpShotFileList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotFile'] = []
        if self.fp_shot_file is not None:
            for k in self.fp_shot_file:
                result['FpShotFile'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_shot_file = []
        if m.get('FpShotFile') is not None:
            for k in m.get('FpShotFile'):
                temp_model = ListFpShotFilesResponseBodyFpShotFileListFpShotFile()
                self.fp_shot_file.append(temp_model.from_map(k))
        return self


class ListFpShotFilesResponseBody(TeaModel):
    def __init__(self, fp_shot_file_list=None, next_page_token=None, request_id=None):
        # The media fingerprint files. For more information, see the "FpShotFile" section of the [Data types](~~29251~~) topic.
        self.fp_shot_file_list = fp_shot_file_list  # type: ListFpShotFilesResponseBodyFpShotFileList
        # The token of the next page.
        self.next_page_token = next_page_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.fp_shot_file_list:
            self.fp_shot_file_list.validate()

    def to_map(self):
        _map = super(ListFpShotFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_file_list is not None:
            result['FpShotFileList'] = self.fp_shot_file_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpShotFileList') is not None:
            temp_model = ListFpShotFilesResponseBodyFpShotFileList()
            self.fp_shot_file_list = temp_model.from_map(m['FpShotFileList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListFpShotFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListFpShotFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFpShotFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListFpShotFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFpShotImportJobRequest(TeaModel):
    def __init__(self, job_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.job_ids = job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFpShotImportJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListFpShotImportJobResponseBodyFpShotImportJobList(TeaModel):
    def __init__(self, code=None, create_time=None, finish_time=None, fp_dbid=None, fp_import_config=None, id=None,
                 input=None, message=None, pipeline_id=None, process_message=None, status=None, user_data=None):
        self.code = code  # type: str
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.fp_dbid = fp_dbid  # type: str
        self.fp_import_config = fp_import_config  # type: str
        self.id = id  # type: str
        self.input = input  # type: str
        self.message = message  # type: str
        self.pipeline_id = pipeline_id  # type: str
        self.process_message = process_message  # type: str
        self.status = status  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFpShotImportJobResponseBodyFpShotImportJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.fp_import_config is not None:
            result['FpImportConfig'] = self.fp_import_config
        if self.id is not None:
            result['Id'] = self.id
        if self.input is not None:
            result['Input'] = self.input
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.process_message is not None:
            result['ProcessMessage'] = self.process_message
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('FpImportConfig') is not None:
            self.fp_import_config = m.get('FpImportConfig')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ProcessMessage') is not None:
            self.process_message = m.get('ProcessMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListFpShotImportJobResponseBody(TeaModel):
    def __init__(self, fp_shot_import_job_list=None, non_exist_ids=None, request_id=None):
        self.fp_shot_import_job_list = fp_shot_import_job_list  # type: list[ListFpShotImportJobResponseBodyFpShotImportJobList]
        self.non_exist_ids = non_exist_ids  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.fp_shot_import_job_list:
            for k in self.fp_shot_import_job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFpShotImportJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotImportJobList'] = []
        if self.fp_shot_import_job_list is not None:
            for k in self.fp_shot_import_job_list:
                result['FpShotImportJobList'].append(k.to_map() if k else None)
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_shot_import_job_list = []
        if m.get('FpShotImportJobList') is not None:
            for k in m.get('FpShotImportJobList'):
                temp_model = ListFpShotImportJobResponseBodyFpShotImportJobList()
                self.fp_shot_import_job_list.append(temp_model.from_map(k))
        if m.get('NonExistIds') is not None:
            self.non_exist_ids = m.get('NonExistIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListFpShotImportJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListFpShotImportJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFpShotImportJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListFpShotImportJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobRequest(TeaModel):
    def __init__(self, end_of_job_created_time_range=None, maximum_page_size=None, next_page_token=None,
                 owner_account=None, owner_id=None, pipeline_id=None, resource_owner_account=None, resource_owner_id=None,
                 start_of_job_created_time_range=None, state=None):
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the `YYYY-MM-DDThh:mm:ssZ` format. The time is displayed in UTC.
        self.end_of_job_created_time_range = end_of_job_created_time_range  # type: str
        # The maximum number of media workflow execution instances to return on each page.
        # 
        # *   Default value: **10**.
        # *   Valid values: **1 to 100**.
        self.maximum_page_size = maximum_page_size  # type: long
        # The token that is used to retrieve the next page of the query results. You do not need to specify this parameter in the first request. The response to the first request contains this parameter, which you add to the next request.
        self.next_page_token = next_page_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the MPS queue. To view the ID of the MPS queue, log on to the [MPS console](https://mps.console.aliyun.com/overview) and choose **Global Settings** > **Pipelines** in the left-side navigation pane.
        self.pipeline_id = pipeline_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the `YYYY-MM-DDThh:mm:ssZ` format. The time is displayed in UTC.
        self.start_of_job_created_time_range = start_of_job_created_time_range  # type: str
        # The status of the transcoding job. Default value: **All**. Valid values:
        # 
        # *   **All**: All statuses.
        # *   **Submitted**: The job is submitted.
        # *   **Transcoding**: The job is being transcoded.
        # *   **TranscodeSuccess**: Transcoding is successful.
        # *   **TranscodeFail**: Transcoding failed.
        # *   **TranscodeCancelled**: Transcoding is canceled.
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_job_created_time_range is not None:
            result['EndOfJobCreatedTimeRange'] = self.end_of_job_created_time_range
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_of_job_created_time_range is not None:
            result['StartOfJobCreatedTimeRange'] = self.start_of_job_created_time_range
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndOfJobCreatedTimeRange') is not None:
            self.end_of_job_created_time_range = m.get('EndOfJobCreatedTimeRange')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartOfJobCreatedTimeRange') is not None:
            self.start_of_job_created_time_range = m.get('StartOfJobCreatedTimeRange')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListJobResponseBodyJobListJobInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The OSS bucket in which the job input is stored.
        self.bucket = bucket  # type: str
        # The OSS region where the job input resides.
        self.location = location  # type: str
        # The name of the OSS object of the job input.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListJobResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(self, error_code=None, error_message=None, message_id=None):
        # The error code that is returned when the job fails. This parameter is not returned if the job is created.
        self.error_code = error_code  # type: str
        # The error message that is returned when the job fails. This parameter is not returned if the job is created.
        self.error_message = error_message  # type: str
        # The ID of the success message.
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobMNSMessageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class ListJobResponseBodyJobListJobOutputAudioVolume(TeaModel):
    def __init__(self, level=None, method=None):
        # The volume adjustment range.
        # 
        # *   Unit: dB.
        # *   Default: **-20db**.
        self.level = level  # type: str
        # The volume adjustment method. Valid values:
        # 
        # *   **auto**: The volume is automatically adjusted.
        # *   **dynamic**: The volume is dynamically adjusted.
        # *   **linear**: The volume is linearly adjusted.
        self.method = method  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputAudioVolume, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class ListJobResponseBodyJobListJobOutputAudio(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, qscale=None, samplerate=None,
                 volume=None):
        # The audio bitrate of the output file.
        # 
        # *   Unit: Kbit/s.
        # *   Default value: **128**.
        self.bitrate = bitrate  # type: str
        # The number of sound channels.
        # 
        # *   If the Codec parameter is set to mp3, this parameter can be set only to 1 or 2.
        # *   If the Codec parameter is set to aac, this parameter can be set only to 1, 2, 4, 5, 6, or 8.
        # *   Default value: 2.
        self.channels = channels  # type: str
        # The audio codec.
        # 
        # *   Valid values: aac, mp3, vorbis, and flac.
        # *   Default value: **aac**.
        self.codec = codec  # type: str
        # The codec profile of the audio. Valid values when the Codec parameter is set to aac: aaclow, aache, aachev2, aacld, and aaceld.
        self.profile = profile  # type: str
        # The level of quality control on the audio.
        self.qscale = qscale  # type: str
        # The sampling rate.
        # 
        # *   Valid values: 22050, 32000, 44100, 48000, and 96000.
        # *   Unit: Hz.
        # *   Default value: 44100.
        # *   If the video container format is FLV and the audio codec is MP3, you cannot set this parameter to 32000, 48000, or 96000. If the audio codec is MP3, you cannot set this parameter to 96000.
        self.samplerate = samplerate  # type: str
        # The volume configuration.
        self.volume = volume  # type: ListJobResponseBodyJobListJobOutputAudioVolume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputAudio, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class ListJobResponseBodyJobListJobOutputClipTimeSpan(TeaModel):
    def __init__(self, duration=None, seek=None):
        # The duration of the clip.
        # 
        # *   Format: `hh:mm:ss[.SSS]` or `sssss[.SSS]`.
        # *   Valid values: `[00:00:00.000,23:59:59.999]` or `[0.000,86399.999]`.
        # *   Examples: 01:00:59.999 and 32000.23.
        self.duration = duration  # type: str
        # The time when the clip starts.
        # 
        # *   Format: `hh:mm:ss[.SSS]` or `sssss[.SSS]`.
        # *   Valid values: `[00:00:00.000,23:59:59.999]` or `[0.000,86399.999]`.
        # *   Examples: 01:59:59.999 and 32000.23.
        self.seek = seek  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputClipTimeSpan, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.seek is not None:
            result['Seek'] = self.seek
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        return self


class ListJobResponseBodyJobListJobOutputClip(TeaModel):
    def __init__(self, time_span=None):
        # The time span of the clip.
        self.time_span = time_span  # type: ListJobResponseBodyJobListJobOutputClipTimeSpan

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputClip, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class ListJobResponseBodyJobListJobOutputContainer(TeaModel):
    def __init__(self, format=None):
        # The format of the container.
        # 
        # *   Default value: mp4.
        # *   Video formats include FLV, MP4, HLS (M3U8 + TS), and MPEG-DASH (MPD + fMP4)
        # *   Audio formats include MP3, MP4, Ogg, FLAC, and M4A.
        # *   Image formats include GIF and WebP.
        # *   If the container format is GIF, the video codec must be set to GIF.
        # *   If the container format is WebP, the video codec must be set to WebP.
        # *   If the container format is FLV, the video codec cannot be set to H.265.
        self.format = format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputContainer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class ListJobResponseBodyJobListJobOutputEncryption(TeaModel):
    def __init__(self, id=None, key=None, key_type=None, key_uri=None, skip_cnt=None, type=None):
        # The encryption ID.
        self.id = id  # type: str
        # The key that is used to encrypt the video.
        self.key = key  # type: str
        # The key encryption method. Valid values: Base64 and KMS.
        # 
        # >  For example, if the key is `"encryptionkey128”`, you can encrypt the key in the Base64 format or use Key Management Service (KMS) to encrypt the key.````
        self.key_type = key_type  # type: str
        # The URL that is used to request the key. The URL is Base64-encoded.
        self.key_uri = key_uri  # type: str
        # The number of unencrypted frames at the beginning of the video. Leaving these frames unencrypted enables video playback to start quickly.
        self.skip_cnt = skip_cnt  # type: str
        # The encryption type. Valid value: hls-aes-128.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputEncryption, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS(TeaModel):
    def __init__(self, md_5support=None, size_support=None):
        # Indicates whether to support the output of the md5 value of the TS file in the M3U8 video. Valid values:
        # 
        # *   **true**: supported.
        # *   **false**: not supported.
        self.md_5support = md_5support  # type: bool
        # Indicates whether to support the output of the size of the TS file in the M3U8 video.
        # 
        # *   **true**: supported.
        # *   **false**: not supported.
        self.size_support = size_support  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        return self


class ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport(TeaModel):
    def __init__(self, ts=None):
        # The non-standard support configuration for TS files. The value must be a JSON object. For more information, see [Parameter details](~~29253~~).
        self.ts = ts  # type: ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class ListJobResponseBodyJobListJobOutputMergeListMerge(TeaModel):
    def __init__(self, duration=None, merge_url=None, role_arn=None, start=None):
        # The start point in time of the clip.
        # 
        # *   Format: `hh:mm:ss[.SSS]` or `sssss[.SSS]`.
        # *   Example values: 01:59:59.999 and 32000.23.
        self.duration = duration  # type: str
        # The OSS URL of the clip.
        # 
        # *   Example: `http://example-bucket-****.oss-cn-hangzhou.aliyuncs.com/example-object.flv`.
        # *   The object must be URL-encoded by using the UTF-8 standard.
        self.merge_url = merge_url  # type: str
        # The Alibaba Cloud Resource Name (ARN) of the role used for proxy authorization.
        self.role_arn = role_arn  # type: str
        # The start point in time of the clip.
        # 
        # *   Format: `hh:mm:ss[.SSS]` or `sssss[.SSS]`.
        # *   Example values: 01:59:59.999 and 32000.23.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputMergeListMerge, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class ListJobResponseBodyJobListJobOutputMergeList(TeaModel):
    def __init__(self, merge=None):
        self.merge = merge  # type: list[ListJobResponseBodyJobListJobOutputMergeListMerge]

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputMergeList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = ListJobResponseBodyJobListJobOutputMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigGif(TeaModel):
    def __init__(self, dither_mode=None, final_delay=None, is_custom_palette=None, loop=None):
        # The color dithering algorithm of the palette. Valid values: **sierra** and **bayer**.
        self.dither_mode = dither_mode  # type: str
        # The duration for which the final frame is paused. Unit: centiseconds.
        self.final_delay = final_delay  # type: str
        # Indicates whether the custom palette was used. Valid values:
        # 
        # - **true**: custom.
        # - **false**: non-custom.
        self.is_custom_palette = is_custom_palette  # type: str
        # The loop count.
        self.loop = loop  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputMuxConfigGif, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigSegment(TeaModel):
    def __init__(self, duration=None):
        # The length of the segment. The value must be an integer. Unit: seconds. 
        # 
        # - Valid values: [1,10].
        # - Default value: 10.
        self.duration = duration  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputMuxConfigSegment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigWebp(TeaModel):
    def __init__(self, loop=None):
        # The loop count.
        self.loop = loop  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputMuxConfigWebp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfig(TeaModel):
    def __init__(self, gif=None, segment=None, webp=None):
        # The transmuxing configuration for GIF.
        self.gif = gif  # type: ListJobResponseBodyJobListJobOutputMuxConfigGif
        # The segment configuration. The value is a JSON object.
        self.segment = segment  # type: ListJobResponseBodyJobListJobOutputMuxConfigSegment
        # The transmuxing configuration for WebP.
        self.webp = webp  # type: ListJobResponseBodyJobListJobOutputMuxConfigWebp

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()
        if self.webp:
            self.webp.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputMuxConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        if self.webp is not None:
            result['Webp'] = self.webp.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        if m.get('Webp') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigWebp()
            self.webp = temp_model.from_map(m['Webp'])
        return self


class ListJobResponseBodyJobListJobOutputOpeningListOpening(TeaModel):
    def __init__(self, height=None, start=None, width=None, open_url=None):
        # The height of the opening part. Valid values: values in the range of (0, 4096), -1, and full.
        # 
        # *   Default value: **-1**.
        # *   A value of -1 indicates that the height of the source of the opening part is retained.
        # *   A value of full indicates that the height of the main part is used for the opening part.
        self.height = height  # type: str
        # The amount of time after which the opening part is played. The value starts from 0.
        # 
        # *   Unit: seconds.
        # *   Default value: **0**.
        self.start = start  # type: str
        # The width of the opening part. Valid values: values in the range of (0, 4096), -1, and full.
        # 
        # *   Default value: **-1**.
        # *   A value of -1 indicates that the width of the source of the opening part is retained.
        # *   A value of full indicates that the width of the main part is used for the opening part.
        self.width = width  # type: str
        # The OSS URL of the opening part of the video.
        self.open_url = open_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputOpeningListOpening, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height is not None:
            result['Height'] = self.height
        if self.start is not None:
            result['Start'] = self.start
        if self.width is not None:
            result['Width'] = self.width
        if self.open_url is not None:
            result['openUrl'] = self.open_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('openUrl') is not None:
            self.open_url = m.get('openUrl')
        return self


class ListJobResponseBodyJobListJobOutputOpeningList(TeaModel):
    def __init__(self, opening=None):
        self.opening = opening  # type: list[ListJobResponseBodyJobListJobOutputOpeningListOpening]

    def validate(self):
        if self.opening:
            for k in self.opening:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputOpeningList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Opening'] = []
        if self.opening is not None:
            for k in self.opening:
                result['Opening'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.opening = []
        if m.get('Opening') is not None:
            for k in m.get('Opening'):
                temp_model = ListJobResponseBodyJobListJobOutputOpeningListOpening()
                self.opening.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None, role_arn=None):
        # The name of the OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The OSS region where the output file resides.
        self.location = location  # type: str
        # The name of the OSS object of the output file.
        self.object = object  # type: str
        # The ARN of the role used for proxy authorization.
        self.role_arn = role_arn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle(TeaModel):
    def __init__(self, map=None, message=None, out_subtitle_file=None, success=None):
        # The video track. Format: 0:{stream}:{stream sequence number}, that is, 0:v:{video_index}. The value of stream is v, which indicates an audio stream of a video. The sequence number is the index of the audio stream in the list and starts from 0.
        self.map = map  # type: str
        # The error message that is returned when the job fails to be created. This parameter is not returned if the job is created.
        self.message = message  # type: str
        # The details of the output file.
        self.out_subtitle_file = out_subtitle_file  # type: ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile
        # Indicates whether the job was successful. Valid values:
        # 
        # *   **true**: The job was successful.
        # *   **fasle**: The job failed.
        self.success = success  # type: bool

    def validate(self):
        if self.out_subtitle_file:
            self.out_subtitle_file.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        if self.message is not None:
            result['Message'] = self.message
        if self.out_subtitle_file is not None:
            result['OutSubtitleFile'] = self.out_subtitle_file.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OutSubtitleFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile()
            self.out_subtitle_file = temp_model.from_map(m['OutSubtitleFile'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleList(TeaModel):
    def __init__(self, out_subtitle=None):
        self.out_subtitle = out_subtitle  # type: list[ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle]

    def validate(self):
        if self.out_subtitle:
            for k in self.out_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputOutSubtitleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OutSubtitle'] = []
        if self.out_subtitle is not None:
            for k in self.out_subtitle:
                result['OutSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.out_subtitle = []
        if m.get('OutSubtitle') is not None:
            for k in m.get('OutSubtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle()
                self.out_subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputOutputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None, role_arn=None):
        # The name of the OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The OSS region where the output file resides.
        self.location = location  # type: str
        # The name of the OSS object of the output file.
        self.object = object  # type: str
        # The ARN of the role used for proxy authorization.
        self.role_arn = role_arn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputOutputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesFormat(TeaModel):
    def __init__(self, bitrate=None, duration=None, format_long_name=None, format_name=None, num_programs=None,
                 num_streams=None, size=None, start_time=None):
        # The total bitrate.
        self.bitrate = bitrate  # type: str
        # The total duration.
        self.duration = duration  # type: str
        # The full name of the container format.
        self.format_long_name = format_long_name  # type: str
        # The short name of the container format. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format_name = format_name  # type: str
        # The total number of program streams.
        self.num_programs = num_programs  # type: str
        # The total number of media streams.
        self.num_streams = num_streams  # type: str
        # The size of the file.
        self.size = size  # type: str
        # The start time.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 num_frames=None, sample_fmt=None, samplerate=None, start_time=None, timebase=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The output layout of the sound channels.
        self.channel_layout = channel_layout  # type: str
        # The number of sound channels.
        self.channels = channels  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The sequence number of the audio stream. The value indicates the position of the audio stream in all audio streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmeg language definition](https://www.ffmpeg.org/ffmpeg-all.html#Metadata) and [ISO-639](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes).
        self.lang = lang  # type: str
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The sampling format.
        self.sample_fmt = sample_fmt  # type: str
        # The sampling rate.
        self.samplerate = samplerate  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(self, audio_stream=None):
        self.audio_stream = audio_stream  # type: list[ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream]

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(self, index=None, lang=None):
        # The sequence number of the subtitle stream. 
        # 
        # The value specifies the position of the subtitle stream in all subtitle streams.
        self.index = index  # type: str
        # The language.
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(self, subtitle_stream=None):
        self.subtitle_stream = subtitle_stream  # type: list[ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream]

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(self, avg_bitrate=None, cost_bandwidth=None, preload_time=None):
        # The average bitrate.
        self.avg_bitrate = avg_bitrate  # type: str
        # The maximum bandwidth that was consumed.
        self.cost_bandwidth = cost_bandwidth  # type: str
        # The amount of preload time.
        self.preload_time = preload_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(self, avg_fps=None, bitrate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, network_cost=None, num_frames=None, pix_fmt=None, profile=None,
                 sar=None, start_time=None, timebase=None, width=None):
        # The average frame rate.
        self.avg_fps = avg_fps  # type: str
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The display aspect ratio (DAR).
        self.dar = dar  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The frame rate.
        self.fps = fps  # type: str
        # Indicates whether the video stream contains bidirectional frames (B-frames).
        self.has_bframes = has_bframes  # type: str
        # The height of the video in pixels.
        self.height = height  # type: str
        # The sequence number of the video stream. The value indicates the position of the video stream in all video streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmeg language definition](https://www.ffmpeg.org/ffmpeg-all.html#Metadata) and [ISO-639](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes).
        self.lang = lang  # type: str
        # The codec level.
        self.level = level  # type: str
        # The network bandwidth consumption.
        self.network_cost = network_cost  # type: ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost
        # The total frame rate.
        self.num_frames = num_frames  # type: str
        # The pixel format.
        self.pix_fmt = pix_fmt  # type: str
        # The codec profile.
        self.profile = profile  # type: str
        # The sample aspect ratio (SAR) of the video stream.
        self.sar = sar  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str
        # The width of the video in pixels.
        self.width = width  # type: str

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NetworkCost') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(self, video_stream=None):
        self.video_stream = video_stream  # type: list[ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream]

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreams(TeaModel):
    def __init__(self, audio_stream_list=None, subtitle_stream_list=None, video_stream_list=None):
        # The list of audio streams.
        self.audio_stream_list = audio_stream_list  # type: ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList
        # The list of subtitle streams.
        self.subtitle_stream_list = subtitle_stream_list  # type: ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList
        # The list of video streams.
        self.video_stream_list = video_stream_list  # type: ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList

    def validate(self):
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()
        if self.video_stream_list:
            self.video_stream_list.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputPropertiesStreams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        if m.get('VideoStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        return self


class ListJobResponseBodyJobListJobOutputProperties(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_format=None, file_size=None, format=None, fps=None,
                 height=None, streams=None, width=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The format of the video file.
        self.file_format = file_format  # type: str
        # The size of the file.
        self.file_size = file_size  # type: str
        # The format information.
        self.format = format  # type: ListJobResponseBodyJobListJobOutputPropertiesFormat
        # The frame rate.
        self.fps = fps  # type: str
        # The length of the video.
        self.height = height  # type: str
        # The stream information.
        self.streams = streams  # type: ListJobResponseBodyJobListJobOutputPropertiesStreams
        # The width of the video.
        self.width = width  # type: str

    def validate(self):
        if self.format:
            self.format.validate()
        if self.streams:
            self.streams.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputProperties, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('Format') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Streams') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The OSS region where the input file resides.
        self.location = location  # type: str
        # The name of the OSS object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(self, char_enc=None, font_name=None, input=None):
        # The character set used by the external subtitle. 
        # 
        # - Valid values: UTF-8, GBK, BIG5, and auto.
        # - Default value: **auto**.
        # 
        # >  If you set this parameter to auto, the detected character set may not be the actual character set. We recommend that you set this parameter to another value.
        self.char_enc = char_enc  # type: str
        # The font of the hard subtitles converted from external subtitles.
        self.font_name = font_name  # type: str
        # The input subtitle file. 
        # 
        # - Files in the SRT or ASS format are supported. For more information, see [Parameter details](https://www.alibabacloud.com/help/en/apsaravideo-for-media-processing/latest/parameter-details).
        # - Example: `{“Bucket”:”example-bucket”,“Location”:”oss-cn-hangzhou”,“Object”:”example.srt”}`.
        self.input = input  # type: ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(self, ext_subtitle=None):
        self.ext_subtitle = ext_subtitle  # type: list[ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle]

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(self, map=None):
        # The sequence number of the video stream. The sequence number is the index of the video stream in the list and starts from 0. If you do not set the corresponding parameter in the request, the default video stream is selected.
        self.map = map  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList(TeaModel):
    def __init__(self, subtitle=None):
        self.subtitle = subtitle  # type: list[ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle]

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfig(TeaModel):
    def __init__(self, ext_subtitle_list=None, subtitle_list=None):
        # The list of external subtitles. The value is a JSON array.
        self.ext_subtitle_list = ext_subtitle_list  # type: ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList
        # The list of subtitles.
        self.subtitle_list = subtitle_list  # type: ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputSubtitleConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class ListJobResponseBodyJobListJobOutputSuperReso(TeaModel):
    def __init__(self, is_half_sample=None):
        # Indicates whether to obtain parameters related to the sampling rate. Valid values:
        # 
        # - **true**: The parameters are obtained.
        # - **false**: The parameters are not obtained.
        self.is_half_sample = is_half_sample  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputSuperReso, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class ListJobResponseBodyJobListJobOutputTailSlateListTailSlate(TeaModel):
    def __init__(self, bg_color=None, blend_duration=None, height=None, is_merge_audio=None, start=None,
                 tail_url=None, width=None):
        # The color of the bars that are added to the ending part if the size of the ending part is smaller than that of the main part. Default value: **White**. For more information, see [Background colors](https://docs-aliyun.cn-hangzhou.oss.aliyun-inc.com/assets/attach/29253/cn_zh/1502784952344/color.txt?spm=a2c4g.11186623.2.63.1df840f74IH4Eq&file=color.txt).
        self.bg_color = bg_color  # type: str
        # The amount of time between the end of the main part and the beginning of the ending part. During the transition, the last frame of the main part fades out, and the first frame of the ending part fades in. Unit: seconds. Default value: 0.
        self.blend_duration = blend_duration  # type: str
        # The height of the ending part. Valid values: values in the range of (0, 4096), -1, and full. 
        # 
        # - A value of -1 indicates that the height of the source of the ending part is retained.
        # - A value of full indicates that the height of the main part is used for the ending part.
        # - Default value: **-1**.
        self.height = height  # type: str
        # Indicates whether to merge the audio content of the ending part. Valid values:
        # 
        # - **true**: The audio content of the ending part is merged.
        # - **false**: The audio content of the ending part is not merged.
        self.is_merge_audio = is_merge_audio  # type: bool
        # The start time.
        self.start = start  # type: str
        # The OSS URL of the ending part.
        self.tail_url = tail_url  # type: str
        # The width of the ending part. Valid values: values in the range of (0, 4096), -1, and full.  
        # 
        # - A value of -1 indicates that the width of the source of the ending part is retained. A value of full indicates that the width of the main part is used for the ending part.
        # - Default value: **-1**.
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputTailSlateListTailSlate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.blend_duration is not None:
            result['BlendDuration'] = self.blend_duration
        if self.height is not None:
            result['Height'] = self.height
        if self.is_merge_audio is not None:
            result['IsMergeAudio'] = self.is_merge_audio
        if self.start is not None:
            result['Start'] = self.start
        if self.tail_url is not None:
            result['TailUrl'] = self.tail_url
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('BlendDuration') is not None:
            self.blend_duration = m.get('BlendDuration')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('IsMergeAudio') is not None:
            self.is_merge_audio = m.get('IsMergeAudio')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('TailUrl') is not None:
            self.tail_url = m.get('TailUrl')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputTailSlateList(TeaModel):
    def __init__(self, tail_slate=None):
        self.tail_slate = tail_slate  # type: list[ListJobResponseBodyJobListJobOutputTailSlateListTailSlate]

    def validate(self):
        if self.tail_slate:
            for k in self.tail_slate:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputTailSlateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TailSlate'] = []
        if self.tail_slate is not None:
            for k in self.tail_slate:
                result['TailSlate'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tail_slate = []
        if m.get('TailSlate') is not None:
            for k in m.get('TailSlate'):
                temp_model = ListJobResponseBodyJobListJobOutputTailSlateListTailSlate()
                self.tail_slate.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputTransConfig(TeaModel):
    def __init__(self, adj_dar_method=None, is_check_audio_bitrate=None, is_check_audio_bitrate_fail=None,
                 is_check_reso=None, is_check_reso_fail=None, is_check_video_bitrate=None, is_check_video_bitrate_fail=None,
                 trans_mode=None):
        # The method of resolution adjustment. Default value: **none**. Valid values: rescale, crop, pad, and none.
        self.adj_dar_method = adj_dar_method  # type: str
        # Indicates whether the audio bitrate is checked. If the output audio bitrate is higher than the input audio bitrate, the system considers that the output bitrate equals the input bitrate.
        # 
        # *   **true**: The audio bitrate is checked.
        # *   **false**: The audio bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_audio_bitrate = is_check_audio_bitrate  # type: str
        # Indicates whether the audio bitrate is checked. If the output audio bitrate is higher than the audio bitrate of the media source, a transcoding failure is returned without transcoding the media. This parameter takes precedence over the IsCheckAudioBitrate parameter.
        # 
        # *   **true**: The audio bitrate is checked.
        # *   **false**: The audio bitrate is not checked.
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail  # type: str
        # Indicates whether the resolution is checked. If the output resolution is higher than the input resolution based on the width or height, the system considers that the output resolution equals the input resolution.
        # 
        # *   **true**: The resolution is checked.
        # *   **false**: The resolution is not checked.
        # *   Default value: **false**.
        self.is_check_reso = is_check_reso  # type: str
        # Indicates whether the resolution is checked. If the output resolution is higher than the input resolution based on the width or height, a transcoding failure is returned.
        # 
        # *   **true**: The resolution is checked.
        # *   **false**: The resolution is not checked.
        # *   Default value: **false**.
        self.is_check_reso_fail = is_check_reso_fail  # type: str
        # Indicates whether the video bitrate is checked. If the output video bitrate is higher than the input video bitrate, the system considers that the output bitrate equals the input bitrate.
        # 
        # *   **true**: The video bitrate is checked.
        # *   **false**: The video bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_video_bitrate = is_check_video_bitrate  # type: str
        # Indicates whether the video bitrate is checked. If the bitrate of the output video is higher than that of the input video, a transcoding failure is returned without transcoding the video. This parameter takes precedence over the IsCheckVideoBitrate parameter.
        # 
        # *   **true**: The video bitrate is checked.
        # *   **false**: The video bitrate is not checked.
        # *   Default value: false.
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail  # type: str
        # The transcoding mode.
        # 
        # *   Valid values: onepass, twopass, and CBR.
        # *   Default value: onepass.
        self.trans_mode = trans_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputTransConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class ListJobResponseBodyJobListJobOutputVideoBitrateBnd(TeaModel):
    def __init__(self, max=None, min=None):
        # The maximum bitrate. Unit: Kbit/s.
        self.max = max  # type: str
        # The minimum bitrate. Unit: Kbit/s.
        self.min = min  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputVideoBitrateBnd, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class ListJobResponseBodyJobListJobOutputVideo(TeaModel):
    def __init__(self, bitrate=None, bitrate_bnd=None, bufsize=None, codec=None, crf=None, crop=None, degrain=None,
                 fps=None, gop=None, height=None, max_fps=None, maxrate=None, pad=None, pix_fmt=None, preset=None,
                 profile=None, qscale=None, reso_priority=None, scan_mode=None, width=None):
        # The average bitrate of the video. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The bitrate range of the video.
        self.bitrate_bnd = bitrate_bnd  # type: ListJobResponseBodyJobListJobOutputVideoBitrateBnd
        # The size of the buffer.
        self.bufsize = bufsize  # type: str
        # The codec. Valid values: **H.264**, **H.265**, **GIF**, and **WEBP**.
        self.codec = codec  # type: str
        # The constant rate factor. If this parameter is specified, the setting of the Bitrate parameter becomes invalid. Default value: **26**.
        self.crf = crf  # type: str
        # The video cropping mode. The following modes are supported:
        # 
        # *   **border**: automatically detects and removes borders.
        # *   Custom cropping. Specify a value in the format of width:height:left:top to crop the video based on the custom settings. Example: 1280:800:0:140.
        self.crop = crop  # type: str
        # The level of the independent denoising algorithm.
        self.degrain = degrain  # type: str
        # The frame rate.
        # 
        # *   The value is 60 if the frame rate of the input file exceeds 60.
        # *   Default value: the frame rate of the input file.
        self.fps = fps  # type: str
        # The maximum number of frames between two keyframes. Default value: 250.
        self.gop = gop  # type: str
        # The height.
        # 
        # *   Unit: pixels.
        # *   Default value: the original height of the video.
        self.height = height  # type: str
        # The maximum frame rate.
        self.max_fps = max_fps  # type: str
        # The maximum bitrate of the video. Unit: Kbit/s.
        self.maxrate = maxrate  # type: str
        # The black borders to be added to the video. Unit: pixels.
        # 
        # *   Format: width:height:left:top.
        # *   Example: 1280:800:0:140.
        self.pad = pad  # type: str
        # The video color format. Valid values: standard pixel formats such as yuv420p and yuvj420p.
        self.pix_fmt = pix_fmt  # type: str
        # The preset video algorithm. Default value: medium. Valid values:
        # 
        # *   **veryfast**\
        # *   **fast**\
        # *   **medium**\
        # *   **slow**\
        # *   **slower**\
        self.preset = preset  # type: str
        # The codec profile. Valid values:
        # 
        # *   **baseline**: applicable to mobile devices.
        # *   **main**: applicable to standard-definition devices.
        # *   **high**: applicable to high-definition devices.
        # *   Default value: **high**.
        self.profile = profile  # type: str
        # The level of quality control on the video.
        self.qscale = qscale  # type: str
        # The priority of the resource.
        self.reso_priority = reso_priority  # type: str
        # The scan mode. Valid values:
        # 
        # *   **interlaced**: An interlaced scan was performed.
        # *   **progressive**: A progressive scan was performed.
        # *   **auto**: A scan was performed based on the video source.
        self.scan_mode = scan_mode  # type: str
        # The width.
        # 
        # *   Unit: pixels.
        # *   Default value: the original width of the video.
        self.width = width  # type: str

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.reso_priority is not None:
            result['ResoPriority'] = self.reso_priority
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('ResoPriority') is not None:
            self.reso_priority = m.get('ResoPriority')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The name of the OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The OSS region where the input file resides.
        self.location = location  # type: str
        # The name of the OSS object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark(TeaModel):
    def __init__(self, dx=None, dy=None, height=None, input_file=None, refer_pos=None, type=None,
                 water_mark_template_id=None, width=None):
        # The horizontal offset of the watermark relative to the output video. If this parameter was specified in the request, the value overwrites the corresponding parameter in the watermark template. Default value: 0. The value can be an integer or a decimal.
        # 
        # *   An integer indicates the pixel value of the horizontal offset.
        # 
        #     *   Valid values: \[8,4096].
        #     *   Unit: pixels.
        # 
        # *   A decimal indicates the ratio of the horizontal offset to the width in the output video resolution.
        # 
        #     *   Valid values: (0,1).
        #     *   The decimal number can be accurate to four decimal places, such as 0.9999. Excessive digits are automatically deleted.
        self.dx = dx  # type: str
        # The vertical offset of the watermark image relative to the output video. If this parameter was specified in the request, the value overwrites the corresponding parameter in the watermark template. The value can be an integer or a decimal.
        # 
        # *   An integer indicates the pixel value of the vertical offset.
        # 
        #     *   Valid values: \[8,4096].
        #     *   Unit: pixels.
        # 
        # *   A decimal indicates the ratio of the vertical offset to the height in the output video resolution.
        # 
        #     *   Valid values: (0,1).
        #     *   The decimal number can be accurate to four decimal places, such as 0.9999. Excessive digits are automatically deleted.
        self.dy = dy  # type: str
        # The height of the watermark. If this parameter was specified in the request, the value overwrites the corresponding parameter in the watermark template. The value can be an integer or a decimal.
        # 
        # *   An integer indicates the pixel value of the watermark height.
        # 
        #     *   Valid values: \[8,4096].
        #     *   Unit: pixels.
        # 
        # *   A decimal indicates the ratio of the watermark height to the height in the output video resolution.
        # 
        #     *   Valid values: (0,1).
        #     *   The decimal number can be accurate to four decimal places, such as 0.9999. Excessive digits are automatically deleted.
        self.height = height  # type: str
        # The watermark input file.
        self.input_file = input_file  # type: ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile
        # The position of the watermark.
        # 
        # *   **TopRight**: the upper-right corner.
        # *   **TopLeft**: the upper-left corner.
        # *   **BottomRight**: the lower-right corner.
        # *   **BottomLeft**: the lower-left corner.
        self.refer_pos = refer_pos  # type: str
        # The type of the watermark. If this parameter was specified in the request, the value overwrites the corresponding parameter in the watermark template. For more information, see [Parameter details](~~29253~~). Valid values:
        # 
        # *   **Image**: an image watermark.
        # *   **Text**: a text watermark.
        self.type = type  # type: str
        # The ID of the watermark template.
        self.water_mark_template_id = water_mark_template_id  # type: str
        # The width of the watermark. If this parameter was specified in the request, the value overwrites the corresponding parameter in the watermark template. The value can be an integer or a decimal.
        # 
        # *   An integer indicates the pixel value of the watermark width.
        # 
        #     *   Valid values: \[8,4096].
        #     *   Unit: pixels.
        # 
        # *   A decimal indicates the ratio of the watermark width to the width in the output video resolution.
        # 
        #     *   Valid values: (0,1).
        #     *   The decimal number can be accurate to four decimal places, such as 0.9999. Excessive digits are automatically deleted.
        self.width = width  # type: str

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.type is not None:
            result['Type'] = self.type
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkList(TeaModel):
    def __init__(self, water_mark=None):
        self.water_mark = water_mark  # type: list[ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark]

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutputWaterMarkList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutput(TeaModel):
    def __init__(self, audio=None, audio_stream_map=None, clip=None, container=None, de_watermark=None,
                 encryption=None, m_3u8non_standard_support=None, merge_config_url=None, merge_list=None, mux_config=None,
                 opening_list=None, out_subtitle_list=None, output_file=None, priority=None, properties=None, rotate=None,
                 subtitle_config=None, super_reso=None, tail_slate_list=None, template_id=None, trans_config=None, user_data=None,
                 video=None, video_stream_map=None, water_mark_config_url=None, water_mark_list=None):
        # The audio configuration.
        self.audio = audio  # type: ListJobResponseBodyJobListJobOutputAudio
        # The sequence number of the audio stream.
        # 
        # *   Format: `0:a:{sequence number}`.
        # *   The sequence number is the index of the audio stream in the list and starts from 0. If you do not set the corresponding parameter in the request, the default audio stream is selected.
        self.audio_stream_map = audio_stream_map  # type: str
        # The information about the clip.
        self.clip = clip  # type: ListJobResponseBodyJobListJobOutputClip
        # The information about the container.
        self.container = container  # type: ListJobResponseBodyJobListJobOutputContainer
        # The configuration of watermark blurring. The value must be a JSON object. For more information, see [Parameter details](~~29253~~).
        self.de_watermark = de_watermark  # type: str
        # The encryption configuration. Only outputs in the M3U8 format are supported.
        self.encryption = encryption  # type: ListJobResponseBodyJobListJobOutputEncryption
        # The non-standard support configuration for M3U8. The value must be a JSON object. For more information, see [Parameter details](~~29253~~).
        self.m_3u8non_standard_support = m_3u8non_standard_support  # type: ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport
        # The URL of the merging configuration file. You can specify either the MergeList or MergeConfigUrl parameter.  
        # 
        # - The configuration file that you specify by using the MergeConfigUrl parameter can contain up to 50 merged clips.
        # - The MergeConfigUrl parameter specifies the URL of the configuration file for clip merging.
        # - Make sure that the configuration file is stored as an object in OSS and that MPS can access the OSS object. For information about the file content, see the details about merging parameters.
        # - Example of the content of mergeConfigfile: `{"MergeList":[{"MergeURL":"http://exampleBucket****.oss-cn-hangzhou.aliyuncs.com/video_01.mp4"}]}`.
        self.merge_config_url = merge_config_url  # type: str
        # The clip merging configuration.
        self.merge_list = merge_list  # type: ListJobResponseBodyJobListJobOutputMergeList
        # The transmuxing configuration.
        self.mux_config = mux_config  # type: ListJobResponseBodyJobListJobOutputMuxConfig
        # The list of opening parts.
        self.opening_list = opening_list  # type: ListJobResponseBodyJobListJobOutputOpeningList
        # The output subtitle list.
        self.out_subtitle_list = out_subtitle_list  # type: ListJobResponseBodyJobListJobOutputOutSubtitleList
        # The information about the output file.
        self.output_file = output_file  # type: ListJobResponseBodyJobListJobOutputOutputFile
        # The priority of the job in the MPS queue to which the job is added. 
        # 
        # - A value of 10 indicates the highest priority.
        # - Default value: **6**.
        self.priority = priority  # type: str
        # The media properties.
        self.properties = properties  # type: ListJobResponseBodyJobListJobOutputProperties
        # The video rotation angle.
        self.rotate = rotate  # type: str
        # The subtitle configuration.
        self.subtitle_config = subtitle_config  # type: ListJobResponseBodyJobListJobOutputSubtitleConfig
        # Indicates that the resolution of the source video is used.
        self.super_reso = super_reso  # type: ListJobResponseBodyJobListJobOutputSuperReso
        # The list of ending parts.
        self.tail_slate_list = tail_slate_list  # type: ListJobResponseBodyJobListJobOutputTailSlateList
        # The ID of the template.
        self.template_id = template_id  # type: str
        # The general transcoding configuration. If this parameter was specified in the request, the value overwrites the corresponding parameter in the specified transcoding template.
        self.trans_config = trans_config  # type: ListJobResponseBodyJobListJobOutputTransConfig
        # The custom data.
        self.user_data = user_data  # type: str
        # The video configuration.
        self.video = video  # type: ListJobResponseBodyJobListJobOutputVideo
        # The sequence number of the video stream. 
        # 
        # - Format: 0:a:{Sequence number}. Example value: 0:a:0.
        # - The sequence number is the index of the video stream in the list and starts from 0.
        # - If you do not set the corresponding parameter in the request, the default video stream is selected.
        self.video_stream_map = video_stream_map  # type: str
        # The URL of the watermark configuration file.
        self.water_mark_config_url = water_mark_config_url  # type: str
        # The list of watermarks.
        self.water_mark_list = water_mark_list  # type: ListJobResponseBodyJobListJobOutputWaterMarkList

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.clip:
            self.clip.validate()
        if self.container:
            self.container.validate()
        if self.encryption:
            self.encryption.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.opening_list:
            self.opening_list.validate()
        if self.out_subtitle_list:
            self.out_subtitle_list.validate()
        if self.output_file:
            self.output_file.validate()
        if self.properties:
            self.properties.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.tail_slate_list:
            self.tail_slate_list.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJobOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.opening_list is not None:
            result['OpeningList'] = self.opening_list.to_map()
        if self.out_subtitle_list is not None:
            result['OutSubtitleList'] = self.out_subtitle_list.to_map()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.tail_slate_list is not None:
            result['TailSlateList'] = self.tail_slate_list.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('Clip') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('Container') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('Encryption') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('MergeList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('MuxConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('OpeningList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOpeningList()
            self.opening_list = temp_model.from_map(m['OpeningList'])
        if m.get('OutSubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleList()
            self.out_subtitle_list = temp_model.from_map(m['OutSubtitleList'])
        if m.get('OutputFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Properties') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputProperties()
            self.properties = temp_model.from_map(m['Properties'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('SubtitleConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('SuperReso') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('TailSlateList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputTailSlateList()
            self.tail_slate_list = temp_model.from_map(m['TailSlateList'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TransConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Video') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('WaterMarkList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        return self


class ListJobResponseBodyJobListJob(TeaModel):
    def __init__(self, code=None, creation_time=None, finish_time=None, input=None, job_id=None,
                 mnsmessage_result=None, message=None, output=None, percent=None, pipeline_id=None, state=None):
        # The error code that is returned when the job fails. This parameter is not returned if the job is successful.
        self.code = code  # type: str
        # The time when the job was created.
        self.creation_time = creation_time  # type: str
        # The time when the transcoding job was complete.
        self.finish_time = finish_time  # type: str
        # The information about the job input.
        self.input = input  # type: ListJobResponseBodyJobListJobInput
        # The ID of the job.
        self.job_id = job_id  # type: str
        # The message sent by Message Service (MNS) to notify the user of the job result.
        self.mnsmessage_result = mnsmessage_result  # type: ListJobResponseBodyJobListJobMNSMessageResult
        # The message that is returned when the job fails. This parameter is not returned if the job is successful.
        self.message = message  # type: str
        # The output of the job.
        self.output = output  # type: ListJobResponseBodyJobListJobOutput
        # The transcoding progress.
        self.percent = percent  # type: long
        # The ID of the MPS queue.
        self.pipeline_id = pipeline_id  # type: str
        # The status of the job. Valid values:
        # 
        # *   **Submitted**: The job is submitted.
        # *   **Transcoding**: The job is being transcoded.
        # *   **TranscodeSuccess**: Transcoding is successful.
        # *   **TranscodeFail**: Transcoding failed.
        # *   **TranscodeCancelled**: Transcoding is canceled.
        self.state = state  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobListJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = ListJobResponseBodyJobListJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = ListJobResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Output') is not None:
            temp_model = ListJobResponseBodyJobListJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListJobResponseBodyJobList(TeaModel):
    def __init__(self, job=None):
        self.job = job  # type: list[ListJobResponseBodyJobListJob]

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = ListJobResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class ListJobResponseBody(TeaModel):
    def __init__(self, job_list=None, next_page_token=None, request_id=None):
        # The list of transcoding jobs.
        self.job_list = job_list  # type: ListJobResponseBodyJobList
        # The token that is used to retrieve the next page of the query results. You must record the token and specify it in the next request.
        self.next_page_token = next_page_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super(ListJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobList') is not None:
            temp_model = ListJobResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMediaWorkflowExecutionsRequest(TeaModel):
    def __init__(self, input_file_url=None, maximum_page_size=None, media_workflow_id=None,
                 media_workflow_name=None, next_page_token=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The Object Storage Service (OSS) URL of the input file of the media workflow. The URL complies with RFC 3986 and is encoded in UTF-8, with reserved characters being percent-encoded.
        self.input_file_url = input_file_url  # type: str
        # The maximum number of media workflow execution instances to return. Valid values: `[1,100]`. Default value: **10**.
        self.maximum_page_size = maximum_page_size  # type: long
        # The ID of the media workflow whose execution instances you want to query. To obtain the workflow ID, you can log on to the **ApsaraVideo Media Processing (MPS) console** and choose **Workflows** > **Workflow Settings**.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the media workflow. To obtain the workflow name, you can log on to the **MPS console** and choose **Workflows** > **Workflow Settings**.
        self.media_workflow_name = media_workflow_name  # type: str
        # The token that is used to retrieve the next page of the query results. The value is a 32-bit UUID. When you request the first page of query results, leave the NextPageToken parameter empty. When you request more query results, specify the value of the NextPageToken parameter returned in the query results on the previous page.
        self.next_page_token = next_page_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file_url is not None:
            result['InputFileURL'] = self.input_file_url
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_name is not None:
            result['MediaWorkflowName'] = self.media_workflow_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InputFileURL') is not None:
            self.input_file_url = m.get('InputFileURL')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowName') is not None:
            self.media_workflow_name = m.get('MediaWorkflowName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult(TeaModel):
    def __init__(self, error_code=None, error_message=None, message_id=None):
        # The error code returned when the job fails. If the job is successful, this parameter is not returned.
        self.error_code = error_code  # type: str
        # The error message returned when the job fails. If the job is successful, this parameter is not returned.
        self.error_message = error_message  # type: str
        # The ID of the success message. If the job fails, this parameter is not returned.
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity(TeaModel):
    def __init__(self, code=None, end_time=None, job_id=None, mnsmessage_result=None, message=None, name=None,
                 start_time=None, state=None, type=None):
        # The error code returned.
        # 
        # *   The specific error code appears if the activity status is **Fail**.
        # *   This parameter is not returned if the activity status is **Success**.
        self.code = code  # type: str
        # The end time of the activity.
        self.end_time = end_time  # type: str
        # The ID of the job generated when the activity is executed. We recommend that you save this ID for subsequent calls of other operations.
        self.job_id = job_id  # type: str
        # The message sent by Message Service (MNS) to notify the user of the job result.
        self.mnsmessage_result = mnsmessage_result  # type: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult
        # The error message returned.
        # 
        # *   The detailed error message appears if the activity status is **Fail**.
        # *   This parameter is not returned if the activity status is **Success**.
        self.message = message  # type: str
        # The name of the media workflow activity. 
        # 
        # >  The name of an activity in a media workflow is unique.
        self.name = name  # type: str
        # The start time of the activity.
        self.start_time = start_time  # type: str
        # The status of the activity. Valid values:
        # 
        # *   **Running**: The activity is being executed.
        # *   **Fail**: The activity failed to be executed.
        # *   **Skipped**: The activity was skipped.
        # *   **Success**: The activity was successfully executed.
        # 
        # >  For example, the high-definition and standard-definition transcoding activities are to be run after the analysis activity is complete. The system determines the activity to run based on the analysis result. If the definition of the input video content is insufficient, the high-definition transcoding activity may be skipped.
        self.state = state  # type: str
        # The type of the media workflow activity. Valid values: Start, Snapshot, Transcode, Analysis, and Report. For more information, see [Media workflow activities](~~68494~~).
        self.type = type  # type: str

    def validate(self):
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList(TeaModel):
    def __init__(self, activity=None):
        self.activity = activity  # type: list[ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity]

    def validate(self):
        if self.activity:
            for k in self.activity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Activity'] = []
        if self.activity is not None:
            for k in self.activity:
                result['Activity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.activity = []
        if m.get('Activity') is not None:
            for k in m.get('Activity'):
                temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity()
                self.activity.append(temp_model.from_map(k))
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The name of the OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The ID of the OSS region where the input file resides.
        self.location = location  # type: str
        # The name of the OSS object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput(TeaModel):
    def __init__(self, input_file=None, user_data=None):
        # The information about the storage location of the input file of the media workflow in OSS.
        self.input_file = input_file  # type: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile
        # The custom data.
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InputFile') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution(TeaModel):
    def __init__(self, activity_list=None, creation_time=None, input=None, media_id=None, media_workflow_id=None,
                 name=None, run_id=None, state=None):
        # The list of activities that are executed in the media workflow.
        self.activity_list = activity_list  # type: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList
        # The time when the execution instance was created.
        self.creation_time = creation_time  # type: str
        # The custom data of the media workflow.
        self.input = input  # type: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput
        # The ID of the media file. This media file ID is associated with all information generated by the media workflow.
        self.media_id = media_id  # type: str
        # The ID of the media workflow.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the media workflow.
        self.name = name  # type: str
        # The ID of the execution instance.
        self.run_id = run_id  # type: str
        # The status of the execution instance. Valid values:
        # 
        # *   **running**: The execution instance is in progress.
        # *   **Completed**: The execution instance is complete.
        # 
        # >  A value of Completed indicates that the execution instance is complete. For the information about whether each activity, such as Transcode or Snapshot, is successful, check the status of the activity.
        # 
        # *   **Fail**: The execution instance failed.
        # *   **Success**: The execution instance was successful.
        self.state = state  # type: str

    def validate(self):
        if self.activity_list:
            self.activity_list.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_list is not None:
            result['ActivityList'] = self.activity_list.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.run_id is not None:
            result['RunId'] = self.run_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityList') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList()
            self.activity_list = temp_model.from_map(m['ActivityList'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Input') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionList(TeaModel):
    def __init__(self, media_workflow_execution=None):
        self.media_workflow_execution = media_workflow_execution  # type: list[ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution]

    def validate(self):
        if self.media_workflow_execution:
            for k in self.media_workflow_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaWorkflowExecution'] = []
        if self.media_workflow_execution is not None:
            for k in self.media_workflow_execution:
                result['MediaWorkflowExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_workflow_execution = []
        if m.get('MediaWorkflowExecution') is not None:
            for k in m.get('MediaWorkflowExecution'):
                temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution()
                self.media_workflow_execution.append(temp_model.from_map(k))
        return self


class ListMediaWorkflowExecutionsResponseBody(TeaModel):
    def __init__(self, media_workflow_execution_list=None, next_page_token=None, request_id=None):
        # The list of media workflow execution instances.
        self.media_workflow_execution_list = media_workflow_execution_list  # type: ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionList
        # The token that is used to retrieve the next page of the query results.
        self.next_page_token = next_page_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_workflow_execution_list:
            self.media_workflow_execution_list.validate()

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_execution_list is not None:
            result['MediaWorkflowExecutionList'] = self.media_workflow_execution_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflowExecutionList') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBodyMediaWorkflowExecutionList()
            self.media_workflow_execution_list = temp_model.from_map(m['MediaWorkflowExecutionList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListMediaWorkflowExecutionsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListMediaWorkflowExecutionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListMediaWorkflowExecutionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMediaWorkflowExecutionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAnalysisJobListRequest(TeaModel):
    def __init__(self, analysis_job_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The IDs of the template analysis jobs.
        # 
        # *   You can query up to 10 jobs at a time.
        # *   Separate multiple IDs with commas (,).
        self.analysis_job_ids = analysis_job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_job_ids is not None:
            result['AnalysisJobIds'] = self.analysis_job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnalysisJobIds') is not None:
            self.analysis_job_ids = m.get('AnalysisJobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop(TeaModel):
    def __init__(self, height=None, left=None, mode=None, top=None, width=None):
        # The height of the video after the margins were cropped out.
        # 
        # >  This parameter is invalid if the Mode parameter is set to Auto or None.
        self.height = height  # type: str
        # The left margin that was cropped out.
        # 
        # >  This parameter is invalid if the Mode parameter is set to Auto or None.
        self.left = left  # type: str
        # The cropping mode. Valid values: Valid values:
        # 
        # *   **Auto**: Cropping was automatically run.
        # *   **Force**: Cropping was forced to run.
        # *   **None**: Cropping was forced not to run.
        # *   This parameter is required if the value of the Crop parameter is not an empty JSON object.
        self.mode = mode  # type: str
        # The top margin that was cropped out.
        # 
        # >  This parameter is invalid if the Mode parameter is set to Auto or None.
        self.top = top  # type: str
        # The width of the video after the margins were cropped out.
        # 
        # >  This parameter is invalid if the Mode parameter is set to Auto or None.
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height is not None:
            result['Height'] = self.height
        if self.left is not None:
            result['Left'] = self.left
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.top is not None:
            result['Top'] = self.top
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl(TeaModel):
    def __init__(self, crop=None, deinterlace=None):
        # The cropping configuration of video images.
        self.crop = crop  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop
        # Indicates whether deinterlacing was forced to run. Valid values:
        # 
        # *   **Auto**: Deinterlacing was automatically run.
        # *   **Force**: Deinterlacing was forced to run.
        # *   **None**: Deinterlacing was forced not to run.
        self.deinterlace = deinterlace  # type: str

    def validate(self):
        if self.crop:
            self.crop.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.crop is not None:
            result['Crop'] = self.crop.to_map()
        if self.deinterlace is not None:
            result['Deinterlace'] = self.deinterlace
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Crop') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop()
            self.crop = temp_model.from_map(m['Crop'])
        if m.get('Deinterlace') is not None:
            self.deinterlace = m.get('Deinterlace')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl(TeaModel):
    def __init__(self, method_streaming=None, rate_quality=None):
        # The playback mode. Valid values:
        # 
        # *   **network**: online playback
        # *   **local**: playback on on-premises devices
        # *   Default value: **network**.
        self.method_streaming = method_streaming  # type: str
        # The quality level of the job output. Default value: **25**.
        self.rate_quality = rate_quality  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method_streaming is not None:
            result['MethodStreaming'] = self.method_streaming
        if self.rate_quality is not None:
            result['RateQuality'] = self.rate_quality
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MethodStreaming') is not None:
            self.method_streaming = m.get('MethodStreaming')
        if m.get('RateQuality') is not None:
            self.rate_quality = m.get('RateQuality')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig(TeaModel):
    def __init__(self, properties_control=None, quality_control=None):
        # The control on the attributes of the job output.
        self.properties_control = properties_control  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl
        # The quality control on the job output.
        self.quality_control = quality_control  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl

    def validate(self):
        if self.properties_control:
            self.properties_control.validate()
        if self.quality_control:
            self.quality_control.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.properties_control is not None:
            result['PropertiesControl'] = self.properties_control.to_map()
        if self.quality_control is not None:
            result['QualityControl'] = self.quality_control.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PropertiesControl') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl()
            self.properties_control = temp_model.from_map(m['PropertiesControl'])
        if m.get('QualityControl') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl()
            self.quality_control = temp_model.from_map(m['QualityControl'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The name of the OSS bucket to which the input file is uploaded.
        self.bucket = bucket  # type: str
        # The ID of the OSS region.
        self.location = location  # type: str
        # The name of the input file uploaded to the Object Storage Service (OSS) bucket.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult(TeaModel):
    def __init__(self, error_code=None, error_message=None, message_id=None):
        # The error code returned when the job fails. This parameter is not returned if the job is successful.
        self.error_code = error_code  # type: str
        # The error message returned when the job fails. This parameter is not returned if the job is successful.
        self.error_message = error_message  # type: str
        # The ID of the success message. This parameter is not returned if the job fails.
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, qscale=None, samplerate=None):
        # The audio bitrate of the output file.
        # 
        # *   Valid values: **8 to 1000**.
        # *   Unit: Kbit/s.
        # *   Default value: **128**.
        self.bitrate = bitrate  # type: str
        # The number of sound channels. Default value: **2**.
        self.channels = channels  # type: str
        # The audio codec format. Default value: **aac**. Valid values:
        # 
        # *   **aac**\
        # *   **mp3**\
        # *   **vorbis**\
        # *   **flac**\
        self.codec = codec  # type: str
        # The codec profile of the audio file. Valid values when the **Codec** parameter is set to **aac**:
        # 
        # *   **aac_low**\
        # *   **aac_he**\
        # *   **aac_he_v2**\
        # *   **aac_ld**\
        # *   **aac_eld**\
        self.profile = profile  # type: str
        # The level of quality control on the audio.
        self.qscale = qscale  # type: str
        # The sampling rate.
        # 
        # *   Unit: Hz.
        # *   Default value: **44100**.
        self.samplerate = samplerate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer(TeaModel):
    def __init__(self, format=None):
        # The container format.
        self.format = format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif(TeaModel):
    def __init__(self, final_delay=None, loop=None):
        # The interval between two consecutive loops for the GIF format. Unit: 0.01s. For example, a value of 500 indicates 5 seconds.
        self.final_delay = final_delay  # type: str
        # The number of loops for the GIF or WebP format. Default value: 0.
        self.loop = loop  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment(TeaModel):
    def __init__(self, duration=None):
        # The length of the segment. Unit: seconds.
        self.duration = duration  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig(TeaModel):
    def __init__(self, gif=None, segment=None):
        # The GIF format.
        self.gif = gif  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif
        # The segment configuration.
        self.segment = segment  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig(TeaModel):
    def __init__(self, trans_mode=None):
        # The transcoding mode. Default value: **onepass**. Valid values:
        # 
        # *   **onepass**\
        # *   **twopass**\
        # *   **CBR**\
        self.trans_mode = trans_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd(TeaModel):
    def __init__(self, max=None, min=None):
        # The upper limit of the total bitrate. Unit: Kbit/s.
        self.max = max  # type: str
        # The lower limit of the total bitrate. Unit: Kbit/s.
        self.min = min  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo(TeaModel):
    def __init__(self, bitrate=None, bitrate_bnd=None, bufsize=None, codec=None, crf=None, degrain=None, fps=None,
                 gop=None, height=None, maxrate=None, pix_fmt=None, preset=None, profile=None, qscale=None,
                 scan_mode=None, width=None):
        # The average bitrate of the video. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The average bit rate range of the video.
        self.bitrate_bnd = bitrate_bnd  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd
        # The size of the buffer.
        # 
        # *   Unit: KB.
        # *   Default value: **6000**.
        self.bufsize = bufsize  # type: str
        # The video codec format. Valid values: H.264 and H.265. Default value: **H.264**.
        self.codec = codec  # type: str
        # The constant rate factor, which is the default quality control setting.
        # 
        # *   Default value when the Codec parameter is set to H.264: **23**. Default value when the Codec parameter is set to H.265: **26**.
        # *   If this parameter is returned, the setting of the Bitrate parameter is invalid.
        self.crf = crf  # type: str
        # The level of the independent denoising algorithm.
        self.degrain = degrain  # type: str
        # The frame rate.
        # 
        # *   The value is 60 if the frame rate of the input file exceeds 60.
        # *   Default value: **the frame rate of the input file**.
        self.fps = fps  # type: str
        # The maximum number of frames between two keyframes. Default value: **250**.
        self.gop = gop  # type: str
        # The height of the video.
        # 
        # *   Unit: pixel.
        # *   Default value: **the original height of the video**.
        self.height = height  # type: str
        # The maximum video bitrate.
        # 
        # *   Valid values: **10 to 50000**.
        # *   Unit: Kbit/s.
        self.maxrate = maxrate  # type: str
        # The pixel format for video color encoding. Valid values: standard pixel formats such as yuv420p and yuvj420p.
        self.pix_fmt = pix_fmt  # type: str
        # The preset video algorithm. Valid values: veryfast, fast, medium, slow, and slower. Default value: **medium**.
        self.preset = preset  # type: str
        # The codec profile. Valid values:
        # 
        # *   **baseline**: applicable to mobile devices.
        # *   **main**: applicable to standard-definition devices.
        # *   **high**: applicable to high-definition devices.
        # *   Default value: **high**.
        self.profile = profile  # type: str
        # The level of quality control on the video.
        self.qscale = qscale  # type: str
        # The scan mode. Valid values:
        # 
        # *   **interlaced**: An interlaced scan was performed.
        # *   **progressive**: A progressive scan was performed.
        self.scan_mode = scan_mode  # type: str
        # The width of the video.
        # 
        # *   Unit: pixel.
        # *   Default value: **the original width of the video**.
        self.width = width  # type: str

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate(TeaModel):
    def __init__(self, audio=None, container=None, id=None, mux_config=None, name=None, state=None, trans_config=None,
                 video=None):
        # The audio codec configuration.
        self.audio = audio  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio
        # The container configuration.
        self.container = container  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer
        # The ID of the transcoding template.
        self.id = id  # type: str
        # The transmuxing configuration.
        self.mux_config = mux_config  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig
        # The name of the template.
        self.name = name  # type: str
        # The status of the template. Valid values:
        # 
        # *   **Normal**: The template is in the normal state.
        # *   **Deleted**: The template is deleted.
        self.state = state  # type: str
        # The general transcoding configuration.
        self.trans_config = trans_config  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig
        # The video codec configuration.
        self.video = video  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MuxConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TransConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Video') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList(TeaModel):
    def __init__(self, template=None):
        self.template = template  # type: list[QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate]

    def validate(self):
        if self.template:
            for k in self.template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Template'] = []
        if self.template is not None:
            for k in self.template:
                result['Template'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.template = []
        if m.get('Template') is not None:
            for k in m.get('Template'):
                temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate()
                self.template.append(temp_model.from_map(k))
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob(TeaModel):
    def __init__(self, analysis_config=None, code=None, creation_time=None, id=None, input_file=None,
                 mnsmessage_result=None, message=None, percent=None, pipeline_id=None, priority=None, state=None, template_list=None,
                 user_data=None):
        # The job configuration.
        self.analysis_config = analysis_config  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig
        # The error code returned when the job fails.
        self.code = code  # type: str
        # The time when the job was created.
        self.creation_time = creation_time  # type: str
        # The ID of the template analysis job.
        self.id = id  # type: str
        # The information about the job input.
        self.input_file = input_file  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile
        # The message sent by Message Service (MNS) to notify the user of the job result.
        self.mnsmessage_result = mnsmessage_result  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult
        # The error message returned when the job fails.
        self.message = message  # type: str
        # The transcoding progress.
        self.percent = percent  # type: long
        # The ID of the ApsaraVideo Media Processing (MPS) queue to which the job is added.
        self.pipeline_id = pipeline_id  # type: str
        # The priority of the job in the MPS queue to which the job is added. 
        # 
        # - Valid values: **1 to 10**. A value of 10 indicates the highest priority.
        # - Default value: **10**.
        self.priority = priority  # type: str
        # The status of the job. Valid values:
        # 
        # *   **Submitted**: The job has been submitted.
        # *   **Analyzing**: The job is being run.
        # *   **Success**: The job is successful.
        # *   **Fail**: The job fails.
        self.state = state  # type: str
        # The list of matched preset templates.
        self.template_list = template_list  # type: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList
        # The custom data.
        self.user_data = user_data  # type: str

    def validate(self):
        if self.analysis_config:
            self.analysis_config.validate()
        if self.input_file:
            self.input_file.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.template_list:
            self.template_list.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_config is not None:
            result['AnalysisConfig'] = self.analysis_config.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.id is not None:
            result['Id'] = self.id
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.state is not None:
            result['State'] = self.state
        if self.template_list is not None:
            result['TemplateList'] = self.template_list.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnalysisConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig()
            self.analysis_config = temp_model.from_map(m['AnalysisConfig'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InputFile') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TemplateList') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList()
            self.template_list = temp_model.from_map(m['TemplateList'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobList(TeaModel):
    def __init__(self, analysis_job=None):
        self.analysis_job = analysis_job  # type: list[QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob]

    def validate(self):
        if self.analysis_job:
            for k in self.analysis_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyAnalysisJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnalysisJob'] = []
        if self.analysis_job is not None:
            for k in self.analysis_job:
                result['AnalysisJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.analysis_job = []
        if m.get('AnalysisJob') is not None:
            for k in m.get('AnalysisJob'):
                temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob()
                self.analysis_job.append(temp_model.from_map(k))
        return self


class QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryAnalysisJobListResponseBody(TeaModel):
    def __init__(self, analysis_job_list=None, non_exist_analysis_job_ids=None, request_id=None):
        # The IDs of the template analysis jobs.
        self.analysis_job_list = analysis_job_list  # type: QueryAnalysisJobListResponseBodyAnalysisJobList
        # The IDs of the template analysis jobs that do not exist. If all queried job IDs exist, the response does not contain this parameter.
        self.non_exist_analysis_job_ids = non_exist_analysis_job_ids  # type: QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.analysis_job_list:
            self.analysis_job_list.validate()
        if self.non_exist_analysis_job_ids:
            self.non_exist_analysis_job_ids.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_job_list is not None:
            result['AnalysisJobList'] = self.analysis_job_list.to_map()
        if self.non_exist_analysis_job_ids is not None:
            result['NonExistAnalysisJobIds'] = self.non_exist_analysis_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnalysisJobList') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobList()
            self.analysis_job_list = temp_model.from_map(m['AnalysisJobList'])
        if m.get('NonExistAnalysisJobIds') is not None:
            temp_model = QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds()
            self.non_exist_analysis_job_ids = temp_model.from_map(m['NonExistAnalysisJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryAnalysisJobListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryAnalysisJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryAnalysisJobListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryAnalysisJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpDBDeleteJobListRequest(TeaModel):
    def __init__(self, job_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The IDs of the jobs of clearing or deleting a media fingerprint library. You can obtain the job IDs from the response parameters of the [SubmitFpDBDeleteJob](~~209341~~) operation. Separate multiple job IDs with commas (,). If you leave this parameter empty, the system returns the latest 20 jobs that are submitted.
        self.job_ids = job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpDBDeleteJobListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobListFpDBDeleteJob(TeaModel):
    def __init__(self, code=None, creation_time=None, del_type=None, finish_time=None, fp_dbid=None, id=None,
                 message=None, pipeline_id=None, status=None, user_data=None):
        # The error code returned when the job fails. This parameter is not returned if the job is successful.
        self.code = code  # type: str
        # The point in time when the job was created.
        self.creation_time = creation_time  # type: str
        # The operation type.
        self.del_type = del_type  # type: str
        # The point in time when the job was complete.
        self.finish_time = finish_time  # type: str
        # The ID of the media fingerprint library.
        self.fp_dbid = fp_dbid  # type: str
        # The ID of the job.
        self.id = id  # type: str
        # The error message returned when the job fails. This parameter is not returned if the job is successful.
        self.message = message  # type: str
        # The ID of the ApsaraVideo Media Processing (MPS) queue.
        self.pipeline_id = pipeline_id  # type: str
        # The status of the job. Valid values:
        # 
        # *   **Queuing**: The job is waiting in the queue.
        # *   **Analysing**: The job is in progress.
        # *   **Success**: The job is successful.
        # *   **Fail**: The job fails.
        self.status = status  # type: str
        # The custom data.
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobListFpDBDeleteJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.del_type is not None:
            result['DelType'] = self.del_type
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DelType') is not None:
            self.del_type = m.get('DelType')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobList(TeaModel):
    def __init__(self, fp_dbdelete_job=None):
        self.fp_dbdelete_job = fp_dbdelete_job  # type: list[QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobListFpDBDeleteJob]

    def validate(self):
        if self.fp_dbdelete_job:
            for k in self.fp_dbdelete_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpDBDeleteJob'] = []
        if self.fp_dbdelete_job is not None:
            for k in self.fp_dbdelete_job:
                result['FpDBDeleteJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_dbdelete_job = []
        if m.get('FpDBDeleteJob') is not None:
            for k in m.get('FpDBDeleteJob'):
                temp_model = QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobListFpDBDeleteJob()
                self.fp_dbdelete_job.append(temp_model.from_map(k))
        return self


class QueryFpDBDeleteJobListResponseBodyNonExistIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpDBDeleteJobListResponseBodyNonExistIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFpDBDeleteJobListResponseBody(TeaModel):
    def __init__(self, fp_dbdelete_job_list=None, non_exist_ids=None, request_id=None):
        # The jobs of deleting a media fingerprint library. For more information, see the "FpDBDeleteJob" section of the [Data types](https://icms.alibaba-inc.com/content/mps/cc2a58?l=1\&m=16051\&n=23657) topic.
        self.fp_dbdelete_job_list = fp_dbdelete_job_list  # type: QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobList
        # The IDs of the jobs that do not exist. This parameter is not returned if all specified jobs are found.
        self.non_exist_ids = non_exist_ids  # type: QueryFpDBDeleteJobListResponseBodyNonExistIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.fp_dbdelete_job_list:
            self.fp_dbdelete_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super(QueryFpDBDeleteJobListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbdelete_job_list is not None:
            result['FpDBDeleteJobList'] = self.fp_dbdelete_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpDBDeleteJobList') is not None:
            temp_model = QueryFpDBDeleteJobListResponseBodyFpDBDeleteJobList()
            self.fp_dbdelete_job_list = temp_model.from_map(m['FpDBDeleteJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryFpDBDeleteJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryFpDBDeleteJobListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryFpDBDeleteJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryFpDBDeleteJobListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryFpDBDeleteJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpFileDeleteJobListRequest(TeaModel):
    def __init__(self, job_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The IDs of the jobs of deleting media files from a media fingerprint library. You can obtain the job IDs from the response parameters of the [SubmitFpFileDeleteJob](~~209274~~) operation. Separate multiple job IDs with commas (,). If you leave this parameter empty, the system returns the latest 20 jobs that are submitted.
        self.job_ids = job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpFileDeleteJobListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobListFpFileDeleteJob(TeaModel):
    def __init__(self, code=None, creation_time=None, file_ids=None, finish_time=None, fp_dbid=None, id=None,
                 message=None, pipeline_id=None, status=None, user_data=None):
        # The error code returned when the job fails. This parameter is not returned if the job is successful.
        self.code = code  # type: str
        # The point in time when the job was created.
        self.creation_time = creation_time  # type: str
        # The IDs of the files.
        self.file_ids = file_ids  # type: str
        # The point in time when the job was complete.
        self.finish_time = finish_time  # type: str
        # The ID of the media fingerprint library.
        self.fp_dbid = fp_dbid  # type: str
        # The ID of the job.
        self.id = id  # type: str
        # The error message returned when the job fails. This parameter is not returned if the job is successful.
        self.message = message  # type: str
        # The ID of the ApsaraVideo Media Processing (MPS) queue.
        self.pipeline_id = pipeline_id  # type: str
        # The status of the job. Valid values:
        # 
        # *   **Queuing**: The job is waiting in the queue.
        # *   **Analysing**: The job is in progress.
        # *   **Success**: The job is successful.
        # *   **Fail**: The job fails.
        self.status = status  # type: str
        # The custom data.
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobListFpFileDeleteJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.file_ids is not None:
            result['FileIds'] = self.file_ids
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FileIds') is not None:
            self.file_ids = m.get('FileIds')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobList(TeaModel):
    def __init__(self, fp_file_delete_job=None):
        self.fp_file_delete_job = fp_file_delete_job  # type: list[QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobListFpFileDeleteJob]

    def validate(self):
        if self.fp_file_delete_job:
            for k in self.fp_file_delete_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpFileDeleteJob'] = []
        if self.fp_file_delete_job is not None:
            for k in self.fp_file_delete_job:
                result['FpFileDeleteJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_file_delete_job = []
        if m.get('FpFileDeleteJob') is not None:
            for k in m.get('FpFileDeleteJob'):
                temp_model = QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobListFpFileDeleteJob()
                self.fp_file_delete_job.append(temp_model.from_map(k))
        return self


class QueryFpFileDeleteJobListResponseBodyNonExistIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpFileDeleteJobListResponseBodyNonExistIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFpFileDeleteJobListResponseBody(TeaModel):
    def __init__(self, fp_file_delete_job_list=None, non_exist_ids=None, request_id=None):
        # The jobs of deleting media files from a media fingerprint library. For more information, see the "FpFileDeleteJob" section of the [Data types](https://icms.alibaba-inc.com/content/mps/cc2a58?l=1\&m=16051\&n=23657) topic.
        self.fp_file_delete_job_list = fp_file_delete_job_list  # type: QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobList
        # The IDs of the jobs that do not exist.
        self.non_exist_ids = non_exist_ids  # type: QueryFpFileDeleteJobListResponseBodyNonExistIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.fp_file_delete_job_list:
            self.fp_file_delete_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super(QueryFpFileDeleteJobListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_file_delete_job_list is not None:
            result['FpFileDeleteJobList'] = self.fp_file_delete_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpFileDeleteJobList') is not None:
            temp_model = QueryFpFileDeleteJobListResponseBodyFpFileDeleteJobList()
            self.fp_file_delete_job_list = temp_model.from_map(m['FpFileDeleteJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryFpFileDeleteJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryFpFileDeleteJobListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryFpFileDeleteJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryFpFileDeleteJobListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryFpFileDeleteJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpShotJobListRequest(TeaModel):
    def __init__(self, end_of_job_created_time_range=None, job_ids=None, maximum_page_size=None,
                 next_page_token=None, owner_account=None, owner_id=None, pipeline_id=None, resource_owner_account=None,
                 resource_owner_id=None, start_of_job_created_time_range=None, state=None):
        self.end_of_job_created_time_range = end_of_job_created_time_range  # type: str
        # The IDs of the media fingerprint analysis jobs that you want to query. To view the job IDs, log on to the **MPS console (https://mps.console.aliyun.com/overview)**, click **Tasks** in the left-side navigation pane, and then click the **Video DNA** tab on the Tasks page. You can query up to 10 media fingerprint analysis jobs at a time. Separate multiple job IDs with commas (,).
        self.job_ids = job_ids  # type: str
        self.maximum_page_size = maximum_page_size  # type: long
        self.next_page_token = next_page_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.pipeline_id = pipeline_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_of_job_created_time_range = start_of_job_created_time_range  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_job_created_time_range is not None:
            result['EndOfJobCreatedTimeRange'] = self.end_of_job_created_time_range
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_of_job_created_time_range is not None:
            result['StartOfJobCreatedTimeRange'] = self.start_of_job_created_time_range
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndOfJobCreatedTimeRange') is not None:
            self.end_of_job_created_time_range = m.get('EndOfJobCreatedTimeRange')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartOfJobCreatedTimeRange') is not None:
            self.start_of_job_created_time_range = m.get('StartOfJobCreatedTimeRange')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotConfig(TeaModel):
    def __init__(self, fp_dbid=None, primary_key=None, save_type=None):
        # The ID of the media fingerprint library.
        self.fp_dbid = fp_dbid  # type: str
        # The unique primary key of the input video.
        self.primary_key = primary_key  # type: str
        # The storage type. Valid values:
        # 
        # - **nosave**: The fingerprints of the job input are not saved to the media fingerprint library.
        # - **save**: The fingerprints of the job input are saved to the media fingerprint library only if the job input is not duplicated with media content in the media fingerprint library.
        # - **forcesave**: The fingerprints of the job input are forcibly saved to the media fingerprint library.
        self.save_type = save_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.save_type is not None:
            result['SaveType'] = self.save_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('SaveType') is not None:
            self.save_type = m.get('SaveType')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication(TeaModel):
    def __init__(self, duration=None, start=None):
        # The length.
        self.duration = duration  # type: str
        # The start point in time.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput(TeaModel):
    def __init__(self, duration=None, start=None):
        # The length.
        self.duration = duration  # type: str
        # The start point in time.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice(TeaModel):
    def __init__(self, duplication=None, input=None, similarity=None):
        # The start point in time and length of the similar audio clip in the audio file that has similar fingerprints to the input audio in the audio fingerprint library.
        self.duplication = duplication  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication
        # The start point in time and length of the similar audio clip in the input audio.
        self.input = input  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput
        # The overall similarity of the input audio against audio files that have similar fingerprints to the input audio in the audio fingerprint library.
        self.similarity = similarity  # type: str

    def validate(self):
        if self.duplication:
            self.duplication.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication is not None:
            result['Duplication'] = self.duplication.to_map()
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duplication') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication()
            self.duplication = temp_model.from_map(m['Duplication'])
        if m.get('Input') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices(TeaModel):
    def __init__(self, fp_shot_slice=None):
        self.fp_shot_slice = fp_shot_slice  # type: list[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice]

    def validate(self):
        if self.fp_shot_slice:
            for k in self.fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotSlice'] = []
        if self.fp_shot_slice is not None:
            for k in self.fp_shot_slice:
                result['FpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_shot_slice = []
        if m.get('FpShotSlice') is not None:
            for k in m.get('FpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice()
                self.fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot(TeaModel):
    def __init__(self, fp_shot_slices=None, primary_key=None, similarity=None):
        # The array of audio files that have similar fingerprints to the input audio in the audio fingerprint library.
        self.fp_shot_slices = fp_shot_slices  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices
        # The unique primary key of the input video.
        self.primary_key = primary_key  # type: str
        # The overall similarity of the input audio against audio files that have similar fingerprints to the input audio in the audio fingerprint library.
        self.similarity = similarity  # type: str

    def validate(self):
        if self.fp_shot_slices:
            self.fp_shot_slices.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_slices is not None:
            result['FpShotSlices'] = self.fp_shot_slices.to_map()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices()
            self.fp_shot_slices = temp_model.from_map(m['FpShotSlices'])
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShots(TeaModel):
    def __init__(self, fp_shot=None):
        self.fp_shot = fp_shot  # type: list[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot]

    def validate(self):
        if self.fp_shot:
            for k in self.fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShot'] = []
        if self.fp_shot is not None:
            for k in self.fp_shot:
                result['FpShot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_shot = []
        if m.get('FpShot') is not None:
            for k in m.get('FpShot'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot()
                self.fp_shot.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication(TeaModel):
    def __init__(self, duration=None, start=None):
        # The length.
        self.duration = duration  # type: str
        # The start point in time.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput(TeaModel):
    def __init__(self, duration=None, start=None):
        # The length.
        self.duration = duration  # type: str
        # The start point in time.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice(TeaModel):
    def __init__(self, duplication=None, input=None, similarity=None):
        # The start point in time and length of the similar video clip in the video that has similar fingerprints to the input video in the video fingerprint library.
        self.duplication = duplication  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication
        # The start point in time and length of the similar video clip in the input video.
        self.input = input  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput
        # The similarity of the input video clip against the video that has similar fingerprints to the input video in the video fingerprint library.
        self.similarity = similarity  # type: str

    def validate(self):
        if self.duplication:
            self.duplication.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication is not None:
            result['Duplication'] = self.duplication.to_map()
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duplication') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication()
            self.duplication = temp_model.from_map(m['Duplication'])
        if m.get('Input') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices(TeaModel):
    def __init__(self, fp_shot_slice=None):
        self.fp_shot_slice = fp_shot_slice  # type: list[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice]

    def validate(self):
        if self.fp_shot_slice:
            for k in self.fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotSlice'] = []
        if self.fp_shot_slice is not None:
            for k in self.fp_shot_slice:
                result['FpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_shot_slice = []
        if m.get('FpShotSlice') is not None:
            for k in m.get('FpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice()
                self.fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot(TeaModel):
    def __init__(self, fp_shot_slices=None, primary_key=None, similarity=None):
        # The array of videos that have similar fingerprints to the input video in the video fingerprint library.
        self.fp_shot_slices = fp_shot_slices  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices
        # The unique primary key of the input video.
        self.primary_key = primary_key  # type: str
        # The overall similarity of the input video against videos that have similar fingerprints to the input video in the video fingerprint library. The overall similarity is the average value of the similarities of the input video against all similar video clips. If multiple similar video clips exist in the video fingerprint library, the similarities of the input video against multiple similar video clips are returned.
        self.similarity = similarity  # type: str

    def validate(self):
        if self.fp_shot_slices:
            self.fp_shot_slices.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_slices is not None:
            result['FpShotSlices'] = self.fp_shot_slices.to_map()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices()
            self.fp_shot_slices = temp_model.from_map(m['FpShotSlices'])
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShots(TeaModel):
    def __init__(self, fp_shot=None):
        self.fp_shot = fp_shot  # type: list[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot]

    def validate(self):
        if self.fp_shot:
            for k in self.fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShot'] = []
        if self.fp_shot is not None:
            for k in self.fp_shot:
                result['FpShot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_shot = []
        if m.get('FpShot') is not None:
            for k in m.get('FpShot'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot()
                self.fp_shot.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment(TeaModel):
    def __init__(self, duration=None, start=None):
        # The length.
        self.duration = duration  # type: str
        # The start point in time.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice(TeaModel):
    def __init__(self, duplication_text=None, input_fragment=None, input_text=None, similarity=None):
        # The text snippet that has similar fingerprints to the input text in the text fingerprint library.
        self.duplication_text = duplication_text  # type: str
        # The start point in time and length of the similar text snippet in the input text.
        self.input_fragment = input_fragment  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment
        # The input text for text fingerprint analysis.
        self.input_text = input_text  # type: str
        # The similarity of the input text against the text snippet that has similar fingerprints to the input text in the text fingerprint library.
        self.similarity = similarity  # type: str

    def validate(self):
        if self.input_fragment:
            self.input_fragment.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication_text is not None:
            result['DuplicationText'] = self.duplication_text
        if self.input_fragment is not None:
            result['InputFragment'] = self.input_fragment.to_map()
        if self.input_text is not None:
            result['InputText'] = self.input_text
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DuplicationText') is not None:
            self.duplication_text = m.get('DuplicationText')
        if m.get('InputFragment') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment()
            self.input_fragment = temp_model.from_map(m['InputFragment'])
        if m.get('InputText') is not None:
            self.input_text = m.get('InputText')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices(TeaModel):
    def __init__(self, text_fp_shot_slice=None):
        self.text_fp_shot_slice = text_fp_shot_slice  # type: list[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice]

    def validate(self):
        if self.text_fp_shot_slice:
            for k in self.text_fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TextFpShotSlice'] = []
        if self.text_fp_shot_slice is not None:
            for k in self.text_fp_shot_slice:
                result['TextFpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.text_fp_shot_slice = []
        if m.get('TextFpShotSlice') is not None:
            for k in m.get('TextFpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice()
                self.text_fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot(TeaModel):
    def __init__(self, primary_key=None, similarity=None, text_fp_shot_slices=None):
        # The unique primary key of the input text.
        self.primary_key = primary_key  # type: str
        # The similarity of the input text against text snippets that have similar fingerprints to the input text in the text fingerprint library.
        self.similarity = similarity  # type: str
        # The array of text snippets that have similar fingerprints to the input text in the text fingerprint library.
        self.text_fp_shot_slices = text_fp_shot_slices  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices

    def validate(self):
        if self.text_fp_shot_slices:
            self.text_fp_shot_slices.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        if self.text_fp_shot_slices is not None:
            result['TextFpShotSlices'] = self.text_fp_shot_slices.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        if m.get('TextFpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices()
            self.text_fp_shot_slices = temp_model.from_map(m['TextFpShotSlices'])
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShots(TeaModel):
    def __init__(self, text_fp_shot=None):
        self.text_fp_shot = text_fp_shot  # type: list[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot]

    def validate(self):
        if self.text_fp_shot:
            for k in self.text_fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TextFpShot'] = []
        if self.text_fp_shot is not None:
            for k in self.text_fp_shot:
                result['TextFpShot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.text_fp_shot = []
        if m.get('TextFpShot') is not None:
            for k in m.get('TextFpShot'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot()
                self.text_fp_shot.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResult(TeaModel):
    def __init__(self, audio_fp_shots=None, fp_shots=None, text_fp_shots=None):
        # The audio fingerprint analysis results.
        self.audio_fp_shots = audio_fp_shots  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShots
        # The video fingerprint analysis results.
        self.fp_shots = fp_shots  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShots
        # The text fingerprint analysis results.
        self.text_fp_shots = text_fp_shots  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShots

    def validate(self):
        if self.audio_fp_shots:
            self.audio_fp_shots.validate()
        if self.fp_shots:
            self.fp_shots.validate()
        if self.text_fp_shots:
            self.text_fp_shots.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_fp_shots is not None:
            result['AudioFpShots'] = self.audio_fp_shots.to_map()
        if self.fp_shots is not None:
            result['FpShots'] = self.fp_shots.to_map()
        if self.text_fp_shots is not None:
            result['TextFpShots'] = self.text_fp_shots.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFpShots') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShots()
            self.audio_fp_shots = temp_model.from_map(m['AudioFpShots'])
        if m.get('FpShots') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShots()
            self.fp_shots = temp_model.from_map(m['FpShots'])
        if m.get('TextFpShots') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShots()
            self.text_fp_shots = temp_model.from_map(m['TextFpShots'])
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobInputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The OSS bucket in which the job input resides.
        self.bucket = bucket  # type: str
        # The OSS region in which the job input resides.
        self.location = location  # type: str
        # The Object Storage Service (OSS) object that is used as the job input.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJobInputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJob(TeaModel):
    def __init__(self, code=None, creation_time=None, duration=None, file_id=None, finish_time=None,
                 fp_shot_config=None, fp_shot_result=None, id=None, input=None, input_file=None, message=None, pipeline_id=None,
                 state=None, user_data=None):
        # The error code returned when the job fails.
        self.code = code  # type: str
        # The point in time when the job was created.
        self.creation_time = creation_time  # type: str
        self.duration = duration  # type: int
        # The ID of the matched file in the media fingerprint library.
        self.file_id = file_id  # type: str
        # The point in time when the job was complete.
        self.finish_time = finish_time  # type: str
        # The configurations of the job.
        self.fp_shot_config = fp_shot_config  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotConfig
        # The results of the media fingerprint analysis job.
        self.fp_shot_result = fp_shot_result  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResult
        # The ID of the job.
        self.id = id  # type: str
        # The information about the job input.
        self.input = input  # type: str
        # The information about the job input.
        self.input_file = input_file  # type: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobInputFile
        # The error message returned when the job fails. This parameter is not returned if the job is successful.
        self.message = message  # type: str
        # The ID of the ApsaraVideo Media Processing (MPS) queue.
        self.pipeline_id = pipeline_id  # type: str
        # The status of the job. Valid values:
        # 
        # - **Queuing**: The job is waiting in the queue.
        # - **Analysing**: The job is in progress.
        # - **Success**: The job is successful.
        # - **Fail**: The job fails.
        self.state = state  # type: str
        # The custom data.
        self.user_data = user_data  # type: str

    def validate(self):
        if self.fp_shot_config:
            self.fp_shot_config.validate()
        if self.fp_shot_result:
            self.fp_shot_result.validate()
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobListFpShotJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fp_shot_config is not None:
            result['FpShotConfig'] = self.fp_shot_config.to_map()
        if self.fp_shot_result is not None:
            result['FpShotResult'] = self.fp_shot_result.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.input is not None:
            result['Input'] = self.input
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FpShotConfig') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotConfig()
            self.fp_shot_config = temp_model.from_map(m['FpShotConfig'])
        if m.get('FpShotResult') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResult()
            self.fp_shot_result = temp_model.from_map(m['FpShotResult'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('InputFile') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryFpShotJobListResponseBodyFpShotJobList(TeaModel):
    def __init__(self, fp_shot_job=None):
        self.fp_shot_job = fp_shot_job  # type: list[QueryFpShotJobListResponseBodyFpShotJobListFpShotJob]

    def validate(self):
        if self.fp_shot_job:
            for k in self.fp_shot_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyFpShotJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotJob'] = []
        if self.fp_shot_job is not None:
            for k in self.fp_shot_job:
                result['FpShotJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fp_shot_job = []
        if m.get('FpShotJob') is not None:
            for k in m.get('FpShotJob'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJob()
                self.fp_shot_job.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyNonExistIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBodyNonExistIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFpShotJobListResponseBody(TeaModel):
    def __init__(self, fp_shot_job_list=None, next_page_token=None, non_exist_ids=None, request_id=None):
        # The array of media fingerprint analysis jobs.
        self.fp_shot_job_list = fp_shot_job_list  # type: QueryFpShotJobListResponseBodyFpShotJobList
        self.next_page_token = next_page_token  # type: str
        # The job IDs that do not exist. This parameter is not returned if all specified jobs are found.
        self.non_exist_ids = non_exist_ids  # type: QueryFpShotJobListResponseBodyNonExistIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.fp_shot_job_list:
            self.fp_shot_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_job_list is not None:
            result['FpShotJobList'] = self.fp_shot_job_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FpShotJobList') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobList()
            self.fp_shot_job_list = temp_model.from_map(m['FpShotJobList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NonExistIds') is not None:
            temp_model = QueryFpShotJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryFpShotJobListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryFpShotJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryFpShotJobListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryFpShotJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryIProductionJobRequest(TeaModel):
    def __init__(self, job_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.job_id = job_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryIProductionJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryIProductionJobResponseBody(TeaModel):
    def __init__(self, function_name=None, input=None, job_id=None, job_params=None, output=None, pipeline_id=None,
                 request_id=None, result=None, state=None, user_data=None):
        self.function_name = function_name  # type: str
        self.input = input  # type: str
        self.job_id = job_id  # type: str
        self.job_params = job_params  # type: str
        self.output = output  # type: str
        self.pipeline_id = pipeline_id  # type: str
        self.request_id = request_id  # type: str
        self.result = result  # type: str
        self.state = state  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryIProductionJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.input is not None:
            result['Input'] = self.input
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.output is not None:
            result['Output'] = self.output
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryIProductionJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryIProductionJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryIProductionJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryIProductionJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryJobListRequest(TeaModel):
    def __init__(self, include_pipeline_info=None, job_ids=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.include_pipeline_info = include_pipeline_info  # type: bool
        # The IDs of transcoding jobs. Separate multiple IDs with commas (,). You can query a maximum of 10 transcoding jobs at a time. You can log on to the [ApsaraVideo Media Processing (MPS) console](https://mps.console.aliyun.com/overview) and click **Tasks** in the left-side navigation pane to obtain job IDs. Alternatively, you can obtain job IDs from the response to the [SubmitJobs](~~29226~~) operation.
        # 
        # >  If you do not set the JobIds parameter, the `InvalidParameter` error code is returned.
        self.job_ids = job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.include_pipeline_info is not None:
            result['IncludePipelineInfo'] = self.include_pipeline_info
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IncludePipelineInfo') is not None:
            self.include_pipeline_info = m.get('IncludePipelineInfo')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryJobListResponseBodyJobListJobInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The name of the OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The ID of the OSS region in which the input file resides.
        self.location = location  # type: str
        # The name of the OSS object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryJobListResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(self, error_code=None, error_message=None, message_id=None):
        # The error code returned if the job fails. This parameter is not returned if the job is successful.
        self.error_code = error_code  # type: str
        # The error message that is returned if the job fails. This parameter is not returned if the job is successful.
        self.error_message = error_message  # type: str
        # The ID of the success message.
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobMNSMessageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class QueryJobListResponseBodyJobListJobOutputAudioVolume(TeaModel):
    def __init__(self, level=None, method=None):
        # The volume adjustment range. Default value: **-20db**.
        self.level = level  # type: str
        # The volume adjustment method. Valid values:
        # 
        # *   **auto**: The volume is automatically adjusted.
        # *   **dynamic**: The volume is dynamically adjusted.
        # *   **linear**: The volume is linearly adjusted.
        self.method = method  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputAudioVolume, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class QueryJobListResponseBodyJobListJobOutputAudio(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, qscale=None, samplerate=None,
                 volume=None):
        # The audio bitrate of the output file.
        # 
        # *   Unit: Kbit/s.
        # *   Default value: **128**.
        self.bitrate = bitrate  # type: str
        # The number of sound channels.
        # 
        # *   Valid values: 1, 2, 3, 4, 5, 6, 7, and 8.
        # *   Default value: **2**.
        self.channels = channels  # type: str
        # The audio encoding and decoding format.
        # 
        # *   Valid values: aac, mp3, vorbis, and flac.
        # *   Default value: **aac**.
        self.codec = codec  # type: str
        # The codec profile of the audio. Valid values when the Codec parameter is set to aac: aaclow, aache, aachev2, aacld, and aaceld.
        self.profile = profile  # type: str
        # The level of quality control on the audio.
        self.qscale = qscale  # type: str
        # The sampling rate.
        # 
        # *   Valid values: 22050, 32000, 44100, 48000, and 96000.
        # *   Unit: Hz
        # *   Default value: 44100.
        # 
        # >  If the video container format is FLV and the audio codec is MP3, you cannot set this parameter to 32000, 48000, or 96000. If the audio codec is MP3, you cannot set this parameter to 96000.
        self.samplerate = samplerate  # type: str
        # The volume configuration.
        self.volume = volume  # type: QueryJobListResponseBodyJobListJobOutputAudioVolume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputAudio, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class QueryJobListResponseBodyJobListJobOutputClipTimeSpan(TeaModel):
    def __init__(self, duration=None, seek=None):
        # The duration of the clip.
        # 
        # *   Format: hh:mm:ss\[.SSS].
        # *   Example: 01:00:59.999.
        # 
        # Or
        # 
        # *   Format: sssss\[.SSS].
        # *   Example: 32000.23.
        self.duration = duration  # type: str
        # The time when the clip starts.
        # 
        # *   Format: hh:mm:ss\[.SSS].
        # *   Example: 01:59:59.999.
        # 
        # Or
        # 
        # *   Format: sssss\[.SSS].
        # *   Example: 32000.23.
        self.seek = seek  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputClipTimeSpan, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.seek is not None:
            result['Seek'] = self.seek
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        return self


class QueryJobListResponseBodyJobListJobOutputClip(TeaModel):
    def __init__(self, time_span=None):
        # The time span of the clip.
        self.time_span = time_span  # type: QueryJobListResponseBodyJobListJobOutputClipTimeSpan

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputClip, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class QueryJobListResponseBodyJobListJobOutputContainer(TeaModel):
    def __init__(self, format=None):
        # The container format.
        # 
        # *   Default value: mp4.
        # *   Video formats include FLV, MP4, HLS (M3U8 + TS), and MPEG-DASH (MPD + fMP4)
        # *   Audio formats include MP3, MP4, Ogg, FLAC, and M4A.
        # *   Image formats include GIF and WebP. If the container format is GIF, the video codec must be set to GIF.
        # *   If the container format is WebP, the video codec must be set to WebP.
        # *   If the container format is FLV, the video codec cannot be set to H.265.
        self.format = format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputContainer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryJobListResponseBodyJobListJobOutputEncryption(TeaModel):
    def __init__(self, id=None, key=None, key_type=None, key_uri=None, skip_cnt=None, type=None):
        # The encryption ID.
        self.id = id  # type: str
        # The key that is used to encrypt the video.
        self.key = key  # type: str
        # The key encryption method. Valid values: Base64 and KMS.
        # 
        # >  For example, if the key is `encryptionkey128`, the value can be `Base64("encryptionkey128")` or `KMS(Base64("encryptionkey128")`, depending on the encryption method used.
        self.key_type = key_type  # type: str
        # The URL that is used to request the key. The URL is Base64-encoded.
        self.key_uri = key_uri  # type: str
        # The number of unencrypted frames at the beginning of the video. Leaving these frames unencrypted enables video playback to quickly start.
        self.skip_cnt = skip_cnt  # type: str
        # The encryption type. Valid value: **hls-aes-128**.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputEncryption, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupportTS(TeaModel):
    def __init__(self, md_5support=None, size_support=None):
        # Indicates whether to support the output of the md5 value of the TS file in the M3U8 file. Valid values:
        # 
        # *   **true**: supported.
        # *   **false**: not supported.
        self.md_5support = md_5support  # type: bool
        # Indicates whether to support the output of the size of the TS file in the M3U8 file. Valid values:
        # 
        # *   **true**: supported.
        # *   **false**: not supported.
        self.size_support = size_support  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupportTS, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        return self


class QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupport(TeaModel):
    def __init__(self, ts=None):
        # The non-standard support configuration for M3U8 about TS files. The value must be a JSON object. For more information, see [Parameter details](~~29253~~).
        self.ts = ts  # type: QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupportTS

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupport, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class QueryJobListResponseBodyJobListJobOutputMergeListMerge(TeaModel):
    def __init__(self, duration=None, merge_url=None, role_arn=None, start=None):
        # The duration of the clip.
        # 
        # *   Valid formats: hh:mm:ss\[.SSS] and sssss\[.SSS].
        # *   Examples: 01:59:59.999 and 32000.23.
        self.duration = duration  # type: str
        # The OSS URL of the clip.
        # 
        # *   Example: `http://example-bucket-.oss-cn-hangzhou.aliyuncs.com/example-object.flv`.
        # *   The object must be URL-encoded by using the UTF-8 standard. For more information, see [URL encoding](~~423796~~).
        self.merge_url = merge_url  # type: str
        # The Alibaba Cloud Resource Name (ARN) of the role used for proxy authorization.
        self.role_arn = role_arn  # type: str
        # The start point in time of the clip.
        # 
        # *   Valid formats: hh:mm:ss\[.SSS] and sssss\[.SSS].
        # *   Examples: 01:59:59.999 and 32000.23.
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputMergeListMerge, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class QueryJobListResponseBodyJobListJobOutputMergeList(TeaModel):
    def __init__(self, merge=None):
        self.merge = merge  # type: list[QueryJobListResponseBodyJobListJobOutputMergeListMerge]

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputMergeList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = QueryJobListResponseBodyJobListJobOutputMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputMultiSpeedInfo(TeaModel):
    def __init__(self, code=None, downgrade_policy=None, duration=None, enable=None, message=None, real_speed=None,
                 setting_speed=None, time_cost=None):
        self.code = code  # type: str
        self.downgrade_policy = downgrade_policy  # type: str
        self.duration = duration  # type: float
        self.enable = enable  # type: str
        self.message = message  # type: str
        self.real_speed = real_speed  # type: float
        self.setting_speed = setting_speed  # type: int
        self.time_cost = time_cost  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputMultiSpeedInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.downgrade_policy is not None:
            result['DowngradePolicy'] = self.downgrade_policy
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.message is not None:
            result['Message'] = self.message
        if self.real_speed is not None:
            result['RealSpeed'] = self.real_speed
        if self.setting_speed is not None:
            result['SettingSpeed'] = self.setting_speed
        if self.time_cost is not None:
            result['TimeCost'] = self.time_cost
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DowngradePolicy') is not None:
            self.downgrade_policy = m.get('DowngradePolicy')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RealSpeed') is not None:
            self.real_speed = m.get('RealSpeed')
        if m.get('SettingSpeed') is not None:
            self.setting_speed = m.get('SettingSpeed')
        if m.get('TimeCost') is not None:
            self.time_cost = m.get('TimeCost')
        return self


class QueryJobListResponseBodyJobListJobOutputMuxConfigGif(TeaModel):
    def __init__(self, dither_mode=None, final_delay=None, is_custom_palette=None, loop=None):
        # The color dithering algorithm of the palette. Valid values: sierra and bayer.
        self.dither_mode = dither_mode  # type: str
        # The duration for which the final frame is paused. Unit: centiseconds.
        self.final_delay = final_delay  # type: str
        # Indicates whether the custom palette was used. Valid values:
        # 
        # - **true**: custom.
        # - **false**: non-custom.
        self.is_custom_palette = is_custom_palette  # type: str
        # The loop count.
        self.loop = loop  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputMuxConfigGif, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryJobListResponseBodyJobListJobOutputMuxConfigSegment(TeaModel):
    def __init__(self, duration=None):
        # The length of the segment. Unit: seconds.
        self.duration = duration  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputMuxConfigSegment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryJobListResponseBodyJobListJobOutputMuxConfigWebp(TeaModel):
    def __init__(self, loop=None):
        # The loop count.
        self.loop = loop  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputMuxConfigWebp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryJobListResponseBodyJobListJobOutputMuxConfig(TeaModel):
    def __init__(self, gif=None, segment=None, webp=None):
        # The transmuxing configuration for GIF.
        self.gif = gif  # type: QueryJobListResponseBodyJobListJobOutputMuxConfigGif
        # The segment configurations. The value is a JSON object.
        self.segment = segment  # type: QueryJobListResponseBodyJobListJobOutputMuxConfigSegment
        # The transmuxing configuration for WebP.
        self.webp = webp  # type: QueryJobListResponseBodyJobListJobOutputMuxConfigWebp

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()
        if self.webp:
            self.webp.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputMuxConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        if self.webp is not None:
            result['Webp'] = self.webp.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        if m.get('Webp') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMuxConfigWebp()
            self.webp = temp_model.from_map(m['Webp'])
        return self


class QueryJobListResponseBodyJobListJobOutputOpeningListOpening(TeaModel):
    def __init__(self, height=None, start=None, width=None, open_url=None):
        # The height of the opening part.
        # 
        # *   Valid values: values in the range of (0, 4096), -1, and full.
        # *   A value of -1 indicates that the height of the source of the opening part is retained.
        # *   A value of full indicates that the height of the main part is used for the opening part.
        # *   Default value: **-1**.
        self.height = height  # type: str
        # The amount of time after which the opening part is played.
        # 
        # *   The amount of time after which the opening part is played. The value starts from 0.
        # *   Unit: seconds.
        # *   Default value: **0**.
        self.start = start  # type: str
        # The width of the opening part.
        # 
        # *   Valid values: values in the range of (0, 4096), -1, and full.
        # *   A value of -1 indicates that the width of the source of the opening part is retained.
        # *   A value of full indicates that the width of the main part is used for the opening part.
        # *   Default value: **-1**.
        self.width = width  # type: str
        # The OSS URL of the opening part of the video.
        self.open_url = open_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputOpeningListOpening, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height is not None:
            result['Height'] = self.height
        if self.start is not None:
            result['Start'] = self.start
        if self.width is not None:
            result['Width'] = self.width
        if self.open_url is not None:
            result['openUrl'] = self.open_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('openUrl') is not None:
            self.open_url = m.get('openUrl')
        return self


class QueryJobListResponseBodyJobListJobOutputOpeningList(TeaModel):
    def __init__(self, opening=None):
        self.opening = opening  # type: list[QueryJobListResponseBodyJobListJobOutputOpeningListOpening]

    def validate(self):
        if self.opening:
            for k in self.opening:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputOpeningList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Opening'] = []
        if self.opening is not None:
            for k in self.opening:
                result['Opening'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.opening = []
        if m.get('Opening') is not None:
            for k in m.get('Opening'):
                temp_model = QueryJobListResponseBodyJobListJobOutputOpeningListOpening()
                self.opening.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None, role_arn=None):
        # The OSS bucket in which the output file is stored.
        self.bucket = bucket  # type: str
        # The ID of the OSS region in which the output file resides.
        self.location = location  # type: str
        # The name of the OSS object of the output file.
        self.object = object  # type: str
        # The ARN of the role used for proxy authorization.
        self.role_arn = role_arn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitle(TeaModel):
    def __init__(self, map=None, message=None, out_subtitle_file=None, success=None):
        # The video track. Format: `0:{stream}:{stream sequence number}`, that is, `0:v:{video_index}`. The value of stream is v, which indicates an audio stream of a video. The sequence number is the index of the audio stream in the list and starts from 0.
        self.map = map  # type: str
        # The error message returned if the job fails to be created. This parameter is not returned if the job is created.
        self.message = message  # type: str
        # The details of the output file.
        self.out_subtitle_file = out_subtitle_file  # type: QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile
        # Indicates whether the job succeeded. Valid values:
        # 
        # *   **true**: succeeded.
        # *   **fasle**: failed.
        self.success = success  # type: bool

    def validate(self):
        if self.out_subtitle_file:
            self.out_subtitle_file.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitle, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        if self.message is not None:
            result['Message'] = self.message
        if self.out_subtitle_file is not None:
            result['OutSubtitleFile'] = self.out_subtitle_file.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OutSubtitleFile') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile()
            self.out_subtitle_file = temp_model.from_map(m['OutSubtitleFile'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryJobListResponseBodyJobListJobOutputOutSubtitleList(TeaModel):
    def __init__(self, out_subtitle=None):
        self.out_subtitle = out_subtitle  # type: list[QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitle]

    def validate(self):
        if self.out_subtitle:
            for k in self.out_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputOutSubtitleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OutSubtitle'] = []
        if self.out_subtitle is not None:
            for k in self.out_subtitle:
                result['OutSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.out_subtitle = []
        if m.get('OutSubtitle') is not None:
            for k in m.get('OutSubtitle'):
                temp_model = QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitle()
                self.out_subtitle.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputOutputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None, role_arn=None):
        # The OSS bucket in which the output file is stored.
        self.bucket = bucket  # type: str
        # The ID of the OSS region in which the output file resides.
        self.location = location  # type: str
        # The name of the OSS object of the output file.
        self.object = object  # type: str
        # The ARN of the role used for proxy authorization.
        self.role_arn = role_arn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputOutputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesFormat(TeaModel):
    def __init__(self, bitrate=None, duration=None, format_long_name=None, format_name=None, num_programs=None,
                 num_streams=None, size=None, start_time=None):
        # The total bitrate.
        self.bitrate = bitrate  # type: str
        # The total duration.
        self.duration = duration  # type: str
        # The full name of the container format.
        self.format_long_name = format_long_name  # type: str
        # The short name of the container format. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format_name = format_name  # type: str
        # The total number of program streams.
        self.num_programs = num_programs  # type: str
        # The total number of media streams.
        self.num_streams = num_streams  # type: str
        # The size of the file.
        self.size = size  # type: str
        # The start time.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogosSourceLogo(TeaModel):
    def __init__(self, source=None):
        # The keywords.
        self.source = source  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogosSourceLogo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogos(TeaModel):
    def __init__(self, source_logo=None):
        self.source_logo = source_logo  # type: list[QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogosSourceLogo]

    def validate(self):
        if self.source_logo:
            for k in self.source_logo:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SourceLogo'] = []
        if self.source_logo is not None:
            for k in self.source_logo:
                result['SourceLogo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.source_logo = []
        if m.get('SourceLogo') is not None:
            for k in m.get('SourceLogo'):
                temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogosSourceLogo()
                self.source_logo.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 num_frames=None, sample_fmt=None, samplerate=None, start_time=None, timebase=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The output layout of the sound channels.
        self.channel_layout = channel_layout  # type: str
        # The number of sound channels.
        self.channels = channels  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The sequence number of the audio stream. The value indicates the position of the audio stream in all audio streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg language definition](https://www.ffmpeg.org/ffmpeg-all.html#Metadata) and [ISO 639](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes).
        self.lang = lang  # type: str
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The sampling format.
        self.sample_fmt = sample_fmt  # type: str
        # The sampling rate.
        self.samplerate = samplerate  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(self, audio_stream=None):
        self.audio_stream = audio_stream  # type: list[QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream]

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(self, index=None, lang=None):
        # The sequence number of the subtitle stream. 
        # 
        # This parameter indicates the position of the subtitle stream in all subtitle streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg language definition](https://www.ffmpeg.org/ffmpeg-all.html#Metadata) and [ISO 639](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes).
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(self, subtitle_stream=None):
        self.subtitle_stream = subtitle_stream  # type: list[QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream]

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(self, avg_bitrate=None, cost_bandwidth=None, preload_time=None):
        # The average bitrate.
        self.avg_bitrate = avg_bitrate  # type: str
        # The maximum bandwidth that was consumed.
        self.cost_bandwidth = cost_bandwidth  # type: str
        # The amount of preload time.
        self.preload_time = preload_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(self, avg_fps=None, bitrate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, network_cost=None, num_frames=None, pix_fmt=None, profile=None,
                 sar=None, start_time=None, timebase=None, width=None, bits_per_raw_sample=None, color_primaries=None,
                 color_transfer=None):
        # The average frame rate of the video stream.
        self.avg_fps = avg_fps  # type: str
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The display aspect ratio (DAR).
        self.dar = dar  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The frame rate.
        self.fps = fps  # type: str
        # Indicates whether the video stream contains bidirectional frames (B-frames).
        self.has_bframes = has_bframes  # type: str
        # The latter number in the video resolution. The number indicates the video height.
        self.height = height  # type: str
        # The sequence number of the video stream. The value indicates the position of the video stream in all video streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg language definition](https://www.ffmpeg.org/ffmpeg-all.html#Metadata) and [ISO 639](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes).
        self.lang = lang  # type: str
        # The codec level.
        self.level = level  # type: str
        # The network bandwidth consumption.
        self.network_cost = network_cost  # type: QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The pixel format of the video stream.
        self.pix_fmt = pix_fmt  # type: str
        # The codec profile.
        self.profile = profile  # type: str
        # The sample aspect ratio (SAR) of the video stream.
        self.sar = sar  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base of the video stream.
        self.timebase = timebase  # type: str
        # The former number in the video resolution. The number indicates the video width.
        self.width = width  # type: str
        # The number of binary bits used by each sample or pixel.
        self.bits_per_raw_sample = bits_per_raw_sample  # type: str
        # The primary colors.
        self.color_primaries = color_primaries  # type: str
        # The color transfer configuration.
        self.color_transfer = color_transfer  # type: str

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        if self.bits_per_raw_sample is not None:
            result['bitsPerRawSample'] = self.bits_per_raw_sample
        if self.color_primaries is not None:
            result['colorPrimaries'] = self.color_primaries
        if self.color_transfer is not None:
            result['colorTransfer'] = self.color_transfer
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NetworkCost') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('bitsPerRawSample') is not None:
            self.bits_per_raw_sample = m.get('bitsPerRawSample')
        if m.get('colorPrimaries') is not None:
            self.color_primaries = m.get('colorPrimaries')
        if m.get('colorTransfer') is not None:
            self.color_transfer = m.get('colorTransfer')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(self, video_stream=None):
        self.video_stream = video_stream  # type: list[QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream]

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreams(TeaModel):
    def __init__(self, audio_stream_list=None, subtitle_stream_list=None, video_stream_list=None):
        # The list of audio streams.
        self.audio_stream_list = audio_stream_list  # type: QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList
        # The list of subtitle streams.
        self.subtitle_stream_list = subtitle_stream_list  # type: QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList
        # The list of video streams.
        self.video_stream_list = video_stream_list  # type: QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList

    def validate(self):
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()
        if self.video_stream_list:
            self.video_stream_list.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputPropertiesStreams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        if m.get('VideoStreamList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        return self


class QueryJobListResponseBodyJobListJobOutputProperties(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_format=None, file_size=None, format=None, fps=None,
                 height=None, source_logos=None, streams=None, width=None):
        # The bitrate of the video.
        self.bitrate = bitrate  # type: str
        # The duration of the video.
        self.duration = duration  # type: str
        # The format of the video.
        self.file_format = file_format  # type: str
        # The size of the file.
        self.file_size = file_size  # type: str
        # The format information.
        self.format = format  # type: QueryJobListResponseBodyJobListJobOutputPropertiesFormat
        # The frame rate of the video.
        self.fps = fps  # type: str
        # The length of the video.
        self.height = height  # type: str
        # The non-engine layer keywords.
        self.source_logos = source_logos  # type: QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogos
        # The stream information.
        self.streams = streams  # type: QueryJobListResponseBodyJobListJobOutputPropertiesStreams
        # The width of the video.
        self.width = width  # type: str

    def validate(self):
        if self.format:
            self.format.validate()
        if self.source_logos:
            self.source_logos.validate()
        if self.streams:
            self.streams.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputProperties, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.source_logos is not None:
            result['SourceLogos'] = self.source_logos.to_map()
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('Format') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('SourceLogos') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogos()
            self.source_logos = temp_model.from_map(m['SourceLogos'])
        if m.get('Streams') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The ID of the OSS region in which the input file resides.
        self.location = location  # type: str
        # The name of the OSS object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(self, char_enc=None, font_name=None, input=None):
        # The character set used by the external subtitle. 
        # 
        # - Valid values: UTF-8, GBK, BIG5, and auto.
        # - Default value: **auto**.
        # 
        # >  If you set this parameter to auto, the detected character set may not be the actual character set. We recommend that you set this parameter to another value.
        self.char_enc = char_enc  # type: str
        # The font of the hard subtitles converted from external subtitles. Default value: SimSum. For more information, see [Fonts](https://www.alibabacloud.com/help/en/apsaravideo-for-media-processing/latest/font-name).
        self.font_name = font_name  # type: str
        # The input subtitle file. 
        # 
        # - Files in the SRT or ASS format are supported. For more information, see the part about input parameters in [Parameter details](https://www.alibabacloud.com/help/en/apsaravideo-for-media-processing/latest/parameter-details).
        # - Example: `{“Bucket”:”example-bucket”,“Location”:”oss-cn-hangzhou”,“Object”:”example.srt”}`.
        self.input = input  # type: QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(self, ext_subtitle=None):
        self.ext_subtitle = ext_subtitle  # type: list[QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle]

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(self, map=None):
        # The audio track. Format: `0:{stream}:{stream sequence number}`, that is, `0:a:{audio_index}`. The value of stream is a, which indicates an audio stream. The sequence number is the index of the audio stream in the list and starts from 0.
        self.map = map  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleList(TeaModel):
    def __init__(self, subtitle=None):
        self.subtitle = subtitle  # type: list[QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle]

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfig(TeaModel):
    def __init__(self, ext_subtitle_list=None, subtitle_list=None):
        # The list of external subtitles.
        self.ext_subtitle_list = ext_subtitle_list  # type: QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList
        # The list of subtitles.
        self.subtitle_list = subtitle_list  # type: QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleList

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputSubtitleConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class QueryJobListResponseBodyJobListJobOutputSuperReso(TeaModel):
    def __init__(self, is_half_sample=None):
        # Indicates whether to obtain parameters related to the sampling rate. Valid values:
        # 
        # - **true**: The parameters are obtained.
        # - **false**: The parameters are not obtained.
        self.is_half_sample = is_half_sample  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputSuperReso, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class QueryJobListResponseBodyJobListJobOutputTailSlateListTailSlate(TeaModel):
    def __init__(self, bg_color=None, blend_duration=None, height=None, is_merge_audio=None, start=None,
                 tail_url=None, width=None):
        # The color of the bars that are added to the ending part if the size of the ending part is smaller than that of the main part. Default value: White. For more information, see [Background colors](https://www.alibabacloud.com/help/en/apsaravideo-for-media-processing/latest/parameter-details).
        self.bg_color = bg_color  # type: str
        # The amount of time between the end of the main part and the beginning of the ending part. During the video part transition, the last frame of the main part fades out, and the first frame of the ending part fades in. Unit: seconds. Default value: 0.
        self.blend_duration = blend_duration  # type: str
        # The height of the ending part. 
        # 
        # - Valid values: values in the range of (0, 4096), -1, and full.
        # - A value of -1 indicates that the height of the source of the ending part is retained.
        # - A value of full indicates that the height of the main part is used for the ending part.
        # - Default value: **-1**.
        self.height = height  # type: str
        # Indicates whether to merge the audio content of the ending part. Valid values:
        # 
        # - **true**: yes.
        # - **false**: no.
        self.is_merge_audio = is_merge_audio  # type: bool
        # The time at which the ending part is played.
        self.start = start  # type: str
        # The OSS URL of the ending part.
        self.tail_url = tail_url  # type: str
        # The width of the ending part. Valid values: values in the range of (0, 4096), -1, and full.  
        # 
        # - A value of -1 indicates that the width of the source of the ending part is retained.
        # - A value of full indicates that the width of the main part is used for the ending part.
        # - Default value: **-1**.
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputTailSlateListTailSlate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.blend_duration is not None:
            result['BlendDuration'] = self.blend_duration
        if self.height is not None:
            result['Height'] = self.height
        if self.is_merge_audio is not None:
            result['IsMergeAudio'] = self.is_merge_audio
        if self.start is not None:
            result['Start'] = self.start
        if self.tail_url is not None:
            result['TailUrl'] = self.tail_url
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('BlendDuration') is not None:
            self.blend_duration = m.get('BlendDuration')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('IsMergeAudio') is not None:
            self.is_merge_audio = m.get('IsMergeAudio')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('TailUrl') is not None:
            self.tail_url = m.get('TailUrl')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryJobListResponseBodyJobListJobOutputTailSlateList(TeaModel):
    def __init__(self, tail_slate=None):
        self.tail_slate = tail_slate  # type: list[QueryJobListResponseBodyJobListJobOutputTailSlateListTailSlate]

    def validate(self):
        if self.tail_slate:
            for k in self.tail_slate:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputTailSlateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TailSlate'] = []
        if self.tail_slate is not None:
            for k in self.tail_slate:
                result['TailSlate'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tail_slate = []
        if m.get('TailSlate') is not None:
            for k in m.get('TailSlate'):
                temp_model = QueryJobListResponseBodyJobListJobOutputTailSlateListTailSlate()
                self.tail_slate.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputTransConfig(TeaModel):
    def __init__(self, adj_dar_method=None, is_check_audio_bitrate=None, is_check_audio_bitrate_fail=None,
                 is_check_reso=None, is_check_reso_fail=None, is_check_video_bitrate=None, is_check_video_bitrate_fail=None,
                 trans_mode=None):
        # The method of resolution adjustment. Default value: **none**. Valid values: rescale, crop, pad, and none.
        self.adj_dar_method = adj_dar_method  # type: str
        # Indicates whether the audio bitrate is checked.
        # 
        # *   If the output audio bitrate is higher than the input audio bitrate, the system considers that the output bitrate equals the input bitrate.
        # *   **true**: The audio bitrate is checked.
        # *   **false**: The audio bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_audio_bitrate = is_check_audio_bitrate  # type: str
        # Indicates whether the audio bitrate is checked. If the output audio bitrate is higher than the audio bitrate of the media source, a transcoding failure is returned without transcoding the media. This value has a higher priority than IsCheckAudioBitrate.
        # 
        # *   **true**: The audio bitrate is checked.
        # *   **false**: The audio bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail  # type: str
        # Indicates whether the resolution is checked.
        # 
        # *   If the output resolution is higher than the input resolution based on the width or height, the system considers that the output resolution equals the input resolution.
        # *   **true**: The resolution is checked.
        # *   **false**: The resolution is not checked.
        # *   Default value: **false**.
        self.is_check_reso = is_check_reso  # type: str
        # Indicates whether the resolution is checked.
        # 
        # *   If the output resolution is higher than the input resolution based on the width or height, a transcoding failure is returned.
        # *   **true**: The resolution is checked.
        # *   **false**: The resolution is not checked.
        # *   Default value: **false**.
        self.is_check_reso_fail = is_check_reso_fail  # type: str
        # Indicates whether the video bitrate is checked.
        # 
        # *   If the output bitrate is higher than the input bitrate, the system considers that the output bitrate equals the input bitrate.
        # *   **true**: The video bitrate is checked.
        # *   **false**: The video bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_video_bitrate = is_check_video_bitrate  # type: str
        # Indicates whether the video bitrate is checked. If the bitrate of the output video is higher than that of the input video, a transcoding failure is returned without transcoding the video. This parameter takes precedence over the IsCheckVideoBitrate parameter.
        # 
        # *   **true**: The video bitrate is checked.
        # *   **false**: The video bitrate is not checked.
        # *   Default value: **false**.
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail  # type: str
        # The transcoding mode.
        # 
        # *   Valid values: onepass, twopass, and CBR.
        # *   Default value: **onepass**.
        self.trans_mode = trans_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputTransConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class QueryJobListResponseBodyJobListJobOutputVideoBitrateBnd(TeaModel):
    def __init__(self, max=None, min=None):
        # The maximum bitrate.
        self.max = max  # type: str
        # The minimum bitrate.
        self.min = min  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputVideoBitrateBnd, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryJobListResponseBodyJobListJobOutputVideo(TeaModel):
    def __init__(self, bitrate=None, bitrate_bnd=None, bufsize=None, codec=None, crf=None, crop=None, degrain=None,
                 fps=None, gop=None, height=None, max_fps=None, maxrate=None, pad=None, pix_fmt=None, preset=None,
                 profile=None, qscale=None, reso_priority=None, scan_mode=None, width=None):
        # The average bitrate of the video. Unit: Kbit/s.
        self.bitrate = bitrate  # type: str
        # The average bitrate range of the video.
        self.bitrate_bnd = bitrate_bnd  # type: QueryJobListResponseBodyJobListJobOutputVideoBitrateBnd
        # The size of the buffer.
        # 
        # *   Unit: KB.
        # *   Default value: **6000**.
        self.bufsize = bufsize  # type: str
        # The codec.
        # 
        # *   Valid values: H.264 and H.265.
        # *   Default value: H.264.
        self.codec = codec  # type: str
        # The constant rate factor.
        # 
        # *   Default value when the Codec parameter is set to H.264: **23**. Default value when the Codec parameter is set to H.265: **26**.
        # *   If this parameter is returned, the setting of the Bitrate parameter is invalid.
        self.crf = crf  # type: str
        # The crop mode. The following two modes are supported:
        # 
        # *   **border**: automatically detects and removes black bars.
        # *   A value in the format of width:height:left:top: crops the video image based on the custom setting.
        self.crop = crop  # type: str
        # The level of the independent denoising algorithm.
        self.degrain = degrain  # type: str
        # The frame rate.
        # 
        # *   Unit: frames per second.
        # *   The value is 60 if the frame rate of the input file exceeds 60.
        # *   By default, the frame rate of the input file is used.
        self.fps = fps  # type: str
        # The maximum interval between keyframes or the maximum number of frames in a frame group. Unit: seconds.
        # 
        # *   Default value: **250**.
        # *   If you specified the maximum number of frames, the value does not contain a unit.
        self.gop = gop  # type: str
        # The height of the video.
        # 
        # *   Unit: pixels.
        # *   By default, the original video height is used.
        self.height = height  # type: str
        # The maximum frame rate.
        self.max_fps = max_fps  # type: str
        # The maximum bitrate of the video. Unit: Kbit/s.
        self.maxrate = maxrate  # type: str
        # The black bars to be added to the video.
        # 
        # *   Unit: pixels.
        # *   Format: width:height:left:top.
        self.pad = pad  # type: str
        # The pixel format. Standard pixel formats such as yuv420p and yuvj420p are supported.
        self.pix_fmt = pix_fmt  # type: str
        # The preset video algorithm. Default value: **medium**. Valid values:
        # 
        # *   **veryfast**\
        # *   **fast**\
        # *   **medium**\
        # *   **slow**\
        # *   **slower**\
        self.preset = preset  # type: str
        # The codec profile. Valid values: baseline, main, and high.
        # 
        # >  If multiple definitions exist, we recommend that you set this parameter to baseline for the lowest definition to ensure normal playback on low-end devices. Set this parameter to main or high for other definitions.
        # 
        # *   **baseline**: applicable to mobile devices.
        # *   **main**: applicable to standard-definition devices.
        # *   **high**: applicable to high-definition devices.
        # *   Default value: **high**.
        self.profile = profile  # type: str
        # The level of quality control on the video.
        self.qscale = qscale  # type: str
        # The priority of the resource.
        self.reso_priority = reso_priority  # type: str
        # The scan mode. Valid values:
        # 
        # *   **interlaced**: An interlaced scan is performed.
        # *   **progressive**: A progressive scan is performed.
        # *   **auto**: A scan is performed based on the video source.
        self.scan_mode = scan_mode  # type: str
        # The width of the video.
        # 
        # *   Unit: pixels.
        # *   By default, the original width of the video is used.
        self.width = width  # type: str

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.reso_priority is not None:
            result['ResoPriority'] = self.reso_priority
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('ResoPriority') is not None:
            self.reso_priority = m.get('ResoPriority')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The name of the OSS bucket to which the input file is uploaded.
        self.bucket = bucket  # type: str
        # The ID of the OSS region in which the input file resides.
        self.location = location  # type: str
        # The name of the Object Storage Service (OSS) object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMark(TeaModel):
    def __init__(self, dx=None, dy=None, height=None, input_file=None, refer_pos=None, type=None,
                 water_mark_template_id=None, width=None):
        # The horizontal offset of the watermark image relative to the output video. If this parameter is set in the request, the value overwrites the corresponding parameter in the watermark template. Default value: 0. The value can be an integer or a decimal.
        # 
        # *   An integer indicates the pixel value of the horizontal offset.
        # 
        #     *   Valid values: **\[8,4096]**.
        #     *   Unit: pixels.
        # 
        # *   A decimal indicates the ratio of the horizontal offset to the width in the output video resolution.
        # 
        #     *   Valid values: (0,1).
        #     *   The decimal number can be accurate to four decimal places, such as 0.9999. Excessive digits are automatically deleted.
        self.dx = dx  # type: str
        # The vertical offset of the watermark image relative to the output video. If this parameter is set in the request, the value overwrites the vertical offset of the watermark image relative to the output video. The value can be an integer or a decimal.
        # 
        # *   An integer indicates the pixel value of the vertical offset.
        # 
        #     *   Valid values: **\[8,4096]**.
        #     *   Unit: pixels.
        # 
        # *   A decimal indicates the ratio of the pixel value to the height in the output video resolution in pixels.
        # 
        #     *   Valid values: **(0,1)**.
        #     *   The decimal number can be accurate to four decimal places, such as 0.9999. Excessive digits are automatically deleted.
        self.dy = dy  # type: str
        # The height of the watermark image. If this parameter is set in the request, the value overwrites the corresponding parameter in the watermark template. The value can be an integer or a decimal.
        # 
        # *   An integer indicates the pixel value of the watermark height.
        # 
        #     *   Valid values: **\[8,4096]**.
        #     *   Unit: pixels.
        # 
        # *   A decimal indicates the ratio of the watermark height to the height in the output video resolution.
        # 
        #     *   Valid values: **(0,1)**.
        #     *   The decimal number can be accurate to four decimal places, such as 0.9999. Excessive digits are automatically deleted.
        self.height = height  # type: str
        # The watermark input file. You can use an image in the PNG format or a file in the MOV format as the watermark input.
        self.input_file = input_file  # type: QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile
        # The position of the watermark. If this parameter is set in the request, the value overwrites the corresponding parameter in the watermark template. Valid values:
        # 
        # *   TopRight: the upper-right corner.
        # *   TopLeft: the upper-left corner.
        # *   BottomRight: the lower-right corner.
        # *   BottomLeft: the lower-left corner.
        self.refer_pos = refer_pos  # type: str
        # The type of the watermark. If this parameter is set in the request, the value overwrites the corresponding parameter in the watermark template. For more information, see [Parameter details](~~29253~~). Valid values:
        # 
        # *   Image: an image watermark.
        # *   Text: a text watermark.
        self.type = type  # type: str
        # The ID of the watermark template.
        self.water_mark_template_id = water_mark_template_id  # type: str
        # The width of the watermark image. If this parameter is set in the request, the value overwrites the corresponding parameter in the watermark template. The value can be an integer or a decimal.
        # 
        # *   An integer indicates the pixel value of the watermark width.
        # 
        #     *   Valid values: **\[8,4096]**.
        #     *   Unit: pixels.
        # 
        # *   A decimal indicates the ratio of the watermark width to the width in the output video resolution.
        # 
        #     *   Valid values: **(0,1)**.
        #     *   The decimal number can be accurate to four decimal places, such as 0.9999. Excessive digits are automatically deleted.
        self.width = width  # type: str

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMark, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.type is not None:
            result['Type'] = self.type
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryJobListResponseBodyJobListJobOutputWaterMarkList(TeaModel):
    def __init__(self, water_mark=None):
        self.water_mark = water_mark  # type: list[QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMark]

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutputWaterMarkList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutput(TeaModel):
    def __init__(self, audio=None, audio_stream_map=None, clip=None, container=None, de_watermark=None,
                 encryption=None, extend_data=None, m_3u8non_standard_support=None, merge_config_url=None, merge_list=None,
                 multi_speed_info=None, mux_config=None, opening_list=None, out_subtitle_list=None, output_file=None, priority=None,
                 properties=None, rotate=None, subtitle_config=None, super_reso=None, tail_slate_list=None, template_id=None,
                 trans_config=None, user_data=None, video=None, video_stream_map=None, water_mark_config_url=None,
                 water_mark_list=None):
        # The audio configurations.
        # 
        # >  If this value was set in the request parameter, the corresponding parameters in the specified transcoding template are overwritten.
        self.audio = audio  # type: QueryJobListResponseBodyJobListJobOutputAudio
        # The sequence number of the audio stream.
        # 
        # *   Format: 0:a:{sequence number}. Example: 0:a:0.
        # *   The sequence number is the index of the audio stream in the list and starts from 0.
        # *   If you do not specify a sequence number, the default audio stream is used.
        self.audio_stream_map = audio_stream_map  # type: str
        # The information about the media clip.
        self.clip = clip  # type: QueryJobListResponseBodyJobListJobOutputClip
        # Information about the container.
        self.container = container  # type: QueryJobListResponseBodyJobListJobOutputContainer
        # The configuration of watermark blurring. The value must be a JSON object. For more information, see [Parameter details](~~29253~~).
        self.de_watermark = de_watermark  # type: str
        # The encryption configuration. Only outputs in the M3U8 format are supported.
        self.encryption = encryption  # type: QueryJobListResponseBodyJobListJobOutputEncryption
        # The custom fields.
        self.extend_data = extend_data  # type: str
        # The non-standard support configuration for M3U8. The value must be a JSON object. For more information, see [Parameter details](~~29253~~).
        self.m_3u8non_standard_support = m_3u8non_standard_support  # type: QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupport
        # The URL of the merging configuration file. You can specify only either the MergeList or MergeConfigUrl parameter.  
        # 
        # - The file that you specify for the MergeConfigUrl parameter can contain up to 50 merged clips.
        # - The MergeConfigUrl parameter specifies the URL of the configuration file for merging clips. Make sure that the configuration file is stored as an object in OSS and that MPS can access the OSS object. For information about the file content, see the details about merging parameters.
        # - Example of the content of mergeConfigfile: `{"MergeList":[{"MergeURL":"http://exampleBucket****.oss-cn-hangzhou.aliyuncs.com/video_01.mp4"}]}`.
        self.merge_config_url = merge_config_url  # type: str
        # The merging configuration. A maximum of four URLs can be merged.
        self.merge_list = merge_list  # type: QueryJobListResponseBodyJobListJobOutputMergeList
        self.multi_speed_info = multi_speed_info  # type: QueryJobListResponseBodyJobListJobOutputMultiSpeedInfo
        # The transmuxing configurations. If this value was set in the request parameter, the corresponding parameters in the specified transcoding template are overwritten.
        self.mux_config = mux_config  # type: QueryJobListResponseBodyJobListJobOutputMuxConfig
        # The list of opening parts. The value must be a JSON object.
        self.opening_list = opening_list  # type: QueryJobListResponseBodyJobListJobOutputOpeningList
        # The output subtitle list.
        self.out_subtitle_list = out_subtitle_list  # type: QueryJobListResponseBodyJobListJobOutputOutSubtitleList
        # The information about the output file.
        self.output_file = output_file  # type: QueryJobListResponseBodyJobListJobOutputOutputFile
        # The priority of the job in the MPS queue to which the job is added. 
        # 
        # - A value of 10 indicates the highest priority.
        # - Default value: **6**.
        self.priority = priority  # type: str
        # The media properties.
        self.properties = properties  # type: QueryJobListResponseBodyJobListJobOutputProperties
        # The video rotation angle.
        self.rotate = rotate  # type: str
        # The subtitle configuration.
        self.subtitle_config = subtitle_config  # type: QueryJobListResponseBodyJobListJobOutputSubtitleConfig
        # Indicates that the resolution of the source video is used.
        self.super_reso = super_reso  # type: QueryJobListResponseBodyJobListJobOutputSuperReso
        # The list of ending parts.
        self.tail_slate_list = tail_slate_list  # type: QueryJobListResponseBodyJobListJobOutputTailSlateList
        # The ID of the template.
        self.template_id = template_id  # type: str
        # The general transcoding configurations.
        # 
        # >  If this value was set in the request parameter, the corresponding parameters in the specified transcoding template are overwritten.
        self.trans_config = trans_config  # type: QueryJobListResponseBodyJobListJobOutputTransConfig
        # The custom data.
        self.user_data = user_data  # type: str
        # The video configuration.
        self.video = video  # type: QueryJobListResponseBodyJobListJobOutputVideo
        # The sequence number of the video stream. The sequence number is the index of the video stream in the list and starts from 0. If you do not set the corresponding parameter in the request, the default video stream is selected.
        self.video_stream_map = video_stream_map  # type: str
        # The URL of the watermark configuration file.
        self.water_mark_config_url = water_mark_config_url  # type: str
        # The list of watermarks.
        self.water_mark_list = water_mark_list  # type: QueryJobListResponseBodyJobListJobOutputWaterMarkList

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.clip:
            self.clip.validate()
        if self.container:
            self.container.validate()
        if self.encryption:
            self.encryption.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.multi_speed_info:
            self.multi_speed_info.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.opening_list:
            self.opening_list.validate()
        if self.out_subtitle_list:
            self.out_subtitle_list.validate()
        if self.output_file:
            self.output_file.validate()
        if self.properties:
            self.properties.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.tail_slate_list:
            self.tail_slate_list.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.video:
            self.video.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.extend_data is not None:
            result['ExtendData'] = self.extend_data
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.multi_speed_info is not None:
            result['MultiSpeedInfo'] = self.multi_speed_info.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.opening_list is not None:
            result['OpeningList'] = self.opening_list.to_map()
        if self.out_subtitle_list is not None:
            result['OutSubtitleList'] = self.out_subtitle_list.to_map()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.tail_slate_list is not None:
            result['TailSlateList'] = self.tail_slate_list.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('Clip') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('Container') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('Encryption') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('ExtendData') is not None:
            self.extend_data = m.get('ExtendData')
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('MergeList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('MultiSpeedInfo') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMultiSpeedInfo()
            self.multi_speed_info = temp_model.from_map(m['MultiSpeedInfo'])
        if m.get('MuxConfig') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('OpeningList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputOpeningList()
            self.opening_list = temp_model.from_map(m['OpeningList'])
        if m.get('OutSubtitleList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputOutSubtitleList()
            self.out_subtitle_list = temp_model.from_map(m['OutSubtitleList'])
        if m.get('OutputFile') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Properties') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputProperties()
            self.properties = temp_model.from_map(m['Properties'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('SubtitleConfig') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('SuperReso') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('TailSlateList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputTailSlateList()
            self.tail_slate_list = temp_model.from_map(m['TailSlateList'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TransConfig') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Video') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('WaterMarkList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        return self


class QueryJobListResponseBodyJobListJobPipelineExtendConfig(TeaModel):
    def __init__(self, is_boost_new=None, max_multi_speed=None, multi_speed_downgrade_policy=None):
        self.is_boost_new = is_boost_new  # type: bool
        self.max_multi_speed = max_multi_speed  # type: int
        self.multi_speed_downgrade_policy = multi_speed_downgrade_policy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobPipelineExtendConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_boost_new is not None:
            result['IsBoostNew'] = self.is_boost_new
        if self.max_multi_speed is not None:
            result['MaxMultiSpeed'] = self.max_multi_speed
        if self.multi_speed_downgrade_policy is not None:
            result['MultiSpeedDowngradePolicy'] = self.multi_speed_downgrade_policy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsBoostNew') is not None:
            self.is_boost_new = m.get('IsBoostNew')
        if m.get('MaxMultiSpeed') is not None:
            self.max_multi_speed = m.get('MaxMultiSpeed')
        if m.get('MultiSpeedDowngradePolicy') is not None:
            self.multi_speed_downgrade_policy = m.get('MultiSpeedDowngradePolicy')
        return self


class QueryJobListResponseBodyJobListJobPipeline(TeaModel):
    def __init__(self, extend_config=None, id=None, name=None, speed=None, state=None):
        self.extend_config = extend_config  # type: QueryJobListResponseBodyJobListJobPipelineExtendConfig
        self.id = id  # type: str
        self.name = name  # type: str
        self.speed = speed  # type: str
        self.state = state  # type: str

    def validate(self):
        if self.extend_config:
            self.extend_config.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJobPipeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_config is not None:
            result['ExtendConfig'] = self.extend_config.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtendConfig') is not None:
            temp_model = QueryJobListResponseBodyJobListJobPipelineExtendConfig()
            self.extend_config = temp_model.from_map(m['ExtendConfig'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryJobListResponseBodyJobListJob(TeaModel):
    def __init__(self, code=None, creation_time=None, finish_time=None, input=None, job_id=None,
                 mnsmessage_result=None, message=None, output=None, percent=None, pipeline=None, pipeline_id=None, state=None):
        # The error code that is returned if the transcoding job fails. This parameter is not returned if the job succeeds.
        self.code = code  # type: str
        # The time when the job was created.
        self.creation_time = creation_time  # type: str
        # The time when the job was complete.
        self.finish_time = finish_time  # type: str
        # The information about the job input.
        self.input = input  # type: QueryJobListResponseBodyJobListJobInput
        # The ID of the job.
        self.job_id = job_id  # type: str
        # The message sent by Message Service (MNS) to notify the user of the job result.
        self.mnsmessage_result = mnsmessage_result  # type: QueryJobListResponseBodyJobListJobMNSMessageResult
        # The message that is returned if the job fails. This parameter is not returned if the job succeeds.
        self.message = message  # type: str
        # The output of the job.
        self.output = output  # type: QueryJobListResponseBodyJobListJobOutput
        # The transcoding progress.
        self.percent = percent  # type: long
        self.pipeline = pipeline  # type: QueryJobListResponseBodyJobListJobPipeline
        # The ID of the MPS queue.
        self.pipeline_id = pipeline_id  # type: str
        # The status of the job. Valid values:
        # 
        # *   **Submitted**: The job has been submitted.
        # *   **Transcoding**: The job is being processed.
        # *   **TranscodeSuccess**: The job succeeded.
        # *   **TranscodeFail**: Transcoding failed.
        # *   **TranscodeCancelled**: The job has been canceled.
        self.state = state  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.output:
            self.output.validate()
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobListJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = QueryJobListResponseBodyJobListJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryJobListResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Output') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('Pipeline') is not None:
            temp_model = QueryJobListResponseBodyJobListJobPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryJobListResponseBodyJobList(TeaModel):
    def __init__(self, job=None):
        self.job = job  # type: list[QueryJobListResponseBodyJobListJob]

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBodyJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QueryJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyNonExistJobIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryJobListResponseBodyNonExistJobIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryJobListResponseBody(TeaModel):
    def __init__(self, job_list=None, non_exist_job_ids=None, request_id=None):
        # The list of transcoding jobs.
        self.job_list = job_list  # type: QueryJobListResponseBodyJobList
        # The list of nonexistent job IDs. If all queried job IDs exist, the response does not contain this parameter.
        self.non_exist_job_ids = non_exist_job_ids  # type: QueryJobListResponseBodyNonExistJobIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.job_list:
            self.job_list.validate()
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()

    def to_map(self):
        _map = super(QueryJobListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobList') is not None:
            temp_model = QueryJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        if m.get('NonExistJobIds') is not None:
            temp_model = QueryJobListResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryJobListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryJobListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaCensorJobDetailRequest(TeaModel):
    def __init__(self, job_id=None, maximum_page_size=None, next_page_token=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the content moderation job. You can obtain the job ID from the response parameters of the [SubmitMediaCensorJob](~~91774~~) operation.
        self.job_id = job_id  # type: str
        # The maximum number of entries to return on each page.
        # 
        # *   Default value: **30**.
        # *   Valid values: **1 to 300**.
        self.maximum_page_size = maximum_page_size  # type: long
        # The token that is used to retrieve the next page of the query results. You can leave this parameter empty when you call this operation to query the results of a content moderation job for the first time. The token of the next page is returned after you call this operation to query the results of a content moderation job for the first time.
        self.next_page_token = next_page_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        # The labels of the moderation result. Multiple labels are separated with commas (,). Valid values:
        # 
        # *   **spam**: spam
        # *   **ad**: ads
        # *   **abuse**: abuse
        # *   **flood**: excessive junk content
        # *   **contraband**: prohibited content
        # *   **meaningless**: meaningless content
        # *   **normal**: normal content
        self.label = label  # type: str
        # The score.
        self.rate = rate  # type: str
        # The moderation scenario. The value is **antispam**.
        self.scene = scene  # type: str
        # The recommended subsequent operation. Valid values:
        # 
        # *   **pass**: The content passes the moderation.
        # *   **review**: The content needs to be manually reviewed again.
        # *   **block**: The content needs to be blocked.
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        # The labels of the moderation result. Multiple labels are separated with commas (,).
        # 
        # *   Valid values in the pornographic content moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **sexy**: sexy content
        #     *   **porn**: pornographic content
        # 
        # *   Valid values in the terrorist content moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **bloody**: bloody content
        #     *   **explosion**: explosion and smoke
        #     *   **outfit**: special costume
        #     *   **logo**: special logo
        #     *   **weapon**: weapon
        #     *   **politics**: political content
        #     *   **violence**: violence
        #     *   **crowd**: crowd
        #     *   **parade**: parade
        #     *   **carcrash**: car accident
        #     *   **flag**: flag
        #     *   **location**: landmark
        #     *   **others**: other content
        # 
        # *   Valid values in the ad moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **ad**: other ads
        #     *   **politics**: political content in text
        #     *   **porn**: pornographic content in text
        #     *   **abuse**: abuse in text
        #     *   **terrorism**: terrorist content in text
        #     *   **contraband**: prohibited content in text
        #     *   **spam**: spam in text
        #     *   **npx**: illegal ads
        #     *   **qrcode**: QR code
        #     *   **programCode**: mini program code
        # 
        # *   Valid values in the live moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **meaningless**: meaningless content, such as a black or white screen
        #     *   **PIP**: picture-in-picture
        #     *   **smoking**: smoking
        #     *   **drivelive**: live broadcasting in a running vehicle
        # 
        # *   Valid values in the logo moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **TV**: controlled TV station logo
        #     *   **trademark**: trademark
        self.label = label  # type: str
        # The score. Valid values: **0 to 100**.
        self.rate = rate  # type: str
        # The moderation scenario. Valid values:
        # 
        # *   **porn**: pornographic content moderation
        # *   **terrorism**: terrorist content moderation
        # *   **ad**: ad violation moderation
        # *   **live**: undesirable scene moderation
        # *   **logo**: logo moderation
        self.scene = scene  # type: str
        # The recommended subsequent operation. Valid values:
        # 
        # *   **pass**: The content passes the moderation.
        # *   **review**: The content needs to be manually reviewed again.
        # *   **block**: The content needs to be blocked.
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults(TeaModel):
    def __init__(self, result=None):
        self.result = result  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult]

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult(TeaModel):
    def __init__(self, bucket=None, location=None, object=None, results=None):
        # The OSS bucket that stores the video thumbnail.
        self.bucket = bucket  # type: str
        # The OSS region in which the video thumbnail resides.
        self.location = location  # type: str
        # The Object Storage Service (OSS) object that is used as the video thumbnail.
        self.object = object  # type: str
        # The moderation results.
        self.results = results  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults

    def validate(self):
        if self.results:
            self.results.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.results is not None:
            result['Results'] = self.results.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Results') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults()
            self.results = temp_model.from_map(m['Results'])
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults(TeaModel):
    def __init__(self, cover_image_censor_result=None):
        self.cover_image_censor_result = cover_image_censor_result  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult]

    def validate(self):
        if self.cover_image_censor_result:
            for k in self.cover_image_censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoverImageCensorResult'] = []
        if self.cover_image_censor_result is not None:
            for k in self.cover_image_censor_result:
                result['CoverImageCensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cover_image_censor_result = []
        if m.get('CoverImageCensorResult') is not None:
            for k in m.get('CoverImageCensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult()
                self.cover_image_censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        # The labels of the moderation result. Valid values:
        # 
        # *   **spam**: spam
        # *   **ad**: ads
        # *   **abuse**: abuse
        # *   **flood**: excessive junk content
        # *   **contraband**: prohibited content
        # *   **meaningless**: meaningless content
        # *   **normal**: normal content
        self.label = label  # type: str
        # The score.
        self.rate = rate  # type: str
        # The moderation scenario. The value is **antispam**.
        self.scene = scene  # type: str
        # The recommended subsequent operation. Valid values:
        # 
        # *   **pass**: The content passes the moderation.
        # *   **review**: The content needs to be manually reviewed again.
        # *   **block**: The content needs to be blocked.
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The OSS bucket that stores the input file.
        self.bucket = bucket  # type: str
        # The OSS region in which the input file resides.
        self.location = location  # type: str
        # The OSS object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        # The labels of the moderation result. Valid values: 
        # 
        # - **normal**: normal content
        # - **spam**: spam
        # - **ad**: ads
        # - **abuse**: abuse
        # - **flood**: excessive junk content
        # - **contraband**: prohibited content
        # - **meaningless**: meaningless content
        self.label = label  # type: str
        # The score.
        self.rate = rate  # type: str
        # The moderation scenario. The value is **antispam**.
        self.scene = scene  # type: str
        # The recommended subsequent operation. Valid values:
        # 
        # - **pass**: The content passes the moderation.
        # - **review**: The content needs to be manually reviewed again.
        # - **block**: The content needs to be blocked.
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        # The labels of the moderation result. Multiple labels are separated with commas (,). 
        # 
        # - Valid values in the pornographic content moderation scenario:   - **porn**: pornographic content
        #   - **sexy**: sexy content
        #   - **normal**: normal content
        # - Valid values in the terrorist content moderation scenario:   - **normal**: normal content
        #   - **bloody**: bloody content
        #   - **explosion**: explosion and smoke
        #   - **outfit**: special costume
        #   - **logo**: special logo
        #   - **weapon**: weapon
        #   - **politics**: political content
        #   - **violence**: violence
        #   - **crowd**: crowd
        #   - **parade**: parade
        #   - **carcrash**: car accident
        #   - **flag**: flag
        #   - **location**: landmark
        #   - **others**: other content
        # - Valid values in the ad moderation scenario:   - **normal**: normal content
        #   - **ad**: other ads
        #   - **politics**: political content in text
        #   - **porn**: pornographic content in text
        #   - **abuse**: abuse in text
        #   - **terrorism**: terrorist content in text
        #   - **contraband**: prohibited content in text
        #   - **spam**: spam in text
        #   - **npx**: illegal ads
        #   - **qrcode**: QR code
        #   - **programCode**: mini program code
        # - Valid values in the live moderation scenario:   - **normal**: normal content
        #   - **meaningless**: meaningless content, such as a black or white screen
        #   - **PIP**: picture-in-picture
        #   - **smoking**: smoking
        #   - **drivelive**: live broadcasting in a running vehicle
        # - Valid values in the logo moderation scenario:   - **normal**: normal content
        #   - **TV**: controlled TV station logo
        #   - **trademark**: trademark
        self.label = label  # type: str
        # The score.
        self.rate = rate  # type: str
        # The moderation scenario. Valid values: 
        # 
        # - **porn**: pornographic content moderation
        # - **terrorism**: terrorist content moderation
        # - **ad**: ad violation moderation
        # - **live**: undesirable scene moderation
        # - **logo**: logo moderation
        self.scene = scene  # type: str
        # The recommended subsequent operation. Valid values:
        # 
        # - **pass**: The content passes the moderation.
        # - **review**: The content needs to be manually reviewed again.
        # - **block**: The content needs to be blocked.
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults(TeaModel):
    def __init__(self, censor_result=None):
        self.censor_result = censor_result  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult]

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        # The labels of the moderation result. Multiple labels are separated with commas (,).
        # 
        # *   Valid values in the pornographic content moderation scenario:
        # 
        #     *   **porn**: pornographic content
        #     *   **sexy**: sexy content
        #     *   **normal**: normal content
        # 
        # *   Valid values in the terrorist content moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **bloody**: bloody content
        #     *   **explosion**: explosion and smoke
        #     *   **outfit**: special costume
        #     *   **logo**: special logo
        #     *   **weapon**: weapon
        #     *   **politics**: political content
        #     *   **violence**: violence
        #     *   **crowd**: crowd
        #     *   **parade**: parade
        #     *   **carcrash**: car accident
        #     *   **flag**: flag
        #     *   **location**: landmark
        #     *   **others**: other content
        # 
        # *   Valid values in the ad moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **ad**: other ads
        #     *   **politics**: political content in text
        #     *   **porn**: pornographic content in text
        #     *   **abuse**: abuse in text
        #     *   **terrorism**: terrorist content in text
        #     *   **contraband**: prohibited content in text
        #     *   **spam**: spam in text
        #     *   **npx**: illegal ads
        #     *   **qrcode**: QR code
        #     *   **programCode**: mini program code
        # 
        # *   Valid values in the live moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **meaningless**: meaningless content, such as a black or white screen
        #     *   **PIP**: picture-in-picture
        #     *   **smoking**: smoking
        #     *   **drivelive**: live broadcasting in a running vehicle
        # 
        # *   Valid values in the logo moderation scenario:
        # 
        #     *   **normal**: normal content
        #     *   **TV**: controlled TV station logo
        #     *   **trademark**: trademark
        self.label = label  # type: str
        # The score.
        self.rate = rate  # type: str
        # The moderation scenario. Valid values:
        # 
        # *   **porn**: pornographic content moderation
        # *   **terrorism**: terrorist content moderation
        # *   **ad**: ad violation moderation
        # *   **live**: undesirable scene moderation
        # *   **logo**: logo moderation
        self.scene = scene  # type: str
        # The recommended subsequent operation. Valid values:
        # 
        # *   **pass**: The content passes the moderation.
        # *   **review**: The content needs to be manually reviewed again.
        # *   **block**: The content needs to be blocked.
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults(TeaModel):
    def __init__(self, censor_result=None):
        self.censor_result = censor_result  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult]

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline(TeaModel):
    def __init__(self, censor_results=None, object=None, timestamp=None):
        # A collection of the moderation results. The information includes the summary about various scenarios such as pornographic content and terrorist content.
        self.censor_results = censor_results  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults
        # The one or more OSS objects that are generated as the output snapshots.
        # 
        # >  In the example, {Count} is a placeholder. The OSS objects that are generated as output snapshots are named `output00001-****.jpg`, `output00002-****.jpg`, and so on.
        self.object = object  # type: str
        # The position in the video.
        # 
        # Format: `hh:mm:ss[.SSS]`.
        self.timestamp = timestamp  # type: str

    def validate(self):
        if self.censor_results:
            self.censor_results.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        if self.object is not None:
            result['Object'] = self.object
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines(TeaModel):
    def __init__(self, video_timeline=None):
        self.video_timeline = video_timeline  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline]

    def validate(self):
        if self.video_timeline:
            for k in self.video_timeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoTimeline'] = []
        if self.video_timeline is not None:
            for k in self.video_timeline:
                result['VideoTimeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_timeline = []
        if m.get('VideoTimeline') is not None:
            for k in m.get('VideoTimeline'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline()
                self.video_timeline.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult(TeaModel):
    def __init__(self, censor_results=None, next_page_token=None, video_timelines=None):
        # A collection of the moderation results. The information includes the summary about various scenarios such as pornographic content and terrorist content.
        self.censor_results = censor_results  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults
        # The token that is used to retrieve the next page of the query results.
        self.next_page_token = next_page_token  # type: str
        # The moderation results that are sorted in ascending order by time.
        self.video_timelines = video_timelines  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines

    def validate(self):
        if self.censor_results:
            self.censor_results.validate()
        if self.video_timelines:
            self.video_timelines.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.video_timelines is not None:
            result['VideoTimelines'] = self.video_timelines.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('VideoTimelines') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines()
            self.video_timelines = temp_model.from_map(m['VideoTimelines'])
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The OSS bucket that stores the output snapshot.
        self.bucket = bucket  # type: str
        # The OSS region in which the OSS bucket for storing the output snapshot resides.
        self.location = location  # type: str
        # The one or more OSS objects that are generated as the output snapshots.
        # 
        # >  In the example, {Count} is a placeholder. The OSS objects that are generated as output snapshots are named `output00001-****.jpg`, `output00002-****.jpg`, and so on.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig(TeaModel):
    def __init__(self, biz_type=None, output_file=None, video_censor=None):
        # The custom business type. Default value: common.
        self.biz_type = biz_type  # type: str
        # The information about output snapshots.
        self.output_file = output_file  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile
        # Indicates whether the video content needs to be moderated. Default value: **true**. Valid values:
        # 
        # *   **true**: The video content needs to be moderated.
        # *   **false**: The video content does not need to be moderated.
        self.video_censor = video_censor  # type: str

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.video_censor is not None:
            result['VideoCensor'] = self.video_censor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('OutputFile') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('VideoCensor') is not None:
            self.video_censor = m.get('VideoCensor')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail(TeaModel):
    def __init__(self, barrage_censor_result=None, code=None, cover_image_censor_results=None, creation_time=None,
                 desc_censor_result=None, finish_time=None, input=None, job_id=None, message=None, pipeline_id=None, state=None,
                 suggestion=None, title_censor_result=None, user_data=None, vensor_censor_result=None,
                 video_censor_config=None):
        # The moderation result of live comments.
        self.barrage_censor_result = barrage_censor_result  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult
        # The error code returned if the job fails. This parameter is not returned if the job is successful.
        self.code = code  # type: str
        # The moderation results of thumbnails.
        self.cover_image_censor_results = cover_image_censor_results  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults
        # The time when the job was created.
        self.creation_time = creation_time  # type: str
        # The moderation result of the description.
        self.desc_censor_result = desc_censor_result  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult
        # The time when the job was completed.
        self.finish_time = finish_time  # type: str
        # The information about the job input.
        self.input = input  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput
        # The ID of the content moderation job.
        self.job_id = job_id  # type: str
        # The error message returned if the job fails. This parameter is not returned if the job is successful.
        self.message = message  # type: str
        # The ID of the ApsaraVideo Media Processing (MPS) queue that is used to run the job.
        self.pipeline_id = pipeline_id  # type: str
        # The status of the job.
        self.state = state  # type: str
        # The overall result of the job. Valid values:
        # 
        # *   **pass**: The content passes the moderation.
        # *   **review**: The content needs to be manually reviewed again.
        # *   **block**: The content needs to be blocked.
        # 
        # If the moderation result of one type of the moderated content is review, the overall result is review. If the moderation result of one type of the moderated content is block, the overall result is block.
        self.suggestion = suggestion  # type: str
        # The moderation result of the title.
        self.title_censor_result = title_censor_result  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult
        # The custom data.
        self.user_data = user_data  # type: str
        # The results of video review.
        self.vensor_censor_result = vensor_censor_result  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult
        # The video moderation configurations.
        self.video_censor_config = video_censor_config  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig

    def validate(self):
        if self.barrage_censor_result:
            self.barrage_censor_result.validate()
        if self.cover_image_censor_results:
            self.cover_image_censor_results.validate()
        if self.desc_censor_result:
            self.desc_censor_result.validate()
        if self.input:
            self.input.validate()
        if self.title_censor_result:
            self.title_censor_result.validate()
        if self.vensor_censor_result:
            self.vensor_censor_result.validate()
        if self.video_censor_config:
            self.video_censor_config.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.barrage_censor_result is not None:
            result['BarrageCensorResult'] = self.barrage_censor_result.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.cover_image_censor_results is not None:
            result['CoverImageCensorResults'] = self.cover_image_censor_results.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.desc_censor_result is not None:
            result['DescCensorResult'] = self.desc_censor_result.to_map()
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.title_censor_result is not None:
            result['TitleCensorResult'] = self.title_censor_result.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.vensor_censor_result is not None:
            result['VensorCensorResult'] = self.vensor_censor_result.to_map()
        if self.video_censor_config is not None:
            result['VideoCensorConfig'] = self.video_censor_config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BarrageCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult()
            self.barrage_censor_result = temp_model.from_map(m['BarrageCensorResult'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CoverImageCensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults()
            self.cover_image_censor_results = temp_model.from_map(m['CoverImageCensorResults'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DescCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult()
            self.desc_censor_result = temp_model.from_map(m['DescCensorResult'])
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TitleCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult()
            self.title_censor_result = temp_model.from_map(m['TitleCensorResult'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VensorCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult()
            self.vensor_censor_result = temp_model.from_map(m['VensorCensorResult'])
        if m.get('VideoCensorConfig') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig()
            self.video_censor_config = temp_model.from_map(m['VideoCensorConfig'])
        return self


class QueryMediaCensorJobDetailResponseBody(TeaModel):
    def __init__(self, media_censor_job_detail=None, request_id=None):
        # The results of the content moderation job.
        self.media_censor_job_detail = media_censor_job_detail  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_censor_job_detail:
            self.media_censor_job_detail.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_censor_job_detail is not None:
            result['MediaCensorJobDetail'] = self.media_censor_job_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaCensorJobDetail') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail()
            self.media_censor_job_detail = temp_model.from_map(m['MediaCensorJobDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMediaCensorJobDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryMediaCensorJobDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaCensorJobListRequest(TeaModel):
    def __init__(self, end_of_job_created_time_range=None, job_ids=None, maximum_page_size=None,
                 next_page_token=None, owner_account=None, owner_id=None, pipeline_id=None, resource_owner_account=None,
                 resource_owner_id=None, start_of_job_created_time_range=None, state=None):
        self.end_of_job_created_time_range = end_of_job_created_time_range  # type: str
        self.job_ids = job_ids  # type: str
        self.maximum_page_size = maximum_page_size  # type: long
        self.next_page_token = next_page_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.pipeline_id = pipeline_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_of_job_created_time_range = start_of_job_created_time_range  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_job_created_time_range is not None:
            result['EndOfJobCreatedTimeRange'] = self.end_of_job_created_time_range
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_of_job_created_time_range is not None:
            result['StartOfJobCreatedTimeRange'] = self.start_of_job_created_time_range
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndOfJobCreatedTimeRange') is not None:
            self.end_of_job_created_time_range = m.get('EndOfJobCreatedTimeRange')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartOfJobCreatedTimeRange') is not None:
            self.start_of_job_created_time_range = m.get('StartOfJobCreatedTimeRange')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobBarrageCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobBarrageCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResultResultsResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResultResultsResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResultResults(TeaModel):
    def __init__(self, result=None):
        self.result = result  # type: list[QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResultResultsResult]

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResultResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResultResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResult(TeaModel):
    def __init__(self, bucket=None, location=None, object=None, results=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str
        self.results = results  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResultResults

    def validate(self):
        if self.results:
            self.results.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.results is not None:
            result['Results'] = self.results.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Results') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResultResults()
            self.results = temp_model.from_map(m['Results'])
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResults(TeaModel):
    def __init__(self, cover_image_censor_result=None):
        self.cover_image_censor_result = cover_image_censor_result  # type: list[QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResult]

    def validate(self):
        if self.cover_image_censor_result:
            for k in self.cover_image_censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoverImageCensorResult'] = []
        if self.cover_image_censor_result is not None:
            for k in self.cover_image_censor_result:
                result['CoverImageCensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cover_image_censor_result = []
        if m.get('CoverImageCensorResult') is not None:
            for k in m.get('CoverImageCensorResult'):
                temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResultsCoverImageCensorResult()
                self.cover_image_censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobDescCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobDescCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobTitleCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobTitleCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultCensorResultsCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultCensorResultsCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultCensorResults(TeaModel):
    def __init__(self, censor_result=None):
        self.censor_result = censor_result  # type: list[QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultCensorResultsCensorResult]

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimelineCensorResults(TeaModel):
    def __init__(self, censor_result=None):
        self.censor_result = censor_result  # type: list[QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult]

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimelineCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimeline(TeaModel):
    def __init__(self, censor_results=None, object=None, timestamp=None):
        self.censor_results = censor_results  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimelineCensorResults
        self.object = object  # type: str
        self.timestamp = timestamp  # type: str

    def validate(self):
        if self.censor_results:
            self.censor_results.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        if self.object is not None:
            result['Object'] = self.object
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimelineCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelines(TeaModel):
    def __init__(self, video_timeline=None):
        self.video_timeline = video_timeline  # type: list[QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimeline]

    def validate(self):
        if self.video_timeline:
            for k in self.video_timeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoTimeline'] = []
        if self.video_timeline is not None:
            for k in self.video_timeline:
                result['VideoTimeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_timeline = []
        if m.get('VideoTimeline') is not None:
            for k in m.get('VideoTimeline'):
                temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelinesVideoTimeline()
                self.video_timeline.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResult(TeaModel):
    def __init__(self, censor_results=None, next_page_token=None, video_timelines=None):
        self.censor_results = censor_results  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultCensorResults
        self.next_page_token = next_page_token  # type: str
        self.video_timelines = video_timelines  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelines

    def validate(self):
        if self.censor_results:
            self.censor_results.validate()
        if self.video_timelines:
            self.video_timelines.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.video_timelines is not None:
            result['VideoTimelines'] = self.video_timelines.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('VideoTimelines') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResultVideoTimelines()
            self.video_timelines = temp_model.from_map(m['VideoTimelines'])
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVideoCensorConfigOutputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVideoCensorConfigOutputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVideoCensorConfig(TeaModel):
    def __init__(self, biz_type=None, output_file=None, video_censor=None):
        self.biz_type = biz_type  # type: str
        self.output_file = output_file  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVideoCensorConfigOutputFile
        self.video_censor = video_censor  # type: str

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVideoCensorConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.video_censor is not None:
            result['VideoCensor'] = self.video_censor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('OutputFile') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVideoCensorConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('VideoCensor') is not None:
            self.video_censor = m.get('VideoCensor')
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJob(TeaModel):
    def __init__(self, barrage_censor_result=None, code=None, cover_image_censor_results=None, creation_time=None,
                 desc_censor_result=None, finish_time=None, input=None, job_id=None, message=None, pipeline_id=None, state=None,
                 suggestion=None, title_censor_result=None, user_data=None, vensor_censor_result=None,
                 video_censor_config=None):
        self.barrage_censor_result = barrage_censor_result  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobBarrageCensorResult
        self.code = code  # type: str
        self.cover_image_censor_results = cover_image_censor_results  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResults
        self.creation_time = creation_time  # type: str
        self.desc_censor_result = desc_censor_result  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobDescCensorResult
        self.finish_time = finish_time  # type: str
        self.input = input  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobInput
        self.job_id = job_id  # type: str
        self.message = message  # type: str
        self.pipeline_id = pipeline_id  # type: str
        self.state = state  # type: str
        self.suggestion = suggestion  # type: str
        self.title_censor_result = title_censor_result  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobTitleCensorResult
        self.user_data = user_data  # type: str
        self.vensor_censor_result = vensor_censor_result  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResult
        self.video_censor_config = video_censor_config  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVideoCensorConfig

    def validate(self):
        if self.barrage_censor_result:
            self.barrage_censor_result.validate()
        if self.cover_image_censor_results:
            self.cover_image_censor_results.validate()
        if self.desc_censor_result:
            self.desc_censor_result.validate()
        if self.input:
            self.input.validate()
        if self.title_censor_result:
            self.title_censor_result.validate()
        if self.vensor_censor_result:
            self.vensor_censor_result.validate()
        if self.video_censor_config:
            self.video_censor_config.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.barrage_censor_result is not None:
            result['BarrageCensorResult'] = self.barrage_censor_result.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.cover_image_censor_results is not None:
            result['CoverImageCensorResults'] = self.cover_image_censor_results.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.desc_censor_result is not None:
            result['DescCensorResult'] = self.desc_censor_result.to_map()
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.title_censor_result is not None:
            result['TitleCensorResult'] = self.title_censor_result.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.vensor_censor_result is not None:
            result['VensorCensorResult'] = self.vensor_censor_result.to_map()
        if self.video_censor_config is not None:
            result['VideoCensorConfig'] = self.video_censor_config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BarrageCensorResult') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobBarrageCensorResult()
            self.barrage_censor_result = temp_model.from_map(m['BarrageCensorResult'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CoverImageCensorResults') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobCoverImageCensorResults()
            self.cover_image_censor_results = temp_model.from_map(m['CoverImageCensorResults'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DescCensorResult') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobDescCensorResult()
            self.desc_censor_result = temp_model.from_map(m['DescCensorResult'])
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TitleCensorResult') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobTitleCensorResult()
            self.title_censor_result = temp_model.from_map(m['TitleCensorResult'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VensorCensorResult') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVensorCensorResult()
            self.vensor_censor_result = temp_model.from_map(m['VensorCensorResult'])
        if m.get('VideoCensorConfig') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJobVideoCensorConfig()
            self.video_censor_config = temp_model.from_map(m['VideoCensorConfig'])
        return self


class QueryMediaCensorJobListResponseBodyMediaCensorJobList(TeaModel):
    def __init__(self, media_censor_job=None):
        self.media_censor_job = media_censor_job  # type: list[QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJob]

    def validate(self):
        if self.media_censor_job:
            for k in self.media_censor_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyMediaCensorJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaCensorJob'] = []
        if self.media_censor_job is not None:
            for k in self.media_censor_job:
                result['MediaCensorJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_censor_job = []
        if m.get('MediaCensorJob') is not None:
            for k in m.get('MediaCensorJob'):
                temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobListMediaCensorJob()
                self.media_censor_job.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobListResponseBodyNonExistIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBodyNonExistIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryMediaCensorJobListResponseBody(TeaModel):
    def __init__(self, media_censor_job_list=None, next_page_token=None, non_exist_ids=None, request_id=None):
        self.media_censor_job_list = media_censor_job_list  # type: QueryMediaCensorJobListResponseBodyMediaCensorJobList
        self.next_page_token = next_page_token  # type: str
        self.non_exist_ids = non_exist_ids  # type: QueryMediaCensorJobListResponseBodyNonExistIds
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_censor_job_list:
            self.media_censor_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_censor_job_list is not None:
            result['MediaCensorJobList'] = self.media_censor_job_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaCensorJobList') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyMediaCensorJobList()
            self.media_censor_job_list = temp_model.from_map(m['MediaCensorJobList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NonExistIds') is not None:
            temp_model = QueryMediaCensorJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMediaCensorJobListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryMediaCensorJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryMediaCensorJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaInfoJobListRequest(TeaModel):
    def __init__(self, media_info_job_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The IDs of the media information analysis jobs. Separate multiple jobs with commas (,). You can query up to 10 jobs at a time.
        self.media_info_job_ids = media_info_job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaInfoJobListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_info_job_ids is not None:
            result['MediaInfoJobIds'] = self.media_info_job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaInfoJobIds') is not None:
            self.media_info_job_ids = m.get('MediaInfoJobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The name of the OSS bucket that stores the object.
        self.bucket = bucket  # type: str
        # The ID of the OSS region.
        self.location = location  # type: str
        # The name of the Object Storage Service (OSS) object used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobMNSMessageResult(TeaModel):
    def __init__(self, error_code=None, error_message=None, message_id=None):
        # The error code returned when the job fails. This parameter is not returned if the job is successful.
        self.error_code = error_code  # type: str
        # The error message returned when the job fails. This parameter is not returned if the job is successful.
        self.error_message = error_message  # type: str
        # The ID of the success message returned when the job is successful. This parameter is not returned if the job fails.
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobMNSMessageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesFormat(TeaModel):
    def __init__(self, bitrate=None, duration=None, format_long_name=None, format_name=None, num_programs=None,
                 num_streams=None, size=None, start_time=None):
        # The total bitrate.
        self.bitrate = bitrate  # type: str
        # The total duration.
        self.duration = duration  # type: str
        # The full name of the container format.
        self.format_long_name = format_long_name  # type: str
        # The short name of the container format.
        self.format_name = format_name  # type: str
        # The total number of program streams.
        self.num_programs = num_programs  # type: str
        # The total number of media streams.
        self.num_streams = num_streams  # type: str
        # The size of the file.
        self.size = size  # type: str
        # The start time.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 num_frames=None, sample_fmt=None, samplerate=None, start_time=None, timebase=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The number of sound channels.
        self.channel_layout = channel_layout  # type: str
        # The output layout of the sound channels.
        self.channels = channels  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format. Valid values:
        # 
        # - **acc**\
        # - **mp3**\
        # - **mp4**\
        # - **ogg**\
        # - **flac**\
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The sequence number of the audio stream. The value indicates the position of the audio stream in all audio streams.
        self.index = index  # type: str
        # The language. For more information, see [21.20.1 Metadata](https://www.ffmpeg.org/ffmpeg-all.html?spm=a2c4g.11186623.2.66.243851cd2SntfN#Metadata) in FFmpeg documentation.
        self.lang = lang  # type: str
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The sampling format.
        self.sample_fmt = sample_fmt  # type: str
        # The sampling rate.
        self.samplerate = samplerate  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsAudioStreamListAudioStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(self, audio_stream=None):
        self.audio_stream = audio_stream  # type: list[QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsAudioStreamListAudioStream]

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsAudioStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(self, codec_long_name=None, codec_name=None, codec_tag=None, codec_tag_string=None,
                 codec_time_base=None, duration=None, index=None, lang=None, start_time=None, timebase=None):
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format. Valid values:
        # 
        # - **srt**\
        # - **ass**\
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The duration. Unit: seconds.
        self.duration = duration  # type: str
        # The sequence number of the subtitle stream. The value indicates the position of the subtitle stream in all subtitle streams.
        self.index = index  # type: str
        # The language.
        self.lang = lang  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsSubtitleStreamListSubtitleStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(self, subtitle_stream=None):
        self.subtitle_stream = subtitle_stream  # type: list[QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsSubtitleStreamListSubtitleStream]

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsSubtitleStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(self, avg_bitrate=None, cost_bandwidth=None, preload_time=None):
        # The average bitrate.
        self.avg_bitrate = avg_bitrate  # type: str
        # The maximum bandwidth consumption.
        self.cost_bandwidth = cost_bandwidth  # type: str
        # The amount of preload time.
        self.preload_time = preload_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamListVideoStreamNetworkCost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(self, avg_fps=None, bitrate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, color_primaries=None, color_range=None, color_transfer=None, dar=None,
                 duration=None, fps=None, has_bframes=None, height=None, index=None, lang=None, level=None, network_cost=None,
                 num_frames=None, pix_fmt=None, profile=None, rotate=None, sar=None, start_time=None, timebase=None, width=None):
        # The average frame rate.
        self.avg_fps = avg_fps  # type: str
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format. Valid values:
        # 
        # *   **h264**\
        # *   **h265**\
        # *   **gif**\
        # *   **webp**\
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The level of color reconstruction.
        self.color_primaries = color_primaries  # type: str
        # The color range.
        self.color_range = color_range  # type: str
        # The color channel.
        self.color_transfer = color_transfer  # type: str
        # The display aspect ratio (DAR).
        self.dar = dar  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The frame rate.
        self.fps = fps  # type: str
        # Indicates whether the video stream contains bidirectional frames (B-frames). A value of 1 indicates that the video stream contains B-frames. A value of 0 indicates that the video stream does not contain B-frames.
        self.has_bframes = has_bframes  # type: str
        # The latter number in the video resolution. The number indicates the video height.
        self.height = height  # type: str
        # The sequence number of the video stream. The value indicates the position of the video stream in all video streams.
        self.index = index  # type: str
        # The language.
        self.lang = lang  # type: str
        # The codec level.
        self.level = level  # type: str
        # The network bandwidth consumption.
        self.network_cost = network_cost  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamListVideoStreamNetworkCost
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The pixel format.
        self.pix_fmt = pix_fmt  # type: str
        # The codec profile.
        self.profile = profile  # type: str
        # The video rotation angle.
        self.rotate = rotate  # type: str
        # The sample aspect ratio (SAR).
        self.sar = sar  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str
        # The former number in the video resolution. The number indicates the video width.
        self.width = width  # type: str

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamListVideoStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.color_primaries is not None:
            result['ColorPrimaries'] = self.color_primaries
        if self.color_range is not None:
            result['ColorRange'] = self.color_range
        if self.color_transfer is not None:
            result['ColorTransfer'] = self.color_transfer
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('ColorPrimaries') is not None:
            self.color_primaries = m.get('ColorPrimaries')
        if m.get('ColorRange') is not None:
            self.color_range = m.get('ColorRange')
        if m.get('ColorTransfer') is not None:
            self.color_transfer = m.get('ColorTransfer')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NetworkCost') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(self, video_stream=None):
        self.video_stream = video_stream  # type: list[QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamListVideoStream]

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreams(TeaModel):
    def __init__(self, audio_stream_list=None, subtitle_stream_list=None, video_stream_list=None):
        # The information about each audio stream.
        self.audio_stream_list = audio_stream_list  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsAudioStreamList
        # The information about each subtitle stream.
        self.subtitle_stream_list = subtitle_stream_list  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsSubtitleStreamList
        # The information about each video stream.
        self.video_stream_list = video_stream_list  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamList

    def validate(self):
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()
        if self.video_stream_list:
            self.video_stream_list.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        if m.get('VideoStreamList') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobProperties(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_format=None, file_size=None, format=None, fps=None,
                 height=None, streams=None, width=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The file format.
        self.file_format = file_format  # type: str
        # The size of the file.
        self.file_size = file_size  # type: str
        # The format information.
        self.format = format  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesFormat
        # The frame rate.
        self.fps = fps  # type: str
        # The height of the video. Unit: pixel.
        self.height = height  # type: str
        # The stream information.
        self.streams = streams  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreams
        # The width of the video. Unit: pixel.
        self.width = width  # type: str

    def validate(self):
        if self.format:
            self.format.validate()
        if self.streams:
            self.streams.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobProperties, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('Format') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Streams') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJob(TeaModel):
    def __init__(self, async=None, code=None, creation_time=None, input=None, job_id=None, mnsmessage_result=None,
                 message=None, pipeline_id=None, properties=None, state=None, user_data=None):
        # Indicates whether the job is in asynchronous mode.
        self.async = async  # type: bool
        # The error code returned when the job fails.
        self.code = code  # type: str
        # The time when the job was created.
        self.creation_time = creation_time  # type: str
        # The information about the job input.
        self.input = input  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobInput
        # The ID of the job.
        self.job_id = job_id  # type: str
        # The message sent by Message Service (MNS) to notify users of the job result.
        self.mnsmessage_result = mnsmessage_result  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobMNSMessageResult
        # The error message returned when the job fails.
        self.message = message  # type: str
        # The ID of the MPS queue to which the job is added.
        self.pipeline_id = pipeline_id  # type: str
        # The information about the input file. For more information, see [AliyunProperties](~~29251~~).
        self.properties = properties  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobProperties
        # The status of the job. Valid values:
        # 
        # *   **Analyzing**: The job is being run.
        # *   **Success**: The job is successful.
        # *   **Fail**: The job fails.
        self.state = state  # type: str
        # The custom data.
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.properties:
            self.properties.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async is not None:
            result['Async'] = self.async
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async = m.get('Async')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Input') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Properties') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJobProperties()
            self.properties = temp_model.from_map(m['Properties'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryMediaInfoJobListResponseBodyMediaInfoJobList(TeaModel):
    def __init__(self, media_info_job=None):
        self.media_info_job = media_info_job  # type: list[QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJob]

    def validate(self):
        if self.media_info_job:
            for k in self.media_info_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyMediaInfoJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaInfoJob'] = []
        if self.media_info_job is not None:
            for k in self.media_info_job:
                result['MediaInfoJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_info_job = []
        if m.get('MediaInfoJob') is not None:
            for k in m.get('MediaInfoJob'):
                temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobListMediaInfoJob()
                self.media_info_job.append(temp_model.from_map(k))
        return self


class QueryMediaInfoJobListResponseBodyNonExistMediaInfoJobIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBodyNonExistMediaInfoJobIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryMediaInfoJobListResponseBody(TeaModel):
    def __init__(self, media_info_job_list=None, non_exist_media_info_job_ids=None, request_id=None):
        # The details of each returned media information analysis job.
        self.media_info_job_list = media_info_job_list  # type: QueryMediaInfoJobListResponseBodyMediaInfoJobList
        # The IDs of the media information analysis jobs that do not exist. If all specified jobs exist, the response does not contain this parameter.
        self.non_exist_media_info_job_ids = non_exist_media_info_job_ids  # type: QueryMediaInfoJobListResponseBodyNonExistMediaInfoJobIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_info_job_list:
            self.media_info_job_list.validate()
        if self.non_exist_media_info_job_ids:
            self.non_exist_media_info_job_ids.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_info_job_list is not None:
            result['MediaInfoJobList'] = self.media_info_job_list.to_map()
        if self.non_exist_media_info_job_ids is not None:
            result['NonExistMediaInfoJobIds'] = self.non_exist_media_info_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaInfoJobList') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyMediaInfoJobList()
            self.media_info_job_list = temp_model.from_map(m['MediaInfoJobList'])
        if m.get('NonExistMediaInfoJobIds') is not None:
            temp_model = QueryMediaInfoJobListResponseBodyNonExistMediaInfoJobIds()
            self.non_exist_media_info_job_ids = temp_model.from_map(m['NonExistMediaInfoJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMediaInfoJobListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryMediaInfoJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryMediaInfoJobListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryMediaInfoJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaListRequest(TeaModel):
    def __init__(self, include_media_info=None, include_play_list=None, include_snapshot_list=None,
                 include_summary_list=None, media_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # Specifies whether to include media information in the returned result.
        # 
        # *   Valid values: true and false.
        # *   Default value: **false**.
        self.include_media_info = include_media_info  # type: bool
        # Specifies whether to include playback information in the returned result.
        # 
        # *   Valid values: true and false.
        # *   Default value: **false**.
        self.include_play_list = include_play_list  # type: bool
        # Specifies whether to include snapshot information in the returned result.
        # 
        # *   Valid values: true and false.
        # *   Default value: **false**.
        self.include_snapshot_list = include_snapshot_list  # type: bool
        # Specifies whether to include summaries in the returned result.
        # 
        # *   Valid values: true and false.
        # *   Default value: **false**.
        self.include_summary_list = include_summary_list  # type: bool
        # The IDs of the media files. To obtain the ID of a media file, you can perform the following operations in the ApsaraVideo Media Processing (MPS) console: In the left-side navigation pane, choose **Media Management** > **Media List**. Find the required video and click Manage. The ID of the video is displayed on the Basics tab. Separate multiple IDs with commas (,). You can query up to 10 media files at a time.
        self.media_ids = media_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.include_media_info is not None:
            result['IncludeMediaInfo'] = self.include_media_info
        if self.include_play_list is not None:
            result['IncludePlayList'] = self.include_play_list
        if self.include_snapshot_list is not None:
            result['IncludeSnapshotList'] = self.include_snapshot_list
        if self.include_summary_list is not None:
            result['IncludeSummaryList'] = self.include_summary_list
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IncludeMediaInfo') is not None:
            self.include_media_info = m.get('IncludeMediaInfo')
        if m.get('IncludePlayList') is not None:
            self.include_play_list = m.get('IncludePlayList')
        if m.get('IncludeSnapshotList') is not None:
            self.include_snapshot_list = m.get('IncludeSnapshotList')
        if m.get('IncludeSummaryList') is not None:
            self.include_summary_list = m.get('IncludeSummaryList')
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryMediaListResponseBodyMediaListMediaFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the input file. Valid values:
        # 
        # *   **Normal**: normal
        # *   **Deleted**: deleted
        self.state = state  # type: str
        # The OSS URL of the input file.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoFormat(TeaModel):
    def __init__(self, bitrate=None, duration=None, format_long_name=None, format_name=None, num_programs=None,
                 num_streams=None, size=None, start_time=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The total duration.
        self.duration = duration  # type: str
        # The full name of the container format.
        self.format_long_name = format_long_name  # type: str
        # The short name of the container format. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format_name = format_name  # type: str
        # The total number of program streams.
        self.num_programs = num_programs  # type: str
        # The total number of media streams.
        self.num_streams = num_streams  # type: str
        # The size of the file.
        self.size = size  # type: str
        # The start time.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 num_frames=None, sample_fmt=None, samplerate=None, start_time=None, timebase=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The output layout of the sound channels.
        self.channel_layout = channel_layout  # type: str
        # The number of sound channels.
        self.channels = channels  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format. Valid values: H264, mov, aac, avc, and mpeg.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The sequence number of the audio stream. The value indicates the position of the audio stream in all audio streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg documentation](https://www.ffmpeg.org/ffmpeg-all.html#Metadata).
        self.lang = lang  # type: str
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The sampling format.
        self.sample_fmt = sample_fmt  # type: str
        # The sampling rate.
        self.samplerate = samplerate  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsAudioStreamListAudioStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsAudioStreamList(TeaModel):
    def __init__(self, audio_stream=None):
        self.audio_stream = audio_stream  # type: list[QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsAudioStreamListAudioStream]

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsAudioStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(self, index=None, lang=None):
        # The sequence number of the subtitle stream. The value indicates the position of the subtitle stream in all subtitle streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg documentation](https://www.ffmpeg.org/ffmpeg-all.html#Metadata).
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamListSubtitleStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamList(TeaModel):
    def __init__(self, subtitle_stream=None):
        self.subtitle_stream = subtitle_stream  # type: list[QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamListSubtitleStream]

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(self, avg_bitrate=None, cost_bandwidth=None, preload_time=None):
        # The average bitrate.
        self.avg_bitrate = avg_bitrate  # type: str
        # The maximum bandwidth that was consumed.
        self.cost_bandwidth = cost_bandwidth  # type: str
        # The amount of preload time.
        self.preload_time = preload_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStreamNetworkCost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(self, avg_fps=None, bitrate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, network_cost=None, num_frames=None, pix_fmt=None, profile=None,
                 rotate=None, sar=None, start_time=None, timebase=None, width=None):
        # The average frame rate.
        self.avg_fps = avg_fps  # type: str
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The display aspect ratio (DAR).
        self.dar = dar  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The frame rate.
        self.fps = fps  # type: str
        # Indicates whether the video stream contains bidirectional frames (B-frames). A value of **1** indicates that the video stream contains B-frames. A value of **2** indicates that the video stream does not contain B-frames.
        self.has_bframes = has_bframes  # type: str
        # The latter number in the video resolution. The number indicates the video height.
        self.height = height  # type: str
        # The sequence number of the video stream. The value indicates the position of the video stream in all video streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg documentation](https://www.ffmpeg.org/ffmpeg-all.html#Metadata).
        self.lang = lang  # type: str
        # The codec level.
        self.level = level  # type: str
        # The network bandwidth consumption.
        self.network_cost = network_cost  # type: QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStreamNetworkCost
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The pixel format.
        self.pix_fmt = pix_fmt  # type: str
        # The codec profile.
        self.profile = profile  # type: str
        # The video rotation angle.
        self.rotate = rotate  # type: str
        # The sample aspect ratio (SAR).
        self.sar = sar  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str
        # The former number in the video resolution. The number indicates the video width.
        self.width = width  # type: str

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NetworkCost') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamList(TeaModel):
    def __init__(self, video_stream=None):
        self.video_stream = video_stream  # type: list[QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStream]

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfoStreams(TeaModel):
    def __init__(self, audio_stream_list=None, subtitle_stream_list=None, video_stream_list=None):
        # The list of audio streams.
        self.audio_stream_list = audio_stream_list  # type: QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsAudioStreamList
        # The list of subtitle streams.
        self.subtitle_stream_list = subtitle_stream_list  # type: QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamList
        # The list of video streams.
        self.video_stream_list = video_stream_list  # type: QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamList

    def validate(self):
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()
        if self.video_stream_list:
            self.video_stream_list.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfoStreams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        if m.get('VideoStreamList') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        return self


class QueryMediaListResponseBodyMediaListMediaMediaInfo(TeaModel):
    def __init__(self, format=None, streams=None):
        # The format information.
        self.format = format  # type: QueryMediaListResponseBodyMediaListMediaMediaInfoFormat
        # The stream information.
        self.streams = streams  # type: QueryMediaListResponseBodyMediaListMediaMediaInfoStreams

    def validate(self):
        if self.format:
            self.format.validate()
        if self.streams:
            self.streams.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaMediaInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('Streams') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfoStreams()
            self.streams = temp_model.from_map(m['Streams'])
        return self


class QueryMediaListResponseBodyMediaListMediaPlayListPlayFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the file. Valid values:
        # 
        # *   **Normal**: normal
        # *   **Deleted**: deleted
        self.state = state  # type: str
        # The Object Storage Service (OSS) URL of the output file.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaPlayListPlayFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class QueryMediaListResponseBodyMediaListMediaPlayListPlay(TeaModel):
    def __init__(self, activity_name=None, bitrate=None, duration=None, encryption=None, file=None, format=None,
                 fps=None, height=None, media_workflow_id=None, media_workflow_name=None, size=None, width=None):
        # The name of the workflow activity.
        self.activity_name = activity_name  # type: str
        # The bitrate of the media file.
        self.bitrate = bitrate  # type: str
        # The duration of the media file.
        self.duration = duration  # type: str
        # Indicates whether the media file is encrypted. Valid values:
        # 
        # *   **0**: The media file is not encrypted.
        # *   **1**: The media file is encrypted.
        self.encryption = encryption  # type: str
        # The playback file.
        self.file = file  # type: QueryMediaListResponseBodyMediaListMediaPlayListPlayFile
        # The encoding format of the media file. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format = format  # type: str
        # The frame rate of the media file.
        self.fps = fps  # type: str
        # The height.
        self.height = height  # type: str
        # The ID of the workflow that generates the playback file.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the workflow that generates the playback file.
        self.media_workflow_name = media_workflow_name  # type: str
        # The size of the media file.
        self.size = size  # type: str
        # The width of the media file.
        self.width = width  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaPlayListPlay, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_name is not None:
            result['ActivityName'] = self.activity_name
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.encryption is not None:
            result['Encryption'] = self.encryption
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_name is not None:
            result['MediaWorkflowName'] = self.media_workflow_name
        if self.size is not None:
            result['Size'] = self.size
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityName') is not None:
            self.activity_name = m.get('ActivityName')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Encryption') is not None:
            self.encryption = m.get('Encryption')
        if m.get('File') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaPlayListPlayFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowName') is not None:
            self.media_workflow_name = m.get('MediaWorkflowName')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryMediaListResponseBodyMediaListMediaPlayList(TeaModel):
    def __init__(self, play=None):
        self.play = play  # type: list[QueryMediaListResponseBodyMediaListMediaPlayListPlay]

    def validate(self):
        if self.play:
            for k in self.play:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaPlayList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Play'] = []
        if self.play is not None:
            for k in self.play:
                result['Play'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.play = []
        if m.get('Play') is not None:
            for k in m.get('Play'):
                temp_model = QueryMediaListResponseBodyMediaListMediaPlayListPlay()
                self.play.append(temp_model.from_map(k))
        return self


class QueryMediaListResponseBodyMediaListMediaRunIdList(TeaModel):
    def __init__(self, run_id=None):
        self.run_id = run_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaRunIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.run_id is not None:
            result['RunId'] = self.run_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        return self


class QueryMediaListResponseBodyMediaListMediaSnapshotListSnapshotFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the file. Valid values:
        # 
        # - **Normal**: normal
        # - **Deleted**: deleted
        self.state = state  # type: str
        # The OSS URL of the snapshot.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaSnapshotListSnapshotFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class QueryMediaListResponseBodyMediaListMediaSnapshotListSnapshot(TeaModel):
    def __init__(self, activity_name=None, count=None, file=None, media_workflow_id=None, media_workflow_name=None,
                 type=None):
        # The name of the workflow activity that generates the snapshot.
        self.activity_name = activity_name  # type: str
        # The number of snapshots. This parameter is valid only when the value of the **Type** parameter is **Sequence**.
        self.count = count  # type: str
        # The snapshot.
        self.file = file  # type: QueryMediaListResponseBodyMediaListMediaSnapshotListSnapshotFile
        # The ID of the workflow that generates the snapshot.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the workflow that generates the snapshot.
        self.media_workflow_name = media_workflow_name  # type: str
        # The type of the snapshot. Valid values:
        # 
        # - **Single**\
        # - **Sequence**\
        self.type = type  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaSnapshotListSnapshot, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_name is not None:
            result['ActivityName'] = self.activity_name
        if self.count is not None:
            result['Count'] = self.count
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_name is not None:
            result['MediaWorkflowName'] = self.media_workflow_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityName') is not None:
            self.activity_name = m.get('ActivityName')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('File') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaSnapshotListSnapshotFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowName') is not None:
            self.media_workflow_name = m.get('MediaWorkflowName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryMediaListResponseBodyMediaListMediaSnapshotList(TeaModel):
    def __init__(self, snapshot=None):
        self.snapshot = snapshot  # type: list[QueryMediaListResponseBodyMediaListMediaSnapshotListSnapshot]

    def validate(self):
        if self.snapshot:
            for k in self.snapshot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaSnapshotList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Snapshot'] = []
        if self.snapshot is not None:
            for k in self.snapshot:
                result['Snapshot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.snapshot = []
        if m.get('Snapshot') is not None:
            for k in m.get('Snapshot'):
                temp_model = QueryMediaListResponseBodyMediaListMediaSnapshotListSnapshot()
                self.snapshot.append(temp_model.from_map(k))
        return self


class QueryMediaListResponseBodyMediaListMediaSummaryListSummaryFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the file. Valid values:
        # 
        # *   **Normal**: normal
        # *   **Deleted**: deleted
        self.state = state  # type: str
        # The OSS URL of the input file.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaSummaryListSummaryFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class QueryMediaListResponseBodyMediaListMediaSummaryListSummary(TeaModel):
    def __init__(self, activity_name=None, file=None, media_workflow_id=None, media_workflow_name=None, type=None):
        # The name of the workflow activity.
        self.activity_name = activity_name  # type: str
        # The information about the input file.
        self.file = file  # type: QueryMediaListResponseBodyMediaListMediaSummaryListSummaryFile
        # The ID of the workflow that generates the summary.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the workflow that generates the summary.
        self.media_workflow_name = media_workflow_name  # type: str
        # The type of the summary. Valid values:
        # 
        # *   **Video**: video
        # *   **Gif**: dynamic image
        self.type = type  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaSummaryListSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_name is not None:
            result['ActivityName'] = self.activity_name
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_name is not None:
            result['MediaWorkflowName'] = self.media_workflow_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityName') is not None:
            self.activity_name = m.get('ActivityName')
        if m.get('File') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaSummaryListSummaryFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowName') is not None:
            self.media_workflow_name = m.get('MediaWorkflowName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryMediaListResponseBodyMediaListMediaSummaryList(TeaModel):
    def __init__(self, summary=None):
        self.summary = summary  # type: list[QueryMediaListResponseBodyMediaListMediaSummaryListSummary]

    def validate(self):
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaSummaryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = QueryMediaListResponseBodyMediaListMediaSummaryListSummary()
                self.summary.append(temp_model.from_map(k))
        return self


class QueryMediaListResponseBodyMediaListMediaTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMediaTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class QueryMediaListResponseBodyMediaListMedia(TeaModel):
    def __init__(self, bitrate=None, cate_id=None, censor_state=None, cover_url=None, creation_time=None,
                 description=None, duration=None, file=None, format=None, fps=None, height=None, media_id=None, media_info=None,
                 play_list=None, publish_state=None, run_id_list=None, size=None, snapshot_list=None, summary_list=None,
                 tags=None, title=None, width=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The ID of the category to which the media file belongs.
        self.cate_id = cate_id  # type: long
        # The review status of the media file. Valid values:
        # 
        # *   **Initiated**: The media file is uploaded but not reviewed.
        # *   **Pass**: The media file is uploaded and passes the review.
        self.censor_state = censor_state  # type: str
        # The OSS URL of the thumbnail.
        self.cover_url = cover_url  # type: str
        # The time when the media file was created.
        self.creation_time = creation_time  # type: str
        # The description.
        self.description = description  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The details of the input file.
        self.file = file  # type: QueryMediaListResponseBodyMediaListMediaFile
        # The encoding format. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format = format  # type: str
        # The frame rate.
        self.fps = fps  # type: str
        # The height of the media file.
        self.height = height  # type: str
        # The ID of the media file.
        self.media_id = media_id  # type: str
        # The media information.
        self.media_info = media_info  # type: QueryMediaListResponseBodyMediaListMediaMediaInfo
        # The playlist.
        self.play_list = play_list  # type: QueryMediaListResponseBodyMediaListMediaPlayList
        # The publishing status of the media file. Valid values:
        # 
        # - **Initiated**: The media file is in the initial state.
        # - **UnPublish**: The media file has not been published, and the playback permission on the OSS object is Private.
        # - **Published**: The media file has been published, and the playback permission on the OSS object is Default.
        # - **Deleted**: The media file has been deleted.
        self.publish_state = publish_state  # type: str
        # The ID of the instance.
        self.run_id_list = run_id_list  # type: QueryMediaListResponseBodyMediaListMediaRunIdList
        # The size of the file.
        self.size = size  # type: str
        # The list of snapshots.
        self.snapshot_list = snapshot_list  # type: QueryMediaListResponseBodyMediaListMediaSnapshotList
        # The list of video summaries.
        self.summary_list = summary_list  # type: QueryMediaListResponseBodyMediaListMediaSummaryList
        # The tags of the media file.
        self.tags = tags  # type: QueryMediaListResponseBodyMediaListMediaTags
        # The title.
        self.title = title  # type: str
        # The width.
        self.width = width  # type: str

    def validate(self):
        if self.file:
            self.file.validate()
        if self.media_info:
            self.media_info.validate()
        if self.play_list:
            self.play_list.validate()
        if self.run_id_list:
            self.run_id_list.validate()
        if self.snapshot_list:
            self.snapshot_list.validate()
        if self.summary_list:
            self.summary_list.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaListMedia, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.censor_state is not None:
            result['CensorState'] = self.censor_state
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_info is not None:
            result['MediaInfo'] = self.media_info.to_map()
        if self.play_list is not None:
            result['PlayList'] = self.play_list.to_map()
        if self.publish_state is not None:
            result['PublishState'] = self.publish_state
        if self.run_id_list is not None:
            result['RunIdList'] = self.run_id_list.to_map()
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_list is not None:
            result['SnapshotList'] = self.snapshot_list.to_map()
        if self.summary_list is not None:
            result['SummaryList'] = self.summary_list.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CensorState') is not None:
            self.censor_state = m.get('CensorState')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('File') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaInfo') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaMediaInfo()
            self.media_info = temp_model.from_map(m['MediaInfo'])
        if m.get('PlayList') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaPlayList()
            self.play_list = temp_model.from_map(m['PlayList'])
        if m.get('PublishState') is not None:
            self.publish_state = m.get('PublishState')
        if m.get('RunIdList') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaRunIdList()
            self.run_id_list = temp_model.from_map(m['RunIdList'])
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotList') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaSnapshotList()
            self.snapshot_list = temp_model.from_map(m['SnapshotList'])
        if m.get('SummaryList') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaSummaryList()
            self.summary_list = temp_model.from_map(m['SummaryList'])
        if m.get('Tags') is not None:
            temp_model = QueryMediaListResponseBodyMediaListMediaTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryMediaListResponseBodyMediaList(TeaModel):
    def __init__(self, media=None):
        self.media = media  # type: list[QueryMediaListResponseBodyMediaListMedia]

    def validate(self):
        if self.media:
            for k in self.media:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBodyMediaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Media'] = []
        if self.media is not None:
            for k in self.media:
                result['Media'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media = []
        if m.get('Media') is not None:
            for k in m.get('Media'):
                temp_model = QueryMediaListResponseBodyMediaListMedia()
                self.media.append(temp_model.from_map(k))
        return self


class QueryMediaListResponseBodyNonExistMediaIds(TeaModel):
    def __init__(self, media_id=None):
        self.media_id = media_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListResponseBodyNonExistMediaIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class QueryMediaListResponseBody(TeaModel):
    def __init__(self, media_list=None, non_exist_media_ids=None, request_id=None):
        # The list of media files.
        self.media_list = media_list  # type: QueryMediaListResponseBodyMediaList
        # The IDs of the media files that do not exist. This parameter is not returned when all specified media files exist.
        self.non_exist_media_ids = non_exist_media_ids  # type: QueryMediaListResponseBodyNonExistMediaIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_list:
            self.media_list.validate()
        if self.non_exist_media_ids:
            self.non_exist_media_ids.validate()

    def to_map(self):
        _map = super(QueryMediaListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_list is not None:
            result['MediaList'] = self.media_list.to_map()
        if self.non_exist_media_ids is not None:
            result['NonExistMediaIds'] = self.non_exist_media_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaList') is not None:
            temp_model = QueryMediaListResponseBodyMediaList()
            self.media_list = temp_model.from_map(m['MediaList'])
        if m.get('NonExistMediaIds') is not None:
            temp_model = QueryMediaListResponseBodyNonExistMediaIds()
            self.non_exist_media_ids = temp_model.from_map(m['NonExistMediaIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMediaListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryMediaListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryMediaListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryMediaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaListByURLRequest(TeaModel):
    def __init__(self, file_urls=None, include_media_info=None, include_play_list=None, include_snapshot_list=None,
                 include_summary_list=None, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The OSS URLs of the media files. To obtain the OSS URL of a media file, you can perform the following operations in the ApsaraVideo Media Processing (MPS) console: In the left-side navigation pane, choose **Media Management** > **Media List**. Find the media file whose OSS URL you want to view and click **Manage** in the **Actions** column. The OSS URL of the media file is displayed on the **Obtain Encoding URL** tab. Separate multiple URLs with commas (,). You can query up to 10 media files at a time.
        # 
        # *   The URL complies with RFC 3986 and is encoded in UTF-8, with reserved characters being percent-encoded. The value can be up to 3,200 bytes in size. For more information, see [URL encoding](~~423796~~).
        # *   Only OSS HTTP URLs are supported. Alibaba Cloud CDN URLs and HTTPS URLs are not supported.
        self.file_urls = file_urls  # type: str
        # Specifies whether to include media information in the returned result.
        # 
        # *   Valid values: true and false.
        # 
        # *   Default value: **false**.
        # 
        # > To obtain detailed information about the media files, set this parameter to true.
        self.include_media_info = include_media_info  # type: bool
        # Specifies whether to include playback information in the returned result.
        # 
        # *   Valid values: true and false.
        # *   Default value: **false**.
        self.include_play_list = include_play_list  # type: bool
        # Specifies whether to include snapshot information in the returned result.
        # 
        # *   Valid values: true and false.
        # *   Default value: **false**.
        self.include_snapshot_list = include_snapshot_list  # type: bool
        # Specifies whether to include summaries in the returned result.
        # 
        # *   Valid values: true and false.
        # *   Default value: **false**.
        self.include_summary_list = include_summary_list  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_urls is not None:
            result['FileURLs'] = self.file_urls
        if self.include_media_info is not None:
            result['IncludeMediaInfo'] = self.include_media_info
        if self.include_play_list is not None:
            result['IncludePlayList'] = self.include_play_list
        if self.include_snapshot_list is not None:
            result['IncludeSnapshotList'] = self.include_snapshot_list
        if self.include_summary_list is not None:
            result['IncludeSummaryList'] = self.include_summary_list
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileURLs') is not None:
            self.file_urls = m.get('FileURLs')
        if m.get('IncludeMediaInfo') is not None:
            self.include_media_info = m.get('IncludeMediaInfo')
        if m.get('IncludePlayList') is not None:
            self.include_play_list = m.get('IncludePlayList')
        if m.get('IncludeSnapshotList') is not None:
            self.include_snapshot_list = m.get('IncludeSnapshotList')
        if m.get('IncludeSummaryList') is not None:
            self.include_summary_list = m.get('IncludeSummaryList')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the media file. Valid values:
        # 
        # *   **Normal**: The file is normal.
        # *   **Deleted**: The file is deleted.
        self.state = state  # type: str
        # The OSS URL of the input file.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoFormat(TeaModel):
    def __init__(self, bitrate=None, duration=None, format_long_name=None, format_name=None, num_programs=None,
                 num_streams=None, size=None, start_time=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The full name of the encoding format.
        self.format_long_name = format_long_name  # type: str
        # The short name of the container format. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format_name = format_name  # type: str
        # The total number of program streams.
        self.num_programs = num_programs  # type: str
        # The total number of media streams.
        self.num_streams = num_streams  # type: str
        # The size.
        self.size = size  # type: str
        # The start time.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 num_frames=None, sample_fmt=None, samplerate=None, start_time=None, timebase=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The output layout of the sound channels.
        self.channel_layout = channel_layout  # type: str
        # The number of sound channels.
        self.channels = channels  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format. Valid values: H264, mov, aac, avc, and mpeg.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The duration of the media file.
        self.duration = duration  # type: str
        # The sequence number of the audio stream. The value indicates the position of the audio stream in all audio streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg language definition](https://www.ffmpeg.org/ffmpeg-all.html#Metadata).
        self.lang = lang  # type: str
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The sampling format.
        self.sample_fmt = sample_fmt  # type: str
        # The sampling rate.
        self.samplerate = samplerate  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsAudioStreamListAudioStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsAudioStreamList(TeaModel):
    def __init__(self, audio_stream=None):
        self.audio_stream = audio_stream  # type: list[QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsAudioStreamListAudioStream]

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsAudioStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(self, index=None, lang=None):
        # The sequence number of the subtitle stream. The value indicates the position of the subtitle stream in all subtitle streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg language definition](https://www.ffmpeg.org/ffmpeg-all.html#Metadata).
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamListSubtitleStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamList(TeaModel):
    def __init__(self, subtitle_stream=None):
        self.subtitle_stream = subtitle_stream  # type: list[QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamListSubtitleStream]

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(self, avg_bitrate=None, cost_bandwidth=None, preload_time=None):
        # The average bitrate of the video stream.
        self.avg_bitrate = avg_bitrate  # type: str
        # The maximum bandwidth that was consumed.
        self.cost_bandwidth = cost_bandwidth  # type: str
        # The amount of preload time.
        self.preload_time = preload_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStreamNetworkCost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(self, avg_fps=None, bitrate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, network_cost=None, num_frames=None, pix_fmt=None, profile=None,
                 rotate=None, sar=None, start_time=None, timebase=None, width=None):
        # The average frame rate.
        self.avg_fps = avg_fps  # type: str
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The full name of the encoding format.
        self.codec_long_name = codec_long_name  # type: str
        # The short name of the encoding format. Valid values: H264, mov, aac, avc, and mpeg.
        self.codec_name = codec_name  # type: str
        # The tag of the encoding format.
        self.codec_tag = codec_tag  # type: str
        # The tag string of the encoding format.
        self.codec_tag_string = codec_tag_string  # type: str
        # The codec time base.
        self.codec_time_base = codec_time_base  # type: str
        # The display aspect ratio (DAR) of the video stream.
        self.dar = dar  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The frame rate.
        self.fps = fps  # type: str
        # Indicates whether the video stream contains bidirectional frames (B-frames). A value of **1** indicates that the video stream contains B-frames. A value of **2** indicates that the video stream does not contain B-frames.
        self.has_bframes = has_bframes  # type: str
        # The latter number in the video resolution. The number indicates the video height.
        self.height = height  # type: str
        # The sequence number of the video stream. The value indicates the position of the video stream in all video streams.
        self.index = index  # type: str
        # The language. For more information, see [FFmpeg documentation](https://www.ffmpeg.org/ffmpeg-all.html#Metadata).
        self.lang = lang  # type: str
        # The codec level.
        self.level = level  # type: str
        # The network bandwidth consumption.
        self.network_cost = network_cost  # type: QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStreamNetworkCost
        # The total number of frames.
        self.num_frames = num_frames  # type: str
        # The pixel format of the video stream.
        self.pix_fmt = pix_fmt  # type: str
        # The codec profile.
        self.profile = profile  # type: str
        # The rotation angle of the video.
        self.rotate = rotate  # type: str
        # The sample aspect ratio (SAR).
        self.sar = sar  # type: str
        # The start time.
        self.start_time = start_time  # type: str
        # The time base.
        self.timebase = timebase  # type: str
        # The former number in the video resolution. The number indicates the video width and cannot be negative.
        self.width = width  # type: str

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NetworkCost') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamList(TeaModel):
    def __init__(self, video_stream=None):
        self.video_stream = video_stream  # type: list[QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStream]

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreams(TeaModel):
    def __init__(self, audio_stream_list=None, subtitle_stream_list=None, video_stream_list=None):
        # The list of audio streams.
        self.audio_stream_list = audio_stream_list  # type: QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsAudioStreamList
        # The list of subtitle streams.
        self.subtitle_stream_list = subtitle_stream_list  # type: QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamList
        # The list of video streams.
        self.video_stream_list = video_stream_list  # type: QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamList

    def validate(self):
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()
        if self.video_stream_list:
            self.video_stream_list.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioStreamList') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        if m.get('VideoStreamList') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        return self


class QueryMediaListByURLResponseBodyMediaListMediaMediaInfo(TeaModel):
    def __init__(self, format=None, streams=None):
        # The format information.
        self.format = format  # type: QueryMediaListByURLResponseBodyMediaListMediaMediaInfoFormat
        # The stream information.
        self.streams = streams  # type: QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreams

    def validate(self):
        if self.format:
            self.format.validate()
        if self.streams:
            self.streams.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaMediaInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('Streams') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfoStreams()
            self.streams = temp_model.from_map(m['Streams'])
        return self


class QueryMediaListByURLResponseBodyMediaListMediaPlayListPlayFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the media file. Valid values:
        # 
        # *   **Normal**: The file is normal.
        # *   **Deleted**: The file is deleted.
        self.state = state  # type: str
        # The OSS URL of the playback file.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaPlayListPlayFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaPlayListPlay(TeaModel):
    def __init__(self, activity_name=None, bitrate=None, duration=None, encryption=None, file=None, format=None,
                 fps=None, height=None, media_workflow_id=None, media_workflow_name=None, size=None, width=None):
        # The name of the workflow activity.
        self.activity_name = activity_name  # type: str
        # The bitrate of the media file.
        self.bitrate = bitrate  # type: str
        # The duration.
        self.duration = duration  # type: str
        # Indicates whether the media file is encrypted. Valid values:
        # 
        # *   **0**: The media file is not encrypted.
        # *   **1**: The media file is encrypted.
        self.encryption = encryption  # type: str
        # The playback file.
        self.file = file  # type: QueryMediaListByURLResponseBodyMediaListMediaPlayListPlayFile
        # The encoding format of the media file. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format = format  # type: str
        # The frame rate.
        self.fps = fps  # type: str
        # The height of the media file.
        self.height = height  # type: str
        # The ID of the workflow that generates the playback file.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the workflow that generates the playback file.
        self.media_workflow_name = media_workflow_name  # type: str
        # The size.
        self.size = size  # type: str
        # The width.
        self.width = width  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaPlayListPlay, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_name is not None:
            result['ActivityName'] = self.activity_name
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.encryption is not None:
            result['Encryption'] = self.encryption
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_name is not None:
            result['MediaWorkflowName'] = self.media_workflow_name
        if self.size is not None:
            result['Size'] = self.size
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityName') is not None:
            self.activity_name = m.get('ActivityName')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Encryption') is not None:
            self.encryption = m.get('Encryption')
        if m.get('File') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaPlayListPlayFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowName') is not None:
            self.media_workflow_name = m.get('MediaWorkflowName')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaPlayList(TeaModel):
    def __init__(self, play=None):
        self.play = play  # type: list[QueryMediaListByURLResponseBodyMediaListMediaPlayListPlay]

    def validate(self):
        if self.play:
            for k in self.play:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaPlayList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Play'] = []
        if self.play is not None:
            for k in self.play:
                result['Play'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.play = []
        if m.get('Play') is not None:
            for k in m.get('Play'):
                temp_model = QueryMediaListByURLResponseBodyMediaListMediaPlayListPlay()
                self.play.append(temp_model.from_map(k))
        return self


class QueryMediaListByURLResponseBodyMediaListMediaRunIdList(TeaModel):
    def __init__(self, run_id=None):
        self.run_id = run_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaRunIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.run_id is not None:
            result['RunId'] = self.run_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaSnapshotListSnapshotFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the file. Valid values:
        # 
        # - **Normal**: The file is normal.
        # - **Deleted**: The file is deleted.
        self.state = state  # type: str
        # The OSS URL of the snapshot.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaSnapshotListSnapshotFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaSnapshotListSnapshot(TeaModel):
    def __init__(self, activity_name=None, count=None, file=None, media_workflow_id=None, media_workflow_name=None,
                 type=None):
        # The name of the workflow activity that generates the snapshot.
        self.activity_name = activity_name  # type: str
        # The number of snapshots. This parameter is valid only when the value of the **Type** parameter is **Sequence**.
        self.count = count  # type: str
        # The snapshot.
        self.file = file  # type: QueryMediaListByURLResponseBodyMediaListMediaSnapshotListSnapshotFile
        # The ID of the workflow that generates the snapshot.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the workflow that generates the snapshot.
        self.media_workflow_name = media_workflow_name  # type: str
        # The type of the snapshot. Valid values:
        # 
        # - **Single**: a single snapshot
        # - **Sequence**: snapshots in sequence
        self.type = type  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaSnapshotListSnapshot, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_name is not None:
            result['ActivityName'] = self.activity_name
        if self.count is not None:
            result['Count'] = self.count
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_name is not None:
            result['MediaWorkflowName'] = self.media_workflow_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityName') is not None:
            self.activity_name = m.get('ActivityName')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('File') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaSnapshotListSnapshotFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowName') is not None:
            self.media_workflow_name = m.get('MediaWorkflowName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaSnapshotList(TeaModel):
    def __init__(self, snapshot=None):
        self.snapshot = snapshot  # type: list[QueryMediaListByURLResponseBodyMediaListMediaSnapshotListSnapshot]

    def validate(self):
        if self.snapshot:
            for k in self.snapshot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaSnapshotList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Snapshot'] = []
        if self.snapshot is not None:
            for k in self.snapshot:
                result['Snapshot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.snapshot = []
        if m.get('Snapshot') is not None:
            for k in m.get('Snapshot'):
                temp_model = QueryMediaListByURLResponseBodyMediaListMediaSnapshotListSnapshot()
                self.snapshot.append(temp_model.from_map(k))
        return self


class QueryMediaListByURLResponseBodyMediaListMediaSummaryListSummaryFile(TeaModel):
    def __init__(self, state=None, url=None):
        # The status of the media file. Valid values:
        # 
        # *   **Normal**: The file is normal.
        # *   **Deleted**: The file is deleted.
        self.state = state  # type: str
        # The OSS URL of the input file.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaSummaryListSummaryFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaSummaryListSummary(TeaModel):
    def __init__(self, activity_name=None, file=None, media_workflow_id=None, media_workflow_name=None, type=None):
        # The name of the workflow activity.
        self.activity_name = activity_name  # type: str
        # The information about the input file.
        self.file = file  # type: QueryMediaListByURLResponseBodyMediaListMediaSummaryListSummaryFile
        # The ID of the workflow that generates the summary.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the workflow that generates the summary.
        self.media_workflow_name = media_workflow_name  # type: str
        # The type of the summary. Valid values:
        # 
        # *   **Video**: video
        # *   **Gif**: dynamic image
        self.type = type  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaSummaryListSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_name is not None:
            result['ActivityName'] = self.activity_name
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.media_workflow_name is not None:
            result['MediaWorkflowName'] = self.media_workflow_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityName') is not None:
            self.activity_name = m.get('ActivityName')
        if m.get('File') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaSummaryListSummaryFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('MediaWorkflowName') is not None:
            self.media_workflow_name = m.get('MediaWorkflowName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryMediaListByURLResponseBodyMediaListMediaSummaryList(TeaModel):
    def __init__(self, summary=None):
        self.summary = summary  # type: list[QueryMediaListByURLResponseBodyMediaListMediaSummaryListSummary]

    def validate(self):
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaSummaryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = QueryMediaListByURLResponseBodyMediaListMediaSummaryListSummary()
                self.summary.append(temp_model.from_map(k))
        return self


class QueryMediaListByURLResponseBodyMediaListMediaTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMediaTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class QueryMediaListByURLResponseBodyMediaListMedia(TeaModel):
    def __init__(self, bitrate=None, cate_id=None, censor_state=None, cover_url=None, creation_time=None,
                 description=None, duration=None, file=None, format=None, fps=None, height=None, media_id=None, media_info=None,
                 play_list=None, publish_state=None, run_id_list=None, size=None, snapshot_list=None, summary_list=None,
                 tags=None, title=None, width=None):
        # The bitrate.
        self.bitrate = bitrate  # type: str
        # The ID of the category to which the media file belongs.
        self.cate_id = cate_id  # type: long
        # The review status of the media file. Valid values:
        # 
        # *   **Initiated**: The media file is uploaded but not reviewed.
        # *   **Pass**: The media file is uploaded and passes the review.
        self.censor_state = censor_state  # type: str
        # The OSS URL of the thumbnail.
        self.cover_url = cover_url  # type: str
        # The time when the media file was created.
        self.creation_time = creation_time  # type: str
        # The description.
        self.description = description  # type: str
        # The duration.
        self.duration = duration  # type: str
        # The details of the input file.
        self.file = file  # type: QueryMediaListByURLResponseBodyMediaListMediaFile
        # The encoding format. Valid values: mov, mp4, m4a, 3gp, 3g2, and mj2.
        self.format = format  # type: str
        # The frame rate.
        self.fps = fps  # type: str
        # The height of the queried media file.
        self.height = height  # type: str
        # The ID of the media file.
        self.media_id = media_id  # type: str
        # The media information.
        self.media_info = media_info  # type: QueryMediaListByURLResponseBodyMediaListMediaMediaInfo
        # The playlist.
        self.play_list = play_list  # type: QueryMediaListByURLResponseBodyMediaListMediaPlayList
        # The publishing status of the media file. Valid values:
        # 
        # - **Initiated**: The media file is in the initial state.
        # - **UnPublish**: The media file has not been published, and the playback permission on the OSS object is Private.
        # - **Published**: The media file has been published, and the playback permission on the OSS object is Default.
        # - **Deleted**: The file is deleted.
        self.publish_state = publish_state  # type: str
        # The IDs of the media workflow execution instances.
        self.run_id_list = run_id_list  # type: QueryMediaListByURLResponseBodyMediaListMediaRunIdList
        # The size of the file.
        self.size = size  # type: str
        # The list of snapshots.
        self.snapshot_list = snapshot_list  # type: QueryMediaListByURLResponseBodyMediaListMediaSnapshotList
        # The list of video summaries.
        self.summary_list = summary_list  # type: QueryMediaListByURLResponseBodyMediaListMediaSummaryList
        # The tags of the media file.
        self.tags = tags  # type: QueryMediaListByURLResponseBodyMediaListMediaTags
        # The title.
        self.title = title  # type: str
        # The width.
        self.width = width  # type: str

    def validate(self):
        if self.file:
            self.file.validate()
        if self.media_info:
            self.media_info.validate()
        if self.play_list:
            self.play_list.validate()
        if self.run_id_list:
            self.run_id_list.validate()
        if self.snapshot_list:
            self.snapshot_list.validate()
        if self.summary_list:
            self.summary_list.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaListMedia, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.censor_state is not None:
            result['CensorState'] = self.censor_state
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_info is not None:
            result['MediaInfo'] = self.media_info.to_map()
        if self.play_list is not None:
            result['PlayList'] = self.play_list.to_map()
        if self.publish_state is not None:
            result['PublishState'] = self.publish_state
        if self.run_id_list is not None:
            result['RunIdList'] = self.run_id_list.to_map()
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_list is not None:
            result['SnapshotList'] = self.snapshot_list.to_map()
        if self.summary_list is not None:
            result['SummaryList'] = self.summary_list.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CensorState') is not None:
            self.censor_state = m.get('CensorState')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('File') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaInfo') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaMediaInfo()
            self.media_info = temp_model.from_map(m['MediaInfo'])
        if m.get('PlayList') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaPlayList()
            self.play_list = temp_model.from_map(m['PlayList'])
        if m.get('PublishState') is not None:
            self.publish_state = m.get('PublishState')
        if m.get('RunIdList') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaRunIdList()
            self.run_id_list = temp_model.from_map(m['RunIdList'])
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotList') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaSnapshotList()
            self.snapshot_list = temp_model.from_map(m['SnapshotList'])
        if m.get('SummaryList') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaSummaryList()
            self.summary_list = temp_model.from_map(m['SummaryList'])
        if m.get('Tags') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaListMediaTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class QueryMediaListByURLResponseBodyMediaList(TeaModel):
    def __init__(self, media=None):
        self.media = media  # type: list[QueryMediaListByURLResponseBodyMediaListMedia]

    def validate(self):
        if self.media:
            for k in self.media:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyMediaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Media'] = []
        if self.media is not None:
            for k in self.media:
                result['Media'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media = []
        if m.get('Media') is not None:
            for k in m.get('Media'):
                temp_model = QueryMediaListByURLResponseBodyMediaListMedia()
                self.media.append(temp_model.from_map(k))
        return self


class QueryMediaListByURLResponseBodyNonExistFileURLs(TeaModel):
    def __init__(self, file_url=None):
        self.file_url = file_url  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBodyNonExistFileURLs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        return self


class QueryMediaListByURLResponseBody(TeaModel):
    def __init__(self, media_list=None, non_exist_file_urls=None, request_id=None):
        # The list of media files.
        self.media_list = media_list  # type: QueryMediaListByURLResponseBodyMediaList
        # The IDs of the media files that do not exist. This parameter is not returned if all specified media files exist.
        self.non_exist_file_urls = non_exist_file_urls  # type: QueryMediaListByURLResponseBodyNonExistFileURLs
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_list:
            self.media_list.validate()
        if self.non_exist_file_urls:
            self.non_exist_file_urls.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_list is not None:
            result['MediaList'] = self.media_list.to_map()
        if self.non_exist_file_urls is not None:
            result['NonExistFileURLs'] = self.non_exist_file_urls.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaList') is not None:
            temp_model = QueryMediaListByURLResponseBodyMediaList()
            self.media_list = temp_model.from_map(m['MediaList'])
        if m.get('NonExistFileURLs') is not None:
            temp_model = QueryMediaListByURLResponseBodyNonExistFileURLs()
            self.non_exist_file_urls = temp_model.from_map(m['NonExistFileURLs'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMediaListByURLResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryMediaListByURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryMediaListByURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryMediaListByURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaWorkflowExecutionListRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 run_ids=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The IDs of the media workflow execution instances. To obtain the instance ID, log on to the **ApsaraVideo Media Processing (MPS) console** and choose **Workflows** > **Execution Instances** in the left-side navigation pane. Separate multiple IDs with commas (,). You can query a maximum of 10 media workflow execution instances at a time.
        self.run_ids = run_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.run_ids is not None:
            result['RunIds'] = self.run_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RunIds') is not None:
            self.run_ids = m.get('RunIds')
        return self


class QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult(TeaModel):
    def __init__(self, error_code=None, error_message=None, message_id=None):
        # The error code returned when the MNS message fails to be sent. This parameter is not returned if the MNS message is sent.
        self.error_code = error_code  # type: str
        # The error message returned when the MNS message fails to be sent. This parameter is not returned if the MNS message is sent.
        self.error_message = error_message  # type: str
        # The ID of the message that indicates the MNS message is sent. This parameter is not returned if the MNS message fails to be sent.
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity(TeaModel):
    def __init__(self, code=None, end_time=None, job_id=None, mnsmessage_result=None, message=None, name=None,
                 start_time=None, state=None, type=None):
        # The error code returned when the method fails to be called.
        # 
        # *   This parameter is returned only when **Fail** is returned for the State parameter.
        # *   ****\
        self.code = code  # type: str
        # The time when the method ends.
        self.end_time = end_time  # type: str
        # The IDs of the jobs that are generated when the methods are called. For example, job IDs for the analysis, transcode, and snapshot methods.
        self.job_id = job_id  # type: str
        # The message sent by Message Service (MNS) to notify the user of the job result.
        self.mnsmessage_result = mnsmessage_result  # type: QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult
        # The error message returned when the method fails to be called.
        # 
        # *   This parameter is returned only when **Fail** is returned for the State parameter.
        # *   ****\
        self.message = message  # type: str
        # The name of the method. 
        # 
        # >  The name of each method in a media workflow is unique.
        self.name = name  # type: str
        # The time when the method is called.
        self.start_time = start_time  # type: str
        # The status of the method. Valid values:
        # 
        # *   Running: The method is being called.
        # *   Success: The method is called.
        # *   Fail: The method failed to be called.
        # *   Skipped: The method is skipped.
        # 
        # >  For example, after the analysis is complete, the transcode method is called and high-definition and standard-definition transcoding jobs are created. The system determines whether to run the jobs based on the analysis result. If the resolution of the input video is low, the high-definition transcoding job may be skipped.
        self.state = state  # type: str
        # The methods that are supported in the media workflow. Valid values: Start, Snapshot, Transcode, Analysis, and Report. For more information, see [Methods supported for media workflows](~~68494~~).
        self.type = type  # type: str

    def validate(self):
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivityMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList(TeaModel):
    def __init__(self, activity=None):
        self.activity = activity  # type: list[QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity]

    def validate(self):
        if self.activity:
            for k in self.activity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Activity'] = []
        if self.activity is not None:
            for k in self.activity:
                result['Activity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.activity = []
        if m.get('Activity') is not None:
            for k in m.get('Activity'):
                temp_model = QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityListActivity()
                self.activity.append(temp_model.from_map(k))
        return self


class QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        # The name of the OSS bucket in which the input file is stored.
        self.bucket = bucket  # type: str
        # The ID of the region in which the input file resides.
        self.location = location  # type: str
        # The name of the Object Storage Service (OSS) object that is used as the input file.
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput(TeaModel):
    def __init__(self, input_file=None, user_data=None):
        # The input file of the media workflow.
        self.input_file = input_file  # type: QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile
        # The custom data.
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InputFile') is not None:
            temp_model = QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInputInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution(TeaModel):
    def __init__(self, activity_list=None, creation_time=None, input=None, media_id=None, media_workflow_id=None,
                 name=None, run_id=None, state=None):
        # The methods that are called in the media workflow.
        self.activity_list = activity_list  # type: QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList
        # The time when the media workflow was created.
        self.creation_time = creation_time  # type: str
        # The input data of the media workflow.
        self.input = input  # type: QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput
        # The ID of the media file. A media file contains all the information about a media workflow.
        self.media_id = media_id  # type: str
        # The ID of the media workflow.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the media workflow.
        self.name = name  # type: str
        # The ID of the execution instance.
        self.run_id = run_id  # type: str
        # The status of the media workflow. Valid values:
        # 
        # *   Running: The media workflow is running.
        # *   Completed: The media workflow is complete.
        # 
        # >  Completed only indicates that the media workflow is complete. View the status of each method in the workflow, such as the transcode and snapshot methods, to check whether the method is called.
        # 
        # *   Fail: The media workflow fails.
        self.state = state  # type: str

    def validate(self):
        if self.activity_list:
            self.activity_list.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_list is not None:
            result['ActivityList'] = self.activity_list.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.run_id is not None:
            result['RunId'] = self.run_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityList') is not None:
            temp_model = QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionActivityList()
            self.activity_list = temp_model.from_map(m['ActivityList'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Input') is not None:
            temp_model = QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecutionInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionList(TeaModel):
    def __init__(self, media_workflow_execution=None):
        self.media_workflow_execution = media_workflow_execution  # type: list[QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution]

    def validate(self):
        if self.media_workflow_execution:
            for k in self.media_workflow_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaWorkflowExecution'] = []
        if self.media_workflow_execution is not None:
            for k in self.media_workflow_execution:
                result['MediaWorkflowExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_workflow_execution = []
        if m.get('MediaWorkflowExecution') is not None:
            for k in m.get('MediaWorkflowExecution'):
                temp_model = QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionListMediaWorkflowExecution()
                self.media_workflow_execution.append(temp_model.from_map(k))
        return self


class QueryMediaWorkflowExecutionListResponseBodyNonExistRunIds(TeaModel):
    def __init__(self, run_id=None):
        self.run_id = run_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBodyNonExistRunIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.run_id is not None:
            result['RunId'] = self.run_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        return self


class QueryMediaWorkflowExecutionListResponseBody(TeaModel):
    def __init__(self, media_workflow_execution_list=None, non_exist_run_ids=None, request_id=None):
        # The details of the media workflows.
        self.media_workflow_execution_list = media_workflow_execution_list  # type: QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionList
        # The IDs of the execution instances that do not exist. null is returned if all specified execution instances exist.
        self.non_exist_run_ids = non_exist_run_ids  # type: QueryMediaWorkflowExecutionListResponseBodyNonExistRunIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_workflow_execution_list:
            self.media_workflow_execution_list.validate()
        if self.non_exist_run_ids:
            self.non_exist_run_ids.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_execution_list is not None:
            result['MediaWorkflowExecutionList'] = self.media_workflow_execution_list.to_map()
        if self.non_exist_run_ids is not None:
            result['NonExistRunIds'] = self.non_exist_run_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflowExecutionList') is not None:
            temp_model = QueryMediaWorkflowExecutionListResponseBodyMediaWorkflowExecutionList()
            self.media_workflow_execution_list = temp_model.from_map(m['MediaWorkflowExecutionList'])
        if m.get('NonExistRunIds') is not None:
            temp_model = QueryMediaWorkflowExecutionListResponseBodyNonExistRunIds()
            self.non_exist_run_ids = temp_model.from_map(m['NonExistRunIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMediaWorkflowExecutionListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryMediaWorkflowExecutionListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowExecutionListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryMediaWorkflowExecutionListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaWorkflowListRequest(TeaModel):
    def __init__(self, media_workflow_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The IDs of the media workflows that you want to query. To obtain the IDs of the media workflows, you can log on to the **ApsaraVideo Media Processing (MPS) console** and choose **Workflows** > **Workflow Settings** in the left-side navigation pane. You can query up to 10 media workflows at a time. Separate multiple IDs of media workflows with commas (,).
        self.media_workflow_ids = media_workflow_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaWorkflowListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_ids is not None:
            result['MediaWorkflowIds'] = self.media_workflow_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflowIds') is not None:
            self.media_workflow_ids = m.get('MediaWorkflowIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryMediaWorkflowListResponseBodyMediaWorkflowListMediaWorkflow(TeaModel):
    def __init__(self, creation_time=None, media_workflow_id=None, name=None, state=None, topology=None,
                 trigger_mode=None):
        # The time when the media workflow was created.
        self.creation_time = creation_time  # type: str
        # The ID of the media workflow.
        self.media_workflow_id = media_workflow_id  # type: str
        # The name of the media workflow.
        self.name = name  # type: str
        # The status of the media workflow. Valid values:
        # 
        # *   **Inactive**: The media workflow is deactivated.
        # *   **Active**: The media workflow is activated.
        # *   **Deleted**: The media workflow is deleted.
        self.state = state  # type: str
        # The topology of the media workflow.
        self.topology = topology  # type: str
        # The trigger mode of the media workflow. Valid values:
        # 
        # *   **OssAutoTrigger**: The media workflow is automatically triggered.
        # *   **NotInAuto**: The media workflow is not automatically triggered.
        self.trigger_mode = trigger_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaWorkflowListResponseBodyMediaWorkflowListMediaWorkflow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.topology is not None:
            result['Topology'] = self.topology
        if self.trigger_mode is not None:
            result['TriggerMode'] = self.trigger_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        if m.get('TriggerMode') is not None:
            self.trigger_mode = m.get('TriggerMode')
        return self


class QueryMediaWorkflowListResponseBodyMediaWorkflowList(TeaModel):
    def __init__(self, media_workflow=None):
        self.media_workflow = media_workflow  # type: list[QueryMediaWorkflowListResponseBodyMediaWorkflowListMediaWorkflow]

    def validate(self):
        if self.media_workflow:
            for k in self.media_workflow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowListResponseBodyMediaWorkflowList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaWorkflow'] = []
        if self.media_workflow is not None:
            for k in self.media_workflow:
                result['MediaWorkflow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_workflow = []
        if m.get('MediaWorkflow') is not None:
            for k in m.get('MediaWorkflow'):
                temp_model = QueryMediaWorkflowListResponseBodyMediaWorkflowListMediaWorkflow()
                self.media_workflow.append(temp_model.from_map(k))
        return self


class QueryMediaWorkflowListResponseBodyNonExistMediaWorkflowIds(TeaModel):
    def __init__(self, media_workflow_id=None):
        self.media_workflow_id = media_workflow_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaWorkflowListResponseBodyNonExistMediaWorkflowIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        return self


class QueryMediaWorkflowListResponseBody(TeaModel):
    def __init__(self, media_workflow_list=None, non_exist_media_workflow_ids=None, request_id=None):
        # The details of the media workflows.
        self.media_workflow_list = media_workflow_list  # type: QueryMediaWorkflowListResponseBodyMediaWorkflowList
        # The media workflow IDs that do not exist. This parameter is not returned if all specified media workflows are found.
        self.non_exist_media_workflow_ids = non_exist_media_workflow_ids  # type: QueryMediaWorkflowListResponseBodyNonExistMediaWorkflowIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_workflow_list:
            self.media_workflow_list.validate()
        if self.non_exist_media_workflow_ids:
            self.non_exist_media_workflow_ids.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_workflow_list is not None:
            result['MediaWorkflowList'] = self.media_workflow_list.to_map()
        if self.non_exist_media_workflow_ids is not None:
            result['NonExistMediaWorkflowIds'] = self.non_exist_media_workflow_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaWorkflowList') is not None:
            temp_model = QueryMediaWorkflowListResponseBodyMediaWorkflowList()
            self.media_workflow_list = temp_model.from_map(m['MediaWorkflowList'])
        if m.get('NonExistMediaWorkflowIds') is not None:
            temp_model = QueryMediaWorkflowListResponseBodyNonExistMediaWorkflowIds()
            self.non_exist_media_workflow_ids = temp_model.from_map(m['NonExistMediaWorkflowIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMediaWorkflowListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryMediaWorkflowListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryMediaWorkflowListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryMediaWorkflowListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryPipelineListRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, pipeline_ids=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The IDs of the MPS queues that you want to query. To view the IDs, you can log on to the **MPS console** and choose **Global Settings** > **Pipelines** in the left-side navigation pane. You can query up to 10 MPS queues at a time. Separate multiple IDs of MPS queues with commas (,).
        self.pipeline_ids = pipeline_ids  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryPipelineListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pipeline_ids is not None:
            result['PipelineIds'] = self.pipeline_ids
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PipelineIds') is not None:
            self.pipeline_ids = m.get('PipelineIds')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryPipelineListResponseBodyNonExistPids(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryPipelineListResponseBodyNonExistPids, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryPipelineListResponseBodyPipelineListPipelineExtendConfig(TeaModel):
    def __init__(self, is_boost_new=None, max_multi_speed=None, multi_speed_downgrade_policy=None):
        self.is_boost_new = is_boost_new  # type: bool
        self.max_multi_speed = max_multi_speed  # type: int
        self.multi_speed_downgrade_policy = multi_speed_downgrade_policy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryPipelineListResponseBodyPipelineListPipelineExtendConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_boost_new is not None:
            result['IsBoostNew'] = self.is_boost_new
        if self.max_multi_speed is not None:
            result['MaxMultiSpeed'] = self.max_multi_speed
        if self.multi_speed_downgrade_policy is not None:
            result['MultiSpeedDowngradePolicy'] = self.multi_speed_downgrade_policy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsBoostNew') is not None:
            self.is_boost_new = m.get('IsBoostNew')
        if m.get('MaxMultiSpeed') is not None:
            self.max_multi_speed = m.get('MaxMultiSpeed')
        if m.get('MultiSpeedDowngradePolicy') is not None:
            self.multi_speed_downgrade_policy = m.get('MultiSpeedDowngradePolicy')
        return self


class QueryPipelineListResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(self, mq_tag=None, mq_topic=None, queue_name=None, topic=None):
        # The tags of the messages.
        self.mq_tag = mq_tag  # type: str
        # The queue of messages that are received.
        self.mq_topic = mq_topic  # type: str
        # The name of the queue that is created in MNS.
        self.queue_name = queue_name  # type: str
        # The name of the topic that is created in MNS.
        self.topic = topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryPipelineListResponseBodyPipelineListPipelineNotifyConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mq_tag is not None:
            result['MqTag'] = self.mq_tag
        if self.mq_topic is not None:
            result['MqTopic'] = self.mq_topic
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MqTag') is not None:
            self.mq_tag = m.get('MqTag')
        if m.get('MqTopic') is not None:
            self.mq_topic = m.get('MqTopic')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class QueryPipelineListResponseBodyPipelineListPipeline(TeaModel):
    def __init__(self, extend_config=None, id=None, name=None, notify_config=None, quota_allocate=None, role=None,
                 speed=None, speed_level=None, state=None):
        self.extend_config = extend_config  # type: QueryPipelineListResponseBodyPipelineListPipelineExtendConfig
        # The ID of the MPS queue.
        self.id = id  # type: str
        # The name of the MPS queue.
        self.name = name  # type: str
        # The Message Service (MNS) configuration.
        self.notify_config = notify_config  # type: QueryPipelineListResponseBodyPipelineListPipelineNotifyConfig
        # The quota that is allocated to the MPS queue.
        self.quota_allocate = quota_allocate  # type: long
        # The role that is assigned to the current RAM user.
        self.role = role  # type: str
        # The type of the MPS queue. Default value: **Standard**. Valid values:
        # 
        # *   **Boost**: MPS queue with transcoding speed boosted
        # *   **Standard**: standard MPS queue
        # *   **NarrowBandHDV2**: MPS queue that supports Narrowband HD 2.0
        # *   **AIVideoCover**: MPS queue for intelligent snapshot capture
        # *   **AIVideoFPShot**: MPS queue for media fingerprinting
        # *   **AIVideoCensor**: MPS queue for automated review
        # *   **AIVideoMCU**: MPS queue for smart tagging
        # *   **AIVideoSummary**: MPS queue for video synopsis
        # *   **AIVideoPorn**: MPS queue for pornography detection in videos
        # *   **AIAudioKWS**: MPS queue for keyword recognition in audio
        # *   **AIAudioASR**: MPS queue for speech-to-text conversion
        self.speed = speed  # type: str
        # The level of the MPS queue.
        self.speed_level = speed_level  # type: long
        # The state of the MPS queue. Valid values:
        # 
        # *   **Active**: The MPS queue is active.
        # *   **Paused**: The MPS queue is paused.
        self.state = state  # type: str

    def validate(self):
        if self.extend_config:
            self.extend_config.validate()
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super(QueryPipelineListResponseBodyPipelineListPipeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_config is not None:
            result['ExtendConfig'] = self.extend_config.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.quota_allocate is not None:
            result['QuotaAllocate'] = self.quota_allocate
        if self.role is not None:
            result['Role'] = self.role
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.speed_level is not None:
            result['SpeedLevel'] = self.speed_level
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtendConfig') is not None:
            temp_model = QueryPipelineListResponseBodyPipelineListPipelineExtendConfig()
            self.extend_config = temp_model.from_map(m['ExtendConfig'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyConfig') is not None:
            temp_model = QueryPipelineListResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('QuotaAllocate') is not None:
            self.quota_allocate = m.get('QuotaAllocate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('SpeedLevel') is not None:
            self.speed_level = m.get('SpeedLevel')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryPipelineListResponseBodyPipelineList(TeaModel):
    def __init__(self, pipeline=None):
        self.pipeline = pipeline  # type: list[QueryPipelineListResponseBodyPipelineListPipeline]

    def va