# coding: utf-8

"""
    Accounting API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    OpenAPI spec version: 2.2.10
    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class ManualJournal(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "narration": "str",
        "journal_lines": "list[ManualJournalLine]",
        "date": "date[ms-format]",
        "line_amount_types": "LineAmountTypes",
        "status": "str",
        "url": "str",
        "show_on_cash_basis_reports": "bool",
        "has_attachments": "bool",
        "updated_date_utc": "datetime[ms-format]",
        "manual_journal_id": "str",
        "status_attribute_string": "str",
        "warnings": "list[ValidationError]",
        "validation_errors": "list[ValidationError]",
        "attachments": "list[Attachment]",
    }

    attribute_map = {
        "narration": "Narration",
        "journal_lines": "JournalLines",
        "date": "Date",
        "line_amount_types": "LineAmountTypes",
        "status": "Status",
        "url": "Url",
        "show_on_cash_basis_reports": "ShowOnCashBasisReports",
        "has_attachments": "HasAttachments",
        "updated_date_utc": "UpdatedDateUTC",
        "manual_journal_id": "ManualJournalID",
        "status_attribute_string": "StatusAttributeString",
        "warnings": "Warnings",
        "validation_errors": "ValidationErrors",
        "attachments": "Attachments",
    }

    def __init__(
        self,
        narration=None,
        journal_lines=None,
        date=None,
        line_amount_types=None,
        status=None,
        url=None,
        show_on_cash_basis_reports=None,
        has_attachments=False,
        updated_date_utc=None,
        manual_journal_id=None,
        status_attribute_string=None,
        warnings=None,
        validation_errors=None,
        attachments=None,
    ):  # noqa: E501
        """ManualJournal - a model defined in OpenAPI"""  # noqa: E501

        self._narration = None
        self._journal_lines = None
        self._date = None
        self._line_amount_types = None
        self._status = None
        self._url = None
        self._show_on_cash_basis_reports = None
        self._has_attachments = None
        self._updated_date_utc = None
        self._manual_journal_id = None
        self._status_attribute_string = None
        self._warnings = None
        self._validation_errors = None
        self._attachments = None
        self.discriminator = None

        self.narration = narration
        if journal_lines is not None:
            self.journal_lines = journal_lines
        if date is not None:
            self.date = date
        if line_amount_types is not None:
            self.line_amount_types = line_amount_types
        if status is not None:
            self.status = status
        if url is not None:
            self.url = url
        if show_on_cash_basis_reports is not None:
            self.show_on_cash_basis_reports = show_on_cash_basis_reports
        if has_attachments is not None:
            self.has_attachments = has_attachments
        if updated_date_utc is not None:
            self.updated_date_utc = updated_date_utc
        if manual_journal_id is not None:
            self.manual_journal_id = manual_journal_id
        if status_attribute_string is not None:
            self.status_attribute_string = status_attribute_string
        if warnings is not None:
            self.warnings = warnings
        if validation_errors is not None:
            self.validation_errors = validation_errors
        if attachments is not None:
            self.attachments = attachments

    @property
    def narration(self):
        """Gets the narration of this ManualJournal.  # noqa: E501

        Description of journal being posted  # noqa: E501

        :return: The narration of this ManualJournal.  # noqa: E501
        :rtype: str
        """
        return self._narration

    @narration.setter
    def narration(self, narration):
        """Sets the narration of this ManualJournal.

        Description of journal being posted  # noqa: E501

        :param narration: The narration of this ManualJournal.  # noqa: E501
        :type: str
        """
        if narration is None:
            raise ValueError(
                "Invalid value for `narration`, must not be `None`"
            )  # noqa: E501

        self._narration = narration

    @property
    def journal_lines(self):
        """Gets the journal_lines of this ManualJournal.  # noqa: E501

        See JournalLines  # noqa: E501

        :return: The journal_lines of this ManualJournal.  # noqa: E501
        :rtype: list[ManualJournalLine]
        """
        return self._journal_lines

    @journal_lines.setter
    def journal_lines(self, journal_lines):
        """Sets the journal_lines of this ManualJournal.

        See JournalLines  # noqa: E501

        :param journal_lines: The journal_lines of this ManualJournal.  # noqa: E501
        :type: list[ManualJournalLine]
        """

        self._journal_lines = journal_lines

    @property
    def date(self):
        """Gets the date of this ManualJournal.  # noqa: E501

        Date journal was posted – YYYY-MM-DD  # noqa: E501

        :return: The date of this ManualJournal.  # noqa: E501
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this ManualJournal.

        Date journal was posted – YYYY-MM-DD  # noqa: E501

        :param date: The date of this ManualJournal.  # noqa: E501
        :type: date
        """

        self._date = date

    @property
    def line_amount_types(self):
        """Gets the line_amount_types of this ManualJournal.  # noqa: E501


        :return: The line_amount_types of this ManualJournal.  # noqa: E501
        :rtype: LineAmountTypes
        """
        return self._line_amount_types

    @line_amount_types.setter
    def line_amount_types(self, line_amount_types):
        """Sets the line_amount_types of this ManualJournal.


        :param line_amount_types: The line_amount_types of this ManualJournal.  # noqa: E501
        :type: LineAmountTypes
        """

        self._line_amount_types = line_amount_types

    @property
    def status(self):
        """Gets the status of this ManualJournal.  # noqa: E501

        See Manual Journal Status Codes  # noqa: E501

        :return: The status of this ManualJournal.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ManualJournal.

        See Manual Journal Status Codes  # noqa: E501

        :param status: The status of this ManualJournal.  # noqa: E501
        :type: str
        """
        allowed_values = [
            "DRAFT",
            "POSTED",
            "DELETED",
            "VOIDED",
            "ARCHIVED",
        ]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}".format(  # noqa: E501
                    status, allowed_values
                )
            )

        self._status = status

    @property
    def url(self):
        """Gets the url of this ManualJournal.  # noqa: E501

        Url link to a source document – shown as “Go to [appName]” in the Xero app  # noqa: E501

        :return: The url of this ManualJournal.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ManualJournal.

        Url link to a source document – shown as “Go to [appName]” in the Xero app  # noqa: E501

        :param url: The url of this ManualJournal.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def show_on_cash_basis_reports(self):
        """Gets the show_on_cash_basis_reports of this ManualJournal.  # noqa: E501

        Boolean – default is true if not specified  # noqa: E501

        :return: The show_on_cash_basis_reports of this ManualJournal.  # noqa: E501
        :rtype: bool
        """
        return self._show_on_cash_basis_reports

    @show_on_cash_basis_reports.setter
    def show_on_cash_basis_reports(self, show_on_cash_basis_reports):
        """Sets the show_on_cash_basis_reports of this ManualJournal.

        Boolean – default is true if not specified  # noqa: E501

        :param show_on_cash_basis_reports: The show_on_cash_basis_reports of this ManualJournal.  # noqa: E501
        :type: bool
        """

        self._show_on_cash_basis_reports = show_on_cash_basis_reports

    @property
    def has_attachments(self):
        """Gets the has_attachments of this ManualJournal.  # noqa: E501

        Boolean to indicate if a manual journal has an attachment  # noqa: E501

        :return: The has_attachments of this ManualJournal.  # noqa: E501
        :rtype: bool
        """
        return self._has_attachments

    @has_attachments.setter
    def has_attachments(self, has_attachments):
        """Sets the has_attachments of this ManualJournal.

        Boolean to indicate if a manual journal has an attachment  # noqa: E501

        :param has_attachments: The has_attachments of this ManualJournal.  # noqa: E501
        :type: bool
        """

        self._has_attachments = has_attachments

    @property
    def updated_date_utc(self):
        """Gets the updated_date_utc of this ManualJournal.  # noqa: E501

        Last modified date UTC format  # noqa: E501

        :return: The updated_date_utc of this ManualJournal.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_date_utc

    @updated_date_utc.setter
    def updated_date_utc(self, updated_date_utc):
        """Sets the updated_date_utc of this ManualJournal.

        Last modified date UTC format  # noqa: E501

        :param updated_date_utc: The updated_date_utc of this ManualJournal.  # noqa: E501
        :type: datetime
        """

        self._updated_date_utc = updated_date_utc

    @property
    def manual_journal_id(self):
        """Gets the manual_journal_id of this ManualJournal.  # noqa: E501

        The Xero identifier for a Manual Journal  # noqa: E501

        :return: The manual_journal_id of this ManualJournal.  # noqa: E501
        :rtype: str
        """
        return self._manual_journal_id

    @manual_journal_id.setter
    def manual_journal_id(self, manual_journal_id):
        """Sets the manual_journal_id of this ManualJournal.

        The Xero identifier for a Manual Journal  # noqa: E501

        :param manual_journal_id: The manual_journal_id of this ManualJournal.  # noqa: E501
        :type: str
        """

        self._manual_journal_id = manual_journal_id

    @property
    def status_attribute_string(self):
        """Gets the status_attribute_string of this ManualJournal.  # noqa: E501

        A string to indicate if a invoice status  # noqa: E501

        :return: The status_attribute_string of this ManualJournal.  # noqa: E501
        :rtype: str
        """
        return self._status_attribute_string

    @status_attribute_string.setter
    def status_attribute_string(self, status_attribute_string):
        """Sets the status_attribute_string of this ManualJournal.

        A string to indicate if a invoice status  # noqa: E501

        :param status_attribute_string: The status_attribute_string of this ManualJournal.  # noqa: E501
        :type: str
        """

        self._status_attribute_string = status_attribute_string

    @property
    def warnings(self):
        """Gets the warnings of this ManualJournal.  # noqa: E501

        Displays array of warning messages from the API  # noqa: E501

        :return: The warnings of this ManualJournal.  # noqa: E501
        :rtype: list[ValidationError]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this ManualJournal.

        Displays array of warning messages from the API  # noqa: E501

        :param warnings: The warnings of this ManualJournal.  # noqa: E501
        :type: list[ValidationError]
        """

        self._warnings = warnings

    @property
    def validation_errors(self):
        """Gets the validation_errors of this ManualJournal.  # noqa: E501

        Displays array of validation error messages from the API  # noqa: E501

        :return: The validation_errors of this ManualJournal.  # noqa: E501
        :rtype: list[ValidationError]
        """
        return self._validation_errors

    @validation_errors.setter
    def validation_errors(self, validation_errors):
        """Sets the validation_errors of this ManualJournal.

        Displays array of validation error messages from the API  # noqa: E501

        :param validation_errors: The validation_errors of this ManualJournal.  # noqa: E501
        :type: list[ValidationError]
        """

        self._validation_errors = validation_errors

    @property
    def attachments(self):
        """Gets the attachments of this ManualJournal.  # noqa: E501

        Displays array of attachments from the API  # noqa: E501

        :return: The attachments of this ManualJournal.  # noqa: E501
        :rtype: list[Attachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this ManualJournal.

        Displays array of attachments from the API  # noqa: E501

        :param attachments: The attachments of this ManualJournal.  # noqa: E501
        :type: list[Attachment]
        """

        self._attachments = attachments
