# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-04-11 15:58
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('projectroles', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ProjectEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('app', models.CharField(help_text='App from which the event was triggered', max_length=255)),
                ('event_name', models.CharField(help_text='Event ID string', max_length=255)),
                ('description', models.TextField(help_text='Description of status change (may include {object label} references)')),
                ('extra_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Additional event data as JSON')),
                ('classified', models.BooleanField(default=False, help_text='Event is classified (only viewable by user levels specified in rules)')),
                ('omics_uuid', models.UUIDField(default=uuid.uuid4, help_text='Event omics UUID', unique=True)),
                ('project', models.ForeignKey(help_text='Project in which the event belongs', on_delete=django.db.models.deletion.CASCADE, related_name='events', to='projectroles.Project')),
            ],
        ),
        migrations.CreateModel(
            name='ProjectEventObjectRef',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(help_text='Label for the object related to the event', max_length=255)),
                ('name', models.CharField(help_text='Name or title of the object', max_length=255)),
                ('object_model', models.CharField(help_text='Object model as string', max_length=255)),
                ('object_uuid', models.UUIDField(blank=True, help_text='Object Omics UUID', null=True)),
                ('extra_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Additional data related to the object as JSON')),
                ('event', models.ForeignKey(help_text='Event to which the object belongs', on_delete=django.db.models.deletion.CASCADE, related_name='event_objects', to='timeline.ProjectEvent')),
            ],
        ),
        migrations.CreateModel(
            name='ProjectEventStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timestamp', models.DateTimeField(auto_now_add=True, help_text='DateTime of the status change')),
                ('status_type', models.CharField(help_text='Type of the status change', max_length=64)),
                ('description', models.TextField(blank=True, help_text='Description of status change (optional)')),
                ('extra_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Additional status data as JSON')),
                ('event', models.ForeignKey(help_text='Event to which the status change belongs', on_delete=django.db.models.deletion.CASCADE, related_name='status_changes', to='timeline.ProjectEvent')),
            ],
        ),
    ]
