# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nautobot_circuit_maintenance',
 'nautobot_circuit_maintenance.api',
 'nautobot_circuit_maintenance.graphql',
 'nautobot_circuit_maintenance.handle_notifications',
 'nautobot_circuit_maintenance.migrations',
 'nautobot_circuit_maintenance.tests']

package_data = \
{'': ['*'],
 'nautobot_circuit_maintenance': ['fixtures/*',
                                  'templates/nautobot_circuit_maintenance/*']}

install_requires = \
['bs4>=0.0.1,<0.0.2',
 'circuit-maintenance-parser>=1.1.0,<2.0.0',
 'nautobot',
 'pydantic>=1.8.1,<2.0.0']

setup_kwargs = {
    'name': 'nautobot-circuit-maintenance',
    'version': '0.1.3',
    'description': 'Nautobot plugin to automatically handle Circuit Maintenances Notifications',
    'long_description': '# Nautobot Circuit Maintenance plugin\n\nA plugin for [Nautobot](https://github.com/nautobot/nautobot) to easily handle Circuit Maintenances related to Nautobot Circuits.\n\n`nautobot-circuit-maintenance` lets you handle maintenances for your Circuits based on notifications received by email by leveraging on [circuit-maintenance-parser](https://github.com/networktocode/circuit-maintenance-parser), a notifications parser library for multiple network service providers that exposes structured data following a recommendation defined in this [draft NANOG BCOP](https://github.com/jda/maintnote-std/blob/master/standard.md).\n\n## Installation\n\nThe plugin is available as a Python package in pypi and can be installed with pip\n\n```shell\npip install nautobot-circuit-maintenance\n```\n\n> The plugin is compatible with Nautobot 1.0.0b4 and higher\n\nTo ensure Circuit Maintenance is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (alongside `requirements.txt`) and list the `nautobot-circuit-maintenance` package:\n\n```no-highlight\n# echo nautobot-circuit-maintenance >> local_requirements.txt\n```\n\nOnce installed, the plugin needs to be enabled in your `configuration.py`.\n\n```python\n# In your configuration.py\nPLUGINS = ["nautobot_circuit_maintenance"]\n```\n\nExtra configuration to define notification sources is defined in the [Usage](#Usage) section.\n\n```py\nPLUGINS_CONFIG = {\n    "nautobot_circuit_maintenance": {\n        "notification_sources": [\n            {\n              ...\n            }\n        ]\n    }\n}\n```\n\n## Usage\n\nAll the plugin configuration is done via UI, under the **Plugins** tab, in the **Circuit Maintenance** sections.\n\n### 1. Define source emails per Provider\n\nEach Circuit **Provider**, that we would like to track via the Circuit Maintenance plugin, requires at least one email address under the `Custom Fields` -> `Emails for Circuit Maintenance plugin` section.\n\nThese are the source email addresses that the plugin will check and use to classify each notification for each specific provider.\n\n### 2. Configure Notification Sources\n\nNotification Sources are defined in two steps:\n\n#### 2.1 Define Notification Sources in `configuration.py`\n\nIn the `PLUGINS_CONFIG`, under the `nautobot_circuit_maintenance` key, we should define the Notification Sources that will be able later in the UI.\n\nThere are two mandatory attributes (other keys are dependent on the integration type, and will be documented below):\n\n- `name`: Name to identify the Source and will be available in the UI.\n- `url`: URL to reach the Notification Source (i.e. `imap://imap.gmail.com:993`)\n\n> Currently, only IMAP email box integration is supported as URL scheme,\n\n##### IMAP\n\nThere are 2 extra attributes:\n\n- `account`: Identifier (i.e. email address) to use to authenticate.\n- `secret`: Password to IMAP authentication.\n\n> Gmail example: [How to setup Gmail with App Passwords](https://support.google.com/accounts/answer/185833)\n\n```py\nPLUGINS_CONFIG = {\n    "nautobot_circuit_maintenance": {\n        "notification_sources": [\n            {\n                "name": "my custom name",\n                "account": os.environ.get("CM_NS_1_ACCOUNT", ""),\n                "secret": os.environ.get("CM_NS_1_SECRET", ""),\n                "url": os.environ.get("CM_NS_1_URL", ""),\n            }\n        ]\n    }\n}\n```\n\n#### 2.2 Add `Providers` to the Notification Sources\n\nIn the Circuit Maintenance plugin UI section, there is a **Notification Sources** button (yellow) where you can configure the Notification Sources to track new circuit maintenance notifications from specific providers.\n\nBecause the Notification Sources are defined by the configuration, you can only view and edit `providers`, but not `add` or `delete` new Notification Sources via UI or API.\n\n### 3. Run Handle Notifications Job\n\nThere is an asynchronous task defined as a **Nautobot Job**, **Handle Circuit Maintenance Notifications** that will connect to the emails sources defined under the Notification Sources section (step above), and will fetch new notifications received since the last notification was fetched.\nEach notification will be parsed using the [circuit-maintenance-parser](https://github.com/networktocode/circuit-maintenance-parser) library, and if a valid parsing is executed, a new **Circuit Maintenance** will be created, or if it was already created, it will updated with the new data.\n\nSo, for each email notification received, several objects will be created:\n\n#### 3.1 Notification\n\nEach notification received will create a related object, containing the raw data received, and linking to the corresponding **parsed notification** in case the [circuit-maintenance-parser](https://github.com/networktocode/circuit-maintenance-parser) was able to parse it correctly.\n\n#### 3.2 Parsed Notification\n\nWhen a notification was successfully parsed, it will create a **parsed notification** object, that will contain the structured output from the parser library , following the recommendation defined in [draft NANOG BCOP](https://github.com/jda/maintnote-std/blob/master/standard.md), and a link to the related **Circuit Maintenance** object created.\n\n#### 3.3 Circuit Maintenance\n\nThe **Circuit Maintenance** is where all the necessary information related to a Circuit maintenance is tracked, and reuses most of the data model defined in the parser library.\n\nAttributes:\n\n- Name: name or identifier of the maintenance.\n- Description: description of the maintenance.\n- Status: current state of the maintenance.\n- Start time: defined start time of the maintenance work.\n- End time: defined end time of the maintenance work.\n- Ack: boolean to show if the maintenance has been properly handled by the operator.\n- Circuits: list of circuits and its specific impact linked to this maintenance.\n- Notes: list of internal notes linked to this maintenance.\n- Notifications: list of all the parsed notifications that have been processed for this maintenance.\n\n<p align="center">\n<img src="https://raw.githubusercontent.com/nautobot/nautobot-plugin-circuit-maintenance/develop/docs/images/circuit_maintenance.png" width="800" class="center">\n</p>\n\n### Rest API\n\nThe plugin includes 6 API endpoints to manage its related objects, complete info in the Swagger section.\n\n- Circuit Maintenance: `/api/plugins\u200b/circuit-maintenance\u200b/maintenance`\n- Circuit Impact: `/api/plugins\u200b/circuit-maintenance\u200b/circuitimpact`\n- Note: `/api/plugins\u200b/circuit-maintenance\u200b/note`\n\n### GraphQL API\n\nCircuit Maintenance and Circuit Impact objects are available for GraphQL queries.\n\n## Contributing\n\nPull requests are welcomed and automatically built and tested against multiple version of Python and multiple version of Nautobot through TravisCI.\n\nThe project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.\n\nThe project is following Network to Code software development guideline and is leveraging:\n\n- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.\n- Django unit test to ensure the plugin is working properly.\n\n### CLI Helper Commands\n\nThe project is coming with a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`.\n\nEach command can be executed with `invoke <command>`. All commands support the arguments `--nautobot-ver` and `--python-ver` if you want to manually define the version of Python and Nautobot to use. Each command also has its own help `invoke <command> --help`\n\n#### Local dev environment\n\n```no-highlight\n  build            Build all docker images.\n  debug            Start Nautobot and its dependencies in debug mode.\n  destroy          Destroy all containers and volumes.\n  restart          Restart Nautobot and its dependencies.\n  start            Start Nautobot and its dependencies in detached mode.\n  stop             Stop Nautobot and its dependencies.\n```\n\n#### Utility\n\n```no-highlight\n  cli              Launch a bash shell inside the running Nautobot container.\n  create-user      Create a new user in django (default: admin), will prompt for password.\n  makemigrations   Run Make Migration in Django.\n  nbshell          Launch a nbshell session.\n```\n\n#### Testing\n\n```no-highlight\n  bandit           Run bandit to validate basic static code security analysis.\n  black            Run black to check that Python files adhere to its style standards.\n  flake8           This will run flake8 for the specified name and Python version.\n  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  pylint           Run pylint code analysis.\n  tests            Run all tests for this plugin.\n  unittest         Run Django unit tests for the plugin.\n```\n\n## Questions\n\nFor any questions or comments, please check the [FAQ](FAQ.md) first and feel free to swing by the [Network to Code slack channel](https://networktocode.slack.com/) (channel #nautobot).\nSign up [here](http://slack.networktocode.com/)\n',
    'author': 'Network to Code, LLC',
    'author_email': 'opensource@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nautobot/nautobot-plugin-circuit-maintenance',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
