CMAKE_MINIMUM_REQUIRED(VERSION 3.12)

IF (CARMA_DEV_DEBUG_MODE)
    SET(ENABLE_CARMA_EXTRA_DEBUG "ON")
    ADD_DEFINITIONS(-DCARMA_DEV_DEBUG)
    SET(CARMA_DEV_MODE ON)
ELSE ()
    REMOVE_DEFINITIONS(-DCARMA_DEV_DEBUG)
ENDIF ()

IF (CARMA_DEV_MODE OR CARMA_DEV_DEBUG_MODE)
    SET(CARMA_BUILD_TESTS ON)
    SET(CMAKE_EXPORT_COMPILE_COMMANDS 1)
    SET(CMAKE_INSTALL_PREFIX ${PROJECT_SOURCE_DIR}/build)
    SET(CARMA_DEV_TARGET ON)
ENDIF ()

SET(ORIGINAL_CARMA_RELEASE_DEFINITIONS ${CARMA_RELEASE_DEFINITIONS})
IF (ENABLE_ARMA_NO_DEBUG)
    SET(CARMA_RELEASE_DEFINITIONS ARMA_NO_DEBUG)
ENDIF ()

IF (ENABLE_ARMA_EXTRA_DEBUG)
    ADD_DEFINITIONS(-DARMA_EXTRA_DEBUG)
ELSE ()
    SET(ENABALE_ARMA_EXTRA_DEBUG "OFF")
    REMOVE_DEFINITIONS(-DARMA_EXTRA_DEBUG)
ENDIF ()

IF (ENABLE_CARMA_EXTRA_DEBUG)
    SET(CARMA_EXTRA_DEBUG "ON")
    ADD_DEFINITIONS(-DCARMA_EXTRA_DEBUG)
ELSE ()
    SET(CARMA_EXTRA_DEBUG "OFF")
    REMOVE_DEFINITIONS(-DCARMA_EXTRA_DEBUG)
ENDIF ()

IF (ENABLE_CARMA_SOFT_STEAL AND ENABLE_CARMA_HARD_STEAL)
    MESSAGE(WARNING "CARMA Configuration: both CARMA_HARD_STEAL and CARMA_SOFT_STEAL were enabled, CARMA_HARD_STEAL has been unset")
    SET(ENABLE_CARMA_HARD_STEAL OFF)
ENDIF ()

IF (ENABLE_CARMA_SOFT_STEAL)
    SET(CARMA_SOFT_STEAL "ON")
    ADD_DEFINITIONS(-DCARMA_SOFT_STEAL)
ELSE ()
    SET(CARMA_SOFT_STEAL "OFF")
    REMOVE_DEFINITIONS(-DCARMA_SOFT_STEAL)
ENDIF ()

IF (ENABLE_CARMA_HARD_STEAL)
    SET(CARMA_HARD_STEAL "ON")
    ADD_DEFINITIONS(-DCARMA_HARD_STEAL)
ELSE ()
    SET(CARMA_HARD_STEAL "OFF")
    REMOVE_DEFINITIONS(-DCARMA_HARD_STEAL)
ENDIF ()

IF (ENABLE_CARMA_DONT_REQUIRE_OWNDATA)
    SET(CARMA_DONT_REQUIRE_OWNDATA "ON")
    ADD_DEFINITIONS(-DCARMA_DONT_REQUIRE_OWNDATA)
ELSE ()
    SET(CARMA_DONT_REQUIRE_OWNDATA "OFF")
    REMOVE_DEFINITIONS(-DCARMA_DONT_REQUIRE_OWNDATA)
ENDIF ()

IF (ENABLE_CARMA_DONT_REQUIRE_F_CONTIGUOUS)
    SET(CARMA_DONT_REQUIRE_F_CONTIGUOUS "ON")
    ADD_DEFINITIONS(-DCARMA_DONT_REQUIRE_F_CONTIGUOUS)
ELSE ()
    SET(CARMA_DONT_REQUIRE_F_CONTIGUOUS "OFF")
    REMOVE_DEFINITIONS(-DCARMA_DONT_REQUIRE_F_CONTIGUOUS)
ENDIF ()

IF (DEFINED Python3_EXECUTABLE AND NOT DEFINED PYTHON_EXECUTABLE)
    SET(PYTHON_EXECUTABLE ${Python3_EXECUTABLE})
ELSEIF (DEFINED PYTHON_EXECUTABLE AND NOT DEFINED Python3_EXECUTABLE)
    SET(Python3_EXECUTABLE ${PYTHON_EXECUTABLE})
ENDIF ()


IF (CARMA_DEV_MODE OR CARMA_DEV_DEBUG_MODE)
    MESSAGE(STATUS "carma: dev mode: ${CARMA_DEV_MODE}")
    MESSAGE(STATUS "carma: dev debug mode: ${CARMA_DEV_DEBUG_MODE}")
ENDIF ()
MESSAGE(STATUS "carma: enable arma no debug: ${ENABLE_ARMA_NO_DEBUG}")
MESSAGE(STATUS "carma: enable extra debug: ${ENABLE_CARMA_EXTRA_DEBUG}")
MESSAGE(STATUS "carma: enable soft steal: ${ENABLE_CARMA_SOFT_STEAL}")
MESSAGE(STATUS "carma: enable hard steal: ${ENABLE_CARMA_HARD_STEAL}")
MESSAGE(STATUS "carma: don't require owndata: ${ENABLE_CARMA_DONT_REQUIRE_OWNDATA}")
MESSAGE(STATUS "carma: don't require f-contiguous: ${ENABLE_CARMA_DONT_REQUIRE_F_CONTIGUOUS}")
