from .base import Request


class DeleteRequest(Request):
    __verb__ = "DELETE"

    def __init__(self, resource, object_id):
        super(DeleteRequest, self).__init__(resource)
        self.base_url = resource.get_url(fragments=[object_id])

    async def send(self, **kwargs):
        return await self._send(**kwargs)

    @property
    def url(self):
        return self.base_url
