/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.isotonic;

import java.util.Arrays;

public class IsotonicRegressionUtils {
    public static double score(double x2, double minX, double maxX, double[] thresholdsX, double[] thresholdsY) {
        double y2;
        if (Double.isNaN(x2) || x2 < minX || x2 > maxX) {
            return Double.NaN;
        }
        int pos = Arrays.binarySearch(thresholdsX, x2);
        if (pos >= 0) {
            y2 = thresholdsY[pos];
        } else {
            int lo = -pos - 2;
            int hi = lo + 1;
            assert (lo >= 0);
            assert (hi < thresholdsX.length);
            assert (x2 > thresholdsX[lo]);
            assert (x2 < thresholdsX[hi]);
            y2 = IsotonicRegressionUtils.interpolate(x2, thresholdsX[lo], thresholdsX[hi], thresholdsY[lo], thresholdsY[hi]);
        }
        return y2;
    }

    public static double clip(double x2, double min, double max) {
        double clipped = Double.isNaN(x2) ? Double.NaN : (x2 < min ? min : Math.min(x2, max));
        return clipped;
    }

    static double interpolate(double x2, double xLo, double xHi, double yLo, double yHi) {
        double slope = (yHi - yLo) / (xHi - xLo);
        return yLo + slope * (x2 - xLo);
    }
}

