/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.isoforextended;

import hex.genmodel.MojoModel;
import hex.genmodel.algos.tree.ScoreIsolationTree;
import hex.genmodel.algos.tree.ScoreIsolationTree0;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.ByteBufferWrapper;
import hex.genmodel.utils.MathUtils;

public final class ExtendedIsolationForestMojoModel
extends MojoModel {
    public static final int NODE = 78;
    public static final int LEAF = 76;
    int _ntrees;
    long _sample_size;
    byte[][] _compressedTrees;
    private ScoreIsolationTree _scoreIsolationTree;

    public ExtendedIsolationForestMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    public void postInit() {
        this._scoreIsolationTree = new ScoreIsolationTree0();
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        return this.score0(row, 0.0, preds);
    }

    @Override
    public double[] score0(double[] row, double offset, double[] preds) {
        double anomalyScore;
        double pathLength = 0.0;
        for (int treeId = 0; treeId < this._ntrees; ++treeId) {
            double iTreeScore = this._scoreIsolationTree.scoreTree(this._compressedTrees[treeId], row);
            pathLength += iTreeScore;
        }
        preds[0] = anomalyScore = ExtendedIsolationForestMojoModel.anomalyScore(pathLength /= (double)this._ntrees, this._sample_size);
        preds[1] = pathLength;
        return preds;
    }

    @Override
    public int getPredsSize() {
        return 2;
    }

    @Override
    public String[] getOutputNames() {
        return new String[]{"anomaly_score", "mean_length"};
    }

    public static double scoreTree0(byte[] isolationTree, double[] row) {
        ByteBufferWrapper ab = new ByteBufferWrapper(isolationTree);
        int sizeOfBranchingArrays = ab.get4();
        double[] tempN = new double[sizeOfBranchingArrays];
        double[] tempP = new double[sizeOfBranchingArrays];
        int height = 0;
        int findNodeNumber = 0;
        int SIZE_OF_NODE = 2 * sizeOfBranchingArrays * 8;
        int SIZE_OF_LEAF = 4;
        double pathLength = -1.0;
        while (ab.hasRemaining()) {
            int tempNodeNumber = ab.get4();
            int tempNodeType = ab.get1U();
            if (tempNodeNumber != findNodeNumber) {
                if (tempNodeType == 78) {
                    ab.skip(SIZE_OF_NODE);
                    continue;
                }
                if (tempNodeType == 76) {
                    ab.skip(4);
                    continue;
                }
                throw new UnsupportedOperationException("Unknown node type: " + tempNodeType);
            }
            if (tempNodeType == 78) {
                ExtendedIsolationForestMojoModel.loadNode(ab, tempN, tempP);
                double mul = ArrayUtils.subAndMul(row, tempP, tempN);
                if (mul <= 0.0) {
                    ++height;
                    findNodeNumber = ExtendedIsolationForestMojoModel.leftChildIndex(tempNodeNumber);
                    continue;
                }
                ++height;
                findNodeNumber = ExtendedIsolationForestMojoModel.rightChildIndex(tempNodeNumber);
                continue;
            }
            if (tempNodeType == 76) {
                int tempNumRows = ab.get4();
                pathLength = (double)height + ExtendedIsolationForestMojoModel.averagePathLengthOfUnsuccessfulSearch(tempNumRows);
                break;
            }
            throw new UnsupportedOperationException("Unknown node type: " + tempNodeType);
        }
        return pathLength;
    }

    private static void loadNode(ByteBufferWrapper ab, double[] n2, double[] p2) {
        int i2;
        for (i2 = 0; i2 < n2.length; ++i2) {
            n2[i2] = ab.get8d();
        }
        for (i2 = 0; i2 < n2.length; ++i2) {
            p2[i2] = ab.get8d();
        }
    }

    public static int leftChildIndex(int i2) {
        return 2 * i2 + 1;
    }

    public static int rightChildIndex(int i2) {
        return 2 * i2 + 2;
    }

    public static double anomalyScore(double pathLength, long sample_size) {
        return Math.pow(2.0, -1.0 * (pathLength / ExtendedIsolationForestMojoModel.averagePathLengthOfUnsuccessfulSearch(sample_size)));
    }

    public static double averagePathLengthOfUnsuccessfulSearch(long n2) {
        if (n2 < 2L) {
            return 0.0;
        }
        if (n2 == 2L) {
            return 1.0;
        }
        return 2.0 * MathUtils.harmonicNumberEstimation(n2 - 1L) - 2.0 * ((double)n2 - 1.0) / (double)n2;
    }
}

