/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.gam.GamMojoModel;
import hex.genmodel.algos.gam.GamMojoModelBase;
import hex.genmodel.algos.gam.GamMojoMultinomialModel;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GamMojoReader
extends ModelMojoReader<GamMojoModelBase> {
    @Override
    public String getModelName() {
        return "Generalized Additive Model";
    }

    @Override
    protected void readModelData() throws IOException {
        ((GamMojoModelBase)this._model)._useAllFactorLevels = this.readkv("use_all_factor_levels", false);
        ((GamMojoModelBase)this._model)._numExpandedGamCols = this.readkv("num_expanded_gam_columns", 0);
        ((GamMojoModelBase)this._model)._numExpandedGamColsCenter = this.readkv("num_expanded_gam_columns_center", 0);
        ((GamMojoModelBase)this._model)._family = DistributionFamily.valueOf((String)this.readkv("family"));
        ((GamMojoModelBase)this._model)._cats = this.readkv("cats", -1);
        ((GamMojoModelBase)this._model)._nums = (Integer)this.readkv("num");
        ((GamMojoModelBase)this._model)._numsCenter = (Integer)this.readkv("numsCenter");
        ((GamMojoModelBase)this._model)._catNAFills = this.readkv("catNAFills", new int[0]);
        ((GamMojoModelBase)this._model)._numNAFillsCenter = this.readkv("numNAFillsCenter", new double[0]);
        ((GamMojoModelBase)this._model)._meanImputation = this.readkv("mean_imputation", false);
        ((GamMojoModelBase)this._model)._betaSizePerClass = this.readkv("beta length per class", 0);
        ((GamMojoModelBase)this._model)._catOffsets = this.readkv("cat_offsets", new int[0]);
        if (!((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.multinomial)) {
            ((GamMojoModelBase)this._model)._link_function = GamMojoReader.readLinkFunction((String)this.readkv("link"), ((GamMojoModelBase)this._model)._family);
        }
        ((GamMojoModelBase)this._model)._tweedieLinkPower = this.readkv("tweedie_link_power", 0.0);
        ((GamMojoModelBase)this._model)._betaCenterSizePerClass = this.readkv("beta center length per class", 0);
        if (((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.multinomial) || ((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.ordinal)) {
            ((GamMojoModelBase)this._model)._beta_multinomial_no_center = this.readRectangularDoubleArray("beta_multinomial", ((GamMojoModelBase)this._model)._nclasses, ((GamMojoModelBase)this._model)._betaSizePerClass);
            ((GamMojoModelBase)this._model)._beta_multinomial_center = this.readRectangularDoubleArray("beta_multinomial_centering", ((GamMojoModelBase)this._model)._nclasses, ((GamMojoModelBase)this._model)._betaCenterSizePerClass);
        } else {
            ((GamMojoModelBase)this._model)._beta_no_center = (double[])this.readkv("beta");
            ((GamMojoModelBase)this._model)._beta_center = (double[])this.readkv("beta_center");
        }
        ((GamMojoModelBase)this._model)._num_knots = (int[])this.readkv("num_knots");
        ((GamMojoModelBase)this._model)._num_knots_sorted = (int[])this.readkv("num_knots_sorted");
        int[] gamColumnDim = (int[])this.readkv("gam_column_dim");
        ((GamMojoModelBase)this._model)._gam_columns = this.read2DStringArrays(gamColumnDim, "gam_columns");
        int[] gamColumnDimSorted = (int[])this.readkv("gam_column_dim_sorted");
        ((GamMojoModelBase)this._model)._gam_columns_sorted = this.read2DStringArrays(gamColumnDimSorted, "gam_columns_sorted");
        ((GamMojoModelBase)this._model)._num_gam_columns = ((GamMojoModelBase)this._model)._gam_columns.length;
        ((GamMojoModelBase)this._model)._numTPCol = (Integer)this.readkv("num_TP_col");
        ((GamMojoModelBase)this._model)._numCSCol = (Integer)this.readkv("num_CS_col");
        ((GamMojoModelBase)this._model)._numISCol = (Integer)this.readkv("num_IS_col");
        ((GamMojoModelBase)this._model)._numMSCol = (Integer)this.readkv("num_MS_col");
        if (((GamMojoModelBase)this._model)._numISCol > 0 || ((GamMojoModelBase)this._model)._numMSCol > 0) {
            int trueIndex;
            int index;
            int offset;
            ((GamMojoModelBase)this._model)._spline_orders = (int[])this.readkv("spline_orders");
            ((GamMojoModelBase)this._model)._spline_orders_sorted = (int[])this.readkv("spline_orders_sorted");
            if (((GamMojoModelBase)this._model)._numISCol > 0) {
                ((GamMojoModelBase)this._model)._numBasisSize = new int[((GamMojoModelBase)this._model)._numISCol];
                int isCounter = 0;
                offset = ((GamMojoModelBase)this._model)._numCSCol;
                for (index = 0; index < ((GamMojoModelBase)this._model)._numISCol; ++index) {
                    trueIndex = index + offset;
                    ((GamMojoModelBase)this._model)._numBasisSize[isCounter++] = ((GamMojoModelBase)this._model)._num_knots_sorted[trueIndex] + ((GamMojoModelBase)this._model)._spline_orders_sorted[trueIndex] - 2;
                }
            }
            if (((GamMojoModelBase)this._model)._numMSCol > 0) {
                ((GamMojoModelBase)this._model)._numMSBasisSize = new int[((GamMojoModelBase)this._model)._numMSCol];
                int msCounter = 0;
                offset = ((GamMojoModelBase)this._model)._numISCol + ((GamMojoModelBase)this._model)._numCSCol;
                for (index = 0; index < ((GamMojoModelBase)this._model)._numMSCol; ++index) {
                    trueIndex = offset + index;
                    ((GamMojoModelBase)this._model)._numMSBasisSize[msCounter++] = ((GamMojoModelBase)this._model)._num_knots_sorted[trueIndex] + ((GamMojoModelBase)this._model)._spline_orders_sorted[trueIndex] - 2;
                }
            }
        }
        ((GamMojoModelBase)this._model)._totFeatureSize = (Integer)this.readkv("total feature size");
        ((GamMojoModelBase)this._model)._names_no_centering = this.readStringArrays(((GamMojoModelBase)this._model)._totFeatureSize, "_names_no_centering");
        ((GamMojoModelBase)this._model)._bs = (int[])this.readkv("bs");
        ((GamMojoModelBase)this._model)._bs_sorted = (int[])this.readkv("bs_sorted");
        ((GamMojoModelBase)this._model)._zTranspose = new double[((GamMojoModelBase)this._model)._num_gam_columns][][];
        int[] gamColName_dim = (int[])this.readkv("gamColName_dim");
        ((GamMojoModelBase)this._model)._gamColNames = this.read2DStringArrays(gamColName_dim, "gamColNames");
        ((GamMojoModelBase)this._model)._gamPredSize = (int[])this.readkv("_d");
        if (((GamMojoModelBase)this._model)._numTPCol > 0) {
            ((GamMojoModelBase)this._model)._standardize = (Boolean)this.readkv("standardize");
            ((GamMojoModelBase)this._model)._zTransposeCS = new double[((GamMojoModelBase)this._model)._numTPCol][][];
            ((GamMojoModelBase)this._model)._num_knots_TP = (int[])this.readkv("num_knots_TP");
            ((GamMojoModelBase)this._model)._d = (int[])this.readkv("_d");
            ((GamMojoModelBase)this._model)._m = (int[])this.readkv("_m");
            ((GamMojoModelBase)this._model)._M = (int[])this.readkv("_M");
            int[] predSize = new int[((GamMojoModelBase)this._model)._numTPCol];
            System.arraycopy(predSize, predSize.length - ((GamMojoModelBase)this._model)._numTPCol, predSize, 0, ((GamMojoModelBase)this._model)._numTPCol);
            ((GamMojoModelBase)this._model)._gamColMeansRaw = this.read2DDoubleArrays(predSize, "gamColMeansRaw");
            ((GamMojoModelBase)this._model)._oneOGamColStd = this.read2DDoubleArrays(predSize, "gamColStdRaw");
            int[] numKnotsMM = ArrayUtils.subtract(((GamMojoModelBase)this._model)._num_knots_TP, ((GamMojoModelBase)this._model)._M);
            ((GamMojoModelBase)this._model)._zTransposeCS = this.read3DArray("zTransposeCS", ((GamMojoModelBase)this._model)._numTPCol, numKnotsMM, ((GamMojoModelBase)this._model)._num_knots_TP);
            int[] predNum = new int[((GamMojoModelBase)this._model)._numTPCol];
            System.arraycopy(((GamMojoModelBase)this._model)._d, ((GamMojoModelBase)this._model)._numCSCol, predNum, 0, ((GamMojoModelBase)this._model)._numTPCol);
            ((GamMojoModelBase)this._model)._allPolyBasisList = this.read3DIntArray("polynomialBasisList", ((GamMojoModelBase)this._model)._numTPCol, ((GamMojoModelBase)this._model)._M, predNum);
        }
        int[] numKnotsM1 = ArrayUtils.subtract(((GamMojoModelBase)this._model)._num_knots_sorted, 1);
        int numKnotsLen = numKnotsM1.length;
        int isCounter = 0;
        int msCounter = 0;
        int[] zSecondDim = new int[numKnotsLen];
        int[] zThirdDim = new int[numKnotsLen];
        for (int index = 0; index < numKnotsLen; ++index) {
            if (((GamMojoModelBase)this._model)._bs_sorted[index] == 2) {
                numKnotsM1[index] = ((GamMojoModelBase)this._model)._numBasisSize[isCounter++];
                zSecondDim[index] = 0;
                zThirdDim[index] = 0;
                continue;
            }
            if (((GamMojoModelBase)this._model)._bs_sorted[index] == 3) {
                numKnotsM1[index] = ((GamMojoModelBase)this._model)._numMSBasisSize[msCounter++] - 1;
                zSecondDim[index] = numKnotsM1[index];
                zThirdDim[index] = numKnotsM1[index] + 1;
                continue;
            }
            zSecondDim[index] = numKnotsM1[index];
            zThirdDim[index] = ((GamMojoModelBase)this._model)._num_knots_sorted[index];
        }
        ((GamMojoModelBase)this._model)._gamColNamesCenter = this.read2DStringArrays(numKnotsM1, "gamColNamesCenter");
        ((GamMojoModelBase)this._model)._zTranspose = this.read3DArray("zTranspose", ((GamMojoModelBase)this._model)._num_gam_columns, zSecondDim, zThirdDim);
        ((GamMojoModelBase)this._model)._knots = this.read3DArray("knots", ((GamMojoModelBase)this._model)._num_gam_columns, ((GamMojoModelBase)this._model)._gamPredSize, ((GamMojoModelBase)this._model)._num_knots_sorted);
        if (((GamMojoModelBase)this._model)._numCSCol > 0) {
            int[] numKnotsM2 = ArrayUtils.subtract(((GamMojoModelBase)this._model)._num_knots_sorted, 2);
            ((GamMojoModelBase)this._model)._binvD = this.read3DArray("_binvD", ((GamMojoModelBase)this._model)._numCSCol, numKnotsM2, ((GamMojoModelBase)this._model)._num_knots_sorted);
        }
        ((GamMojoModelBase)this._model).init();
    }

    String[] readStringArrays(int aSize, String title) throws IOException {
        String[] stringArrays = new String[aSize];
        int counter = 0;
        for (String line : this.readtext(title)) {
            stringArrays[counter++] = line;
        }
        return stringArrays;
    }

    String[][] read2DStringArrays(int[] arrayDim, String title) throws IOException {
        int firstDim = arrayDim.length;
        String[][] stringArrays = new String[firstDim][];
        int indexDim1 = 0;
        int indexDim2 = 0;
        for (int index = 0; index < firstDim; ++index) {
            stringArrays[index] = new String[arrayDim[index]];
        }
        for (String line : this.readtext(title)) {
            if (indexDim2 >= stringArrays[indexDim1].length) {
                ++indexDim1;
                indexDim2 = 0;
            }
            stringArrays[indexDim1][indexDim2] = line;
            ++indexDim2;
        }
        return stringArrays;
    }

    double[][] read2DDoubleArrays(int[] arrayDim, String title) throws IOException {
        int firstDim = arrayDim.length;
        double[][] doubleArrays = new double[firstDim][];
        ByteBuffer bb = ByteBuffer.wrap(this.readblob(title));
        for (int index = 0; index < firstDim; ++index) {
            doubleArrays[index] = new double[arrayDim[index]];
            for (int index2nd = 0; index2nd < arrayDim[index]; ++index2nd) {
                doubleArrays[index][index2nd] = bb.getDouble();
            }
        }
        return doubleArrays;
    }

    double[][] read2DArray(String title, int firstDSize, int secondDSize) throws IOException {
        double[][] row = new double[firstDSize][secondDSize];
        ByteBuffer bb = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < firstDSize; ++i2) {
            for (int j2 = 0; j2 < secondDSize; ++j2) {
                row[i2][j2] = bb.getDouble();
            }
        }
        return row;
    }

    int[][][] read3DIntArray(String title, int firstDimSize, int[] secondDim, int[] thirdDim) throws IOException {
        int[][][] row = new int[firstDimSize][][];
        ByteBuffer bb = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < firstDimSize; ++i2) {
            row[i2] = new int[secondDim[i2]][thirdDim[i2]];
            for (int j2 = 0; j2 < secondDim[i2]; ++j2) {
                for (int k2 = 0; k2 < thirdDim[i2]; ++k2) {
                    row[i2][j2][k2] = bb.getInt();
                }
            }
        }
        return row;
    }

    double[][][] read3DArray(String title, int firstDimSize, int[] secondDim, int[] thirdDim) throws IOException {
        double[][][] row = new double[firstDimSize][][];
        ByteBuffer bb = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < firstDimSize; ++i2) {
            row[i2] = new double[secondDim[i2]][thirdDim[i2]];
            for (int j2 = 0; j2 < secondDim[i2]; ++j2) {
                for (int k2 = 0; k2 < thirdDim[i2]; ++k2) {
                    row[i2][j2][k2] = bb.getDouble();
                }
            }
        }
        return row;
    }

    double[][] read2DArrayDiffLength(String title, double[][] row, int[] num_knots) throws IOException {
        int numGamColumns = num_knots.length;
        ByteBuffer bb = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < numGamColumns; ++i2) {
            row[i2] = new double[num_knots[i2]];
            for (int j2 = 0; j2 < row[i2].length; ++j2) {
                row[i2][j2] = bb.getDouble();
            }
        }
        return row;
    }

    @Override
    protected GamMojoModelBase makeModel(String[] columns, String[][] domains, String responseColumn) {
        String family = (String)this.readkv("family");
        if ("multinomial".equals(family) || "ordinal".equals(family)) {
            return new GamMojoMultinomialModel(columns, domains, responseColumn);
        }
        return new GamMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

