/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import ai.h2o.sparkling.ml.params.NullableDataFrameParam;
import ai.h2o.sparkling.utils.DataFrameSerializationWrappers$;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting ordinal regression.")
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001\u0002\f\u0018\u0001\tB\u0001b\n\u0001\u0003\u0006\u0004%\t\u0005\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005S!)q\u0007\u0001C\u0001q!)q\u0007\u0001C\u0001w!9A\b\u0001b\u0001\n#i\u0004BB&\u0001A\u0003%a\bC\u0004M\u0001\t\u0007I\u0011C'\t\rQ\u0003\u0001\u0015!\u0003O\u0011\u001d)\u0006A1A\u0005\u00125CaA\u0016\u0001!\u0002\u0013q\u0005bB,\u0001\u0005\u0004%\t\"\u0010\u0005\u00071\u0002\u0001\u000b\u0011\u0002 \t\u000fe\u0003!\u0019!C\t{!1!\f\u0001Q\u0001\nyBQa\u0017\u0001\u0005\u0002qCQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001e\u0001\u0005\u0002\tDQ!\u001e\u0001\u0005\u0002qCQA\u001e\u0001\u0005\u0002qCQa\u001e\u0001\u0005BaDq!!\u0006\u0001\t\u0003\n9BA\tIe={%\u000fZ5oC2lU\r\u001e:jGNT!\u0001G\r\u0002\u000f5,GO]5dg*\u0011!dG\u0001\u0003[2T!\u0001H\u000f\u0002\u0013M\u0004\u0018M]6mS:<'B\u0001\u0010 \u0003\rA'g\u001c\u0006\u0002A\u0005\u0011\u0011-[\u0002\u0001'\t\u00011\u0005\u0005\u0002%K5\tq#\u0003\u0002'/\t\u0001\u0002JM(D_6lwN\\'fiJL7m]\u0001\u0004k&$W#A\u0015\u0011\u0005)\u001adBA\u00162!\tas&D\u0001.\u0015\tq\u0013%\u0001\u0004=e>|GO\u0010\u0006\u0002a\u0005)1oY1mC&\u0011!gL\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023_\u0005!Q/\u001b3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011H\u000f\t\u0003I\u0001AQaJ\u0002A\u0002%\"\u0012!O\u0001\u0003eJ*\u0012A\u0010\t\u0003\u007f%k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQ\u0001]1sC6T!AG\"\u000b\u0005\u0011+\u0015!B:qCJ\\'B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001eL!A\u0013!\u0003\u0017\u0011{WO\u00197f!\u0006\u0014\u0018-\\\u0001\u0004eJ\u0002\u0013!\u00045jiJ\u000bG/[8UC\ndW-F\u0001O!\ty%+D\u0001Q\u0015\t\t\u0016$\u0001\u0004qCJ\fWn]\u0005\u0003'B\u0013aCT;mY\u0006\u0014G.\u001a#bi\u00064%/Y7f!\u0006\u0014\u0018-\\\u0001\u000fQ&$(+\u0019;j_R\u000b'\r\\3!\u0003=\u0019wN\u001c4vg&|g.T1ue&D\u0018\u0001E2p]\u001a,8/[8o\u001b\u0006$(/\u001b=!\u0003\u001dawn\u001a7pgN\f\u0001\u0002\\8hY>\u001c8\u000fI\u0001\u0012[\u0016\fg\u000eU3s\u00072\f7o]#se>\u0014\u0018AE7fC:\u0004VM]\"mCN\u001cXI\u001d:pe\u0002\nQaZ3u%J\"\u0012!\u0018\t\u0003=~k\u0011aL\u0005\u0003A>\u0012a\u0001R8vE2,\u0017\u0001E4fi\"KGOU1uS>$\u0016M\u00197f)\u0005\u0019\u0007C\u00013r\u001d\t)gN\u0004\u0002gY:\u0011qm\u001b\b\u0003Q*t!\u0001L5\n\u0003!K!AR$\n\u0005\u0011+\u0015BA7D\u0003\r\u0019\u0018\u000f\\\u0005\u0003_B\fq\u0001]1dW\u0006<WM\u0003\u0002n\u0007&\u0011!o\u001d\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!a\u001c9\u0002%\u001d,GoQ8oMV\u001c\u0018n\u001c8NCR\u0014\u0018\u000e_\u0001\u000bO\u0016$Hj\\4m_N\u001c\u0018\u0001F4fi6+\u0017M\u001c)fe\u000ec\u0017m]:FeJ|'/\u0001\u0006tKRlU\r\u001e:jGN$B!\u001f?\u0002\u0012A\u0011aL_\u0005\u0003w>\u0012A!\u00168ji\")Q\u0010\u0006a\u0001}\u0006!!n]8o!\ry\u0018QB\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!qm]8o\u0015\u0011\t9!!\u0003\u0002\r\u001d|wn\u001a7f\u0015\t\tY!A\u0002d_6LA!a\u0004\u0002\u0002\tQ!j]8o\u001f\nTWm\u0019;\t\r\u0005MA\u00031\u0001*\u0003\u001d\u0019wN\u001c;fqR\fAaY8qsR!\u0011\u0011DA\u000e\u001b\u0005\u0001\u0001bBA\u000f+\u0001\u0007\u0011qD\u0001\u0006Kb$(/\u0019\t\u0004\u007f\u0005\u0005\u0012bAA\u0012\u0001\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0004\u0001\u0003O\ti#a\f\u0011\u0007\u0011\nI#C\u0002\u0002,]\u0011!#T3ue&\u001c7\u000fR3tGJL\u0007\u000f^5p]\u0006YA-Z:de&\u0004H/[8oC\t\t\t$\u00014UQ\u0016\u00043\r\\1tg\u0002j\u0017m[3tA\u00054\u0018-\u001b7bE2,\u0007%\u00197mA5,GO]5dg\u0002\"\b.\u0019;!g\"\f'/\u001a3!C\u000e\u0014xn]:!C2d\u0007%\u00197h_JLG\u000f[7tAM,\b\u000f]8si&tw\rI8sI&t\u0017\r\u001c\u0011sK\u001e\u0014Xm]:j_:t\u0003")
public class H2OOrdinalMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam r2;
    private final NullableDataFrameParam hitRatioTable;
    private final NullableDataFrameParam confusionMatrix;
    private final DoubleParam logloss;
    private final DoubleParam meanPerClassError;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam r2() {
        return this.r2;
    }

    public NullableDataFrameParam hitRatioTable() {
        return this.hitRatioTable;
    }

    public NullableDataFrameParam confusionMatrix() {
        return this.confusionMatrix;
    }

    public DoubleParam logloss() {
        return this.logloss;
    }

    public DoubleParam meanPerClassError() {
        return this.meanPerClassError;
    }

    public double getR2() {
        return BoxesRunTime.unboxToDouble(this.$(this.r2()));
    }

    public Dataset<Row> getHitRatioTable() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.hitRatioTable()));
    }

    public Dataset<Row> getConfusionMatrix() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.confusionMatrix()));
    }

    public double getLogloss() {
        return BoxesRunTime.unboxToDouble(this.$(this.logloss()));
    }

    public double getMeanPerClassError() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanPerClassError()));
    }

    @Override
    public void setMetrics(JsonObject json, String context) {
        block47: {
            Params params;
            block44: {
                block43: {
                    Params params2;
                    block40: {
                        block39: {
                            Params params3;
                            block36: {
                                block35: {
                                    Params params4;
                                    block32: {
                                        super.setMetrics(json, context);
                                        if (!json.has("r2")) break block32;
                                        try {
                                            params4 = this.set("r2", BoxesRunTime.boxToDouble((double)json.get("r2").getAsDouble()));
                                        }
                                        catch (Throwable throwable) {
                                            Throwable throwable2;
                                            block34: {
                                                block33: {
                                                    Throwable throwable3 = throwable;
                                                    if (throwable3 == null) break block33;
                                                    throwable2 = throwable3;
                                                    String string = System.getProperty("spark.testing", "false");
                                                    String string2 = "true";
                                                    if (string == null ? string2 != null : !string.equals(string2)) break block34;
                                                }
                                                throw throwable;
                                            }
                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unsuccessful try to extract 'r2' from ").append(context).toString(), throwable2);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            params4 = boxedUnit;
                                        }
                                        break block35;
                                    }
                                    String message = new StringBuilder(35).append("The metric 'r2' in ").append(context).append(" does not exist.").toString();
                                    String string = System.getProperty("spark.testing", "false");
                                    String string3 = "true";
                                    if (!(string == null ? string3 != null : !string.equals(string3))) {
                                        throw new AssertionError((Object)message);
                                    }
                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                    params4 = BoxedUnit.UNIT;
                                }
                                if (!json.has("hit_ratio_table")) break block36;
                                try {
                                    params3 = this.set("hitRatioTable", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "hit_ratio_table")));
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable4;
                                    block38: {
                                        block37: {
                                            Throwable throwable5 = throwable;
                                            if (throwable5 == null) break block37;
                                            throwable4 = throwable5;
                                            String string = System.getProperty("spark.testing", "false");
                                            String string4 = "true";
                                            if (string == null ? string4 != null : !string.equals(string4)) break block38;
                                        }
                                        throw throwable;
                                    }
                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Unsuccessful try to extract 'hit_ratio_table' from ").append(context).toString(), throwable4);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    params3 = boxedUnit;
                                }
                                break block39;
                            }
                            String message = new StringBuilder(48).append("The metric 'hit_ratio_table' in ").append(context).append(" does not exist.").toString();
                            String string = System.getProperty("spark.testing", "false");
                            String string5 = "true";
                            if (!(string == null ? string5 != null : !string.equals(string5))) {
                                throw new AssertionError((Object)message);
                            }
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                            params3 = BoxedUnit.UNIT;
                        }
                        if (!json.has("cm")) break block40;
                        try {
                            params2 = this.set("confusionMatrix", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.nestedJsonFieldToDataFrame(json, "cm", "table")));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable6;
                            block42: {
                                block41: {
                                    Throwable throwable7 = throwable;
                                    if (throwable7 == null) break block41;
                                    throwable6 = throwable7;
                                    String string = System.getProperty("spark.testing", "false");
                                    String string6 = "true";
                                    if (string == null ? string6 != null : !string.equals(string6)) break block42;
                                }
                                throw throwable;
                            }
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unsuccessful try to extract 'cm' from ").append(context).toString(), throwable6);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            params2 = boxedUnit;
                        }
                        break block43;
                    }
                    String message = new StringBuilder(35).append("The metric 'cm' in ").append(context).append(" does not exist.").toString();
                    String string = System.getProperty("spark.testing", "false");
                    String string7 = "true";
                    if (!(string == null ? string7 != null : !string.equals(string7))) {
                        throw new AssertionError((Object)message);
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    params2 = BoxedUnit.UNIT;
                }
                if (!json.has("logloss")) break block44;
                try {
                    params = this.set("logloss", BoxesRunTime.boxToDouble((double)json.get("logloss").getAsDouble()));
                }
                catch (Throwable throwable) {
                    Throwable throwable8;
                    block46: {
                        block45: {
                            Throwable throwable9 = throwable;
                            if (throwable9 == null) break block45;
                            throwable8 = throwable9;
                            String string = System.getProperty("spark.testing", "false");
                            String string8 = "true";
                            if (string == null ? string8 != null : !string.equals(string8)) break block46;
                        }
                        throw throwable;
                    }
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Unsuccessful try to extract 'logloss' from ").append(context).toString(), throwable8);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    params = boxedUnit;
                }
                break block47;
            }
            String message = new StringBuilder(40).append("The metric 'logloss' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (!(string == null ? string9 != null : !string.equals(string9))) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            params = BoxedUnit.UNIT;
        }
        if (json.has("mean_per_class_error")) {
            try {
                this.set("meanPerClassError", BoxesRunTime.boxToDouble((double)json.get("mean_per_class_error").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 != null) {
                    Throwable throwable11 = throwable10;
                    String string = System.getProperty("spark.testing", "false");
                    String string10 = "true";
                    if (string == null ? string10 != null : !string.equals(string10)) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Unsuccessful try to extract 'mean_per_class_error' from ").append(context).toString(), throwable11);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        } else {
            String message = new StringBuilder(53).append("The metric 'mean_per_class_error' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null ? string11 != null : !string.equals(string11)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            } else {
                throw new AssertionError((Object)message);
            }
        }
    }

    @Override
    public H2OOrdinalMetrics copy(ParamMap extra) {
        return (H2OOrdinalMetrics)this.defaultCopy(extra);
    }

    public H2OOrdinalMetrics(String uid) {
        this.uid = uid;
        this.r2 = this.doubleParam("r2", "The R^2 for this scoring run.");
        this.hitRatioTable = this.nullableDataFrameParam("hitRatioTable", "The hit ratio table for this scoring run.");
        this.confusionMatrix = this.nullableDataFrameParam("confusionMatrix", "The ConfusionMatrix object for this scoring run.");
        this.logloss = this.doubleParam("logloss", "The logarithmic loss for this scoring run.");
        this.meanPerClassError = this.doubleParam("meanPerClassError", "The mean misclassification error per class.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.r2().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.hitRatioTable().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.confusionMatrix().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.logloss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanPerClassError().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2OOrdinalMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OOrdinalMetrics"));
    }
}

