/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.DescriptorProtos;
import ai.h2o.com.google.protobuf.ExtensionRegistry;
import ai.h2o.com.google.protobuf.ExtensionRegistryLite;
import ai.h2o.com.google.protobuf.FieldSet;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import ai.h2o.com.google.protobuf.Message;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.TextFormat;
import ai.h2o.com.google.protobuf.WireFormat;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class Descriptors {
    private static final Logger logger = Logger.getLogger(Descriptors.class.getName());
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Descriptor[] EMPTY_DESCRIPTORS = new Descriptor[0];
    private static final FieldDescriptor[] EMPTY_FIELD_DESCRIPTORS = new FieldDescriptor[0];
    private static final EnumDescriptor[] EMPTY_ENUM_DESCRIPTORS = new EnumDescriptor[0];
    private static final ServiceDescriptor[] EMPTY_SERVICE_DESCRIPTORS = new ServiceDescriptor[0];
    private static final OneofDescriptor[] EMPTY_ONEOF_DESCRIPTORS = new OneofDescriptor[0];

    private static String computeFullName(FileDescriptor file, Descriptor parent, String name) {
        if (parent != null) {
            return parent.getFullName() + '.' + name;
        }
        String string = file.getPackage();
        if (!string.isEmpty()) {
            return string + '.' + name;
        }
        return name;
    }

    private static <T> T binarySearch(T[] array, int size, NumberGetter<T> getter, int number) {
        int n2 = 0;
        int n3 = size - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            T t2 = array[n4];
            int n5 = getter.getNumber(t2);
            if (number < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (number > n5) {
                n2 = n4 + 1;
                continue;
            }
            return t2;
        }
        return null;
    }

    private static interface NumberGetter<T> {
        public int getNumber(T var1);
    }

    public static final class OneofDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.OneofDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private Descriptor containingType;
        private int fieldCount;
        private FieldDescriptor[] fields;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        public final Descriptor getContainingType() {
            return this.containingType;
        }

        public final int getFieldCount() {
            return this.fieldCount;
        }

        public final DescriptorProtos.OneofOptions getOptions() {
            return this.proto.getOptions();
        }

        public final boolean isSynthetic() {
            return this.fields.length == 1 && this.fields[0].isProto3Optional;
        }

        public final List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public final FieldDescriptor getField(int index) {
            return this.fields[index];
        }

        @Override
        public final DescriptorProtos.OneofDescriptorProto toProto() {
            return this.proto;
        }

        private void setProto(DescriptorProtos.OneofDescriptorProto proto) {
            this.proto = proto;
        }

        private OneofDescriptor(DescriptorProtos.OneofDescriptorProto proto, FileDescriptor file, Descriptor parent, int index) {
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file, parent, proto.getName());
            this.file = file;
            this.index = index;
            this.containingType = parent;
            this.fieldCount = 0;
        }

        static /* synthetic */ FieldDescriptor[] access$2502(OneofDescriptor x0, FieldDescriptor[] x1) {
            x0.fields = x1;
            return x1;
        }
    }

    private static final class DescriptorPool {
        private final Set<FileDescriptor> dependencies;
        private final boolean allowUnknownDependencies;
        private final Map<String, GenericDescriptor> descriptorsByName = new HashMap<String, GenericDescriptor>();

        DescriptorPool(FileDescriptor[] dependencies, boolean allowUnknownDependencies) {
            this.dependencies = Collections.newSetFromMap(new IdentityHashMap(dependencies.length));
            this.allowUnknownDependencies = allowUnknownDependencies;
            FileDescriptor[] fileDescriptorArray = dependencies;
            int n2 = dependencies.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                FileDescriptor fileDescriptor = fileDescriptorArray[i2];
                this.dependencies.add(fileDescriptor);
                this.importPublicDependencies(fileDescriptor);
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                try {
                    this.addPackage(fileDescriptor.getPackage(), fileDescriptor);
                }
                catch (DescriptorValidationException descriptorValidationException) {
                    throw new AssertionError((Object)descriptorValidationException);
                }
            }
        }

        private void importPublicDependencies(FileDescriptor file) {
            for (FileDescriptor fileDescriptor : file.getPublicDependencies()) {
                if (!this.dependencies.add(fileDescriptor)) continue;
                this.importPublicDependencies(fileDescriptor);
            }
        }

        final GenericDescriptor findSymbol(String fullName) {
            return this.findSymbol(fullName, SearchFilter.ALL_SYMBOLS);
        }

        final GenericDescriptor findSymbol(String fullName, SearchFilter filter) {
            GenericDescriptor genericDescriptor = this.descriptorsByName.get(fullName);
            if (genericDescriptor != null && (filter == SearchFilter.ALL_SYMBOLS || filter == SearchFilter.TYPES_ONLY && this.isType(genericDescriptor) || filter == SearchFilter.AGGREGATES_ONLY && this.isAggregate(genericDescriptor))) {
                return genericDescriptor;
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                genericDescriptor = ((FileDescriptor)fileDescriptor).pool.descriptorsByName.get(fullName);
                if (genericDescriptor == null || filter != SearchFilter.ALL_SYMBOLS && (filter != SearchFilter.TYPES_ONLY || !this.isType(genericDescriptor)) && (filter != SearchFilter.AGGREGATES_ONLY || !this.isAggregate(genericDescriptor))) continue;
                return genericDescriptor;
            }
            return null;
        }

        final boolean isType(GenericDescriptor descriptor) {
            return descriptor instanceof Descriptor || descriptor instanceof EnumDescriptor;
        }

        final boolean isAggregate(GenericDescriptor descriptor) {
            return descriptor instanceof Descriptor || descriptor instanceof EnumDescriptor || descriptor instanceof PackageDescriptor || descriptor instanceof ServiceDescriptor;
        }

        final GenericDescriptor lookupSymbol(String name, GenericDescriptor relativeTo, SearchFilter filter) throws DescriptorValidationException {
            GenericDescriptor genericDescriptor;
            String string;
            if (name.startsWith(".")) {
                string = name.substring(1);
                genericDescriptor = this.findSymbol(string, filter);
            } else {
                int n2 = name.indexOf(46);
                String string2 = n2 == -1 ? name : name.substring(0, n2);
                StringBuilder stringBuilder = new StringBuilder(relativeTo.getFullName());
                while (true) {
                    int n3;
                    if ((n3 = stringBuilder.lastIndexOf(".")) == -1) {
                        string = name;
                        genericDescriptor = this.findSymbol(name, filter);
                        break;
                    }
                    stringBuilder.setLength(n3 + 1);
                    stringBuilder.append(string2);
                    genericDescriptor = this.findSymbol(stringBuilder.toString(), SearchFilter.AGGREGATES_ONLY);
                    if (genericDescriptor != null) {
                        if (n2 != -1) {
                            stringBuilder.setLength(n3 + 1);
                            stringBuilder.append(name);
                            genericDescriptor = this.findSymbol(stringBuilder.toString(), filter);
                        }
                        string = stringBuilder.toString();
                        break;
                    }
                    stringBuilder.setLength(n3);
                }
            }
            if (genericDescriptor == null) {
                if (this.allowUnknownDependencies && filter == SearchFilter.TYPES_ONLY) {
                    logger.warning("The descriptor for message type \"" + name + "\" cannot be found and a placeholder is created for it");
                    genericDescriptor = new Descriptor(string);
                    this.dependencies.add(genericDescriptor.getFile());
                    return genericDescriptor;
                }
                throw new DescriptorValidationException(relativeTo, "\"" + name + "\" is not defined.");
            }
            return genericDescriptor;
        }

        final void addSymbol(GenericDescriptor descriptor) throws DescriptorValidationException {
            DescriptorPool.validateSymbolName(descriptor);
            String string = descriptor.getFullName();
            GenericDescriptor genericDescriptor = this.descriptorsByName.put(string, descriptor);
            if (genericDescriptor != null) {
                this.descriptorsByName.put(string, genericDescriptor);
                if (descriptor.getFile() == genericDescriptor.getFile()) {
                    int n2 = string.lastIndexOf(46);
                    if (n2 == -1) {
                        throw new DescriptorValidationException(descriptor, "\"" + string + "\" is already defined.");
                    }
                    throw new DescriptorValidationException(descriptor, "\"" + string.substring(n2 + 1) + "\" is already defined in \"" + string.substring(0, n2) + "\".");
                }
                throw new DescriptorValidationException(descriptor, "\"" + string + "\" is already defined in file \"" + genericDescriptor.getFile().getName() + "\".");
            }
        }

        final void addPackage(String fullName, FileDescriptor file) throws DescriptorValidationException {
            String string;
            int n2 = fullName.lastIndexOf(46);
            if (n2 == -1) {
                string = fullName;
            } else {
                this.addPackage(fullName.substring(0, n2), file);
                string = fullName.substring(n2 + 1);
            }
            GenericDescriptor genericDescriptor = this.descriptorsByName.put(fullName, new PackageDescriptor(string, fullName, file));
            if (genericDescriptor != null) {
                this.descriptorsByName.put(fullName, genericDescriptor);
                if (!(genericDescriptor instanceof PackageDescriptor)) {
                    throw new DescriptorValidationException(file, "\"" + string + "\" is already defined (as something other than a package) in file \"" + genericDescriptor.getFile().getName() + "\".");
                }
            }
        }

        static void validateSymbolName(GenericDescriptor descriptor) throws DescriptorValidationException {
            String string = descriptor.getName();
            if (string.length() == 0) {
                throw new DescriptorValidationException(descriptor, "Missing name.");
            }
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || c2 == '_' || '0' <= c2 && c2 <= '9' && i2 > 0) continue;
                throw new DescriptorValidationException(descriptor, "\"" + string + "\" is not a valid identifier.");
            }
        }

        private static final class PackageDescriptor
        extends GenericDescriptor {
            private final String name;
            private final String fullName;
            private final FileDescriptor file;

            @Override
            public final Message toProto() {
                return this.file.toProto();
            }

            @Override
            public final String getName() {
                return this.name;
            }

            @Override
            public final String getFullName() {
                return this.fullName;
            }

            @Override
            public final FileDescriptor getFile() {
                return this.file;
            }

            PackageDescriptor(String name, String fullName, FileDescriptor file) {
                this.file = file;
                this.fullName = fullName;
                this.name = name;
            }
        }

        static enum SearchFilter {
            TYPES_ONLY,
            AGGREGATES_ONLY,
            ALL_SYMBOLS;

        }
    }

    public static class DescriptorValidationException
    extends Exception {
        private static final long serialVersionUID = 5750205775490483148L;
        private final String name;
        private final Message proto;
        private final String description;

        public String getProblemSymbolName() {
            return this.name;
        }

        public Message getProblemProto() {
            return this.proto;
        }

        public String getDescription() {
            return this.description;
        }

        private DescriptorValidationException(GenericDescriptor problemDescriptor, String description) {
            super(problemDescriptor.getFullName() + ": " + description);
            this.name = problemDescriptor.getFullName();
            this.proto = problemDescriptor.toProto();
            this.description = description;
        }

        private DescriptorValidationException(GenericDescriptor problemDescriptor, String description, Throwable cause) {
            this(problemDescriptor, description);
            this.initCause(cause);
        }

        private DescriptorValidationException(FileDescriptor problemDescriptor, String description) {
            super(problemDescriptor.getName() + ": " + description);
            this.name = problemDescriptor.getName();
            this.proto = problemDescriptor.toProto();
            this.description = description;
        }
    }

    public static abstract class GenericDescriptor {
        private GenericDescriptor() {
        }

        public abstract Message toProto();

        public abstract String getName();

        public abstract String getFullName();

        public abstract FileDescriptor getFile();
    }

    public static final class MethodDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.MethodDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final ServiceDescriptor service;
        private Descriptor inputType;
        private Descriptor outputType;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final DescriptorProtos.MethodDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        public final ServiceDescriptor getService() {
            return this.service;
        }

        public final Descriptor getInputType() {
            return this.inputType;
        }

        public final Descriptor getOutputType() {
            return this.outputType;
        }

        public final boolean isClientStreaming() {
            return this.proto.getClientStreaming();
        }

        public final boolean isServerStreaming() {
            return this.proto.getServerStreaming();
        }

        public final DescriptorProtos.MethodOptions getOptions() {
            return this.proto.getOptions();
        }

        private MethodDescriptor(DescriptorProtos.MethodDescriptorProto proto, FileDescriptor file, ServiceDescriptor parent, int index) throws DescriptorValidationException {
            this.index = index;
            this.proto = proto;
            this.file = file;
            this.service = parent;
            this.fullName = parent.getFullName() + '.' + proto.getName();
            file.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor = this.getFile().pool.lookupSymbol(this.proto.getInputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, "\"" + this.proto.getInputType() + "\" is not a message type.");
            }
            this.inputType = (Descriptor)genericDescriptor;
            GenericDescriptor genericDescriptor2 = this.getFile().pool.lookupSymbol(this.proto.getOutputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor2 instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, "\"" + this.proto.getOutputType() + "\" is not a message type.");
            }
            this.outputType = (Descriptor)genericDescriptor2;
        }

        private void setProto(DescriptorProtos.MethodDescriptorProto proto) {
            this.proto = proto;
        }
    }

    public static final class ServiceDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.ServiceDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private MethodDescriptor[] methods;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final DescriptorProtos.ServiceDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        public final DescriptorProtos.ServiceOptions getOptions() {
            return this.proto.getOptions();
        }

        public final List<MethodDescriptor> getMethods() {
            return Collections.unmodifiableList(Arrays.asList(this.methods));
        }

        public final MethodDescriptor findMethodByName(String name) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + name);
            if (genericDescriptor instanceof MethodDescriptor) {
                return (MethodDescriptor)genericDescriptor;
            }
            return null;
        }

        private ServiceDescriptor(DescriptorProtos.ServiceDescriptorProto proto, FileDescriptor file, int index) throws DescriptorValidationException {
            this.index = index;
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file, null, proto.getName());
            this.file = file;
            this.methods = new MethodDescriptor[proto.getMethodCount()];
            for (int i2 = 0; i2 < proto.getMethodCount(); ++i2) {
                this.methods[i2] = new MethodDescriptor(proto.getMethod(i2), file, this, i2);
            }
            file.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            MethodDescriptor[] methodDescriptorArray = this.methods;
            int n2 = this.methods.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MethodDescriptor methodDescriptor = methodDescriptorArray[i2];
                methodDescriptor.crossLink();
            }
        }

        private void setProto(DescriptorProtos.ServiceDescriptorProto proto) {
            this.proto = proto;
            for (int i2 = 0; i2 < this.methods.length; ++i2) {
                this.methods[i2].setProto(proto.getMethod(i2));
            }
        }
    }

    public static final class EnumValueDescriptor
    extends GenericDescriptor
    implements Internal.EnumLite {
        static final Comparator<EnumValueDescriptor> BY_NUMBER = new Comparator<EnumValueDescriptor>(){

            @Override
            public final int compare(EnumValueDescriptor o1, EnumValueDescriptor o2) {
                return Integer.valueOf(o1.getNumber()).compareTo(o2.getNumber());
            }
        };
        static final NumberGetter<EnumValueDescriptor> NUMBER_GETTER = new NumberGetter<EnumValueDescriptor>(){

            @Override
            public final int getNumber(EnumValueDescriptor enumValueDescriptor) {
                return enumValueDescriptor.getNumber();
            }
        };
        private final int index;
        private DescriptorProtos.EnumValueDescriptorProto proto;
        private final String fullName;
        private final EnumDescriptor type;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final DescriptorProtos.EnumValueDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final int getNumber() {
            return this.proto.getNumber();
        }

        public final String toString() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.type.file;
        }

        public final EnumDescriptor getType() {
            return this.type;
        }

        public final DescriptorProtos.EnumValueOptions getOptions() {
            return this.proto.getOptions();
        }

        private EnumValueDescriptor(DescriptorProtos.EnumValueDescriptorProto proto, FileDescriptor file, EnumDescriptor parent, int index) throws DescriptorValidationException {
            this.index = index;
            this.proto = proto;
            this.type = parent;
            this.fullName = parent.getFullName() + '.' + proto.getName();
            file.pool.addSymbol(this);
        }

        private EnumValueDescriptor(EnumDescriptor parent, Integer number) {
            String string = "UNKNOWN_ENUM_VALUE_" + parent.getName() + "_" + number;
            DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto = DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName(string).setNumber(number).build();
            this.index = -1;
            this.proto = enumValueDescriptorProto;
            this.type = parent;
            this.fullName = parent.getFullName() + '.' + enumValueDescriptorProto.getName();
        }

        private void setProto(DescriptorProtos.EnumValueDescriptorProto proto) {
            this.proto = proto;
        }
    }

    public static final class EnumDescriptor
    extends GenericDescriptor
    implements Internal.EnumLiteMap<EnumValueDescriptor> {
        private final int index;
        private DescriptorProtos.EnumDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final EnumValueDescriptor[] values;
        private final EnumValueDescriptor[] valuesSortedByNumber;
        private final int distinctNumbers;
        private Map<Integer, WeakReference<EnumValueDescriptor>> unknownValues = null;
        private ReferenceQueue<EnumValueDescriptor> cleanupQueue = null;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final DescriptorProtos.EnumDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        public final Descriptor getContainingType() {
            return this.containingType;
        }

        public final DescriptorProtos.EnumOptions getOptions() {
            return this.proto.getOptions();
        }

        public final List<EnumValueDescriptor> getValues() {
            return Collections.unmodifiableList(Arrays.asList(this.values));
        }

        public final EnumValueDescriptor findValueByName(String name) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + name);
            if (genericDescriptor instanceof EnumValueDescriptor) {
                return (EnumValueDescriptor)genericDescriptor;
            }
            return null;
        }

        @Override
        public final EnumValueDescriptor findValueByNumber(int number) {
            return (EnumValueDescriptor)Descriptors.binarySearch(this.valuesSortedByNumber, this.distinctNumbers, EnumValueDescriptor.NUMBER_GETTER, number);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final EnumValueDescriptor findValueByNumberCreatingIfUnknown(int number) {
            EnumValueDescriptor enumValueDescriptor = this.findValueByNumber(number);
            if (enumValueDescriptor != null) {
                return enumValueDescriptor;
            }
            EnumDescriptor enumDescriptor = this;
            synchronized (enumDescriptor) {
                WeakReference weakReference;
                if (this.cleanupQueue == null) {
                    this.cleanupQueue = new ReferenceQueue();
                    this.unknownValues = new HashMap<Integer, WeakReference<EnumValueDescriptor>>();
                } else {
                    while ((weakReference = (UnknownEnumValueReference)this.cleanupQueue.poll()) != null) {
                        this.unknownValues.remove(((UnknownEnumValueReference)weakReference).number);
                    }
                }
                weakReference = this.unknownValues.get(number);
                enumValueDescriptor = weakReference == null ? null : (EnumValueDescriptor)weakReference.get();
                if (enumValueDescriptor == null) {
                    enumValueDescriptor = new EnumValueDescriptor(this, number);
                    this.unknownValues.put(number, new UnknownEnumValueReference(number, enumValueDescriptor));
                }
            }
            return enumValueDescriptor;
        }

        final int getUnknownEnumValueDescriptorCount() {
            return this.unknownValues.size();
        }

        private EnumDescriptor(DescriptorProtos.EnumDescriptorProto proto, FileDescriptor file, Descriptor parent, int index) throws DescriptorValidationException {
            int n2;
            this.index = index;
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file, parent, proto.getName());
            this.file = file;
            this.containingType = parent;
            if (proto.getValueCount() == 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Enums must contain at least one value.");
            }
            this.values = new EnumValueDescriptor[proto.getValueCount()];
            for (n2 = 0; n2 < proto.getValueCount(); ++n2) {
                this.values[n2] = new EnumValueDescriptor(proto.getValue(n2), file, this, n2);
            }
            this.valuesSortedByNumber = (EnumValueDescriptor[])this.values.clone();
            Arrays.sort(this.valuesSortedByNumber, EnumValueDescriptor.BY_NUMBER);
            n2 = 0;
            for (int i2 = 1; i2 < proto.getValueCount(); ++i2) {
                EnumValueDescriptor enumValueDescriptor = this.valuesSortedByNumber[n2];
                EnumValueDescriptor enumValueDescriptor2 = this.valuesSortedByNumber[i2];
                if (enumValueDescriptor.getNumber() == enumValueDescriptor2.getNumber()) continue;
                this.valuesSortedByNumber[++n2] = enumValueDescriptor2;
            }
            this.distinctNumbers = n2 + 1;
            Arrays.fill(this.valuesSortedByNumber, this.distinctNumbers, proto.getValueCount(), null);
            file.pool.addSymbol(this);
        }

        private void setProto(DescriptorProtos.EnumDescriptorProto proto) {
            this.proto = proto;
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].setProto(proto.getValue(i2));
            }
        }

        private static class UnknownEnumValueReference
        extends WeakReference<EnumValueDescriptor> {
            private final int number;

            private UnknownEnumValueReference(int number, EnumValueDescriptor descriptor) {
                super(descriptor);
                this.number = number;
            }
        }
    }

    public static final class FieldDescriptor
    extends GenericDescriptor
    implements FieldSet.FieldDescriptorLite<FieldDescriptor>,
    Comparable<FieldDescriptor> {
        private static final NumberGetter<FieldDescriptor> NUMBER_GETTER = new NumberGetter<FieldDescriptor>(){

            @Override
            public final int getNumber(FieldDescriptor fieldDescriptor) {
                return fieldDescriptor.getNumber();
            }
        };
        private static final WireFormat.FieldType[] table = WireFormat.FieldType.values();
        private final int index;
        private DescriptorProtos.FieldDescriptorProto proto;
        private final String fullName;
        private String jsonName;
        private final FileDescriptor file;
        private final Descriptor extensionScope;
        private final boolean isProto3Optional;
        private Type type;
        private Descriptor containingType;
        private Descriptor messageType;
        private OneofDescriptor containingOneof;
        private EnumDescriptor enumType;
        private Object defaultValue;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final DescriptorProtos.FieldDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final int getNumber() {
            return this.proto.getNumber();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        public final String getJsonName() {
            String string = this.jsonName;
            if (string != null) {
                return string;
            }
            if (this.proto.hasJsonName()) {
                this.jsonName = this.proto.getJsonName();
                return this.jsonName;
            }
            this.jsonName = FieldDescriptor.fieldNameToJsonName(this.proto.getName());
            return this.jsonName;
        }

        public final JavaType getJavaType() {
            return this.type.getJavaType();
        }

        @Override
        public final WireFormat.JavaType getLiteJavaType() {
            return this.getLiteType().getJavaType();
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        public final Type getType() {
            return this.type;
        }

        @Override
        public final WireFormat.FieldType getLiteType() {
            return table[this.type.ordinal()];
        }

        public final boolean needsUtf8Check() {
            if (this.type != Type.STRING) {
                return false;
            }
            if (this.getContainingType().getOptions().getMapEntry()) {
                return true;
            }
            if (this.getFile().getSyntax() == FileDescriptor.Syntax.PROTO3) {
                return true;
            }
            return this.getFile().getOptions().getJavaStringCheckUtf8();
        }

        public final boolean isMapField() {
            return this.getType() == Type.MESSAGE && this.isRepeated() && this.getMessageType().getOptions().getMapEntry();
        }

        public final boolean isRequired() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
        }

        public final boolean isOptional() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL;
        }

        @Override
        public final boolean isRepeated() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
        }

        @Override
        public final boolean isPacked() {
            if (!this.isPackable()) {
                return false;
            }
            if (this.getFile().getSyntax() == FileDescriptor.Syntax.PROTO2) {
                return this.getOptions().getPacked();
            }
            return !this.getOptions().hasPacked() || this.getOptions().getPacked();
        }

        public final boolean isPackable() {
            return this.isRepeated() && this.getLiteType().isPackable();
        }

        public final boolean hasDefaultValue() {
            return this.proto.hasDefaultValue();
        }

        public final Object getDefaultValue() {
            if (this.getJavaType() == JavaType.MESSAGE) {
                throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
            }
            return this.defaultValue;
        }

        public final DescriptorProtos.FieldOptions getOptions() {
            return this.proto.getOptions();
        }

        public final boolean isExtension() {
            return this.proto.hasExtendee();
        }

        public final Descriptor getContainingType() {
            return this.containingType;
        }

        public final OneofDescriptor getContainingOneof() {
            return this.containingOneof;
        }

        public final OneofDescriptor getRealContainingOneof() {
            if (this.containingOneof != null && !this.containingOneof.isSynthetic()) {
                return this.containingOneof;
            }
            return null;
        }

        public final boolean hasOptionalKeyword() {
            return this.isProto3Optional || this.file.getSyntax() == FileDescriptor.Syntax.PROTO2 && this.isOptional() && this.getContainingOneof() == null;
        }

        public final boolean hasPresence() {
            if (this.isRepeated()) {
                return false;
            }
            return this.getType() == Type.MESSAGE || this.getType() == Type.GROUP || this.getContainingOneof() != null || this.file.getSyntax() == FileDescriptor.Syntax.PROTO2;
        }

        public final Descriptor getExtensionScope() {
            if (!this.isExtension()) {
                throw new UnsupportedOperationException(String.format("This field is not an extension. (%s)", this.fullName));
            }
            return this.extensionScope;
        }

        public final Descriptor getMessageType() {
            if (this.getJavaType() != JavaType.MESSAGE) {
                throw new UnsupportedOperationException(String.format("This field is not of message type. (%s)", this.fullName));
            }
            return this.messageType;
        }

        public final EnumDescriptor getEnumType() {
            if (this.getJavaType() != JavaType.ENUM) {
                throw new UnsupportedOperationException(String.format("This field is not of enum type. (%s)", this.fullName));
            }
            return this.enumType;
        }

        @Override
        public final int compareTo(FieldDescriptor other) {
            if (other.containingType != this.containingType) {
                throw new IllegalArgumentException("FieldDescriptors can only be compared to other FieldDescriptors for fields of the same message type.");
            }
            return this.getNumber() - other.getNumber();
        }

        public final String toString() {
            return this.getFullName();
        }

        private static String fieldNameToJsonName(String name) {
            int n2 = name.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            boolean bl = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = name.charAt(i2);
                if (c2 == '_') {
                    bl = true;
                    continue;
                }
                if (bl) {
                    if ('a' <= c2 && c2 <= 'z') {
                        c2 = (char)(c2 - 97 + 65);
                    }
                    stringBuilder.append(c2);
                    bl = false;
                    continue;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }

        private FieldDescriptor(DescriptorProtos.FieldDescriptorProto proto, FileDescriptor file, Descriptor parent, int index, boolean isExtension) throws DescriptorValidationException {
            this.index = index;
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file, parent, proto.getName());
            this.file = file;
            if (proto.hasType()) {
                this.type = Type.valueOf(proto.getType());
            }
            this.isProto3Optional = proto.getProto3Optional();
            if (this.getNumber() <= 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field numbers must be positive integers.");
            }
            if (isExtension) {
                if (!proto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee not set for extension field.");
                }
                this.containingType = null;
                this.extensionScope = parent != null ? parent : null;
                if (proto.hasOneofIndex()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index set for extension field.");
                }
                this.containingOneof = null;
            } else {
                if (proto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee set for non-extension field.");
                }
                this.containingType = parent;
                if (proto.hasOneofIndex()) {
                    if (proto.getOneofIndex() < 0 || proto.getOneofIndex() >= parent.toProto().getOneofDeclCount()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index is out of range for type " + parent.getName());
                    }
                    this.containingOneof = parent.getOneofs().get(proto.getOneofIndex());
                    this.containingOneof.fieldCount++;
                } else {
                    this.containingOneof = null;
                }
                this.extensionScope = null;
            }
            file.pool.addSymbol(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void crossLink() throws DescriptorValidationException {
            block47: {
                block46: {
                    GenericDescriptor genericDescriptor;
                    if (this.proto.hasExtendee()) {
                        genericDescriptor = this.file.pool.lookupSymbol(this.proto.getExtendee(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                        if (!(genericDescriptor instanceof Descriptor)) {
                            throw new DescriptorValidationException((GenericDescriptor)this, "\"" + this.proto.getExtendee() + "\" is not a message type.");
                        }
                        this.containingType = (Descriptor)genericDescriptor;
                        if (!this.getContainingType().isExtensionNumber(this.getNumber())) {
                            throw new DescriptorValidationException((GenericDescriptor)this, "\"" + this.getContainingType().getFullName() + "\" does not declare " + this.getNumber() + " as an extension number.");
                        }
                    }
                    if (this.proto.hasTypeName()) {
                        genericDescriptor = this.file.pool.lookupSymbol(this.proto.getTypeName(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                        if (!this.proto.hasType()) {
                            if (genericDescriptor instanceof Descriptor) {
                                this.type = Type.MESSAGE;
                            } else {
                                if (!(genericDescriptor instanceof EnumDescriptor)) throw new DescriptorValidationException((GenericDescriptor)this, "\"" + this.proto.getTypeName() + "\" is not a type.");
                                this.type = Type.ENUM;
                            }
                        }
                        if (this.getJavaType() == JavaType.MESSAGE) {
                            if (!(genericDescriptor instanceof Descriptor)) {
                                throw new DescriptorValidationException((GenericDescriptor)this, "\"" + this.proto.getTypeName() + "\" is not a message type.");
                            }
                            this.messageType = (Descriptor)genericDescriptor;
                            if (this.proto.hasDefaultValue()) {
                                throw new DescriptorValidationException((GenericDescriptor)this, "Messages can't have default values.");
                            }
                        } else {
                            if (this.getJavaType() != JavaType.ENUM) throw new DescriptorValidationException((GenericDescriptor)this, "Field with primitive type has type_name.");
                            if (!(genericDescriptor instanceof EnumDescriptor)) {
                                throw new DescriptorValidationException((GenericDescriptor)this, "\"" + this.proto.getTypeName() + "\" is not an enum type.");
                            }
                            this.enumType = (EnumDescriptor)genericDescriptor;
                        }
                    } else if (this.getJavaType() == JavaType.MESSAGE || this.getJavaType() == JavaType.ENUM) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "Field with message or enum type missing type_name.");
                    }
                    if (this.proto.getOptions().getPacked() && !this.isPackable()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "[packed = true] can only be specified for repeated primitive fields.");
                    }
                    if (!this.proto.hasDefaultValue()) break block46;
                    if (this.isRepeated()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "Repeated fields cannot have default values.");
                    }
                    try {
                        switch (this.getType()) {
                            case INT32: 
                            case SINT32: 
                            case SFIXED32: {
                                this.defaultValue = TextFormat.parseInt32(this.proto.getDefaultValue());
                                break;
                            }
                            case UINT32: 
                            case FIXED32: {
                                this.defaultValue = TextFormat.parseUInt32(this.proto.getDefaultValue());
                                break;
                            }
                            case INT64: 
                            case SINT64: 
                            case SFIXED64: {
                                this.defaultValue = TextFormat.parseInt64(this.proto.getDefaultValue());
                                break;
                            }
                            case UINT64: 
                            case FIXED64: {
                                this.defaultValue = TextFormat.parseUInt64(this.proto.getDefaultValue());
                                break;
                            }
                            case FLOAT: {
                                if (this.proto.getDefaultValue().equals("inf")) {
                                    this.defaultValue = Float.valueOf(Float.POSITIVE_INFINITY);
                                    break;
                                }
                                if (this.proto.getDefaultValue().equals("-inf")) {
                                    this.defaultValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                                    break;
                                }
                                if (this.proto.getDefaultValue().equals("nan")) {
                                    this.defaultValue = Float.valueOf(Float.NaN);
                                    break;
                                }
                                this.defaultValue = Float.valueOf(this.proto.getDefaultValue());
                                break;
                            }
                            case DOUBLE: {
                                if (this.proto.getDefaultValue().equals("inf")) {
                                    this.defaultValue = Double.POSITIVE_INFINITY;
                                    break;
                                }
                                if (this.proto.getDefaultValue().equals("-inf")) {
                                    this.defaultValue = Double.NEGATIVE_INFINITY;
                                    break;
                                }
                                if (this.proto.getDefaultValue().equals("nan")) {
                                    this.defaultValue = Double.NaN;
                                    break;
                                }
                                this.defaultValue = Double.valueOf(this.proto.getDefaultValue());
                                break;
                            }
                            case BOOL: {
                                this.defaultValue = Boolean.valueOf(this.proto.getDefaultValue());
                                break;
                            }
                            case STRING: {
                                this.defaultValue = this.proto.getDefaultValue();
                                break;
                            }
                            case BYTES: {
                                try {
                                    this.defaultValue = TextFormat.unescapeBytes(this.proto.getDefaultValue());
                                    break;
                                }
                                catch (TextFormat.InvalidEscapeSequenceException invalidEscapeSequenceException) {
                                    throw new DescriptorValidationException(this, "Couldn't parse default value: " + invalidEscapeSequenceException.getMessage(), invalidEscapeSequenceException);
                                }
                            }
                            case ENUM: {
                                this.defaultValue = this.enumType.findValueByName(this.proto.getDefaultValue());
                                if (this.defaultValue == null) {
                                    throw new DescriptorValidationException((GenericDescriptor)this, "Unknown enum default value: \"" + this.proto.getDefaultValue() + '\"');
                                }
                                break block47;
                            }
                            case MESSAGE: 
                            case GROUP: {
                                throw new DescriptorValidationException((GenericDescriptor)this, "Message type had default value.");
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new DescriptorValidationException(this, "Could not parse default value: \"" + this.proto.getDefaultValue() + '\"', numberFormatException);
                    }
                }
                if (this.isRepeated()) {
                    this.defaultValue = Collections.emptyList();
                } else {
                    switch (this.getJavaType()) {
                        case ENUM: {
                            this.defaultValue = this.enumType.getValues().get(0);
                            break;
                        }
                        case MESSAGE: {
                            this.defaultValue = null;
                            break;
                        }
                        default: {
                            this.defaultValue = this.getJavaType().defaultDefault;
                        }
                    }
                }
            }
            if (this.containingType == null || !this.containingType.getOptions().getMessageSetWireFormat()) return;
            if (!this.isExtension()) throw new DescriptorValidationException((GenericDescriptor)this, "MessageSets cannot have fields, only extensions.");
            if (this.isOptional() && this.getType() == Type.MESSAGE) return;
            throw new DescriptorValidationException((GenericDescriptor)this, "Extensions of MessageSets must be optional messages.");
        }

        private void setProto(DescriptorProtos.FieldDescriptorProto proto) {
            this.proto = proto;
        }

        @Override
        public final MessageLite.Builder internalMergeFrom(MessageLite.Builder to, MessageLite from) {
            return ((Message.Builder)to).mergeFrom((Message)from);
        }

        static {
            if (Type.types.length != DescriptorProtos.FieldDescriptorProto.Type.values().length) {
                throw new RuntimeException("descriptor.proto has a new declared type but Descriptors.java wasn't updated.");
            }
        }

        public static enum JavaType {
            INT(0),
            LONG(0L),
            FLOAT(Float.valueOf(0.0f)),
            DOUBLE(0.0),
            BOOLEAN(Boolean.FALSE),
            STRING(""),
            BYTE_STRING(ByteString.EMPTY),
            ENUM(null),
            MESSAGE(null);

            private final Object defaultDefault;

            private JavaType(Object defaultDefault) {
                this.defaultDefault = defaultDefault;
            }
        }

        public static enum Type {
            DOUBLE(JavaType.DOUBLE),
            FLOAT(JavaType.FLOAT),
            INT64(JavaType.LONG),
            UINT64(JavaType.LONG),
            INT32(JavaType.INT),
            FIXED64(JavaType.LONG),
            FIXED32(JavaType.INT),
            BOOL(JavaType.BOOLEAN),
            STRING(JavaType.STRING),
            GROUP(JavaType.MESSAGE),
            MESSAGE(JavaType.MESSAGE),
            BYTES(JavaType.BYTE_STRING),
            UINT32(JavaType.INT),
            ENUM(JavaType.ENUM),
            SFIXED32(JavaType.INT),
            SFIXED64(JavaType.LONG),
            SINT32(JavaType.INT),
            SINT64(JavaType.LONG);

            private static final Type[] types;
            private final JavaType javaType;

            private Type(JavaType javaType) {
                this.javaType = javaType;
            }

            public final DescriptorProtos.FieldDescriptorProto.Type toProto() {
                return DescriptorProtos.FieldDescriptorProto.Type.forNumber(this.ordinal() + 1);
            }

            public final JavaType getJavaType() {
                return this.javaType;
            }

            public static Type valueOf(DescriptorProtos.FieldDescriptorProto.Type type) {
                return types[type.getNumber() - 1];
            }

            static {
                types = Type.values();
            }
        }
    }

    public static final class Descriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.DescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final Descriptor[] nestedTypes;
        private final EnumDescriptor[] enumTypes;
        private final FieldDescriptor[] fields;
        private final FieldDescriptor[] fieldsSortedByNumber;
        private final FieldDescriptor[] extensions;
        private final OneofDescriptor[] oneofs;
        private final int realOneofCount;
        private final int[] extensionRangeLowerBounds;
        private final int[] extensionRangeUpperBounds;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final DescriptorProtos.DescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        public final Descriptor getContainingType() {
            return this.containingType;
        }

        public final DescriptorProtos.MessageOptions getOptions() {
            return this.proto.getOptions();
        }

        public final List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public final List<OneofDescriptor> getOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs));
        }

        public final List<OneofDescriptor> getRealOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs).subList(0, this.realOneofCount));
        }

        public final List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public final List<Descriptor> getNestedTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.nestedTypes));
        }

        public final List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public final boolean isExtensionNumber(int number) {
            int n2 = Arrays.binarySearch(this.extensionRangeLowerBounds, number);
            if (n2 < 0) {
                n2 = ~n2 - 1;
            }
            return n2 >= 0 && number < this.extensionRangeUpperBounds[n2];
        }

        public final boolean isReservedNumber(int number) {
            for (DescriptorProtos.DescriptorProto.ReservedRange reservedRange : this.proto.getReservedRangeList()) {
                if (reservedRange.getStart() > number || number >= reservedRange.getEnd()) continue;
                return true;
            }
            return false;
        }

        public final boolean isReservedName(String name) {
            Internal.checkNotNull(name);
            for (String string : this.proto.getReservedNameList()) {
                if (!string.equals(name)) continue;
                return true;
            }
            return false;
        }

        public final boolean isExtendable() {
            return !this.proto.getExtensionRangeList().isEmpty();
        }

        public final FieldDescriptor findFieldByName(String name) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + name);
            if (genericDescriptor instanceof FieldDescriptor) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public final FieldDescriptor findFieldByNumber(int number) {
            return (FieldDescriptor)Descriptors.binarySearch(this.fieldsSortedByNumber, this.fieldsSortedByNumber.length, FieldDescriptor.NUMBER_GETTER, number);
        }

        public final Descriptor findNestedTypeByName(String name) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + name);
            if (genericDescriptor instanceof Descriptor) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public final EnumDescriptor findEnumTypeByName(String name) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + name);
            if (genericDescriptor instanceof EnumDescriptor) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        Descriptor(String fullname) throws DescriptorValidationException {
            String string = fullname;
            String string2 = "";
            int n2 = fullname.lastIndexOf(46);
            if (n2 != -1) {
                string = fullname.substring(n2 + 1);
                string2 = fullname.substring(0, n2);
            }
            this.index = 0;
            this.proto = DescriptorProtos.DescriptorProto.newBuilder().setName(string).addExtensionRange(DescriptorProtos.DescriptorProto.ExtensionRange.newBuilder().setStart(1).setEnd(0x20000000).build()).build();
            this.fullName = fullname;
            this.containingType = null;
            this.nestedTypes = EMPTY_DESCRIPTORS;
            this.enumTypes = EMPTY_ENUM_DESCRIPTORS;
            this.fields = EMPTY_FIELD_DESCRIPTORS;
            this.fieldsSortedByNumber = EMPTY_FIELD_DESCRIPTORS;
            this.extensions = EMPTY_FIELD_DESCRIPTORS;
            this.oneofs = EMPTY_ONEOF_DESCRIPTORS;
            this.realOneofCount = 0;
            this.file = new FileDescriptor(string2, this);
            this.extensionRangeLowerBounds = new int[]{1};
            this.extensionRangeUpperBounds = new int[]{0x20000000};
        }

        private Descriptor(DescriptorProtos.DescriptorProto proto, FileDescriptor file, Descriptor parent, int index) throws DescriptorValidationException {
            Object object;
            int n2;
            this.index = index;
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file, parent, proto.getName());
            this.file = file;
            this.containingType = parent;
            this.oneofs = proto.getOneofDeclCount() > 0 ? new OneofDescriptor[proto.getOneofDeclCount()] : EMPTY_ONEOF_DESCRIPTORS;
            for (n2 = 0; n2 < proto.getOneofDeclCount(); ++n2) {
                this.oneofs[n2] = new OneofDescriptor(proto.getOneofDecl(n2), file, this, n2);
            }
            this.nestedTypes = proto.getNestedTypeCount() > 0 ? new Descriptor[proto.getNestedTypeCount()] : EMPTY_DESCRIPTORS;
            for (n2 = 0; n2 < proto.getNestedTypeCount(); ++n2) {
                this.nestedTypes[n2] = new Descriptor(proto.getNestedType(n2), file, this, n2);
            }
            this.enumTypes = proto.getEnumTypeCount() > 0 ? new EnumDescriptor[proto.getEnumTypeCount()] : EMPTY_ENUM_DESCRIPTORS;
            for (n2 = 0; n2 < proto.getEnumTypeCount(); ++n2) {
                this.enumTypes[n2] = new EnumDescriptor(proto.getEnumType(n2), file, this, n2);
            }
            this.fields = proto.getFieldCount() > 0 ? new FieldDescriptor[proto.getFieldCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n2 = 0; n2 < proto.getFieldCount(); ++n2) {
                this.fields[n2] = new FieldDescriptor(proto.getField(n2), file, this, n2, false);
            }
            this.fieldsSortedByNumber = proto.getFieldCount() > 0 ? (FieldDescriptor[])this.fields.clone() : EMPTY_FIELD_DESCRIPTORS;
            this.extensions = proto.getExtensionCount() > 0 ? new FieldDescriptor[proto.getExtensionCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n2 = 0; n2 < proto.getExtensionCount(); ++n2) {
                this.extensions[n2] = new FieldDescriptor(proto.getExtension(n2), file, this, n2, true);
            }
            for (n2 = 0; n2 < proto.getOneofDeclCount(); ++n2) {
                OneofDescriptor.access$2502(this.oneofs[n2], new FieldDescriptor[this.oneofs[n2].getFieldCount()]);
                this.oneofs[n2].fieldCount = 0;
            }
            for (n2 = 0; n2 < proto.getFieldCount(); ++n2) {
                object = this.fields[n2].getContainingOneof();
                if (object == null) continue;
                ((OneofDescriptor)object).fields[((OneofDescriptor)object).fieldCount++] = this.fields[n2];
            }
            n2 = 0;
            object = this.oneofs;
            int n3 = this.oneofs.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                OneofDescriptor oneofDescriptor = object[i2];
                if (oneofDescriptor.isSynthetic()) {
                    ++n2;
                    continue;
                }
                if (n2 <= 0) continue;
                throw new DescriptorValidationException((GenericDescriptor)this, "Synthetic oneofs must come last.");
            }
            this.realOneofCount = this.oneofs.length - n2;
            file.pool.addSymbol(this);
            if (proto.getExtensionRangeCount() > 0) {
                this.extensionRangeLowerBounds = new int[proto.getExtensionRangeCount()];
                this.extensionRangeUpperBounds = new int[proto.getExtensionRangeCount()];
                int n4 = 0;
                for (DescriptorProtos.DescriptorProto.ExtensionRange extensionRange : proto.getExtensionRangeList()) {
                    this.extensionRangeLowerBounds[n4] = extensionRange.getStart();
                    this.extensionRangeUpperBounds[n4] = extensionRange.getEnd();
                    ++n4;
                }
                Arrays.sort(this.extensionRangeLowerBounds);
                Arrays.sort(this.extensionRangeUpperBounds);
                return;
            }
            this.extensionRangeLowerBounds = EMPTY_INT_ARRAY;
            this.extensionRangeUpperBounds = EMPTY_INT_ARRAY;
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor;
            int n2;
            GenericDescriptor[] genericDescriptorArray = this.nestedTypes;
            int n3 = this.nestedTypes.length;
            for (n2 = 0; n2 < n3; ++n2) {
                genericDescriptor = genericDescriptorArray[n2];
                genericDescriptor.crossLink();
            }
            genericDescriptorArray = this.fields;
            n3 = this.fields.length;
            for (n2 = 0; n2 < n3; ++n2) {
                genericDescriptor = genericDescriptorArray[n2];
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
            Arrays.sort(this.fieldsSortedByNumber);
            this.validateNoDuplicateFieldNumbers();
            genericDescriptorArray = this.extensions;
            n3 = this.extensions.length;
            for (n2 = 0; n2 < n3; ++n2) {
                genericDescriptor = genericDescriptorArray[n2];
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void validateNoDuplicateFieldNumbers() throws DescriptorValidationException {
            int n2 = 0;
            while (n2 + 1 < this.fieldsSortedByNumber.length) {
                FieldDescriptor fieldDescriptor = this.fieldsSortedByNumber[n2];
                FieldDescriptor fieldDescriptor2 = this.fieldsSortedByNumber[n2 + 1];
                if (fieldDescriptor.getNumber() == fieldDescriptor2.getNumber()) {
                    throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor2, "Field number " + fieldDescriptor2.getNumber() + " has already been used in \"" + fieldDescriptor2.getContainingType().getFullName() + "\" by field \"" + fieldDescriptor.getName() + "\".");
                }
                ++n2;
            }
        }

        private void setProto(DescriptorProtos.DescriptorProto proto) {
            int n2;
            this.proto = proto;
            for (n2 = 0; n2 < this.nestedTypes.length; ++n2) {
                this.nestedTypes[n2].setProto(proto.getNestedType(n2));
            }
            for (n2 = 0; n2 < this.oneofs.length; ++n2) {
                this.oneofs[n2].setProto(proto.getOneofDecl(n2));
            }
            for (n2 = 0; n2 < this.enumTypes.length; ++n2) {
                this.enumTypes[n2].setProto(proto.getEnumType(n2));
            }
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                this.fields[n2].setProto(proto.getField(n2));
            }
            for (n2 = 0; n2 < this.extensions.length; ++n2) {
                this.extensions[n2].setProto(proto.getExtension(n2));
            }
        }
    }

    public static final class FileDescriptor
    extends GenericDescriptor {
        private DescriptorProtos.FileDescriptorProto proto;
        private final Descriptor[] messageTypes;
        private final EnumDescriptor[] enumTypes;
        private final ServiceDescriptor[] services;
        private final FieldDescriptor[] extensions;
        private final FileDescriptor[] dependencies;
        private final FileDescriptor[] publicDependencies;
        private final DescriptorPool pool;

        @Override
        public final DescriptorProtos.FileDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final FileDescriptor getFile() {
            return this;
        }

        @Override
        public final String getFullName() {
            return this.proto.getName();
        }

        public final String getPackage() {
            return this.proto.getPackage();
        }

        public final DescriptorProtos.FileOptions getOptions() {
            return this.proto.getOptions();
        }

        public final List<Descriptor> getMessageTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.messageTypes));
        }

        public final List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public final List<ServiceDescriptor> getServices() {
            return Collections.unmodifiableList(Arrays.asList(this.services));
        }

        public final List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public final List<FileDescriptor> getDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.dependencies));
        }

        public final List<FileDescriptor> getPublicDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.publicDependencies));
        }

        public final Syntax getSyntax() {
            if (Syntax.PROTO3.name.equals(this.proto.getSyntax())) {
                return Syntax.PROTO3;
            }
            return Syntax.PROTO2;
        }

        public final Descriptor findMessageTypeByName(String name) {
            GenericDescriptor genericDescriptor;
            if (name.indexOf(46) != -1) {
                return null;
            }
            String string = this.getPackage();
            if (!string.isEmpty()) {
                name = string + '.' + name;
            }
            if ((genericDescriptor = this.pool.findSymbol(name)) instanceof Descriptor && genericDescriptor.getFile() == this) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public final EnumDescriptor findEnumTypeByName(String name) {
            GenericDescriptor genericDescriptor;
            if (name.indexOf(46) != -1) {
                return null;
            }
            String string = this.getPackage();
            if (!string.isEmpty()) {
                name = string + '.' + name;
            }
            if ((genericDescriptor = this.pool.findSymbol(name)) instanceof EnumDescriptor && genericDescriptor.getFile() == this) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        public final ServiceDescriptor findServiceByName(String name) {
            GenericDescriptor genericDescriptor;
            if (name.indexOf(46) != -1) {
                return null;
            }
            String string = this.getPackage();
            if (!string.isEmpty()) {
                name = string + '.' + name;
            }
            if ((genericDescriptor = this.pool.findSymbol(name)) instanceof ServiceDescriptor && genericDescriptor.getFile() == this) {
                return (ServiceDescriptor)genericDescriptor;
            }
            return null;
        }

        public final FieldDescriptor findExtensionByName(String name) {
            GenericDescriptor genericDescriptor;
            if (name.indexOf(46) != -1) {
                return null;
            }
            String string = this.getPackage();
            if (!string.isEmpty()) {
                name = string + '.' + name;
            }
            if ((genericDescriptor = this.pool.findSymbol(name)) instanceof FieldDescriptor && genericDescriptor.getFile() == this) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto proto, FileDescriptor[] dependencies) throws DescriptorValidationException {
            return FileDescriptor.buildFrom(proto, dependencies, false);
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto proto, FileDescriptor[] dependencies, boolean allowUnknownDependencies) throws DescriptorValidationException {
            DescriptorPool descriptorPool = new DescriptorPool(dependencies, allowUnknownDependencies);
            FileDescriptor fileDescriptor = new FileDescriptor(proto, dependencies, descriptorPool, allowUnknownDependencies);
            fileDescriptor.crossLink();
            return fileDescriptor;
        }

        private static byte[] latin1Cat(String[] strings) {
            if (strings.length == 1) {
                return strings[0].getBytes(Internal.ISO_8859_1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = strings;
            int n2 = strings.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                stringBuilder.append(string);
            }
            return stringBuilder.toString().getBytes(Internal.ISO_8859_1);
        }

        private static FileDescriptor[] findDescriptors(Class<?> descriptorOuterClass, String[] dependencyClassNames, String[] dependencyFileNames) {
            ArrayList<FileDescriptor> arrayList = new ArrayList<FileDescriptor>();
            for (int i2 = 0; i2 < dependencyClassNames.length; ++i2) {
                try {
                    Class<?> clazz = descriptorOuterClass.getClassLoader().loadClass(dependencyClassNames[i2]);
                    arrayList.add((FileDescriptor)clazz.getField("descriptor").get(null));
                    continue;
                }
                catch (Exception exception) {
                    logger.warning("Descriptors for \"" + dependencyFileNames[i2] + "\" can not be found.");
                }
            }
            return arrayList.toArray(new FileDescriptor[0]);
        }

        @Deprecated
        public static void internalBuildGeneratedFileFrom(String[] descriptorDataParts, FileDescriptor[] dependencies, InternalDescriptorAssigner descriptorAssigner) {
            FileDescriptor fileDescriptor;
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            byte[] byArray = FileDescriptor.latin1Cat(descriptorDataParts);
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            try {
                fileDescriptor = FileDescriptor.buildFrom(fileDescriptorProto, dependencies, true);
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
            ExtensionRegistry extensionRegistry = descriptorAssigner.assignDescriptors(fileDescriptor);
            if (extensionRegistry != null) {
                try {
                    fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray, (ExtensionRegistryLite)extensionRegistry);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
                }
                fileDescriptor.setProto(fileDescriptorProto);
            }
        }

        public static FileDescriptor internalBuildGeneratedFileFrom(String[] descriptorDataParts, FileDescriptor[] dependencies) {
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            byte[] byArray = FileDescriptor.latin1Cat(descriptorDataParts);
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            try {
                return FileDescriptor.buildFrom(fileDescriptorProto, dependencies, true);
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
        }

        @Deprecated
        public static void internalBuildGeneratedFileFrom(String[] descriptorDataParts, Class<?> descriptorOuterClass, String[] dependencyClassNames, String[] dependencyFileNames, InternalDescriptorAssigner descriptorAssigner) {
            FileDescriptor[] fileDescriptorArray = FileDescriptor.findDescriptors(descriptorOuterClass, dependencyClassNames, dependencyFileNames);
            FileDescriptor.internalBuildGeneratedFileFrom(descriptorDataParts, fileDescriptorArray, descriptorAssigner);
        }

        public static FileDescriptor internalBuildGeneratedFileFrom(String[] descriptorDataParts, Class<?> descriptorOuterClass, String[] dependencyClassNames, String[] dependencyFileNames) {
            FileDescriptor[] fileDescriptorArray = FileDescriptor.findDescriptors(descriptorOuterClass, dependencyClassNames, dependencyFileNames);
            return FileDescriptor.internalBuildGeneratedFileFrom(descriptorDataParts, fileDescriptorArray);
        }

        public static void internalUpdateFileDescriptor(FileDescriptor descriptor, ExtensionRegistry registry) {
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            ByteString byteString = descriptor.proto.toByteString();
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byteString, (ExtensionRegistryLite)registry);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
            }
            descriptor.setProto(fileDescriptorProto);
        }

        private FileDescriptor(DescriptorProtos.FileDescriptorProto proto, FileDescriptor[] dependencies, DescriptorPool pool, boolean allowUnknownDependencies) throws DescriptorValidationException {
            Object object;
            int n2;
            this.pool = pool;
            this.proto = proto;
            this.dependencies = (FileDescriptor[])dependencies.clone();
            HashMap<String, FileDescriptor> hashMap = new HashMap<String, FileDescriptor>();
            Object object2 = dependencies;
            int n3 = dependencies.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = object2[n2];
                hashMap.put(((FileDescriptor)object).getName(), (FileDescriptor)object);
            }
            object2 = new ArrayList();
            for (n3 = 0; n3 < proto.getPublicDependencyCount(); ++n3) {
                n2 = proto.getPublicDependency(n3);
                if (n2 < 0 || n2 >= proto.getDependencyCount()) {
                    throw new DescriptorValidationException(this, "Invalid public dependency index.");
                }
                object = proto.getDependency(n2);
                FileDescriptor fileDescriptor = (FileDescriptor)hashMap.get(object);
                if (fileDescriptor == null) {
                    if (allowUnknownDependencies) continue;
                    throw new DescriptorValidationException(this, "Invalid public dependency: " + (String)object);
                }
                object2.add(fileDescriptor);
            }
            this.publicDependencies = new FileDescriptor[object2.size()];
            object2.toArray(this.publicDependencies);
            pool.addPackage(this.getPackage(), this);
            this.messageTypes = proto.getMessageTypeCount() > 0 ? new Descriptor[proto.getMessageTypeCount()] : EMPTY_DESCRIPTORS;
            for (n3 = 0; n3 < proto.getMessageTypeCount(); ++n3) {
                this.messageTypes[n3] = new Descriptor(proto.getMessageType(n3), this, null, n3);
            }
            this.enumTypes = proto.getEnumTypeCount() > 0 ? new EnumDescriptor[proto.getEnumTypeCount()] : EMPTY_ENUM_DESCRIPTORS;
            for (n3 = 0; n3 < proto.getEnumTypeCount(); ++n3) {
                this.enumTypes[n3] = new EnumDescriptor(proto.getEnumType(n3), this, null, n3);
            }
            this.services = proto.getServiceCount() > 0 ? new ServiceDescriptor[proto.getServiceCount()] : EMPTY_SERVICE_DESCRIPTORS;
            for (n3 = 0; n3 < proto.getServiceCount(); ++n3) {
                this.services[n3] = new ServiceDescriptor(proto.getService(n3), this, n3);
            }
            this.extensions = proto.getExtensionCount() > 0 ? new FieldDescriptor[proto.getExtensionCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (n3 = 0; n3 < proto.getExtensionCount(); ++n3) {
                this.extensions[n3] = new FieldDescriptor(proto.getExtension(n3), this, null, n3, true);
            }
        }

        FileDescriptor(String packageName, Descriptor message) throws DescriptorValidationException {
            this.pool = new DescriptorPool(new FileDescriptor[0], true);
            this.proto = DescriptorProtos.FileDescriptorProto.newBuilder().setName(message.getFullName() + ".placeholder.proto").setPackage(packageName).addMessageType(message.toProto()).build();
            this.dependencies = new FileDescriptor[0];
            this.publicDependencies = new FileDescriptor[0];
            this.messageTypes = new Descriptor[]{message};
            this.enumTypes = EMPTY_ENUM_DESCRIPTORS;
            this.services = EMPTY_SERVICE_DESCRIPTORS;
            this.extensions = EMPTY_FIELD_DESCRIPTORS;
            this.pool.addPackage(packageName, this);
            this.pool.addSymbol(message);
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor;
            int n2;
            GenericDescriptor[] genericDescriptorArray = this.messageTypes;
            int n3 = this.messageTypes.length;
            for (n2 = 0; n2 < n3; ++n2) {
                genericDescriptor = genericDescriptorArray[n2];
                ((Descriptor)genericDescriptor).crossLink();
            }
            genericDescriptorArray = this.services;
            n3 = this.services.length;
            for (n2 = 0; n2 < n3; ++n2) {
                genericDescriptor = genericDescriptorArray[n2];
                ((ServiceDescriptor)genericDescriptor).crossLink();
            }
            genericDescriptorArray = this.extensions;
            n3 = this.extensions.length;
            for (n2 = 0; n2 < n3; ++n2) {
                genericDescriptor = genericDescriptorArray[n2];
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void setProto(DescriptorProtos.FileDescriptorProto proto) {
            int n2;
            this.proto = proto;
            for (n2 = 0; n2 < this.messageTypes.length; ++n2) {
                this.messageTypes[n2].setProto(proto.getMessageType(n2));
            }
            for (n2 = 0; n2 < this.enumTypes.length; ++n2) {
                this.enumTypes[n2].setProto(proto.getEnumType(n2));
            }
            for (n2 = 0; n2 < this.services.length; ++n2) {
                this.services[n2].setProto(proto.getService(n2));
            }
            for (n2 = 0; n2 < this.extensions.length; ++n2) {
                this.extensions[n2].setProto(proto.getExtension(n2));
            }
        }

        final boolean supportsUnknownEnumValue() {
            return this.getSyntax() == Syntax.PROTO3;
        }

        @Deprecated
        public static interface InternalDescriptorAssigner {
            public ExtensionRegistry assignDescriptors(FileDescriptor var1);
        }

        public static enum Syntax {
            UNKNOWN("unknown"),
            PROTO2("proto2"),
            PROTO3("proto3");

            private final String name;

            private Syntax(String name) {
                this.name = name;
            }
        }
    }
}

