<a id="mypy-boto3-mediatailor"></a>

# mypy-boto3-mediatailor

[![PyPI - mypy-boto3-mediatailor](https://img.shields.io/pypi/v/mypy-boto3-mediatailor.svg?color=blue)](https://pypi.org/project/mypy-boto3-mediatailor)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mediatailor.svg?color=blue)](https://pypi.org/project/mypy-boto3-mediatailor)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-mediatailor?color=blue)](https://pypistats.org/packages/mypy-boto3-mediatailor)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.MediaTailor 1.17.104](https://boto3.amazonaws.com/v1/documentation/api/1.17.104/reference/services/mediatailor.html#MediaTailor)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-mediatailor docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediatailor/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-mediatailor](#mypy-boto3-mediatailor)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `MediaTailor` service.

```bash
python -m pip install boto3-stubs[mediatailor]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[mediatailor]` in your environment:
  `python -m pip install 'boto3-stubs[mediatailor]'`

Both type checking and auto-complete should work for `MediaTailor` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[mediatailor]` in your environment:
  `python -m pip install 'boto3-stubs[mediatailor]'`

Both type checking and auto-complete should work for `MediaTailor` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[mediatailor]` in your environment:
  `python -m pip install 'boto3-stubs[mediatailor]'`
- Run `mypy` as usual

Type checking should work for `MediaTailor` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[mediatailor]` in your environment:
  `python -m pip install 'boto3-stubs[mediatailor]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MediaTailor` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`MediaTailorClient` provides annotations for `boto3.client("mediatailor")`.

```python
import boto3

from mypy_boto3_mediatailor import MediaTailorClient

client: MediaTailorClient = boto3.client("mediatailor")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MediaTailorClient = session.client("mediatailor")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_mediatailor.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_mediatailor import MediaTailorClient
from mypy_boto3_mediatailor.paginator import (
    GetChannelSchedulePaginator,
    ListChannelsPaginator,
    ListPlaybackConfigurationsPaginator,
    ListSourceLocationsPaginator,
    ListVodSourcesPaginator,
)

client: MediaTailorClient = boto3.client("mediatailor")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_channel_schedule_paginator: GetChannelSchedulePaginator = client.get_paginator("get_channel_schedule")
list_channels_paginator: ListChannelsPaginator = client.get_paginator("list_channels")
list_playback_configurations_paginator: ListPlaybackConfigurationsPaginator = client.get_paginator("list_playback_configurations")
list_source_locations_paginator: ListSourceLocationsPaginator = client.get_paginator("list_source_locations")
list_vod_sources_paginator: ListVodSourcesPaginator = client.get_paginator("list_vod_sources")
```

<a id="literals"></a>

### Literals

`mypy_boto3_mediatailor.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_mediatailor.literals import (
    AccessTypeType,
    ChannelStateType,
    GetChannelSchedulePaginatorName,
    ListChannelsPaginatorName,
    ListPlaybackConfigurationsPaginatorName,
    ListSourceLocationsPaginatorName,
    ListVodSourcesPaginatorName,
    MessageTypeType,
    ModeType,
    OriginManifestTypeType,
    PlaybackModeType,
    RelativePositionType,
    TypeType,
)

def check_value(value: AccessTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_mediatailor.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_mediatailor.type_defs import (
    AccessConfigurationTypeDef,
    AdBreakTypeDef,
    AdMarkerPassthroughTypeDef,
    AvailSuppressionTypeDef,
    BumperTypeDef,
    CdnConfigurationTypeDef,
    ChannelTypeDef,
    CreateChannelRequestRequestTypeDef,
    CreateChannelResponseTypeDef,
    CreateProgramRequestRequestTypeDef,
    CreateProgramResponseTypeDef,
    CreateSourceLocationRequestRequestTypeDef,
    CreateSourceLocationResponseTypeDef,
    CreateVodSourceRequestRequestTypeDef,
    CreateVodSourceResponseTypeDef,
    DashConfigurationForPutTypeDef,
    DashConfigurationTypeDef,
    DashPlaylistSettingsTypeDef,
    DefaultSegmentDeliveryConfigurationTypeDef,
    DeleteChannelPolicyRequestRequestTypeDef,
    DeleteChannelRequestRequestTypeDef,
    DeletePlaybackConfigurationRequestRequestTypeDef,
    DeleteProgramRequestRequestTypeDef,
    DeleteSourceLocationRequestRequestTypeDef,
    DeleteVodSourceRequestRequestTypeDef,
    DescribeChannelRequestRequestTypeDef,
    DescribeChannelResponseTypeDef,
    DescribeProgramRequestRequestTypeDef,
    DescribeProgramResponseTypeDef,
    DescribeSourceLocationRequestRequestTypeDef,
    DescribeSourceLocationResponseTypeDef,
    DescribeVodSourceRequestRequestTypeDef,
    DescribeVodSourceResponseTypeDef,
    GetChannelPolicyRequestRequestTypeDef,
    GetChannelPolicyResponseTypeDef,
    GetChannelScheduleRequestRequestTypeDef,
    GetChannelScheduleResponseTypeDef,
    GetPlaybackConfigurationRequestRequestTypeDef,
    GetPlaybackConfigurationResponseTypeDef,
    HlsConfigurationTypeDef,
    HlsPlaylistSettingsTypeDef,
    HttpConfigurationTypeDef,
    HttpPackageConfigurationTypeDef,
    ListChannelsRequestRequestTypeDef,
    ListChannelsResponseTypeDef,
    ListPlaybackConfigurationsRequestRequestTypeDef,
    ListPlaybackConfigurationsResponseTypeDef,
    ListSourceLocationsRequestRequestTypeDef,
    ListSourceLocationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListVodSourcesRequestRequestTypeDef,
    ListVodSourcesResponseTypeDef,
    LivePreRollConfigurationTypeDef,
    ManifestProcessingRulesTypeDef,
    PaginatorConfigTypeDef,
    PlaybackConfigurationTypeDef,
    PutChannelPolicyRequestRequestTypeDef,
    PutPlaybackConfigurationRequestRequestTypeDef,
    PutPlaybackConfigurationResponseTypeDef,
    RequestOutputItemTypeDef,
    ResponseMetadataTypeDef,
    ResponseOutputItemTypeDef,
    ScheduleAdBreakTypeDef,
    ScheduleConfigurationTypeDef,
    ScheduleEntryTypeDef,
    SecretsManagerAccessTokenConfigurationTypeDef,
    SlateSourceTypeDef,
    SourceLocationTypeDef,
    SpliceInsertMessageTypeDef,
    StartChannelRequestRequestTypeDef,
    StopChannelRequestRequestTypeDef,
    TagResourceRequestRequestTypeDef,
    TransitionTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateChannelRequestRequestTypeDef,
    UpdateChannelResponseTypeDef,
    UpdateSourceLocationRequestRequestTypeDef,
    UpdateSourceLocationResponseTypeDef,
    UpdateVodSourceRequestRequestTypeDef,
    UpdateVodSourceResponseTypeDef,
    VodSourceTypeDef,
)

def get_structure() -> AccessConfigurationTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-mediatailor` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-mediatailor docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediatailor/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
