# Copyright 2022 Cognite AS
from .logarithmic_functions import exp, log, log2, log10, logn
from .numerical_calculus import differentiate, sliding_window_integration, trapezoidal_integration
from .operators import absolute, add, arithmetic_mean, div, inv, mod, mul, neg, power, sqrt, sub
from .trigonometric_functions import (
    arccos,
    arccosh,
    arcsin,
    arcsinh,
    arctan,
    arctan2,
    arctanh,
    cos,
    cosh,
    deg2rad,
    rad2deg,
    sin,
    sinh,
    tan,
    tanh,
)
from .utility_functions import (
    bin_map,
    ceil,
    clip,
    floor,
    get_timestamps,
    maximum,
    minimum,
    remove,
    replace,
    round,
    set_timestamps,
    sign,
    threshold,
    time_shift,
    union,
)


TOOLBOX_NAME = "Operators"

__all__ = [
    "add",
    "sub",
    "mul",
    "div",
    "absolute",
    "inv",
    "mod",
    "neg",
    "power",
    "sqrt",
    "sin",
    "cos",
    "tan",
    "arccos",
    "arcsin",
    "arctan",
    "arctan2",
    "deg2rad",
    "rad2deg",
    "sinh",
    "cosh",
    "tanh",
    "arcsinh",
    "arccosh",
    "arctanh",
    "exp",
    "log",
    "log2",
    "log10",
    "logn",
    "clip",
    "replace",
    "remove",
    "maximum",
    "minimum",
    "union",
    "bin_map",
    "get_timestamps",
    "set_timestamps",
    "time_shift",
    "ceil",
    "floor",
    "round",
    "sign",
    "trapezoidal_integration",
    "differentiate",
    "threshold",
    "sliding_window_integration",
    "arithmetic_mean",
]
