#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['qpsolvers',
 'qpsolvers.conversions',
 'qpsolvers.solvers',
 'qpsolvers.unsupported']

package_data = \
{'': ['*']}

install_requires = \
['daqp >=0.5.1',
 'ecos >=2.0.8',
 'numpy >=1.15.4',
 'osqp >=0.6.2',
 'scipy >=1.2.0',
 'scs >=3.2.0']

extras_require = \
{'clarabel': ['clarabel >=0.4.1'],
 'cvxopt': ['cvxopt >=1.2.6'],
 'daqp': ['daqp >=0.5.1'],
 'ecos': ['ecos >=2.0.8'],
 'highs': ['highspy >=1.1.2.dev3'],
 'open_source_solvers': ['qpsolvers[clarabel,cvxopt,daqp,ecos,highs,osqp,piqp,proxqp,qpalm,quadprog,scs]'],
 'osqp': ['osqp >=0.6.2'],
 'piqp': ['piqp >=0.2.2'],
 'proxqp': ['proxsuite >=0.2.9'],
 'qpalm': ['qpalm >=1.2.1'],
 'quadprog': ['quadprog >=0.1.11'],
 'scs': ['scs >=3.2.0']}

setup(name='qpsolvers',
      version='4.1.1',
      description='Quadratic programming solvers in Python with a unified API.',
      author=None,
      author_email='Stéphane Caron <stephane.caron@normalesup.org>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.7',
     )
