import { Construct } from 'constructs';
import { Cluster, ClusterOptions } from './cluster';
import { FargateProfile, FargateProfileOptions } from './fargate-profile';
/**
 * Configuration props for EKS Fargate.
 *
 * @stability stable
 */
export interface FargateClusterProps extends ClusterOptions {
    /**
     * Fargate Profile to create along with the cluster.
     *
     * @default - A profile called "default" with 'default' and 'kube-system'
     *   selectors will be created if this is left undefined.
     * @stability stable
     */
    readonly defaultProfile?: FargateProfileOptions;
}
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 *
 * @stability stable
 */
export declare class FargateCluster extends Cluster {
    /**
     * Fargate Profile that was created with the cluster.
     *
     * @stability stable
     */
    readonly defaultProfile: FargateProfile;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: FargateClusterProps);
}
