---
actual_hours: null
assignees: []
created_at: '2025-11-28T02:03:39.854503'
dependencies: []
description: '## Problem

  Priority fields currently only accept exact enum values (critical, high, medium,
  low). No support for:

  - Natural language: "urgent", "asap", "important", "whenever"

  - Typos: "criticl", "hgh", "medum"

  - Phrases: "high priority", "needs attention"

  - Confidence-based suggestions


  ## Solution

  Implement SemanticPriorityMatcher following the proven pattern from SemanticStateMatcher.


  ## Benefits

  - Better UX for AI agents and humans

  - Consistent with state semantic matching

  - Backward compatible (exact values still work)

  - Fuzzy matching for typos


  ## Implementation Plan

  See research document: docs/research/priority-semantic-mapping-analysis-2025-11-28.md


  ## Files to Create

  - src/mcp_ticketer/core/priority_matcher.py

  - tests/unit/test_priority_matcher.py

  - docs/SEMANTIC_PRIORITY_MATCHING.md


  ## Effort Estimate

  - Time: 2-3 days

  - Risk: Low (proven pattern exists)

  - Tests: 120+ (matching state matcher coverage)'
due_date: null
estimated_hours: null
id: ISS-0001
labels: []
metadata:
  issue_type: enhancement
  severity: high
  type: issue
parent: null
priority: high
status: open
tags:
- issue
- enhancement
- enhancement
- ux
- semantic-matching
- priority
title: Add semantic priority matching for natural language inputs
updated_at: '2025-11-28T02:03:39.854503'
---

# Add semantic priority matching for natural language inputs

## Description
## Problem
Priority fields currently only accept exact enum values (critical, high, medium, low). No support for:
- Natural language: "urgent", "asap", "important", "whenever"
- Typos: "criticl", "hgh", "medum"
- Phrases: "high priority", "needs attention"
- Confidence-based suggestions

## Solution
Implement SemanticPriorityMatcher following the proven pattern from SemanticStateMatcher.

## Benefits
- Better UX for AI agents and humans
- Consistent with state semantic matching
- Backward compatible (exact values still work)
- Fuzzy matching for typos

## Implementation Plan
See research document: docs/research/priority-semantic-mapping-analysis-2025-11-28.md

## Files to Create
- src/mcp_ticketer/core/priority_matcher.py
- tests/unit/test_priority_matcher.py
- docs/SEMANTIC_PRIORITY_MATCHING.md

## Effort Estimate
- Time: 2-3 days
- Risk: Low (proven pattern exists)
- Tests: 120+ (matching state matcher coverage)

## Details
- **Status**: open
- **Priority**: high
- **Assignees**: None
- **Tags**: issue, enhancement, enhancement, ux, semantic-matching, priority
- **Created**: 2025-11-28 02:03:39
- **Updated**: 2025-11-28 02:03:39

## Tasks
- [ ] Add task items here

## Notes
_Add any additional notes or context here._
