# Troubleshooting

Solutions to common issues and problems when using MCP Ticketer.

## 📚 Contents

### Main Troubleshooting Guide

- **[Troubleshooting Guide](TROUBLESHOOTING.md)** - Comprehensive troubleshooting reference
  - Common installation issues
  - Configuration problems
  - Adapter-specific issues (Linear, JIRA, GitHub)
  - Connection and authentication errors
  - Performance issues
  - Error reference and fixes

## 🔍 Quick Troubleshooting

### Installation Issues
See: [Troubleshooting Guide - Installation Issues](TROUBLESHOOTING.md#installation-issues)

### Configuration Problems
See: [Troubleshooting Guide - Configuration Issues](TROUBLESHOOTING.md#configuration-issues)

### Adapter Issues
- **Linear**: [Troubleshooting Guide - Linear Issues](TROUBLESHOOTING.md#linear-adapter-issues)
- **JIRA**: [Troubleshooting Guide - JIRA Issues](TROUBLESHOOTING.md#jira-adapter-issues)
- **GitHub**: [Troubleshooting Guide - GitHub Issues](TROUBLESHOOTING.md#github-adapter-issues)

### Connection Issues
See: [Troubleshooting Guide - Connection Issues](TROUBLESHOOTING.md#connection-issues)

### Performance Issues
See: [Troubleshooting Guide - Performance Issues](TROUBLESHOOTING.md#performance-issues)

## 🆘 Getting Help

### Before Asking for Help
1. Check the [Troubleshooting Guide](TROUBLESHOOTING.md)
2. Search [GitHub Issues](https://github.com/mcp-ticketer/mcp-ticketer/issues)
3. Review [Configuration Guide](../getting-started/CONFIGURATION.md)
4. Verify your setup with the [Setup Command](../guides/SETUP_COMMAND.md)

### Reporting Issues
When reporting issues, please include:
- MCP Ticketer version (`mcp-ticketer --version`)
- Adapter being used (Linear, JIRA, GitHub, etc.)
- Complete error message
- Steps to reproduce
- Configuration (with sensitive data removed)

### Support Channels
- **GitHub Issues**: [Report bugs or request features](https://github.com/mcp-ticketer/mcp-ticketer/issues)
- **GitHub Discussions**: [Ask questions and share ideas](https://github.com/mcp-ticketer/mcp-ticketer/discussions)

## 📖 Related Documentation

- **[Configuration Guide](../getting-started/CONFIGURATION.md)** - Complete configuration reference
- **[User Guide](../guides/USER_GUIDE.md)** - User documentation
- **[Integration Guides](../../integrations/README.md)** - Platform-specific setup
- **[Developer Documentation](../../developer-docs/README.md)** - For contributors

---

[← Back to User Documentation](../README.md)
