# User Guides

Comprehensive how-to guides and tutorials for MCP Ticketer users.

## 📚 Contents

### Core Guides

- **[User Guide](USER_GUIDE.md)** - Complete user documentation
  - All features and capabilities
  - Usage examples
  - Best practices
  - Common workflows

- **[Bulletproof Ticket Creation](BULLETPROOF_TICKET_CREATION.md)** - Best practices for ticket creation
  - Ticket creation strategies
  - Validation and error handling
  - Template usage
  - Quality guidelines

### Feature Guides

- **[Epic Attachments Guide](EPIC_ATTACHMENTS.md)** - Working with epic attachments
  - Uploading files
  - Managing attachments
  - Supported platforms
  - Limitations and workarounds

- **[Label Management](LABEL_MANAGEMENT.md)** - Managing labels and tags
  - Creating labels
  - Label conventions
  - Cleanup and organization
  - Best practices

- **[Label Tools Examples](LABEL_TOOLS_EXAMPLES.md)** - Practical label management examples
  - Common label operations
  - Automation scripts
  - Label cleanup workflows

- **[Semantic State Transitions](SEMANTIC_STATE_TRANSITIONS.md)** - Natural language state transitions
  - Using natural language for states
  - State machine overview
  - Valid transitions
  - Examples and patterns

- **[Session Ticket Tracking](SESSION_TICKET_TRACKING.md)** - Track work sessions with tickets
  - Associating work with tickets
  - Session management
  - Work tracking best practices

### Setup and Configuration

- **[Setup Command](SETUP_COMMAND.md)** - Interactive setup guide
  - Initial configuration
  - Adapter setup
  - Testing connection
  - Troubleshooting setup

- **[Config and User Tools](config_and_user_tools.md)** - Configuration management
  - Configuration tools
  - User management
  - Settings and preferences

## 📖 Guide Categories

### By Task
- **Creating Tickets**: [User Guide](USER_GUIDE.md), [Bulletproof Ticket Creation](BULLETPROOF_TICKET_CREATION.md)
- **Managing Labels**: [Label Management](LABEL_MANAGEMENT.md), [Label Tools Examples](LABEL_TOOLS_EXAMPLES.md)
- **Working with Attachments**: [Epic Attachments](EPIC_ATTACHMENTS.md)
- **State Management**: [Semantic State Transitions](SEMANTIC_STATE_TRANSITIONS.md)
- **Session Tracking**: [Session Ticket Tracking](SESSION_TICKET_TRACKING.md)

### By Experience Level
- **Beginners**: [Setup Command](SETUP_COMMAND.md), [User Guide](USER_GUIDE.md)
- **Intermediate**: [Bulletproof Ticket Creation](BULLETPROOF_TICKET_CREATION.md), [Label Management](LABEL_MANAGEMENT.md)
- **Advanced**: [Label Tools Examples](LABEL_TOOLS_EXAMPLES.md), [Session Ticket Tracking](SESSION_TICKET_TRACKING.md)

## 🚀 Getting Started Path

1. **[Setup Command](SETUP_COMMAND.md)** - Initial setup
2. **[User Guide](USER_GUIDE.md)** - Learn the basics
3. **[Bulletproof Ticket Creation](BULLETPROOF_TICKET_CREATION.md)** - Create quality tickets

## 📋 Related Documentation

- **[Getting Started](../getting-started/README.md)** - Installation and configuration
- **[Features](../features/README.md)** - Feature documentation
- **[API Reference](../../developer-docs/api/README.md)** - API documentation
- **[Troubleshooting](../troubleshooting/TROUBLESHOOTING.md)** - Common issues

---

[← Back to User Documentation](../README.md)
