# Developer Documentation

Documentation for developers contributing to MCP Ticketer.

## Getting Started

1. **[Developer Guide](getting-started/DEVELOPER_GUIDE.md)** - Complete development guide
2. **[Contributing Guide](getting-started/CONTRIBUTING.md)** - How to contribute
3. **[Code Structure](getting-started/CODE_STRUCTURE.md)** - Codebase architecture

## API Reference

- **[API Documentation](api/README.md)** - Complete API reference
- **[Epic Updates & Attachments](api/epic_updates_and_attachments.md)** - Epic-related APIs

## Adapters

- **[Adapter Overview](adapters/OVERVIEW.md)** - Understanding adapters and feature support
- **[GitHub Adapter](adapters/github.md)** - GitHub implementation
- **[Linear Adapter](adapters/LINEAR.md)** - Linear implementation
- **[Linear URL Handling](adapters/LINEAR_URL_HANDLING.md)** - How Linear URLs are parsed and handled

## Release Management

- **[Release Process](releasing/RELEASING.md)** - How to create releases
- **[Versioning](releasing/VERSIONING.md)** - Version numbering scheme

## See Also

- [Architecture Documentation](../architecture/README.md) - Technical design details
- [Investigation Reports](../investigations/README.md) - Analysis and investigation results
- [User Documentation](../user-docs/README.md) - End-user guides
