# MCP Ticketer Documentation

Welcome to the comprehensive documentation for MCP Ticketer - the universal ticket management interface for AI agents.

**📍 New here? See the [Documentation Navigation Map](NAVIGATION.md) for a complete overview of all documentation.**

## Documentation Structure

Our documentation is organized by audience and purpose:

### 👥 [User Documentation](user-docs/README.md)
For end users of MCP Ticketer
- Getting started guides
- User guide and CLI reference
- Feature documentation
- Examples and best practices

### 👨‍💻 [Developer Documentation](developer-docs/README.md)
For contributors and developers
- Developer guide and contributing guidelines
- API reference
- Adapter development
- Release management

### 🏛️ [Architecture Documentation](architecture/README.md)
Technical deep-dives and design documents
- System architecture
- Design documents (PRD)
- Integration architecture

### 🔌 [Integration Guides](integrations/README.md)
Platform-specific setup and integration
- AI client integration
- Platform setup guides (Linear, JIRA, Claude Desktop, etc.)
- Pull request integration

### 🔧 [Troubleshooting Guide](user-docs/troubleshooting/TROUBLESHOOTING.md)
Common issues and solutions
- General troubleshooting steps
- Adapter-specific issues (Linear, GitHub, JIRA)
- Configuration and performance issues
- Error reference and fixes

### 🔍 [Investigation Reports](investigations/README.md)
Analysis, research, and investigation results
- Adapter investigations
- Performance reports
- Test coverage reports
- Implementation documentation

### 🗄️ [Archive](_archive/README.md)
Historical documentation and older reports

### 📋 [Meta Documentation](meta/README.md)
Documentation about documentation, migrations, and configuration

---

## Quick Start Paths

### I'm a new user
1. [Quick Start Guide](user-docs/getting-started/QUICK_START.md)
2. [Configuration Guide](user-docs/getting-started/CONFIGURATION.md)
3. [User Guide](user-docs/guides/USER_GUIDE.md)

### I want to integrate with an AI client
1. [AI Client Integration](integrations/AI_CLIENT_INTEGRATION.md)
2. Choose your platform: [Claude Desktop](integrations/setup/CLAUDE_DESKTOP_SETUP.md), [Codex](integrations/setup/CODEX_INTEGRATION.md)
3. [Bulletproof Ticket Creation](user-docs/guides/BULLETPROOF_TICKET_CREATION.md)

### I want to contribute
1. [Development Guide](developer-docs/DEVELOPMENT.md) - Build system, testing, and workflows
2. [Developer Guide](developer-docs/getting-started/DEVELOPER_GUIDE.md)
3. [Contributing Guide](developer-docs/getting-started/CONTRIBUTING.md)
4. [Code Structure](developer-docs/getting-started/CODE_STRUCTURE.md)

### I need to understand the architecture
1. [Architecture Overview](architecture/README.md)
2. [MCP Integration](architecture/MCP_INTEGRATION.md)
3. [API Reference](developer-docs/api/README.md)

---

## Documentation Standards

- **Format**: Markdown (`.md`) for all active documentation
- **Organization**: Audience-based directory structure
- **Links**: Relative links within documentation
- **Updates**: Documentation updated with each release
- **Archive**: Historical docs moved to `_archive/`

## Getting Help

- **Having Issues?**: Check the [Troubleshooting Guide](user-docs/troubleshooting/TROUBLESHOOTING.md) first
- **Missing Information**: Open an issue describing what's missing
- **Unclear Instructions**: Submit a pull request with improvements
- **Broken Examples**: Report with steps to reproduce
- **General Questions**: Check [User Guide](user-docs/guides/USER_GUIDE.md) or GitHub Discussions

---

**Last Updated**: November 2025
**Documentation Version**: 2.0 (Reorganized)
