# -*- coding: utf-8 -*-
"""\
* *[Summary]* :: A /library/ Beginning point for development of new ICM oriented libraries.
"""

import typing

icmInfo: typing.Dict[str, typing.Any] = { 'moduleDescription': ["""
*       [[elisp:(org-show-subtree)][|=]]  [[elisp:(org-cycle)][| *Description:* | ]]
**  [[elisp:(org-cycle)][| ]]  [Xref]          :: *[Related/Xrefs:]*  <<Xref-Here->>  -- External Documents  [[elisp:(org-cycle)][| ]]

**  [[elisp:(org-cycle)][| ]]   Model and Terminology                                      :Overview:
*** concept             -- Desctiption of concept
**      [End-Of-Description]
"""], }

icmInfo['moduleUsage'] = """
*       [[elisp:(org-show-subtree)][|=]]  [[elisp:(org-cycle)][| *Usage:* | ]]

**      How-Tos:
**      [End-Of-Usage]
"""

icmInfo['moduleStatus'] = """
*       [[elisp:(org-show-subtree)][|=]]  [[elisp:(org-cycle)][| *Status:* | ]]
**  [[elisp:(org-cycle)][| ]]  [Info]          :: *[Current-Info:]* Status/Maintenance -- General TODO List [[elisp:(org-cycle)][| ]]
** TODO [[elisp:(org-cycle)][| ]]  Current     :: For now it is an ICM. Turn it into ICM-Lib. [[elisp:(org-cycle)][| ]]
**      [End-Of-Status]
"""

"""
*  [[elisp:(org-cycle)][| *ICM-INFO:* |]] :: Author, Copyleft and Version Information
"""
####+BEGIN: bx:icm:py:name :style "fileName"
icmInfo['moduleName'] = "pattern"
####+END:

####+BEGIN: bx:icm:py:version-timestamp :style "date"
icmInfo['version'] = "202110191256"
####+END:

####+BEGIN: bx:icm:py:status :status "Production"
icmInfo['status']  = "Production"
####+END:

icmInfo['credits'] = ""

####+BEGIN: bx:dblock:global:file-insert-cond :cond "./blee.el" :file "/bisos/apps/defaults/update/sw/icm/py/icmInfo-mbNedaGplByStar.py"
icmInfo['authors'] = "[[http://mohsen.1.banan.byname.net][Mohsen Banan]]"
icmInfo['copyright'] = "Copyright 2017, [[http://www.neda.com][Neda Communications, Inc.]]"
icmInfo['licenses'] = "[[https://www.gnu.org/licenses/agpl-3.0.en.html][Affero GPL]]", "Libre-Halaal Services License", "Neda Commercial License"
icmInfo['maintainers'] = "[[http://mohsen.1.banan.byname.net][Mohsen Banan]]"
icmInfo['contacts'] = "[[http://mohsen.1.banan.byname.net/contact]]"
icmInfo['partOf'] = "[[http://www.by-star.net][Libre-Halaal ByStar Digital Ecosystem]]"
####+END:

icmInfo['panel'] = "{}-Panel.org".format(icmInfo['moduleName'])
icmInfo['groupingType'] = "IcmGroupingType-pkged"
icmInfo['cmndParts'] = "IcmCmndParts[common] IcmCmndParts[param]"


####+BEGIN: bx:icm:python:top-of-file :partof "bystar" :copyleft "halaal+minimal"
"""
*  This file:/bisos/git/auth/bxRepos/bisos-pip/basics/py3/bisos/basics/pattern.py :: [[elisp:(org-cycle)][| ]]
 is part of The Libre-Halaal ByStar Digital Ecosystem. http://www.by-star.net
 *CopyLeft*  This Software is a Libre-Halaal Poly-Existential. See http://www.freeprotocols.org
 A Python Interactively Command Module (PyICM).
 Best Developed With COMEEGA-Emacs And Best Used With Blee-ICM-Players.
 *WARNING*: All edits wityhin Dynamic Blocks may be lost.
"""
####+END:

####+BEGIN: bx:icm:python:topControls :partof "bystar" :copyleft "halaal+minimal"
"""
*  [[elisp:(org-cycle)][|/Controls/| ]] :: [[elisp:(org-show-subtree)][|=]]  [[elisp:(show-all)][Show-All]]  [[elisp:(org-shifttab)][Overview]]  [[elisp:(progn (org-shifttab) (org-content))][Content]] | [[file:Panel.org][Panel]] | [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] | [[elisp:(bx:org:run-me)][Run]] | [[elisp:(bx:org:run-me-eml)][RunEml]] | [[elisp:(delete-other-windows)][(1)]] | [[elisp:(progn (save-buffer) (kill-buffer))][S&Q]]  [[elisp:(save-buffer)][Save]]  [[elisp:(kill-buffer)][Quit]] [[elisp:(org-cycle)][| ]]
** /Version Control/ ::  [[elisp:(call-interactively (quote cvs-update))][cvs-update]]  [[elisp:(vc-update)][vc-update]] | [[elisp:(bx:org:agenda:this-file-otherWin)][Agenda-List]]  [[elisp:(bx:org:todo:this-file-otherWin)][ToDo-List]]
"""
####+END:
####+BEGIN: bx:dblock:global:file-insert-cond :cond "./blee.el" :file "/bisos/apps/defaults/software/plusOrg/dblock/inserts/pyWorkBench.org"
"""
*  /Python Workbench/ ::  [[elisp:(org-cycle)][| ]]  [[elisp:(python-check (format "/bisos/venv/py3/bisos3/bin/python -m pyclbr %s" (bx:buf-fname))))][pyclbr]] || [[elisp:(python-check (format "/bisos/venv/py3/bisos3/bin/python -m pydoc ./%s" (bx:buf-fname))))][pydoc]] || [[elisp:(python-check (format "/bisos/pipx/bin/pyflakes %s" (bx:buf-fname)))][pyflakes]] | [[elisp:(python-check (format "/bisos/pipx/bin/pychecker %s" (bx:buf-fname))))][pychecker (executes)]] | [[elisp:(python-check (format "/bisos/pipx/bin/pycodestyle %s" (bx:buf-fname))))][pycodestyle]] | [[elisp:(python-check (format "/bisos/pipx/bin/flake8 %s" (bx:buf-fname))))][flake8]] | [[elisp:(python-check (format "/bisos/pipx/bin/pylint %s" (bx:buf-fname))))][pylint]]  [[elisp:(org-cycle)][| ]]
"""
####+END:

####+BEGIN: bx:icm:python:icmItem :itemType "=Imports=" :itemTitle "*IMPORTS*"
"""
*  _[[elisp:(blee:menu-sel:outline:popupMenu)][±]]_ _[[elisp:(blee:menu-sel:navigation:popupMenu)][Ξ]]_ [[elisp:(bx:orgm:indirectBufOther)][|>]] *[[elisp:(blee:ppmm:org-mode-toggle)][|N]]*  =Imports=  :: *IMPORTS*  [[elisp:(org-cycle)][| ]]
"""
####+END:

#from unisos import ucf
from unisos import icm

#import shlex
import subprocess

from bisos import bpf

"""
*  [[elisp:(org-cycle)][| ]]  /subProc/            :: *SubProcess -- Bash or Command Syncronous invokations* [[elisp:(org-cycle)][| ]]
"""



####+BEGIN: bx:dblock:python:class :className "Op" :superClass "bpf.op.BasicOp" :comment "" :classType "basic"
"""
*  _[[elisp:(blee:menu-sel:outline:popupMenu)][±]]_ _[[elisp:(blee:menu-sel:navigation:popupMenu)][Ξ]]_ [[elisp:(bx:orgm:indirectBufOther)][|>]] *[[elisp:(blee:ppmm:org-mode-toggle)][|N]]*  Class-basic :: /Op/ bpf.op.BasicOp  [[elisp:(org-cycle)][| ]]
"""
class Op(bpf.op.BasicOp):
####+END:
    """
** Basic Operation -- Obsoleted By WOpW.
"""
    def __init__(
            self,
            outcome=None,
            log=0,
            cd="",
            uid=""
    ):
        super().__init__(outcome, log,)
        self.cd=cd
        self.uid=uid

    @icm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
    def bash(
            self,
            cmndStr,
            stdin=None,
    ):
        """
    subprocess.Popen() -- shell=True, runs cmndStr in bash.
** TODO This should be renamed to subProc_bashOutcome and subProc_bashOut should become subProc_bash.

** TODO BISOS Py Framework -- OpedSubProc -- Desired Usages:
if not (resStr := bpf.OpSubProc(outcome=cmndOutcome, log=1).sudoBash(
    fa2ensite {ploneBaseDomain}.conf,
).stdOut):  return(icm.EH_badOutcome(cmndOutcome))

if bpf.OpSubProc(outcome=cmndOutcome, cd=someDirBase, log=1).bash(
    fa2ensite {ploneBaseDomain}.conf,
).isProblematic():  return(icm.EH_badOutcome(cmndOutcome))
        """
        if not self.outcome:
            self.outcome = bpf.op.Outcome()

        if not stdin:
            stdin = ""

        fullCmndStr = cmndStr

        if self.cd:
            fullCmndStr = f"""pushd {self.cd}; {cmndStr}; popd;"""

        if self.uid:
            fullCmndStr = f"""sudo -u {self.uid} -- bash -c '{fullCmndStr}'"""

        self.outcome.stdcmnd = fullCmndStr
        try:
            process = subprocess.Popen(
                fullCmndStr,
                shell=True,
                encoding='utf8',
                executable="/bin/bash",
                stdin=subprocess.PIPE,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
            )
        except OSError:
            self.outcome.error = OSError
        else:
            self.outcome.stdout, self.outcome.stderr = process.communicate(input=format(stdin.encode()))
            process.stdin.close() # type: ignore

        process.wait() # type: ignore

        self.outcome.error = process.returncode # type: ignore

        if self.log == 1:
            print(self.outcome.stdout)

        return self.outcome


    @icm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
    def exec(
            self,
            cmndStr,
            stdin=None,
    ):
        """
    subprocess.Popen() -- shell=True, runs cmndStr in bash.
** TODO This should be renamed to subProc_bashOutcome and subProc_bashOut should become subProc_bash.

** TODO BISOS Py Framework -- OpedSubProc -- Desired Usages:
if not (resStr := bpf.OpSubProc(outcome=cmndOutcome, log=1).sudoBash(
    f"a2ensite {ploneBaseDomain}.conf",
).stdOut):  return(icm.EH_badOutcome(cmndOutcome))

if bpf.OpSubProc(outcome=cmndOutcome, cd=someDirBase, log=1).bash(
    f"a2ensite {ploneBaseDomain}.conf",
).isProblematic():  return(icm.EH_badOutcome(cmndOutcome))
        """
        if not self.outcome:
            self.outcome = bpf.op.Outcome()

        if not stdin:
            stdin = ""

        self.outcome.stdcmnd = cmndStr
        try:
            process = subprocess.Popen(
                cmndStr,
                encoding='utf8',
                stdin=subprocess.PIPE,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
            )
        except OSError as exception:
            self.outcome.error = exception
            print(exception)
        else:
            self.outcome.stdout, self.outcome.stderr = process.communicate(input=format(stdin.encode()))
            process.stdin.close() # type: ignore

        process.wait() # type: ignore

        self.outcome.error = process.returncode # type: ignore

        return self.outcome


####+BEGIN: bx:dblock:python:class :className "WOpW" :superClass "bpf.op.BasicOp" :comment "Basic Subprocess Within Operation Wrapper" :classType "basic"
"""
*  _[[elisp:(blee:menu-sel:outline:popupMenu)][±]]_ _[[elisp:(blee:menu-sel:navigation:popupMenu)][Ξ]]_ [[elisp:(bx:orgm:indirectBufOther)][|>]] *[[elisp:(blee:ppmm:org-mode-toggle)][|N]]*  Class-basic :: /WOpW/ bpf.op.BasicOp  [[elisp:(org-cycle)][| ]]
"""
class WOpW(bpf.op.AbstractWithinOpWrapper):
####+END:
    """
** Basic Subprocess Within Operation Wrapper (bash and exec),  returns an OpOutcome.
"""
    def __init__(
            self,
            invedBy=None,
            log=1,
            cd="",
            uid=""
    ):
        super().__init__(invedBy, log,)
        self.cd=cd
        self.uid=uid

    @icm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
    def bash(
            self,
            cmndStr,
            stdin=None,
    ):
        """
    subprocess.Popen() -- shell=True, runs cmndStr in bash.
** TODO This should be renamed to subProc_bashOutcome and subProc_bashOut should become subProc_bash.

** TODO BISOS Py Framework -- OpedSubProc -- Desired Usages:
if not (resStr := bpf.OpSubProc(outcome=cmndOutcome, log=1).sudoBash(
    fa2ensite {ploneBaseDomain}.conf,
).stdOut):  return(icm.EH_badOutcome(cmndOutcome))

if bpf.OpSubProc(outcome=cmndOutcome, cd=someDirBase, log=1).bash(
    fa2ensite {ploneBaseDomain}.conf,
).isProblematic():  return(icm.EH_badOutcome(cmndOutcome))
        """
        if not self.outcome:
            self.outcome = bpf.op.Outcome()

        if not stdin:
            stdin = ""

        fullCmndStr = cmndStr

        if self.cd:
            fullCmndStr = f"""pushd {self.cd}; {cmndStr}; popd;"""

        if self.uid:
            fullCmndStr = f"""sudo -u {self.uid} -- bash -c '{fullCmndStr}'"""

        self.outcome.stdcmnd = fullCmndStr
        try:
            process = subprocess.Popen(
                fullCmndStr,
                shell=True,
                encoding='utf8',
                executable="/bin/bash",
                stdin=subprocess.PIPE,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
            )
        except OSError:
            self.outcome.error = OSError
        else:
            self.outcome.stdout, self.outcome.stderr = process.communicate(input=format(stdin.encode()))
            process.stdin.close() # type: ignore

        process.wait() # type: ignore

        self.outcome.error = process.returncode # type: ignore

        if self.log == 1:
            print(f"** cmnd= {fullCmndStr}")
            if self.outcome.error:
                print(f"*** exit= {self.outcome.error}")
            if self.outcome.stdout:
                print(f"*** stdout= {self.outcome.stdout}")
            if self.outcome.stderr:
                print(f"*** stderr= {self.outcome.stderr}")

        return self.outcome


    @icm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
    def exec(
            self,
            cmndStr,
            stdin=None,
    ):
        """
    subprocess.Popen() -- shell=True, runs cmndStr in bash.
** TODO This should be renamed to subProc_bashOutcome and subProc_bashOut should become subProc_bash.

** TODO BISOS Py Framework -- OpedSubProc -- Desired Usages:
if not (resStr := bpf.OpSubProc(outcome=cmndOutcome, log=1).sudoBash(
    f"a2ensite {ploneBaseDomain}.conf",
).stdOut):  return(icm.EH_badOutcome(cmndOutcome))

if bpf.OpSubProc(outcome=cmndOutcome, cd=someDirBase, log=1).bash(
    f"a2ensite {ploneBaseDomain}.conf",
).isProblematic():  return(icm.EH_badOutcome(cmndOutcome))
        """
        if not self.outcome:
            self.outcome = bpf.op.Outcome()

        if not stdin:
            stdin = ""

        self.outcome.stdcmnd = cmndStr
        try:
            process = subprocess.Popen(
                cmndStr,
                encoding='utf8',
                stdin=subprocess.PIPE,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
            )
        except OSError as exception:
            self.outcome.error = exception
            print(exception)
        else:
            self.outcome.stdout, self.outcome.stderr = process.communicate(input=format(stdin.encode()))
            process.stdin.close() # type: ignore

        process.wait() # type: ignore

        self.outcome.error = process.returncode # type: ignore

        return self.outcome


#
# NOTYET, we should do sameInstance bpf.instantiate.same(x)
#
opLog = Op(log=1,)

opSilent = Op()



####+BEGIN: bx:icm:python:section :title "End Of Editable Text"
"""
*  [[elisp:(beginning-of-buffer)][Top]] ############## [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(delete-other-windows)][(1)]]    *End Of Editable Text*  [[elisp:(org-cycle)][| ]]  [[elisp:(org-show-subtree)][|=]]
"""
####+END:

####+BEGIN: bx:dblock:global:file-insert-cond :cond "./blee.el" :file "/bisos/apps/defaults/software/plusOrg/dblock/inserts/endOfFileControls.org"
#+STARTUP: showall
####+END:
